/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["./_AggregationHelper","./_Cache","./_ConcatHelper","./_GroupLock","./_Helper","./_MinMaxHelper","./_TreeState","sap/base/Log","sap/ui/base/SyncPromise","sap/ui/model/odata/ODataUtils"],function(e,t,n,i,r,o,s,a,l,d){"use strict";function u(i,o,a,d,u){var c=function(){},h=null,f,g=this;t.call(this,i,o,d,true);this.oAggregation=a;this.sToString=this.getDownloadUrl("");this.aElements=[];this.aElements.$byPredicate={};this.aElements.$count=undefined;this.aElements.$created=0;this.oCountPromise=undefined;if(d.$count){if(a.hierarchyQualifier){this.oCountPromise=new l(function(e){f=e});this.oCountPromise.$resolve=f}else if(a.groupLevels.length){d.$$leaves=true;this.oCountPromise=new l(function(e){h=function(t){e(parseInt(t.UI5__leaves))}})}}this.oFirstLevel=this.createGroupLevelCache(null,u||!!h);this.addKeptElement=this.oFirstLevel.addKeptElement;this.removeKeptElement=this.oFirstLevel.removeKeptElement;this.requestSideEffects=this.oFirstLevel.requestSideEffects;this.oGrandTotalPromise=undefined;if(u){this.oGrandTotalPromise=new l(function(t){n.enhanceCache(g.oFirstLevel,a,[h,function(n){var i;if(a["grandTotal like 1.84"]){e.removeUI5grand__(n)}e.setAnnotations(n,true,true,0,e.getAllProperties(a));if(a.grandTotalAtBottomOnly===false){i=Object.assign({},n,{"@$ui5.node.isExpanded":undefined});r.setPrivateAnnotation(n,"copy",i);r.setPrivateAnnotation(i,"predicate","($isTotal=true)")}r.setPrivateAnnotation(n,"predicate","()");t(n)},c])})}else if(h){n.enhanceCache(g.oFirstLevel,a,[h,c])}this.oTreeState=new s(a.$NodeProperty,e=>r.getKeyFilter(e,this.sMetaPath,this.getTypes()));this.bUnifiedCache=this.oAggregation.expandTo>=Number.MAX_SAFE_INTEGER||!!this.oAggregation.createInPlace}u.prototype=Object.create(t.prototype);u.prototype.addTransientCollection=null;u.prototype._delete=function(e,n,i,o,s){let a=parseInt(i);if(isNaN(a)){throw new Error(`Unsupported kept-alive entity: ${this.sResourcePath}${i}`)}const d=this.aElements[a];const u=r.getPrivateAnnotation(d,"predicate");if(d["@$ui5.node.isExpanded"]){throw new Error(`Unsupported expanded node: ${this.sResourcePath}${u}`)}const c=r.getPrivateAnnotation(d,"parent");if(d["@$ui5.context.isTransient"]){return c._delete(e,n,r.getPrivateAnnotation(d,"transientPredicate"))}return l.resolve(this.oRequestor.request("DELETE",n,e,{"If-Match":d})).then(()=>{this.oTreeState.delete(d);a=t.getElementIndex(this.aElements,u,a);const e=c.removeElement(r.getPrivateAnnotation(d,"rank",0),u);const n=r.getPrivateAnnotation(d,"descendants",0);for(let t=0;t<n;t+=1){c.removeElement(e)}const i=n+1;if(c===this.oFirstLevel){this.adjustDescendantCount(d,a,-i)}else if(!c.getValue("$count")){this.makeLeaf(this.aElements[a-1])}this.shiftRank(a,-i);this.removeElement(a,u);s(a,-1)})};u.prototype.addElements=function(t,n,i,o){var s=this.aElements,a=this.oAggregation.hierarchyQualifier,d=this.oAggregation.$NodeProperty,u=this;function c(t,c){var h=s[n+c],f,g=r.getPrivateAnnotation(t,"predicate"),p=r.getPrivateAnnotation(t,"transientPredicate");if(h){if(h===t){return}e.beforeOverwritePlaceholder(h,t,i,o===undefined?undefined:o+c,d)}else if(n+c>=s.length){throw new Error("Array index out of bounds: "+(n+c))}f=s.$byPredicate[g];if(f&&f!==t&&!(f instanceof l)){if(!a||s.includes(f)){const e=i.fixDuplicatePredicate(t,g);if(e){g=e;f=t}else{throw new Error("Duplicate key predicate: "+g)}}if(!f["@odata.etag"]||t["@odata.etag"]===f["@odata.etag"]){r.updateNonExisting(t,f)}else if(u.hasPendingChangesForPath(g)){throw new Error("Modified on client and on server: "+u.sResourcePath+g)}else{r.copySelected(f,t)}}if(g){s.$byPredicate[g]=t}if(p){s.$byPredicate[p]=t}s[n+c]=t;if(i){r.setPrivateAnnotation(t,"parent",i)}if(p){o-=1}else{r.setPrivateAnnotation(t,"rank",o+c)}}if(n<0){throw new Error("Illegal offset: "+n)}if(Array.isArray(t)){t.forEach(c)}else{c(t,0)}};u.prototype.adjustDescendantCount=function(e,t,n){let i=e["@$ui5.node.level"];let o=false;for(let e=t-1;e>=0&&i>1;e-=1){const s=this.aElements[e];const a=s["@$ui5.node.level"];if(a===0){o=true}else if(a<i){if(!o||this.isAncestorOf(e,t)){const i=r.getPrivateAnnotation(s,"descendants",0)+n;r.setPrivateAnnotation(s,"descendants",i);if(i===0){this.makeLeaf(s)}t=e;o=false}i=a}}};u.prototype.beforeRequestSideEffects=function(e){if(!this.oAggregation.hierarchyQualifier){throw new Error("Missing recursive hierarchy")}delete e.$apply;if(!e.$select.includes(this.oAggregation.$NodeProperty)){e.$select.push(this.oAggregation.$NodeProperty)}};u.prototype.beforeUpdateSelected=function(t,n){e.checkNodeProperty(this.aElements.$byPredicate[t],n,this.oAggregation.$NodeProperty,true)};u.prototype.collapse=function(t,n,i,o){const s=this.getValue(t);const a=e.getCollapsedObject(s);r.updateAll(i?{}:this.mChangeListeners,t,s,a);const l=!!n;this.oTreeState.collapse(s,l,o);const d=this.aElements;const u=d.indexOf(s);let c=this.countDescendants(s,u);if(this.oAggregation.subtotalsAtBottomOnly!==undefined&&Object.keys(a).length>1){c+=1}let h=c;for(let e=u+1;e<u+1+h;e+=1){const t=d[e];if(r.hasPrivateAnnotation(t,"placeholder")){continue}if(l&&t["@$ui5.node.isExpanded"]){h-=this.collapse(r.getPrivateAnnotation(t,"predicate"),n,i,true)}if(!this.isSelectionDifferent(t)){delete d.$byPredicate[r.getPrivateAnnotation(t,"predicate")];delete d.$byPredicate[r.getPrivateAnnotation(t,"transientPredicate")]}}const f=d.splice(u+1,h);const g=s["@$ui5.node.level"];if(!l||!this.bUnifiedCache&&g>=this.oAggregation.expandTo){f.$level=g;f.$rank=r.getPrivateAnnotation(s,"rank");r.setPrivateAnnotation(s,"spliced",f)}d.$count-=h;if(l&&!o){this.validateAndDeleteExpandInfo(n,s)}return c};u.prototype.countDescendants=function(e,t){var n;const i=e["@$ui5.node.level"];const o=this.bUnifiedCache?Infinity:this.oAggregation.expandTo;let s=r.getPrivateAnnotation(e,"descendants");for(n=t+1;n<this.aElements.length;n+=1){const e=this.aElements[n];const t=e["@$ui5.node.level"];const a=t===0&&r.hasPrivateAnnotation(e,"placeholder");if(!a&&t<=i){break}if(t<=o&&r.hasPrivateAnnotation(e,"rank")){if(!s){break}s-=1;if(e["@$ui5.node.isExpanded"]===false){s-=r.getPrivateAnnotation(e,"descendants",0)}}}return n-(t+1)};u.prototype.create=function(e,t,n,i,o,s,a,l){if(s){throw new Error("Unsupported bAtEndOfCreated")}const d=o["@$ui5.node.parent"];delete o["@$ui5.node.parent"];const u=d?.slice(d.indexOf("("));const c=this.aElements;const h=c.$byPredicate[u];if(h?.["@$ui5.node.isExpanded"]===false){throw new Error("Unsupported collapsed parent: "+d)}const f=h?h["@$ui5.node.level"]+1:1;let g=f>this.oAggregation.expandTo&&!this.oAggregation.createInPlace?r.getPrivateAnnotation(h,"cache"):this.oFirstLevel;if(!g){g=this.createGroupLevelCache(h);g.setEmpty();r.setPrivateAnnotation(h,"cache",g)}r.addByPath(this.mPostRequests,i,o);const p=c.indexOf(h)+1;const P=g.create(e,t,n,i,o,s,a,l,()=>{r.removeByPath(this.mPostRequests,i,o);if(this.oAggregation.createInPlace){return}c.$count-=1;delete c.$byPredicate[i];c.splice(p,1)});if(d){r.getPrivateAnnotation(o,"postBody")[this.oAggregation.$ParentNavigationProperty+"@odata.bind"]=r.makeRelativeUrl("/"+d,"/"+this.sResourcePath)}const v=h&&h["@$ui5.node.isExpanded"]===undefined;const m=v&&h?.["@$ui5.node.level"]>=this.oAggregation.expandTo;if(m){this.oTreeState.expand(h)}const $=(e,t)=>{if(v){r.updateAll(this.mChangeListeners,u,h,{"@$ui5.node.isExpanded":true})}o["@$ui5.node.level"]=f;c.splice(e,0,null);this.addElements(o,e,g,t);c.$count+=1};const y=(e,t)=>{g.removeElement(0);r.deletePrivateAnnotation(o,"transientPredicate");delete c.$byPredicate[i];if(t!==undefined){this.adjustDescendantCount(o,e,+1);g.restoreElement(t,o);r.setPrivateAnnotation(o,"rank",t);this.shiftRank(e,+1)}};if(this.oAggregation.createInPlace){return P.then(async()=>{r.removeByPath(this.mPostRequests,i,o);delete o["@$ui5.context.isTransient"];const[t]=await Promise.all([this.requestRank(o,e),this.requestNodeProperty(o,e)]);if(m){r.setPrivateAnnotation(o,"rank",t)}else if(t===undefined){g.removeElement(0)}else{$(t,t);y(t,t)}return o})}$(p,undefined);return P.then(async()=>{r.removeByPath(this.mPostRequests,i,o);c.$byPredicate[r.getPrivateAnnotation(o,"predicate")]=o;o["@$ui5.node.level"]=f;this.oTreeState.setOutOfPlace(o,h);if(g===this.oFirstLevel&&this.oAggregation.expandTo>1){const[t]=await Promise.all([this.requestRank(o,e),this.requestNodeProperty(o,e,true)]);y(p,t)}else{await this.requestNodeProperty(o,e,true)}return o})};u.prototype.createGroupLevelCache=function(n,i){var o=this.oAggregation,s=n?n["@$ui5.node.level"]+1:1,a,l,d,c,h,f,g;if(o.hierarchyQualifier){f=Object.assign({},this.mQueryOptions)}else{a=e.getAllProperties(o);c=s>o.groupLevels.length;d=c?o.groupLevels.concat(Object.keys(o.group).sort()):o.groupLevels.slice(0,s);f=e.filterOrderby(this.mQueryOptions,o,s);g=!c&&Object.keys(o.aggregate).some(function(e){return o.aggregate[e].subtotals})}if(n){h=r.getPrivateAnnotation(n,"filter")||r.getKeyFilter(n,this.sMetaPath,this.getTypes());f.$$filterBeforeAggregate=h+(f.$$filterBeforeAggregate?" and ("+f.$$filterBeforeAggregate+")":"")}if(!i){delete f.$count;f=e.buildApply(o,f,s)}f.$count=true;l=t.create(this.oRequestor,this.sResourcePath,f,true);l.calculateKeyPredicate=o.hierarchyQualifier?u.calculateKeyPredicateRH.bind(null,n,o):u.calculateKeyPredicate.bind(null,n,d,a,c,g);if(h){l.$parentFilter=h}if(!o.hierarchyQualifier){l.fixDuplicatePredicate=u.fixDuplicatePredicate.bind(l)}return l};u.prototype.expand=function(t,n,o,s){var a,d=typeof n==="string"?this.getValue(n):n,u=r.getPrivateAnnotation(d,"spliced"),c=this;if(n!==d){r.updateAll(this.mChangeListeners,n,d,e.getOrCreateExpandedObject(this.oAggregation,d));this.oTreeState.expand(d,o)}if(o>=Number.MAX_SAFE_INTEGER){return l.resolve(this.validateAndDeleteExpandInfo(t,d)).then(()=>-1)}if(u){r.deletePrivateAnnotation(d,"spliced");const e=this.aElements;const t=e.indexOf(d)+1;this.aElements=e.concat(u,e.splice(t));this.aElements.$byPredicate=e.$byPredicate;a=u.length;this.aElements.$count=e.$count+a;r.copySelected(e,this.aElements);const n=d["@$ui5.node.level"]-u.$level;const o=r.getPrivateAnnotation(d,"rank")-u.$rank;u.forEach(function(e){var t=r.getPrivateAnnotation(e,"predicate");if(e["@$ui5.node.level"]){e["@$ui5.node.level"]+=n}if(r.getPrivateAnnotation(e,"parent")===c.oFirstLevel){const t=r.getPrivateAnnotation(e,"rank");if(t!==undefined){r.setPrivateAnnotation(e,"rank",t+o)}}if(!r.hasPrivateAnnotation(e,"placeholder")){if(u.$stale&&!c.isSelectionDifferent(e)){c.turnIntoPlaceholder(e,t)}else{c.aElements.$byPredicate[t]=e;const n=r.getPrivateAnnotation(e,"transientPredicate");if(n){c.aElements.$byPredicate[n]=e}if(r.hasPrivateAnnotation(e,"expanding")){r.deletePrivateAnnotation(e,"expanding");a+=c.expand(i.$cached,e).getResult()}}}});return l.resolve(a)}if(this.bUnifiedCache||o>1||d["@$ui5.node.level"]<this.oAggregation.expandTo){return l.resolve(-1)}let h=r.getPrivateAnnotation(d,"cache");if(!h){h=this.createGroupLevelCache(d);r.setPrivateAnnotation(d,"cache",h)}return h.read(0,this.iReadLength,0,t,s).then(function(t){var i=c.aElements.indexOf(d)+1,o=d["@$ui5.node.level"],s=e.getCollapsedObject(d),l=c.oAggregation.subtotalsAtBottomOnly!==undefined&&Object.keys(s).length>1,u;if(!d["@$ui5.node.isExpanded"]){r.deletePrivateAnnotation(d,"spliced");return 0}if(!i){r.setPrivateAnnotation(d,"expanding",true);return 0}a=t.value.$count;if(r.hasPrivateAnnotation(d,"groupLevelCount")&&r.getPrivateAnnotation(d,"groupLevelCount")!==a){throw new Error("Unexpected structural change: groupLevelCount")}r.setPrivateAnnotation(d,"groupLevelCount",a);r.updateAll(c.mChangeListeners,n,d,{"@$ui5.node.groupLevelCount":a});if(l){a+=1}if(i===c.aElements.length){c.aElements.length+=a}else{for(u=c.aElements.length-1;u>=i;u-=1){c.aElements[u+a]=c.aElements[u];delete c.aElements[u]}}c.addElements(t.value,i,h,0);for(u=i+t.value.length;u<i+t.value.$count;u+=1){c.aElements[u]=e.createPlaceholder(o+1,u-i,h)}if(l){s=Object.assign({},s);e.setAnnotations(s,undefined,true,o,e.getAllProperties(c.oAggregation));r.setPrivateAnnotation(s,"predicate",r.getPrivateAnnotation(d,"predicate").slice(0,-1)+",$isTotal=true)");c.addElements(s,i+a-1)}c.aElements.$count+=a;return a},function(t){r.updateAll(c.mChangeListeners,n,d,e.getCollapsedObject(d));c.oTreeState.collapse(d);throw t})};u.prototype.fetchParentIndex=function(e,t){const n=this.aElements[e]["@$ui5.node.level"];for(let t=e-1;t>=0;t-=1){const i=this.aElements[t]["@$ui5.node.level"];if(i===0){break}if(i===n){e=t}}const i=this.aElements[e];let o=r.getPrivateAnnotation(i,"parentIndexPromise");if(o){return o}const s=r.getKeyFilter(i,this.sMetaPath,this.getTypes());const a=Object.assign({},this.mQueryOptions);a.$apply="ancestors($root"+this.oAggregation.$path+","+this.oAggregation.hierarchyQualifier+","+this.oAggregation.$NodeProperty+",filter("+s+"),1)";const d=this.sResourcePath+this.oRequestor.buildQueryString(null,a);o=this.oRequestor.request("GET",d,t).then(async e=>{const n=e.value[0];const i=this.aElements.$byPredicate[r.getKeyPredicate(n,this.sMetaPath,this.getTypes())];if(i&&r.getPrivateAnnotation(i,"rank")!==undefined){return this.aElements.indexOf(i)}r.setPrivateAnnotation(n,"parent",this.oFirstLevel);const o=[this.oAggregation.$DistanceFromRoot,this.oAggregation.$DrillState,this.oAggregation.$LimitedDescendantCount];const[s]=await Promise.all([this.requestRank(n,t),this.requestProperties(n,o,t,true),this.requestNodeProperty(n,t,false)]);this.oFirstLevel.calculateKeyPredicate(n,this.getTypes(),this.sMetaPath);const a=this.findIndex(s);if(r.hasPrivateAnnotation(this.aElements[a],"placeholder")){this.insertNode(n,s,a)}return a}).finally(()=>{r.deletePrivateAnnotation(i,"parentIndexPromise")});o=l.resolve(o);r.setPrivateAnnotation(i,"parentIndexPromise",o);return o};u.prototype.fetchValue=function(e,t,n,i){var r=this;if(t==="$count"){if(this.oCountPromise){return this.oCountPromise}if(this.oAggregation.hierarchyQualifier||this.oAggregation.groupLevels.length){a.error("Failed to drill-down into $count, invalid segment: $count",this.toString(),"sap.ui.model.odata.v4.lib._Cache");return l.resolve()}return this.oFirstLevel.fetchValue(e,t,n,i)}return l.resolve(this.aElements.$byPredicate[t.split("/")[0]]).then(function(){r.registerChangeListener(t,i);return r.drillDown(r.aElements,t,e)})};u.prototype.findIndex=function(e,t=this.oFirstLevel){return this.aElements.findIndex(n=>r.getPrivateAnnotation(n,"rank")===e&&r.getPrivateAnnotation(n,"parent")===t)};u.prototype.get1stInPlaceChildIndex=function(e){let t=e+1;while(this.aElements[t]?.["@$ui5.context.isTransient"]!==undefined){t+=1}const n=this.aElements[t];if(!n){return[-1]}const i=n["@$ui5.node.level"];const o=e>=0?this.aElements[e]["@$ui5.node.level"]+1:1;const s=r.hasPrivateAnnotation(n,"placeholder");return i===o||i===0?[t,s,o]:[-1]};u.prototype.getCreatedElements=function(e){return[]};u.prototype.getDownloadQueryOptions=function(t){if(this.oAggregation.hierarchyQualifier){if("$count"in t){t=Object.assign({},t);delete t.$count}}else{t=e.filterOrderby(t,this.oAggregation)}return e.buildApply(this.oAggregation,t,0,true)};u.prototype.getElements=function(e,t,n){if(e){throw new Error("Unsupported path: "+e)}const i=this.aElements.slice(t,n).map(e=>r.hasPrivateAnnotation(e,"placeholder")?undefined:e);i.$count=this.aElements.$count;return i};u.prototype.getInsertIndex=function(e){var t;for(t=0;t<this.aElements.length;t+=1){const n=this.aElements[t];if(r.getPrivateAnnotation(n,"rank")>e&&!this.oTreeState.isOutOfPlace(r.getPrivateAnnotation(n,"predicate"))){return t}}return t};u.prototype.getParentIndex=function(e){const t=this.aElements[e]["@$ui5.node.level"];if(t<=1){return-1}let n=false;for(let i=e;i>=0;i-=1){const r=this.aElements[i];const o=r["@$ui5.node.level"];if(o===0){n=true}else if(o<t){if(o===t-1&&(!n||this.isAncestorOf(i,e))){return i}break}}};u.prototype.getSiblingIndex=function(t,n,i){const o=this.aElements[t];const s=r.getPrivateAnnotation(o,"parent");const a=s!==this.oFirstLevel||this.oAggregation.expandTo===1&&!this.oAggregation.$ExpandLevels;const l=r.getPrivateAnnotation(o,"rank");let d=l+n;if(n<0){if(!a){d=e.findPreviousSiblingIndex(s.aElements,l)}if(d<0){return-1}}else{d+=r.getPrivateAnnotation(o,"descendants",0);if(d>=s.aElements.$count||s.aElements[d]?.["@$ui5.node.level"]<o["@$ui5.node.level"]){return-1}}if(d>=0){const e=this.findIndex(d,s);if(e<0){return-1}const t=this.aElements[e];if(a&&i||!r.hasPrivateAnnotation(t,"placeholder")){if(t["@$ui5.context.isTransient"]!==undefined){return this.getSiblingIndex(e,n,i)}return e}}};u.prototype.getValue=function(e){var t;t=this.fetchValue(i.$cached,e);if(t.isFulfilled()){return t.getResult()}t.caught()};u.prototype.handleOutOfPlaceNodes=function([e,...t]){if(!e){return}const n=e=>r.getKeyPredicate(e,this.sMetaPath,this.getTypes());const i=e=>parseInt(r.drillDown(e,this.oAggregation.$LimitedRank));const o={};e.value.forEach(e=>{o[n(e)]=e});const s=new Set(this.oTreeState.getOutOfPlacePredicates());t.forEach(e=>{e.value.forEach(e=>{const t=n(e);s.delete(t);if(this.aElements.$byPredicate[t]){return}const a=this.oTreeState.getOutOfPlace(t).parentPredicate;const l=o[a];if(l){const e=r.drillDown(l,this.oAggregation.$DrillState);if(e==="collapsed"){return}}else if(a){return}r.merge(e,o[t]);this.oFirstLevel.calculateKeyPredicate(e,this.getTypes(),this.sMetaPath);const d=i(e);r.deleteProperty(e,this.oAggregation.$LimitedRank);this.insertNode(e,d)})});s.forEach(e=>this.oTreeState.deleteOutOfPlace(e));this.oTreeState.getOutOfPlaceGroupedByParent().forEach(e=>{const t=o[e.parentPredicate];this.moveOutOfPlaceNodes(t&&i(t),e.nodePredicates)})};u.prototype.insertNode=function(e,t,n=t){this.addElements(e,n,this.oFirstLevel,t);this.oFirstLevel.removeElement(t);this.oFirstLevel.restoreElement(t,e)};u.prototype.isAncestorOf=function(e,t){if(t===e){return true}if(t<e||!this.aElements[e]["@$ui5.node.isExpanded"]||this.aElements[e]["@$ui5.node.level"]>=this.aElements[t]["@$ui5.node.level"]){return false}return t<=e+this.countDescendants(this.aElements[e],e)};u.prototype.isDeletingInOtherGroup=function(e){return false};u.prototype.isRefreshNeededAfterCreate=function(e){const t=this.aElements[e];return this.oAggregation.createInPlace&&t["@$ui5.node.isExpanded"]===undefined&&t["@$ui5.node.level"]>=this.oAggregation.expandTo};u.prototype.isSelectionDifferent=function(e){return this.oAggregation.hierarchyQualifier&&(e["@$ui5.context.isSelected"]??false)!==(this.aElements["@$ui5.context.isSelected"]??false)};u.prototype.keepOnlyGivenElements=function(t){var n={},i=this;t.forEach(function(e){n[e]=true});return Object.values(this.aElements.$byPredicate).filter(function(t){var o=r.getPrivateAnnotation(t,"predicate");if(!o){return}if(n[o]){e.markSplicedStale(t);n[o]=false;return true}if(!(o in n)){i.turnIntoPlaceholder(t,o)}})};u.prototype.makeLeaf=function(e){r.updateAll(this.mChangeListeners,r.getPrivateAnnotation(e,"predicate"),e,{"@$ui5.node.isExpanded":undefined});delete e["@$ui5.node.isExpanded"];r.deletePrivateAnnotation(e,"descendants")};u.prototype.move=function(e,t,n,o,s,a,d){let u=!this.bUnifiedCache;const c=t.slice(t.indexOf("("));const h=this.aElements.$byPredicate[c];if(!d&&this.oTreeState.isOutOfPlace(c)){this.oTreeState.deleteOutOfPlace(c);delete h["@$ui5.context.isTransient"];u=true}const f=n?.slice(n.indexOf("("));const g=this.aElements.$byPredicate[f];if(this.oTreeState.isOutOfPlace(f)){this.oTreeState.deleteOutOfPlace(f,true);u=true}if(g?.["@$ui5.node.isExpanded"]===false||g?.["@$ui5.node.level"]>=this.oAggregation.expandTo&&!g["@$ui5.node.isExpanded"]){this.oTreeState.expand(g);if(!r.hasPrivateAnnotation(g,"spliced")){u=true}}let p;const P=()=>{if(o!==undefined){u=true;const t=s+"/"+this.oAggregation.$Actions.ChangeNextSiblingAction;const n=o?.slice(o.indexOf("("));p=this.aElements.$byPredicate[n];let i=null;if(p){this.oTreeState.deleteOutOfPlace(n);const e=this.oAggregation.$fetchMetadata(r.getMetaPath("/"+t+"/NextSibling/")).getResult();const o=Object.keys(e).filter(e=>e[0]!=="$");i=o.reduce((e,t)=>{e[t]=p[t];return e},{})}return this.oRequestor.request("POST",t,e.getUnlockedCopy(),{"If-Match":h,Prefer:"return=minimal"},{NextSibling:i})}};let v;if(d){u=true;const n={$select:[]};r.selectKeyProperties(n,this.getTypes()[this.sMetaPath]);const i=t+"/"+this.oAggregation.$Actions.CopyAction+this.oRequestor.buildQueryString(this.sMetaPath,n,false,true);v=this.oRequestor.request("POST",i,e.getUnlockedCopy(),{"If-Match":h},{});t="$-1"}let m=l.all([this.oRequestor.request("PATCH",t,e,{"If-Match":h,Prefer:"return=minimal"},{[this.oAggregation.$ParentNavigationProperty+"@odata.bind"]:n},null,function e(){}),P(),this.requestRank(h,e,u),a&&this.requestRank(p,e,true),v]);if(u){m=m.then(([,,t,n,i])=>()=>{let r;if(d){r=this.requestRank(i,e,true).then(e=>this.findIndex(e))}return[t===undefined?undefined:this.findIndex(t),a&&this.findIndex(n),r]})}else{m=m.then(([e,,t])=>{const n=h["@$ui5.node.isExpanded"]?this.collapse(c):undefined;let o=1;switch(g?g["@$ui5.node.isExpanded"]:true){case false:o=this.expand(i.$cached,f).unwrap()+1;case true:break;default:r.updateAll(this.mChangeListeners,f,g,{"@$ui5.node.isExpanded":true})}const s=this.aElements.indexOf(h);const a=r.getPrivateAnnotation(h,"descendants",0)+1;this.adjustDescendantCount(h,s,-a);this.aElements.splice(s,1);const l=r.getPrivateAnnotation(h,"rank");this.shiftRankForMove(l,a,t);this.oFirstLevel.move(l,t,a);r.updateExisting(this.mChangeListeners,c,h,{"@odata.etag":e["@odata.etag"],"@$ui5.context.isTransient":undefined,"@$ui5.node.level":g?g["@$ui5.node.level"]+1:1});r.deletePrivateAnnotation(h,"rank");const d=this.getInsertIndex(t);this.aElements.splice(d,0,h);this.adjustDescendantCount(h,d,+a);r.setPrivateAnnotation(h,"rank",t);return[o,d,n]})}return{promise:m,refresh:u}};u.prototype.moveOutOfPlaceNodes=function(e,t){const n=e===undefined?-1:this.findIndex(e);t.forEach(e=>{const t=this.aElements.$byPredicate[e];if(t){this.oTreeState.stillOutOfPlace(t,e);const r=t["@$ui5.node.isExpanded"];if(r){this.collapse(e)}const o=this.aElements.indexOf(t);this.aElements.splice(o,1);this.aElements.splice(n+1,0,t);if(r){this.expand(i.$cached,e)}}})};u.prototype.read=function(e,t,n,i,o){var s,a=e,u=t,c,h,f=this.oGrandTotalPromise&&this.oAggregation.grandTotalAtBottomOnly!==true,g=[],p,P=this;function v(e,t){g.push(P.readGap(c,e,t,i.getUnlockedCopy(),o))}if(f&&!e&&t===1){if(n!==0){throw new Error("Unsupported prefetch length: "+n)}i.unlock();return this.oGrandTotalPromise.then(function(e){return{value:[e]}})}if(this.aElements.$count===undefined){this.iReadLength=t+n;if(f){if(a){a-=1}else{u-=1}}g.push(this.readCount(i),this.readFirst(a,u,n,i,o))}else{const o=d._getReadRange(this.aElements,e,t,n,e=>{switch(r.getPrivateAnnotation(e,"placeholder")){case true:return r.getPrivateAnnotation(e,"parent").isMissing(r.getPrivateAnnotation(e,"rank"));case 1:return!(this.aElements.$byPredicate[r.getPrivateAnnotation(e,"predicate")]instanceof l);default:return false}});const a=Math.min(o.start+o.length,this.aElements.length);for(p=o.start;p<a;p+=1){const e=this.aElements[p];s=r.hasPrivateAnnotation(e,"placeholder")?r.getPrivateAnnotation(e,"parent"):undefined;if(s!==c){if(h!==undefined){v(h,p);c=h=undefined}if(s){h=p;c=s}}else if(h!==undefined&&r.getPrivateAnnotation(e,"rank")!==r.getPrivateAnnotation(this.aElements[p-1],"rank")+1){v(h,p);h=p}}if(h!==undefined){v(h,p)}i.unlock()}return l.all(g).then(function(){var n=P.aElements.slice(e,e+t).map(function(e){return r.hasPrivateAnnotation(e,"placeholder")?undefined:e});n.$count=P.aElements.$count;return{value:n}})};u.prototype.readCount=function(e){var t,n=this.oCountPromise&&this.oCountPromise.$resolve,i;if(n){delete this.oCountPromise.$resolve;t=Object.assign({},this.mQueryOptions);delete t.$apply;delete t.$count;delete t.$expand;delete t.$orderby;if(this.oAggregation.search){t.$search=this.oAggregation.search}delete t.$select;i=this.sResourcePath+"/$count"+this.oRequestor.buildQueryString(null,t);return this.oRequestor.request("GET",i,e.getUnlockedCopy()).then(n)}};u.prototype.readFirst=function(t,n,o,s,a){var d=this;n+=o;const u=this.oTreeState.getOutOfPlaceCount();o=Math.max(o,u);if(t>o){n+=o;t-=o}else{n+=t;t=0}const c=this.oFirstLevel.bSentRequest;if(c&&u){s=i.$cached}return l.all([this.oFirstLevel.read(t,n,0,s,a),...c?[]:this.requestOutOfPlaceNodes(s)]).then(function([n,...i]){if(c&&u){return}var o,s,a=0,l;d.aElements.length=d.aElements.$count=n.value.$count;if(d.oGrandTotalPromise){d.aElements.$count+=1;d.aElements.length+=1;o=d.oGrandTotalPromise.getResult();switch(d.oAggregation.grandTotalAtBottomOnly){case false:a=1;d.aElements.$count+=1;d.aElements.length+=1;d.addElements(o,0);s=r.getPrivateAnnotation(o,"copy");d.addElements(s,d.aElements.length-1);break;case true:d.addElements(o,d.aElements.length-1);break;default:a=1;d.addElements(o,0)}}d.addElements(n.value,t+a,d.oFirstLevel,t);for(l=0;l<d.aElements.$count;l+=1){d.aElements[l]??=e.createPlaceholder(d.oAggregation.expandTo>1||d.bUnifiedCache?0:1,l-a,d.oFirstLevel)}d.handleOutOfPlaceNodes(i)})};u.prototype.readGap=function(e,t,n,i,o){const s=this.aElements[t];const a=r.getPrivateAnnotation(s,"rank");if(a===undefined){if(n-t!==1){throw new Error("Not just a single created persisted")}const a=r.getPrivateAnnotation(s,"predicate");const l=e.refreshSingle(i,"",-1,a,true,false,o).then(n=>{r.inheritPathValue(this.oAggregation.$NodeProperty.split("/"),s,n,true);this.addElements(n,t,e)});this.aElements.$byPredicate[a]=l;return l}const l=e.getQueryOptions();if(l.$count){delete l.$count;e.setQueryOptions(l,true)}const d=e.read(a,n-t,0,i,o,true).then(n=>{var i=false,r;if(s!==this.aElements[t]&&n.value[0]!==this.aElements[t]){i=true;t=this.aElements.indexOf(s);if(t<0){t=this.aElements.indexOf(n.value[0]);if(t<0){r=new Error("Collapse before read has finished");r.canceled=true;throw r}}}this.addElements(n.value,t,e,a);if(i){r=new Error("Collapse or expand before read has finished");r.canceled=true;throw r}});if(d.isPending()){for(let e=t;e<n;e+=1){const t=r.getPrivateAnnotation(this.aElements[e],"predicate");if(t){this.aElements.$byPredicate[t]=d}}}return d};u.prototype.refreshKeptElements=function(e,t,n,i){const r=this.oFirstLevel.refreshKeptElements;return r.call(this,e,t,n,true)};u.prototype.requestFilteredOrderedPredicates=async function(t,n,i){if(!i){throw new Error("Not implemented")}let o={...this.mQueryOptions};delete o.$count;delete o.$expand;delete o.$orderby;o=e.buildApply4Hierarchy(this.oAggregation,o,true);o.$select=[];const s=this.getTypes();r.selectKeyProperties(o,s[this.sMetaPath]);const a=t.map(e=>r.getKeyFilter(this.aElements.$byPredicate[e],this.sMetaPath,s));o.$top=a.length;o.$filter=a.join(" or ");const l=this.sResourcePath+this.oRequestor.buildQueryString(this.sMetaPath,o,false,true,true);const d=await this.oRequestor.request("GET",l,n);return d.value.map(e=>{this.calculateKeyPredicate(e,s,this.sMetaPath);return r.getPrivateAnnotation(e,"predicate")})};u.prototype.requestNodeProperty=async function(e,t,n){if(r.drillDown(e,this.oAggregation.$NodeProperty)!==undefined){return}await this.requestProperties(e,[this.oAggregation.$NodeProperty],t,true,n)};u.prototype.requestOutOfPlaceNodes=function(t){const n=this.oTreeState.getOutOfPlaceGroupedByParent();if(!n.length){return[]}const i=[];const r=e=>{const n=this.sResourcePath+this.oRequestor.buildQueryString(this.sMetaPath,e,false,true);i.push(this.oRequestor.request("GET",n,t.getUnlockedCopy()))};let o=e.getQueryOptionsForOutOfPlaceNodesRank(n,this.oAggregation,this.oFirstLevel.getQueryOptions());r(o);n.forEach(t=>{o=e.getQueryOptionsForOutOfPlaceNodesData(t,this.oAggregation,this.mQueryOptions);r(o)});return i};u.prototype.requestProperties=async function(t,n,i,o,s,a){function l(e){e={...e};delete e.$count;delete e.$expand;delete e.$select;return e}let d;if(a){const t={...this.oAggregation,$ExpandLevels:this.oTreeState.getExpandLevels()};d=l(e.buildApply4Hierarchy(t,this.mQueryOptions))}else{const n=r.getPrivateAnnotation(t,"parent",this.oFirstLevel);d=s?e.dropFilter(this.oAggregation,this.mQueryOptions,n.$parentFilter):l(n.getQueryOptions())}d.$filter=r.getKeyFilter(t,this.sMetaPath,this.getTypes());const u=this.sResourcePath+this.oRequestor.buildQueryString(this.sMetaPath,d,false,true);const c=await this.oRequestor.request("GET",u,i.getUnlockedCopy(),undefined,undefined,undefined,undefined,this.sMetaPath,undefined,false,{$select:n},this);const h=c.value[0];if(o&&h){n.forEach(e=>{r.inheritPathValue(e.split("/"),h,t,true)})}else{return h}};u.prototype.requestRank=async function(e,t,n){const i=await this.requestProperties(e,[this.oAggregation.$LimitedRank],t,false,false,n);return i&&parseInt(r.drillDown(i,this.oAggregation.$LimitedRank))};u.prototype.requestSiblingIndex=async function(e,t,n){const i=this.getSiblingIndex(e,t,true);if(i!==undefined){return i}const o=this.aElements[e];const s={...this.oFirstLevel.mQueryOptions,$filter:this.oAggregation.$LimitedRank+(t<0?" lt ":" gt ")+r.getPrivateAnnotation(o,"rank")+" and "+this.oAggregation.$DistanceFromRoot+" lt "+o["@$ui5.node.level"],$top:1};if(t<0){s.$orderby=this.oAggregation.$LimitedRank+" desc"}s.$select=[...s.$select,this.oAggregation.$LimitedRank];delete s.$count;const a=this.sResourcePath+this.oRequestor.buildQueryString("",s,false,true,true);const l=await this.oRequestor.request("GET",a,n);const d=l.value[0];this.oFirstLevel.calculateKeyPredicate(d,this.getTypes(),this.sMetaPath);const u=parseInt(r.drillDown(d,this.oAggregation.$LimitedRank));r.deleteProperty(d,this.oAggregation.$LimitedRank);if(r.hasPrivateAnnotation(this.aElements[u],"placeholder")){this.insertNode(d,u)}return d["@$ui5.node.level"]===o["@$ui5.node.level"]?u:-1};u.prototype.reset=function(e,t,n,i,o){var s,a=this;if(o){throw new Error("Unsupported grouping via sorter")}e.forEach(function(e){var t=a.aElements.$byPredicate[e];if(r.hasPrivateAnnotation(t,"placeholder")){throw new Error("Unexpected placeholder")}delete t["@$ui5.node.isExpanded"];delete t["@$ui5.node.level"];delete t["@$ui5._"];r.setPrivateAnnotation(t,"predicate",e)});this.oAggregation=i;const d=this.oFirstLevel.reset;d.call(this,e,t,n);this.sToString=this.getDownloadUrl("");if(t){this.oBackup.oCountPromise=this.oCountPromise;this.oBackup.oFirstLevel=this.oFirstLevel;this.oBackup.bUnifiedCache=this.bUnifiedCache;this.bUnifiedCache=true}else{this.oTreeState.reset()}this.oAggregation.$ExpandLevels=this.oTreeState.getExpandLevels();this.oCountPromise=undefined;if(n.$count){this.oCountPromise=new l(function(e){s=e});this.oCountPromise.$resolve=s}this.oFirstLevel=this.createGroupLevelCache()};u.prototype.resetOutOfPlace=function(){this.oTreeState.resetOutOfPlace()};u.prototype.restore=function(e){if(e){this.oCountPromise=this.oBackup.oCountPromise;this.oFirstLevel=this.oBackup.oFirstLevel;this.bUnifiedCache=this.oBackup.bUnifiedCache}const t=this.oFirstLevel.restore;t.call(this,e)};u.prototype.shiftRank=function(e,t){const n=this.aElements[e];const i=r.getPrivateAnnotation(n,"rank");if(i===undefined){return}const o=r.getPrivateAnnotation(n,"parent");if(o===this.oFirstLevel){e=-1}for(let s=e+1;s<this.aElements.length;s+=1){const e=this.aElements[s];if(e===n){continue}if(r.getPrivateAnnotation(e,"parent")===o){const n=r.getPrivateAnnotation(e,"rank");if(n>=i){r.setPrivateAnnotation(e,"rank",n+t)}}if(o!==this.oFirstLevel&&e["@$ui5.node.level"]<n["@$ui5.node.level"]){break}}};u.prototype.shiftRankForMove=function(e,t,n){if(e<n){this.aElements.forEach(i=>{const o=r.getPrivateAnnotation(i,"rank");if(e+t<=o&&o<n+t){r.setPrivateAnnotation(i,"rank",o-t)}})}else if(n<e){this.aElements.forEach(i=>{const o=r.getPrivateAnnotation(i,"rank");if(n<=o&&o<e){r.setPrivateAnnotation(i,"rank",o+t)}})}};u.prototype.toString=function(){return this.sToString};u.prototype.turnIntoPlaceholder=function(t,n){if(r.hasPrivateAnnotation(t,"placeholder")){return}r.setPrivateAnnotation(t,"placeholder",1);e.markSplicedStale(t);delete this.aElements.$byPredicate[n];const i=r.getPrivateAnnotation(t,"rank");if(i!==undefined){r.getPrivateAnnotation(t,"parent").drop(i,n,true)}};u.prototype.validateAndDeleteExpandInfo=async function(t,n){const i=this.oTreeState.getExpandFilters(e=>{const t=this.aElements.$byPredicate[e];return!this.aElements.includes(t)});if(!i.length){return}const o=this.getTypes();let s={...this.mQueryOptions};s.$$filterBeforeAggregate=r.getKeyFilter(n,this.sMetaPath,o);delete s.$count;delete s.$expand;delete s.$orderby;s=e.buildApply4Hierarchy(this.oAggregation,s,true);s.$filter=i.sort().join(" or ");s.$select=[];r.selectKeyProperties(s,o[this.sMetaPath]);s.$top=i.length;const a=this.sResourcePath+this.oRequestor.buildQueryString(this.sMetaPath,s,false,true,true);const l=await this.oRequestor.request("GET",a,this.oRequestor.getUnlockedAutoCopy(t));l.value.forEach(e=>{this.calculateKeyPredicate(e,o,this.sMetaPath);this.oTreeState.deleteExpandInfo(e)})};u.calculateKeyPredicate=function(t,n,i,o,s,a,l,d){var u;if(!(d in l)){return undefined}if(t){i.forEach(function(e){if(Array.isArray(e)){r.inheritPathValue(e,t,a)}else if(!(e in a)){if(t[e+"@$ui5.noData"]){a[e+"@$ui5.noData"]=true}a[e]=t[e]}})}u=o&&r.getKeyPredicate(a,d,l)||r.getKeyPredicate(a,d,l,n,true);r.setPrivateAnnotation(a,"predicate",u);if(!o){r.setPrivateAnnotation(a,"filter",r.getKeyFilter(a,d,l,n))}e.setAnnotations(a,o?undefined:false,s,t?t["@$ui5.node.level"]+1:1,t?null:i);return u};u.calculateKeyPredicateRH=function(t,n,i,o,s){var a,l,d=1,u,c;if(!(s in o)){return undefined}c=r.getKeyPredicate(i,s,o);r.setPrivateAnnotation(i,"predicate",c);if(s!==n.$metaPath){return c}switch(r.drillDown(i,n.$DrillState)){case"expanded":l=true;break;case"collapsed":l=false;break;default:}r.deleteProperty(i,n.$DrillState);if(t){d=t["@$ui5.node.level"]+1}else{a=r.drillDown(i,n.$DistanceFromRoot);if(a){r.deleteProperty(i,n.$DistanceFromRoot);d=parseInt(a)+1}}e.setAnnotations(i,l,undefined,d);if(n.$LimitedDescendantCount){u=r.drillDown(i,n.$LimitedDescendantCount);if(u){r.deleteProperty(i,n.$LimitedDescendantCount);if(u!=="0"){r.setPrivateAnnotation(i,"descendants",parseInt(u))}}}return c};u.create=function(n,i,r,s,a,l,d,c){var h,f;function g(){if("$expand"in s){throw new Error("Unsupported system query option: $expand")}if("$select"in s){throw new Error("Unsupported system query option: $select")}}if(a){h=e.hasGrandTotal(a.aggregate);f=a.groupLevels&&!!a.groupLevels.length;if(e.hasMinOrMax(a.aggregate)){if(h){throw new Error("Unsupported grand totals together with min/max")}if(f){throw new Error("Unsupported group levels together with min/max")}if(a.hierarchyQualifier){throw new Error("Unsupported recursive hierarchy together with min/max")}if(d){throw new Error("Unsupported $$sharedRequest together with min/max")}g();return o.createCache(n,i,a,s)}if(s.$filter&&(h&&!a["grandTotal like 1.84"]||f)){throw new Error("Unsupported system query option: $filter")}if(h||f||a.hierarchyQualifier){if(s.$search){throw new Error("Unsupported system query option: $search")}if(!a.hierarchyQualifier){g()}if(c){throw new Error("Unsupported grouping via sorter")}if(d){throw new Error("Unsupported $$sharedRequest")}return new u(n,i,a,s,h)}}if("$$filterOnAggregate"in s){throw new Error("Unsupported $$filterOnAggregate")}if(s.$$filterBeforeAggregate){s.$apply="filter("+s.$$filterBeforeAggregate+")/"+s.$apply;delete s.$$filterBeforeAggregate}return t.create(n,i,s,l,r,d)};u.fixDuplicatePredicate=function(e,t){if(t==="('')"||t.includes("=''")){a.warning("Duplicate key predicate: "+t,this.toString(),"sap.ui.model.odata.v4.lib._AggregationCache");const n=t.slice(0,-1)+",$duplicate="+r.uid()+")";r.setPrivateAnnotation(e,"predicate",n);if(this.aElements.$byPredicate[t]===e){delete this.aElements.$byPredicate[t];this.aElements.$byPredicate[n]=e}return n}};return u},false);
//# sourceMappingURL=_AggregationCache.js.map