/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["./_Helper","./_Parser","sap/ui/model/Filter"],function(e,t,r){"use strict";var n=/,|%2C|%2c/,i={aggregate:{"*":{grandTotal:"boolean",max:"boolean",min:"boolean",name:"string",subtotals:"boolean",unit:"string",with:"string"}},"grandTotal like 1.84":"boolean",grandTotalAtBottomOnly:"boolean",group:{"*":{additionally:["string"]}},groupLevels:["string"],search:"string",subtotalsAtBottomOnly:"boolean"},a=Object.freeze({"@$ui5.node.isExpanded":false}),o=Object.freeze({"@$ui5.node.isExpanded":true}),l=new RegExp("^("+t.sODataIdentifier+"(?:/"+t.sODataIdentifier+")*"+")(?:"+t.sWhitespace+"+(?:asc|desc))?$"),s={createInPlace:true,expandTo:/^[1-9]\d*$/,hierarchyQualifier:"string",search:"string"},u="com.sap.vocabularies.Hierarchy.v1.",f;function c(e,t,r,n,i,a,o){var l=e.aggregate[i],s=l.name||i,u=l.unit,f=l.with;if(n){if(f==="average"||f==="countdistinct"){throw new Error("Cannot aggregate totals with '"+f+"'")}s=i;i="UI5grand__"+i}if(f){s+=" with "+f+" as "+i}else if(l.name){s+=" as "+i}r.push(s);if(u&&!r.includes(u)&&!o.includes(u,a+1)&&!t.includes(u)){r.push(u)}}function g(e){var t=[];if(e.$skip){t.push("skip("+e.$skip+")")}delete e.$skip;if(e.$top<Infinity){t.push("top("+e.$top+")")}delete e.$top;return t.join("/")}f={beforeOverwritePlaceholder:function(t,r,n,i,a){var o=e.getPrivateAnnotation(t,"parent");if(!e.hasPrivateAnnotation(t,"placeholder")){throw new Error("Unexpected element")}if(o!==n||e.getPrivateAnnotation(t,"rank")!==i||t["@$ui5.node.level"]!==r["@$ui5.node.level"]&&t["@$ui5.node.level"]!==0){throw new Error("Wrong placeholder")}["descendants","predicate"].forEach(function(n){if(e.hasPrivateAnnotation(t,n)&&e.getPrivateAnnotation(t,n)!==e.getPrivateAnnotation(r,n)){throw new Error("Unexpected structural change: "+n)}});if(a){f.checkNodeProperty(t,r,a)}e.copyPrivateAnnotation(t,"cache",r);e.copyPrivateAnnotation(t,"context",r);e.copyPrivateAnnotation(t,"spliced",r);if("@$ui5.context.isTransient"in t){r["@$ui5.context.isTransient"]=false}if(e.getPrivateAnnotation(t,"placeholder")===1){if(t["@$ui5.node.isExpanded"]===undefined!==(r["@$ui5.node.isExpanded"]===undefined)){throw new Error("Not a leaf anymore (or vice versa)")}if(t["@$ui5.node.isExpanded"]!==undefined){r["@$ui5.node.isExpanded"]=t["@$ui5.node.isExpanded"]}}},buildApply:function(e,t,r,n,i){var a,o="",l=[],s=e["grandTotal like 1.84"],u,d,p,h=[],$,y,v=[];function b(t,r){var n,a=e.aggregate[t];if(a[r]){n="UI5"+r+"__"+t;h.push(t+" with "+r+" as "+n);if(i){i[n]={measure:t,method:r}}}}if(e.hierarchyQualifier){return f.buildApply4Hierarchy(e,t,!r)}t=Object.assign({},t);e.groupLevels??=[];e.group??={};e.groupLevels.forEach(function(t){e.group[t]??={}});y=Object.keys(e.group).sort();if(y.length===e.groupLevels.length){e.groupLevels.pop()}d=!r||r>e.groupLevels.length;u=d?y.filter(function(t){return!e.groupLevels.includes(t)}):[e.groupLevels[r-1]];if(!r){u=e.groupLevels.concat(u)}e.aggregate??={};a=Object.keys(e.aggregate).sort();if(r===1&&!n){a.filter(function(t){return e.aggregate[t].grandTotal}).forEach(c.bind(null,e,[],l,s))}if(!n){a.forEach(function(e){b(e,"min");b(e,"max")})}a.filter(function(t){return d||e.aggregate[t].subtotals}).forEach(c.bind(null,e,u,v,false));if(v.length){o="aggregate("+v.join(",")+")"}if(u.length){u.forEach(function(t){var r=e.group[t].additionally;if(r){u.push.apply(u,r)}});o="groupby(("+u.join(",")+(o?"),"+o+")":"))")}if(n){delete t.$count}else if(t.$count){h.push("$count as UI5__count");delete t.$count}if(t.$filter){o+="/filter("+t.$filter+")";delete t.$filter}if(t.$orderby){o+="/orderby("+t.$orderby+")";delete t.$orderby}$=g(t);if(s&&l.length){if(e.groupLevels.length){throw new Error("Cannot combine visual grouping with grand total")}o+="/concat(aggregate("+l.join(",")+"),aggregate("+h.join(",")+"),"+($||"identity")+")"}else{if(h.length){o+="/concat(aggregate("+h.join(",")+"),"+($||"identity")+")"}else if($){o+="/"+$}if(r===1&&t.$$leaves&&!n){p="groupby(("+y.join(",")+"))/aggregate($count as UI5__leaves)"}delete t.$$leaves;if(l.length){o="concat("+(p?p+",":"")+"aggregate("+l.join(",")+"),"+o+")"}else if(p){o="concat("+p+","+o+")"}}if(t.$$filterOnAggregate){o="groupby(("+y.join(",")+"),filter("+t.$$filterOnAggregate+"))/"+o;delete t.$$filterOnAggregate}if(e.search){o="search("+e.search+")/"+o}if(t.$$filterBeforeAggregate){o="filter("+t.$$filterBeforeAggregate+")/"+o;delete t.$$filterBeforeAggregate}if(o){t.$apply=o}return t},buildApply4Hierarchy:function(e,t,r){let n;function i(r){if(t.$select){let i=e["$"+r];if(!i){n??=e.$fetchMetadata(e.$metaPath+"/@"+u+"RecursiveHierarchy#"+e.hierarchyQualifier).getResult();i=e["$"+r]=n[r+"Property"]?.$PropertyPath??n[r]?.$Path}t.$select.push(i)}}let a=e.$NodeProperty;if(!a){a="???";if(t){const t=e.$fetchMetadata(e.$metaPath+"/@Org.OData.Aggregation.V1.RecursiveHierarchy#"+e.hierarchyQualifier);if(t.isFulfilled()){a=e.$NodeProperty=t.getResult().NodeProperty.$PropertyPath;e.$ParentNavigationProperty=t.getResult().ParentNavigationProperty.$NavigationPropertyPath}}}t=Object.assign({},t);if(t.$select){t.$select=t.$select.slice();if(!t.$select.includes(a)){t.$select.push(a)}e.$Actions??=e.$fetchMetadata(e.$metaPath+"/@"+u+"RecursiveHierarchyActions#"+e.hierarchyQualifier).getResult()}let o="";if(t.$filter||e.search){let r="";if(t.$filter){o="filter("+t.$filter;r=")/";delete t.$filter}if(e.search){o+=r+"search("+e.search}o="ancestors($root"+e.$path+","+e.hierarchyQualifier+","+a+","+o+"),keep start)/"}if(t.$$filterBeforeAggregate){o+="descendants($root"+e.$path+","+e.hierarchyQualifier+","+a+",filter("+t.$$filterBeforeAggregate+(r?"))":"),1)");delete t.$$filterBeforeAggregate;if(t.$orderby){o+="/orderby("+t.$orderby+")";delete t.$orderby}}else{if(t.$orderby){o+="orderby("+t.$orderby+")/";delete t.$orderby}e.expandTo??=1;const n=!r&&e.$ExpandLevels;o+=u+"TopLevels(HierarchyNodes=$root"+(e.$path||"")+",HierarchyQualifier='"+e.hierarchyQualifier+"',NodeProperty='"+a+"'"+(r||e.expandTo>=Number.MAX_SAFE_INTEGER?"":",Levels="+e.expandTo)+(n?",ExpandLevels="+n:"")+")";if(r){i("DistanceFromRoot")}else if(e.expandTo>1||n){i("DistanceFromRoot");i("LimitedDescendantCount")}}i("DrillState");if(n&&!e.$LimitedRank){e.$LimitedRank=n.LimitedRank?.$Path??e.$DrillState.slice(0,e.$DrillState.lastIndexOf("/")+1)+"LimitedRank"}t.$apply=o;return t},checkNodeProperty:function(t,r,n,i){var a=e.drillDown(r,n),o=e.drillDown(t,n);if((i||o!==undefined)&&a!==undefined&&o!==a){throw new Error("Unexpected structural change: "+n+" from "+JSON.stringify(o)+" to "+JSON.stringify(a))}},checkTypeof:function(e,t,r){if(Array.isArray(t)){if(!Array.isArray(e)){throw new Error("Not an array value for '"+r+"'")}e.forEach(function(e,n){f.checkTypeof(e,t[0],r+"/"+n)})}else if(t instanceof RegExp){if(!t.test(e)){throw new Error("Not a matching value for '"+r+"'")}}else if(typeof t==="object"){const n="*"in t;if(typeof e!=="object"||!e||Array.isArray(e)){throw new Error("Not an object value for '"+r+"'")}Object.keys(e).forEach(function(i){if(!n&&!(i in t)){throw new Error("Unsupported property: '"+r+"/"+i+"'")}f.checkTypeof(e[i],t[n?"*":i],r+"/"+i)})}else if(t===true){if(e!==true){throw new Error("Not a true value for '"+r+"'")}}else if(typeof e!==t){throw new Error("Not a "+t+" value for '"+r+"'")}},createPlaceholder:function(t,r,n){var i={"@$ui5.node.level":t};e.setPrivateAnnotation(i,"parent",n);e.setPrivateAnnotation(i,"placeholder",true);e.setPrivateAnnotation(i,"rank",r);return i},dropFilter:function(e,t,r){e={...e};delete e.search;t={...t};delete t.$count;delete t.$expand;delete t.$filter;delete t.$orderby;delete t.$select;if(r){t.$$filterBeforeAggregate=r}else{delete t.$$filterBeforeAggregate}return f.buildApply4Hierarchy(e,t)},extractSubtotals:function(e,t,r,n){var i=t["@$ui5.node.level"];Object.keys(e.aggregate).forEach(function(a){var o=e.aggregate[a],l,s=o.unit;if(!o.subtotals){return}r[a]=t[a];if(n){n[a]=null}if(s){r[s]=t[s];if(n){l=e.groupLevels.indexOf(s);if(l<0||l>=i){n[s]=null}}}})},filterOrderby:function(e,t,r){var n=f.getFilteredOrderby(e.$orderby,t,r);e=Object.assign({},e);if(n){e.$orderby=n}else{delete e.$orderby}return e},findPreviousSiblingIndex:function(t,r){let n;const i=t[r]["@$ui5.node.level"];for(let a=r-1;a>=0;a-=1){const o=t[a];if(!o){n=true;continue}if(o["@$ui5.node.level"]<i){break}if(o["@$ui5.node.level"]>i){continue}if(a+e.getPrivateAnnotation(o,"descendants",0)===r-1){return a}break}return n?undefined:-1},getAllProperties:function(e){var t=Object.keys(e.aggregate),r=Object.keys(e.group),n=t.concat(r);t.forEach(function(t){var r=e.aggregate[t].unit;if(r){n.push(r)}});r.forEach(function(t){e.group[t].additionally?.forEach(function(e){n.push(e.includes("/")?e.split("/"):e)})});return n},getCollapsedObject:function(t){return e.getPrivateAnnotation(t,"collapsed",a)},getFilteredOrderby:function(e,t,r){var i=!r||r>t.groupLevels.length;function a(e){return Object.keys(t.aggregate).some(function(r){var n=t.aggregate[r];return n.subtotals&&e===n.unit})}function o(e){if(e in t.group&&(!r||!t.groupLevels.includes(e))){return true}return Object.keys(t.aggregate).some(function(r){return e===t.aggregate[r].unit})||Object.keys(t.group).some(function(n){return(!r||!t.groupLevels.includes(n))&&s(e,n)})}function s(e,r){return e===r||t.group[r].additionally?.includes(e)}if(e){return e.split(n).filter(function(e){var n=l.exec(e),u;if(n){u=n[1];return u in t.aggregate&&(i||t.aggregate[u].subtotals)||i&&o(u)||!i&&(s(u,t.groupLevels[r-1])||a(u))}return true}).join(",")}},getOrCreateExpandedObject:function(t,r){var n,i;if(t.subtotalsAtBottomOnly===undefined){return o}i=e.getPrivateAnnotation(r,"expanded");if(!i){n={"@$ui5.node.isExpanded":false};e.setPrivateAnnotation(r,"collapsed",n);i={"@$ui5.node.isExpanded":true};e.setPrivateAnnotation(r,"expanded",i);f.extractSubtotals(t,r,n,t.subtotalsAtBottomOnly?i:null)}return i},getQueryOptionsForOutOfPlaceNodesData:function(e,t,r){t=Object.assign({},t);t.expandTo=1;delete t.search;delete t.$ExpandLevels;r=Object.assign({},r);if(e.parentFilter){r.$$filterBeforeAggregate=e.parentFilter}delete r.$count;delete r.$filter;delete r.$orderby;r=f.buildApply(t,r,1);const n=e.nodeFilters.slice().sort();r.$filter=n.join(" or ");r.$top=n.length;const i=r.$select.indexOf(t.$DrillState);if(i>=0){r.$select.splice(i,1)}return r},getQueryOptionsForOutOfPlaceNodesRank:function(t,r,n){const i=new Set;t.forEach(function(e){if(e.parentFilter){i.add(e.parentFilter)}e.nodeFilters.forEach(function(e){i.add(e)})});const a=[r.$DistanceFromRoot,r.$DrillState,r.$LimitedRank];if(r.$LimitedDescendantCount){a.push(r.$LimitedDescendantCount)}n=Object.assign({},n,{$filter:[...i].sort().join(" or "),$select:a,$top:i.size});delete n.$count;delete n.$orderby;e.selectKeyProperties(n,r.$fetchMetadata(r.$metaPath+"/").getResult());return n},hasGrandTotal:function(e){return e&&Object.keys(e).some(function(t){return e[t].grandTotal})},hasMinOrMax:function(e){return e&&Object.keys(e).some(function(t){var r=e[t];return r.min||r.max})},isAffected:function(t,r,n){return n.some(function(n){function i(t){return e.hasPathPrefix(t,n.endsWith("/*")?n.slice(0,-2):n)||e.hasPathPrefix(n,t)}function a(e){return e.some(function(e){return e.getFilters()?a(e.getFilters()):i(e.getPath())})}return n===""||n==="*"||a(r)||Object.keys(t.aggregate).some(e=>{const r=t.aggregate[e];return i(r.name||e)||r.unit&&i(r.unit)})||Object.keys(t.group).some(e=>i(e)||t.group[e].additionally?.some(e=>i(e)))})},markSplicedStale:function(t){var r=e.getPrivateAnnotation(t,"spliced");if(r){r.$stale=true}},removeUI5grand__:function(e){Object.keys(e).forEach(function(t){if(t.startsWith("UI5grand__")){e[t.slice(10)]=e[t];delete e[t]}})},setAnnotations:function(t,r,n,i,a){e.setAnnotation(t,"@$ui5.node.isExpanded",r);e.setAnnotation(t,"@$ui5.node.isTotal",n);t["@$ui5.node.level"]=i;if(a){a.forEach(function(r){if(Array.isArray(r)){e.createMissing(t,r)}else if(!(r in t)){t[r]=undefined;t[r+"@$ui5.noData"]=true}})}},setPath:function(t,r){t.$metaPath=r&&e.getMetaPath(r);t.$path=r},splitFilter:function(e,t){var n=[],i=[],a=[];function o(e){return e.getFilters()?e.getFilters().some(o):e.getPath()in t.aggregate}function l(e){return Object.keys(t.aggregate).some(r=>t.aggregate[r].unit===e)}function s(e){if(e.getFilters()&&e.isAnd()){e.getFilters().forEach(s)}else if(e.getPath()&&l(e.getPath())){n.push(e);i.push(e);a.push(e)}else{(o(e)?a:n).push(e)}}function u(e){return e.length>1?new r(e,true):e[0]}if(!t?.aggregate){return[e]}if(!t.$leafLevelAggregated){return[undefined,e]}s(e);let c=[u(a),u(n)];if(t.groupLevels.length||!t["grandTotal like 1.84"]&&f.hasGrandTotal(t.aggregate)){c=[undefined,c[1],c[0],i]}return c},validateAggregation:function(e,t){if(e.hierarchyQualifier&&!t){throw new Error("Missing parameter autoExpandSelect at model")}f.checkTypeof(e,e.hierarchyQualifier?s:i,"$$aggregation")},validateAggregationAndSetPath:function(e,t,r,n){f.validateAggregation(e,t);e.$fetchMetadata=r;f.setPath(e,n)}};return f},false);
//# sourceMappingURL=_AggregationHelper.js.map