/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["./_GroupLock","./_Helper","./_Requestor","sap/base/Log","sap/ui/base/SyncPromise","sap/ui/model/odata/ODataUtils"],function(e,t,i,n,s,r){"use strict";var o="sap.ui.model.odata.v4.lib._Cache",a=/\(\$uid=[-\w]+\)$/,u=/^\$inactive\./,h="@com.sap.vocabularies.Common.v1.Messages",c=/^-?\d+$/,l=/^([^(]*)(\(.*\))$/;function d(e,t){return t===""||e===t||e.startsWith(t+"/")}function f(e,t,i,n,s,r){this.iActiveUsages=1;this.mChangeListeners={};this.mChangeRequests={};this.sOriginalResourcePath=s||t;this.iInactiveSince=Infinity;this.mEditUrl2PatchPromise={};this.oPendingRequestsPromise=null;this.mPostRequests={};this.sReportedMessagesPath=undefined;this.oRequestor=e;this.bSentRequest=false;this.bSortExpandSelect=n;this.setResourcePath(t);this.setQueryOptions(i);this.bSharedRequest=r}f.prototype._delete=function(i,n,r,o,a){var u=r.split("/"),h=u.pop(),l=u.join("/"),d=this;this.checkSharedRequest();return this.fetchValue(e.$cached,l).then(function(e){var r,u=h?e[h]||e.$byPredicate[h]:e,f,p,g,P=c.test(h)?Number(h):undefined,m=t.getPrivateAnnotation(u,"predicate"),y=t.buildPath(l,Array.isArray(e)?m:h),$=d.oRequestor.getModelInterface(),v,R=t.getPrivateAnnotation(u,"transient"),E=t.getPrivateAnnotation(u,"transientPredicate");function q(){t.removeByPath(d.mChangeRequests,y,v);if(p.length){$.updateMessages(undefined,p)}delete u["@$ui5.context.isDeleted"];if(Array.isArray(e)){P=r.index;const t=e.$deleted.indexOf(r);if(P!==undefined){d.restoreElement(P,u,t,e,l)}e.$deleted.splice(t,1)}if(d.iActiveUsages){a(P,1)}else if(P===undefined&&d.reset){d.reset([])}}if(R){if(typeof R!=="string"){throw new Error("No 'delete' allowed while waiting for server response")}if(e.$postBodyCollection){e.$postBodyCollection.splice(P,1);d.removeElement(P,E,e,l);a(P,-1);const i=new Error("Deleted from deep create");i.canceled=true;t.getPrivateAnnotation(u,"reject")(i);t.cancelNestedCreates(u,"Deleted from deep create")}else{d.oRequestor.removePost(R,u)}return undefined}p=$.getMessagesByPath(t.buildPath("/",d.sResourcePath,y),true);$.updateMessages(p);u["@$ui5.context.isDeleted"]=true;if(Array.isArray(e)){r=d.addDeleted(e,P,m,i,!!E);d.removeElement(P,m,e,l)}a(P,-1);if(i){f=i.getGroupId();d.oRequestor.relocateAll("$parked."+f,f,u)}g={"If-Match":o||u};n+=d.oRequestor.buildQueryString(d.sMetaPath,d.mQueryOptions,true);v=i?d.oRequestor.request("DELETE",n,i,g,undefined,undefined,q,undefined,t.buildPath(d.sOriginalResourcePath,y)):s.resolve();t.addByPath(d.mChangeRequests,y,v);return v.catch(function(e){if(e.status!==404){throw e}}).then(function(){t.removeByPath(d.mChangeRequests,y,v);if(Array.isArray(e)){e.$deleted.splice(e.$deleted.indexOf(r),1);delete e.$byPredicate[m];delete e.$byPredicate[E]}else if(h){t.updateExisting(d.mChangeListeners,l,e,t.makeUpdateData([h],null))}else{u["$ui5.deleted"]=true}},function(e){if(!e.canceled){p=p.filter(function(e){return!e.persistent});q()}throw e})})};f.prototype.addDeleted=function(e,t,i,n,s){var r={created:s,groupId:n&&n.getGroupId(),predicate:i,index:t},o;e.$deleted??=[];if(t===undefined){e.$deleted.unshift(r)}else{for(o=0;o<e.$deleted.length;o+=1){if(t<e.$deleted[o].index){break}}e.$deleted.splice(o,0,r)}return r};f.prototype.addPendingRequest=function(){var e;if(!this.oPendingRequestsPromise){this.oPendingRequestsPromise=new s(function(t){e=t});this.oPendingRequestsPromise.$count=0;this.oPendingRequestsPromise.$resolve=e}this.oPendingRequestsPromise.$count+=1};f.prototype.addTransientCollection=function(e,i){var n,s=e.split("/"),r=s.pop(),o=this.getValue(s.join("/")),a=t.getPrivateAnnotation(o,"postBody"),u,h=e.indexOf(")",e.indexOf("($uid="))+1,c=this.getValue(e.slice(0,h)),l=t.getPrivateAnnotation(c,"select",{}),d=this;function f(){n.$postBodyCollection=a[r]=u}this.checkSharedRequest();n=o[r]??=[];n.$count=n.$created=n.length;n.$byPredicate={};u=a[r]||[];if(n.length){f()}else{n.$postBodyCollection=f}l[t.getMetaPath(e.slice(h+1))]=i;t.setPrivateAnnotation(c,"select",l);n.forEach(function(e,i){var s="($uid="+t.uid()+")";e["@$ui5.context.isTransient"]=true;t.setPrivateAnnotation(e,"postBody",u[i]);t.setPrivateAnnotation(e,"transient",t.getPrivateAnnotation(o,"transient"));t.setPrivateAnnotation(e,"transientPredicate",s);t.setPrivateAnnotation(e,"promise",t.addPromise(e));n.$byPredicate[s]=e});this.fetchTypes().then(function(i){d.oRequestor.fetchType(i,d.sMetaPath+"/"+t.getMetaPath(e))});return n};f.prototype.adjustIndexes=function(e,t,i,n,s,r){if(i===undefined){return}if(!e&&this.aReadRequests){this.aReadRequests.forEach(function(e){if(e.iStart>=i){e.iStart+=n;e.iEnd+=n}})}(t.$deleted||[]).forEach(function(e,t){if(i<e.index||s<t||r&&(i===0||!e.created)){e.index+=n}})};f.prototype.calculateKeyPredicate=function(e,i,n){var s,r=i[n];if(r&&r.$Key){s=t.getKeyPredicate(e,n,i);if(s){t.setPrivateAnnotation(e,"predicate",s)}}return s};f.prototype.checkSharedRequest=function(){if(this.bSharedRequest){throw new Error(this+" is read-only")}};f.prototype.create=function(e,i,n,r,o,a,h,c,l){var d=this.getValue(n),f=e.getGroupId(),p,g,P=this;function m(s){var a=o["@$ui5.context.isInactive"],u=d.indexOf(o);if(s&&a){if(a===1){t.resetInactiveEntity(P.mChangeListeners,r,o)}return true}t.cancelNestedCreates(o,"Deep create of "+i.getResult()+" canceled; group: "+e.getGroupId());t.removeByPath(P.mPostRequests,n,o);d.splice(u,1);d.$created-=1;if(!o["@$ui5.context.isInactive"]){if(!n){P.iActiveElements-=1}t.addToCount(P.mChangeListeners,n,d,-1)}delete d.$byPredicate[r];P.adjustIndexes(n,d,u,-1);if(l){l()}e.cancel()}function y(){P.addPendingRequest();t.setPrivateAnnotation(o,"transient",new Promise(function(e){g=e}));c()}function $(e,i){t.setPrivateAnnotation(o,"transient",f);t.addByPath(P.mPostRequests,n,o);return s.all([P.oRequestor.request("POST",e,i,null,p,y,m,undefined,t.buildPath(P.sResourcePath,n,r)),P.fetchTypes()]).then(function([i,s]){var a,u,h;t.deletePrivateAnnotation(o,"postBody");t.deletePrivateAnnotation(o,"transient");i["@$ui5.context.isTransient"]=false;t.removeByPath(P.mPostRequests,n,o);P.visitResponse(i,s,t.getMetaPath(t.buildPath(P.sMetaPath,n)),n+r,undefined,true);a=t.getPrivateAnnotation(i,"predicate");if(a){t.setPrivateAnnotation(o,"predicate",a);if(r in d.$byPredicate){d.$byPredicate[a]=o;t.updateTransientPaths(P.mChangeListeners,r,a)}}t.cancelNestedCreates(o,"Deep create of "+e+" succeeded. Do not use this promise.");u=t.buildPath(n,a||r);const c=t.updateNestedCreates(P.mChangeListeners,P.mQueryOptions,u,o,i,t.getPrivateAnnotation(o,"select"));if(!c){h=t.getQueryOptionsForPath(P.mLateQueryOptions||P.mQueryOptions,n).$select}t.updateSelected(P.mChangeListeners,u,o,i,h,undefined,true);t.setPrivateAnnotation(o,"deepCreate",c);t.deletePrivateAnnotation(o,"select");P.removePendingRequest();g(true);return o},function(t){var i;if(t.canceled){throw t}if(g){P.removePendingRequest();g()}if(P.fetchTypes().isRejected()){h(t);throw t}f=f.replace(u,"");f=P.oRequestor.getGroupSubmitMode(f)==="API"?f:"$parked."+f;i=$(e,P.oRequestor.lockGroup(f,P,true,true));h(t);return i})}this.checkSharedRequest();if(!Array.isArray(d)){throw new Error("Create is only supported for collections; '"+n+"' does not reference a collection")}p=t.clone(o);t.setPrivateAnnotation(o,"postBody",p);t.setPrivateAnnotation(o,"transientPredicate",r);o["@$ui5.context.isTransient"]=true;if(f.startsWith("$inactive.")){t.setPrivateAnnotation(o,"initialData",t.publicClone(o,true));o["@$ui5.context.isInactive"]=true}else{if(!n){this.iActiveElements+=1}t.addToCount(this.mChangeListeners,n,d,1)}if(a){d.splice(d.$created,0,o)}else{d.unshift(o)}d.$created+=1;d.$byPredicate??={};d.$byPredicate[r]=o;P.adjustIndexes(n,d,0,1,0,true);if(d.$postBodyCollection){if(typeof d.$postBodyCollection==="function"){d.$postBodyCollection()}t.setPrivateAnnotation(o,"transient",f);if(a){d.$postBodyCollection.push(p)}else{d.$postBodyCollection.unshift(p)}e.unlock();return t.addPromise(o)}return i.then(function(t){t+=P.oRequestor.buildQueryString(P.sMetaPath,P.mQueryOptions,true);return $(t,e)})};f.prototype.drillDown=function(i,r,a,u){var h=s.resolve(i),c,d,p=false,g,P=false,m=this;function y(e,t){t||=e[0]==="("&&e.at(-1)===")";n[t?"info":"error"]("Failed to drill-down into "+r+", invalid segment: "+e,m.toString(),o);return undefined}function $(e,n,s,r){var o,u,h=g.slice(0,s).join("/"),l=t.getMetaPath(h),f;if(Array.isArray(e)){return y(n,n==="0")}if(p){return y(n,true)}if(n.includes("@")){u=n.split("@")[0];l=t.getMetaPath(h.split("@")[0]);if(P||u in e||e[u+"@$ui5.noData"]||t.isSelected(l,m.mQueryOptions)){return y(n,true)}}const $=m.mSeparateProperty2ReadRequests?.[n];if($){const t=m.aElements.indexOf(e);const i=$.find(e=>t>=e.start&&t<e.end);if(i){return i.promise}}o=e[t.getAnnotationKey(e,".Permissions",n)];if(o===0||o==="None"){return undefined}return m.oRequestor.getModelInterface().fetchMetadata(m.sMetaPath+"/"+l).then(function(s){var o=false;if(!s){return y(n)}if(s.$Type==="Edm.Stream"&&!u){f=e[n+"@odata.mediaReadLink"]||e[n+"@mediaReadLink"];if(f){return f}if(e[n+"@$ui5.noData"]||t.isSelected(l,m.mQueryOptions)){return t.buildPath(m.oRequestor.getServiceUrl()+m.sResourcePath,h)}}if(!r&&e[n+"@$ui5.noData"]){return undefined}if(!P){if(!c&&!Array.isArray(i)){c=i;d=0}if(c&&!r){o=m.fetchLateProperty(a,c,g.slice(0,d).join("/"),g.slice(d).join("/"))}return typeof o==="boolean"?y(n,o):o}if(s.$kind==="NavigationProperty"){return null}if(!s.$Type.startsWith("Edm.")){return{}}if("$DefaultValue"in s){return s.$Type==="Edm.String"?s.$DefaultValue:t.parseLiteral(s.$DefaultValue,s.$Type,h)}return null})}if(!r){return h}g=r.split("/");return g.reduce(function(i,n,r){return i.then(function i(o,h){var v,R,E;if(o===undefined){return undefined}if(n==="$count"){return Array.isArray(o)?o.$count:y(n)}if(o===null){P=true;return $({},n,r+1)}if(typeof o!=="object"||n==="@$ui5._"||Array.isArray(o)&&(n[0]==="$"||n==="length")){return y(n)}if(t.hasPrivateAnnotation(o,"predicate")){c=o;d=r}E=o;P||=o["@$ui5.context.isTransient"];R=l.exec(n);if(R){if(R[1]){o=o[R[1]]}o&&=o.$byPredicate&&o.$byPredicate[R[2]]}else{v=f.from$skip(n,o);if(u&&v===n&&(o[n]===undefined||o[n]===null)){o[n]={}}o=o[v]}if(g.length===1&&a!==e.$cached&&m.mSeparateProperty2ReadRequests){const e=m.aElements.indexOf(o);const t=[];for(const i in m.mSeparateProperty2ReadRequests){const n=m.mSeparateProperty2ReadRequests[i].find(t=>e>=t.start&&e<t.end);if(n){t.push(n.promise)}}if(t.length){return Promise.all(t).then(function(){return i(E)})}}if(o===undefined&&n[0]!=="#"&&n[0]!=="@"){o=$(E,n,r+1,h);if(o instanceof s&&o.isPending()){return o.then(function(){return i(E,true)})}}if(n.includes("@")){p=true}return o})},h)};f.prototype.fetchLateProperty=function(e,i,n,s){var r=false,o,a,u,h=s.indexOf("@"),c,l,d,f,p=t.getMetaPath(n),g=this.getTypes(),P,m=this;function y(){r=true;m.oRequestor.getModelInterface().fireDataRequested("/"+a)}function $(e,i){var n=t.buildPath(o,i),s=g[n],r;s??=m.oRequestor.fetchType(g,n).getResult();if(i){(s.$Key||[]).forEach(function(e){if(typeof e==="object"){e=e[Object.keys(e)[0]]}P.push(t.buildPath(i,e))})}if(e.$expand){r=Object.keys(e.$expand)[0];$(e.$expand[r],t.buildPath(i,r))}}if(!(this.mLateQueryOptions||this.mQueryOptions&&this.mQueryOptions.$select)){return false}if(h>=0){if(s.startsWith("@$ui5.",h)){return true}s=s.slice(0,h)}P=[s];o=t.buildPath(this.sMetaPath,p);d=this.mLateQueryOptions||{$select:this.mQueryOptions.$select,$expand:this.mQueryOptions.$expand};d=t.intersectQueryOptions(t.getQueryOptionsForPath(d,n),[s],this.oRequestor.getModelInterface().fetchMetadata,o);if(!d){return false}$(d);a=t.buildPath(this.sResourcePath,n);f=a+this.oRequestor.buildQueryString(o,d,false,true);l=this.mPropertyRequestByPath[f];if(!l){c=a+this.oRequestor.buildQueryString(o,this.mQueryOptions,true);u=t.getPrivateAnnotation(i,"groupId");l=this.oRequestor.request("GET",c,u?this.oRequestor.lockGroup(u,this):e.getUnlockedCopy(),undefined,undefined,y,undefined,o,undefined,false,d).then(function(e){m.visitResponse(e,g,o,n);return e});this.mPropertyRequestByPath[f]=l}return l.then(function(e){var s=t.getPrivateAnnotation(e,"predicate"),o=t.getPrivateAnnotation(i,"predicate");if(o&&s&&o!==s){throw new Error("GET "+f+": Key predicate changed from "+o+" to "+s)}if(i["@odata.etag"]&&e["@odata.etag"]!==i["@odata.etag"]){throw new Error("GET "+f+": ETag changed")}t.updateSelected(m.mChangeListeners,n,i,e,P);if(r){r=false;m.oRequestor.getModelInterface().fireDataReceived(undefined,"/"+a)}}).catch(function(e){if(r){m.oRequestor.getModelInterface().fireDataReceived(e,"/"+a)}throw e}).finally(function(){delete m.mPropertyRequestByPath[f]})};f.prototype.fetchTypes=function(){var e,t,i=this;function n(s,r){if(r&&r.$expand){Object.keys(r.$expand).forEach(function(o){var a=s;o.split("/").forEach(function(n){a+="/"+n;e.push(i.oRequestor.fetchType(t,a))});n(a,r.$expand[o])})}}if(!this.oTypePromise){e=[];t={};e.push(this.oRequestor.fetchType(t,this.sMetaPath));n(this.sMetaPath,this.mQueryOptions);this.oTypePromise=s.all(e).then(function(){return t})}return this.oTypePromise};f.prototype.getAndRemoveCollection=function(t){var i=t.split("/"),n=i.pop(),s=this.fetchValue(e.$cached,i.join("/")).getResult(),r=s[n];this.checkSharedRequest();if(r){if(!Array.isArray(r)){throw new Error(`${t} must point to a collection`)}if(!r.$transfer){return undefined}delete r.$transfer}delete s[n];return r};f.prototype.getCreatedElements=function(e){var t=this.getValue(e);return t?t.slice(0,t.$created):[]};f.prototype.getDownloadQueryOptions=function(e){return e};f.prototype.getDownloadUrl=function(e,i,n){var s=this.mQueryOptions;if(e){s=t.getQueryOptionsForPath(s,e);s=t.merge({},i,s)}s=t.merge({},s,n);return this.oRequestor.getServiceUrl()+t.buildPath(this.sResourcePath,e)+this.oRequestor.buildQueryString(t.buildPath(this.sMetaPath,t.getMetaPath(e)),this.getDownloadQueryOptions(s),false,true,!t.isEmptyObject(n))};f.prototype.getElements=function(e,t,i){const n=this.getValue(e);if(!n){return undefined}const r=n.slice(t,i).map(e=>e instanceof s?undefined:e);r.$count=n.$count;return r};f.prototype.getLateQueryOptions=function(){return this.mLateQueryOptions};f.prototype.getPendingRequestsPromise=function(){return this.oPendingRequestsPromise&&this.oPendingRequestsPromise.getResult()};f.prototype.getQueryOptions=function(){return this.mQueryOptions};f.prototype.getResourcePath=function(){return this.sResourcePath};f.prototype.getTypes=function(){return this.fetchTypes().getResult()};f.prototype.getValue=function(e){throw new Error("Unsupported operation")};f.prototype.hasChangeListeners=function(){return!t.isEmptyObject(this.mChangeListeners)};f.prototype.hasPendingChangesForPath=function(e,i,n){var s=this;return Object.keys(this.mChangeRequests).some(function(n){return t.hasPathPrefix(n,e)&&!(i&&s.mChangeRequests[n].every(function(e){return!e.$isKeepAlive||e.$isKeepAlive()}))})||Object.keys(this.mPostRequests).some(function(i){return n&&!i?false:t.hasPathPrefix(i,e)&&s.mPostRequests[i].some(function(e){return e["@$ui5.context.isInactive"]!==true})})};f.prototype.hasSentRequest=function(){return this.bSentRequest};f.prototype.patch=function(i,n){var s=this;this.checkSharedRequest();return this.fetchValue(e.$cached,i).then(function(e){t.updateExisting(s.mChangeListeners,i,e,n);return e})};f.prototype.refreshSingle=function(i,n,r,o,a,u,h){var c=false,l=this;this.checkSharedRequest();return this.fetchValue(e.$cached,n).then(function(e){var d=u&&n===""&&l.oRequestor.getModelInterface().fetchMetadata(l.sMetaPath+"/@com.sap.vocabularies.Common.v1.Messages/$Path").getResult(),f=t.clone(t.getQueryOptionsForPath(l.mQueryOptions,n)),p;if(r>=0){o=t.getPrivateAnnotation(e[r],"predicate")}if(!o){throw new Error("No key predicate known")}p=t.buildPath(l.sResourcePath,n,o);if(a&&l.mLateQueryOptions){t.aggregateExpandSelect(f,l.mLateQueryOptions)}if(d&&f.$select&&!f.$select.includes(d)){f.$select.push(d);c=true}delete f.$apply;delete f.$count;delete f.$filter;delete f.$orderby;delete f.$search;p+=l.oRequestor.buildQueryString(l.sMetaPath,f,false,l.bSortExpandSelect);l.bSentRequest=true;return s.all([l.oRequestor.request("GET",p,i,undefined,undefined,h),l.fetchTypes()]).then(function(t){var i=t[0];l.replaceElement(e,r,o,i,t[1],n,c);return i})})};f.prototype.refreshSingleWithRemove=function(i,n,r,o,a,u,h){var c=this;this.checkSharedRequest();return s.all([this.fetchValue(e.$cached,n),this.fetchTypes()]).then(function(e){var l=e[0],d,f,p={},g,P,m=t.clone(t.getQueryOptionsForPath(c.mQueryOptions,n)),y,$=t.buildPath(c.sResourcePath,n),v=[],R=e[1];if(r!==undefined){d=l[r];o=t.getPrivateAnnotation(d,"predicate");if(!o){throw new Error("No key predicate known")}}else{d=l.$byPredicate[o]}P=t.getKeyFilter(d,c.sMetaPath,R);f=(m.$filter?"("+m.$filter+") and ":"")+P;delete m.$count;delete m.$orderby;c.bSentRequest=true;if(a){if(c.mLateQueryOptions){t.aggregateExpandSelect(m,c.mLateQueryOptions)}p=Object.assign({},m);p.$filter=f;m.$filter=P;delete m.$search;y=$+c.oRequestor.buildQueryString(c.sMetaPath,m,false,c.bSortExpandSelect);v.push(c.oRequestor.request("GET",y,i,undefined,undefined,u));if(r!==undefined&&(P!==f||p.$search)){delete p.$select;delete p.$expand;p.$count=true;p.$top=0;g=$+c.oRequestor.buildQueryString(c.sMetaPath,p);v.push(c.oRequestor.request("GET",g,i.getUnlockedCopy()))}}else{m.$filter=f;y=$+c.oRequestor.buildQueryString(c.sMetaPath,m,false,c.bSortExpandSelect);v.push(c.oRequestor.request("GET",y,i,undefined,undefined,u))}return s.all(v).then(function(e){var i=e[0].value,s=e[1]&&e[1]["@odata.count"]==="0";if(i.length>1){throw new Error("Unexpected server response, more than one entity returned.")}else if(i.length===0){c.removeElement(r,o,l,n);c.oRequestor.getModelInterface().reportStateMessages(c.sResourcePath,{},[n+o]);h(false)}else if(s){const e=l.$byPredicate[o];t.copySelected(e,i[0]);if("@$ui5.context.isTransient"in e){i[0]["@$ui5.context.isTransient"]=false}c.removeElement(r,o,l,n);c.replaceElement(l,undefined,o,i[0],R,n);h(true)}else{c.replaceElement(l,r,o,i[0],R,n)}})})};f.prototype.registerChangeListener=function(e,i){if(!(this.bSharedRequest&&e)){t.registerChangeListener(this,e,i)}};f.prototype.removeElement=function(e,i,n=this.aElements,s=""){const r=i?n.$byPredicate[i]:n[e];if(!i){i=r&&t.getPrivateAnnotation(r,"predicate")}else if(e!==undefined){e=f.getElementIndex(n,i,e)}if(r&&!r["@$ui5.context.isDeleted"]){delete n.$byPredicate[i];delete n.$byPredicate[t.getPrivateAnnotation(r,"transientPredicate")]}if(e>=0){n.splice(e,1);t.addToCount(this.mChangeListeners,s,n,-1);if(e<n.$created){n.$created-=1;if(!s){this.iActiveElements-=1}}else if(!s){this.iLimit-=1}this.adjustIndexes(s,n,e,-1)}return e};f.prototype.removeMessages=function(){if(this.sReportedMessagesPath){this.oRequestor.getModelInterface().reportStateMessages(this.sReportedMessagesPath,{});this.sReportedMessagesPath=undefined}};f.prototype.removePendingRequest=function(){if(this.oPendingRequestsPromise){this.oPendingRequestsPromise.$count-=1;if(!this.oPendingRequestsPromise.$count){this.oPendingRequestsPromise.$resolve();this.oPendingRequestsPromise=null}}};f.prototype.replaceElement=function(e,i,n,s,r,o,a){var u,h;if(i===undefined){u=e.$byPredicate[n];e.$byPredicate[n]=s}else{i=f.getElementIndex(e,n,i);u=e[i];e[i]=e.$byPredicate[n]=s;h=t.getPrivateAnnotation(u,"transientPredicate");if(h){s["@$ui5.context.isTransient"]=false;e.$byPredicate[h]=s;t.setPrivateAnnotation(s,"transientPredicate",h)}}if(u){t.copySelected(u,s)}t.restoreUpdatingProperties(u,s);this.visitResponse(s,r,t.getMetaPath(t.buildPath(this.sMetaPath,o)),o+n,undefined,a)};f.prototype.requestCount=function(e){var i,n,s,r=this;if(this.mQueryOptions&&this.mQueryOptions.$count){n=Object.assign({},this.mQueryOptions);delete n.$expand;delete n.$orderby;delete n.$select;i=this.getExclusiveFilter();if(i){n.$filter=n.$filter?"("+n.$filter+") and "+i:i}n.$top=0;s=this.sResourcePath+this.oRequestor.buildQueryString(this.sMetaPath,n);return this.oRequestor.request("GET",s,e.getUnlockedCopy()).catch(function(t){if(t.cause&&t.cause.status===404){return r.oRequestor.request("GET",s,e.getUnlockedCopy())}throw t}).then(function(e){var i=parseInt(e["@odata.count"])+r.iActiveElements;t.setCount(r.mChangeListeners,"",r.aElements,i);r.iLimit=i;return i})}return Promise.resolve(r.iLimit)};f.prototype.resetChangesForPath=function(e){var i=this;this.checkSharedRequest();Object.keys(this.mChangeRequests).reverse().forEach(function(n){var s,r;if(t.hasPathPrefix(n,e)){s=i.mChangeRequests[n];for(r=s.length-1;r>=0;r-=1){i.oRequestor.removeChangeRequest(s[r])}delete i.mChangeRequests[n]}});Object.keys(this.mPostRequests).forEach(function(n){var s=i.mPostRequests[n],r,o,a;if(e.startsWith("($uid=")){s.forEach(function(n){o=t.getPrivateAnnotation(n,"transientPredicate");if(o===e&&n["@$ui5.context.isInactive"]===1){t.resetInactiveEntity(i.mChangeListeners,o,n)}})}else if(d(n,e)){for(a=s.length-1;a>=0;a-=1){r=t.getPrivateAnnotation(s[a],"transient");if(r.startsWith("$inactive.")){t.resetInactiveEntity(i.mChangeListeners,t.getPrivateAnnotation(s[a],"transientPredicate"),s[a])}else{i.oRequestor.removePost(r,s[a])}}}})};f.prototype.restoreElement=function(e,i,n,s=this.aElements,r=""){this.adjustIndexes(r,s,e,1,n);const o=t.getPrivateAnnotation(i,"transientPredicate");if(o){s.$created+=1;if(!r){this.iActiveElements+=1}}else if(!r){this.iLimit+=1}t.addToCount(this.mChangeListeners,r,s,1);t.insert(s,e,i);s.$byPredicate[t.getPrivateAnnotation(i,"predicate")]=i};f.prototype.setActive=function(e){if(e){this.iActiveUsages+=1;this.iInactiveSince=Infinity}else{this.iActiveUsages-=1;if(!this.iActiveUsages){this.iInactiveSince=Date.now();this.mChangeListeners={}}}};f.prototype.setLateQueryOptions=function(e){if(e){this.mLateQueryOptions={$select:e.$select,$expand:e.$expand}}else{this.mLateQueryOptions=null}};f.prototype.setProperty=function(i,n,s,r){var o=this;this.checkSharedRequest();return this.fetchValue(e.$cached,s,null,null,true).then(function(e){t.updateAll(o.mChangeListeners,s,e,t.makeUpdateData(i.split("/"),n,r))})};f.prototype.setQueryOptions=function(e={},t=false){this.checkSharedRequest();if(this.bSentRequest&&!t){throw new Error("Cannot set query options: Cache has already sent a request")}this.mQueryOptions=e;this.sQueryString=this.oRequestor.buildQueryString(this.sMetaPath,e,false,this.bSortExpandSelect)};f.prototype.setResourcePath=function(e){this.checkSharedRequest();this.sResourcePath=e;this.sMetaPath=t.getMetaPath("/"+e);this.oTypePromise=undefined;this.mLateQueryOptions=null;this.mPropertyRequestByPath={}};f.prototype.toString=function(){return this.oRequestor.getServiceUrl()+this.sResourcePath+this.sQueryString};f.prototype.update=function(i,r,a,u,h,c,l,d,f,p,g){var P,m=r.split("/"),y,$=this;this.checkSharedRequest();try{P=this.fetchValue(e.$cached,c)}catch(e){if(!e.$cached||this.oPromise!==null){throw e}P=this.oPromise=s.resolve({"@odata.etag":"*"})}const v=P.then(function(e){var P=t.buildPath(c,r),v=i.getGroupId(),R,E,q,b=t.makeUpdateData(m,a);function S(n,r){var o={"If-Match":e},a,l,m;function A(e){if(arguments.length===0){m=true;return E}if(E){t.updateNonExisting(E,e)}}function C(){t.removeByPath($.mChangeRequests,P,a);if(y){t.updateAll($.mChangeListeners,q,$.getValue(q),{[R]:null});g?.()}else{t.updateAll($.mChangeListeners,c,e,E)}}function O(){if(y&&$.iActiveUsages){$.refreshSingleNoCollection(i,c).catch($.oRequestor.getModelInterface().getReporter())}l=$.oRequestor.lockGroup(v,$,true);f()}if(y){o["If-None-Match"]="*";d=true}if(d){o.Prefer="return=minimal"}a=$.oRequestor.request("PATCH",h,n,o,b,O,C,undefined,t.buildPath($.sOriginalResourcePath,c),r,undefined,undefined,A);a.$isKeepAlive=p;t.addByPath($.mChangeRequests,P,a);return s.all([a,$.fetchTypes()]).then(function([i,n]){t.removeByPath($.mChangeRequests,P,a);if(m){return}if(!d){$.visitResponse(i,n,t.getMetaPath(t.buildPath($.sMetaPath,c)),c)}t.updateExisting($.mChangeListeners,c,e,d?{"@odata.etag":i["@odata.etag"]}:i);if(y){t.updateAll($.mChangeListeners,c,e,{"@$ui5.context.isTransient":false});t.deletePrivateAnnotation(e,"upsert")}},function(i){var n=v;if(!u&&!i.canceled){C();throw i}t.removeByPath($.mChangeRequests,P,a);if(i.canceled){throw i}l.unlock();l=undefined;u(i);if(m){return $.mEditUrl2PatchPromise[h]}switch($.oRequestor.getGroupSubmitMode(v)){case"API":break;case"Auto":if(!$.oRequestor.hasChanges(v,e)){n="$parked."+v}break;default:throw i}$.mEditUrl2PatchPromise[h]=S($.oRequestor.lockGroup(n,$,true,true),true);return $.mEditUrl2PatchPromise[h]}).finally(function(){if(l){l.unlock()}delete $.mEditUrl2PatchPromise[h]})}function A(i){t.updateAll($.mChangeListeners,c,e,b);if(l){l=t.buildPath(m.slice(0,-1).join("/"),l);const e=l.split("/");l=t.buildPath(c,l);const s=$.getValue(l);if(s===undefined){n.debug("Missing value for unit of measure "+l+" when updating "+P,$.toString(),o)}else{t.merge(i,t.makeUpdateData(e,s))}}}y=e===null;if(y){const i=c.split("/");R=i.pop();q=i.join("/");e={"@$ui5.context.isTransient":true};t.setPrivateAnnotation(e,"upsert",true);$.getValue(q)[R]=e;t.fireChanges($.mChangeListeners,c,e,false);A(b)}else{if(!e){throw new Error("Cannot update '"+r+"': '"+c+"' does not exist")}t.deleteUpdating(r,e);let n;let s=t.getPrivateAnnotation(e,"transient");if(s){if(typeof s!=="string"){throw new Error("No 'update' allowed while waiting for server response")}if(s.startsWith("$parked.")||s.startsWith("$inactive.")){n=s;s=s.slice(s.indexOf(".")+1)}if(s!==v){throw new Error("The entity will be created via group '"+s+"'. Cannot patch via group '"+v+"'")}}E=t.makeUpdateData(m,t.drillDown(e,m));const o=t.getPrivateAnnotation(e,"postBody");if(o){t.updateAll({},c,o,b)}A(s?o:b);if(s){if(n&&!e["@$ui5.context.isInactive"]){t.setPrivateAnnotation(e,"transient",s);$.oRequestor.relocate(n,o,s)}i.unlock();return Promise.resolve()}$.oRequestor.relocateAll("$parked."+v,v,e)}h+=$.oRequestor.buildQueryString($.sMetaPath,$.mQueryOptions,true);return S(i)});if(y){g?.(v)}return v};f.prototype.visitResponse=function(e,i,n,s,r,o){var u,c=false,l={},d=this.oRequestor.getServiceUrl()+this.sResourcePath,f=this;function p(e,i,n){c=true;if(e&&e.length){f.checkSharedRequest();l[i]=e;e.forEach(function(e){e.longtextUrl&&=t.makeAbsolute(e.longtextUrl,n)})}}function g(e,i){return i?t.makeAbsolute(i,e):e}function P(e,i,n,s){var o={},a,h,c,l;for(l=0;l<e.length;l+=1){h=e[l];a=n===""?r+l:l;if(h&&typeof h==="object"){m(h,i,n,s,a);c=t.getPrivateAnnotation(h,"predicate");if(!n){u.push(c||""+a)}if(c){o[c]=h;e.$byPredicate=o}}}}function m(e,n,r,o,c){var l,d,y=i[n],$=y&&y[h]&&y[h].$Path,v;o=g(o,e["@odata.context"]);d=f.calculateKeyPredicate(e,i,n);if(c!==undefined){r=t.buildPath(r,d||c)}else if(d){l=a.exec(r);if(l){r=r.slice(0,-l[0].length)+d}}if(s&&!u){u=[r]}if($){v=t.drillDown(e,$.split("/"));if(v!==undefined){p(v,r,o)}}Object.keys(e).forEach(function(i){var s,a=n+"/"+i,u=e[i],h=t.buildPath(r,i);if(i.endsWith("@odata.mediaReadLink")||i.endsWith("@mediaReadLink")){e[i]=t.makeAbsolute(u,o)}if(i===$||i.includes("@")){return}if(Array.isArray(u)){u.$created=0;s=e[i+"@odata.count"];if(s){u.$count=parseInt(s)}else if(!e[i+"@odata.nextLink"]){u.$count=u.length}else{u.$count=undefined}P(u,a,h,g(o,e[i+"@odata.context"]))}else if(u&&typeof u==="object"){m(u,a,h,o)}})}if(r!==undefined){u=[];P(e.value,n||this.sMetaPath,"",g(d,e["@odata.context"]))}else if(e&&typeof e==="object"){m(e,n||this.sMetaPath,s||"",d)}if(c&&!this.bSharedRequest){if(!o){this.sReportedMessagesPath=this.sOriginalResourcePath}this.oRequestor.getModelInterface().reportStateMessages(this.sOriginalResourcePath,l,u)}};function p(e,t,i,n,s,r){f.call(this,e,t,i,n,s,r);this.iActiveElements=0;this.oBackup=null;this.sContext=undefined;this.aElements=[];this.aElements.$byPredicate={};this.aElements.$count=undefined;this.aElements.$created=0;this.aElements.$tail=undefined;this.iLimit=Infinity;this.aReadRequests=[];this.aSeparateProperties=[];this.mSeparateProperty2ReadRequests={};this.bServerDrivenPaging=false;this.oSyncPromiseAll=undefined}p.prototype=Object.create(f.prototype);p.prototype.addKeptElement=function(e){this.checkSharedRequest();this.aElements.$byPredicate[t.getPrivateAnnotation(e,"predicate")]=e};p.prototype.checkRange=function(e,t,i){var n;if(e!==this.aElements.$tail){i=Math.min(i,this.aElements.length);for(n=t;n<i;n+=1){if(this.aElements[n]!==e){throw new Error("Found data at an index being read from the back end")}}}};p.prototype.doReplaceWith=function(e,i){var n=this.aElements[e];this.checkSharedRequest();if(n&&t.hasPrivateAnnotation(n,"transientPredicate")&&!t.hasPrivateAnnotation(i,"transientPredicate")){t.setPrivateAnnotation(i,"transientPredicate",t.getPrivateAnnotation(i,"predicate"))}this.aElements[e]=i;this.addKeptElement(i)};p.prototype.drop=function(e,i,n){if(n){e+=this.aElements.$created}const s=this.aElements[e];if(s["@$ui5.context.isTransient"]){throw new Error("Must not drop a transient element")}delete this.aElements[e];delete this.aElements.$byPredicate[i];const r=t.getPrivateAnnotation(s,"transientPredicate");if(r){this.aElements.$created-=1;this.iActiveElements-=1;this.iLimit+=1;delete this.aElements.$byPredicate[r]}};p.prototype.fetchValue=function(t,i,n,r,o){var a,u=i.split("/")[0],h,c=this;t.unlock();c.registerChangeListener(i,r);if(this.aElements.$byPredicate[u]){h=s.resolve()}else if((t===e.$cached||u!=="$count")&&this.aElements[u]!==undefined){h=s.resolve(this.aElements[u])}else{if(!this.oSyncPromiseAll){a=this.aElements.$tail?this.aElements.concat(this.aElements.$tail):this.aElements;this.oSyncPromiseAll=s.all(a)}h=this.oSyncPromiseAll}return h.then(function(){return c.drillDown(c.aElements,i,t,o)})};p.prototype.fill=function(e,t,i){var n;if(!this.aElements.$count&&i>this.aElements.length&&i-t>1024){if(this.aElements.$tail&&e){throw new Error("Cannot fill from "+t+" to "+i+", $tail already in use, # of elements is "+this.aElements.length)}this.aElements.$tail=e;i=this.aElements.length}for(n=t;n<i;n+=1){this.aElements[n]=e}this.oSyncPromiseAll=undefined};p.prototype.fixDuplicatePredicate=function(e,t){};p.prototype.getExclusiveFilter=function(){var e=[],i,n,s=this;function r(n){var r;i??=s.getTypes();r=t.getKeyFilter(n,s.sMetaPath,i);if(r){e.push(r)}}for(n=0;n<this.aElements.$created;n+=1){const e=this.aElements[n];if(!e["@$ui5.context.isTransient"]){r(e)}}(this.aElements.$deleted||[]).forEach(function(e){r(s.aElements.$byPredicate[e.predicate])});return e.length?"not ("+e.sort().join(" or ")+")":undefined};p.prototype.getQueryString=function(e){var i=this.getExclusiveFilter(),n=Object.assign({},this.mQueryOptions),s=this.sQueryString,r,o;if(this.aSeparateProperties.length){if(e){delete n.$count;n.$expand={[e]:n.$expand[e]};n.$select=[];t.selectKeyProperties(n,this.getTypes()[this.sMetaPath])}else{n.$expand={...n.$expand};this.aSeparateProperties.forEach(e=>{delete n.$expand[e]});if(t.isEmptyObject(n.$expand)){delete n.$expand}}o=true;r=true}if(i){if(n.$filter){r=true}else{s+=(s?"&":"?")+"$filter="+t.encode(i,false)}n.$filter=n.$filter?"("+n.$filter+") and "+i:i}if(r){s=this.oRequestor.buildQueryString(this.sMetaPath,n,false,this.bSortExpandSelect,o)}return s};p.prototype.getResourcePathWithQuery=function(e,t,i){var n=this.aElements.$created,s=this.getQueryString(i),r=s?"&":"?",o=t-e,a=this.sResourcePath+s;if(e<n){throw new Error("Must not request created element")}e-=n;if(e>0||o<Infinity){a+=r+"$skip="+e}if(o<Infinity){a+="&$top="+o}return a};p.prototype.getValue=function(t){var i;if(!t){return this.aElements}i=this.fetchValue(e.$cached,t);if(i.isFulfilled()){return i.getResult()}i.caught()};p.prototype.handleCount=function(e,i,n,s,r,o){var a=r["@odata.count"],u=this.aElements.$created,h,c=-1,l=this.aElements.$count,d,f=r.value.length,p;s-=o;f-=o;if(a){h=parseInt(a)-o;if(o===i||n===u&&f===h){this.iLimit=c=h}else{d=this.requestCount(this.oRequestor.getUnlockedAutoCopy(e))}}if(r["@odata.nextLink"]){this.bServerDrivenPaging=true;if(s<this.aElements.length){for(p=n+f;p<s;p+=1){delete this.aElements[p]}}else{this.aElements.length=n+f}}else if(f<s-n){if(c===-1){c=l&&l-this.iActiveElements}c=Math.min(c!==undefined?c:Infinity,n-u+f);this.aElements.length=u+c;this.iLimit=c;if(!a&&c>0&&!this.aElements[c-1]){c=undefined}}if(c!==-1){t.setCount(this.mChangeListeners,"",this.aElements,c!==undefined?c+this.iActiveElements:undefined)}return d};p.prototype.handleResponse=function(e,i,n){var s,r=this.aElements,o=r.$created,a,u=0,h,c=e.value.length,l;this.sContext=e["@odata.context"];this.visitResponse(e,n,undefined,undefined,i);for(l=0;l<c;l+=1){s=e.value[l];h=t.getPrivateAnnotation(s,"predicate");if(h){a=r.$byPredicate[h];if(a){if(o&&r.lastIndexOf(a,o-1)>=0){u+=1;r[i+c-u]=undefined;continue}const e=r.indexOf(a);if(e>=0&&e!==i+l-u){const e=this.fixDuplicatePredicate(s,h);if(e){h=e;a=s}else{throw new Error("Duplicate key predicate: "+h)}}if(!a["@odata.etag"]||s["@odata.etag"]===a["@odata.etag"]){t.updateNonExisting(a,s);s=a}else if(this.hasPendingChangesForPath(h)){throw new Error("Modified on client and on server: "+this.sResourcePath+h)}}r.$byPredicate[h]=s}r[i+l-u]=s}return u};p.prototype.isDeletingInOtherGroup=function(e){return Object.values(this.aElements.$deleted||{}).some(function(t){return t.groupId!==e})};p.prototype.isMissing=function(e){return this.aElements[e]===undefined&&!(this.$tail&&this.aReadRequests.some(t=>t.iStart<=e&&e<t.iEnd))};p.prototype.keepOnlyGivenElements=function(e){var i,n=-1,s={},r=this;e.forEach(function(e){s[e]=true});i=this.aElements.filter(function(e,i){var o;if(!e){return false}if(t.hasPrivateAnnotation(e,"transient")){n=i;return false}o=t.getPrivateAnnotation(e,"predicate");if(s[o]){n=i;delete s[o];return true}r.drop(i,o);return false});this.aElements.length=n+1;Object.keys(s).forEach(function(e){i.push(r.aElements.$byPredicate[e])});return i};p.prototype.move=function(e,t,i){const n=this.aElements;function s(e,t){while(e<t){const i=n[e];n[e]=n[t];n[t]=i;e+=1;t-=1}}function r(e,t,i){s(e,t-1);s(t,i-1);s(e,i-1)}if(i>0){if(e<t){r(e,e+i,t+i)}else if(e>t){r(t,e,e+i)}}};p.prototype.read=function(e,i,n,o,a,u,h){var c=0,l,d,f,p=this.oPendingRequestsPromise||this.aElements.$tail,g,P=0,m,y=this;if(e<0){throw new Error("Illegal index "+e+", must be >= 0")}if(i<0){throw new Error("Illegal length "+i+", must be >= 0")}if(p){return p.then(function(){return y.read(e,i,n,o,a,u,h)})}if(u){e+=this.aElements.$created}for(m=0;m<this.aElements.$created;m+=1){l=this.aElements[m];if(t.getPrivateAnnotation(l,"transient")===o.getGroupId()){P+=1}if(y.oBackup&&!l["@$ui5.context.isTransient"]){c+=1}}g=r._getReadIntervals(this.aElements,e,i,this.bServerDrivenPaging?0:Math.max(n,P,c),this.aElements.$created+this.iLimit);if(P&&(g.length>1||g.length&&g[0].start>this.aElements.$created)){o.unlock();return this.oRequestor.waitForBatchResponseReceived(o.getGroupId()).then(function(){return y.read(e,i,n,y.oRequestor.getUnlockedAutoCopy(o),a)})}g.forEach(function(e){y.requestElements(e.start,e.end,o.getUnlockedCopy(),P,a,h);a=undefined});o.unlock();f=e+i+n;d=this.aElements.slice(Math.max(0,e-n),f);if(this.aElements.$tail){d.push(this.aElements.$tail)}return s.all(d).then(function(){var t=y.aElements.slice(e,e+i);t.$count=y.aElements.$count;return{"@odata.context":y.sContext,value:t}})};p.prototype.refreshKeptElements=function(e,i,n,s){var r=this,o=Object.keys(this.aElements.$byPredicate).filter(h).sort(),a;function u(){var e,i=t.clone(r.mQueryOptions);if(r.mLateQueryOptions){t.aggregateExpandSelect(i,r.mLateQueryOptions)}if(s){delete i.$apply}delete i.$count;delete i.$orderby;delete i.$search;e=o.map(function(e){return t.getKeyFilter(r.aElements.$byPredicate[e],r.sMetaPath,a)});i.$filter=e.join(" or ");if(e.length>1){i.$top=e.length}return r.sResourcePath+r.oRequestor.buildQueryString(r.sMetaPath,i,false,true)}function h(e){var i=r.aElements.$byPredicate[e];return t.getPrivateAnnotation(i,"predicate")===e&&Object.keys(i).length>1&&!i["@$ui5.context.isDeleted"]&&!r.hasPendingChangesForPath(e,n)}this.checkSharedRequest();if(o.length===0){return undefined}a=this.getTypes();return this.oRequestor.request("GET",u(),e).then(function(e){var n;r.visitResponse(e,a,undefined,undefined,0);n=e.value.$byPredicate||{};o.forEach(function(e){var s,o;if(e in n){t.updateAll(r.mChangeListeners,e,r.aElements.$byPredicate[e],n[e])}else{s=r.aElements.$byPredicate[e];if(t.hasPrivateAnnotation(s,"transientPredicate")){o=r.removeElement(-1,e)}else{delete r.aElements.$byPredicate[e]}i(e,o)}})})};p.prototype.refreshSingleNoCollection=function(e,i){return this.requestSideEffects(e.getUnlockedCopy(),[t.getMetaPath(i)],[i.split("/")[0]],true)};p.prototype.removeKeptElement=function(e){this.checkSharedRequest();delete this.aElements.$byPredicate[e]};p.prototype.requestElements=function(e,t,i,n,r,o){var a,u={iEnd:t,bObsolete:false,iStart:e},h=this;this.aReadRequests.push(u);this.bSentRequest=true;a=s.all([this.mQueryOptions.$filter==="false"?Promise.resolve({"@odata.count":"0",value:[]}):this.oRequestor.request("GET",this.getResourcePathWithQuery(e,t),i,undefined,undefined,r),this.fetchTypes()]).then(function(e){var t;if(u.bObsolete){const e=new Error("Request is obsolete");e.canceled=true;throw e}h.checkRange(a,u.iStart,u.iEnd);if(h.aElements.$tail===a){h.aElements.$tail=undefined}t=h.handleResponse(e[0],u.iStart,e[1]);return h.handleCount(i,n,u.iStart,u.iEnd,e[0],t)},function(e){if(!e.canceled&&!u.bObsolete){h.checkRange(a,u.iStart,u.iEnd);h.fill(undefined,u.iStart,u.iEnd)}throw e}).finally(function(){h.aReadRequests.splice(h.aReadRequests.indexOf(u),1)});this.requestSeparateProperties(e,t,a,o);this.fill(a,e,t);return a};p.prototype.requestFilteredOrderedPredicates=async function(e,i,n){this.checkSharedRequest();const s=this.getTypes();const r=e.map(e=>t.getKeyFilter(this.aElements.$byPredicate[e],this.sMetaPath,s));const o={...this.mQueryOptions};delete o.$count;o.$filter=o.$filter?`${o.$filter} and (${r.join(" or ")})`:r.join(" or ");o.$top=r.length;if(n){delete o.$expand;delete o.$orderby;o.$select=[];t.selectKeyProperties(o,s[this.sMetaPath])}const a=this.sResourcePath+this.oRequestor.buildQueryString(this.sMetaPath,o,false,true,true);const u=await this.oRequestor.request("GET",a,i);this.visitResponse(u,s,undefined,undefined,0);return u.value.map(e=>{const i=t.getPrivateAnnotation(e,"predicate");if(!n){const n=this.aElements.$byPredicate[i];t.copySelected(n,e);this.aElements.$byPredicate[i]=e;this.aElements[this.aElements.indexOf(n)]=e;t.fireChanges(this.mChangeListeners,i,n,true);t.fireChanges(this.mChangeListeners,i,e)}return i})};p.prototype.requestSeparateProperties=async function(e,i,r,a){if(!this.aSeparateProperties.length){return}const u=await this.fetchTypes();this.aSeparateProperties.forEach(async h=>{let c;let l;const d={start:e,end:i,promise:new s(function(e,t){c=e;l=function(){const e=new Error("$$separate: canceled "+h);e.canceled=true;t(e)}})};d.promise.catch(()=>{});try{this.mSeparateProperty2ReadRequests[h].push(d);const s=this.getResourcePathWithQuery(e,i,h);const f=await this.oRequestor.request("GET",s,this.oRequestor.lockGroup("$single",this));let p;await r.catch(()=>{p=true});const g=this.mSeparateProperty2ReadRequests[h].indexOf(d);if(g<0){l();return}this.mSeparateProperty2ReadRequests[h].splice(g,1);if(p){l();return}this.visitResponse(f,u,undefined,undefined,e);for(const e of f.value){const i=t.getPrivateAnnotation(e,"predicate");const r=this.aElements.$byPredicate[i];if(r){if(r["@odata.etag"]===e["@odata.etag"]){t.updateSelected(this.mChangeListeners,i,r,e,[h])}else{n.error(`ETag changed: ${this.sResourcePath+i}`,s,o)}}}c();a(h,e,i)}catch(t){l();a(h,e,i,t)}})};p.prototype.requestSideEffects=function(e,i,n,r,o){var a,u,h,c,l,d=this.getTypes(),f=this;function p(e,n=t.getPrivateAnnotation(e,"predicate")){f.beforeUpdateSelected?.(n,e);t.updateSelected(f.mChangeListeners,n,f.aElements.$byPredicate[n],e,i,function e(s){s=s.slice(n.length+1);return!i.some(function(e){return t.getRelativePath(s,e)!==undefined})})}this.checkSharedRequest();h=t.intersectQueryOptions(Object.assign({},this.mQueryOptions,this.mLateQueryOptions),i,this.oRequestor.getModelInterface().fetchMetadata,this.sMetaPath,"",o);if(!h){return s.resolve()}this.beforeRequestSideEffects?.(h);delete h.$count;delete h.$orderby;delete h.$search;if(r){delete h.$filter}else{a=this.keepOnlyGivenElements(n);if(!a.length){return s.resolve()}h.$filter=a.map(function(e){return t.getKeyFilter(e,f.sMetaPath,d)}).sort().join(" or ");if(a.length>1){h.$top=a.length}t.selectKeyProperties(h,d[this.sMetaPath])}u=t.extractMergeableQueryOptions(h);c=this.sResourcePath+(r?n[0]:"")+this.oRequestor.buildQueryString(this.sMetaPath,h,false,true);return this.oRequestor.request("GET",c,e,undefined,undefined,undefined,undefined,this.sMetaPath,undefined,false,u,this,function(e){if(arguments.length){i=i.concat(e)}else{l=true;return i}}).then(function(e){if(l){return}if(r){f.visitResponse(e,d,undefined,n[0],undefined,true);p(e,n[0])}else{if(e.value.length!==a.length){throw new Error("Expected "+a.length+" row(s), but instead saw "+e.value.length)}f.visitResponse(e,d,undefined,"",NaN,true);for(let t=0,i=e.value.length;t<i;t+=1){p(e.value[t])}}})};p.prototype.reset=function(e,i,n,s,r){var o=this.aElements.$byPredicate,a=this.mChangeListeners,u=0,h,c,l,d=this;if(i){this.checkSharedRequest();this.oBackup={iActiveElements:this.iActiveElements,mChangeListeners:this.mChangeListeners,sContext:this.sContext,aElements:this.aElements.slice(),$byPredicate:o,$count:this.aElements.$count,$created:this.aElements.$created,iLimit:this.iLimit}}if(n){this.setQueryOptions(n,true)}for(l=0;l<this.aElements.$created;l+=1){h=this.aElements[l];c=t.getPrivateAnnotation(h,"transient");if(i?"@$ui5.context.isInactive"in h||c&&c!==i:c){e.push(t.getPrivateAnnotation(h,"predicate")||t.getPrivateAnnotation(h,"transientPredicate"));this.aElements[u]=h;u+=1}else{this.iActiveElements-=1}}Object.keys(o).forEach(function(t){if("@$ui5.context.isDeleted"in o[t]){e.push(t)}});this.mChangeListeners={};this.sContext=undefined;this.aElements.length=this.aElements.$created=u;this.aElements.$byPredicate={};this.aElements.$count=undefined;this.iLimit=Infinity;Object.keys(a).forEach(function(t){if(t==="$count"||e.includes(t.split("/")[0])){d.mChangeListeners[t]=a[t]}});e.forEach(function(e){d.aElements.$byPredicate[e]=o[e]});this.aReadRequests?.forEach(e=>{e.bObsolete=true});for(const e in this.mSeparateProperty2ReadRequests){this.mSeparateProperty2ReadRequests[e]=[]}if(a[""]){this.mChangeListeners[""]=a[""];t.fireChange(this.mChangeListeners,"")}Object.values(this.aElements.$deleted||{}).forEach(function(e){e.index=undefined})};p.prototype.restore=function(e){if(e){this.checkSharedRequest();this.iActiveElements=this.oBackup.iActiveElements;this.mChangeListeners=this.oBackup.mChangeListeners;this.sContext=this.oBackup.sContext;this.aElements.length=this.oBackup.aElements.length;this.oBackup.aElements.forEach(function(e,t){this[t]=e},this.aElements);this.aElements.$byPredicate=this.oBackup.$byPredicate;this.aElements.$count=this.oBackup.$count;this.aElements.$created=this.oBackup.$created;this.iLimit=this.oBackup.iLimit}this.oBackup=null};p.prototype.setEmpty=function(){if(this.iLimit!==Infinity||this.aElements.$count!==undefined||this.aElements.length){throw new Error("Unsupported")}this.iLimit=this.aElements.$count=0};p.prototype.setInactive=function(e,i){const n=this.getValue(e);t.updateAll(this.mChangeListeners,e,n,{"@$ui5.context.isInactive":i});if(!i){t.deletePrivateAnnotation(n,"initialData");this.iActiveElements+=1;t.addToCount(this.mChangeListeners,"",this.aElements,1)}};p.prototype.setPersistedCollection=function(e){this.aElements=e;this.iActiveElements=e.$created;this.iLimit=e.length};p.prototype.setSeparate=function(e=[]){this.aSeparateProperties=e;this.aSeparateProperties.forEach(e=>{this.mSeparateProperty2ReadRequests[e]=[]})};function g(e,t,i){f.call(this,e,t,i);this.oPromise=null}g.prototype=Object.create(f.prototype);g.prototype._delete=function(){throw new Error("Unsupported")};g.prototype.create=function(){throw new Error("Unsupported")};g.prototype.fetchValue=function(e,t,i,n,r){var o=this;if(r){throw new Error("Unsupported argument: bCreateOnDemand")}if(this.oPromise){e.unlock()}else{this.bSentRequest=true;this.oPromise=s.resolve(this.oRequestor.request("GET",this.sResourcePath+this.sQueryString,e,undefined,undefined,i,undefined,this.sMetaPath))}o.registerChangeListener("",n);return this.oPromise.then(function(e){return e&&typeof e==="object"?e.value:e})};g.prototype.update=function(){throw new Error("Unsupported")};function P(e,t,i,n,r,o,a,u,h){f.call(this,e,t,i,n,o,r);this.sMetaPath=u||this.sMetaPath;this.bPost=a;this.bPosting=false;if(h){this.oPromise=s.resolve({})}else{this.oPromise=null}}P.prototype=Object.create(f.prototype);P.prototype.buildOriginalResourcePath=function(e,t,i){if(i){this.calculateKeyPredicate(e,t,this.sMetaPath);this.sOriginalResourcePath=i(e)}};P.prototype.fetchValue=function(e,t,i,n,r,o){var a=this.sResourcePath+this.sQueryString,u=this;this.registerChangeListener(t,n);if(this.oPromise){e.unlock()}else{if(this.bPost){throw new Error("Cannot fetch a value before the POST request")}this.oPromise=s.all([this.oRequestor.request("GET",a,e,undefined,undefined,i,undefined,this.sMetaPath),this.fetchTypes()]).then(function(e){u.buildOriginalResourcePath(e[0],e[1],o);u.visitResponse(e[0],e[1]);return e[0]});this.bSentRequest=true}return this.oPromise.then(function(i){if(i&&i["$ui5.deleted"]){throw new Error("Cannot read a deleted entity")}return u.drillDown(i,t,e,r)})};P.prototype.getValue=function(t){var i;if(this.oPromise&&this.oPromise.isFulfilled()){i=this.drillDown(this.oPromise.getResult(),t,e.$cached);if(i.isFulfilled()){return i.getResult()}i.caught()}};P.prototype.post=function(e,i,n,r,o,a){var u,h={},c="POST",l,d=this;function f(){l=d.oRequestor.lockGroup(u,d,true)}function p(e){d.bPosting=true;return s.all([d.oRequestor.request(c,d.sResourcePath+d.sQueryString,e,h,i,n&&u!=="$single"&&f,undefined,undefined,"R#V#C"),d.fetchTypes()]).then(function(e){d.buildOriginalResourcePath(e[0],e[1],a);const i=t.getPrivateAnnotation(e[0],"headerMessages");if(i){d.oRequestor.getModelInterface().reportTransitionMessages(i,d.sResourcePath,false,d.sOriginalResourcePath);t.deletePrivateAnnotation(e[0],"headerMessages")}d.visitResponse(e[0],e[1]);if(d.mQueryOptions&&d.mQueryOptions.$select){t.updateSelected({},"",e[0],e[0],d.mQueryOptions.$select)}d.bPosting=false;if(l){l.unlock()}return e[0]},function(t){d.bPosting=false;if(l){l.unlock();l=undefined}if(o&&t.strictHandlingFailed){return o(t).then(function(t){var i;if(t){delete h["Prefer"];return p(e.getUnlockedCopy())}i=Error("Action canceled due to strict handling");i.canceled=true;throw i})}throw t})}this.checkSharedRequest();if(!this.bPost){throw new Error("POST request not allowed")}if(this.bPosting){throw new Error("Parallel POST requests not allowed")}if(n){u=e.getGroupId();this.oRequestor.relocateAll("$parked."+u,u,n)}if(i){c=i["X-HTTP-Method"]||c;delete i["X-HTTP-Method"];if(this.oRequestor.isActionBodyOptional()&&t.isEmptyObject(i)){i=undefined}}if(n&&!("@odata.etag"in n)){r=false}if(r||n){h["If-Match"]=r?"*":n}if(o){h["Prefer"]="handling=strict"}this.bSentRequest=true;this.oPromise=p(e);return this.oPromise};P.prototype.refreshSingleNoCollection=function(e,i){return this.requestSideEffects(e.getUnlockedCopy(),[t.getMetaPath(i)])};P.prototype.requestSideEffects=function(i,n,r){var o,a,u,h,c=this;this.checkSharedRequest();a=this.oPromise&&t.intersectQueryOptions(Object.assign({},this.mQueryOptions,this.mLateQueryOptions),n,this.oRequestor.getModelInterface().fetchMetadata,this.sMetaPath);if(!a){return s.resolve()}if(this.oPromise.isRejected()){throw new Error(this+": Cannot call requestSideEffects, cache is broken: "+this.oPromise.getResult().message)}o=t.extractMergeableQueryOptions(a);r=(r||this.sResourcePath)+this.oRequestor.buildQueryString(this.sMetaPath,a,false,true);u=s.all([this.oRequestor.request("GET",r,i,undefined,undefined,undefined,undefined,this.sMetaPath,undefined,false,o,this,function(e){if(arguments.length){n=n.concat(e)}else{h=true;return n}}),this.fetchTypes(),this.fetchValue(e.$cached,"")]).then(function(e){return e}).then(function(e){var i=e[0],s=e[2];if(h){return}t.setPrivateAnnotation(i,"predicate",t.getPrivateAnnotation(s,"predicate"));c.visitResponse(i,e[1]);t.updateSelected(c.mChangeListeners,"",s,i,n,function(e){return!n.some(function(i){return t.getRelativePath(e,i)!==undefined})})});return u};P.prototype.resetProperty=function(e){var t=this.oPromise.getResult();if(t){e.split("/").some(function(e){delete t["@odata.etag"];if(typeof t[e]==="object"){t=t[e];return false}delete t[e];return true})}};function m(e,t,i){var n=t.split("/"),s=n[0],r=s+JSON.stringify(i),o;g.call(this,e,t,{});o=e.$mSingletonCacheByPath??={};this.oSingleton=o[r]??=new P(e,s,i,undefined,undefined,undefined,undefined,undefined,true);this.sRelativePath=t.split(s+"/")[1]}m.prototype=Object.create(g.prototype);m.prototype.fetchValue=function(e,i,n,s,r){var o=this.oSingleton.sResourcePath+"/"+this.sRelativePath,a,u=this.oMetadataPromise||this.oRequestor.getModelInterface().fetchMetadata("/"+t.getMetaPath(o)),h=this;return u.then(function(){if(!h.oMetadataPromise){a=h.oSingleton.getLateQueryOptions()||{};t.aggregateExpandSelect(a,t.wrapChildQueryOptions("/"+h.oSingleton.sResourcePath,h.sRelativePath,{},h.oRequestor.getModelInterface().fetchMetadata));h.oSingleton.setLateQueryOptions(a)}h.oMetadataPromise=u;return h.oSingleton.fetchValue(e,h.sRelativePath,n,s,r)})};m.prototype.reset=function(){this.oSingleton.resetProperty(this.sRelativePath)};f.create=function(e,i,n,s,r,o){var a,u,h,c,l;if(o){h=i+e.buildQueryString(t.getMetaPath("/"+i),n,false,s);l=e.$mSharedCollectionCacheByPath??={};c=l[h];if(c){c.setActive(true)}else{u=Object.keys(l);a=u.length;if(a>100){u.filter(function(e){return!l[e].iActiveUsages}).sort(function(e,t){return l[e].iInactiveSince-l[t].iInactiveSince}).every(function(e){delete l[e];a-=1;return a>100})}c=l[h]=new p(e,i,n,s,r,o)}return c}return new p(e,i,n,s,r,o)};f.createProperty=function(e,t,i){if(t.includes("(")||t.endsWith("/$count")){return new g(e,t,i)}return new m(e,t,i)};f.createSingle=function(e,t,i,n,s,r,o,a){return new P(e,t,i,n,s,r,o,a)};f.from$skip=function(e,t){return c.test(e)?(t.$created||0)+Number(e):e};f.getElementIndex=function(e,i,n){var s=e[n];if(!s||t.getPrivateAnnotation(s,"predicate")!==i){n=e.indexOf(e.$byPredicate[i])}return n};return f},false);
//# sourceMappingURL=_Cache.js.map