/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["./_Batch","./_GroupLock","./_Helper","./_V2Requestor","sap/base/Log","sap/ui/base/SyncPromise","sap/ui/core/cache/CacheManager","sap/ui/security/Security","sap/ui/thirdparty/jquery"],function(e,t,r,n,o,i,s,a,jQuery){"use strict";var u={Accept:"multipart/mixed"},c="sap.ui.model.odata.v4.optimisticBatch:",h="sap.ui.model.odata.v4.lib._Requestor",f="@com.sap.vocabularies.Common.v1.Messages",p=/(\$\w+)=~/g,d=/^\d+$/;function l(e){var t=Object.assign({},e);delete t["X-CSRF-Token"];return t}function m(e){var t;e=e.toLowerCase();for(t in this.headers){if(t.toLowerCase()===e){return this.headers[t]}}}function y(e,t,n,o,i){this.mBatchQueue={};this.bBatchSent=false;this.mHeaders=t||{};this.aLockedGroupLocks=[];this.oModelInterface=o;this.oOptimisticBatch=null;this.sQueryParams=r.buildQuery(n);this.mRunningChangeRequests={};this.iSessionTimer=0;this.iSerialNumber=0;this.sServiceUrl=e;this.vStatistics=n&&n["sap-statistics"];this.bWithCredentials=i;this.processSecurityTokenHandlers()}y.prototype.mFinalHeaders={"Content-Type":"application/json;charset=UTF-8;IEEE754Compatible=true"};y.prototype.mPredefinedPartHeaders={Accept:"application/json;odata.metadata=minimal;IEEE754Compatible=true"};y.prototype.mPredefinedRequestHeaders={Accept:"application/json;odata.metadata=minimal;IEEE754Compatible=true","OData-MaxVersion":"4.0","OData-Version":"4.0","X-CSRF-Token":"Fetch"};y.prototype.mReservedHeaders={accept:true,"accept-charset":true,"content-encoding":true,"content-id":true,"content-language":true,"content-length":true,"content-transfer-encoding":true,"content-type":true,"if-match":true,"if-none-match":true,isolation:true,"odata-isolation":true,"odata-maxversion":true,"odata-version":true,prefer:true,"sap-contextid":true};y.prototype.addChangeSet=function(e){var t=[],r=this.getOrCreateBatchQueue(e,true);t.iSerialNumber=this.getSerialNumber();r.iChangeSet+=1;r.splice(r.iChangeSet,0,t)};y.prototype.addChangeToGroup=function(e,t){var r;if(this.getGroupSubmitMode(t)==="Direct"){e.$resolve(this.request(e.method,e.url,this.lockGroup(t,this,true,true),e.headers,e.body,e.$submit,e.$cancel))}else{r=this.getOrCreateBatchQueue(t);r[r.iChangeSet].push(e)}};y.prototype.addQueryString=function(e,t,n){var o;n=this.convertQueryOptions(t,n,false,true);e=e.replace(p,function(e,t){var o=n[t];delete n[t];return r.encodePair(t,o)});o=r.buildQuery(n);if(!o){return e}return e+(e.includes("?")?"&"+o.slice(1):o)};y.prototype.batchRequestSent=function(e,t,r){var n,o;if(r){if(!(e in this.mRunningChangeRequests)){this.mRunningChangeRequests[e]=[]}n=new i(function(e){o=e});n.$resolve=o;n.$requests=t;this.mRunningChangeRequests[e].push(n)}};y.prototype.batchResponseReceived=function(e,t,r){var n;if(r){n=this.mRunningChangeRequests[e].filter(function(e){if(e.$requests===t){e.$resolve();return false}return true});if(n.length){this.mRunningChangeRequests[e]=n}else{delete this.mRunningChangeRequests[e]}}};y.prototype.buildQueryString=function(e,t,n,o,i){return r.buildQuery(this.convertQueryOptions(e,t,n,o),i)};y.prototype.cancelChanges=function(e,t){if(this.mRunningChangeRequests[e]){throw new Error("Cannot cancel the changes for group '"+e+"', the batch request is running")}this.cancelChangesByFilter(function(){return true},e,t);this.cancelGroupLocks(e)};y.prototype.cancelChangesByFilter=function(e,t,r){var n=false,o=this;function i(t){var i=o.mBatchQueue[t],s,a,u,c,h;for(h=i.length-1;h>=0;h-=1){if(Array.isArray(i[h])){a=i[h];for(c=a.length-1;c>=0;c-=1){s=a[c];if(s.$cancel&&e(s)){if(!s.$cancel(r)){u=new Error("Request canceled: "+s.method+" "+s.url+"; group: "+t);u.canceled=true;s.$reject(u);a.splice(c,1);n=true}}}}}}if(t){if(this.mBatchQueue[t]){i(t)}}else{for(t in this.mBatchQueue){i(t)}}return n};y.prototype.cancelGroupLocks=function(e){this.aLockedGroupLocks.forEach(function(t){if((!e||e===t.getGroupId())&&t.isModifying()&&t.isLocked()){t.cancel()}})};y.prototype.checkConflictingStrictRequest=function(e,t,r){function n(e,t){return r!==t&&e.some(o)}function o(e){return e.headers.Prefer==="handling=strict"}if(o(e)&&t.slice(0,t.iChangeSet+1).some(n)){throw new Error("All requests with strict handling must belong to the same change set")}};y.prototype.checkForOpenRequests=function(){var e=this;if(!r.isEmptyObject(this.mRunningChangeRequests)||Object.keys(this.mBatchQueue).some(function(t){return e.mBatchQueue[t].some(function(e){return Array.isArray(e)?e.length:true})})||this.aLockedGroupLocks.some(function(e){return e.isLocked()})){throw new Error("Unexpected open requests")}};y.prototype.checkHeaderNames=function(e){var t;for(t in e){if(this.mReservedHeaders[t.toLowerCase()]){throw new Error("Unsupported header: "+t)}}};y.prototype.cleanUpChangeSets=function(e){var t,n=false,o;function i(e){if(!s(e)){if(e.method==="DELETE"&&e.headers["If-Match"]&&e.headers["If-Match"]["@odata.etag"]&&t.find(function(t){return t.headers["If-Match"]===e.headers["If-Match"]})){e.headers["If-Match"]={"@odata.etag":"*"}}t.push(e)}}function s(e){if(e.method!=="PATCH"){return false}return t.some(function(t){if(t.method==="PATCH"&&t.headers["If-Match"]===e.headers["If-Match"]){r.merge(t.body,e.body);e.$resolve(t.$promise);t.$mergeRequests(e.$mergeRequests());return true}})}for(o=e.iChangeSet;o>=0;o-=1){t=[];e[o].forEach(i);if(t.length===0){e.splice(o,1)}else if(t.length===1&&this.isChangeSetOptional()){e[o]=t[0]}else{e[o]=t}n||=t.length>0}return n};y.prototype.clearSessionContext=function(e){if(e){this.oModelInterface.fireSessionTimeout()}delete this.mHeaders["SAP-ContextId"];if(this.iSessionTimer){clearInterval(this.iSessionTimer);this.iSessionTimer=0}};y.prototype.convertExpand=function(e,t){var r,n=[],o=this;if(!e||typeof e!=="object"){throw new Error("$expand must be a valid object")}r=Object.keys(e);if(t){r=r.sort()}r.forEach(function(r){var i=e[r];if(i&&typeof i==="object"){n.push(o.convertExpandOptions(r,i,t))}else{n.push(r)}});return n.join(",")};y.prototype.convertExpandOptions=function(e,t,r){var n=[];this.doConvertSystemQueryOptions(undefined,t,function(e,t){n.push(e+"="+t)},undefined,r);return n.length?e+"("+n.join(";")+")":e};y.prototype.convertQueryOptions=function(e,t,r,n){var o={};if(!t){return undefined}this.doConvertSystemQueryOptions(e,t,function(e,t){o[e]=t},r,n);return o};y.prototype.convertResourcePath=function(e){return e};y.prototype.destroy=function(){this.clearSessionContext()};y.prototype.doCheckVersionHeader=function(e,t,r){var n=e("OData-Version"),o=!n&&e("DataServiceVersion");if(o){throw new Error("Expected 'OData-Version' header with value '4.0' but received"+" 'DataServiceVersion' header with value '"+o+"' in response for "+this.sServiceUrl+t)}if(n==="4.0"||!n&&r){return}throw new Error("Expected 'OData-Version' header with value '4.0' but received value '"+n+"' in response for "+this.sServiceUrl+t)};y.prototype.doConvertResponse=function(e,t){return e};y.prototype.doConvertSystemQueryOptions=function(e,t,n,o,i){var s=this;Object.keys(t).forEach(function(e){var a=t[e];if(o&&e[0]==="$"){return}switch(e){case"$expand":if(a!=="~"){a=s.convertExpand(a,i)}break;case"$select":if(Array.isArray(a)){if(i){a=a.slice().sort();for(let e=1;e<a.length;){if(r.hasPathPrefix(a[e],a[e-1])){a.splice(e,1)}else{e+=1}}}a=a.join(",")}break;default:}n(e,a)})};y.prototype.fetchType=function(e,t){var r=this;if(t in e){return i.resolve(e[t])}return this.fetchTypeForPath(t).then(function(n){var o,s=[];if(n){o=r.getModelInterface().fetchMetadata(t+"/"+f).getResult();if(o){n=Object.create(n);n[f]=o}e[t]=n;(n.$Key||[]).forEach(function(n){if(typeof n==="object"){n=n[Object.keys(n)[0]];s.push(r.fetchType(e,t+"/"+n.slice(0,n.lastIndexOf("/"))))}});return i.all(s).then(function(){return n})}})};y.prototype.fetchTypeForPath=function(e){return this.oModelInterface.fetchMetadata(e+"/")};y.prototype.formatPropertyAsLiteral=function(e,t){return r.formatLiteral(e,t.$Type)};y.prototype.getGroupSubmitMode=function(e){return this.oModelInterface.getGroupProperty(e,"submit")};y.prototype.getModelInterface=function(){return this.oModelInterface};y.prototype.getOrCreateBatchQueue=function(e,t){var r,n=this.mBatchQueue[e];if(!n){r=[];r.iSerialNumber=0;n=this.mBatchQueue[e]=[r];n.iChangeSet=0;if(!t){this.oModelInterface.onCreateGroup(e)}}return n};y.prototype.getPathAndAddQueryOptions=function(e,t,r){var n=[],o,i={},s=this;e=e.slice(1,-5);if(t.$Parameter){t.$Parameter.forEach(function(e){i[e.$Name]=e})}if(t.$kind==="Function"){for(o in r){const e=i[o];if(e){if(e.$isCollection){throw new Error("Unsupported collection-valued parameter: "+o)}n.push(encodeURIComponent(o)+"="+encodeURIComponent(s.formatPropertyAsLiteral(r[o],e)))}}e+="("+n.join(",")+")"}else{for(o in r){if(!(o in i)){delete r[o]}}}return e};y.prototype.getSerialNumber=function(){this.iSerialNumber+=1;return this.iSerialNumber};y.prototype.getServiceUrl=function(){return this.sServiceUrl};y.prototype.getUnlockedAutoCopy=function(e){if(this.getGroupSubmitMode(e.getGroupId())!=="API"){return e.getUnlockedCopy()}return this.lockGroup("$auto",e.getOwner())};y.prototype.hasChanges=function(e,t){var r=this.mBatchQueue[e];if(r){return r.some(function(e){return Array.isArray(e)&&e.some(function(e){return e.headers["If-Match"]===t})})}return false};y.prototype.hasOnlyPatchesWithoutSideEffects=function(e){return this.getGroupSubmitMode(e)==="Auto"&&!!this.mBatchQueue[e]&&this.mBatchQueue[e].every(function(e){return Array.isArray(e)&&e.every(function(e){return e.method==="PATCH"&&e.headers.Prefer==="return=minimal"})})};y.prototype.hasPendingChanges=function(e){var t=this;function r(t){if(!e){return Object.keys(t)}return e in t?[e]:[]}return r(this.mRunningChangeRequests).length>0||this.aLockedGroupLocks.some(function(t){var r=t.getGroupId();return(e===undefined||r===e)&&t.isModifying()&&t.isLocked()&&!r.startsWith("$inactive.")})||r(this.mBatchQueue).some(function(e){return!e.startsWith("$inactive.")&&t.mBatchQueue[e].some(function(e){return Array.isArray(e)&&e.some(function(e){return e.$cancel})})})};y.prototype.isActionBodyOptional=function(){return false};y.prototype.isBatchSent=function(){return this.bBatchSent};y.prototype.isChangeSetOptional=function(){return true};y.prototype.lockGroup=function(e,r,n,o,i){var s;s=new t(e,r,n,o,this.getSerialNumber(),i);if(n){this.aLockedGroupLocks.push(s)}return s};y.prototype.mergeGetRequests=function(e){var t=[],n=this;function o(e){return e.$queryOptions&&t.some(function(t){if(t.$queryOptions&&e.url===t.url&&e.$owner===t.$owner){t.$queryOptions=r.clone(t.$queryOptions);r.aggregateExpandSelect(t.$queryOptions,e.$queryOptions);e.$resolve(t.$promise);if(t.$mergeRequests&&e.$mergeRequests){t.$mergeRequests(e.$mergeRequests())}return true}return false})}e.forEach(function(e){if(!o(e)){t.push(e)}});t.forEach(function(e){var t=e.$queryOptions;if(t){if(t.$expand&&!t.$select.length){t.$select=Object.keys(t.$expand).sort().slice(0,1)}e.url=n.addQueryString(e.url,e.$metaPath,t)}});t.iChangeSet=e.iChangeSet;if(e.bContinueOnError){t.bContinueOnError=true}return t};y.prototype.processBatch=function(e){var t,n=this.mBatchQueue[e]||[],o=this;function i(e){if(Array.isArray(e)){e.forEach(i)}else if(e.$submit){e.$submit()}}function s(e,t){if(Array.isArray(t)){t.forEach(s.bind(null,e))}else{t.$reject(e)}}function a(e,t){var n;e.forEach(function(e,i){var u,c,h=t[i];if(Array.isArray(h)){a(e,h)}else if(!h){const t=new Error("HTTP request was not processed because the previous request failed");t.cause=n;t.$reported=true;s(t,e)}else if(h.status>=400){o.oModelInterface.onHttpResponse(h.headers);h.getResponseHeader=m;n=r.createError(h,"Communication error",e.url?o.sServiceUrl+e.url:undefined,e.$resourcePath);if(Array.isArray(e)){r.decomposeError(n,e,o.sServiceUrl).forEach(function(t,r){e[r].$reject(t)})}else{e.$reject(n)}}else{o.oModelInterface.onHttpResponse(h.headers);if(h.responseText){try{o.doCheckVersionHeader(m.bind(h),e.url,true);c=o.doConvertResponse(JSON.parse(h.responseText),e.$metaPath)}catch(t){e.$reject(t);return}}else{c=e.method==="GET"?null:{}}o.reportHeaderMessages(e.$resourcePath,m.call(h,"sap-messages"),c);u=m.call(h,"ETag");if(u){c["@odata.etag"]=u}e.$resolve(c)}})}i(n);delete this.mBatchQueue[e];t=this.cleanUpChangeSets(n);if(n.length===0){return Promise.resolve()}this.bBatchSent=true;n=this.mergeGetRequests(n);this.batchRequestSent(e,n,t);return this.sendBatch(n,e,t).then(function(e){a(n,e)}).catch(function(e){var t=new Error("HTTP request was not processed because $batch failed");t.cause=e;t.$reported=true;s(t,n);throw e}).finally(function(){o.batchResponseReceived(e,n,t)})};y.prototype.processOptimisticBatch=function(e,t){var r,n,i=this.oOptimisticBatch,a,u=this;if(!i){return}a=this.oModelInterface.getOptimisticBatchEnabler();n=i.key;this.oOptimisticBatch=null;if(i.result){if(y.matchesOptimisticBatch(e,t,i.firstBatch.requests,i.firstBatch.groupId)){if(a){Promise.resolve(a(n)).then(async e=>{if(!e){await s.del(c+n);o.info("optimistic batch: disabled, batch payload deleted",n,h)}}).catch(u.oModelInterface.getReporter())}o.info("optimistic batch: success, response consumed",n,h);return i.result}o.warning("optimistic batch: mismatch, response skipped",n,h);s.del(c+n).catch(this.oModelInterface.getReporter())}if(a){r=e.some(function(e){return Array.isArray(e)||e.method!=="GET"});if(r){o.warning("optimistic batch: modifying batch not supported",n,h);return}Promise.resolve(a(n)).then(function(r){if(r){return s.set(c+n,{groupId:t,requests:e.map(function(e){return{headers:l(e.headers),method:"GET",url:e.url}})}).then(function(){o.info("optimistic batch: enabled, batch payload saved",n,h)})}o.info("optimistic batch: disabled",n,h)}).catch(u.oModelInterface.getReporter())}};y.prototype.processSecurityTokenHandlers=function(){var e=this;this.oSecurityTokenPromise=null;a.getSecurityTokenHandlers().some(function(t){var r=t(e.sServiceUrl);if(r!==undefined){e.oSecurityTokenPromise=r.then(function(t){e.checkHeaderNames(t);Object.assign(e.mHeaders,{"X-CSRF-Token":undefined},t);e.oSecurityTokenPromise=null}).catch(function(e){o.error("An error occurred within security token handler: "+t,e,h);throw e});return true}})};y.prototype.ready=function(){return i.resolve()};y.prototype.refreshSecurityToken=function(e){var t=this;if(!this.oSecurityTokenPromise){if(e!==this.mHeaders["X-CSRF-Token"]){return Promise.resolve()}this.oSecurityTokenPromise=new Promise(function(e,n){const o={method:"HEAD",headers:Object.assign({},t.mHeaders,{"X-CSRF-Token":"Fetch"})};if(t.bWithCredentials){o.xhrFields={withCredentials:true}}jQuery.ajax(t.sServiceUrl+t.sQueryParams,o).then(function(n,o,i){var s=i.getResponseHeader("X-CSRF-Token");if(s){t.mHeaders["X-CSRF-Token"]=s}else{delete t.mHeaders["X-CSRF-Token"]}t.oSecurityTokenPromise=null;t.oModelInterface.onHttpResponse(r.parseRawHeaders(i.getAllResponseHeaders()));e()},function(o){t.oSecurityTokenPromise=null;if(o.status===503&&o.getResponseHeader("Retry-After")){e()}else{n(r.createError(o,"Could not refresh security token"))}})})}return this.oSecurityTokenPromise};y.prototype.relocate=function(e,t,r){var n=this.mBatchQueue[e],o=this,i=n&&n[0].some(function(e,i){if(e.body===t){o.addChangeToGroup(e,r);n[0].splice(i,1);return true}});if(!i){throw new Error("Request not found in group '"+e+"'")}};y.prototype.relocateAll=function(e,t,r){var n=0,o=this.mBatchQueue[e],i=this;if(o){o[0].slice().forEach(function(e){if(!r||e.headers["If-Match"]===r){i.addChangeToGroup(e,t);o[0].splice(n,1)}else{n+=1}})}};y.prototype.removeChangeRequest=function(e){var t=this.cancelChangesByFilter(function(t){return t.$promise===e});if(!t){throw new Error("Cannot reset the changes, the batch request is running")}};y.prototype.removePost=function(e,t){var n=r.getPrivateAnnotation(t,"postBody"),o=this.cancelChangesByFilter(function(e){return e.body===n},e);if(!o){throw new Error("Cannot reset the changes, the batch request is running")}};y.prototype.reportHeaderMessages=function(e,t,n){if(t){const o=JSON.parse(t);if(e==="R#V#C"){r.setPrivateAnnotation(n,"headerMessages",o)}else{this.oModelInterface.reportTransitionMessages(o,e)}}};y.prototype.request=function(e,t,r,n,o,i,s,a,u,c,h,f,p){var d,l,m=r&&r.getGroupId()||"$direct",y,g=Infinity,v,S=this;if(m==="$cached"){l=new Error("Unexpected request: "+e+" "+t);l.$cached=true;throw l}if(r&&r.isCanceled()){if(s){s()}l=new Error("Request already canceled");l.canceled=true;return Promise.reject(l)}if(r){r.unlock();g=r.getSerialNumber()}t=this.convertResourcePath(t);u??=t;if(this.getGroupSubmitMode(m)!=="Direct"){if(m==="$single"&&this.mBatchQueue[m]){throw new Error("Cannot add new request to already existing $single queue")}y=new Promise(function(r,l){var y=S.getOrCreateBatchQueue(m);v={method:e,url:t,headers:Object.assign({},S.mPredefinedPartHeaders,S.mHeaders,n,S.mFinalHeaders),body:o,$cancel:s,$mergeRequests:p,$metaPath:a,$owner:f,$queryOptions:h,$reject:l,$resolve:r,$resourcePath:u,$submit:i};if(e==="GET"){y.push(v)}else if(c){y[0].unshift(v)}else{d=y.iChangeSet;while(y[d].iSerialNumber>g){d-=1}S.checkConflictingStrictRequest(v,y,d);y[d].push(v)}if(m==="$single"){S.submitBatch("$single").catch(S.oModelInterface.getReporter())}});v.$promise=y;return y}if(this.vStatistics!==undefined){h=Object.assign({"sap-statistics":this.vStatistics},h)}if(h){t=S.addQueryString(t,a,h)}if(i){i()}return this.sendRequest(e,t,Object.assign({},n,this.mFinalHeaders,e==="GET"?{"sap-cancel-on-close":"true"}:undefined),JSON.stringify(o),u==="R#V#C"?t:u).then(function(e){const t=S.doConvertResponse(typeof e.body==="string"?JSON.parse(e.body):e.body,a);S.reportHeaderMessages(u,e.messages,t);return t})};y.prototype.sendBatch=function(t,r,n){var o=e.serializeBatchRequest(t,this.getGroupSubmitMode(r)==="Auto"?"Group ID: "+r:"Group ID (API): "+r,this.oModelInterface.isIgnoreETag());return this.processOptimisticBatch(t,r)||this.sendRequest("POST","$batch"+this.sQueryParams,Object.assign(o.headers,u,n?undefined:{"sap-cancel-on-close":"true"},t.bContinueOnError?{Prefer:"odata.continue-on-error"}:undefined),o.body).then(function(t){if(t.messages!==null){throw new Error("Unexpected 'sap-messages' response header for batch request")}return e.deserializeBatchResponse(t.contentType,t.body)})};y.prototype.sendOptimisticBatch=function(){var e=window.location.href,t=this;s.get(c+e).then(function(r){var n={key:e};if(r){if(t.isBatchSent()){o.error("optimistic batch: #sendBatch called before optimistic batch "+"payload could be read",undefined,h);return}n.firstBatch=r;n.result=t.sendBatch(r.requests,r.groupId);o.info("optimistic batch: sent ",e,h)}t.oOptimisticBatch=n}).catch(this.oModelInterface.getReporter())};y.prototype.sendRequest=function(e,t,n,i,s){var a=this.sServiceUrl+t,u=this;return new Promise(function(c,f){function p(d){const l={contentType:n&&n["Content-Type"],data:i,headers:Object.assign({},u.mPredefinedRequestHeaders,u.mHeaders,r.resolveIfMatchHeader(n,u.oModelInterface.isIgnoreETag())),method:e};var m=u.mHeaders["X-CSRF-Token"];if(u.bWithCredentials){l.xhrFields={withCredentials:true}}jQuery.ajax(a,l).then(function(n,o,i){var s=i.getResponseHeader("ETag"),a=i.getResponseHeader("X-CSRF-Token");u.oModelInterface.onHttpResponse(r.parseRawHeaders(i.getAllResponseHeaders()));try{u.doCheckVersionHeader(i.getResponseHeader,t,!n)}catch(e){f(e);return}if(a){u.mHeaders["X-CSRF-Token"]=a}u.setSessionContext(i.getResponseHeader("SAP-ContextId"),i.getResponseHeader("SAP-Http-Session-Timeout"));n||=e==="GET"?null:{};if(s&&typeof n==="object"){n["@odata.etag"]=s}c({body:n,contentType:i.getResponseHeader("Content-Type"),messages:i.getResponseHeader("sap-messages"),resourcePath:t})},function(e){var t=e.getResponseHeader("SAP-ContextId"),n=e.getResponseHeader("X-CSRF-Token"),i;if(!d&&e.status===403&&n&&n.toLowerCase()==="required"){u.refreshSecurityToken(m).then(function(){p(true)},f)}else if(e.status===503&&e.getResponseHeader("Retry-After")&&u.oModelInterface.getOrCreateRetryAfterPromise(r.createError(e,""))){u.oModelInterface.getOrCreateRetryAfterPromise().then(p,f)}else{i="Communication error";if(t){u.setSessionContext(t,e.getResponseHeader("SAP-Http-Session-Timeout"))}else if(u.mHeaders["SAP-ContextId"]){i="Session not found on server";o.error(i,undefined,h);u.clearSessionContext(true)}f(r.createError(e,i,a,s))}})}const d=u.oModelInterface.getOrCreateRetryAfterPromise();if(d){d.then(p,f)}else if(u.oSecurityTokenPromise&&e!=="GET"){u.oSecurityTokenPromise.then(p)}else{p()}})};y.prototype.setContinueOnError=function(e){this.getOrCreateBatchQueue(e).bContinueOnError=true};y.prototype.setSessionContext=function(e,t){var r=d.test(t)?parseInt(t):0,n=Date.now()+30*60*1e3,i=this;this.clearSessionContext();if(e){this.mHeaders["SAP-ContextId"]=e;if(r>=60){this.iSessionTimer=setInterval(function(){if(Date.now()>=n){i.clearSessionContext(true);return}const e={method:"HEAD",headers:{"SAP-ContextId":i.mHeaders["SAP-ContextId"]}};if(i.bWithCredentials){e.xhrFields={withCredentials:true}}jQuery.ajax(i.sServiceUrl+i.sQueryParams,e).fail(function(e){if(e.getResponseHeader("SAP-Err-Id")==="ICMENOSESSION"){o.error("Session not found on server",undefined,h);i.clearSessionContext(true)}})},(r-5)*1e3)}else if(t!==null){o.warning("Unsupported SAP-Http-Session-Timeout header",t,h)}}};y.prototype.submitBatch=function(e){var t,r,n=this;r=i.all(this.aLockedGroupLocks.map(function(t){return t.waitFor(e)}));t=r.isPending();if(t){o.info("submitBatch('"+e+"') is waiting for locks",null,h)}return r.then(function(){if(n.hasOnlyPatchesWithoutSideEffects(e)){t=true;o.info("submitBatch('"+e+"') is waiting for potential side effect requests",null,h);return new Promise(function(e){setTimeout(function(){e()},0)})}}).then(function(){if(t){o.info("submitBatch('"+e+"') continues",null,h)}n.aLockedGroupLocks=n.aLockedGroupLocks.filter(function(e){return e.isLocked()});return n.processBatch(e)})};y.prototype.waitForBatchResponseReceived=function(e){return i.resolve(this.mBatchQueue[e][0][0].$promise)};y.prototype.waitForRunningChangeRequests=function(e){var t=this.mRunningChangeRequests[e];if(t){return t.length>1?i.all(t):t[0]}return i.resolve()};y.matchesOptimisticBatch=function(e,t,n,o){return t===o&&e.length===n.length&&e.every(function(e,t){return e.url===n[t].url&&r.deepEqual(l(e.headers),n[t].headers)})};y.create=function(e,t,r,o,i,s){var a=new y(e,r,o,t,s);if(i==="2.0"){n(a)}return a};return y},false);
//# sourceMappingURL=_Requestor.js.map