/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["./_Helper","./_MetadataConverter","sap/base/Log"],function(t,e,a){"use strict";var o="sap.ui.model.odata.v4.lib._V2MetadataConverter",n=/^(?:DELETE|GET|MERGE|PATCH|POST|PUT)$/,i="http://schemas.microsoft.com/ado/2007/06/edmx",r="http://schemas.microsoft.com/ado/2007/08/dataservices/metadata",s="http://www.sap.com/Protocols/SAPData",p={creatable:{property:"Insertable",term:"@Org.OData.Capabilities.V1.InsertRestrictions"},deletable:{property:"Deletable",term:"@Org.OData.Capabilities.V1.DeleteRestrictions"},"deletable-path":{property:"Deletable",term:"@Org.OData.Capabilities.V1.DeleteRestrictions"},"field-control":{term:"@com.sap.vocabularies.Common.v1.FieldControl"},heading:{term:"@com.sap.vocabularies.Common.v1.Heading"},label:{term:"@com.sap.vocabularies.Common.v1.Label"},precision:{term:"@Org.OData.Measures.V1.Scale"},quickinfo:{term:"@com.sap.vocabularies.Common.v1.QuickInfo"},"requires-filter":{property:"RequiresFilter",term:"@Org.OData.Capabilities.V1.FilterRestrictions"},searchable:{property:"Searchable",term:"@Org.OData.Capabilities.V1.SearchRestrictions"},text:{term:"@com.sap.vocabularies.Common.v1.Text"},topable:{term:"@Org.OData.Capabilities.V1.TopSupported"},updatable:{property:"Updatable",term:"@Org.OData.Capabilities.V1.UpdateRestrictions"},"updatable-path":{property:"Updatable",term:"@Org.OData.Capabilities.V1.UpdateRestrictions"}},c={bday:{TermName:"Contact"},city:{Path:"adr",TermName:"Contact",V4Attribute:"locality"},country:{Path:"adr",TermName:"Contact"},email:{Path:"address",TermName:"Contact",V4Attribute:"uri",typeMapping:{home:"home",pref:"preferred",work:"work"},v4EnumType:"com.sap.vocabularies.Communication.v1.ContactInformationType",v4PropertyAnnotation:"@com.sap.vocabularies.Communication.v1.IsEmailAddress"},familyname:{Path:"n",TermName:"Contact",V4Attribute:"surname"},givenname:{Path:"n",TermName:"Contact",V4Attribute:"given"},honorific:{Path:"n",TermName:"Contact",V4Attribute:"prefix"},middlename:{Path:"n",TermName:"Contact",V4Attribute:"additional"},name:{TermName:"Contact",V4Attribute:"fn"},nickname:{TermName:"Contact"},note:{TermName:"Contact"},org:{TermName:"Contact"},"org-role":{TermName:"Contact",V4Attribute:"role"},"org-unit":{TermName:"Contact",V4Attribute:"orgunit"},photo:{TermName:"Contact"},pobox:{Path:"adr",TermName:"Contact"},region:{Path:"adr",TermName:"Contact"},street:{Path:"adr",TermName:"Contact"},suffix:{Path:"n",TermName:"Contact"},tel:{Path:"tel",TermName:"Contact",V4Attribute:"uri",typeMapping:{cell:"cell",fax:"fax",home:"home",pref:"preferred",video:"video",voice:"voice",work:"work"},v4EnumType:"com.sap.vocabularies.Communication.v1.PhoneType",v4PropertyAnnotation:"@com.sap.vocabularies.Communication.v1.IsPhoneNumber"},title:{TermName:"Contact"},zip:{Path:"adr",TermName:"Contact",V4Attribute:"code"},class:{TermName:"Event"},dtend:{TermName:"Event"},dtstart:{TermName:"Event"},duration:{TermName:"Event"},fbtype:{TermName:"Event"},location:{TermName:"Event"},status:{TermName:"Event"},transp:{TermName:"Event"},wholeday:{TermName:"Event"},body:{TermName:"Message"},from:{TermName:"Message"},received:{TermName:"Message"},sender:{TermName:"Message"},subject:{TermName:"Message"},completed:{TermName:"Task"},due:{TermName:"Task"},"percent-complete":{TermName:"Task",V4Attribute:"percentcomplete"},priority:{TermName:"Task"}},l={fiscalyear:"@com.sap.vocabularies.Common.v1.IsFiscalYear",fiscalyearperiod:"@com.sap.vocabularies.Common.v1.IsFiscalYearPeriod",year:"@com.sap.vocabularies.Common.v1.IsCalendarYear",yearmonth:"@com.sap.vocabularies.Common.v1.IsCalendarYearMonth",yearmonthday:"@com.sap.vocabularies.Common.v1.IsCalendarDate",yearquarter:"@com.sap.vocabularies.Common.v1.IsCalendarYearQuarter",yearweek:"@com.sap.vocabularies.Common.v1.IsCalendarYearWeek",url:"@Org.OData.Core.V1.IsURL"};function m(e,a){var o=e.oAnnotatable;if(o){a=t.buildPath(o.sPath,a)}this.oConverter=e;this.sPath=a;this.oParent=o;this.mSapAttributes=e.mSapAttributes;this.mAnnotationsForTarget=null}m.prototype.annotate=function(t,e){this.getTarget()[t]=e};m.prototype.consume=function(t){return this.oConverter.consumeSapAnnotation(t)};m.prototype.convert=function(t,e){var a,o;if(e===undefined||e===""){return}o=p[t];if(o.property){a=this.getOrCreateAnnotationRecord(o.term);a[o.property]=e}else{this.annotate(o.term,e)}};m.prototype.getOrCreateAnnotationRecord=function(t){return this.oConverter.getOrCreateObject(this.getTarget(),t)};m.prototype.getTarget=function(){if(!this.mAnnotationsForTarget){this.mAnnotationsForTarget=this.oConverter.convertedV2Annotations[this.sPath]={}}return this.mAnnotationsForTarget};m.prototype.peek=function(t){return this.oConverter.mSapAnnotations[t]};function u(){this.association=null;this.associations={};this.associationSet=null;this.associationSets=[];this.aBoundOperations=[];this.constraintRole=null;this.convertedV2Annotations={};this.defaultEntityContainer=null;this.mEntityContainersOfSchema={};this.mEntityType2EntitySetAnnotation={};this.mProperty2Semantics={};this.sPropertyName=null;this.navigationProperties=[];this.mSapAnnotations={};this.sTypeName=null;this.mProperty2Unit={};e.call(this)}u.prototype=Object.create(e.prototype);u.prototype.collectSapAnnotations=function(t){var e,a=t.attributes,o,n;this.mSapAnnotations={};for(o=0,n=a.length;o<n;o+=1){e=a.item(o);if(e.namespaceURI===s&&e.localName!=="content-version"){this.mSapAnnotations[e.localName]=e.value}}};u.prototype.consumeSapAnnotation=function(t){var e=this.mSapAnnotations[t];delete this.mSapAnnotations[t];return e};u.prototype.convertEntitySetAnnotation=function(t,e){var n,i;switch(e){case"creatable":case"deletable":case"updatable":if(t.peek(e)==="false"){t.convert(e,false)}break;case"deletable-path":case"updatable-path":n=e.slice(0,9);i=t.consume(e);if(t.peek(n)){t.convert(e,false);a.warning("Inconsistent metadata in '"+this.url+"'","Use either 'sap:"+n+"' or 'sap:"+n+"-path'"+" at entity set '"+t.sPath+"'",o)}else{t.convert(e,{$Path:i})}break;case"label":this.convertLabel(t);break;case"pageable":i=t.consume(e);if(i==="false"){t.annotate("@Org.OData.Capabilities.V1.SkipSupported",false);t.annotate("@Org.OData.Capabilities.V1.TopSupported",false)}break;case"requires-filter":i=t.consume(e);if(i==="true"){t.convert(e,true)}break;case"topable":i=t.consume(e);if(i==="false"){t.convert(e,false)}break;default:}};u.prototype.convertLabel=function(t){t.convert("label",t.consume("label"))};u.prototype.convertPropertyAnnotation=function(t,e){var a;switch(e){case"heading":case"label":case"quickinfo":t.convert(e,t.consume(e));break;case"field-control":case"precision":case"text":t.convert(e,{$Path:t.consume(e)});break;case"aggregation-role":a=t.consume(e);if(a==="dimension"){t.annotate("@com.sap.vocabularies.Analytics.v1.Dimension",true)}else if(a==="measure"){t.annotate("@com.sap.vocabularies.Analytics.v1.Measure",true)}break;case"display-format":a=t.consume(e);if(a==="NonNegative"){t.annotate("@com.sap.vocabularies.Common.v1.IsDigitSequence",true)}else if(a==="UpperCase"){t.annotate("@com.sap.vocabularies.Common.v1.IsUpperCase",true)}break;case"semantics":this.convertPropertySemanticsAnnotation(t);break;case"unit":this.mProperty2Unit[t.sPath]=t.consume("unit");break;case"visible":a=t.consume(e);if(a==="false"){t.annotate("@com.sap.vocabularies.UI.v1.Hidden",true);t.annotate("@com.sap.vocabularies.Common.v1.FieldControl",{$EnumMember:"com.sap.vocabularies.Common.v1.FieldControlType/Hidden"})}break;default:}};u.prototype.convertPropertySemanticsAnnotation=function(t){var e,n,i,r,s,p=t.peek("semantics").split(";"),m=p[0],u=c[m];if(m==="unit-of-measure"||m==="currency-code"){this.mProperty2Semantics[t.sPath]=t.consume("semantics")}else if(l[m]){t.annotate(l[m],true);t.consume("semantics")}else if(u){i={$Path:this.sPropertyName};e=t.oParent.getOrCreateAnnotationRecord("@com.sap.vocabularies.Communication.v1."+u.TermName);if(u.Path){s=this.getOrCreateObject(e,u.Path);s[u.V4Attribute||m]=i;if(u.v4PropertyAnnotation){t.annotate(u.v4PropertyAnnotation,true);if(p[1]){r=[];n=p[1].split("=")[1];n.split(",").forEach(function(t){var e=u.typeMapping[t];if(e){r.push(u.v4EnumType+"/"+e)}else{a.warning("Unsupported semantic type: "+t,undefined,o)}});if(r.length){s.type={EnumMember:r.join(" ")}}}e[u.Path]=[s]}else{e[u.Path]=s}}else{e[u.V4Attribute||m]=i}t.consume("semantics")}};u.prototype.finalize=function(){this.result.$Version="4.0";this.setDefaultEntityContainer();this.updateNavigationPropertiesAndCreateBindings();this.processBoundOperations();this.processUnitConversion()};u.prototype.mergeAnnotations=function(t,e){var a;for(a in t){if(a in e){e[a]=Object.assign(t[a],e[a])}else{e[a]=t[a]}}};u.prototype.postProcessSchema=function(e,a){var o,n,i,r,s,p;for(i in this.mEntityContainersOfSchema){n=this.mEntityContainersOfSchema[i];for(s in n){r=n[s];if(r.$kind!=="EntitySet"){continue}p=i+"/"+s;o=t.merge(this.convertedV2Annotations[p]||{},this.mEntityType2EntitySetAnnotation[r.$Type]);if(!t.isEmptyObject(o)){this.convertedV2Annotations[p]=o}}}if(this.bIgnoreAnnotations){if(!t.isEmptyObject(this.convertedV2Annotations)){this.schema.$Annotations={}}}else if(this.schema.$Annotations){this.mergeAnnotations(this.convertedV2Annotations,this.schema.$Annotations)}else if(!t.isEmptyObject(this.convertedV2Annotations)){this.schema.$Annotations=this.convertedV2Annotations}this.convertedV2Annotations={};this.mEntityContainersOfSchema={}};u.prototype.processAssociation=function(t){var e=this.namespace+t.getAttribute("Name");this.associations[e]=this.association={referentialConstraint:null,roles:{}}};u.prototype.processAssociationEnd=function(t){var e=t.getAttribute("Role");this.association.roles[e]={multiplicity:t.getAttribute("Multiplicity"),propertyName:undefined,typeName:this.resolveAlias(t.getAttribute("Type"))}};u.prototype.processAssociationSet=function(t){var e={associationName:this.resolveAlias(t.getAttribute("Association")),ends:[],entityContainer:this.entityContainer};this.associationSet=e;this.associationSets.push(e);this.consumeSapAnnotation("creatable");this.consumeSapAnnotation("deletable");this.consumeSapAnnotation("updatable")};u.prototype.processAssociationSetEnd=function(t){this.associationSet.ends.push({entitySetName:t.getAttribute("EntitySet"),roleName:t.getAttribute("Role")})};u.prototype.processBoundOperations=function(){var t=this;this.aBoundOperations.forEach(function(e){var a=t.result[e.$Parameter[0].$Type];a.$Key.forEach(function(t){e.$Parameter.some(function(a,o){if(a.$Name===t){e.$Parameter.splice(o,1);return true}})})})};u.prototype.processComplexType=function(t){this.processType(t,{$kind:"ComplexType"})};u.prototype.processDataServices=function(t){if(t.getAttributeNS(r,"DataServiceVersion")!=="2.0"){throw new Error(this.url+': expected DataServiceVersion="2.0": '+h(t))}};u.prototype.processDependent=function(t){var e=this.association.referentialConstraint;this.constraintRole=e.dependent={roleName:t.getAttribute("Role")}};u.prototype.processElement=function(t,e){this.collectSapAnnotations(t);if(e){e.call(this,t)}this.warnUnsupportedSapAnnotations(t)};u.prototype.processEntityContainer=function(t){var e=this.namespace+t.getAttribute("Name");this.mEntityContainersOfSchema[e]=this.entityContainer={$kind:"EntityContainer"};this.addToResult(e,this.entityContainer);if(t.getAttributeNS(r,"IsDefaultEntityContainer")==="true"){this.defaultEntityContainer=e}this.v2annotatable(e)};u.prototype.processEntitySet=function(t){var e,a=t.getAttribute("Name");this.entityContainer[a]=this.entitySet={$kind:"EntitySet",$Type:this.resolveAlias(t.getAttribute("EntityType"))};e=this.v2annotatable(a,this.convertEntitySetAnnotation);e.consume("creatable");e.consume("deletable");e.consume("updatable");if(e.consume("searchable")!=="true"){e.convert("searchable",false)}};u.prototype.processEntityType=function(t){var e={$kind:"EntityType"},a=this;this.processType(t,e);this.processAttributes(t,e,{Abstract:this.setIfTrue,BaseType:function(t){return t?a.resolveAlias(t):undefined}});this.convertLabel(this.oAnnotatable)};u.prototype.processEntityTypeKeyPropertyRef=function(t){var e=t.getAttribute("Name");this.getOrCreateArray(this.type,"$Key").push(e)};u.prototype.processFacetAttributes=function(t,e){var a=this;this.processAttributes(t,e,{DefaultValue:this.setValue,MaxLength:function(t){return t==="Max"?undefined:a.setNumber(t)},Nullable:this.setIfFalse,Precision:this.setNumber,Scale:this.setNumber,Unicode:this.setIfFalse});if(t.getAttribute("FixedLength")==="false"){e.$Scale="variable"}};u.prototype.processFunctionImport=function(t){var e,i=t.getAttributeNS(r,"HttpMethod"),s=i!=="GET"?"Action":"Function",c,l=t.getAttribute("Name"),m={$kind:s},u={$kind:s+"Import"},h=this.namespace+l,y=t.getAttribute("ReturnType"),f;u["$"+s]=h;this.processAttributes(t,u,{EntitySet:this.setValue});if(y){m.$ReturnType=f={};this.processTypedCollection(y,f)}if(!n.test(i)){a.warning("Unsupported HttpMethod at FunctionImport '"+l+"', removing this FunctionImport",undefined,o);this.consumeSapAnnotation("action-for");this.consumeSapAnnotation("applicable-path")}else{if(i!=="GET"&&i!=="POST"){m.$v2HttpMethod=i}this.addToResult(h,[m]);e=this.consumeSapAnnotation("action-for");if(e){m.$IsBound=true;m.$Parameter=[{$Name:null,$Nullable:false,$Type:this.resolveAlias(e)}];this.aBoundOperations.push(m);this.consumeSapAnnotation("applicable-path");c=this.consumeSapAnnotation("label");if(c){m[p["label"].term]=c}}else{this.entityContainer[l]=u;this.v2annotatable(l);this.convertLabel(this.oAnnotatable)}}this.oOperation=m};u.prototype.processParameter=function(t){var e,a=this.oOperation,o={$Name:t.getAttribute("Name")};this.processFacetAttributes(t,o);this.processTypedCollection(t.getAttribute("Type"),o);this.getOrCreateArray(a,"$Parameter").push(o);e=this.consumeSapAnnotation("label");if(e){o[p["label"].term]=e}};u.prototype.processPrincipal=function(t){var e=this.association.referentialConstraint;this.constraintRole=e.principal={roleName:t.getAttribute("Role")}};u.prototype.processReferentialConstraint=function(t){this.association.referentialConstraint={}};u.prototype.processReferentialConstraintPropertyRef=function(t){this.constraintRole.propertyRef=t.getAttribute("Name")};u.prototype.processSchema=function(t){var e=this.consumeSapAnnotation("schema-version");this.namespace=t.getAttribute("Namespace")+".";this.schema={$kind:"Schema"};this.addToResult(this.namespace,this.schema);if(e){this.schema["@Org.Odata.Core.V1.SchemaVersion"]=e}};u.prototype.processType=function(t,e){var a=this.namespace+t.getAttribute("Name");this.sTypeName=a;this.type=e;this.addToResult(a,e);this.v2annotatable(a)};u.prototype.processTypedCollection=function(t,e){var a=this.rCollection.exec(t);if(a){e.$isCollection=true;t=a[1]}if(!t.includes(".")){t="Edm."+t}switch(t){case"Edm.DateTime":e.$v2Type=t;if(this.mSapAnnotations["display-format"]==="Date"){t="Edm.Date";delete e.$Precision}else{t="Edm.DateTimeOffset"}break;case"Edm.Float":e.$v2Type=t;t="Edm.Single";break;case"Edm.Time":e.$v2Type=t;t="Edm.TimeOfDay";break;default:t=this.resolveAlias(t)}e.$Type=t};u.prototype.processTypeNavigationProperty=function(t){var e=this.consumeSapAnnotation("creatable"),n=this.consumeSapAnnotation("creatable-path"),i=this.consumeSapAnnotation("filterable"),r,s,p=t.getAttribute("Name"),c,l={$kind:"NavigationProperty"},m=this;function u(t,e,a){s=m.getOrCreateObject(m.mEntityType2EntitySetAnnotation,m.sTypeName);s=m.getOrCreateObject(s,t);s=m.getOrCreateArray(s,e);s.push(a)}this.type[p]=l;this.navigationProperties.push({associationName:this.resolveAlias(t.getAttribute("Relationship")),fromRoleName:t.getAttribute("FromRole"),property:l,propertyName:p,toRoleName:t.getAttribute("ToRole")});this.v2annotatable(p);if(e){c={$NavigationPropertyPath:p};if(n){a.warning("Inconsistent metadata in '"+this.url+"'","Use either 'sap:creatable' or 'sap:creatable-path' at navigation property '"+this.oAnnotatable.sPath+"'",o)}else if(e==="true"){c=null}}else if(n){c={$If:[{$Not:{$Path:n}},{$NavigationPropertyPath:p}]}}if(c){u("@Org.OData.Capabilities.V1.InsertRestrictions","NonInsertableNavigationProperties",c)}if(i==="false"){r={NavigationProperty:{$NavigationPropertyPath:p},FilterRestrictions:{Filterable:false}};u("@Org.OData.Capabilities.V1.NavigationRestrictions","RestrictedProperties",r)}};u.prototype.processTypeProperty=function(t){var e,n,i,r,s=t.getAttribute("Name"),p={$kind:"Property"},c=this;function l(t,n,i){if(c.type.$kind==="EntityType"){r=c.getOrCreateObject(c.mEntityType2EntitySetAnnotation,c.sTypeName);r=c.getOrCreateObject(r,t);r=c.getOrCreateArray(r,n);r.push({$PropertyPath:s})}else{a.warning("Unsupported SAP annotation at a complex type in '"+c.url+"'","sap:"+i+" at property '"+e.sPath+"'",o)}}this.sPropertyName=s;this.type[s]=p;this.processFacetAttributes(t,p);this.processTypedCollection(t.getAttribute("Type"),p);e=this.v2annotatable(s,this.convertPropertyAnnotation);if(e.consume("updatable")==="false"){if(e.consume("creatable")==="false"){e.annotate("@Org.OData.Core.V1.Computed",true)}else{e.annotate("@Org.OData.Core.V1.Immutable",true)}}if(e.consume("filterable")==="false"){l("@Org.OData.Capabilities.V1.FilterRestrictions","NonFilterableProperties","filterable")}i=e.consume("filter-restriction");if(i){switch(i){case"interval":n="SingleInterval";break;case"multi-value":n="MultiValue";break;case"single-value":n="SingleValue";break;default:a.warning("Inconsistent metadata in '"+this.url+"'",'Unsupported sap:filter-restriction="'+i+"\" at property '"+e.sPath+"'",o)}if(n){if(this.type.$kind==="EntityType"){r=this.getOrCreateObject(this.mEntityType2EntitySetAnnotation,this.sTypeName);r=this.getOrCreateArray(r,"@com.sap.vocabularies.Common.v1.FilterExpressionRestrictions");r.push({AllowedExpressions:{EnumMember:"com.sap.vocabularies.Common.v1.FilterExpressionType/"+n},Property:{$PropertyPath:s}})}else{a.warning("Unsupported SAP annotation at a complex type in '"+this.url+"'","sap:filter-restriction at property '"+e.sPath+"'",o)}}}if(e.consume("required-in-filter")==="true"){l("@Org.OData.Capabilities.V1.FilterRestrictions","RequiredProperties","required-in-filter")}if(e.consume("sortable")==="false"){l("@Org.OData.Capabilities.V1.SortRestrictions","NonSortableProperties","sortable")}};u.prototype.processUnitConversion=function(){var e=this;Object.keys(this.mProperty2Unit).forEach(function(n){var i,r,s=n.split("/")[0],p,c=e.mProperty2Unit[n],l=c.split("/"),m,u,h,y=l.length;for(h=0;h<y;h+=1){r=e.result[s];m=r[l[h]];if(!m){a.warning("Path '"+c+"' for sap:unit cannot be resolved",n,o);return}if(h<y-1){s=m.$Type}}u=e.mProperty2Semantics[s+"/"+l[y-1]];if(!u){a.warning("Unsupported sap:semantics at sap:unit='"+c+"'; expected 'currency-code' or 'unit-of-measure'",n,o);return}p=u==="currency-code"?"ISOCurrency":"Unit";p="@Org.OData.Measures.V1."+p;i=e.getOrCreateObject(e.result[t.namespace(n)+"."],"$Annotations");if(e.bIgnoreAnnotations){return}i=e.getOrCreateObject(i,n);if(!(p in i)){i[p]={$Path:c}}})};function h(t){var e,a=t.attributes,o="<"+t.nodeName,n,i;for(n=0,i=a.length;n<i;n+=1){e=a.item(n);o+=" "+e.name+'="'+e.value+'"'}return o+(t.childNodes.length?">":"/>")}u.prototype.setDefaultEntityContainer=function(){var t=this.defaultEntityContainer,e,a=this.result;if(t){a.$EntityContainer=t}else{e=Object.keys(a).filter(function(t){return a[t].$kind==="EntityContainer"});if(e.length===1){a.$EntityContainer=e[0]}}};u.prototype.updateNavigationPropertiesAndCreateBindings=function(){var t=this;this.navigationProperties.forEach(function(e){var a=t.associations[e.associationName],o=a.referentialConstraint,n=e.property,i=a.roles[e.toRoleName];n.$Type=i.typeName;i.propertyName=e.propertyName;if(i.multiplicity==="1"){n.$Nullable=false}if(i.multiplicity==="*"){n.$isCollection=true}if(o&&o.principal.roleName===e.toRoleName){n.$ReferentialConstraint={};n.$ReferentialConstraint[o.dependent.propertyRef]=o.principal.propertyRef}});this.associationSets.forEach(function(e){var a=t.associations[e.associationName],o=e.entityContainer;function n(t,e){var n=o[t.entitySetName],i=a.roles[e.roleName];if(i.propertyName){n.$NavigationPropertyBinding??={};n.$NavigationPropertyBinding[i.propertyName]=e.entitySetName}}n(e.ends[0],e.ends[1]);n(e.ends[1],e.ends[0])})};u.prototype.v2annotatable=function(t,e){var a=new m(this,t);this.oAnnotatable=a;if(e){e=e.bind(this);Object.keys(this.mSapAnnotations).forEach(function(t){e(a,t)})}return a};u.prototype.warnUnsupportedSapAnnotations=function(t){Object.keys(this.mSapAnnotations).forEach(function(e){a.warning("Unsupported annotation 'sap:"+e+"'",h(t),o)})};(function(t){var a;t.sRootNamespace=i;t.oAliasConfig={Reference:{__xmlns:e.sEdmxNamespace,Include:{__processor:t.processAlias}},DataServices:{Schema:{__processor:t.processAlias}}};a={NavigationProperty:{__processor:t.processTypeNavigationProperty},Property:{__processor:t.processTypeProperty}};t.oFullConfig={__include:[t.oReferenceInclude],DataServices:{__processor:t.processDataServices,Schema:{__postProcessor:t.postProcessSchema,__processor:t.processSchema,__include:[t.oAnnotationsConfig],Association:{__processor:t.processAssociation,End:{__processor:t.processAssociationEnd},ReferentialConstraint:{__processor:t.processReferentialConstraint,Dependent:{__processor:t.processDependent,PropertyRef:{__processor:t.processReferentialConstraintPropertyRef}},Principal:{__processor:t.processPrincipal,PropertyRef:{__processor:t.processReferentialConstraintPropertyRef}}}},ComplexType:{__processor:t.processComplexType,__include:[a]},EntityContainer:{__processor:t.processEntityContainer,AssociationSet:{__processor:t.processAssociationSet,End:{__processor:t.processAssociationSetEnd}},EntitySet:{__processor:t.processEntitySet},FunctionImport:{__processor:t.processFunctionImport,Parameter:{__processor:t.processParameter}}},EntityType:{__processor:t.processEntityType,__include:[a],Key:{PropertyRef:{__processor:t.processEntityTypeKeyPropertyRef}}}}}}})(u.prototype);return u},false);
//# sourceMappingURL=_V2MetadataConverter.js.map