/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/base/util/isEmptyObject","sap/ui/core/Lib","sap/ui/core/date/UI5Date","sap/ui/core/format/DateFormat","sap/ui/model/CompositeType","sap/ui/model/FormatException","sap/ui/model/ParseException","sap/ui/model/ValidateException"],function(t,e,o,a,i,r,n,s){"use strict";var u=i.extend("sap.ui.model.type.DateInterval",{constructor:function(){i.apply(this,arguments);this.sName="DateInterval";this.bUseInternalValues=true}});u.prototype.formatValue=function(t,e){var a=this;if(!Array.isArray(t)){throw new r("Cannot format date interval: "+t+" is expected as an Array but given the wrong format")}switch(this.getPrimitiveType(e)){case"string":case"any":if(!t[0]||!t[1]&&!this.oFormatOptions.singleIntervalValue){return""}if(this.oInputFormat){t=t.map(function(t){if(a.oFormatOptions.source.pattern==="timestamp"){if(typeof t!=="number"){if(isNaN(t)){throw new r("Cannot format date: "+t+" is not a valid Timestamp")}else{t=parseInt(t)}}t=o.getInstance(t)}else{t=a.oInputFormat.parse(t);if(t==null){throw new r("Cannot format date: "+t+" has the wrong format")}}return t})}return this.oOutputFormat.format(t);default:throw new r("Don't know how to format Date to "+e)}};u.prototype.parseValue=function(t,o){var a,i,r=this;switch(this.getPrimitiveType(o)){case"string":if(t===""){return[null,null]}i=this.oOutputFormat.parse(t);if(!i[0]||!i[1]&&!this.oFormatOptions.singleIntervalValue){a=e.getResourceBundleFor("sap.ui.core");throw new n(a.getText("Enter"+this.getName(),[this.oOutputFormat.format(this.oOutputFormat.getSampleValue()[0])]))}if(i[1]&&this.sName==="DateInterval"){if(this.oFormatOptions.UTC){i[1].setUTCHours(23,59,59,0)}else{i[1].setHours(23,59,59,0)}}if(this.oInputFormat){i=i.map(function(t){return r.oFormatOptions.source.pattern==="timestamp"?t.getTime():r.oInputFormat.format(t)})}return i;default:throw new n("Don't know how to parse a date interval from "+o)}};u.prototype.validateValue=function(t){var o,a,i=e.getResourceBundleFor("sap.ui.core"),r=[],n=[],u=this;if(this.oInputFormat&&this.oFormatOptions.source.pattern!="timestamp"){t=t.map(function(t){return u.oInputFormat.parse(t)})}o=!this.oFormatOptions.singleIntervalValue||t[1]!==null;if(this.oConstraints.minimum){a=this.oConstraints.minimum;if(t[0]<a||o&&t[1]<a){r.push("minimum");n.push(i.getText("Date.Minimum",[a]))}}if(this.oConstraints.maximum){a=this.oConstraints.maximum;if(t[0]>a||o&&t[1]>a){r.push("maximum");n.push(i.getText("Date.Maximum",[a]))}}if(r.length>0){throw new s(this.combineMessages(n),r)}};u.prototype.setFormatOptions=function(t){this.oFormatOptions=t;this._createFormats()};u.prototype._handleLocalizationChange=function(){this._createFormats()};u.prototype._createFormats=function(){var e=this.oFormatOptions.source;this.oFormatOptions.interval=true;this.oOutputFormat=a.getDateInstance(this.oFormatOptions);if(e){if(t(e)){e={pattern:"yyyy-MM-dd"}}this.oInputFormat=a.getDateInstance(e)}};u.prototype.getPlaceholderText=function(){return this.oOutputFormat.getPlaceholderText()};return u});
//# sourceMappingURL=DateInterval.js.map