/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/base/util/each","sap/ui/core/Lib","sap/ui/core/format/FileSizeFormat","sap/ui/model/FormatException","sap/ui/model/ParseException","sap/ui/model/SimpleType","sap/ui/model/ValidateException"],function(t,e,i,o,n,r,s){"use strict";var a=r.extend("sap.ui.model.type.FileSize",{constructor:function(){r.apply(this,arguments);this.sName="FileSize"}});a.prototype.formatValue=function(t,e){var i;if(t==undefined||t==null){return null}if(this.oInputFormat&&typeof t==="string"){i=this.oInputFormat.parse(t);if(isNaN(i)){throw new o("Cannot format file size: "+t+" has the wrong format")}}else if(!this.oInputFormat&&typeof t==="string"){throw new o("Cannot format file size: "+t+" of type string without input/source formatter")}else if(typeof t==="number"){i=t}else{throw new o("Cannot format file size: "+t+" has wrong type: "+typeof t)}if(i==undefined||i==null){return null}switch(this.getPrimitiveType(e)){case"string":return this.oOutputFormat.format(i);case"int":return Math.floor(i);case"float":case"any":return i;default:throw new o("Don't know how to format FileSize to "+e)}};a.prototype.parseValue=function(t,i){var o,r;if(t==undefined||t==null){return null}switch(this.getPrimitiveType(i)){case"string":o=this.oOutputFormat.parse(t);if(isNaN(o)){r=e.getResourceBundleFor("sap.ui.core");throw new n(r.getText("FileSize.Invalid"))}break;case"int":case"float":o=t;break;default:throw new n("Don't know how to parse FileSize from "+i)}if(this.oInputFormat){o=this.oInputFormat.format(o)}return o};a.prototype.validateValue=function(i){if(this.oConstraints){var o=e.getResourceBundleFor("sap.ui.core"),n=[],r=[],a=this.oInputFormat;if(a&&typeof i==="string"){i=a.parse(i)}else if(!a&&typeof i==="string"){throw new Error("No Validation possible: '"+i+"' is of type string but not input/source format specified.")}t(this.oConstraints,function(t,e){if(a&&typeof e==="string"){e=a.parse(e)}else if(!a&&typeof e==="string"){throw new Error("No Validation possible: Compare value ("+t+") '"+e+"' is of type string but not input/source format specified.")}switch(t){case"minimum":if(i<e){n.push("minimum");r.push(o.getText("FileSize.Minimum",[e]))}break;case"maximum":if(i>e){n.push("maximum");r.push(o.getText("FileSize.Maximum",[e]))}break;default:break}});if(n.length>0){throw new s(this.combineMessages(r),n)}}};a.prototype.setFormatOptions=function(t){this.oFormatOptions=t;this._handleLocalizationChange()};a.prototype._handleLocalizationChange=function(){this.oOutputFormat=i.getInstance(this.oFormatOptions);if(this.oFormatOptions.source){this.oInputFormat=i.getInstance(this.oFormatOptions.source)}};return a});
//# sourceMappingURL=FileSize.js.map