/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/base/util/each","sap/base/util/isEmptyObject","sap/ui/core/Lib","sap/ui/core/format/NumberFormat","sap/ui/model/FormatException","sap/ui/model/ParseException","sap/ui/model/SimpleType","sap/ui/model/ValidateException"],function(t,o,e,a,i,r,s,n){"use strict";var u=s.extend("sap.ui.model.type.Float",{constructor:function(){s.apply(this,arguments);this.sName="Float"}});u.prototype.formatValue=function(t,o){var e=t;if(t==undefined||t==null){return null}if(this.oInputFormat){e=this.oInputFormat.parse(t);if(e==null){throw new i("Cannot format float: "+t+" has the wrong format")}}switch(this.getPrimitiveType(o)){case"string":return this.oOutputFormat.format(e);case"int":return Math.floor(e);case"float":case"any":return e;default:throw new i("Don't know how to format Float to "+o)}};u.prototype.parseValue=function(t,o){var a,i;switch(this.getPrimitiveType(o)){case"string":a=this.oOutputFormat.parse(t);if(isNaN(a)){i=e.getResourceBundleFor("sap.ui.core");throw new r(i.getText("Float.Invalid"))}break;case"int":case"float":a=t;break;default:throw new r("Don't know how to parse Float from "+o)}if(this.oInputFormat){a=this.oInputFormat.format(a)}return a};u.prototype.validateValue=function(o){if(this.oConstraints){var a=e.getResourceBundleFor("sap.ui.core"),i=[],r=[],s=o,u=this;if(this.oInputFormat){s=this.oInputFormat.parse(o)}t(this.oConstraints,function(t,o){switch(t){case"minimum":if(s<o){i.push("minimum");r.push(a.getText("Float.Minimum",[u.oOutputFormat.format(o)]))}break;case"maximum":if(s>o){i.push("maximum");r.push(a.getText("Float.Maximum",[u.oOutputFormat.format(o)]))}break;default:break}});if(i.length>0){throw new n(this.combineMessages(r),i)}}};u.prototype.setFormatOptions=function(t){this.oFormatOptions=Object.assign(t.style!=="short"&&t.style!=="long"?{preserveDecimals:true}:{},t);this._createFormats()};u.prototype._handleLocalizationChange=function(){this._createFormats()};u.prototype._createFormats=function(){var t=this.oFormatOptions.source;this.oOutputFormat=a.getFloatInstance(this.oFormatOptions);if(t){if(o(t)){t={groupingEnabled:false,groupingSeparator:",",decimalSeparator:"."}}this.oInputFormat=a.getFloatInstance(t)}};return u});
//# sourceMappingURL=Float.js.map