/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/base/Log","sap/base/util/each","sap/ui/core/Lib","sap/ui/model/FormatException","sap/ui/model/ParseException","sap/ui/model/SimpleType","sap/ui/model/ValidateException"],function(t,e,s,n,a,i,r){"use strict";var o=i.extend("sap.ui.model.type.String",{constructor:function(){i.apply(this,arguments);this.sName="String";if(this.oConstraints.search&&typeof this.oConstraints.search=="string"){this.oConstraints.search=new RegExp(this.oConstraints.search)}}});o.prototype.formatValue=function(t,e){if(t==undefined||t==null){return null}switch(this.getPrimitiveType(e)){case"string":case"any":return t;case"int":var s=parseInt(t);if(isNaN(s)){throw new n(t+" is not a valid int value")}return s;case"float":var a=parseFloat(t);if(isNaN(a)){throw new n(t+" is not a valid float value")}return a;case"boolean":if(t.toLowerCase()=="true"||t=="X"){return true}if(t.toLowerCase()=="false"||t==""){return false}throw new n(t+" is not a valid boolean value");default:throw new n("Don't know how to format String to "+e)}};o.prototype.parseValue=function(t,e){switch(this.getPrimitiveType(e)){case"string":return t;case"boolean":case"int":case"float":return t.toString();default:throw new a("Don't know how to parse String from "+e)}};o.prototype.validateValue=function(n){if(this.oConstraints){var a=s.getResourceBundleFor("sap.ui.core"),i=[],o=[];if(n===null){n=""}e(this.oConstraints,function(e,s){switch(e){case"maxLength":if(n.length>s){i.push("maxLength");o.push(a.getText("String.MaxLength",[s]))}break;case"minLength":if(n.length<s){i.push("minLength");o.push(a.getText("String.MinLength",[s]))}break;case"startsWith":if(!(typeof s=="string"&&s.length>0&&n.startsWith(s))){i.push("startsWith");o.push(a.getText("String.StartsWith",[s]))}break;case"startsWithIgnoreCase":if(!(typeof s=="string"&&s!=""?n.toLowerCase().startsWith(s.toLowerCase()):false)){i.push("startsWithIgnoreCase");o.push(a.getText("String.StartsWith",[s]))}break;case"endsWith":if(!(typeof s=="string"&&s.length>0&&n.endsWith(s))){i.push("endsWith");o.push(a.getText("String.EndsWith",[s]))}break;case"endsWithIgnoreCase":if(!(typeof s=="string"&&s!=""?n.toLowerCase().endsWith(s.toLowerCase()):false)){i.push("endsWithIgnoreCase");o.push(a.getText("String.EndsWith",[s]))}break;case"contains":if(n.indexOf(s)==-1){i.push("contains");o.push(a.getText("String.Contains",[s]))}break;case"equals":if(n!=s){i.push("equals");o.push(a.getText("String.Equals",[s]))}break;case"search":if(n.search(s)==-1){i.push("search");o.push(a.getText("String.Search",[s]))}break;default:t.warning("Ignoring unknown constraint: '"+e+"'",null,"sap.ui.model.type.String")}});if(i.length>0){throw new r(this.combineMessages(o),i)}}};return o});
//# sourceMappingURL=String.js.map