/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/base/i18n/Formatting","sap/base/strings/hash","sap/base/util/each","sap/base/util/extend","sap/base/util/isEmptyObject","sap/ui/core/Lib","sap/ui/core/Locale","sap/ui/core/LocaleData","sap/ui/core/format/NumberFormat","sap/ui/model/CompositeType","sap/ui/model/FormatException","sap/ui/model/ParseException","sap/ui/model/ValidateException"],function(t,e,a,i,s,n,o,r,u,c,p,m,h){"use strict";var l=c.extend("sap.ui.model.type.Unit",{constructor:function(t,e,a){c.apply(this,arguments);this.sName="Unit";this.bShowMeasure=!t||!("showMeasure"in t)||t.showMeasure;this.bShowNumber=!t||!("showNumber"in t)||t.showNumber;this.bUseRawValues=true;this.aDynamicFormatOptionNames=a}});l.prototype._getInstance=function(a,s){var n=this.createFormatOptions(a);if(s&&!this.oFormatOptions.customUnits&&!n.customUnits){var c=new o(t.getLanguageTag());var p=r.getInstance(c);var m=p.getUnitFromMapping(s)||s;var h=p.getUnitFormat(m);if(h){var f=i({},h);f.decimals=n.decimals!=undefined?n.decimals:f.decimals;f.precision=n.precision!=undefined?n.precision:f.precision;n.customUnits={};n.customUnits[s]=f}}var g=n;if(this.oFormatOptions){g=i({},this.oFormatOptions,n)}if(this.iScale>=0){g=i({},{maxFractionDigits:this.iScale},g)}if(this.getMetadata().getClass()!==l){var d=this.getMetadata();d._mTypeInstanceCache=d._mTypeInstanceCache||{};var y=e(JSON.stringify(g)||"");var F=d._mTypeInstanceCache[y];if(!F){F=u.getUnitInstance(g);d._mTypeInstanceCache[y]=F}return F}else{return u.getUnitInstance(g)}};l.prototype._clearInstances=function(){if(this.getMetadata().getClass()!==l){var t=this.getMetadata();if(t._mTypeInstanceCache){t._mTypeInstanceCache={}}}};l.prototype.createFormatOptions=function(t){var e={};if(this.aDynamicFormatOptionNames&&t.length>=this.aDynamicFormatOptionNames.length){this.aDynamicFormatOptionNames.forEach(function(a,i){if(a){e[a]=t[i]}})}return e};l.prototype.extractArguments=function(t){return Array.isArray(t)&&t.length>2?t.slice(2):[]};l.prototype.formatValue=function(t,e){var a=t;if(t==undefined||t==null){return null}if(this.oInputFormat){a=this.oInputFormat.parse(t)}if(!Array.isArray(a)){throw new p("Cannot format Unit: "+t+" has the wrong format")}if((a[0]==undefined||a[0]==null)&&this.bShowNumber){return null}switch(this.getPrimitiveType(e)){case"string":this.aDynamicValues=this.extractArguments(a);this.oOutputFormat=this._getInstance(this.aDynamicValues,a[1]);return this.oOutputFormat.format(a);case"int":case"float":case"any":default:throw new p("Don't know how to format Unit to "+e)}};l.prototype.getPartsListeningToTypeChanges=function(){return this.bShowNumber?[0]:[]};l.prototype.parseValue=function(t,e){var a;switch(this.getPrimitiveType(e)){case"string":this.oOutputFormat=this._getInstance(this.aDynamicValues);a=this.oOutputFormat.parse(t);if(!Array.isArray(a)||this.bShowNumber&&isNaN(a[0])){throw this.getParseException()}break;case"int":case"float":default:throw new m("Don't know how to parse Unit from "+e)}if(this.oInputFormat){a=this.oInputFormat.format(a)}return a};l.prototype.processPartTypes=function(t){const e=t[0];if(e?.isA("sap.ui.model.odata.type.Decimal")){this.iScale=e.oConstraints?.scale||0}};l.prototype.validateValue=function(t){if(this.oConstraints){var e=n.getResourceBundleFor("sap.ui.core"),i=[],s=[],o=t,r;if(this.oInputFormat){o=this.oInputFormat.parse(t)}r=o[0];a(this.oConstraints,function(t,a){switch(t){case"minimum":if(r<a){i.push("minimum");s.push(e.getText("Unit.Minimum",[a]))}break;case"maximum":if(r>a){i.push("maximum");s.push(e.getText("Unit.Maximum",[a]))}break;case"decimals":var n=u._shiftDecimalPoint(r,a);if(Math.floor(n)!==n){i.push("decimals");s.push(e.getText("Unit.Decimals",[a]))}break;default:break}});if(i.length>0){throw new h(s.join(" "),i)}}};l.prototype.setFormatOptions=function(t){const e=t.maxFractionDigits===undefined&&t.minFractionDigits===undefined&&t.decimals===undefined;this.oFormatOptions={...t.style!=="short"&&t.style!=="long"?{preserveDecimals:true}:{},...t,...e?{decimals:3}:{}};this._clearInstances();this._createInputFormat()};l.prototype._handleLocalizationChange=function(){this._clearInstances();this._createInputFormat()};l.prototype._createInputFormat=function(){var t=this.oFormatOptions.source;if(t){if(s(t)){t={groupingEnabled:false,groupingSeparator:",",decimalSeparator:"."}}this.oInputFormat=u.getUnitInstance(t)}};l.prototype.getParseException=function(){var t=n.getResourceBundleFor("sap.ui.core"),e;if(!this.bShowNumber){e=t.getText("Unit.InvalidMeasure")}else if(!this.bShowMeasure){e=t.getText("EnterNumber")}else{e=t.getText("Unit.Invalid")}return new m(e)};l.prototype.getPartsIgnoringMessages=function(){if(!this.bShowMeasure){return[1]}else if(!this.bShowNumber){return[0]}return[]};return l});
//# sourceMappingURL=Unit.js.map