/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/performance/Measurement","sap/ui/performance/XHRInterceptor","sap/ui/performance/trace/FESRHelper","sap/base/util/LoaderExtensions","sap/base/util/now","sap/base/util/uid","sap/base/Log","sap/ui/thirdparty/URI"],function(e,t,i,n,r,s,a,o){"use strict";let u=false,d=false,p=[],f,g,c=false,l=false,m,h=0,v=false,y=false,I,S;const L={"application/zip":true,"application/vnd.rar":true,"application/gzip":true,"application/x-tar":true,"application/java-archive":true,"image/jpeg":true,"application/pdf":true},T="zip,rar,arj,z,gz,tar,lzh,cab,hqx,ace,jar,ear,war,jpg,jpeg,pdf,gzip";function b(e){var t=new o(e.toString()).host();return t&&t!==window.location.host}function E(e){var t=e.toString();var i="";for(var n=0;n<t.length;n+=2){i+=String.fromCharCode(parseInt(t.substr(n,2),16))}return i.trim()}function H(e){return{event:"startup",trigger:"undetermined",component:"undetermined",appVersion:"undetermined",start:e||performance.timeOrigin,end:0,navigation:0,roundtrip:0,processing:0,duration:0,requests:[],measurements:[],sapStatistics:[],requestTime:0,networkTime:0,bytesSent:0,bytesReceived:0,requestCompression:"X",busyDuration:0,id:s(),passportAction:"undetermined_startup_0",rootId:undefined}}function q(e){if(e.start>f.start&&e.end<f.end){return e}}function w(e){var t=e.startTime>0&&e.startTime<=e.requestStart&&e.requestStart<=e.responseEnd;var i=f.start<=performance.timeOrigin+e.requestStart&&f.end>=performance.timeOrigin+e.responseEnd;return i&&t&&e.initiatorType==="xmlhttprequest"}function P(e){this.end=e.responseEnd>this.end?e.responseEnd:this.end;f.requestTime+=e.responseEnd-e.startTime;if(this.roundtripHigherLimit<=e.startTime){f.navigation+=this.navigationHigherLimit-this.navigationLowerLimit;f.roundtrip+=this.roundtripHigherLimit-this.roundtripLowerLimit;this.navigationLowerLimit=e.startTime;this.roundtripLowerLimit=e.startTime}if(e.responseEnd>this.roundtripHigherLimit){this.roundtripHigherLimit=e.responseEnd}if(e.requestStart>this.navigationHigherLimit){this.navigationHigherLimit=e.requestStart}}function R(e){var t={start:e[0].startTime,end:e[0].responseEnd,navigationLowerLimit:e[0].startTime,navigationHigherLimit:e[0].requestStart,roundtripLowerLimit:e[0].startTime,roundtripHigherLimit:e[0].responseEnd};e.forEach(P,t);f.navigation+=t.navigationHigherLimit-t.navigationLowerLimit;f.roundtrip+=t.roundtripHigherLimit-t.roundtripLowerLimit;if(f.networkTime){var i=f.requestTime-f.networkTime;f.networkTime=i/e.length}else{f.networkTime=0}}function N(t){if(f){var i=performance.getEntriesByType("resource");var n;f.end=t;f.processing=t-f.start;f.duration=f.processing;f.requests=i.filter(w);f.completeRoundtrips=0;f.measurements=e.filterMeasurements(q,true);if(f.requests.length>0){R(f.requests)}f.completeRoundtrips=f.requests.length;var r=f.processing-f.navigation-f.roundtrip;f.processing=r>-1?r:0;f.completed=true;if(f.semanticStepName||f.duration>=2||f.requests.length>0||u){p.push(f);n=p[p.length-1];if(a.isLoggable()){a.debug("Interaction step finished: trigger: "+f.trigger+"; duration: "+f.duration+"; requests: "+f.requests.length,"_InteractionImpl.js")}}if(I?.onInteractionFinished){I.onInteractionFinished(n)}Object.freeze(f);f=null;g=null;u=false;l=false;c=false;clearTimeout(d)}}function A(e){var t,i;if(e){var n,r;n=sap.ui.require("sap/ui/core/Component");if(n){while(e&&e.getParent){r=n.getOwnerComponentFor(e);if(r||e instanceof n){r=r||e;var s=r.getManifestEntry("sap.app");t=s&&s.id||r.getMetadata().getName();i=s&&s.applicationVersion&&s.applicationVersion.version}e=e.getParent()}}}return{id:t?t:"undetermined",version:i?i:""}}function C(){const e=Object.getOwnPropertyDescriptor(HTMLScriptElement.prototype,"src");Object.defineProperty(HTMLScriptElement.prototype,"src",{set:function(t){var i;if(!this.dataset.sapUiCoreInteractionHandled){i=j.notifyAsyncStep();this.addEventListener("load",function(){i()});this.addEventListener("error",function(){i()});this.dataset.sapUiCoreInteractionHandled="true"}e.set.call(this,t)},get:e.get})}function _(){t.register("INTERACTION","send",function(){if(this.oPendingInteraction){this.oPendingInteraction.bytesSent+=arguments[0]?arguments[0].length:0}});t.register("INTERACTION","setRequestHeader",function(e,t){if(!this.requestHeaderLength){this.requestHeaderLength=0}this.requestHeaderLength+=(e+"").length+(t+"").length});t.register("INTERACTION","open",function(e,t,i){var n,r,s;function a(e){if(this.readyState===4){e()}}if(f){var o=!b(t);if(o){n=I?.passportHeader.get(this);if(n&&n.length>=370){r=E(n.substring(150,230));if(parseInt(n.substring(8,10),16)>2){s=n.substring(372,404)}}if(!n||r&&s&&f.passportAction.endsWith(r)){this.addEventListener("readystatechange",D.bind(this,f.id))}}if(o||i!==false){this.addEventListener("readystatechange",a.bind(this,j.notifyAsyncStep()))}this.oPendingInteraction=f}})}function O(e,t,i,n){var r=e.split(".").pop().split(/\#|\?/)[0];if(t==="gzip"||t==="br"||i in L||r&&T.indexOf(r)!==-1||n<1024){return true}else{return false}}function D(e){if(this.readyState===4){if(this.oPendingInteraction&&!this.oPendingInteraction.completed&&f.id===e){var t=this.getResponseHeader("content-length"),i=O(this.responseURL,this.getResponseHeader("content-encoding"),this.getResponseHeader("content-type"),t),n=this.getResponseHeader("sap-perf-fesrec");this.oPendingInteraction.bytesReceived+=t?parseInt(t):0;this.oPendingInteraction.bytesReceived+=this.getAllResponseHeaders().length;this.oPendingInteraction.bytesSent+=this.requestHeaderLength||0;this.oPendingInteraction.requestCompression=i&&this.oPendingInteraction.requestCompression!==false;this.oPendingInteraction.networkTime+=n?Math.round(parseFloat(n,10)/1e3):0;var r=this.getResponseHeader("sap-statistics");if(r){var s=performance.getEntriesByType("resource");this.oPendingInteraction.sapStatistics.push({url:this.responseURL,statistics:r,timing:s?s[s.length-1]:undefined})}delete this.requestHeaderLength;delete this.oPendingInteraction}}}var j={getAll:function(e){if(e){j.end(true)}return p},filter:function(e){var t=[];if(e){for(var i=0,n=p.length;i<n;i++){if(e(p[i])){t.push(p[i])}}}return t},getPending:function(){return f},clear:function(){p=[]},start:function(e,t){var n=r();if(f){N(n)}if(m){clearTimeout(m)}h=0;if(performance.clearResourceTimings){performance.clearResourceTimings()}var s=A(t);f=H(n);f.event=e;f.component=s.id;f.appVersion=s.version;if(t&&t.getId){f.trigger=t.getId();f.semanticStepName=i.getSemanticStepname(t,e)}if(a.isLoggable(null,"sap.ui.Performance")){console.time("INTERACTION: "+f.trigger+" - "+f.event)}if(a.isLoggable()){a.debug("Interaction step started: trigger: "+f.trigger+"; type: "+f.event,"_InteractionImpl.js")}},end:function(e){if(f){if(e){if(a.isLoggable(null,"sap.ui.Performance")){console.timeEnd("INTERACTION: "+f.trigger+" - "+f.event)}N(f.preliminaryEnd||r());if(a.isLoggable()){a.debug("Interaction ended...")}}else{f.preliminaryEnd=r()}}},notifyNavigation:function(){u=true},notifyShowBusyIndicator:function(e){e._sapui_fesr_fDelayedStartTime=r()+e.getBusyIndicatorDelay()},notifyHideBusyIndicator:function(e){if(e._sapui_fesr_fDelayedStartTime){var t=r()-e._sapui_fesr_fDelayedStartTime;j.addBusyDuration(t>0?t:0);delete e._sapui_fesr_fDelayedStartTime}},notifyStepStart:function(e,t,n){if(y){let r,s,a;if(!f&&g||n){if(n){r="startup"}else{r=e}j.start(r,t);f=j.getPending();if(f&&!f.completed&&I?.onInteractionStarted){f.passportAction=I.onInteractionStarted(f,n)}if(g){S=g.srcControl}a=i.getSemanticStepname(S,e);if(t&&t.getId&&S&&t.getId()===S.getId()){c=true}else if(a){f.trigger=S.getId();f.semanticStepName=a;c=true}else{s=S;while(s&&s.getParent()){s=s.getParent();if(t.getId()===s.getId()){l=true;break}}}g=null;u=false;d=setTimeout(function(){g=null},0);v=false;j.notifyStepEnd(true)}else if(f&&S&&!c){s=S;a=i.getSemanticStepname(S,e);if(s&&t.getId()===s.getId()){f.trigger=t.getId();f.semanticStepName=a;f.event=e;c=true}else if(a){f.trigger=S.getId();f.semanticStepName=a;c=true}else if(!l){while(s&&s.getParent()){s=s.getParent();if(t.getId()===s.getId()){f.trigger=t.getId();f.semanticStepName=i.getSemanticStepname(t,e);f.event=e;break}}}}}},notifyAsyncStep:function(e){if(f){if(a.isLoggable(null,"sap.ui.Performance")&&e){console.time(e)}var t=f.id;delete f.preliminaryEnd;j.notifyAsyncStepStart();return function(){j.notifyAsyncStepEnd(t);if(a.isLoggable(null,"sap.ui.Performance")&&e){console.timeEnd(e)}}}else{return function(){}}},notifyAsyncStepStart:function(){if(f){h++;clearTimeout(m);v=false;if(a.isLoggable()){a.debug("Interaction relevant step started - Number of pending steps: "+h)}}},notifyAsyncStepEnd:function(e){if(f&&e===f.id){h--;j.notifyStepEnd(true);if(a.isLoggable()){a.debug("Interaction relevant step stopped - Number of pending steps: "+h)}}},notifyStepEnd:function(e){if(y){if(h===0||!e){if(v||!e){j.end(true);if(a.isLoggable()){a.debug("Interaction stopped")}v=false}else{j.end();v=true;if(m){clearTimeout(m)}m=setTimeout(j.notifyStepEnd,301);if(a.isLoggable()){a.debug("Interaction check for bIdle time - Number of pending steps: "+h)}}}}},notifyEventStart:function(e){g=y?e:null},notifyScrollEvent:function(e){},notifyEventEnd:function(){if(g){if(g.type.match(/^(mousedown|touchstart|keydown)$/)){j.end(true)}if(this.eventEndTimer){clearTimeout(this.eventEndTimer)}this.eventEndTimer=setTimeout(function(){g=null;delete this.eventEndTimer}.bind(this),10)}},setStepComponent:function(e){if(y&&f&&e&&!f.stepComponent){f.stepComponent=e}},addBusyDuration:function(e){if(y&&f){if(!f.busyDuration){f.busyDuration=0}f.busyDuration+=e}},_setActive:function(e){y=e;if(e){j.notifyStepStart("startup","startup",true)}},_setFESR:function(e){I=e}};_();C();n.notifyResourceLoading=j.notifyAsyncStep;return j});
//# sourceMappingURL=_InteractionImpl.js.map