/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/core/ElementRegistry","sap/ui/core/Control","sap/ui/qunit/utils/nextUIUpdate"],function(t,e,n){"use strict";if(typeof QUnit==="undefined"){sap.ui.requireSync("sap/ui/qunit/qunit-css");sap.ui.requireSync("sap/ui/thirdparty/qunit");sap.ui.requireSync("sap/ui/qunit/qunit-junit");sap.ui.requireSync("sap/ui/qunit/qunit-coverage")}QUnit.config.reorder=false;var o={};function a(){return t.all()}var r=function(t){var e=t.getMetadata().getAllProperties();for(var n in e){if(t.isPropertyInitial(n)){var o=e[n];try{t[o._sMutator]("dummyValueForMemLeakTest")}catch(t){}}}if(!t.getTooltip()){t.setTooltip("test")}};var i=function(t,o,i,l){QUnit.test("Control "+t+" should not have any memory leaks",async function(t){var u=o();t.ok(u,"calling fnControlFactory() should return something (a control)");t.ok(u instanceof e,"calling fnControlFactory() should return something that is really instanceof sap.ui.core.Control");if(u.placeAt&&!l){try{u.getMetadata().getRenderer()}catch(e){t.ok(false,"Error: control does not have a renderer. If this is known, please set the 'bControlCannotRender' flag when calling MemoryLeakCheck.checkControl")}}r(u);if(u.placeAt&&!l){try{u.placeAt("qunit-fixture");await n()}catch(e){t.ok(false,"Error: control has a renderer, but could not be rendered. If this is known, please set the 'bControlCannotRender' flag when calling MemoryLeakCheck.checkControl");throw e}}if(i){i(u);await n()}u.destroy();await n();var s=a(),f=o();r(f);if(f.placeAt&&!l){f.placeAt("qunit-fixture");await n();f.invalidate();await n()}if(i){i(f);await n()}f.destroy();await n();var d=a();c(t,d,s,"Memory leak check should not find any leftover controls after creating two instances and rendering twice"+(i?"\n(and calling fnSomeAdditionalFunction)":""))})};var c=function(t,e,n,o){var a=[];for(var r in e){if(!n[r]){a.push(e[r])}}for(var i=0;i<a.length;i++){if(typeof a[i].getText==="function"){a[i]+=" (text: '"+a[i].getText()+"')"}}o=o+(a.length>0?". LEFTOVERS: "+a.join(", "):"");t.equal(a.length,0,o)};o.checkControl=function(e,n,o,r){if(typeof e!=="string"){r=o;o=n;n=e;e="[some control, id: "+Math.random()+" - please update your test to also pass the control name]"}if(o===true||o===false){r=o;o=undefined}var c;QUnit.module("MemoryLeakCheck.checkControl: "+e,{beforeEach:function(){c=a()},afterEach:function(e){t.forEach(function(t,n){if(!c[n]){e.ok(t.getMetadata().getName(),"Cleanup of id: "+n+", control: "+t.getMetadata().getName());t.destroy()}})}});QUnit.test("MemoryLeakCheck.checkControl(fnControlFactory) should receive a control factory",function(t){t.equal(typeof n,"function","MemoryLeakCheck should have received a control factory");t.ok(document.getElementById("qunit-fixture"),"the test page HTML should contain an element with ID 'qunit-fixture'")});i(e,n,o,r)};return o},true);
//# sourceMappingURL=MemoryLeakCheck.js.map