/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/base/ManagedObject","sap/ui/core/postmessage/Bus","sap/ui/core/Lib","sap/base/util/uid","sap/base/util/merge","sap/ui/rta/util/ServiceEventBus","sap/ui/thirdparty/URI"],function(e,t,s,i,r,n,a){"use strict";var o="sap.ui.rta.service.receiver";var u="pending";var h="accepted";var c="declined";var d=e.extend("sap.ui.rta.Client",{metadata:{library:"sap.ui.rta",properties:{window:"object",origin:"string"}},_bInit:false,constructor:function(...i){e.apply(this,i);if(!this.getWindow()){throw new TypeError("sap.ui.rta.Client: window parameter is required")}if(!this.getOrigin()){throw new TypeError("sap.ui.rta.Client: origin parameter is required")}this._oPostMessageBus=t.getInstance();this._sStatus=u;this._mPendingRequests={};this._aRequestQueue=[];this._oServiceEventBus=null;this._mEventHandlerIds={};this._oPostMessageBus.subscribeOnce(o,t.event.READY,function(e){if(!this._isValidMessage(e)){return}this._oPostMessageBus.subscribeOnce(o,t.event.ACCEPTED,function(e){if(!this._isValidMessage(e)){return}this._sStatus=h;var t=this._aRequestQueue.slice();this._aRequestQueue=[];t.forEach(this._sendRequest,this);this._oPostMessageBus.subscribe(o,"getService",this._receiverMethods,this);this._oPostMessageBus.subscribe(o,"callMethod",this._receiverMethods,this);this._oPostMessageBus.subscribe(o,"subscribe",this._receiverMethods,this);this._oPostMessageBus.subscribe(o,"unsubscribe",this._receiverMethods,this);this._oPostMessageBus.subscribe(o,"event",this._receiverEvents,this)},this);this._oPostMessageBus.subscribeOnce(o,t.event.DECLINED,function(e){if(!this._isValidMessage(e)){return}this._sStatus=c;var t=this._aRequestQueue.slice();this._aRequestQueue=[];t.forEach(function(e){e.reject(new Error("sap.ui.rta.Client.getService(): connection to RuntimeAuthoring instance has been refused"))})},this);this._oPostMessageBus.publish({target:this.getWindow(),origin:this.getOrigin(),channelId:o,eventId:t.event.CONNECT,data:s.getResourceBundleFor("sap.ui.rta").getText("SERVICE_NAME")})},this);this._bInit=true}});d.prototype.destroy=function(...t){this._oPostMessageBus.unsubscribe(o,"getService",this._receiverMethods,this);this._oPostMessageBus.unsubscribe(o,"callMethod",this._receiverMethods,this);this._oPostMessageBus.unsubscribe(o,"subscribe",this._receiverMethods,this);this._oPostMessageBus.unsubscribe(o,"unsubscribe",this._receiverMethods,this);this._oPostMessageBus.unsubscribe(o,"event",this._receiverEvents,this);e.prototype.destroy.apply(this,t)};d.prototype.getService=function(e){if(typeof e!=="string"){throw new TypeError("sap.ui.rta.Client.getService(): invalid service name specified")}return this._sendRequest(this._createRequest({target:this.getWindow(),origin:this.getOrigin(),channelId:o,eventId:"getService",data:{arguments:[e]}}))};d.prototype._createRequest=function(e){var t=i();var s={id:t,request:{target:e.target,origin:e.origin,channelId:o,eventId:e.eventId,data:{id:t,type:"request",body:e.data}}};s.promise=new Promise(function(e,t){s.resolve=e;s.reject=t});return s};d.prototype._sendRequest=function(e){switch(this._sStatus){case h:this._mPendingRequests[e.id]=e;this._oPostMessageBus.publish(e.request);break;case u:this._aRequestQueue.push(e);break;case c:e.reject(new Error("sap.ui.rta.Client.getService(): connection to RuntimeAuthoring instance has been refused"));break;default:}return e.promise};d.prototype._isValidMessage=function(e){return this.getWindow()===e.source&&this.getOrigin()===e.origin};d.prototype._receiverMethods=function(e){if(!this._isValidMessage(e)){return}var t=e.data;if(t.type!=="response"){return}var s=this._mPendingRequests[t.id];switch(e.eventId){case"getService":var i=s.request.data.body.arguments[0];var a=t.body.methods||[];var u=t.body.events;var h=r(a.reduce(function(t,s){t[s]=function(...t){return this._sendRequest(this._createRequest({target:e.source,origin:e.origin,channelId:o,eventId:"callMethod",data:{service:i,method:s,arguments:t}}))}.bind(this);return t}.bind(this),{}),t.body.properties);if(Array.isArray(u)&&u.length>0){this._oServiceEventBus||=new n;r(h,{attachEvent:function(t,s,r){if(typeof t!=="string"||!t){throw new TypeError("sap.ui.rta.Client: sEventName must be a non-empty string when calling attachEvent() for a service")}if(typeof s!=="function"){throw new TypeError("sap.ui.rta.Client: fnFunction must be a function when calling attachEvent() for a service")}var n=this._oServiceEventBus.getChannel(i);var a=!n||!n.hasListeners(t);this._oServiceEventBus.subscribe(i,t,s,r);if(a){this._sendRequest(this._createRequest({target:e.source,origin:e.origin,channelId:o,eventId:"subscribe",data:{service:i,event:t}})).then(function(e){this._mEventHandlerIds[`${i},${t}`]=e.id;this._checkIfEventAlive(i,t)}.bind(this))}}.bind(this),detachEvent:function(e,t,s){if(typeof e!=="string"||!e){throw new TypeError("sap.ui.rta.Client: sEventName must be a non-empty string when calling detachEvent() for a service")}if(typeof t!=="function"){throw new TypeError("sap.ui.rta.Client: fnFunction must be a function when calling detachEvent() for a service")}this._oServiceEventBus.unsubscribe(i,e,t,s);this._checkIfEventAlive(i,e)}.bind(this),attachEventOnce(e,t,s){function i(...r){h.detachEvent(e,i);t.apply(s,r)}h.attachEvent(e,i)}})}s.resolve(h);delete this._mPendingRequests[t.id];break;case"callMethod":if(t.status==="success"){s.resolve(t.body)}else{s.reject(t.body)}delete this._mPendingRequests[t.id];break;case"subscribe":case"unsubscribe":s.resolve(t.body);delete this._mPendingRequests[t.id];break;default:}};d.prototype._checkIfEventAlive=function(e,t){var s=this._oServiceEventBus.getChannel(e);var i=this._mEventHandlerIds[`${e},${t}`];if((!s||!s.hasListeners(t))&&i){this._sendRequest(this._createRequest({target:this.getWindow(),origin:this.getOrigin(),channelId:o,eventId:"unsubscribe",data:{service:e,event:t,id:i}}))}};d.prototype._receiverEvents=function(e){if(!this._isValidMessage(e)){return}var t=e.data.body;this._oServiceEventBus.publish(t.service,t.event,t.data)};d.prototype.setWindow=function(e){if(this._bInit){throw new TypeError("sap.ui.rta.Client: Window parameter cannot be changed at runtime; recreate instance of the Client.")}if(!e){throw new TypeError("sap.ui.rta.Client: Window parameter is required")}if(e===window){throw new TypeError("sap.ui.rta.Client: Window object has to be different from the one where Client is running")}this.setProperty("window",e);return this};d.prototype.setOrigin=function(e){if(this._bInit){throw new TypeError("sap.ui.rta.Client: Cannot change origin parameter at runtime; recreate instance of the Client.")}if(!e){throw new TypeError("sap.ui.rta.Client: Origin parameter is required")}if(typeof e!=="string"){throw new TypeError("sap.ui.rta.Client: Origin parameter has to be a string")}if(new a(e).origin()!==e){throw new TypeError("sap.ui.rta.Client: Origin string is invalid")}this.setProperty("origin",e);return this};return d});
//# sourceMappingURL=Client.js.map