/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/base/strings/capitalize","sap/base/Log","sap/m/MessageBox","sap/m/MessageToast","sap/ui/base/ManagedObject","sap/ui/core/BusyIndicator","sap/ui/core/Lib","sap/ui/dt/DesignTime","sap/ui/dt/DOMUtil","sap/ui/dt/ElementUtil","sap/ui/dt/Overlay","sap/ui/dt/OverlayRegistry","sap/ui/dt/Util","sap/ui/events/KeyCodes","sap/ui/fl/apply/_internal/flexState/ManifestUtils","sap/ui/fl/apply/api/FlexRuntimeInfoAPI","sap/ui/fl/initial/api/Version","sap/ui/fl/write/api/ContextBasedAdaptationsAPI","sap/ui/fl/write/api/ControlPersonalizationWriteAPI","sap/ui/fl/write/api/FeaturesAPI","sap/ui/fl/write/api/PersistenceWriteAPI","sap/ui/fl/write/api/ReloadInfoAPI","sap/ui/fl/write/api/TranslationAPI","sap/ui/fl/write/api/VersionsAPI","sap/ui/fl/Layer","sap/ui/fl/LayerUtils","sap/ui/fl/requireAsync","sap/ui/fl/Utils","sap/ui/model/json/JSONModel","sap/ui/performance/Measurement","sap/ui/rta/appVariant/Feature","sap/ui/rta/command/BaseCommand","sap/ui/rta/command/LREPSerializer","sap/ui/rta/command/Stack","sap/ui/rta/toolbar/Fiori","sap/ui/rta/toolbar/FioriLike","sap/ui/rta/toolbar/Standalone","sap/ui/rta/util/changeVisualization/ChangeVisualization","sap/ui/rta/util/guidedTour/content/GeneralTour","sap/ui/rta/util/guidedTour/GuidedTour","sap/ui/rta/util/whatsNew/WhatsNew","sap/ui/rta/util/PluginManager","sap/ui/rta/util/PopupManager","sap/ui/rta/util/ReloadManager","sap/ui/rta/util/ServiceManager","sap/ui/rta/util/validateFlexEnabled","sap/ui/rta/Utils","sap/ui/Device"],function(t,e,i,a,o,n,s,r,l,c,d,h,g,u,p,f,S,m,C,y,_,A,b,v,R,w,M,T,E,P,D,I,O,L,N,V,x,U,k,B,F,G,z,K,W,H,$,j){"use strict";const Y="STARTING";const q="STARTED";const Z="STOPPED";const J="FAILED";const Q=o.extend("sap.ui.rta.RuntimeAuthoring",{metadata:{library:"sap.ui.rta",associations:{rootControl:{type:"sap.ui.base.ManagedObject"}},properties:{showToolbars:{type:"boolean",defaultValue:true},triggeredFromDialog:{type:"boolean",defaultValue:false},showWindowUnloadDialog:{type:"boolean",defaultValue:true},commandStack:{type:"any"},flexSettings:{type:"object",defaultValue:{layer:R.CUSTOMER,developerMode:true}},mode:{type:"string",defaultValue:"adaptation"},metadataScope:{type:"string",defaultValue:"default"}},events:{start:{parameters:{editablePluginsCount:{type:"int"}}},stop:{},failed:{parameters:{error:{type:"any"}}},selectionChange:{parameters:{selection:{type:"sap.ui.dt.Overlay[]"}}},modeChanged:{},undoRedoStackModified:{}}},_sAppTitle:null,_dependents:null,_sStatus:Z,_bNavigationModeWarningShown:false,constructor:function(...t){o.apply(this,t);this._dependents={};this._mUShellServices={};this._pElementModified=Promise.resolve();this.addDependent(new G,"pluginManager");this.addDependent(new z,"popupManager");this.addDependent(new W,"serviceManager");if(this.getShowToolbars()){this.getPopupManager().attachOpen(at,this);this.getPopupManager().attachClose(ot,this);this.addDependent(new U,"changeVisualization")}this.pServices=Promise.resolve();if(window.parent!==window){this.pServices=this.getService("receiver")}this.pServices=this.pServices.then(this.getService.bind(this,"supportTools"));this._loadUShellServicesPromise=T.getUShellServices(["URLParsing","AppLifeCycle","Navigation"]).then(function(t){this._mUShellServices=t;K.setUShellServices(t);return y.isSeenFeaturesAvailable()}.bind(this)).then(function(t){if(t&&!K.getDontShowWhatsNewAfterReload()){this.addDependent(new F({layer:this.getLayer()}),"whatsNew")}this.addDependent(new B,"guidedTour");return Promise.resolve()}.bind(this))}});Q.prototype.addDependent=function(e,i,a){a=typeof a==="undefined"?true:!!a;if(!(i in this._dependents)){if(i&&a){this[`get${t(i,0)}`]=this.getDependent.bind(this,i)}this._dependents[i||e.getId()]=e}else{throw g.createError("RuntimeAuthoring#addDependent",`Can't add dependency with same key '${i}'`,"sap.ui.rta")}};Q.prototype.getDependent=function(t){return this._dependents[t]};Q.prototype.getDependents=function(){return this._dependents};Q.prototype.removeDependent=function(t){delete this._dependents[t]};Q.prototype.setPlugins=function(t){if(this._sStatus!==Z){throw Error("Cannot replace plugins: runtime authoring already started")}this.getPluginManager().setPlugins(t)};Q.prototype.getPlugins=function(){return this.getPluginManager&&this.getPluginManager()&&this.getPluginManager().getPlugins()};Q.prototype.getDefaultPlugins=function(){return this.getPluginManager().getDefaultPlugins(this.getFlexSettings())};Q.prototype.setFlexSettings=function(t){const e=new URLSearchParams(window.location.search);const i=e.get("sap-ui-layer");t={...this.getFlexSettings(),...t};if(i){t.layer=i.toUpperCase()}if(t.scenario||t.baseId){const e=T.buildLrepRootNamespace(t.baseId,t.scenario,t.projectId);t.rootNamespace=e;t.namespace=`${e}changes/`}$.setRtaStyleClassName(t.layer);this.setProperty("flexSettings",t)};Q.prototype.getLayer=function(){return this.getFlexSettings().layer};Q.prototype.getRootControlInstance=function(){this._oRootControl||=c.getElementInstance(this.getRootControl());return this._oRootControl};Q.prototype._getTextResources=function(){return s.getResourceBundleFor("sap.ui.rta")};Q.prototype.start=async function(){if(this._sStatus!==Z){throw Error("RuntimeAuthoring is already started")}this._sStatus=Y;const t=this.getRootControlInstance();if(!t){throw Error("Root control not found")}try{await this._loadUShellServicesPromise;await Lt.call(this);await Nt.call(this,Q.needsRestart(this.getLayer()));const e=await K.handleReloadOnStart({layer:this.getLayer(),selector:t,versioningEnabled:this._oVersionsModel.getProperty("/versioningEnabled"),developerMode:this.getFlexSettings().developerMode,adaptationId:this._oContextBasedAdaptationsModel.getProperty("/displayedAdaptation/id")});if(e){throw Error("Reload triggered")}_.setAdaptationLayer(this.getLayer(),t);const i=_.getResetAndPublishInfoFromSession(t);this.bInitialResetEnabled=!!i.isResetEnabled;this._oSerializer=new O({commandStack:this.getCommandStack(),rootControl:this.getRootControl()});this.getPluginManager().preparePlugins(this.getFlexSettings(),Ft.bind(this),this.getCommandStack());const a=X.call(this);this._oldUnloadHandler=window.onbeforeunload;window.onbeforeunload=this._onUnload.bind(this);if(this.getShowToolbars()){const e=await lt(t,this.getLayer(),this._oSerializer);await Vt.call(this,e)}await ht.call(this);d.getOverlayContainer().style.setProperty("--sap-ui-rta-scrollbar-scrollWidth",`${l.getScrollbarWidth()}px`);d.getOverlayContainer().style.setProperty("--sap-ui-rta-scrollbar-scrollWidthPlusTwo",`${l.getScrollbarWidth()+2}px`);await a;if(this.getChangeVisualization){this.getChangeVisualization()._oDesignTime=this._oDesignTime}et.call(this,true);const o=await ct(this.getRootControlInstance(),this.getLayer());if(o){const t=this.getGuidedTour();t.attachTourClosed(()=>{if(this.getWhatsNew){const t=["GuidedTour"];this.getWhatsNew().initializeWhatsNewDialog(t)}});k.getTourContent();t.autoStart(k.getTourContent())}else if(this.getWhatsNew){this.getWhatsNew().initializeWhatsNewDialog()}this.getPopupManager().setRta(this);if(this.getShowToolbars()){await this.getToolbar().show()}this.fnKeyDown=pt.bind(this);document.addEventListener("keydown",this.fnKeyDown);this.fnOnPersonalizationChangeCreation=nt.bind(this);C.attachChangeCreation(t,this.fnOnPersonalizationChangeCreation);it.call(this);this._sStatus=q;Q.disableRestart(this.getLayer());this.fireStart({editablePluginsCount:this.getPluginManager().getEditableOverlaysCount()});await this.pServices}catch(t){if(t.message==="Reload triggered"){this.destroy()}else{this._sStatus=J;this.fireFailed({vError:t.message})}throw Error(t.message)}};function X(){const t=this.getPluginManager().getPluginList();return new Promise(function(e,i){P.start("rta.dt.startup","Measurement of RTA: DesignTime start up");this._oDesignTime=new r({scope:this.getMetadataScope(),plugins:t});rt(this.getRootControlInstance(),true);this._oDesignTime.addRootElement(this._oRootControl);d.getOverlayContainer().classList.add("sapUiRta");document.body.classList.add("sapUiRtaMode");this._oDesignTime.getSelectionManager().attachChange(function(t){this.fireSelectionChange({selection:t.getParameter("selection")})},this);this._oDesignTime.attachEventOnce("synced",function(){e();P.end("rta.dt.startup","Measurement of RTA: DesignTime start up")},this);this._oDesignTime.attachEventOnce("syncFailed",function(t){i(t.getParameter("error"))})}.bind(this))}function tt(){const t=this._oVersionsModel.getProperty("/versioningEnabled");const e=t?"MSG_UNSAVED_DRAFT_CHANGES_ON_CLOSE":"MSG_UNSAVED_CHANGES_ON_CLOSE";const i=t?"BTN_UNSAVED_DRAFT_CHANGES_ON_CLOSE_SAVE":"BTN_UNSAVED_CHANGES_ON_CLOSE_SAVE";return $.showMessageBox("warning",e,{titleKey:"TIT_UNSAVED_CHANGES_ON_CLOSE",actionKeys:[i,"BTN_UNSAVED_CHANGES_ON_CLOSE_DONT_SAVE"],emphasizedActionKey:"BTN_UNSAVED_CHANGES_ON_CLOSE_SAVE",showCancel:true})}Q.prototype.stop=async function(t,e,a){let o;gt.call(this,"setBusy",true);try{t||=!_.hasDirtyChanges({selector:this.getRootControlInstance()});await ut.call(this);if(!t&&this.canSave()&&!a){const t=await tt.call(this);if(t===i.Action.CANCEL){o=true;throw Error()}if(t===this._getTextResources().getText("BTN_UNSAVED_CHANGES_ON_CLOSE_DONT_SAVE")){await this._oSerializer.clearCommandStack(true)}}const n=e?{}:await K.checkReloadOnExit({layer:this.getLayer(),selector:this.getRootControlInstance(),isDraftAvailable:this._oVersionsModel.getProperty("/draftAvailable"),versioningEnabled:this._oVersionsModel.getProperty("/versioningEnabled"),activeVersion:this._oVersionsModel.getProperty("/activeVersion"),changesNeedReloadPromise:this._bSavedChangesNeedReload?Promise.resolve(true):this._oSerializer.needsReload()});if(!t){await this._serializeToLrep(false,true)}gt.call(this,"hide",t);this.fireStop();if(!e){A.removeInfoSessionStorage(this.getRootControlInstance());K.handleReloadOnExit(n);K.removeDontShowWhatsNewAfterReload()}v.clearInstances()}catch(t){if(!o){dt(t)}}gt.call(this,"setBusy",false);et.call(this,false);if(!o){this._sStatus=Z;document.body.classList.remove("sapUiRtaMode")}};Q.prototype.setCommandStack=function(t){const e=this.getProperty("commandStack");if(e){e.detachModified(ht,this)}if(this._oInternalCommandStack){this._oInternalCommandStack.destroy();delete this._oInternalCommandStack}const i=this.setProperty("commandStack",t);if(t){t.attachModified(ht,this)}if(this.getPluginManager&&this.getPluginManager()){this.getPluginManager().provideCommandStack(t)}return i};Q.prototype.getCommandStack=function(){let t=this.getProperty("commandStack");if(!t){t=new L;this._oInternalCommandStack=t;this.setCommandStack(t)}return t};Q.prototype.setMode=function(t){const e=this.getMode();if(e!==t){const i=this.getPluginManager().getPlugin("selection");if(e==="navigation"||t==="navigation"){this._oDesignTime.setEnabled(t!=="navigation");et.call(this,e==="navigation")}const a=this.getChangeVisualization?.();if(t==="visualization"||e==="visualization"){g.waitForSynced(this._oDesignTime)().then(function(){return a.triggerModeChange(this.getRootControl(),this.getToolbar())}.bind(this))}if(e==="adaptation"){this.getPluginManager().handleStopCutPaste()}i.setIsActive(!(t==="visualization"));const o=d.getOverlayContainer();if(t==="visualization"){o.classList.add("sapUiRtaVisualizationMode")}else{o.classList.remove("sapUiRtaVisualizationMode")}if(t==="visualization"){document.querySelectorAll(".sapUiDtOverlayMovable").forEach(function(t){t.style.cursor="default"})}else{document.querySelectorAll(".sapUiDtOverlayMovable").forEach(function(t){t.style.cursor="move"})}this._oToolbarControlsModel.setProperty("/modeSwitcher",t);this.setProperty("mode",t);this.fireModeChanged({mode:t})}};Q.prototype.setMetadataScope=function(t){if(this._sStatus!==Z){e.error("sap.ui.rta: Failed to set metadata scope on RTA instance after RTA is started");return}this.setProperty("metadataScope",t)};Q.prototype.destroy=function(...t){const e=Object.keys(this._dependents);e.forEach(function(t){this._dependents[t].destroy(true);this.removeDependent(t)}.bind(this));et.call(this,false);if(this._oDesignTime){this._oDesignTime.destroy();this._oDesignTime=null;document.removeEventListener("keydown",this.fnKeyDown);if(this.fnOnPersonalizationChangeCreation){C.detachChangeCreation(this.getRootControlInstance(),this.fnOnPersonalizationChangeCreation)}}if(this.getRootControlInstance()){rt(this.getRootControlInstance(),false)}this.setCommandStack(null);window.onbeforeunload=this._oldUnloadHandler;o.prototype.destroy.apply(this,t)};Q.needsRestart=function(t){return K.needsAutomaticStart(t)};Q.enableRestart=function(t,e){K.enableAutomaticStart(t,e)};Q.disableRestart=function(t){K.disableAutomaticStart(t)};Q.willRTAStartAfterReload=function(t){return K.needsAutomaticStart(t||R.CUSTOMER)};Q.prototype.getSelection=function(){if(this._oDesignTime){return this._oDesignTime.getSelectionManager().get()}return[]};Q.prototype.restore=function(){const t=this.getLayer();const e="FORM_PERS_RESET_MESSAGE";const a="FORM_PERS_RESET_TITLE";this.getPluginManager().handleStopCutPaste();return $.showMessageBox("warning",e,{titleKey:a,actions:[i.Action.OK,i.Action.CANCEL],emphasizedAction:i.Action.OK}).then(function(e){if(e===i.Action.OK){Q.enableRestart(t,this.getRootControlInstance());return xt.call(this)}return undefined}.bind(this))};Q.prototype.undo=function(){this.getPluginManager().handleStopCutPaste();return this.getCommandStack().undo()};Q.prototype.redo=function(){this.getPluginManager().handleStopCutPaste();return this.getCommandStack().redo()};Q.prototype.canUndo=function(){return this.getCommandStack().canUndo()};Q.prototype.canSave=function(){return this.getCommandStack().canSave()};Q.prototype.canRedo=function(){return this.getCommandStack().canRedo()};Q.prototype.save=function(){return ut.call(this).then(this._serializeToLrep.bind(this))};Q.prototype._serializeToLrep=function(t,e,i){if(!this._bSavedChangesNeedReload){return this._oSerializer.needsReload().then(function(a){this._bSavedChangesNeedReload=a;return mt.call(this,i,t,e)}.bind(this))}return mt.call(this,i,t,e)};Q.prototype.condenseAndSaveChanges=function(...t){return this._serializeToLrep(...t)};Q.prototype._onUnload=function(){if(this.canSave()&&this.getShowWindowUnloadDialog()){return this._getTextResources().getText("MSG_UNSAVED_CHANGES")}window.onbeforeunload=this._oldUnloadHandler;return undefined};function et(t){this._oDesignTime?.getRootElements().forEach(e=>{const i=e.isA("sap.ui.core.Component")?e.getRootControl():e;i?.setBlocked(t)})}function it(){const t=new URLSearchParams(window.location.search).get("sap-ui-rta-skip-flex-validation");const e=f.isCustomerSystem();if(!e&&t!=="true"){H(this)}}function at(t){const e=t.getParameters().getSource();if(e.isA("sap.m.Dialog")&&this.getToolbar().type==="fiori"){this.getToolbar().setColor("contrast")}this.getToolbar().bringToFront()}function ot(t){if(t.getParameters().isA("sap.m.Dialog")){this.getToolbar().setColor()}}function nt(){if(this.getMode()==="navigation"&&!this._bNavigationModeWarningShown){st.call(this,"MSG_NAVIGATION_MODE_CHANGES_WARNING",{duration:5e3});this._bNavigationModeWarningShown=true}}function st(t,e){const i=this._getTextResources().getText(t);a.show(i,e||{})}function rt(t,e){if(t.isA("sap.ui.core.UIComponent")){t=t.getRootControl()}if(t){t[e?"addStyleClass":"removeStyleClass"]("sapUiRtaRoot")}}async function lt(t,e,i){const a=await y.isPublishAvailable();const o=await D.isSaveAsAvailable(t,e,i);const n=await y.isContextBasedAdaptationAvailable(e);const s=await T.getUShellService("AppLifeCycle");const r=s?.getCurrentApplication()?.homePage||false;return{publishAvailable:a,saveAsAvailable:!r&&a&&o,contextBasedAdaptationAvailable:!r&&n}}async function ct(t,e){const i=T.getConnectors();const a=["LocalStorageConnector","SessionStorageConnector"];const o=i.length>0;const n=o&&i.every(t=>!a.includes(t));if(!n||w.isDeveloperLayer(e)){return false}const s=await f.getUserId();if(s==="DEFAULT_USER"||!s){return false}const r=await _._getFlexObjectsForUser({selector:t,layer:e});if(!r||r.length>0){return false}const l=(await y.getSeenFeatureIds({layer:e})).length>0;return!l}function dt(t){n.hide();const a=t.userMessage||t.stack||t.message||t.status||t;const o=s.getResourceBundleFor("sap.ui.rta");e.error("Failed to transfer changes",a);const r=`${o.getText("MSG_LREP_TRANSFER_ERROR")}\n\t\t\t${o.getText("MSG_ERROR_REASON",[a])}`;i.error(r,{styleClass:$.getRtaStyleClassName()})}async function ht(){const t=!this.getShowToolbars()||!this.getCommandStack().canUndo();try{const e=await $.checkDraftOverwrite(this._oVersionsModel,t);if(e){await v.discardDraft({layer:this.getLayer(),control:this.getRootControlInstance(),updateState:true,discardDraftAndKeepActiveVersion:true})}if(this.getShowToolbars()){const t=this.getCommandStack();const e=t.canUndo();const i=t.canRedo();const a=t.canSave();const o=t.getSaved();const n=this._oToolbarControlsModel.getProperty("/translation/visible")&&b.hasTranslationRelevantDirtyChanges({layer:R.CUSTOMER,selector:this.getRootControlInstance()});this._oVersionsModel.setDirtyChanges(_.hasDirtyChanges({selector:this.getRootControlInstance()}));this._oToolbarControlsModel.setProperty("/undo/enabled",e);this._oToolbarControlsModel.setProperty("/redo/enabled",i);this._oToolbarControlsModel.setProperty("/save/enabled",a);this._oToolbarControlsModel.setProperty("/restore/enabled",this.bInitialResetEnabled||a||o);this._oToolbarControlsModel.setProperty("/translation/enabled",this.bPersistedDataTranslatable||n);const s=this._bSavedChangesNeedReload||await this._oSerializer.needsReload();this._oToolbarControlsModel.setProperty("/changesNeedHardReload",s)}this.fireUndoRedoStackModified()}catch(t){this.undo()}}function gt(t,e){if(this.getShowToolbars()&&this.getToolbar&&this.getToolbar()){return this.getToolbar()[t](e)}return undefined}async function ut(){await(this._oDesignTime?.waitForBusyPlugins());return this._pElementModified}function pt(t){const e=j.os.macintosh;const i=d.getOverlayContainer().contains(document.activeElement);const a=this.getShowToolbars()&&this.getToolbar().getDomRef().contains(document.activeElement);let o=false;document.querySelectorAll(".sapUiDtContextMenu").forEach(function(t){if(t.contains(document.activeElement)){o=true}});const n=document.body===document.activeElement;const s=l.getParents(document.activeElement,".sapUiRtaEditableField").length>0;if((i||a||o||n)&&!s){const i=e?t.metaKey:t.ctrlKey;if(t.keyCode===u.Z&&t.shiftKey===false&&t.altKey===false&&i===true){this.undo().then(t.stopPropagation.bind(t))}else if((e&&t.keyCode===u.Z&&t.shiftKey===true||!e&&t.keyCode===u.Y&&t.shiftKey===false)&&t.altKey===false&&i===true){this.redo().then(t.stopPropagation.bind(t))}}}async function ft(){if(this.canSave()){const t=await $.showMessageBox("information","MSG_SAVE_AND_RELOAD_DIALOG",{actions:[i.Action.OK,i.Action.CANCEL],emphasizedAction:i.Action.OK});if(t===i.Action.CANCEL){return}}await this.save();if(this._oVersionsModel.getProperty("/versioningEnabled")){await v.loadDraftForApplication({control:this.getRootControlInstance(),layer:this.getLayer()})}Q.enableRestart(this.getLayer(),this.getRootControlInstance());await this.stop(true,true,true);K.reloadPage()}function St(t){const e=t.getParameter("callback")||function(){};const i=this._oVersionsModel.getProperty("/versioningEnabled");return this.save().then(function(){st.call(this,i?"MSG_SAVE_DRAFT_SUCCESS":"MSG_SAVE_SUCCESS",{duration:5e3})}.bind(this)).catch(function(t){return dt(t)}).then(e)}async function mt(t,e,i){if(this.getShowToolbars()){this.bPersistedDataTranslatable=this._oToolbarControlsModel.getProperty("/translation/enabled")}const a={layer:this.getLayer(),removeOtherLayerChanges:true,condenseAnyLayer:e};if(this._oVersionsModel.getProperty("/versioningEnabled")){const e=this._oVersionsModel.getProperty("/displayedVersion");let o=t?e:undefined;o||=i?undefined:S.Number.Draft;a.version=o;a.saveAsDraft=this.getLayer()===R.CUSTOMER&&e===S.Number.Draft}if(this._oContextBasedAdaptationsModel.getProperty("/contextBasedAdaptationsEnabled")){a.adaptationId=i?undefined:this._oContextBasedAdaptationsModel.getProperty("/displayedAdaptation/id")}await this._oSerializer.saveCommands(a);if(!i&&this.getChangeVisualization){const t=this.getToolbar();const e=this.getChangeVisualization();e.updateAfterSave(t)}}async function Ct(t){const e=t.getParameter("versionTitle");if(It.call(this)&&Ot.call(this)){const t=await $.showMessageBox("warning","MSG_DRAFT_DISCARD_ON_REACTIVATE_DIALOG",{titleKey:"TIT_DRAFT_DISCARD_ON_REACTIVATE_DIALOG",actions:[i.Action.OK,i.Action.CANCEL],emphasizedAction:i.Action.OK});if(t===i.Action.OK){return yt.call(this,e)}}return yt.call(this,e)}async function yt(t){const e=this.getLayer();const i=this.getRootControlInstance();const a=this._oVersionsModel.getProperty("/displayedVersion");try{await this._serializeToLrep(false,false,true);await v.activate({layer:e,control:i,title:t,displayedVersion:a});await _.updateResetAndPublishInfo({selector:i,layer:e});st.call(this,"MSG_DRAFT_ACTIVATION_SUCCESS");this.getPluginManager().getPlugin("toolHooks").setVersionWasActivated(true);this.bInitialResetEnabled=true;this._oToolbarControlsModel.setProperty("/restore/enabled",true);this.getCommandStack().removeAllCommands()}catch(t){$.showMessageBox("error","MSG_DRAFT_ACTIVATION_FAILED",{error:t})}}async function _t(){const t=await $.showMessageBox("warning","MSG_DRAFT_DISCARD_DIALOG",{actions:[i.Action.OK,i.Action.CANCEL],emphasizedAction:i.Action.OK});if(t===i.Action.OK){await v.discardDraft({layer:this.getLayer(),control:this.getRootControlInstance(),updateState:true});await At.call(this)}}function At(){const t=this.getLayer();const e={layer:t,removeDraft:true,selector:this.getRootControlInstance()};Q.enableRestart(t,this.getRootControlInstance());this.getCommandStack().removeAllCommands();K.triggerReload(e);return this.stop(true,true)}function bt(){if(this.canSave()){vt.call(this,"DAC_DATA_LOSS_DIALOG_DESCRIPTION","DAC_DIALOG_HEADER",true)}else{vt.call(this,"DAC_DIALOG_DESCRIPTION","DAC_DIALOG_HEADER")}}function vt(t,e,a){$.showMessageBox("confirm",t,{titleKey:e}).then(function(t){if(t===i.Action.OK){n.show();if(a){this.getCommandStack().removeAllCommands(true)}Rt.call(this)}}.bind(this))}function Rt(){P.start("onCBADeleteAdaptation","Measurement of deleting a context-based adaptation");m.remove({control:this.getRootControlInstance(),layer:this.getLayer(),adaptationId:this._oContextBasedAdaptationsModel.getProperty("/displayedAdaptation/id")}).then(function(){n.hide();const t=this._oContextBasedAdaptationsModel.deleteAdaptation();Tt.call(this,t);P.end("onCBADeleteAdaptation");if(P.getActive()){e.info(`onCBADeleteAdaptation: ${P.getMeasurement("onCBADeleteAdaptation").time} ms`)}}.bind(this)).catch(function(t){n.hide();e.error(t.stack);const i="MSG_LREP_TRANSFER_ERROR";const a={titleKey:"DAC_DIALOG_HEADER"};a.details=t.userMessage;$.showMessageBox("error",i,a)})}async function wt(t,e,a){if(this.canSave()){const o=await $.showMessageBox("warning",t,{titleKey:e,actions:[i.Action.YES,i.Action.NO,i.Action.CANCEL],emphasizedAction:i.Action.YES});if(o===i.Action.YES){await this._serializeToLrep();await a()}else if(o===i.Action.NO){this.getCommandStack().removeAllCommands(true);await a()}}else{await a()}}function Mt(t){P.start("onCBASwitchAdaptation","Measurement of switching a context-based adaptation");const i=t.getParameter("callback")||function(){};if(t.getParameter("trigger")==="SaveAs"){this.getCommandStack().removeAllCommands(true)}const a=t.getParameter("adaptationId");this._sSwitchToAdaptationId=a;return wt.call(this,"MSG_SWITCH_VERSION_DIALOG","BTN_SWITCH_ADAPTATIONS",Tt.bind(this,this._sSwitchToAdaptationId)).then(function(){i();P.end("onCBASwitchAdaptation");if(P.getActive()){e.info(`onCBASwitchAdaptation: ${P.getMeasurement("onCBASwitchAdaptation").time} ms`)}}).catch(function(t){$.showMessageBox("error","MSG_SWITCH_ADAPTATION_FAILED",{error:t});e.error(`sap.ui.rta: ${t.stack||t.message||t}`)})}function Tt(t){const e=this._oVersionsModel.getProperty("/displayedVersion");return Pt.call(this,e,t)}function Et(t){const i=t.getParameter("callback")||function(){};const a=t.getParameter("version");const o=this._oVersionsModel.getProperty("/displayedVersion");if(a===o){return}this._sSwitchToVersion=a;wt.call(this,"MSG_SWITCH_VERSION_DIALOG","TIT_SWITCH_VERSION_DIALOG",Pt.bind(this,this._sSwitchToVersion)).then(i).catch(function(t){$.showMessageBox("error","MSG_SWITCH_VERSION_FAILED",{error:t.stack});e.error(`sap.ui.rta: ${t.stack||t.message||t}`)})}function Pt(t,e){Q.enableRestart(this.getLayer(),this.getRootControlInstance());return v.loadVersionForApplication({control:this.getRootControlInstance(),layer:this.getLayer(),version:t,adaptationId:e}).then(function(){const e={versionSwitch:true,version:t,selector:this.getRootControlInstance()};K.triggerReload(e)}.bind(this))}function Dt(){this.getPluginManager().handleStopCutPaste();return v.publish({selector:this.getRootControlInstance(),styleClass:$.getRtaStyleClassName(),layer:this.getLayer(),version:this._oVersionsModel.getProperty("/displayedVersion")}).then(function(t){if(t!=="Error"&&t!=="Cancel"){a.show(t)}})}function It(){return v.isOldVersionDisplayed({control:this.getRootControlInstance(),layer:this.getLayer()})}function Ot(){return v.isDraftAvailable({control:this.getRootControlInstance(),layer:this.getLayer()})}function Lt(){return v.initialize({control:this.getRootControlInstance(),layer:this.getLayer()}).then(function(t){this._oVersionsModel=t}.bind(this))}function Nt(t){if(!t){m.clearInstances()}return m.initialize({control:this.getRootControlInstance(),layer:this.getLayer()}).then(function(t){this._oContextBasedAdaptationsModel=t}.bind(this))}async function Vt(t){if(this.getDependent("toolbar")){return}const e={id:"sapUIRta_toolbar",rtaInformation:{flexSettings:this.getFlexSettings(),rootControl:this.getRootControlInstance(),commandStack:this.getCommandStack()},textResources:this._getTextResources(),restore:this.restore.bind(this),exit:this.stop.bind(this,false,false,false)};e.publishVersion=Dt.bind(this);e.undo=this.undo.bind(this);e.redo=this.redo.bind(this);e.modeChange=Gt.bind(this);e.activate=Ct.bind(this);e.discardDraft=_t.bind(this);e.switchVersion=Et.bind(this);e.switchAdaptation=Mt.bind(this);e.deleteAdaptation=bt.bind(this);e.openChangeCategorySelectionPopover=this.getChangeVisualization?this.getChangeVisualization().openChangeCategorySelectionPopover.bind(this.getChangeVisualization()):function(){};e.save=St.bind(this);e.saveAndReload=ft.bind(this);let i;const a=!!T.getUshellContainer();if(a){const t=await M("sap/ushell/api/RTA");e.ushellApi=t;if($.isOriginalFioriToolbarAccessible()){i=new N(e)}else{i=new V(e)}}else{i=new x(e)}this.addDependent(i,"toolbar");await i.onFragmentLoaded();const o=await y.isKeyUserTranslationEnabled(this.getLayer());const n=await y.isSeenFeaturesAvailable();const s=t.saveAsAvailable;const r=s&&D.isOverviewExtended();const l=new URLSearchParams(window.location.search);const c=!l.has("fiori-tools-rta-mode")||l.get("fiori-tools-rta-mode")==="false";const d=f.getConfiguredFlexServices().some(function(t){return t.connector!=="LocalStorageConnector"});this.bPersistedDataTranslatable=false;const h=this._bSavedChangesNeedReload||await this._oSerializer.needsReload();this._oToolbarControlsModel=new E({changesNeedHardReload:h,modeSwitcher:this.getMode(),undo:{enabled:false},redo:{enabled:false},save:{enabled:false},translation:{visible:o,enabled:this.bPersistedDataTranslatable},newFeaturesOverview:{visible:n,enabled:n},appVariantMenu:{visible:s,enabled:s,overview:{visible:s&&r,enabled:s&&r},manageApps:{visible:s&&!r,enabled:s&&!r},saveAs:{visible:s,enabled:s}},restore:{visible:!this._oVersionsModel.getProperty("/versioningEnabled"),enabled:this.bInitialResetEnabled},contextBasedAdaptation:{visible:t.contextBasedAdaptationAvailable,enabled:t.contextBasedAdaptationAvailable},actionsMenuButton:{enabled:true},visualizationButton:{visible:c,enabled:c},feedbackButton:{visible:d}});this._oVersionsModel.setProperty("/publishVersionVisible",t.publishAvailable);this.getToolbar().setModel(this._oVersionsModel,"versions");this.getToolbar().setModel(this._oContextBasedAdaptationsModel,"contextBasedAdaptations");this.getToolbar().setModel(this._oToolbarControlsModel,"controls");if(o){b.getSourceLanguages({selector:this.getRootControlInstance(),layer:this.getLayer()}).then(function(t){this.bPersistedDataTranslatable=t.length>0;this._oToolbarControlsModel.setProperty("/translation/enabled",this.bPersistedDataTranslatable)}.bind(this))}if(s){const t=T.isVariantByStartupParameter(this.getRootControlInstance())?false:await D.isManifestSupported();this._oToolbarControlsModel.setProperty("/appVariantMenu/saveAs/enabled",t);this._oToolbarControlsModel.setProperty("/appVariantMenu/overview/enabled",t);this._oToolbarControlsModel.setProperty("/appVariantMenu/manageApps/enabled",t)}}function xt(){const t=this.getLayer();const e=T.getAppComponentForControl(this.getRootControlInstance());return _.reset({selector:e,layer:t}).then(function(){this.getCommandStack().removeAllCommands(true);A.removeInfoSessionStorage(e);const i={layer:t,ignoreMaxLayerParameter:true,triggerHardReload:true};return K.triggerReload(i)}.bind(this)).catch(function(t){if(t!=="cancel"){$.showMessageBox("error","MSG_RESTORE_FAILED",{error:t})}})}function Ut(t,e){function i(a){const o=a.getParameter("elementOverlay");if(o.getElement().getId()===t){this._oDesignTime.detachEvent("elementOverlayCreated",i,this);e(o)}}this._oDesignTime.attachEvent("elementOverlayCreated",i,this)}function kt(t,e){function i(t){const a=t.getSource();if(a.getGeometry()&&a.getGeometry().visible){a.detachEvent("geometryChanged",i);e(a)}}function a(t){if(!t.getGeometry()||!t.getGeometry().visible){t.attachEvent("geometryChanged",i)}else{e(t)}}Ut.call(this,t,function(t){if(t.isRendered()){a(t)}else{t.attachEventOnce("afterRendering",function(t){a(t.getSource())})}})}function Bt(t,e,i){const a=function(t){if(t.getSelectable()){t.setSelected(true)}else{t.attachEventOnce("selectableChange",()=>{t.setSelected(true)})}this.getPluginManager().getPlugin("rename").startEdit(t)}.bind(this);kt.call(this,e,async function(e){const o=this.getPluginManager().getPlugin("createContainer").getCreatedContainerId(t,e.getElement().getId());const n=h.getOverlay(o);if(n){if(i){await this.getPluginManager().getPlugin("rename").createRenameCommand(n,i);this.getCommandStack().compositeLastTwoCommands()}else{a(n)}}else{kt.call(this,o,a)}}.bind(this))}function Ft(t){const i=t.getParameter("command");const a=t.getParameter("newControlId");const o=t.getParameter("action");const n=t.getParameter("title");this._pElementModified=this._pElementModified.then(function(){this.getPluginManager().handleStopCutPaste();if(i instanceof I){if(a){Ut.call(this,a,function(t){const e=t.getDesignTimeMetadata();const i=e.getData().select;if(typeof i==="function"){i(t.getElement())}});if(o){Bt.call(this,o,a,n)}}return this.getCommandStack().pushAndExecute(i).catch(function(t){if(t?.message?.indexOf?.("The following Change cannot be applied because of a dependency")>-1){$.showMessageBox("error","MSG_DEPENDENCY_ERROR",{error:t})}e.error("sap.ui.rta:",t.message,t.stack)})}return undefined}.bind(this));return this._pElementModified}function Gt(t){this.setMode(t.getParameter("item").getKey())}Q.prototype.getService=function(t){if(this._sStatus!==q){return new Promise((t,e)=>{this.attachEventOnce("start",t);this.attachEventOnce("failed",e)}).then(()=>this.getServiceManager().startService(t,this)).catch(()=>{throw Error(g.createError("RuntimeAuthoring#getService",`Can't start the service '${t}' because RTA startup failed`,"sap.ui.rta"))})}return this.getServiceManager().startService(t,this)};return Q});
//# sourceMappingURL=RuntimeAuthoring.js.map