/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/base/ManagedObject","sap/ui/rta/appVariant/AppVariantDialog","sap/ui/rta/appVariant/AppVariantUtils","sap/ui/rta/appVariant/Feature","sap/ui/rta/appVariant/S4HanaCloudBackend"],function(e,t,n,a,r){"use strict";const i=e.extend("sap.ui.rta.appVariant.AppVariantManager",{metadata:{library:"sap.ui.rta",properties:{commandSerializer:{type:"object"},layer:{type:"string"}}}});i.prototype._openDialog=function(e,n){const a=new t("appVariantDialog");a.attachCreate(e);a.attachCancel(n);a.attachAfterClose(function(){this.destroy()});a.open();return a};i.prototype._prepareAppVariantData=function(e,t){return{referenceAppId:e["sap.app"].id,title:t.title,subTitle:t.subTitle,description:t.description,icon:t.icon,inbounds:e["sap.app"].crossNavigation&&e["sap.app"].crossNavigation.inbounds?e["sap.app"].crossNavigation.inbounds:null}};i.prototype.createAllInlineChanges=function(e,t){const a=n.getId(e.referenceAppId);const r=[];let i={};i.content=n.prepareTextsChange("title",e.title);r.push(n.createInlineChange(i,"appdescr_app_setTitle",t));i.content=n.prepareTextsChange("subtitle",e.subTitle);r.push(n.createInlineChange(i,"appdescr_app_setSubTitle",t));i.content=n.prepareTextsChange("description",e.description);r.push(n.createInlineChange(i,"appdescr_app_setDescription",t));i=n.getInlineChangeInputIcon(e.icon);r.push(n.createInlineChange(i,"appdescr_ui_setIcon",t));return n.getInboundInfo(e.inbounds).then(function(p){const o=p.currentRunningInbound;if(p.addNewInboundRequired){const i=n.prepareAddNewInboundChange(o,a,e).then(function(e){return n.createInlineChange(e,"appdescr_app_addNewInbound",t)});r.push(i)}else{i=n.prepareChangeInboundChange(o,a,e);r.push(n.createInlineChange(i,"appdescr_app_changeInbound",t))}i=n.prepareRemoveAllInboundsExceptOneChange(o);r.push(n.createInlineChange(i,"appdescr_app_removeAllInboundsExceptOne",t));return Promise.all(r)})};i.prototype.createAppVariant=function(e,t){const a={id:e,layer:this.getLayer()};return n.createAppVariant(t,a)};i.prototype.deleteAppVariant=function(e){return n.deleteAppVariant({appId:e},this.getLayer())};i.prototype.processSaveAsDialog=function(e,t){return new Promise(function(n,r){const i=function(t){const a=t.getParameters();const r=this._prepareAppVariantData(e,a);n(r)}.bind(this);const p=function(){if(!t){return a.onGetOverview(true,this.getLayer())}r()}.bind(this);return this._openDialog(i,p)}.bind(this))};i.prototype._clearRTACommandStack=function(){return this.getCommandSerializer().clearCommandStack()};i.prototype.clearRTACommandStack=function(e){const t=this.getCommandSerializer().getCommandStack();if(e&&t.getAllExecutedCommands().length){return this._clearRTACommandStack()}return Promise.resolve()};i.prototype.triggerCatalogPublishing=function(e,t,a){const r=a?n.triggerCatalogAssignment:n.triggerCatalogUnAssignment;return r(e,this.getLayer(),t).catch(function(t){const r=a?"MSG_CATALOG_ASSIGNMENT_FAILED":"MSG_DELETE_APP_VARIANT_FAILED";return n.catchErrorDialog(t,r,e)})};i.prototype.notifyKeyUserWhenPublishingIsReady=function(e,t,a){const i=new r;return i.notifyFlpCustomizingIsReady(e,a).catch(function(e){let r=a?"MSG_TILE_CREATION_FAILED":"MSG_DELETE_APP_VARIANT_FAILED";if(!a&&e.error==="locked"){r="MSG_CATALOGS_LOCKED"}return n.catchErrorDialog(e,r,t)})};i.prototype.showSuccessMessage=function(e){return n.showRelevantDialog(e,true)};return i});
//# sourceMappingURL=AppVariantManager.js.map