/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/core/mvc/Controller","sap/ui/fl/Layer","sap/ui/fl/Utils","sap/ui/rta/appVariant/manageApps/webapp/model/models","sap/ui/rta/appVariant/AppVariantUtils","sap/ui/rta/appVariant/Utils","sap/m/MessageBox","sap/ui/rta/Utils","sap/ui/rta/appVariant/Feature","sap/ui/rta/RuntimeAuthoring","sap/ui/core/BusyIndicator","sap/base/i18n/ResourceBundle","sap/m/MessageToast","sap/m/MenuItem"],function(t,e,n,r,i,a,o,s,u,p,A,g,_,l){"use strict";let c;let I;let h;let T;let d;return t.extend("sap.ui.rta.appVariant.manageApps.webapp.controller.ManageApps",{onInit(){c=this.getOwnerComponent().getIdRunningApp();I=this.getOwnerComponent().getIsOverviewForKeyUser();h=this.getOwnerComponent().getLayer();const t=n.getUshellContainer();A.show();return this._createResourceBundle().then(function(){if(t){return t.getServiceAsync("Navigation").then(function(t){T=t})}return undefined}).then(()=>a.getAppVariantOverview(c,I,this._oI18n)).then(function(t){A.hide();if(t.length){return this._arrangeOverviewDataAndBindToModel(t).then(function(t){return this._highlightNewCreatedAppVariant(t)}.bind(this))}i.closeOverviewDialog();return this._showMessageWhenNoAppVariantsExist()}.bind(this)).catch(function(t){i.closeOverviewDialog();const e=i.buildErrorInfo("MSG_MANAGE_APPS_FAILED",t);e.overviewDialog=true;A.hide();return i.showRelevantDialog(e,false)})},async _createResourceBundle(){d=`${sap.ui.require.toUrl("sap/ui/rta/appVariant/manageApps/")}webapp/i18n/i18n.properties`;this._oI18n=await g.create({url:d,async:true})},_showMessageWhenNoAppVariantsExist(){return s.showMessageBox(o.Icon.INFORMATION,"MSG_APP_VARIANT_OVERVIEW_SAP_DEVELOPER",{titleKey:"TITLE_APP_VARIANT_OVERVIEW_SAP_DEVELOPER"})},_highlightNewCreatedAppVariant(t){const e=this.byId("Table1");if(!e){return Promise.resolve()}e.focus();t.forEach((t,n)=>{if(t.currentStatus===this._oI18n.getText("MAA_NEW_APP_VARIANT")||t.currentStatus===this._oI18n.getText("MAA_OPERATION_IN_PROGRESS")){if(e.getItems().length>=n){e.getItems()[n].focus()}}});return Promise.resolve()},_arrangeOverviewDataAndBindToModel(t){const e=t.filter(function(t){return t.appId===c});const n=e[0];if(n&&n.appVarStatus!=="R"){n.currentStatus=this._oI18n.getText("MAA_CURRENTLY_ADAPTING")}t=t.filter(function(t){return t.appId!==c});t.unshift(n);const i=t.filter(function(t){return t.isOriginal});const a=i[0];t=t.filter(function(t){return!t.isOriginal});t.unshift(a);const o={appVariants:t};const s=r.createModel(o);this.getView().setModel(s);return Promise.resolve(t)},formatRowHighlight(t){if(t===this._oI18n.getText("MAA_CURRENTLY_ADAPTING")){return"Success"}else if(t===this._oI18n.getText("MAA_NEW_APP_VARIANT")){return"Information"}else if(t===this._oI18n.getText("MAA_OPERATION_IN_PROGRESS")){return"Warning"}return"None"},formatDelButtonTooltip(t,e){if(!t&&!e){return this._oI18n.getText("TOOLTIP_DELETE_APP_VAR")}return undefined},formatAdaptUIButtonTooltip(t,e){if(!t){switch(e){case"R":return this._oI18n.getText("TOOLTIP_ADAPTUI_STATUS_RUNNING");case"U":return this._oI18n.getText("TOOLTIP_ADAPTUI_STATUS_UNPBLSHD_ERROR");case"E":return this._oI18n.getText("TOOLTIP_ADAPTUI_STATUS_UNPBLSHD_ERROR");case"P":return this._oI18n.getText("TOOLTIP_ADAPTUI_STATUS_PUBLISHED");case undefined:return this._oI18n.getText("TOOLTIP_ADAPTUI_ON_PREMISE");default:}}return undefined},formatAdaptUIButtonVisibility(t,e){return t&&e},getModelProperty(t,e){return this.getView().getModel().getProperty(t,e)},onMenuAction(t){let e=t.getParameter("item");let n="";while(e instanceof l){n=`${e.getText()} > ${n}`;e=e.getParent()}n=n.substr(0,n.lastIndexOf(" > "));if(n===this._oI18n.getText("MAA_DIALOG_ADAPT_UI")){return this.handleUiAdaptation(t)}else if(n===this._oI18n.getText("MAA_DIALOG_COPY_ID")){return this.copyId(t)}else if(n===this._oI18n.getText("MAA_DIALOG_DELETE_APPVAR")){return this.deleteAppVariant(t)}return undefined},handleUiAdaptation(t){const n=this.getModelProperty("semanticObject",t.getSource().getBindingContext());const r=this.getModelProperty("action",t.getSource().getBindingContext());const a=this.getModelProperty("params",t.getSource().getBindingContext());let o;if(n&&r&&a){o={target:{semanticObject:n,action:r},params:a,writeHistory:false};p.enableRestart(e.CUSTOMER);if(T){T.navigate(o)}i.closeOverviewDialog();return true}return false},copyId(t){const e=this.getModelProperty("appId",t.getSource().getBindingContext());i.copyId(e);_.show(this._oI18n.getText("MAA_COPY_ID_SUCCESS"))},deleteAppVariant(t){const e={};const n=this._oI18n.getText("MSG_APP_VARIANT_DELETE_CONFIRMATION");e.text=n;e.deleteAppVariant=true;const r=this.getModelProperty("appId",t.getSource().getBindingContext());const a=this.getModelProperty("currentStatus",t.getSource().getBindingContext());const o=a===this._oI18n.getText("MAA_CURRENTLY_ADAPTING");return i.showRelevantDialog(e).then(function(){return u.onDeleteFromOverviewDialog(r,o,h)}).catch(function(){return true})}})});
//# sourceMappingURL=ManageApps.controller.js.map