/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/core/util/reflection/JsControlTreeModifier","sap/ui/fl/variants/VariantManager","sap/ui/fl/write/api/ContextSharingAPI","sap/ui/fl/write/api/PersistenceWriteAPI","sap/ui/fl/Utils","sap/ui/rta/command/BaseCommand","sap/ui/rta/library","sap/ui/rta/Utils"],function(e,t,a,n,r,i,o,s){"use strict";var h=i.extend("sap.ui.rta.command.ControlVariantSaveAs",{metadata:{library:"sap.ui.rta",properties:{sourceVariantReference:{type:"string"},sourceDefaultVariant:{type:"string"},model:{type:"object"},newVariantParameters:{type:"object"}},associations:{},events:{}}});h.prototype.prepare=function(t){this.oVariantManagementControl=this.getElement();this.oAppComponent=r.getAppComponentForControl(this.oVariantManagementControl);this.sVariantManagementReference=e.getSelector(this.oVariantManagementControl,this.oAppComponent).id;this.oModel=this.getModel();this.setSourceDefaultVariant(this.oModel.getData()[this.sVariantManagementReference].defaultVariant);this.sLayer=t.layer;var n=t;n.variantManagementControl=this.oVariantManagementControl;function i(e,t){var a=e.getParameters();this.setNewVariantParameters(a);this.oVariantManagementControl.detachSave(i,this);this.oVariantManagementControl.detachCancel(o,this);t.resolve(true)}function o(e,t){this.oVariantManagementControl.detachSave(i,this);this.oVariantManagementControl.detachCancel(o,this);t.resolve(false)}return new Promise(function(e){this.oVariantManagementControl.attachSave({resolve:e},i,this);this.oVariantManagementControl.attachCancel({resolve:e},o,this);this.oVariantManagementControl.openSaveAsDialogForKeyUser(s.getRtaStyleClassName(),a.createComponent(n))}.bind(this)).then(function(e){return e})};h.prototype.getPreparedChange=function(){if(!this._aPreparedChanges){return undefined}return this._aPreparedChanges};h.prototype.execute=function(){var e=this.getSourceVariantReference();this._aControlChangesWithoutVariant=this.oModel.getVariant(e,this.sVariantManagementReference).controlChanges.filter(e=>!e.getSavedToVariant());var a=this.getNewVariantParameters();a.layer=this.sLayer;a.newVariantReference=this.sNewVariantReference;a.generator=o.GENERATOR_NAME;return t.handleSaveEvent(this.oVariantManagementControl,a,this.oModel).then(function(e){this._aPreparedChanges=e;[this._oVariantChange]=e;this.sNewVariantReference=this._oVariantChange.getId();this._aPreparedChanges.forEach(function(e){if(e.getFileType()==="change"){e.setSavedToVariant(true)}});this.getModel().invalidateMap()}.bind(this))};h.prototype.undo=async function(){if(this._oVariantChange){var e=[];this._aPreparedChanges.forEach(function(t){if(t.getFileType()==="ctrl_variant_management_change"){e.push(t)}});await n.remove({flexObjects:e,selector:this.oAppComponent});var a={variant:this._oVariantChange,sourceVariantReference:this.getSourceVariantReference(),variantManagementReference:this.sVariantManagementReference,appComponent:this.oAppComponent};await t.removeVariant(a,true);await t.addAndApplyChangesOnVariant(this._aControlChangesWithoutVariant,this.oAppComponent);this._aPreparedChanges=null;this._oVariantChange=null}};return h});
//# sourceMappingURL=ControlVariantSaveAs.js.map