/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/core/mvc/XMLView","sap/ui/core/ComponentContainer","sap/ui/core/UIComponent","sap/ui/core/util/reflection/JsControlTreeModifier","sap/ui/dt/DesignTime","sap/ui/dt/DesignTimeStatus","sap/ui/dt/OverlayRegistry","sap/ui/fl/apply/_internal/changes/Utils","sap/ui/fl/changeHandler/condenser/Classification","sap/ui/fl/write/api/PersistenceWriteAPI","sap/ui/fl/Layer","sap/ui/model/Model","sap/ui/rta/command/CommandFactory","sap/ui/rta/util/changeVisualization/ChangeCategories","sap/ui/rta/util/changeVisualization/ChangeVisualization","sap/ui/qunit/utils/nextUIUpdate","sap/ui/thirdparty/sinon-4","test-resources/sap/ui/fl/api/FlexTestAPI","test-resources/sap/ui/fl/qunit/FlQUnitUtils","sap/ui/fl/library"],function(e,t,n,i,a,o,s,r,c,l,h,d,m,u,g,f,p,C,w){"use strict";function y(v,b){if(y._only&&v.indexOf(y._only)<0){return}if(typeof b.xmlView==="string"){b.xmlView={viewContent:b.xmlView}}const A=p.createSandbox();b.before||=function(){};b.after||=function(){};QUnit.module(v,function(){QUnit.test("When using the 'elementActionTest' function to test if your control is ready for UI adaptation at runtime",function(e){e.ok(b.afterAction,"then you implement a function to check if your action has been successful: See the afterAction parameter.");e.ok(b.afterUndo,"then you implement a function to check if the undo has been successful: See the afterUndo parameter.");e.ok(b.afterRedo,"then you implement a function to check if the redo has been successful: See the afterRedo parameter.");e.ok(b.xmlView,"then you provide an XML view to test on: See the.xmlView parameter.");const t=(new DOMParser).parseFromString(b.xmlView.viewContent,"application/xml").documentElement;e.ok(t.tagName.match("View$"),"then you use the sap.ui.core.mvc View tag as the first tag in your view");e.ok(b.action,"then you provide an action: See the action parameter.");e.ok(b.action.name,"then you provide an action name: See the action.name parameter.");e.ok(b.action.controlId||b.action.control,"then you provide the control or control's id to operate the action on: See the action.controlId.")})});const U="sap.ui.rta.control.enabling.comp";const V=false;const x=true;const I=n.extend(U,{metadata:{interfaces:["sap.ui.core.IAsyncContentCreation"],manifest:{"sap.app":{id:U,type:"application"}}},createContent(){const t={...b.xmlView};t.id=this.createId("view");if(t.async===undefined){t.async=this.getComponentData().async}t.definition=t.viewContent;this.oViewPromise=e.create(t);return this.oViewPromise}});function k(e){this.oUiComponent=new I({id:"comp",componentData:{async:e}});return this.oUiComponent.oViewPromise.then(async function(){this.oUiComponentContainer=new t({component:this.oUiComponent,height:"100%"});this.oUiComponentContainer.placeAt(b.placeAt||"qunit-fixture");this.oView=this.oUiComponent.getRootControl();if(b.model instanceof d){this.oView.setModel(b.model)}await f();return b.model&&b.model.getMetaModel()&&b.model.getMetaModel().loaded()}.bind(this))}function D(e,t){const n=[].concat(b.previousActions||[],b.action);const i=[];async function a(n,a){const o=await R.call(this,e,n);i.push(o);await o.execute();if(a&&t?.relevantForDuplicateChangeCheck&&await $.call(this,o,n)){await X(this.oDesignTime);t.duplicateChangeCheckActive=true;const a=await R.call(this,e,n);i.push(a);try{await a.execute()}catch(t){e.strictEqual(a.getPreparedChange()?.hasApplyProcessFailed(),true,`then on second application of the same action returns the following error message: ${t.message||t}`)}}await X(this.oDesignTime)}return n.reduce(function(e,t,i){return e.then(a.bind(this,t,i===n.length-1))}.bind(this),Promise.resolve()).then(function(){return i})}function P(e){if(typeof e.control==="function"){return e.control(this.oView)}return this.oView.byId(e.controlId)}function E(e){return e.designtimeActionControl?e.designtimeActionControl(this.oView):undefined}function T(){this.oDesignTime=new a({rootElements:[this.oView]});return new Promise(function(e){this.oDesignTime.attachEventOnce("synced",e)}.bind(this))}function M(e){if(e){return typeof e==="function"?e(this.oView):e}return{}}function S(e,t,n,i,a,o){if(Array.isArray(t.name)){const i=a.getAction(t.name[0],n,t.name[1]);e.ok(i,`the ${t[0]} via ${t.name[1]} action is available in the designtime`)}else if(t.name==="createContainer"||t.name==="addIFrame"){e.ok(o.getAction(t.name,n),`the ${t.name} action is available in the calculated designtime metadata during execution`)}else if(t.name==="move"){e.ok(a.getAction(t.name,i),`the ${t.name} action is available in the calculated designtime metadata during execution`)}else{e.ok(a.getAction(t.name,n),`the ${t.name} action is available in the calculated designtime metadata during execution`)}}async function R(e,t){try{let n=t.name;let i;let a;let o=await P.call(this,t);const r=M.call(this,t.parameter);const c=await E.call(this,t);await T.call(this);let l=s.getOverlay(c||o);if(!l){throw new Error(`The provided control ${o.getId()}does not have any overlay existing during test execution. `+"With this testsetup it is no possible to check for designtime action definition. In some cases it is not "+"possible to identify the control with the designtime metadata automatically just by the given 'action.control'. "+"In this case please provide the 'action.designtimeActionControl' property with a valid control containing "+"the designtime metadata definition for this check.")}let d=l.getDesignTimeMetadata();const u=d.getResponsibleElement(o);if(b.label){e.strictEqual(d.getLabel(o),b.label,"then the control label is correct")}if(t.name==="move"){a=r.movedElements[0].element||r.movedElements[0].id;const e=s.getOverlay(a);const t=e.getRelevantContainer();o=t;d=e.getParentAggregationOverlay().getDesignTimeMetadata()}else if(Array.isArray(t.name)){const e=d.getActionDataFromAggregations(t.name[0],o,undefined,t.name[1]);const i=l.getAggregationOverlay(e[0].aggregation);d=i.getDesignTimeMetadata();n="addDelegateProperty"}else if(t.name==="createContainer"||t.name==="addIFrame"){const e=d.getActionDataFromAggregations(t.name,c||o);const n=l.getAggregationOverlay(e[0].aggregation);i=n.getDesignTimeMetadata()}else if(u){if(t.name==="reveal"){o=t.revealedElement(this.oView);l=s.getOverlay(t.revealedElement(this.oView));d=l.getDesignTimeMetadata();if(t.label){const n=d.getAction("reveal");e.strictEqual(n.getLabel(o),t.label,"then the control label is correct")}}else{o=u;l=s.getOverlay(o);d=l.getDesignTimeMetadata();o.getMetadata().loadDesignTime(o)}}S(e,t,o,a,d,i);const g=new m({flexSettings:{layer:b.layer||h.CUSTOMER}});const f=await g.getCommandFor(o,n,r,d);e.ok(f,"then the registration for action to change type, the registration for change and "+`control type to change handler is available and ${b.action.name} is a valid action`);return f}catch(e){throw new Error(e)}}function O(e){return e.reduce(function(e,t){return e.then(t.execute.bind(t))},Promise.resolve())}function F(e){const t=e.slice().reverse();return t.reduce(function(e,t){return e.then(t.undo.bind(t))},Promise.resolve())}async function W(e,t){if(t?.duplicateChangeCheckActive){const t=e[e.length-1];await t.undo()}}function z(e){e.forEach(e=>{e.destroy()})}async function Q(e,t,n){const i={remainingCommands:[],deletedCommands:[]};if(t.length===1){i.remainingCommands.push(t[0]);return Promise.resolve(i)}const a=t.map(e=>e.getPreparedChange());const o=await l._condense({selector:e,changes:a});if(b.changesAfterCondensing!==undefined){n.equal(o.length,b.changesAfterCondensing,"after condensing the amount of changes is correct")}const s=o.map(e=>e.getId());t.forEach(e=>{if(s.indexOf(e.getPreparedChange().getId())>-1){i.remainingCommands.push(e)}else{i.deletedCommands.push(e)}});return i}async function q(e,t,n){if(!b.changeVisualization){return}let i;if(typeof b.changeVisualization==="function"){i=b.changeVisualization(e)}else{i=b.changeVisualization}const a=new g({rootControlId:e.getId(),isActive:true});A.stub(a,"_updateChangeIndicators");const o=t.map(e=>e.getPreparedChange());A.stub(a,"_collectChanges").resolves(o);await a._updateChangeRegistry();await a._selectChangeCategory(u.ALL);const s=a._oChangeIndicatorRegistry;const r=s.getSelectorsWithRegisteredChanges();const c=i.displayElementId;const l=c?e.createId(c):e.getId();n.ok(r[l]&&r[l].length,"there is a change indicator at the correct element");const h=s.getAllRegisteredChanges();const d=o[o.length-1];const m=h.find(e=>e.change.getId()===d.getId());const f=i.info;function p(t){return t.map(t=>e.createId(t))}if(f){if(f.affectedControls){const e=p(f.affectedControls);n.deepEqual(e,m.visualizationInfo.affectedElementIds,"then the affected control ids are correct")}if(f.dependentControls){const e=p(f.dependentControls);n.deepEqual(e,m.visualizationInfo.dependentElementIds,"then the dependent control ids are correct")}if(f.displayControls){const e=p(f.displayControls);n.deepEqual(e,m.visualizationInfo.displayElementIds,"then the display control ids are correct")}if(f.descriptionPayload){n.deepEqual(f.descriptionPayload,m.visualizationInfo.descriptionPayload,"then the descriptionPayload is correct")}}}function L(e){const t=[];e.forEach(function(e){const n=e.getPreparedChange();if(e.getAppComponent){t.push(l.remove({change:n,selector:e.getAppComponent()}))}});return Promise.all(t)}async function $(e,t){let n;const a=await P.call(this,t);const o=e.getPreparedChange();o.setRevertData(o.getRevertData()||{});try{const t=await r.getChangeHandler({flexObject:o,control:a,controlType:a.getMetadata().getName(),modifier:i});if(t&&typeof t.getCondenserInfo==="function"){n=await t.getCondenserInfo(o,{modifier:i,appComponent:e.getAppComponent()})}return n?.classification===c.Create}catch(e){return false}}async function _(e,t){await k.call(this,V);await j.call(this,e,t)}function j(e,t){const n=[].concat(b.previousActions||[],b.action);const i=[];let a;async function o(n,o){const s=await R.call(this,e,n);i.push(s);a=s.getAppComponent();let r;if(o&&t?.relevantForDuplicateChangeCheck&&await $.call(this,s,n)){t.duplicateChangeCheckActive=true;r=await R.call(this,e,n);i.push(r)}this.oUiComponentContainer.destroy();l.add({change:s.getPreparedChange(),selector:a});if(r){l.add({change:r.getPreparedChange(),selector:a})}return await k.call(this,x)}return n.reduce(function(e,t,i){return e.then(o.bind(this,t,i===n.length-1))}.bind(this),Promise.resolve()).then(function(){this.aCommands=i;const e=i.map(e=>e.getPreparedChange());return l.remove({flexObjects:e,selector:a})}.bind(this))}if(!b.jsOnly){QUnit.module(`${v} on async views`,{before(e){this.hookContext={};return b.before.call(this.hookContext,e)},after(e){return b.after.call(this.hookContext,e)},async beforeEach(){await w.initializeFlexStateWithData(A,U,{changes:[]})},afterEach(){this.oUiComponentContainer.destroy();this.oDesignTime.destroy();z(this.aCommands);C.reset();A.restore()}},function(){QUnit.test("When applying the change directly on the XMLView",async function(e){await _.call(this,e);await q(this.oView,this.aCommands,e);await b.afterAction(this.oUiComponent,this.oView,e)});QUnit.test("When executing on XML and reverting the change in JS (e.g. variant switch)",async function(e){await _.call(this,e);await F(this.aCommands);await L(this.aCommands);await f();await b.afterUndo(this.oUiComponent,this.oView,e)});QUnit.test("When executing on XML, reverting the change in JS (e.g. variant switch) and applying again",async function(e){await _.call(this,e);const t=await Q(this.oView,this.aCommands,e);this.aRemainingCommands=t.remainingCommands;await F(this.aCommands);await L(this.aCommands);await O(this.aRemainingCommands);await f();await b.afterRedo(this.oUiComponent,this.oView,e)});QUnit.test("When executing on XML and applying the create change twice (check for duplicate change errors) and reverting just one change in JS",async function(e){const t={relevantForDuplicateChangeCheck:true};await _.call(this,e,t);await W(this.aCommands,t);await L(this.aCommands);f();await b.afterAction(this.oUiComponent,this.oView,e)})})}function X(e){if(e.getStatus()!==o.SYNCED){return new Promise(function(t){e.attachEventOnce("synced",t)})}return Promise.resolve()}QUnit.module(v,{before(e){this.hookContext={};return b.before.call(this.hookContext,e)},after(e){return b.after.call(this.hookContext,e)},async beforeEach(e){await w.initializeFlexStateWithData(A,U,{changes:[]});return k.call(this,V).then(D.bind(this,e)).then(function(e){this.aCommands=e}.bind(this))},afterEach(){this.oDesignTime.destroy();this.oUiComponentContainer.destroy();z(this.aCommands);C.reset();A.restore()}},function(){QUnit.test("When executing the underlying command on the control at runtime",async function(e){await X(this.oDesignTime);await q(this.oView,this.aCommands,e);await f();await b.afterAction(this.oUiComponent,this.oView,e)});QUnit.test("When executing and undoing the command",async function(e){await X(this.oDesignTime);await F(this.aCommands);await L(this.aCommands);await f();await b.afterUndo(this.oUiComponent,this.oView,e)});QUnit.test("When executing, undoing and redoing the command",async function(e){await X(this.oDesignTime);const t=await Q(this.oView,this.aCommands,e);this.aRemainingCommands=t.remainingCommands;await F(this.aCommands);await L(this.aCommands);await O(this.aRemainingCommands);await f();await b.afterRedo(this.oUiComponent,this.oView,e)});QUnit.test("When executing and applying the create change twice (check for duplicate change errors) and undoing just one command",async function(e){this.oUiComponentContainer.destroy();await k.call(this,V);const t={relevantForDuplicateChangeCheck:true};const n=await D.call(this,e,t);this.aCommands=n;await X(this.oDesignTime);await W(this.aCommands,t);await L(this.aCommands);f();await b.afterAction(this.oUiComponent,this.oView,e)})})}y.skip=function(){};y.only=function(e){y._only=e};return y});
//# sourceMappingURL=elementActionTest.js.map