//@ui5-bundle sap/ui/rta/library-preload.js
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/rta/Client", ["sap/ui/base/ManagedObject","sap/ui/core/postmessage/Bus","sap/ui/core/Lib","sap/base/util/uid","sap/base/util/merge","sap/ui/rta/util/ServiceEventBus","sap/ui/thirdparty/URI"],function(e,t,s,i,r,n,a){"use strict";var o="sap.ui.rta.service.receiver";var u="pending";var h="accepted";var c="declined";var d=e.extend("sap.ui.rta.Client",{metadata:{library:"sap.ui.rta",properties:{window:"object",origin:"string"}},_bInit:false,constructor:function(...i){e.apply(this,i);if(!this.getWindow()){throw new TypeError("sap.ui.rta.Client: window parameter is required")}if(!this.getOrigin()){throw new TypeError("sap.ui.rta.Client: origin parameter is required")}this._oPostMessageBus=t.getInstance();this._sStatus=u;this._mPendingRequests={};this._aRequestQueue=[];this._oServiceEventBus=null;this._mEventHandlerIds={};this._oPostMessageBus.subscribeOnce(o,t.event.READY,function(e){if(!this._isValidMessage(e)){return}this._oPostMessageBus.subscribeOnce(o,t.event.ACCEPTED,function(e){if(!this._isValidMessage(e)){return}this._sStatus=h;var t=this._aRequestQueue.slice();this._aRequestQueue=[];t.forEach(this._sendRequest,this);this._oPostMessageBus.subscribe(o,"getService",this._receiverMethods,this);this._oPostMessageBus.subscribe(o,"callMethod",this._receiverMethods,this);this._oPostMessageBus.subscribe(o,"subscribe",this._receiverMethods,this);this._oPostMessageBus.subscribe(o,"unsubscribe",this._receiverMethods,this);this._oPostMessageBus.subscribe(o,"event",this._receiverEvents,this)},this);this._oPostMessageBus.subscribeOnce(o,t.event.DECLINED,function(e){if(!this._isValidMessage(e)){return}this._sStatus=c;var t=this._aRequestQueue.slice();this._aRequestQueue=[];t.forEach(function(e){e.reject(new Error("sap.ui.rta.Client.getService(): connection to RuntimeAuthoring instance has been refused"))})},this);this._oPostMessageBus.publish({target:this.getWindow(),origin:this.getOrigin(),channelId:o,eventId:t.event.CONNECT,data:s.getResourceBundleFor("sap.ui.rta").getText("SERVICE_NAME")})},this);this._bInit=true}});d.prototype.destroy=function(...t){this._oPostMessageBus.unsubscribe(o,"getService",this._receiverMethods,this);this._oPostMessageBus.unsubscribe(o,"callMethod",this._receiverMethods,this);this._oPostMessageBus.unsubscribe(o,"subscribe",this._receiverMethods,this);this._oPostMessageBus.unsubscribe(o,"unsubscribe",this._receiverMethods,this);this._oPostMessageBus.unsubscribe(o,"event",this._receiverEvents,this);e.prototype.destroy.apply(this,t)};d.prototype.getService=function(e){if(typeof e!=="string"){throw new TypeError("sap.ui.rta.Client.getService(): invalid service name specified")}return this._sendRequest(this._createRequest({target:this.getWindow(),origin:this.getOrigin(),channelId:o,eventId:"getService",data:{arguments:[e]}}))};d.prototype._createRequest=function(e){var t=i();var s={id:t,request:{target:e.target,origin:e.origin,channelId:o,eventId:e.eventId,data:{id:t,type:"request",body:e.data}}};s.promise=new Promise(function(e,t){s.resolve=e;s.reject=t});return s};d.prototype._sendRequest=function(e){switch(this._sStatus){case h:this._mPendingRequests[e.id]=e;this._oPostMessageBus.publish(e.request);break;case u:this._aRequestQueue.push(e);break;case c:e.reject(new Error("sap.ui.rta.Client.getService(): connection to RuntimeAuthoring instance has been refused"));break;default:}return e.promise};d.prototype._isValidMessage=function(e){return this.getWindow()===e.source&&this.getOrigin()===e.origin};d.prototype._receiverMethods=function(e){if(!this._isValidMessage(e)){return}var t=e.data;if(t.type!=="response"){return}var s=this._mPendingRequests[t.id];switch(e.eventId){case"getService":var i=s.request.data.body.arguments[0];var a=t.body.methods||[];var u=t.body.events;var h=r(a.reduce(function(t,s){t[s]=function(...t){return this._sendRequest(this._createRequest({target:e.source,origin:e.origin,channelId:o,eventId:"callMethod",data:{service:i,method:s,arguments:t}}))}.bind(this);return t}.bind(this),{}),t.body.properties);if(Array.isArray(u)&&u.length>0){this._oServiceEventBus||=new n;r(h,{attachEvent:function(t,s,r){if(typeof t!=="string"||!t){throw new TypeError("sap.ui.rta.Client: sEventName must be a non-empty string when calling attachEvent() for a service")}if(typeof s!=="function"){throw new TypeError("sap.ui.rta.Client: fnFunction must be a function when calling attachEvent() for a service")}var n=this._oServiceEventBus.getChannel(i);var a=!n||!n.hasListeners(t);this._oServiceEventBus.subscribe(i,t,s,r);if(a){this._sendRequest(this._createRequest({target:e.source,origin:e.origin,channelId:o,eventId:"subscribe",data:{service:i,event:t}})).then(function(e){this._mEventHandlerIds[`${i},${t}`]=e.id;this._checkIfEventAlive(i,t)}.bind(this))}}.bind(this),detachEvent:function(e,t,s){if(typeof e!=="string"||!e){throw new TypeError("sap.ui.rta.Client: sEventName must be a non-empty string when calling detachEvent() for a service")}if(typeof t!=="function"){throw new TypeError("sap.ui.rta.Client: fnFunction must be a function when calling detachEvent() for a service")}this._oServiceEventBus.unsubscribe(i,e,t,s);this._checkIfEventAlive(i,e)}.bind(this),attachEventOnce(e,t,s){function i(...r){h.detachEvent(e,i);t.apply(s,r)}h.attachEvent(e,i)}})}s.resolve(h);delete this._mPendingRequests[t.id];break;case"callMethod":if(t.status==="success"){s.resolve(t.body)}else{s.reject(t.body)}delete this._mPendingRequests[t.id];break;case"subscribe":case"unsubscribe":s.resolve(t.body);delete this._mPendingRequests[t.id];break;default:}};d.prototype._checkIfEventAlive=function(e,t){var s=this._oServiceEventBus.getChannel(e);var i=this._mEventHandlerIds[`${e},${t}`];if((!s||!s.hasListeners(t))&&i){this._sendRequest(this._createRequest({target:this.getWindow(),origin:this.getOrigin(),channelId:o,eventId:"unsubscribe",data:{service:e,event:t,id:i}}))}};d.prototype._receiverEvents=function(e){if(!this._isValidMessage(e)){return}var t=e.data.body;this._oServiceEventBus.publish(t.service,t.event,t.data)};d.prototype.setWindow=function(e){if(this._bInit){throw new TypeError("sap.ui.rta.Client: Window parameter cannot be changed at runtime; recreate instance of the Client.")}if(!e){throw new TypeError("sap.ui.rta.Client: Window parameter is required")}if(e===window){throw new TypeError("sap.ui.rta.Client: Window object has to be different from the one where Client is running")}this.setProperty("window",e);return this};d.prototype.setOrigin=function(e){if(this._bInit){throw new TypeError("sap.ui.rta.Client: Cannot change origin parameter at runtime; recreate instance of the Client.")}if(!e){throw new TypeError("sap.ui.rta.Client: Origin parameter is required")}if(typeof e!=="string"){throw new TypeError("sap.ui.rta.Client: Origin parameter has to be a string")}if(new a(e).origin()!==e){throw new TypeError("sap.ui.rta.Client: Origin string is invalid")}this.setProperty("origin",e);return this};return d});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/rta/RuntimeAuthoring", ["sap/base/strings/capitalize","sap/base/Log","sap/m/MessageBox","sap/m/MessageToast","sap/ui/base/ManagedObject","sap/ui/core/BusyIndicator","sap/ui/core/Lib","sap/ui/dt/DesignTime","sap/ui/dt/DOMUtil","sap/ui/dt/ElementUtil","sap/ui/dt/Overlay","sap/ui/dt/OverlayRegistry","sap/ui/dt/Util","sap/ui/events/KeyCodes","sap/ui/fl/apply/_internal/flexState/ManifestUtils","sap/ui/fl/apply/api/FlexRuntimeInfoAPI","sap/ui/fl/initial/api/Version","sap/ui/fl/write/api/ContextBasedAdaptationsAPI","sap/ui/fl/write/api/ControlPersonalizationWriteAPI","sap/ui/fl/write/api/FeaturesAPI","sap/ui/fl/write/api/PersistenceWriteAPI","sap/ui/fl/write/api/ReloadInfoAPI","sap/ui/fl/write/api/TranslationAPI","sap/ui/fl/write/api/VersionsAPI","sap/ui/fl/Layer","sap/ui/fl/LayerUtils","sap/ui/fl/requireAsync","sap/ui/fl/Utils","sap/ui/model/json/JSONModel","sap/ui/performance/Measurement","sap/ui/rta/appVariant/Feature","sap/ui/rta/command/BaseCommand","sap/ui/rta/command/LREPSerializer","sap/ui/rta/command/Stack","sap/ui/rta/toolbar/Fiori","sap/ui/rta/toolbar/FioriLike","sap/ui/rta/toolbar/Standalone","sap/ui/rta/util/changeVisualization/ChangeVisualization","sap/ui/rta/util/guidedTour/content/GeneralTour","sap/ui/rta/util/guidedTour/GuidedTour","sap/ui/rta/util/whatsNew/WhatsNew","sap/ui/rta/util/PluginManager","sap/ui/rta/util/PopupManager","sap/ui/rta/util/ReloadManager","sap/ui/rta/util/ServiceManager","sap/ui/rta/util/validateFlexEnabled","sap/ui/rta/Utils","sap/ui/Device"],function(t,e,i,a,o,n,s,r,l,c,d,h,g,u,p,f,S,m,C,y,_,A,b,v,R,w,M,T,E,P,D,I,O,L,N,V,x,U,k,B,F,G,z,K,W,H,$,j){"use strict";const Y="STARTING";const q="STARTED";const Z="STOPPED";const J="FAILED";const Q=o.extend("sap.ui.rta.RuntimeAuthoring",{metadata:{library:"sap.ui.rta",associations:{rootControl:{type:"sap.ui.base.ManagedObject"}},properties:{showToolbars:{type:"boolean",defaultValue:true},triggeredFromDialog:{type:"boolean",defaultValue:false},showWindowUnloadDialog:{type:"boolean",defaultValue:true},commandStack:{type:"any"},flexSettings:{type:"object",defaultValue:{layer:R.CUSTOMER,developerMode:true}},mode:{type:"string",defaultValue:"adaptation"},metadataScope:{type:"string",defaultValue:"default"}},events:{start:{parameters:{editablePluginsCount:{type:"int"}}},stop:{},failed:{parameters:{error:{type:"any"}}},selectionChange:{parameters:{selection:{type:"sap.ui.dt.Overlay[]"}}},modeChanged:{},undoRedoStackModified:{}}},_sAppTitle:null,_dependents:null,_sStatus:Z,_bNavigationModeWarningShown:false,constructor:function(...t){o.apply(this,t);this._dependents={};this._mUShellServices={};this._pElementModified=Promise.resolve();this.addDependent(new G,"pluginManager");this.addDependent(new z,"popupManager");this.addDependent(new W,"serviceManager");if(this.getShowToolbars()){this.getPopupManager().attachOpen(at,this);this.getPopupManager().attachClose(ot,this);this.addDependent(new U,"changeVisualization")}this.pServices=Promise.resolve();if(window.parent!==window){this.pServices=this.getService("receiver")}this.pServices=this.pServices.then(this.getService.bind(this,"supportTools"));this._loadUShellServicesPromise=T.getUShellServices(["URLParsing","AppLifeCycle","Navigation"]).then(function(t){this._mUShellServices=t;K.setUShellServices(t);return y.isSeenFeaturesAvailable()}.bind(this)).then(function(t){if(t&&!K.getDontShowWhatsNewAfterReload()){this.addDependent(new F({layer:this.getLayer()}),"whatsNew")}this.addDependent(new B,"guidedTour");return Promise.resolve()}.bind(this))}});Q.prototype.addDependent=function(e,i,a){a=typeof a==="undefined"?true:!!a;if(!(i in this._dependents)){if(i&&a){this[`get${t(i,0)}`]=this.getDependent.bind(this,i)}this._dependents[i||e.getId()]=e}else{throw g.createError("RuntimeAuthoring#addDependent",`Can't add dependency with same key '${i}'`,"sap.ui.rta")}};Q.prototype.getDependent=function(t){return this._dependents[t]};Q.prototype.getDependents=function(){return this._dependents};Q.prototype.removeDependent=function(t){delete this._dependents[t]};Q.prototype.setPlugins=function(t){if(this._sStatus!==Z){throw Error("Cannot replace plugins: runtime authoring already started")}this.getPluginManager().setPlugins(t)};Q.prototype.getPlugins=function(){return this.getPluginManager&&this.getPluginManager()&&this.getPluginManager().getPlugins()};Q.prototype.getDefaultPlugins=function(){return this.getPluginManager().getDefaultPlugins(this.getFlexSettings())};Q.prototype.setFlexSettings=function(t){const e=new URLSearchParams(window.location.search);const i=e.get("sap-ui-layer");t={...this.getFlexSettings(),...t};if(i){t.layer=i.toUpperCase()}if(t.scenario||t.baseId){const e=T.buildLrepRootNamespace(t.baseId,t.scenario,t.projectId);t.rootNamespace=e;t.namespace=`${e}changes/`}$.setRtaStyleClassName(t.layer);this.setProperty("flexSettings",t)};Q.prototype.getLayer=function(){return this.getFlexSettings().layer};Q.prototype.getRootControlInstance=function(){this._oRootControl||=c.getElementInstance(this.getRootControl());return this._oRootControl};Q.prototype._getTextResources=function(){return s.getResourceBundleFor("sap.ui.rta")};Q.prototype.start=async function(){if(this._sStatus!==Z){throw Error("RuntimeAuthoring is already started")}this._sStatus=Y;const t=this.getRootControlInstance();if(!t){throw Error("Root control not found")}try{await this._loadUShellServicesPromise;await Lt.call(this);await Nt.call(this,Q.needsRestart(this.getLayer()));const e=await K.handleReloadOnStart({layer:this.getLayer(),selector:t,versioningEnabled:this._oVersionsModel.getProperty("/versioningEnabled"),developerMode:this.getFlexSettings().developerMode,adaptationId:this._oContextBasedAdaptationsModel.getProperty("/displayedAdaptation/id")});if(e){throw Error("Reload triggered")}_.setAdaptationLayer(this.getLayer(),t);const i=_.getResetAndPublishInfoFromSession(t);this.bInitialResetEnabled=!!i.isResetEnabled;this._oSerializer=new O({commandStack:this.getCommandStack(),rootControl:this.getRootControl()});this.getPluginManager().preparePlugins(this.getFlexSettings(),Ft.bind(this),this.getCommandStack());const a=X.call(this);this._oldUnloadHandler=window.onbeforeunload;window.onbeforeunload=this._onUnload.bind(this);if(this.getShowToolbars()){const e=await lt(t,this.getLayer(),this._oSerializer);await Vt.call(this,e)}await ht.call(this);d.getOverlayContainer().style.setProperty("--sap-ui-rta-scrollbar-scrollWidth",`${l.getScrollbarWidth()}px`);d.getOverlayContainer().style.setProperty("--sap-ui-rta-scrollbar-scrollWidthPlusTwo",`${l.getScrollbarWidth()+2}px`);await a;if(this.getChangeVisualization){this.getChangeVisualization()._oDesignTime=this._oDesignTime}et.call(this,true);const o=await ct(this.getRootControlInstance(),this.getLayer());if(o){const t=this.getGuidedTour();t.attachTourClosed(()=>{if(this.getWhatsNew){const t=["GuidedTour"];this.getWhatsNew().initializeWhatsNewDialog(t)}});k.getTourContent();t.autoStart(k.getTourContent())}else if(this.getWhatsNew){this.getWhatsNew().initializeWhatsNewDialog()}this.getPopupManager().setRta(this);if(this.getShowToolbars()){await this.getToolbar().show()}this.fnKeyDown=pt.bind(this);document.addEventListener("keydown",this.fnKeyDown);this.fnOnPersonalizationChangeCreation=nt.bind(this);C.attachChangeCreation(t,this.fnOnPersonalizationChangeCreation);it.call(this);this._sStatus=q;Q.disableRestart(this.getLayer());this.fireStart({editablePluginsCount:this.getPluginManager().getEditableOverlaysCount()});await this.pServices}catch(t){if(t.message==="Reload triggered"){this.destroy()}else{this._sStatus=J;this.fireFailed({vError:t.message})}throw Error(t.message)}};function X(){const t=this.getPluginManager().getPluginList();return new Promise(function(e,i){P.start("rta.dt.startup","Measurement of RTA: DesignTime start up");this._oDesignTime=new r({scope:this.getMetadataScope(),plugins:t});rt(this.getRootControlInstance(),true);this._oDesignTime.addRootElement(this._oRootControl);d.getOverlayContainer().classList.add("sapUiRta");document.body.classList.add("sapUiRtaMode");this._oDesignTime.getSelectionManager().attachChange(function(t){this.fireSelectionChange({selection:t.getParameter("selection")})},this);this._oDesignTime.attachEventOnce("synced",function(){e();P.end("rta.dt.startup","Measurement of RTA: DesignTime start up")},this);this._oDesignTime.attachEventOnce("syncFailed",function(t){i(t.getParameter("error"))})}.bind(this))}function tt(){const t=this._oVersionsModel.getProperty("/versioningEnabled");const e=t?"MSG_UNSAVED_DRAFT_CHANGES_ON_CLOSE":"MSG_UNSAVED_CHANGES_ON_CLOSE";const i=t?"BTN_UNSAVED_DRAFT_CHANGES_ON_CLOSE_SAVE":"BTN_UNSAVED_CHANGES_ON_CLOSE_SAVE";return $.showMessageBox("warning",e,{titleKey:"TIT_UNSAVED_CHANGES_ON_CLOSE",actionKeys:[i,"BTN_UNSAVED_CHANGES_ON_CLOSE_DONT_SAVE"],emphasizedActionKey:"BTN_UNSAVED_CHANGES_ON_CLOSE_SAVE",showCancel:true})}Q.prototype.stop=async function(t,e,a){let o;gt.call(this,"setBusy",true);try{t||=!_.hasDirtyChanges({selector:this.getRootControlInstance()});await ut.call(this);if(!t&&this.canSave()&&!a){const t=await tt.call(this);if(t===i.Action.CANCEL){o=true;throw Error()}if(t===this._getTextResources().getText("BTN_UNSAVED_CHANGES_ON_CLOSE_DONT_SAVE")){await this._oSerializer.clearCommandStack(true)}}const n=e?{}:await K.checkReloadOnExit({layer:this.getLayer(),selector:this.getRootControlInstance(),isDraftAvailable:this._oVersionsModel.getProperty("/draftAvailable"),versioningEnabled:this._oVersionsModel.getProperty("/versioningEnabled"),activeVersion:this._oVersionsModel.getProperty("/activeVersion"),changesNeedReloadPromise:this._bSavedChangesNeedReload?Promise.resolve(true):this._oSerializer.needsReload()});if(!t){await this._serializeToLrep(false,true)}gt.call(this,"hide",t);this.fireStop();if(!e){A.removeInfoSessionStorage(this.getRootControlInstance());K.handleReloadOnExit(n);K.removeDontShowWhatsNewAfterReload()}v.clearInstances()}catch(t){if(!o){dt(t)}}gt.call(this,"setBusy",false);et.call(this,false);if(!o){this._sStatus=Z;document.body.classList.remove("sapUiRtaMode")}};Q.prototype.setCommandStack=function(t){const e=this.getProperty("commandStack");if(e){e.detachModified(ht,this)}if(this._oInternalCommandStack){this._oInternalCommandStack.destroy();delete this._oInternalCommandStack}const i=this.setProperty("commandStack",t);if(t){t.attachModified(ht,this)}if(this.getPluginManager&&this.getPluginManager()){this.getPluginManager().provideCommandStack(t)}return i};Q.prototype.getCommandStack=function(){let t=this.getProperty("commandStack");if(!t){t=new L;this._oInternalCommandStack=t;this.setCommandStack(t)}return t};Q.prototype.setMode=function(t){const e=this.getMode();if(e!==t){const i=this.getPluginManager().getPlugin("selection");if(e==="navigation"||t==="navigation"){this._oDesignTime.setEnabled(t!=="navigation");et.call(this,e==="navigation")}const a=this.getChangeVisualization?.();if(t==="visualization"||e==="visualization"){g.waitForSynced(this._oDesignTime)().then(function(){return a.triggerModeChange(this.getRootControl(),this.getToolbar())}.bind(this))}if(e==="adaptation"){this.getPluginManager().handleStopCutPaste()}i.setIsActive(!(t==="visualization"));const o=d.getOverlayContainer();if(t==="visualization"){o.classList.add("sapUiRtaVisualizationMode")}else{o.classList.remove("sapUiRtaVisualizationMode")}if(t==="visualization"){document.querySelectorAll(".sapUiDtOverlayMovable").forEach(function(t){t.style.cursor="default"})}else{document.querySelectorAll(".sapUiDtOverlayMovable").forEach(function(t){t.style.cursor="move"})}this._oToolbarControlsModel.setProperty("/modeSwitcher",t);this.setProperty("mode",t);this.fireModeChanged({mode:t})}};Q.prototype.setMetadataScope=function(t){if(this._sStatus!==Z){e.error("sap.ui.rta: Failed to set metadata scope on RTA instance after RTA is started");return}this.setProperty("metadataScope",t)};Q.prototype.destroy=function(...t){const e=Object.keys(this._dependents);e.forEach(function(t){this._dependents[t].destroy(true);this.removeDependent(t)}.bind(this));et.call(this,false);if(this._oDesignTime){this._oDesignTime.destroy();this._oDesignTime=null;document.removeEventListener("keydown",this.fnKeyDown);if(this.fnOnPersonalizationChangeCreation){C.detachChangeCreation(this.getRootControlInstance(),this.fnOnPersonalizationChangeCreation)}}if(this.getRootControlInstance()){rt(this.getRootControlInstance(),false)}this.setCommandStack(null);window.onbeforeunload=this._oldUnloadHandler;o.prototype.destroy.apply(this,t)};Q.needsRestart=function(t){return K.needsAutomaticStart(t)};Q.enableRestart=function(t,e){K.enableAutomaticStart(t,e)};Q.disableRestart=function(t){K.disableAutomaticStart(t)};Q.willRTAStartAfterReload=function(t){return K.needsAutomaticStart(t||R.CUSTOMER)};Q.prototype.getSelection=function(){if(this._oDesignTime){return this._oDesignTime.getSelectionManager().get()}return[]};Q.prototype.restore=function(){const t=this.getLayer();const e="FORM_PERS_RESET_MESSAGE";const a="FORM_PERS_RESET_TITLE";this.getPluginManager().handleStopCutPaste();return $.showMessageBox("warning",e,{titleKey:a,actions:[i.Action.OK,i.Action.CANCEL],emphasizedAction:i.Action.OK}).then(function(e){if(e===i.Action.OK){Q.enableRestart(t,this.getRootControlInstance());return xt.call(this)}return undefined}.bind(this))};Q.prototype.undo=function(){this.getPluginManager().handleStopCutPaste();return this.getCommandStack().undo()};Q.prototype.redo=function(){this.getPluginManager().handleStopCutPaste();return this.getCommandStack().redo()};Q.prototype.canUndo=function(){return this.getCommandStack().canUndo()};Q.prototype.canSave=function(){return this.getCommandStack().canSave()};Q.prototype.canRedo=function(){return this.getCommandStack().canRedo()};Q.prototype.save=function(){return ut.call(this).then(this._serializeToLrep.bind(this))};Q.prototype._serializeToLrep=function(t,e,i){if(!this._bSavedChangesNeedReload){return this._oSerializer.needsReload().then(function(a){this._bSavedChangesNeedReload=a;return mt.call(this,i,t,e)}.bind(this))}return mt.call(this,i,t,e)};Q.prototype.condenseAndSaveChanges=function(...t){return this._serializeToLrep(...t)};Q.prototype._onUnload=function(){if(this.canSave()&&this.getShowWindowUnloadDialog()){return this._getTextResources().getText("MSG_UNSAVED_CHANGES")}window.onbeforeunload=this._oldUnloadHandler;return undefined};function et(t){this._oDesignTime?.getRootElements().forEach(e=>{const i=e.isA("sap.ui.core.Component")?e.getRootControl():e;i?.setBlocked(t)})}function it(){const t=new URLSearchParams(window.location.search).get("sap-ui-rta-skip-flex-validation");const e=f.isCustomerSystem();if(!e&&t!=="true"){H(this)}}function at(t){const e=t.getParameters().getSource();if(e.isA("sap.m.Dialog")&&this.getToolbar().type==="fiori"){this.getToolbar().setColor("contrast")}this.getToolbar().bringToFront()}function ot(t){if(t.getParameters().isA("sap.m.Dialog")){this.getToolbar().setColor()}}function nt(){if(this.getMode()==="navigation"&&!this._bNavigationModeWarningShown){st.call(this,"MSG_NAVIGATION_MODE_CHANGES_WARNING",{duration:5e3});this._bNavigationModeWarningShown=true}}function st(t,e){const i=this._getTextResources().getText(t);a.show(i,e||{})}function rt(t,e){if(t.isA("sap.ui.core.UIComponent")){t=t.getRootControl()}if(t){t[e?"addStyleClass":"removeStyleClass"]("sapUiRtaRoot")}}async function lt(t,e,i){const a=await y.isPublishAvailable();const o=await D.isSaveAsAvailable(t,e,i);const n=await y.isContextBasedAdaptationAvailable(e);const s=await T.getUShellService("AppLifeCycle");const r=s?.getCurrentApplication()?.homePage||false;return{publishAvailable:a,saveAsAvailable:!r&&a&&o,contextBasedAdaptationAvailable:!r&&n}}async function ct(t,e){const i=T.getConnectors();const a=["LocalStorageConnector","SessionStorageConnector"];const o=i.length>0;const n=o&&i.every(t=>!a.includes(t));if(!n||w.isDeveloperLayer(e)){return false}const s=await f.getUserId();if(s==="DEFAULT_USER"||!s){return false}const r=await _._getFlexObjectsForUser({selector:t,layer:e});if(!r||r.length>0){return false}const l=(await y.getSeenFeatureIds({layer:e})).length>0;return!l}function dt(t){n.hide();const a=t.userMessage||t.stack||t.message||t.status||t;const o=s.getResourceBundleFor("sap.ui.rta");e.error("Failed to transfer changes",a);const r=`${o.getText("MSG_LREP_TRANSFER_ERROR")}\n\t\t\t${o.getText("MSG_ERROR_REASON",[a])}`;i.error(r,{styleClass:$.getRtaStyleClassName()})}async function ht(){const t=!this.getShowToolbars()||!this.getCommandStack().canUndo();try{const e=await $.checkDraftOverwrite(this._oVersionsModel,t);if(e){await v.discardDraft({layer:this.getLayer(),control:this.getRootControlInstance(),updateState:true,discardDraftAndKeepActiveVersion:true})}if(this.getShowToolbars()){const t=this.getCommandStack();const e=t.canUndo();const i=t.canRedo();const a=t.canSave();const o=t.getSaved();const n=this._oToolbarControlsModel.getProperty("/translation/visible")&&b.hasTranslationRelevantDirtyChanges({layer:R.CUSTOMER,selector:this.getRootControlInstance()});this._oVersionsModel.setDirtyChanges(_.hasDirtyChanges({selector:this.getRootControlInstance()}));this._oToolbarControlsModel.setProperty("/undo/enabled",e);this._oToolbarControlsModel.setProperty("/redo/enabled",i);this._oToolbarControlsModel.setProperty("/save/enabled",a);this._oToolbarControlsModel.setProperty("/restore/enabled",this.bInitialResetEnabled||a||o);this._oToolbarControlsModel.setProperty("/translation/enabled",this.bPersistedDataTranslatable||n);const s=this._bSavedChangesNeedReload||await this._oSerializer.needsReload();this._oToolbarControlsModel.setProperty("/changesNeedHardReload",s)}this.fireUndoRedoStackModified()}catch(t){this.undo()}}function gt(t,e){if(this.getShowToolbars()&&this.getToolbar&&this.getToolbar()){return this.getToolbar()[t](e)}return undefined}async function ut(){await(this._oDesignTime?.waitForBusyPlugins());return this._pElementModified}function pt(t){const e=j.os.macintosh;const i=d.getOverlayContainer().contains(document.activeElement);const a=this.getShowToolbars()&&this.getToolbar().getDomRef().contains(document.activeElement);let o=false;document.querySelectorAll(".sapUiDtContextMenu").forEach(function(t){if(t.contains(document.activeElement)){o=true}});const n=document.body===document.activeElement;const s=l.getParents(document.activeElement,".sapUiRtaEditableField").length>0;if((i||a||o||n)&&!s){const i=e?t.metaKey:t.ctrlKey;if(t.keyCode===u.Z&&t.shiftKey===false&&t.altKey===false&&i===true){this.undo().then(t.stopPropagation.bind(t))}else if((e&&t.keyCode===u.Z&&t.shiftKey===true||!e&&t.keyCode===u.Y&&t.shiftKey===false)&&t.altKey===false&&i===true){this.redo().then(t.stopPropagation.bind(t))}}}async function ft(){if(this.canSave()){const t=await $.showMessageBox("information","MSG_SAVE_AND_RELOAD_DIALOG",{actions:[i.Action.OK,i.Action.CANCEL],emphasizedAction:i.Action.OK});if(t===i.Action.CANCEL){return}}await this.save();if(this._oVersionsModel.getProperty("/versioningEnabled")){await v.loadDraftForApplication({control:this.getRootControlInstance(),layer:this.getLayer()})}Q.enableRestart(this.getLayer(),this.getRootControlInstance());await this.stop(true,true,true);K.reloadPage()}function St(t){const e=t.getParameter("callback")||function(){};const i=this._oVersionsModel.getProperty("/versioningEnabled");return this.save().then(function(){st.call(this,i?"MSG_SAVE_DRAFT_SUCCESS":"MSG_SAVE_SUCCESS",{duration:5e3})}.bind(this)).catch(function(t){return dt(t)}).then(e)}async function mt(t,e,i){if(this.getShowToolbars()){this.bPersistedDataTranslatable=this._oToolbarControlsModel.getProperty("/translation/enabled")}const a={layer:this.getLayer(),removeOtherLayerChanges:true,condenseAnyLayer:e};if(this._oVersionsModel.getProperty("/versioningEnabled")){const e=this._oVersionsModel.getProperty("/displayedVersion");let o=t?e:undefined;o||=i?undefined:S.Number.Draft;a.version=o;a.saveAsDraft=this.getLayer()===R.CUSTOMER&&e===S.Number.Draft}if(this._oContextBasedAdaptationsModel.getProperty("/contextBasedAdaptationsEnabled")){a.adaptationId=i?undefined:this._oContextBasedAdaptationsModel.getProperty("/displayedAdaptation/id")}await this._oSerializer.saveCommands(a);if(!i&&this.getChangeVisualization){const t=this.getToolbar();const e=this.getChangeVisualization();e.updateAfterSave(t)}}async function Ct(t){const e=t.getParameter("versionTitle");if(It.call(this)&&Ot.call(this)){const t=await $.showMessageBox("warning","MSG_DRAFT_DISCARD_ON_REACTIVATE_DIALOG",{titleKey:"TIT_DRAFT_DISCARD_ON_REACTIVATE_DIALOG",actions:[i.Action.OK,i.Action.CANCEL],emphasizedAction:i.Action.OK});if(t===i.Action.OK){return yt.call(this,e)}}return yt.call(this,e)}async function yt(t){const e=this.getLayer();const i=this.getRootControlInstance();const a=this._oVersionsModel.getProperty("/displayedVersion");try{await this._serializeToLrep(false,false,true);await v.activate({layer:e,control:i,title:t,displayedVersion:a});await _.updateResetAndPublishInfo({selector:i,layer:e});st.call(this,"MSG_DRAFT_ACTIVATION_SUCCESS");this.getPluginManager().getPlugin("toolHooks").setVersionWasActivated(true);this.bInitialResetEnabled=true;this._oToolbarControlsModel.setProperty("/restore/enabled",true);this.getCommandStack().removeAllCommands()}catch(t){$.showMessageBox("error","MSG_DRAFT_ACTIVATION_FAILED",{error:t})}}async function _t(){const t=await $.showMessageBox("warning","MSG_DRAFT_DISCARD_DIALOG",{actions:[i.Action.OK,i.Action.CANCEL],emphasizedAction:i.Action.OK});if(t===i.Action.OK){await v.discardDraft({layer:this.getLayer(),control:this.getRootControlInstance(),updateState:true});await At.call(this)}}function At(){const t=this.getLayer();const e={layer:t,removeDraft:true,selector:this.getRootControlInstance()};Q.enableRestart(t,this.getRootControlInstance());this.getCommandStack().removeAllCommands();K.triggerReload(e);return this.stop(true,true)}function bt(){if(this.canSave()){vt.call(this,"DAC_DATA_LOSS_DIALOG_DESCRIPTION","DAC_DIALOG_HEADER",true)}else{vt.call(this,"DAC_DIALOG_DESCRIPTION","DAC_DIALOG_HEADER")}}function vt(t,e,a){$.showMessageBox("confirm",t,{titleKey:e}).then(function(t){if(t===i.Action.OK){n.show();if(a){this.getCommandStack().removeAllCommands(true)}Rt.call(this)}}.bind(this))}function Rt(){P.start("onCBADeleteAdaptation","Measurement of deleting a context-based adaptation");m.remove({control:this.getRootControlInstance(),layer:this.getLayer(),adaptationId:this._oContextBasedAdaptationsModel.getProperty("/displayedAdaptation/id")}).then(function(){n.hide();const t=this._oContextBasedAdaptationsModel.deleteAdaptation();Tt.call(this,t);P.end("onCBADeleteAdaptation");if(P.getActive()){e.info(`onCBADeleteAdaptation: ${P.getMeasurement("onCBADeleteAdaptation").time} ms`)}}.bind(this)).catch(function(t){n.hide();e.error(t.stack);const i="MSG_LREP_TRANSFER_ERROR";const a={titleKey:"DAC_DIALOG_HEADER"};a.details=t.userMessage;$.showMessageBox("error",i,a)})}async function wt(t,e,a){if(this.canSave()){const o=await $.showMessageBox("warning",t,{titleKey:e,actions:[i.Action.YES,i.Action.NO,i.Action.CANCEL],emphasizedAction:i.Action.YES});if(o===i.Action.YES){await this._serializeToLrep();await a()}else if(o===i.Action.NO){this.getCommandStack().removeAllCommands(true);await a()}}else{await a()}}function Mt(t){P.start("onCBASwitchAdaptation","Measurement of switching a context-based adaptation");const i=t.getParameter("callback")||function(){};if(t.getParameter("trigger")==="SaveAs"){this.getCommandStack().removeAllCommands(true)}const a=t.getParameter("adaptationId");this._sSwitchToAdaptationId=a;return wt.call(this,"MSG_SWITCH_VERSION_DIALOG","BTN_SWITCH_ADAPTATIONS",Tt.bind(this,this._sSwitchToAdaptationId)).then(function(){i();P.end("onCBASwitchAdaptation");if(P.getActive()){e.info(`onCBASwitchAdaptation: ${P.getMeasurement("onCBASwitchAdaptation").time} ms`)}}).catch(function(t){$.showMessageBox("error","MSG_SWITCH_ADAPTATION_FAILED",{error:t});e.error(`sap.ui.rta: ${t.stack||t.message||t}`)})}function Tt(t){const e=this._oVersionsModel.getProperty("/displayedVersion");return Pt.call(this,e,t)}function Et(t){const i=t.getParameter("callback")||function(){};const a=t.getParameter("version");const o=this._oVersionsModel.getProperty("/displayedVersion");if(a===o){return}this._sSwitchToVersion=a;wt.call(this,"MSG_SWITCH_VERSION_DIALOG","TIT_SWITCH_VERSION_DIALOG",Pt.bind(this,this._sSwitchToVersion)).then(i).catch(function(t){$.showMessageBox("error","MSG_SWITCH_VERSION_FAILED",{error:t.stack});e.error(`sap.ui.rta: ${t.stack||t.message||t}`)})}function Pt(t,e){Q.enableRestart(this.getLayer(),this.getRootControlInstance());return v.loadVersionForApplication({control:this.getRootControlInstance(),layer:this.getLayer(),version:t,adaptationId:e}).then(function(){const e={versionSwitch:true,version:t,selector:this.getRootControlInstance()};K.triggerReload(e)}.bind(this))}function Dt(){this.getPluginManager().handleStopCutPaste();return v.publish({selector:this.getRootControlInstance(),styleClass:$.getRtaStyleClassName(),layer:this.getLayer(),version:this._oVersionsModel.getProperty("/displayedVersion")}).then(function(t){if(t!=="Error"&&t!=="Cancel"){a.show(t)}})}function It(){return v.isOldVersionDisplayed({control:this.getRootControlInstance(),layer:this.getLayer()})}function Ot(){return v.isDraftAvailable({control:this.getRootControlInstance(),layer:this.getLayer()})}function Lt(){return v.initialize({control:this.getRootControlInstance(),layer:this.getLayer()}).then(function(t){this._oVersionsModel=t}.bind(this))}function Nt(t){if(!t){m.clearInstances()}return m.initialize({control:this.getRootControlInstance(),layer:this.getLayer()}).then(function(t){this._oContextBasedAdaptationsModel=t}.bind(this))}async function Vt(t){if(this.getDependent("toolbar")){return}const e={id:"sapUIRta_toolbar",rtaInformation:{flexSettings:this.getFlexSettings(),rootControl:this.getRootControlInstance(),commandStack:this.getCommandStack()},textResources:this._getTextResources(),restore:this.restore.bind(this),exit:this.stop.bind(this,false,false,false)};e.publishVersion=Dt.bind(this);e.undo=this.undo.bind(this);e.redo=this.redo.bind(this);e.modeChange=Gt.bind(this);e.activate=Ct.bind(this);e.discardDraft=_t.bind(this);e.switchVersion=Et.bind(this);e.switchAdaptation=Mt.bind(this);e.deleteAdaptation=bt.bind(this);e.openChangeCategorySelectionPopover=this.getChangeVisualization?this.getChangeVisualization().openChangeCategorySelectionPopover.bind(this.getChangeVisualization()):function(){};e.save=St.bind(this);e.saveAndReload=ft.bind(this);let i;const a=!!T.getUshellContainer();if(a){const t=await M("sap/ushell/api/RTA");e.ushellApi=t;if($.isOriginalFioriToolbarAccessible()){i=new N(e)}else{i=new V(e)}}else{i=new x(e)}this.addDependent(i,"toolbar");await i.onFragmentLoaded();const o=await y.isKeyUserTranslationEnabled(this.getLayer());const n=await y.isSeenFeaturesAvailable();const s=t.saveAsAvailable;const r=s&&D.isOverviewExtended();const l=new URLSearchParams(window.location.search);const c=!l.has("fiori-tools-rta-mode")||l.get("fiori-tools-rta-mode")==="false";const d=f.getConfiguredFlexServices().some(function(t){return t.connector!=="LocalStorageConnector"});this.bPersistedDataTranslatable=false;const h=this._bSavedChangesNeedReload||await this._oSerializer.needsReload();this._oToolbarControlsModel=new E({changesNeedHardReload:h,modeSwitcher:this.getMode(),undo:{enabled:false},redo:{enabled:false},save:{enabled:false},translation:{visible:o,enabled:this.bPersistedDataTranslatable},newFeaturesOverview:{visible:n,enabled:n},appVariantMenu:{visible:s,enabled:s,overview:{visible:s&&r,enabled:s&&r},manageApps:{visible:s&&!r,enabled:s&&!r},saveAs:{visible:s,enabled:s}},restore:{visible:!this._oVersionsModel.getProperty("/versioningEnabled"),enabled:this.bInitialResetEnabled},contextBasedAdaptation:{visible:t.contextBasedAdaptationAvailable,enabled:t.contextBasedAdaptationAvailable},actionsMenuButton:{enabled:true},visualizationButton:{visible:c,enabled:c},feedbackButton:{visible:d}});this._oVersionsModel.setProperty("/publishVersionVisible",t.publishAvailable);this.getToolbar().setModel(this._oVersionsModel,"versions");this.getToolbar().setModel(this._oContextBasedAdaptationsModel,"contextBasedAdaptations");this.getToolbar().setModel(this._oToolbarControlsModel,"controls");if(o){b.getSourceLanguages({selector:this.getRootControlInstance(),layer:this.getLayer()}).then(function(t){this.bPersistedDataTranslatable=t.length>0;this._oToolbarControlsModel.setProperty("/translation/enabled",this.bPersistedDataTranslatable)}.bind(this))}if(s){const t=T.isVariantByStartupParameter(this.getRootControlInstance())?false:await D.isManifestSupported();this._oToolbarControlsModel.setProperty("/appVariantMenu/saveAs/enabled",t);this._oToolbarControlsModel.setProperty("/appVariantMenu/overview/enabled",t);this._oToolbarControlsModel.setProperty("/appVariantMenu/manageApps/enabled",t)}}function xt(){const t=this.getLayer();const e=T.getAppComponentForControl(this.getRootControlInstance());return _.reset({selector:e,layer:t}).then(function(){this.getCommandStack().removeAllCommands(true);A.removeInfoSessionStorage(e);const i={layer:t,ignoreMaxLayerParameter:true,triggerHardReload:true};return K.triggerReload(i)}.bind(this)).catch(function(t){if(t!=="cancel"){$.showMessageBox("error","MSG_RESTORE_FAILED",{error:t})}})}function Ut(t,e){function i(a){const o=a.getParameter("elementOverlay");if(o.getElement().getId()===t){this._oDesignTime.detachEvent("elementOverlayCreated",i,this);e(o)}}this._oDesignTime.attachEvent("elementOverlayCreated",i,this)}function kt(t,e){function i(t){const a=t.getSource();if(a.getGeometry()&&a.getGeometry().visible){a.detachEvent("geometryChanged",i);e(a)}}function a(t){if(!t.getGeometry()||!t.getGeometry().visible){t.attachEvent("geometryChanged",i)}else{e(t)}}Ut.call(this,t,function(t){if(t.isRendered()){a(t)}else{t.attachEventOnce("afterRendering",function(t){a(t.getSource())})}})}function Bt(t,e,i){const a=function(t){if(t.getSelectable()){t.setSelected(true)}else{t.attachEventOnce("selectableChange",()=>{t.setSelected(true)})}this.getPluginManager().getPlugin("rename").startEdit(t)}.bind(this);kt.call(this,e,async function(e){const o=this.getPluginManager().getPlugin("createContainer").getCreatedContainerId(t,e.getElement().getId());const n=h.getOverlay(o);if(n){if(i){await this.getPluginManager().getPlugin("rename").createRenameCommand(n,i);this.getCommandStack().compositeLastTwoCommands()}else{a(n)}}else{kt.call(this,o,a)}}.bind(this))}function Ft(t){const i=t.getParameter("command");const a=t.getParameter("newControlId");const o=t.getParameter("action");const n=t.getParameter("title");this._pElementModified=this._pElementModified.then(function(){this.getPluginManager().handleStopCutPaste();if(i instanceof I){if(a){Ut.call(this,a,function(t){const e=t.getDesignTimeMetadata();const i=e.getData().select;if(typeof i==="function"){i(t.getElement())}});if(o){Bt.call(this,o,a,n)}}return this.getCommandStack().pushAndExecute(i).catch(function(t){if(t?.message?.indexOf?.("The following Change cannot be applied because of a dependency")>-1){$.showMessageBox("error","MSG_DEPENDENCY_ERROR",{error:t})}e.error("sap.ui.rta:",t.message,t.stack)})}return undefined}.bind(this));return this._pElementModified}function Gt(t){this.setMode(t.getParameter("item").getKey())}Q.prototype.getService=function(t){if(this._sStatus!==q){return new Promise((t,e)=>{this.attachEventOnce("start",t);this.attachEventOnce("failed",e)}).then(()=>this.getServiceManager().startService(t,this)).catch(()=>{throw Error(g.createError("RuntimeAuthoring#getService",`Can't start the service '${t}' because RTA startup failed`,"sap.ui.rta"))})}return this.getServiceManager().startService(t,this)};return Q});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/rta/Utils", ["sap/base/util/restricted/_omit","sap/m/MessageBox","sap/ui/core/Fragment","sap/ui/core/Lib","sap/ui/dt/DOMUtil","sap/ui/dt/ElementUtil","sap/ui/dt/MetadataPropagationUtil","sap/ui/dt/OverlayUtil","sap/ui/fl/apply/api/FlexRuntimeInfoAPI","sap/ui/fl/initial/api/Version","sap/ui/fl/Layer","sap/ui/fl/LayerUtils","sap/ui/fl/Utils","sap/ui/model/json/JSONModel","sap/ui/rta/util/BindingsExtractor","sap/ui/rta/util/hasStableId"],function(e,t,r,n,i,a,s,l,o,u,c,g,f,v,d,y){"use strict";var m={};m.RESOLVED_PROMISE=Promise.resolve(true);m._sFocusableOverlayClass=".sapUiDtOverlaySelectable";m._sRtaStyleClassName="";m.getRtaStyleClassName=function(){return m._sRtaStyleClassName};m.setRtaStyleClassName=function(e){if(e===c.USER){m._sRtaStyleClassName=""}else if(g.getLayerIndex(e)>-1){m._sRtaStyleClassName="sapUiRTABorder"}};m.openRemoveConfirmationDialog=function(e,t){var i=n.getResourceBundleFor("sap.ui.rta");var a;return new Promise(function(e){a=i.getText("CTX_REMOVE_TITLE");var n={messageText:t,titleText:a,icon:"sap-icon://question-mark",removeText:i.getText("BTN_FREP_REMOVE"),cancelText:i.getText("BTN_FREP_CANCEL")};var s=new v;s.setData(n);var l;var o=function(){if(l){l.close();l.destroy();l=null}};var u={removeField(){o();e(true)},closeDialog(){o();e(false)}};if(!l){r.load({name:"sap.ui.rta.view.RemoveElementDialog",controller:u}).then(function(e){l=e;l.setModel(s);l.addStyleClass(m.getRtaStyleClassName());l.open()})}else{l.addStyleClass(m.getRtaStyleClassName());l.open()}})};m.isOverlaySelectable=function(e){return e.isSelectable()&&i.isVisible(e.getDomRef())};m.getFocusableParentOverlay=function(e){if(!e){return undefined}var t=e.getParentElementOverlay();while(t&&!t.getSelectable()){t=t.getParentElementOverlay()}return t};m.getFirstFocusableDescendantOverlay=function(e){return l.getFirstDescendantByCondition(e,this.isOverlaySelectable)};m.getLastFocusableDescendantOverlay=function(e){return l.getLastDescendantByCondition(e,this.isOverlaySelectable)};m.getNextFocusableSiblingOverlay=function(e){var t=true;var r=l.getNextSiblingOverlay(e);while(r&&!this.isOverlaySelectable(r)){r=l.getNextSiblingOverlay(r)}r||=this._findSiblingOverlay(e,t);return r};m.getPreviousFocusableSiblingOverlay=function(e){var t=false;var r=l.getPreviousSiblingOverlay(e);while(r&&!this.isOverlaySelectable(r)){r=l.getPreviousSiblingOverlay(r)}r||=this._findSiblingOverlay(e,t);return r};m._findSiblingOverlay=function(e,t){var r=e.getParentElementOverlay();if(r){var n=t?l.getNextSiblingOverlay(r):l.getPreviousSiblingOverlay(r);if(!n){return this._findSiblingOverlay(r,t)}var i=t?this.getFirstFocusableDescendantOverlay(n):this.getLastFocusableDescendantOverlay(n);return i}return undefined};m.getIndex=function(e,t,r,n){var i;if(n&&typeof n==="function"){i=n(e,t)}else{var a=e.getMetadata();var s=a.getAggregation(r);var l=s._sGetter;var o=e[l]();if(Array.isArray(o)&&t){i=o.indexOf(t)+1}else{i=0}}return i};m.isOriginalFioriToolbarAccessible=function(){var e=m.getFiori2Renderer();return e&&e.getRootControl&&e.getRootControl().getShellHeader()};m.getFiori2Renderer=function(){var e=f.getUshellContainer()||{};return typeof e.getRenderer==="function"?e.getRenderer("fiori2"):undefined};m.extendWith=function(e,t,r){if(!(typeof r==="function")){throw new Error("In order to use extendWith() utility function fnCustomizer should be provided!")}for(var n in t){if(t.hasOwnProperty(n)){if(r(e[n],t[n],n,e,t)){e[n]=t[n]}}}};m.showMessageBox=function(r,i,a){var s=n.getResourceBundleFor("sap.ui.rta");a||={};var l=s.getText(i,a.error?[a.error.userMessage||a.error.message||a.error]:undefined);var o=a.titleKey&&s.getText(a.titleKey);var u=a.actionKeys&&a.actionKeys.map(function(e){return s.getText(e)});var c=a.emphasizedActionKey?s.getText(a.emphasizedActionKey):undefined;var g=a.showCancel;var f=e(a,["titleKey","error","actionKeys","emphasizedAction","emphasizedActionKey","showCancel"]);f.title=o;f.styleClass=m.getRtaStyleClassName();f.actions||=u;f.emphasizedAction=c||a.emphasizedAction;if(g){f.actions.push(t.Action.CANCEL)}return h(r,l,f)};function h(e,r,n){return new Promise(function(i){n.onClose=i;t[e](r,n)})}m.checkSourceTargetBindingCompatibility=function(e,t,r){r||=e.getModel();var n=d.collectBindingPaths(e,r);var i;var a;if(n.bindingPaths.length===0){return true}i=d.getBindingContextPath(e);a=d.getBindingContextPath(t);if(i===a){return true}return false};m.doIfAllControlsAreAvailable=function(e,t){if(e.every(function(e){return e&&!e._bIsBeingDestroyed})){return t()}return undefined};m.isS4HanaCloud=function(){return o.isAtoEnabled()&&o.getSystem()};m.checkTargetZone=function(e,t,r,n){function i(e,t,r,n){var i=e.getDesignTimeMetadata();var a=i.getAction("move",t);if(!a){return Promise.resolve(false)}return n.hasChangeHandler(a.changeType,r)}return a.checkTargetZone(e,t,n).then(function(n){if(!n){return false}var a=t.getElement();var l=e.getParent();var o=t.getRelevantContainer();if(!a||!l){return false}var u=l.getElement();var c=e.getDesignTimeMetadata();var g=s.getRelevantContainerForPropagation(c.getData(),a);g||=u;if(!o||!g||!y(l)||o!==g){return false}if(t.getParent().getElement()!==u&&!m.checkSourceTargetBindingCompatibility(a,u)){return false}return i(e,a,g,r)})};m.checkDraftOverwrite=function(e,r){var n=e.getProperty("/backendDraft");var i=e.getProperty("/displayedVersion")===u.Number.Draft;if(i||!n||r){return Promise.resolve(false)}return m.showMessageBox("warning","MSG_DRAFT_DISCARD_AND_CREATE_NEW_DIALOG",{titleKey:"TIT_DRAFT_DISCARD_DIALOG",actions:[t.Action.OK,t.Action.CANCEL],emphasizedAction:t.Action.OK}).then(function(e){if(e!==t.Action.OK){throw"cancel"}return true})};m.isElementVisible=function(e){if(!e){return false}return!!(e.offsetWidth||e.offsetHeight||e.getClientRects().length)};return m},true);
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/rta/api/startAdaptation", ["sap/ui/rta/util/adaptationStarter","sap/ui/fl/Layer","sap/ui/fl/LayerUtils","sap/base/util/merge"],function(e,i,t,r){"use strict";function a(e){if(!t.isValidLayer(e)){throw new Error("An invalid layer is passed")}}function s(t,s,n,l,u){var f={flexSettings:{developerMode:false,layer:i.CUSTOMER}};t=r(f,t);return Promise.resolve().then(a.bind(this,t.flexSettings.layer)).then(e.bind(this,t,s,n,l,u))}return s});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/rta/api/startKeyUserAdaptation", ["sap/ui/rta/util/adaptationStarter","sap/ui/fl/Layer"],function(t,r){"use strict";function e(e){var o={rootControl:e.rootControl,flexSettings:{developerMode:false,layer:r.CUSTOMER}};return t(o)}return e});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/rta/appVariant/AppVariantDialog", ["sap/m/Button","sap/m/Dialog","sap/m/DialogRenderer","sap/m/GenericTile","sap/m/ImageContent","sap/m/Input","sap/m/Label","sap/m/SelectDialog","sap/m/StandardListItem","sap/m/TextArea","sap/m/TileContent","sap/m/VBox","sap/ui/core/Element","sap/ui/core/library","sap/ui/core/Lib","sap/ui/core/IconPool","sap/ui/core/Title","sap/ui/layout/form/SimpleForm","sap/ui/layout/library","sap/ui/model/Filter","sap/ui/model/FilterOperator","sap/ui/model/json/JSONModel","sap/ui/rta/Utils","sap/ui/layout/form/ResponsiveGridLayout"],function(e,t,a,n,i,l,s,r,o,u,p,c,d,g,A,m,T,_,v,I,L,y,f){"use strict";var{SimpleFormLayout:S}=v.form;var{ValueState:h}=g;var C=A.getResourceBundleFor("sap.ui.rta");var E;var x;var P;var V;var w;var b;var O;var N;var B;var D;var R;var G;var M;function U(){E=new n("tile",{header:"{/title}",subheader:"{/subtitle}",ariaLabel:C.getText("APP_VARIANT_TILE_ARIA_LABEL"),tileContent:[new p({content:[new i({src:"{/icon}"})]})]}).addStyleClass("sapUiMediumMarginBegin").addStyleClass("sapUiTinyMarginTop").addStyleClass("sapUiTinyMarginBottom")}function X(e){var t=e.getParameter("value");var a=new I("name",L.Contains,t);var n=e.getSource().getBinding("items");n.filter([a])}function F(e){var t=e.getParameter("selectedContexts");if(t&&t.length){t.forEach(function(e){var t=e.getObject().name;B.setValue(t);G.setProperty("/icon",e.getObject().icon)})}e.getSource().getBinding("items").filter([])}function j(){R||=new r("selectDialog",{noDataText:C.getText("APP_VARIANT_ICON_NO_DATA"),title:C.getText("APP_VARIANT_ICON_SELECT_ICON"),search(e){X(e)},confirm(e){F(e)},cancel(e){F(e)}});R.addStyleClass(f.getRtaStyleClassName());R.bindAggregation("items",{path:"/icons",template:new o({title:"{name}",description:"",icon:"{icon}",iconDensityAware:false,iconInset:false,type:"Active"})});var e=m.getIconNames();var t=[];e.forEach(function(e){var a=m.getIconInfo(e);t.push({icon:a.uri,name:a.text===""?e.toLowerCase():a.text})});M.setProperty("/icons",t);R.setModel(M);R.getBinding("items").filter([]);R.open()}function H(){x=new s({required:true,text:C.getText("APP_DIALOG_TITLE_TEXT"),textAlign:"Left"});P=new l("titleInput",{value:"{/title}",valueLiveUpdate:true,placeholder:C.getText("SAVE_AS_DIALOG_PLACEHOLDER_TITLE_TEXT"),liveChange(){var e=d.getElementById("saveButton");if(this.getValue()===""){this.setValueState(h.Error);e.setEnabled(false)}else{this.setValueState(h.None);e.setEnabled(true)}}});V=new s({text:C.getText("APP_DIALOG_SUB_TITLE_TEXT"),textAlign:"Left"});w=new l({value:"{/subtitle}",valueLiveUpdate:true});b=new s({text:C.getText("APP_DIALOG_DESCRIPTION_TEXT"),textAlign:"Left"});O=new u({rows:4});N=new s({text:C.getText("APP_DIALOG_ICON_TEXT"),textAlign:"Left"});B=new l("selectInput",{showValueHelp:true,liveChange(e){j(e)},valueHelpRequest(e){j(e)},value:"{/iconname}",valueLiveUpdate:true})}function q(){D=new _({editable:true,layout:S.ResponsiveGridLayout,labelSpanXL:4,labelSpanL:4,labelSpanM:4,labelSpanS:4,adjustLabelSpan:false,emptySpanXL:0,emptySpanL:0,emptySpanM:0,emptySpanS:0,columnsXL:2,columnsL:2,columnsM:2,singleContainerFullSize:false,content:[new T("title1"),x,P,V,w,N,B,b,O,new T("title2"),E]});return D}function z(){var e=new c({items:[q()]}).addStyleClass("sapUISmallMargin");return e}var J=t.extend("sap.ui.rta.appVariant.AppVariantDialog",{metadata:{library:"sap.ui.rta",events:{create:{},cancel:{}}},init(){t.prototype.init.apply(this);this.setTitle(C.getText("CREATE_APP_VARIANT_DIALOG_TITLE"));this.setContentWidth("860px");this.setContentHeight("250px");G=new y({title:null,subtitle:null,icon:" ",iconname:null});M=new y({icons:null});this.setModel(G);U();H();this.addContent(z());this._createButtons();this.addStyleClass(f.getRtaStyleClassName())},onAfterRendering(){document.getElementById("title1").style.height="0px";document.getElementById("title2").style.height="0px";document.getElementById("tile").style.float="left"},_onCreate(){var e=P.getValue()||" ";var t=w.getValue()||" ";var a=O.getValue()||" ";var n=B.getValue()?m.getIconInfo(B.getValue()).uri:" ";this.fireCreate({title:e,subTitle:t,description:a,icon:n});this.close();this.destroy()},_createButtons(){this.addButton(new e("saveButton",{text:C.getText("APP_VARIANT_DIALOG_SAVE"),tooltip:C.getText("TOOLTIP_APP_VARIANT_DIALOG_SAVE"),enabled:false,press:function(){this._onCreate()}.bind(this)}));this.addButton(new e({text:C.getText("SAVE_AS_APP_VARIANT_DIALOG_CANCEL"),tooltip:C.getText("TOOLTIP_SAVE_AS_APP_VARIANT_DIALOG_CANCEL"),press:function(){this.fireCancel();this.close();this.destroy()}.bind(this)}))},destroy(...e){if(G){G.destroy()}t.prototype.destroy.apply(this,e)},renderer:a});return J});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/rta/appVariant/AppVariantManager", ["sap/ui/base/ManagedObject","sap/ui/rta/appVariant/AppVariantDialog","sap/ui/rta/appVariant/AppVariantUtils","sap/ui/rta/appVariant/Feature","sap/ui/rta/appVariant/S4HanaCloudBackend"],function(e,t,n,a,r){"use strict";const i=e.extend("sap.ui.rta.appVariant.AppVariantManager",{metadata:{library:"sap.ui.rta",properties:{commandSerializer:{type:"object"},layer:{type:"string"}}}});i.prototype._openDialog=function(e,n){const a=new t("appVariantDialog");a.attachCreate(e);a.attachCancel(n);a.attachAfterClose(function(){this.destroy()});a.open();return a};i.prototype._prepareAppVariantData=function(e,t){return{referenceAppId:e["sap.app"].id,title:t.title,subTitle:t.subTitle,description:t.description,icon:t.icon,inbounds:e["sap.app"].crossNavigation&&e["sap.app"].crossNavigation.inbounds?e["sap.app"].crossNavigation.inbounds:null}};i.prototype.createAllInlineChanges=function(e,t){const a=n.getId(e.referenceAppId);const r=[];let i={};i.content=n.prepareTextsChange("title",e.title);r.push(n.createInlineChange(i,"appdescr_app_setTitle",t));i.content=n.prepareTextsChange("subtitle",e.subTitle);r.push(n.createInlineChange(i,"appdescr_app_setSubTitle",t));i.content=n.prepareTextsChange("description",e.description);r.push(n.createInlineChange(i,"appdescr_app_setDescription",t));i=n.getInlineChangeInputIcon(e.icon);r.push(n.createInlineChange(i,"appdescr_ui_setIcon",t));return n.getInboundInfo(e.inbounds).then(function(p){const o=p.currentRunningInbound;if(p.addNewInboundRequired){const i=n.prepareAddNewInboundChange(o,a,e).then(function(e){return n.createInlineChange(e,"appdescr_app_addNewInbound",t)});r.push(i)}else{i=n.prepareChangeInboundChange(o,a,e);r.push(n.createInlineChange(i,"appdescr_app_changeInbound",t))}i=n.prepareRemoveAllInboundsExceptOneChange(o);r.push(n.createInlineChange(i,"appdescr_app_removeAllInboundsExceptOne",t));return Promise.all(r)})};i.prototype.createAppVariant=function(e,t){const a={id:e,layer:this.getLayer()};return n.createAppVariant(t,a)};i.prototype.deleteAppVariant=function(e){return n.deleteAppVariant({appId:e},this.getLayer())};i.prototype.processSaveAsDialog=function(e,t){return new Promise(function(n,r){const i=function(t){const a=t.getParameters();const r=this._prepareAppVariantData(e,a);n(r)}.bind(this);const p=function(){if(!t){return a.onGetOverview(true,this.getLayer())}r()}.bind(this);return this._openDialog(i,p)}.bind(this))};i.prototype._clearRTACommandStack=function(){return this.getCommandSerializer().clearCommandStack()};i.prototype.clearRTACommandStack=function(e){const t=this.getCommandSerializer().getCommandStack();if(e&&t.getAllExecutedCommands().length){return this._clearRTACommandStack()}return Promise.resolve()};i.prototype.triggerCatalogPublishing=function(e,t,a){const r=a?n.triggerCatalogAssignment:n.triggerCatalogUnAssignment;return r(e,this.getLayer(),t).catch(function(t){const r=a?"MSG_CATALOG_ASSIGNMENT_FAILED":"MSG_DELETE_APP_VARIANT_FAILED";return n.catchErrorDialog(t,r,e)})};i.prototype.notifyKeyUserWhenPublishingIsReady=function(e,t,a){const i=new r;return i.notifyFlpCustomizingIsReady(e,a).catch(function(e){let r=a?"MSG_TILE_CREATION_FAILED":"MSG_DELETE_APP_VARIANT_FAILED";if(!a&&e.error==="locked"){r="MSG_CATALOGS_LOCKED"}return n.catchErrorDialog(e,r,t)})};i.prototype.showSuccessMessage=function(e){return n.showRelevantDialog(e,true)};return i});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/rta/appVariant/AppVariantOverviewDialog", ["sap/ui/core/ComponentContainer","sap/ui/core/Lib","sap/m/Button","sap/m/Dialog","sap/m/DialogRenderer","sap/ui/rta/appVariant/manageApps/webapp/Component","sap/ui/rta/Utils"],function(t,e,n,s,a,i,o){"use strict";var p=s.extend("sap.ui.rta.appVariant.AppVariantOverviewDialog",{metadata:{library:"sap.ui.rta",properties:{idRunningApp:"string",isOverviewForKeyUser:{type:"boolean"},layer:"string"},events:{cancel:{}}},constructor:function(...n){s.prototype.constructor.apply(this,n);this._oTextResources=e.getResourceBundleFor("sap.ui.rta");this.oManageAppsComponent=new i("sap.ui.rta.appVariant.manageApps",{idRunningApp:this.getIdRunningApp(),isOverviewForKeyUser:this.getIsOverviewForKeyUser(),layer:this.getLayer()});this.oManageAppsComponentContainer=new t({component:this.oManageAppsComponent});this.addContent(this.oManageAppsComponentContainer);this._createButton();this.setContentWidth("1000px");this.setContentHeight("450px");this.setHorizontalScrolling(false);this.setTitle(this._oTextResources.getText("APP_VARIANT_OVERVIEW_DIALOG_TITLE"));this.addStyleClass(o.getRtaStyleClassName())},destroy(...t){s.prototype.destroy.apply(this,t)},renderer:a});p.prototype._createButton=function(){this.addButton(new n({text:this._oTextResources.getText("APP_VARIANT_DIALOG_CLOSE"),press:function(){this.close();this.fireCancel()}.bind(this)}))};return p});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/rta/appVariant/AppVariantUtils", ["sap/ui/fl/Utils","sap/m/MessageBox","sap/ui/rta/Utils","sap/ui/core/BusyIndicator","sap/ui/core/EventBus","sap/ui/core/Lib","sap/base/util/uid","sap/base/Log","sap/ui/fl/write/api/PersistenceWriteAPI","sap/ui/fl/write/api/AppVariantWriteAPI","sap/ui/fl/write/api/ChangesWriteAPI","sap/ui/fl/write/_internal/connectors/LrepConnector"],function(e,t,n,r,a,i,s,o,u,p,c,l){"use strict";var g={};var d=56;g._newAppVariantId=null;g.getManifirstSupport=function(e){return l.appVariant.getManifirstSupport({appId:e})};g.getNewAppVariantId=function(){return g._newAppVariantId};g.setNewAppVariantId=function(e){g._newAppVariantId=e};g.trimIdIfRequired=function(e){if(e.length>d){var t=e.split(".");var n;var r=t[t.length-1].length;var a=t.pop();n=t.join(".");if(n.length>r){n=n.substring(0,n.length-r)}else{return e.substr(0,d)}if(n[n.length-1]==="."){n=n+a}else{n=`${n}.${a}`}return this.trimIdIfRequired(n)}return e};g.getId=function(e){var t;var n=e.split(".");if(n[0]!=="customer"){n[0]=`customer.${n[0]}`}var r=false;var a=/^id.*/i;n.forEach(function(e,t,n){if(e.match(a)){e=e.replace(a,s().replace(/-/g,"_"));n[t]=e;r=true}});t=n.join(".");if(!r){t=`${t}.${s().replace(/-/g,"_")}`}t=this.trimIdIfRequired(t);this.setNewAppVariantId(t);return t};g.createAppVariant=function(e,t){t.version="1.0.0";return p.saveAs({selector:e,...t})};g.getInlineChangeInput=function(e,t){return{type:"XTIT",maxLength:50,comment:t,value:{"":e}}};g.prepareTextsChange=function(e,t){var n=`New ${e} entered by a key user via RTA tool`;return this.getInlineChangeInput(t,n)};g.getInlineChangeInputIcon=function(e){return{content:{icon:e}}};g.prepareRemoveAllInboundsExceptOneChange=function(e){return{content:{inboundId:e}}};g.getInboundInfo=function(t){var n={};if(!t){n.currentRunningInbound="customer.savedAsAppVariant";n.addNewInboundRequired=true;return Promise.resolve(n)}return e.getUShellService("URLParsing").then(function(t){return e.getParsedURLHash(t)}).then(function(e){var r=Object.keys(t);var a=[];if(r.length===1&&r[0]==="customer.savedAsAppVariant"){return{currentRunningInbound:"customer.savedAsAppVariant",addNewInboundRequired:false}}r.forEach(function(n){if(t[n].action===e.action&&t[n].semanticObject===e.semanticObject){a.push(n)}});switch(a.length){case 0:n.currentRunningInbound="customer.savedAsAppVariant";n.addNewInboundRequired=true;break;case 1:[n.currentRunningInbound]=a;n.addNewInboundRequired=false;break;default:n.currentRunningInbound="customer.savedAsAppVariant";n.addNewInboundRequired=true;break}return n})};g.getInboundPropertiesKey=function(e,t,n){return`${e}_sap.app.crossNavigation.inbounds.${t}.${n}`};g.getInlineChangeForInboundPropertySaveAs=function(e,t){return{inboundId:e,entityPropertyChange:{propertyPath:"signature/parameters/sap-appvar-id",operation:"UPSERT",propertyValue:{required:true,filter:{value:t,format:"plain"},launcherValue:{value:t}}}}};g.prepareAddNewInboundChange=function(t,n,r){return e.getUShellService("URLParsing").then(function(t){return e.getParsedURLHash(t)}).then(function(e){var a={content:{inbound:{}},texts:{}};var i=this.getInboundPropertiesKey(r.referenceAppId,t,"title");var s=this.getInboundPropertiesKey(r.referenceAppId,t,"subTitle");a.content.inbound[t]={semanticObject:e.semanticObject,action:e.action,title:`{{${i}}}`,subTitle:`{{${s}}}`,icon:r.icon,signature:{parameters:{"sap-appvar-id":{required:true,filter:{value:n,format:"plain"},launcherValue:{value:n}}},additionalParameters:"ignored"}};a.texts[i]=this.prepareTextsChange("title",r.title);a.texts[s]=this.prepareTextsChange("subTitle",r.subTitle);return a}.bind(this))};g.prepareChangeInboundChange=function(e,t,n){var r={content:{},texts:{}};var a=this.getInboundPropertiesKey(n.referenceAppId,e,"title");var i=this.getInboundPropertiesKey(n.referenceAppId,e,"subTitle");r.content={inboundId:e,entityPropertyChange:[{propertyPath:"signature/parameters/sap-appvar-id",operation:"UPSERT",propertyValue:{required:true,filter:{value:t,format:"plain"},launcherValue:{value:t}}},{propertyPath:"title",operation:"UPSERT",propertyValue:`{{${a}}}`},{propertyPath:"subTitle",operation:"UPSERT",propertyValue:`{{${i}}}`},{propertyPath:"icon",operation:"UPSERT",propertyValue:n.icon}]};r.texts[a]=this.prepareTextsChange("title",n.title);r.texts[i]=this.prepareTextsChange("subTitle",n.subTitle);return r};g.createInlineChange=function(e,t,n){var r={changeType:t,content:e.content};if(e.texts){r.texts=e.texts}return c.create({changeSpecificData:r,selector:n})};g.addChangesToPersistence=function(e,t){u.add({flexObjects:e,selector:t});return Promise.resolve()};g.getTransportInput=function(e,t,n,r){return{getPackage(){return e},getNamespace(){return t},getId(){return n},getDefinition(){return{fileType:r}}}};g.triggerCatalogAssignment=function(e,t,n){return p.assignCatalogs({selector:{appId:e},action:"assignCatalogs",assignFromAppId:n,layer:t})};g.triggerCatalogUnAssignment=function(e,t){return p.unassignCatalogs({selector:{appId:e},action:"unassignCatalogs",layer:t})};g.copyId=function(e){var t=document.createElement("textarea");t.value=e;document.body.appendChild(t);t.select();document.execCommand("copy");document.body.removeChild(t);return true};g.getTextResources=function(){return i.getResourceBundleFor("sap.ui.rta")};g.getText=function(e,t){var n=this.getTextResources();return t?n.getText(e,[t]):n.getText(e)};g._getErrorMessageText=function(e){var t;if(e.messages&&e.messages.length){t=e.messages.map(function(e){return e.text}).join("\n")}else if(e.userMessage){t=e.userMessage}else if(e.iamAppId){t=`IAM App Id: ${e.iamAppId}`}else{t=e.stack||e.message||e.status||e}return t};g.buildWarningInfo=function(e,t){let n=`${g.getText(e)}\n\n`;if(t){n+=`${g.getText("MSG_APP_VARIANT_ID",t)}\n`}return{text:n,appVariantId:t,warning:true}};g.buildErrorInfo=function(e,t,n){var r=this._getErrorMessageText(t);var a=`${g.getText(e)}\n\n`;if(n){a+=`${g.getText("MSG_APP_VARIANT_ID",n)}\n`}a+=g.getText("MSG_TECHNICAL_ERROR",r);o.error("App variant error: ",r);return{text:a,appVariantId:n,error:true}};g.buildSuccessInfo=function(e,t,n){var r=n?"CLOUD":"ON_PREMISE";var a=t?"":"_OVERVIEW_LIST";var i=n?undefined:e;var s=`${g.getText("SAVE_APP_VARIANT_SUCCESS_MESSAGE")}\n\n`;s+=g.getText(`SAVE_APP_VARIANT_SUCCESS_S4HANA_${r}_MESSAGE${a}`,i);return{text:s,appVariantId:e,copyId:!n}};g.buildFinalSuccessInfoS4HANACloud=function(){var e=g.getText("MSG_SAVE_APP_VARIANT_NEW_TILE_AVAILABLE");return{text:e}};g.buildDeleteSuccessMessage=function(e,t){var n=t?"DELETE_APP_VARIANT_SUCCESS_MESSAGE_CLOUD":"DELETE_APP_VARIANT_SUCCESS_MESSAGE";var r=g.getText(n,e);return{text:r}};g.showRelevantDialog=function(e,a){r.hide();var i;var s;var o;var u;var p=[];if(a){i=this.getText("SAVE_APP_VARIANT_SUCCESS_MESSAGE_TITLE");s=this.getText("SAVE_APP_VARIANT_OK_TEXT")}else{i=this.getText("HEADER_SAVE_APP_VARIANT_FAILED");s=this.getText("SAVE_APP_VARIANT_CLOSE_TEXT")}if(e&&e.copyId){u=this.getText("SAVE_APP_VARIANT_COPY_ID_TEXT");p.push(u)}else if(e&&e.deleteAppVariant){i=this.getText("DELETE_APP_VARIANT_INFO_MESSAGE_TITLE");o=this.getText("DELETE_APP_VARIANT_OK_TEXT");p.push(o);s=this.getText("DELETE_APP_VARIANT_CLOSE_TEXT")}p.push(s);return new Promise(function(r,c){var l=function(t){if(t===u){g.copyId(e.appVariantId)}if(a){r()}else if(e.overviewDialog){r(false)}else if(e.deleteAppVariant&&t===o){r()}else if(e.deleteAppVariant&&t===s){c(e.deleteAppVariant)}else if(e.error||e.warning){c(e.error||e.warning)}else{r()}};let d=t.Icon.NONE;if(a||e.deleteAppVariant){d=t.Icon.INFORMATION}else if(e.warning){d=t.Icon.WARNING}else{d=t.Icon.ERROR}t.show(e.text,{icon:d,onClose:l,title:i,actions:p,styleClass:n.getRtaStyleClassName()})})};g.closeOverviewDialog=function(){a.getInstance().publish("sap.ui.rta.appVariant.manageApps.controller.ManageApps","navigate")};g.navigateToFLPHomepage=function(){var t=e.getUshellContainer();var n;if(t){return t.getServiceAsync("AppLifeCycle").then(function(e){var r=e.getCurrentApplication();n=r.componentInstance;if(n){return t.getServiceAsync("Navigation")}return undefined}).then(function(e){if(e&&e.navigate){e.navigate({target:{shellHash:"#"}},n)}}).catch(function(e){throw new Error(`Error navigating to FLP Homepage: ${e}`)})}return Promise.resolve()};g.deleteAppVariant=function(e,t){r.hide();return p.deleteAppVariant({selector:e,layer:t})};g.handleBeforeUnloadEvent=function(){return g.getText("MSG_DO_NOT_CLOSE_BROWSER")};g.showMessage=function(e){var t=g.getText(e);var n={text:t,copyId:false};return g.showRelevantDialog(n,true)};g.catchErrorDialog=function(e,t,n){r.hide();var a=g.buildErrorInfo(t,e,n);return g.showRelevantDialog(a,false)};return g},true);
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/rta/appVariant/Feature", ["sap/base/util/merge","sap/ui/core/BusyIndicator","sap/ui/core/EventBus","sap/ui/fl/apply/api/FlexRuntimeInfoAPI","sap/ui/fl/write/_internal/appVariant/AppVariantFactory","sap/ui/fl/write/api/FeaturesAPI","sap/ui/fl/Utils","sap/ui/rta/appVariant/AppVariantUtils","sap/ui/rta/util/showMessageBox"],function(e,n,t,r,i,s,a,o,u){"use strict";let c;let l;let p;let f;let h;const d=function(){return a.getAppDescriptor(p)};const g=function(){window.onbeforeunload=h};const A=function(e){const n=e?"MSG_DO_NOT_CLOSE_BROWSER_CURRENTLY_ADAPTING":"MSG_DO_NOT_CLOSE_BROWSER";h=window.onbeforeunload;window.onbeforeunload=o.handleBeforeUnloadEvent;return o.showMessage(n)};const v=function(e,n){return l.triggerCatalogPublishing(e,n,true)};const w=function(e){return l.triggerCatalogPublishing(e,null,false)};const I=function(e,t){if(c){o.closeOverviewDialog();return this.onGetOverview(true,t)}else if(!c&&e){n.hide();return this.onGetOverview(true,t)}return Promise.resolve()};const b=function(e,n,t){return e?o.navigateToFLPHomepage():I.call(this,!n,t)};const P=function(e,n){if(e&&e.response&&e.response.IAMId){if(!Array.isArray(e.response.CatalogIds)||e.response.CatalogIds.length===0){const e=o.getText("MSG_BASE_APP_CATALOGS_NOT_FOUND",n);const t=o.getText("HEADER_SAVE_APP_VARIANT_FAILED");u(e,{title:t},"error");return Promise.reject()}return l.notifyKeyUserWhenPublishingIsReady(e.response.IAMId,n,true)}return Promise.resolve()};const S=function(e,n){if(e&&e.response&&e.response.IAMId&&e.response.inProgress){return l.notifyKeyUserWhenPublishingIsReady(e.response.IAMId,n,false)}return Promise.resolve()};t.getInstance().subscribe("sap.ui.rta.appVariant.manageApps.controller.ManageApps","navigate",function(){if(c){c.destroy();c=null}});return{onGetOverview(e,n){const t=d();return new Promise(function(r){const i=function(){o.closeOverviewDialog()};const s="sap/ui/rta/appVariant/AppVariantOverviewDialog";const a={idRunningApp:t["sap.app"].id,isOverviewForKeyUser:e,layer:n};sap.ui.require([s],function(e){c||=new e(a);c.attachCancel(i);c.oPopup.attachOpened(function(){r(c)});c.open()})})},isOverviewExtended(){const e=new URLSearchParams(window.location.search);const n=e.get("sap-ui-xx-app-variant-overview-extended");if(!n){return false}return n.toLowerCase()==="true"},isManifestSupported(){const e=d();return o.getManifirstSupport(e["sap.app"].id)},isSaveAsAvailable(e,n,t){p=e;f=t;const r=d();if(r["sap.app"]&&r["sap.app"].id){return s.isSaveAsAvailable(n).then(function(e){if(e){if(r["sap.app"].crossNavigation&&r["sap.app"].crossNavigation.inbounds){return o.getInboundInfo(r["sap.app"].crossNavigation.inbounds)}return o.getInboundInfo()}return undefined}).then(function(e){return!!e})}return Promise.resolve(false)},getAppVariantManifest(e){p=e;const n=d();if(n["sap.app"]&&n["sap.app"].id){return i.load({id:n["sap.app"].id})}return Promise.resolve(false)},_determineSelector(e,n){return e?p:{appId:n["sap.app"].id,appVersion:n["sap.app"].applicationVersion.version}},onSaveAs(t,i,s,u){let c;let p;let h=d();let w=true;if(u&&u["sap.app"].id===h["sap.app"].id){i=true;h=e({},u);u=null}else if(u){w=false;h=e({},u);u=null}const I=this._determineSelector(w,h);return new Promise(function(u){const d=function(){return l.processSaveAsDialog(h,t)};const w=function(e){n.show();return l.createAllInlineChanges(e,I)};const S=function(e){const n=e.slice();return o.addChangesToPersistence(n,I)};const _=function(){const e=o.getNewAppVariantId();return l.createAppVariant(e,I).catch(function(n){let t=n.messageKey;t||="MSG_SAVE_APP_VARIANT_FAILED";return o.catchErrorDialog(n,t,e)})};const m=function(n){p=null;p=e({},n.response);return l.clearRTACommandStack(i)};const E=function(){const e=a.getUshellContainer();if(e&&i){e.setDirtyFlag(false)}};var O=function(){E();c=r.isAtoEnabled();const e=o.buildSuccessInfo(p.id,t,c);return l.showSuccessMessage(e)};const D=function(){const e=o.buildFinalSuccessInfoS4HANACloud();return l.showSuccessMessage(e)};const V=function(){n.show();if(c){let e;return A().then(function(){return v(p.id,p.reference)}).then(function(r){e={...r};n.hide();return b.call(this,t,null,s)}.bind(this)).then(function(){return P(e,p.id)}).then(function(){g();return D()}).then(function(){return t?u():b.call(this,t,c,s)}.bind(this))}n.hide();return b.call(this,t,c,s)};sap.ui.require(["sap/ui/rta/appVariant/AppVariantManager"],function(e){l||=new e({commandSerializer:f,layer:s});return d().then(w).then(S).then(_).then(m).then(O).then(V.bind(this)).then(u).catch(function(e){if(!e){return false}if(c){g()}return b.call(this,null,c,s).then(u)}.bind(this))}.bind(this))}.bind(this))},onDeleteFromOverviewDialog(e,t,i){let s;return new Promise(function(a){sap.ui.require(["sap/ui/rta/appVariant/AppVariantManager"],function(u){l||=new u({rootControl:p,commandSerializer:f,layer:i});const c=function(){return l.deleteAppVariant(e).catch(function(n){if(n==="cancel"){return Promise.reject("cancel")}let t=n.messageKey;t||="MSG_DELETE_APP_VARIANT_FAILED";return o.catchErrorDialog(n,t,e)})};const h=function(){o.closeOverviewDialog();const n=o.buildDeleteSuccessMessage(e,s);return l.showSuccessMessage(n)};const d=function(){s=r.isAtoEnabled();if(s){let n;return A(t).then(function(){return w(e)}).then(function(e){n={...e};return I.call(this,!t,i)}.bind(this)).then(function(){return S(n,e)})}n.show();return Promise.resolve()};const v=function(){if(s){g()}n.hide();return t?a():I.call(this,!s,s,i).then(a)};if(t){o.closeOverviewDialog();o.navigateToFLPHomepage()}return d.call(this).then(c).then(h).then(v.bind(this)).catch(function(e){if(e==="cancel"){return false}if(s){g()}return I.call(this,null,s,i).then(a)}.bind(this))}.bind(this))}.bind(this))}}});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/rta/appVariant/S4HanaCloudBackend", ["sap/ui/base/ManagedObject","sap/ui/model/odata/v2/ODataModel","sap/base/Log"],function(t,a,e){"use strict";var n;var r=t.extend("sap.ui.rta.appVariant.S4HanaCloudBackend",{metadata:{library:"sap.ui.rta"},constructor:function(...a){t.apply(this,a)}});r.prototype.notifyFlpCustomizingIsReady=function(t,a,n,r){var i=this;return new Promise(function(o,u){function s(t){return!isNaN(parseFloat(t))&&isFinite(t)}var c=s(n)?n:2500;var d=s(r)?r:-1;function p(){if(d===0){o({iamAppId:t,customizingIsReady:false});return}else if(d>0){d=d-1}this.checkCatalogCustomizingIsReady(t,a).then(function(a){if(a){o({iamAppId:t,customizingIsReady:true})}else{setTimeout(p.bind(i),c)}}).catch(function(n){var r=a?"creation":"deletion";e.error(`Catalog publishing failed for app variant ${r}. AppVarStatus is ${n.message}`);u({iamAppId:t,error:n.message})})}setTimeout(p.bind(i),c)})};r._isAppReady=function(t,a){var e=t.data.results;if(!Array.isArray(e)){throw new Error(`${t.requestUri} returned unexpected result: ${t}`)}var n=e.every(function(t){return t.ActualStatus===1});var r=e.every(function(t){return t.ActualStatus===2});var i=e.some(function(t){return t.ActualStatus===5});var o=e.some(function(t){return t.ActualStatus===4});if(i||o){var u=i?"error":"locked";throw new Error(u)}return a?r:n};r._getODataModel=function(){n||=new Promise(function(t,e){var r=new a("/sap/opu/odata/sap/APS_IAM_APP_SRV");r.attachMetadataFailed(function(t){e(t);n=null});r.metadataLoaded().then(function(){t(r)})});return n};r._readODataModel=function(t,a){return new Promise(function(e,n){var r=function(t,a){e(a)};var i=function(t){n(t)};t.read(`/aps_iam_app_ddl('${a}')/to_BusinessCatalogAssignment`,{success:r,error:i})})};r.prototype.checkCatalogCustomizingIsReady=function(t,a){return r._getODataModel().then(function(a){return r._readODataModel(a,t)}).then(function(t){return r._isAppReady(t,a)})};return r});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/rta/appVariant/Utils", ["sap/ui/core/IconPool","sap/ui/fl/apply/api/FlexRuntimeInfoAPI","sap/ui/fl/write/api/AppVariantWriteAPI","sap/ui/fl/Utils","sap/ui/rta/appVariant/AppVariantUtils"],function(t,e,i,a,n){"use strict";const r={};r._checkNavigationSupported=function(t){const e=a.getUshellContainer();return e.getServiceAsync("Navigation").then(function(e){return e.getLinks([t])}).catch(function(t){throw new Error(`Error retrieving ushell service Navigation: ${t}`)})};r._checkAppType=function(t,e,i){if(t&&e){return i.getText("MAA_ORIGINAL_TYPE")}else if(e){return i.getText("MAA_APP_VARIANT_TYPE")}else if(t){return i.getText("MAA_ORIGINAL_TYPE")}return undefined};r._calculateCurrentStatus=function(t,e,i){const a=n.getNewAppVariantId();if(e==="R"){return i.getText("MAA_OPERATION_IN_PROGRESS")}else if(a===t){n.setNewAppVariantId(null);if(e!=="E"){return i.getText("MAA_NEW_APP_VARIANT")}}};r._checkMenuItemOptions=function(t,e){const i={};if(t.isKeyUser){if(t.isOriginal){i.delAppVarButtonVisibility=false;i.adaptUIButtonVisibility=false;return i}if(t.appVarStatus==="U"||t.appVarStatus==="E"||t.appVarStatus==="R"){i.saveAsButtonEnabled=false}i.adaptUIButtonVisibility=true;if(e){if(t.isS4HanaCloud){i.delAppVarButtonEnabled=true;i.delAppVarButtonVisibility=true}else{i.delAppVarButtonEnabled=false;i.delAppVarButtonVisibility=true}}else{i.delAppVarButtonVisibility=true;if(t.appVarStatus==="R"){i.delAppVarButtonEnabled=false}else{i.delAppVarButtonEnabled=true}}}else{i.delAppVarButtonVisibility=false;i.adaptUIButtonVisibility=false}return i};r._getNavigationInfo=function(t){let e={};const i=t.startWith.semanticObject;const a=t.startWith.action;const n=t.startWith.parameters;const r={semanticObject:i,action:a,params:n};return this._checkNavigationSupported(r).then(function(r){if(r[0].length&&t.isKeyUser){e.adaptUIButtonEnabled=true;if(t.appVarStatus==="R"||t.appVarStatus==="U"||t.appVarStatus==="E"){e.adaptUIButtonEnabled=false;e.appVarStatus=t.appVarStatus}}else{e.adaptUIButtonEnabled=false}const s=this._checkMenuItemOptions(t,e.adaptUIButtonEnabled);e.semanticObject=i;e.action=a;if(n){Object.keys(n).forEach(function(t){if(n[t].value){n[t]=n[t].value}});e.params=n}e={...e,...s};return e}.bind(this))};r._prepareAppVariantAttributes=function(t){return{appId:t.appId,title:t.title||"",subTitle:t.subTitle||"",description:t.description||"",icon:t.iconUrl||"",iconText:t.iconText,isOriginal:t.isOriginal,isAppVariant:t.isAppVariant,descriptorUrl:t.descriptorUrl,appVarStatus:t.appVarStatus}};r.getAppVariantOverviewAttributes=function(i,a,n){let r;const s=i.iconUrl;if(s&&t.isIconURI(s)){i.iconText=s.split("//")[1]}r=this._prepareAppVariantAttributes(i);r.isKeyUser=a;r.typeOfApp=this._checkAppType(i.isOriginal,i.isAppVariant,n);r.currentStatus=this._calculateCurrentStatus(i.appId,i.appVarStatus,n);const p=e.isAtoEnabled();r.isS4HanaCloud=p;const u={isKeyUser:a,isOriginal:i.isOriginal,isS4HanaCloud:p,appVarStatus:i.appVarStatus};if(i.hasStartableIntent){u.startWith=i.startWith;return this._getNavigationInfo(u).then(function(t){r={...r,...t};return r})}r.adaptUIButtonEnabled=false;const o=this._checkMenuItemOptions(u,false);r={...r,...o};return Promise.resolve(r)};r.getAppVariantOverview=function(t,e,a){const n=e?"CUSTOMER*":"VENDOR";const r={selector:{appId:t},layer:n};return i.listAllAppVariants(r).then(function(t){const i=[];let n;if(t.response&&t.response.items){n=t.response.items}else{return Promise.resolve([])}n.forEach(function(t){if(!t.isDescriptorVariant){i.push(this.getAppVariantOverviewAttributes(t,e,a))}},this);return Promise.all(i).then(function(t){return t})}.bind(this))};r.getManifest=function(t){return i.getManifest(t).then(function(t){return t.response})};return r},true);
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/rta/appVariant/manageApps/webapp/Component", ["sap/ui/core/UIComponent"],function(e){"use strict";var t;var r;var i;return e.extend("sap.ui.rta.appVariant.manageApps.webapp.Component",{metadata:{manifest:"json",library:"sap.ui.rta",version:"0.9",properties:{idRunningApp:"string",isOverviewForKeyUser:{type:"boolean"},layer:"string"}},constructor:function(...n){t=n[1].idRunningApp;r=n[1].isOverviewForKeyUser;i=n[1].layer;e.prototype.constructor.apply(this,n)},init(...n){this.setIdRunningApp(t);this.setIsOverviewForKeyUser(r);this.setLayer(i);e.prototype.init.apply(this,n)}})});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/rta/appVariant/manageApps/webapp/controller/ManageApps.controller", ["sap/ui/core/mvc/Controller","sap/ui/fl/Layer","sap/ui/fl/Utils","sap/ui/rta/appVariant/manageApps/webapp/model/models","sap/ui/rta/appVariant/AppVariantUtils","sap/ui/rta/appVariant/Utils","sap/m/MessageBox","sap/ui/rta/Utils","sap/ui/rta/appVariant/Feature","sap/ui/rta/RuntimeAuthoring","sap/ui/core/BusyIndicator","sap/base/i18n/ResourceBundle","sap/m/MessageToast","sap/m/MenuItem"],function(t,e,n,r,i,a,o,s,u,p,A,g,_,l){"use strict";let c;let I;let h;let T;let d;return t.extend("sap.ui.rta.appVariant.manageApps.webapp.controller.ManageApps",{onInit(){c=this.getOwnerComponent().getIdRunningApp();I=this.getOwnerComponent().getIsOverviewForKeyUser();h=this.getOwnerComponent().getLayer();const t=n.getUshellContainer();A.show();return this._createResourceBundle().then(function(){if(t){return t.getServiceAsync("Navigation").then(function(t){T=t})}return undefined}).then(()=>a.getAppVariantOverview(c,I,this._oI18n)).then(function(t){A.hide();if(t.length){return this._arrangeOverviewDataAndBindToModel(t).then(function(t){return this._highlightNewCreatedAppVariant(t)}.bind(this))}i.closeOverviewDialog();return this._showMessageWhenNoAppVariantsExist()}.bind(this)).catch(function(t){i.closeOverviewDialog();const e=i.buildErrorInfo("MSG_MANAGE_APPS_FAILED",t);e.overviewDialog=true;A.hide();return i.showRelevantDialog(e,false)})},async _createResourceBundle(){d=`${sap.ui.require.toUrl("sap/ui/rta/appVariant/manageApps/")}webapp/i18n/i18n.properties`;this._oI18n=await g.create({url:d,async:true})},_showMessageWhenNoAppVariantsExist(){return s.showMessageBox(o.Icon.INFORMATION,"MSG_APP_VARIANT_OVERVIEW_SAP_DEVELOPER",{titleKey:"TITLE_APP_VARIANT_OVERVIEW_SAP_DEVELOPER"})},_highlightNewCreatedAppVariant(t){const e=this.byId("Table1");if(!e){return Promise.resolve()}e.focus();t.forEach((t,n)=>{if(t.currentStatus===this._oI18n.getText("MAA_NEW_APP_VARIANT")||t.currentStatus===this._oI18n.getText("MAA_OPERATION_IN_PROGRESS")){if(e.getItems().length>=n){e.getItems()[n].focus()}}});return Promise.resolve()},_arrangeOverviewDataAndBindToModel(t){const e=t.filter(function(t){return t.appId===c});const n=e[0];if(n&&n.appVarStatus!=="R"){n.currentStatus=this._oI18n.getText("MAA_CURRENTLY_ADAPTING")}t=t.filter(function(t){return t.appId!==c});t.unshift(n);const i=t.filter(function(t){return t.isOriginal});const a=i[0];t=t.filter(function(t){return!t.isOriginal});t.unshift(a);const o={appVariants:t};const s=r.createModel(o);this.getView().setModel(s);return Promise.resolve(t)},formatRowHighlight(t){if(t===this._oI18n.getText("MAA_CURRENTLY_ADAPTING")){return"Success"}else if(t===this._oI18n.getText("MAA_NEW_APP_VARIANT")){return"Information"}else if(t===this._oI18n.getText("MAA_OPERATION_IN_PROGRESS")){return"Warning"}return"None"},formatDelButtonTooltip(t,e){if(!t&&!e){return this._oI18n.getText("TOOLTIP_DELETE_APP_VAR")}return undefined},formatAdaptUIButtonTooltip(t,e){if(!t){switch(e){case"R":return this._oI18n.getText("TOOLTIP_ADAPTUI_STATUS_RUNNING");case"U":return this._oI18n.getText("TOOLTIP_ADAPTUI_STATUS_UNPBLSHD_ERROR");case"E":return this._oI18n.getText("TOOLTIP_ADAPTUI_STATUS_UNPBLSHD_ERROR");case"P":return this._oI18n.getText("TOOLTIP_ADAPTUI_STATUS_PUBLISHED");case undefined:return this._oI18n.getText("TOOLTIP_ADAPTUI_ON_PREMISE");default:}}return undefined},formatAdaptUIButtonVisibility(t,e){return t&&e},getModelProperty(t,e){return this.getView().getModel().getProperty(t,e)},onMenuAction(t){let e=t.getParameter("item");let n="";while(e instanceof l){n=`${e.getText()} > ${n}`;e=e.getParent()}n=n.substr(0,n.lastIndexOf(" > "));if(n===this._oI18n.getText("MAA_DIALOG_ADAPT_UI")){return this.handleUiAdaptation(t)}else if(n===this._oI18n.getText("MAA_DIALOG_COPY_ID")){return this.copyId(t)}else if(n===this._oI18n.getText("MAA_DIALOG_DELETE_APPVAR")){return this.deleteAppVariant(t)}return undefined},handleUiAdaptation(t){const n=this.getModelProperty("semanticObject",t.getSource().getBindingContext());const r=this.getModelProperty("action",t.getSource().getBindingContext());const a=this.getModelProperty("params",t.getSource().getBindingContext());let o;if(n&&r&&a){o={target:{semanticObject:n,action:r},params:a,writeHistory:false};p.enableRestart(e.CUSTOMER);if(T){T.navigate(o)}i.closeOverviewDialog();return true}return false},copyId(t){const e=this.getModelProperty("appId",t.getSource().getBindingContext());i.copyId(e);_.show(this._oI18n.getText("MAA_COPY_ID_SUCCESS"))},deleteAppVariant(t){const e={};const n=this._oI18n.getText("MSG_APP_VARIANT_DELETE_CONFIRMATION");e.text=n;e.deleteAppVariant=true;const r=this.getModelProperty("appId",t.getSource().getBindingContext());const a=this.getModelProperty("currentStatus",t.getSource().getBindingContext());const o=a===this._oI18n.getText("MAA_CURRENTLY_ADAPTING");return i.showRelevantDialog(e).then(function(){return u.onDeleteFromOverviewDialog(r,o,h)}).catch(function(){return true})}})});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/rta/appVariant/manageApps/webapp/model/models", ["sap/ui/model/json/JSONModel"],function(e){"use strict";return{createModel(n){var t=new e(n);t.setDefaultBindingMode("OneWay");return t}}});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/rta/command/AddIFrame", ["sap/ui/rta/command/FlexCommand"],function(t){"use strict";var e=t.extend("sap.ui.rta.command.AddIFrame",{metadata:{library:"sap.ui.rta",properties:{baseId:{type:"string",group:"content"},targetAggregation:{type:"string",group:"content"},index:{type:"int",group:"content"},url:{type:"string",group:"content"},width:{type:"string",group:"content"},height:{type:"string",group:"content"},title:{type:"string",group:"content"},advancedSettings:{type:"object",defaultValue:{},group:"content"},changeType:{type:"string",defaultValue:"addIFrame"}},associations:{},events:{}}});e.prototype.applySettings=function(...e){const n=e[0];var r={};Object.keys(n).filter(function(t){return t!=="url"}).forEach(function(t){r[t]=n[t]});e[0]=r;t.prototype.applySettings.apply(this,e);this.setUrl(n.url)};e.prototype._getChangeSpecificData=function(){var e=t.prototype._getChangeSpecificData.call(this);var n=e.changeType;delete e.changeType;return{changeType:n,content:e.content}};return e},true);
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/rta/command/AddProperty", ["sap/ui/rta/command/FlexCommand"],function(t){"use strict";var e=t.extend("sap.ui.rta.command.AddProperty",{metadata:{library:"sap.ui.rta",properties:{index:{type:"int",group:"content"},newControlId:{type:"string",group:"content"},bindingString:{type:"string",group:"content"},modelType:{type:"string",group:"content"},relevantContainerId:{type:"string",group:"content"},parentId:{type:"string",group:"content"},oDataServiceVersion:{type:"string",group:"content"},oDataServiceUri:{type:"string",group:"oDataInformation"},propertyName:{type:"string",group:"oDataInformation"},entityType:{type:"string",group:"oDataInformation"}}}});e.prototype._getChangeSpecificData=function(){return{changeType:this.getChangeType(),content:{index:this.getIndex(),newControlId:this.getNewControlId(),bindingPath:this.getBindingString(),parentId:this.getParentId(),modelType:this.getModelType(),relevantContainerId:this.getRelevantContainerId(),oDataServiceVersion:this.getODataServiceVersion()},oDataInformation:{oDataServiceUri:this.getODataServiceUri(),propertyName:this.getPropertyName(),entityType:this.getEntityType()}}};return e},true);
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/rta/command/AddXML", ["sap/ui/rta/command/FlexCommand"],function(t){"use strict";var e=t.extend("sap.ui.rta.command.AddXML",{metadata:{library:"sap.ui.rta",properties:{fragment:{type:"string",group:"content"},fragmentPath:{type:"string",group:"content"},targetAggregation:{type:"string",group:"content"},index:{type:"int",group:"content"},changeType:{type:"string",defaultValue:"addXML"}},associations:{},events:{}}});e.prototype.bindProperty=function(...e){const[n,r]=e;if(n==="fragment"){return this.setFragment(r.bindingString)}return t.prototype.bindProperty.apply(this,e)};e.prototype._applyChange=function(...e){const n=e[0];var r={};r[n.getFlexObjectMetadata().moduleName]=this.getFragment();sap.ui.require.preload(r);return t.prototype._applyChange.apply(this,e)};return e},true);
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/rta/command/AddXMLAtExtensionPoint", ["sap/ui/rta/command/FlexCommand","sap/ui/core/util/reflection/JsControlTreeModifier","sap/ui/fl/apply/api/ExtensionPointRegistryAPI","sap/ui/fl/write/api/ChangesWriteAPI","sap/ui/fl/Utils"],function(e,t,n,r,o){"use strict";var i=e.extend("sap.ui.rta.command.AddXMLAtExtensionPoint",{metadata:{library:"sap.ui.rta",properties:{fragment:{type:"string",group:"content"},fragmentPath:{type:"string",group:"content"},changeType:{type:"string",defaultValue:"addXMLAtExtensionPoint"}},associations:{},events:{}}});i.prototype.bindProperty=function(...t){const[n,r]=t;if(n==="fragment"){return this.setFragment(r.bindingString)}return e.prototype.bindProperty.apply(this,t)};i.prototype.getAppComponent=function(){var e=this.getSelector().view;return o.getAppComponentForControl(e)};i.prototype._applyChange=function(e){var o={};o[e.getFlexObjectMetadata().moduleName]=this.getFragment();sap.ui.require.preload(o);var i=e.change||e;var a=this.getAppComponent();var p=i.getSelector();var s=t.bySelector(p.viewSelector,a);var u=n.getExtensionPointInfo({name:p.name,view:s});var g=u.targetControl;i.setExtensionPointInfo(u);var c={modifier:t,appComponent:a,view:s};return r.apply({change:i,element:g,...c}).then(function(e){if(!e.success){return Promise.reject(e.error)}return undefined})};return i},true);
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/rta/command/AnnotationCommand", ["sap/ui/fl/write/api/ChangesWriteAPI","sap/ui/fl/write/api/FeaturesAPI","sap/ui/fl/write/api/LocalResetAPI","sap/ui/fl/write/api/PersistenceWriteAPI","sap/ui/fl/LayerUtils","sap/ui/rta/command/FlexCommand","sap/ui/rta/library"],function(e,t,a,n,s,i,o){"use strict";const r=i.extend("sap.ui.rta.command.AnnotationCommand",{metadata:{library:"sap.ui.rta",properties:{changeType:{type:"string"},serviceUrl:{type:"string"},content:{type:"any"},changesToDelete:{type:"object[]",defaultValue:[]}},events:{}}});r.prototype._createChange=function(a,n,i){this._aToBeResetChanges=[];const r={...this._getChangeSpecificData(),...a,serviceUrl:this.getServiceUrl(),command:i,jsOnly:this.getJsOnly(),generator:a.generator||o.GENERATOR_NAME};if(this.getChangesToDelete().length){const n=[];if(t.isLocalResetEnabled()){this.getChangesToDelete().forEach(e=>{if(s.compareAgainstCurrentLayer(e.getLayer(),a.layer)===-1){n.push(e)}else{this._aToBeResetChanges.push(e)}})}else{n.push(...this.getChangesToDelete())}if(n.length){this._oDeactivateChange=e.create({changeSpecificData:{changeType:"deactivateChanges",content:{changeIds:n.map(e=>e.getId())},generator:a.generator||o.GENERATOR_NAME,layer:a.layer},selector:this.getAppComponent()})}}return e.create({changeSpecificData:r,annotationChange:true,selector:this.getAppComponent()})};r.prototype.execute=async function(){if(this._aToBeResetChanges.length){await a.resetChanges(this._aToBeResetChanges,this.getAppComponent(),true)}if(this._oDeactivateChange){n.add({selector:this.getAppComponent(),flexObjects:[this._oDeactivateChange]})}};r.prototype.undo=async function(){if(this._aToBeResetChanges.length){await a.restoreChanges(this._aToBeResetChanges,this.getAppComponent(),true)}if(this._oDeactivateChange){n.remove({selector:this.getAppComponent(),flexObjects:[this._oDeactivateChange]})}};r.prototype.needsReload=true;return r});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/rta/command/BaseCommand", ["sap/ui/base/ManagedObject","sap/ui/core/Element"],function(e,t){"use strict";var n=e.extend("sap.ui.rta.command.BaseCommand",{metadata:{library:"sap.ui.rta",properties:{name:{type:"string"},runtimeOnly:{type:"boolean"},relevantForSave:{type:"boolean",defaultValue:true}},associations:{element:{type:"sap.ui.core.Element"}},events:{}}});n.prototype.getElement=function(){var e=this.getAssociation("element");return t.getElementById(e)};n.prototype.prepare=function(){return true};n.prototype.execute=function(){return Promise.resolve()};n.prototype.getVariantChange=function(){return this._oVariantChange};n.prototype.undo=function(){return Promise.resolve()};n.prototype.isEnabled=function(){return true};return n});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/rta/command/BindProperty", ["sap/ui/rta/command/FlexCommand"],function(t){"use strict";var e=t.extend("sap.ui.rta.command.BindProperty",{metadata:{library:"sap.ui.rta",properties:{propertyName:{type:"string",group:"content"},newBinding:{type:"string",group:"content"},changeType:{type:"string",defaultValue:"propertyBindingChange"}},associations:{},events:{}}});e.prototype.applySettings=function(...e){const[n]=e;t.prototype.applySettings.apply(this,e);this.setNewBinding(n.newBinding)};e.prototype._getChangeSpecificData=function(){var t=this.getElement();var e={changeType:this.getChangeType(),selector:{id:t.getId(),type:t.getMetadata().getName()},content:{property:this.getPropertyName(),newBinding:this.getNewBinding()}};return e};return e});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/rta/command/Combine", ["sap/ui/rta/command/FlexCommand"],function(e){"use strict";var t=e.extend("sap.ui.rta.command.Combine",{metadata:{library:"sap.ui.rta",properties:{newElementId:{type:"string",group:"content"},source:{type:"any",group:"content"},combineElements:{type:"any[]",group:"content"}},associations:{},events:{}}});t.prototype._getChangeSpecificData=function(){var e=[];this.getCombineElements().forEach(function(t){e.push(t.getId())});var t={changeType:this.getChangeType(),content:{newElementId:this.getNewElementId(),sourceControlId:this.getSource().getId(),combineElementIds:e}};return t};return t});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/rta/command/CommandFactory", ["sap/base/util/merge","sap/base/Log","sap/ui/base/ManagedObject","sap/ui/core/Element","sap/ui/dt/ElementUtil","sap/ui/dt/OverlayRegistry","sap/ui/dt/Util","sap/ui/fl/Utils","sap/ui/fl/Layer"],function(e,t,n,a,r,o,i,c,m){"use strict";function l(e){const t=r.getAggregationInformation(e.getElement());if(t.elementId){const e=o.getOverlay(t.elementId);const n=e.getParentElementOverlay();const a=n?!!r.getAggregationInformation(n.getElement()).templateId:false;if(a){throw i.createError("CommandFactory#evaluateTemplateBinding","Multiple template bindings are not supported","sap.ui.rta")}const c=r.extractTemplateId(t);if(c){return{templateSelector:t.elementId,originalSelector:c,content:{boundAggregation:t.aggregation}}}}return undefined}function d(e,t){const n=typeof e==="string"?a.getElementById(e):e;const i=o.getOverlay(n);if(i){const e=r.getAggregationInformation(n);if(typeof t==="number"){e.stack[0].index=t}return r.extractTemplateId(e)}return n.getId()}function s(e){if(!e){throw new Error("adjustment for template failed")}}function u(e,n){let a;let r=false;let o=false;if(typeof n==="string"){a=n}else if(n){a=n.changeType;r=n.jsOnly===true;o=n.CAUTION_variantIndependent===true}if(!a){return false}e.setChangeType(a);e.setJsOnly(r);if(e.setVariantIndependent){e.setVariantIndependent(o)}else if(o){t.error("the variant independent Flag is not available for the action",a)}return true}function g(e,t,n){let a;if(n){a=n.getAction(t.name,e)}const r=a||{};Object.assign(r,{changeType:t.name});return r}function p(e,t,n){var a;if(n){a=n.getAction(t.name,e)}var r=a||{};Object.assign(r,{changeType:t.name});return r}function f(e){e.element=a.getElementById(d(e.element));s(e.element)}function z(e,t,n){const r=t.element||a.getElementById(t.element.id);const o=n.getActionDataFromAggregations("createContainer",r)[0];return o}function y(e){e.element=a.getElementById(d(e.element));s(e.element);e.parentId=d(e.parentId);s(e.parentId)}function E(e,t,n){const r=t.movedElements[0].element||a.getElementById(t.movedElements[0].id);const o=n.getAction("move",r);return o}function I(e){const t=e.movedElements.map(function(e){const t=a.getElementById(d(e.element,e.sourceIndex));s(t);return t});e.movedElements.forEach(function(e,n){e.element=t[n]});e.element=a.getElementById(d(e.element));s(e.element);e.source.parent=a.getElementById(d(e.source.parent));s(e.source.parent);e.target.parent=a.getElementById(d(e.target.parent));s(e.target.parent)}function v(e,t,n){return n.getAction("localReset",e)}function C(e,t,n){const a=t.renamedElement;const r=n.getAction("rename",a);return r}function B(e){e.element=a.getElementById(d(e.element));s(e.element);e.renamedElement=a.getElementById(d(e.renamedElement));s(e.renamedElement)}function A(e,t,a){let r=t.removedElement;if(!r){r=e}else if(!(r instanceof n)){throw new Error("No valid 'removedElement' found")}const o=a.getAction("remove",r);return o}function h(e){e.element=a.getElementById(d(e.element));s(e.element);e.removedElement=a.getElementById(d(e.removedElement));s(e.removedElement)}function F(e,t,n){const a=t.source;const r=n.getAction("combine",a);return r}function S(e){e.element=a.getElementById(d(e.element));s(e.element);e.source=a.getElementById(d(e.source));s(e.source);const t=e.combineElements.map(function(e){e=a.getElementById(d(e));s(e);return e});e.combineElements=t}function b(e,t,n){const a=t.source;const r=n.getAction("split",a);return r}function j(e){e.element=a.getElementById(d(e.element));s(e.element);e.parentElement=a.getElementById(d(e.parentElement));s(e.parentElement);e.source=a.getElementById(d(e.source));s(e.source)}function O(e,t,n){const a=t.element;return n.getAction("add",a,"delegate")}function V(e){e.element=a.getElementById(d(e.element));s(e.element);e.parentId=d(e.parentId);s(e.parentId)}function P(e,t,n){const a=t.element;const r=n.getAction("reveal",a);return r}function x(e){e.element=a.getElementById(d(e.element));s(e.element);if(e.revealedElementId){e.revealedElementId=d(e.revealedElementId);s(e.revealedElementId)}if(e.directParent){e.directParent=a.getElementById(d(e.directParent));s(e.directParent)}}function R(e,t,n){const a=n.getAction("add",t.element);if(a&&a.custom&&typeof a.custom.getItems==="function"){const e={...a.custom,changeOnRelevantContainer:t.changeOnRelevantContainer,changeType:t.changeType};delete t.changeOnRelevantContainer;return e}return undefined}function T(e,t,n){return n.getAction("addIFrame",t.element)||n.getActionDataFromAggregations("addIFrame",t.element)[0]}function M(){return"propertyBindingChange"}function w(){return"propertyChange"}const L={composite:{clazz:"sap/ui/rta/command/CompositeCommand",noSelector:true},property:{clazz:"sap/ui/rta/command/Property",adjustForBinding:f,configure:w},bindProperty:{clazz:"sap/ui/rta/command/BindProperty",configure:M},addXML:{clazz:"sap/ui/rta/command/AddXML",configure:g,adjustForBinding:f},addXMLAtExtensionPoint:{clazz:"sap/ui/rta/command/AddXMLAtExtensionPoint",configure:g,adjustForBinding:f},codeExt:{clazz:"sap/ui/rta/command/ExtendControllerCommand",configure:p,adjustForBinding:f},createContainer:{clazz:"sap/ui/rta/command/CreateContainer",configure:z,adjustForBinding:y},move:{clazz:"sap/ui/rta/command/Move",configure:E,adjustForBinding:I},remove:{clazz:"sap/ui/rta/command/Remove",configure:A,adjustForBinding:h},localReset:{clazz:"sap/ui/rta/command/LocalReset",configure:v},rename:{clazz:"sap/ui/rta/command/Rename",configure:C,adjustForBinding:B},addDelegateProperty:{clazz:"sap/ui/rta/command/AddProperty",configure:O,adjustForBinding:V},reveal:{clazz:"sap/ui/rta/command/Reveal",configure:P,adjustForBinding:x},customAdd:{clazz:"sap/ui/rta/command/CustomAdd",configure:R},combine:{clazz:"sap/ui/rta/command/Combine",configure:F,adjustForBinding:S},split:{clazz:"sap/ui/rta/command/Split",configure:b,adjustForBinding:j},resize:{clazz:"sap/ui/rta/command/Resize"},switch:{clazz:"sap/ui/rta/command/ControlVariantSwitch"},save:{clazz:"sap/ui/rta/command/ControlVariantSave"},saveAs:{clazz:"sap/ui/rta/command/ControlVariantSaveAs"},setTitle:{clazz:"sap/ui/rta/command/ControlVariantSetTitle"},configure:{clazz:"sap/ui/rta/command/ControlVariantConfigure"},settings:{clazz:"sap/ui/rta/command/Settings"},addLibrary:{clazz:"sap/ui/rta/command/manifest/AddLibrary",noSelector:true},appDescriptor:{clazz:"sap/ui/rta/command/ManifestCommand",noSelector:true},manifest:{clazz:"sap/ui/rta/command/ManifestCommand",noSelector:true},annotation:{clazz:"sap/ui/rta/command/AnnotationCommand",noSelector:true},addIFrame:{clazz:"sap/ui/rta/command/AddIFrame",configure:T},compVariantContent:{clazz:"sap/ui/rta/command/compVariant/CompVariantContent"},compVariantSaveAs:{clazz:"sap/ui/rta/command/compVariant/CompVariantSaveAs"},compVariantSwitch:{clazz:"sap/ui/rta/command/compVariant/CompVariantSwitch"},compVariantUpdate:{clazz:"sap/ui/rta/command/compVariant/CompVariantUpdate"}};function U(t,a,r,c,m,d){let s;a=a[0].toLowerCase()+a.slice(1);const g=L[a];let p=m;if(!g){return Promise.reject(i.createError("CommandFactory#getCommandFor",`Command '${a}' doesn't exist, check typing`,"sap.ui.rta"))}return new Promise(function(e){const t=g.clazz;sap.ui.require([t],function(t){e(t)})}).then(function(i){const m=t instanceof n;if(!g.noSelector&&!m){r={...r,selector:t}}r={...r,element:m?t:undefined,name:a};let f;if(g.configure){f=g.configure(t,r,c)}let z;if(m){z=o.getOverlay(t)}if(f&&f.changeOnRelevantContainer){Object.assign(r,{element:z.getRelevantContainer()});t=r.element;z=o.getOverlay(t)}let y;if(z&&t.sParentAggregationName){y=l(z)}if(y){if(g.adjustForBinding){g.adjustForBinding(r)}p=e(y,p)}s=new i(r);let E=true;if(g.configure){E=u(s,f)}if(E){return s.prepare(p,d,a)}return undefined}).then(function(e){if(e){return s}s.destroy();return undefined})}const N=n.extend("sap.ui.rta.command.CommandFactory",{metadata:{library:"sap.ui.rta",properties:{flexSettings:{type:"object"}}}});N.prototype.init=function(){this.setProperty("flexSettings",{layer:m.CUSTOMER,developerMode:true})};N.prototype.setFlexSettings=function(e){this.setProperty("flexSettings",{...this.getFlexSettings(),...e})};N.prototype.getCommandFor=function(e,t,n,a,r){return U(e,t,n,a,this.getFlexSettings(),r)};N.getCommandFor=function(e,t,n,a,r){r||={layer:m.CUSTOMER,developerMode:true};if(r.scenario||r.baseId){const e=c.buildLrepRootNamespace(r.baseId,r.scenario,r.projectId);r.rootNamespace=e;r.namespace=`${e}changes/`}return U(e,t,n,a,r)};return N},true);
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/rta/command/CompositeCommand", ["sap/ui/rta/command/BaseCommand","sap/ui/rta/command/FlexCommand","sap/ui/fl/Utils"],function(t,e,o){"use strict";const n=t.extend("sap.ui.rta.command.CompositeCommand",{metadata:{library:"sap.ui.rta",properties:{},aggregations:{commands:{type:"sap.ui.rta.command.BaseCommand",multiple:true}},events:{}}});n.prototype.execute=function(){const t=[];this._forEachCommand(function(e){t.push(e.execute.bind(e))});return o.execPromiseQueueSequentially(t,true).catch(function(t){const o=this.getCommands();o.forEach(function(t){if(t instanceof e){this.removeCommand(t)}}.bind(this));return this.undo().then(function(){return Promise.reject(t)})}.bind(this))};n.prototype.undo=function(){const t=[];this._forEachCommandInReverseOrder(function(e){t.push(e.undo.bind(e))});return o.execPromiseQueueSequentially(t)};n.prototype._forEachCommand=function(t){const e=this.getCommands();e.forEach(t,this)};n.prototype._forEachCommandInReverseOrder=function(t){const e=this.getCommands();for(let o=e.length-1;o>=0;o--){t.call(this,e[o])}};n.prototype._addCompositeIdToChange=function(t){this._sCompositeId||=o.createDefaultFileName("composite");const e=t.getPreparedChange&&t.getPreparedChange();if(e){const t=e.getSupportInformation();if(!t.compositeCommand){t.compositeCommand=this._sCompositeId;e.setSupportInformation(t)}}else if(t.setCompositeId){t.setCompositeId(this._sCompositeId)}};n.prototype.addCommand=function(t,e){this._addCompositeIdToChange(t);return this.addAggregation("commands",t,e)};n.prototype.insertCommand=function(t,e,o){this._addCompositeIdToChange(t);return this.insertAggregation("commands",t,e,o)};return n});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/rta/command/ControlVariantConfigure", ["sap/ui/core/util/reflection/JsControlTreeModifier","sap/ui/fl/apply/api/ControlVariantApplyAPI","sap/ui/fl/apply/api/FlexRuntimeInfoAPI","sap/ui/fl/variants/VariantManager","sap/ui/fl/write/api/ChangesWriteAPI","sap/ui/fl/Utils","sap/ui/rta/command/BaseCommand","sap/ui/rta/library"],function(e,t,a,n,r,i,s,o){"use strict";var p=s.extend("sap.ui.rta.command.ControlVariantConfigure",{metadata:{library:"sap.ui.rta",properties:{control:{type:"any"},changes:{type:"array"},deletedVariants:{type:"array"}},associations:{},events:{}}});p.prototype.prepare=function(e){this.sLayer=e.layer;return true};p.prototype.getPreparedChange=function(){if(!this._aPreparedChanges){return undefined}return this._aPreparedChanges};p.prototype.execute=async function(){var a=this.getControl();this.oAppComponent=i.getAppComponentForControl(a);this.oModel=this.oAppComponent.getModel(t.getVariantModelName());this.sVariantManagementReference=e.getSelector(a,this.oAppComponent).id;this._aPreparedChanges=[];if(this.getChanges().some(e=>{if(e.visible===false&&e.variantReference===this.oModel.getCurrentVariantReference(this.sVariantManagementReference)){this._sOldVReference=e.variantReference;return true}return false})){await this.oModel.updateCurrentVariant({variantManagementReference:this.sVariantManagementReference,newVariantReference:this.sVariantManagementReference})}this.getChanges().forEach(function(e){e.appComponent=this.oAppComponent;e.generator=o.GENERATOR_NAME;this._aPreparedChanges.push(n.addVariantChange(this.sVariantManagementReference,e))}.bind(this));this._aDeletedFlexObjects=r.deleteVariantsAndRelatedObjects({variantManagementControl:a,layer:this.sLayer,variants:this.getDeletedVariants()});return Promise.resolve()};p.prototype.undo=async function(){const e=a.getFlexReference({element:this.getControl()});r.restoreDeletedFlexObjects({reference:e,flexObjects:this._aDeletedFlexObjects});delete this._aDeletedFlexObjects;this.getChanges().forEach(function(e,t){const a={appComponent:this.oAppComponent};Object.keys(e).forEach(function(t){var n=`original${t.charAt(0).toUpperCase()}${t.substr(1)}`;if(t==="visible"){a[t]=true}else if(e[n]){a[t]=e[n];a[n]=e[t]}else if(t.indexOf("original")===-1){a[t]=e[t]}});var r=this._aPreparedChanges[t];n.deleteVariantChange(this.sVariantManagementReference,a,r)}.bind(this));this._aPreparedChanges=null;if(this._sOldVReference){await this.oModel.updateCurrentVariant({variantManagementReference:this.sVariantManagementReference,newVariantReference:this._sOldVReference}).then(()=>{delete this._sOldVReference})}};return p});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/rta/command/ControlVariantSave", ["sap/ui/rta/command/BaseCommand","sap/ui/core/util/reflection/JsControlTreeModifier","sap/ui/fl/Utils"],function(e,t,a){"use strict";var n=e.extend("sap.ui.rta.command.ControlVariantSave",{metadata:{library:"sap.ui.rta",properties:{model:{type:"object"}},associations:{},events:{}}});n.prototype.prepare=function(){this.oAppComponent=a.getAppComponentForControl(this.getElement());this.sVariantManagementReference=t.getSelector(this.getElement(),this.oAppComponent).id;return true};n.prototype.execute=function(){var e=this.getModel().getCurrentVariantReference(this.sVariantManagementReference);this._aControlChanges=this.getModel().getVariant(e,this.sVariantManagementReference).controlChanges;this._aDirtyChanges=this.getModel()._getDirtyChangesFromVariantChanges(this._aControlChanges);this._aDirtyChanges.forEach(function(e){if(e.getFileType()==="change"){e.setSavedToVariant(true)}});this.getModel().invalidateMap();return Promise.resolve()};n.prototype.undo=function(){this._aDirtyChanges.forEach(function(e){if(e.getFileType()==="change"){e.setSavedToVariant(false)}});this.getModel().invalidateMap();return Promise.resolve()};return n});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/rta/command/ControlVariantSaveAs", ["sap/ui/core/util/reflection/JsControlTreeModifier","sap/ui/fl/variants/VariantManager","sap/ui/fl/write/api/ContextSharingAPI","sap/ui/fl/write/api/PersistenceWriteAPI","sap/ui/fl/Utils","sap/ui/rta/command/BaseCommand","sap/ui/rta/library","sap/ui/rta/Utils"],function(e,t,a,n,r,i,o,s){"use strict";var h=i.extend("sap.ui.rta.command.ControlVariantSaveAs",{metadata:{library:"sap.ui.rta",properties:{sourceVariantReference:{type:"string"},sourceDefaultVariant:{type:"string"},model:{type:"object"},newVariantParameters:{type:"object"}},associations:{},events:{}}});h.prototype.prepare=function(t){this.oVariantManagementControl=this.getElement();this.oAppComponent=r.getAppComponentForControl(this.oVariantManagementControl);this.sVariantManagementReference=e.getSelector(this.oVariantManagementControl,this.oAppComponent).id;this.oModel=this.getModel();this.setSourceDefaultVariant(this.oModel.getData()[this.sVariantManagementReference].defaultVariant);this.sLayer=t.layer;var n=t;n.variantManagementControl=this.oVariantManagementControl;function i(e,t){var a=e.getParameters();this.setNewVariantParameters(a);this.oVariantManagementControl.detachSave(i,this);this.oVariantManagementControl.detachCancel(o,this);t.resolve(true)}function o(e,t){this.oVariantManagementControl.detachSave(i,this);this.oVariantManagementControl.detachCancel(o,this);t.resolve(false)}return new Promise(function(e){this.oVariantManagementControl.attachSave({resolve:e},i,this);this.oVariantManagementControl.attachCancel({resolve:e},o,this);this.oVariantManagementControl.openSaveAsDialogForKeyUser(s.getRtaStyleClassName(),a.createComponent(n))}.bind(this)).then(function(e){return e})};h.prototype.getPreparedChange=function(){if(!this._aPreparedChanges){return undefined}return this._aPreparedChanges};h.prototype.execute=function(){var e=this.getSourceVariantReference();this._aControlChangesWithoutVariant=this.oModel.getVariant(e,this.sVariantManagementReference).controlChanges.filter(e=>!e.getSavedToVariant());var a=this.getNewVariantParameters();a.layer=this.sLayer;a.newVariantReference=this.sNewVariantReference;a.generator=o.GENERATOR_NAME;return t.handleSaveEvent(this.oVariantManagementControl,a,this.oModel).then(function(e){this._aPreparedChanges=e;[this._oVariantChange]=e;this.sNewVariantReference=this._oVariantChange.getId();this._aPreparedChanges.forEach(function(e){if(e.getFileType()==="change"){e.setSavedToVariant(true)}});this.getModel().invalidateMap()}.bind(this))};h.prototype.undo=async function(){if(this._oVariantChange){var e=[];this._aPreparedChanges.forEach(function(t){if(t.getFileType()==="ctrl_variant_management_change"){e.push(t)}});await n.remove({flexObjects:e,selector:this.oAppComponent});var a={variant:this._oVariantChange,sourceVariantReference:this.getSourceVariantReference(),variantManagementReference:this.sVariantManagementReference,appComponent:this.oAppComponent};await t.removeVariant(a,true);await t.addAndApplyChangesOnVariant(this._aControlChangesWithoutVariant,this.oAppComponent);this._aPreparedChanges=null;this._oVariantChange=null}};return h});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/rta/command/ControlVariantSetTitle", ["sap/ui/core/util/reflection/JsControlTreeModifier","sap/ui/fl/apply/api/ControlVariantApplyAPI","sap/ui/fl/variants/VariantManager","sap/ui/fl/Utils","sap/ui/rta/command/BaseCommand","sap/ui/rta/library"],function(e,t,n,a,r,i){"use strict";var o=r.extend("sap.ui.rta.command.ControlVariantSetTitle",{metadata:{library:"sap.ui.rta",properties:{oldText:{type:"string"},newText:{type:"string"}},associations:{},events:{}}});o.prototype.prepare=function(e){this.sLayer=e.layer;return true};o.prototype.getPreparedChange=function(){this._oPreparedChange=this.getVariantChange();if(!this._oPreparedChange){return undefined}return this._oPreparedChange};o.prototype.execute=function(){var r=this.getElement();this.oAppComponent=a.getAppComponentForControl(r);this.oModel=this.oAppComponent.getModel(t.getVariantModelName());this.sVariantManagementReference=e.getSelector(r,this.oAppComponent).id;this.sCurrentVariant=this.oModel.getCurrentVariantReference(this.sVariantManagementReference);var o=this.oModel.getVariantTitle(this.sCurrentVariant,this.sVariantManagementReference);this.setOldText(o);var s={appComponent:this.oAppComponent,variantReference:this.sCurrentVariant,changeType:"setTitle",title:this.getNewText(),layer:this.sLayer,generator:i.GENERATOR_NAME};return Promise.resolve(n.addVariantChange(this.sVariantManagementReference,s)).then(function(e){this._oVariantChange=e}.bind(this))};o.prototype.undo=function(){var e={variantReference:this.sCurrentVariant,changeType:"setTitle",title:this.getOldText(),appComponent:this.oAppComponent};var t=this._oVariantChange;return Promise.resolve(n.deleteVariantChange(this.sVariantManagementReference,e,t)).then(function(){this._oVariantChange=null}.bind(this))};return o});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/rta/command/ControlVariantSwitch", ["sap/ui/core/util/reflection/JsControlTreeModifier","sap/ui/fl/apply/api/ControlVariantApplyAPI","sap/ui/fl/variants/VariantManager","sap/ui/fl/Utils","sap/ui/rta/command/BaseCommand"],function(e,t,n,a,r){"use strict";var i=r.extend("sap.ui.rta.command.ControlVariantSwitch",{metadata:{library:"sap.ui.rta",properties:{targetVariantReference:{type:"string"},sourceVariantReference:{type:"string"},discardVariantContent:{type:"boolean"},discardedChanges:{type:"array"}},associations:{},events:{}},constructor:function(...e){r.apply(this,e);this.setRelevantForSave(false)}});function o(e){return n.eraseDirtyChangesOnVariant(this.sVariantManagementReference,e,this._getAppComponent()).then(function(e){this.setDiscardedChanges(e)}.bind(this))}i.prototype._getAppComponent=function(){var e=this.getElement();return e?a.getAppComponentForControl(e):this.getSelector().appComponent};i.prototype.execute=function(){var n=this.getElement();var a=this._getAppComponent();var r=this.getTargetVariantReference();this.oModel=a.getModel(t.getVariantModelName());this.sVariantManagementReference=e.getSelector(n,a).id;return Promise.resolve().then(function(){if(this.getDiscardVariantContent()){return o.call(this,this.getSourceVariantReference())}return undefined}.bind(this)).then(this._updateModelVariant.bind(this,r,a))};i.prototype.undo=function(){var e=this.getSourceVariantReference();var t=this._getAppComponent();return this._updateModelVariant(e,t).then(function(){if(this.getDiscardVariantContent()){return n.addAndApplyChangesOnVariant(this.getDiscardedChanges(),this._getAppComponent()).then(function(){this.setDiscardedChanges([]);this.oModel.checkUpdate(true)}.bind(this))}return undefined}.bind(this))};i.prototype._updateModelVariant=function(e,t){if(this.getTargetVariantReference()!==this.getSourceVariantReference()){return this.oModel.updateCurrentVariant({variantManagementReference:this.sVariantManagementReference,newVariantReference:e,appComponent:t})}return Promise.resolve()};return i});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/rta/command/CreateContainer", ["sap/ui/rta/command/FlexCommand"],function(t){"use strict";var e=t.extend("sap.ui.rta.command.CreateContainer",{metadata:{library:"sap.ui.rta",properties:{index:{type:"int",group:"content"},newControlId:{type:"string",group:"content"},label:{type:"string"},parentId:{type:"string",group:"content"}},associations:{},events:{}}});e.prototype._getChangeSpecificData=function(){var e=t.prototype._getChangeSpecificData.apply(this);e.content.newLabel=this.getLabel();return e};return e});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/rta/command/CustomAdd", ["sap/ui/rta/command/FlexCommand"],function(t){"use strict";var e=t.extend("sap.ui.rta.command.CustomAdd",{metadata:{library:"sap.ui.rta",properties:{index:{type:"int",group:"content"},addElementInfo:{type:"object",group:"content"},aggregationName:{type:"string",group:"content"},customItemId:{type:"string",group:"content"}}}});return e});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/rta/command/ExtendControllerCommand", ["sap/ui/core/Element","sap/ui/fl/apply/api/FlexRuntimeInfoAPI","sap/ui/fl/write/api/ChangesWriteAPI","sap/ui/rta/command/FlexCommand"],function(e,t,o,n){"use strict";const r=n.extend("sap.ui.rta.command.ExtendControllerCommand",{metadata:{library:"sap.ui.rta",properties:{changeType:{type:"string",defaultValue:"codeExt"},codeRef:{type:"string"},viewId:{type:"string"}},associations:{},events:{}}});r.prototype._createChange=function(n){const r=this.getViewId();const a=this.getCodeRef();const s=e.getElementById(r);const l=this.getAppComponent();const c=s.getControllerModuleName()?`module:${s.getControllerModuleName()}`:s.getController()?.getMetadata().getName();const i=t.getFlexReference({element:l});let p=i.replace(/\.Component/g,"").replace(/\./g,"/");p+="/changes/";p+=a.replace(/\.js/g,"");const d={changeType:this.getChangeType(),layer:n.layer,codeRef:this.getCodeRef(),controllerName:c,reference:i,moduleName:p,generator:"sap.ui.rta.command.ExtendControllerCommand"};return o.create({changeSpecificData:d,selector:l})};r.prototype.execute=function(){return Promise.resolve()};r.prototype.undo=function(){return Promise.resolve()};r.prototype.needsReload=true;return r});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/rta/command/FlexCommand", ["sap/base/util/merge","sap/base/util/values","sap/base/Log","sap/ui/core/util/reflection/JsControlTreeModifier","sap/ui/core/Element","sap/ui/fl/apply/api/ControlVariantApplyAPI","sap/ui/fl/write/api/ChangesWriteAPI","sap/ui/fl/Utils","sap/ui/rta/command/BaseCommand","sap/ui/rta/library"],function(e,t,n,r,o,a,i,p,l,s){"use strict";var c=l.extend("sap.ui.rta.command.FlexCommand",{metadata:{library:"sap.ui.rta",properties:{changeType:{type:"string"},jsOnly:{type:"boolean",defaultValue:false},selector:{type:"object"},variantIndependent:{type:"boolean",defaultValue:false}},associations:{},events:{}}});c.prototype.getElementId=function(){var e=this.getElement();return e?e.getId():this.getSelector().id};c.prototype.getAppComponent=function(){var e=this.getElement();return e?p.getAppComponentForControl(e):this.getSelector().appComponent};c.prototype.prepare=async function(e,t,r){try{let n;if(!this.getSelector()&&e&&e.templateSelector){n={id:e.templateSelector,appComponent:this.getAppComponent(),controlType:p.getControlType(o.getElementById(e.templateSelector))};this.setSelector(n)}else if(!this.getSelector()&&this.getElement()){n={id:this.getElement().getId(),appComponent:this.getAppComponent(),controlType:p.getControlType(this.getElement())};this.setSelector(n)}const a=await this._createChange(e,t,r);this._oPreparedChange=a;return true}catch(e){n.error(e.message||e.name);return false}};c.prototype.getPreparedChange=function(){return this._oPreparedChange};c.prototype.execute=function(){var e=this.getPreparedChange();return this._applyChange(e)};c.prototype._getChangeSpecificData=function(){var e=this.getMetadata().getProperties();var n={changeType:this.getChangeType(),content:e.content?.get(this)};t(e).filter(function(e){return e.group==="content"}).forEach(function(e){n.content||={};n.content[e.name]=e.get(this)},this);return n};c.prototype._createChange=function(e,t,n){return this._createChangeFromData(this._getChangeSpecificData(),e,t,n)};c.prototype._createChangeFromData=async function(t,n,o,p){if(n){t=e({},t,n)}t.jsOnly=this.getJsOnly();const l=this.getAppComponent().getModel(a.getVariantModelName());let c;if(l&&o){c=l.getCurrentVariantReference(o)}if(c&&!this.getVariantIndependent()){const e={variantManagementReference:o,variantReference:c,isChangeOnStandardVariant:o===c};t={...t,...e}}t.command=p;t.generator=n.generator||s.GENERATOR_NAME;const g=await i.create({changeSpecificData:t,selector:this._validateControlForChange(n)});if(n&&n.originalSelector){g.addDependentControl(n.originalSelector,"originalSelector",{modifier:r,appComponent:this.getAppComponent()});g.setSelector({...g.getSelector(),...r.getSelector(this.getSelector().id,this.getAppComponent())});g.setContent({...g.getContent(),...n.content})}return g};c.prototype.undo=function(){var e=this.getElement()||r.bySelector(this.getSelector());var t=this.getPreparedChange();return i.revert({change:t,element:e})};c.prototype._applyChange=function(e){var t=this.getAppComponent();var n=r.bySelector(e.getSelector(),t);var o={modifier:r,appComponent:t,view:p.getViewForControl(n)};return i.apply({change:e,element:n,...o}).then(function(e){if(!e.success){return Promise.reject(e.error)}return undefined})};c.prototype._validateControlForChange=function(e){if(e&&e.originalSelector&&e.content&&e.content.boundAggregation){return{id:e.originalSelector,appComponent:this.getAppComponent(),controlType:p.getControlType(o.getElementById(e.originalSelector))}}return this.getElement()||this.getSelector()};return c});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/rta/command/LREPSerializer", ["sap/ui/base/ManagedObject","sap/ui/rta/command/FlexCommand","sap/ui/rta/command/ManifestCommand","sap/ui/fl/Utils","sap/ui/dt/ElementUtil","sap/base/Log","sap/ui/fl/write/api/PersistenceWriteAPI"],function(t,e,n,o,a,s,i){"use strict";const r=t.extend("sap.ui.rta.command.LREPSerializer",{metadata:{library:"sap.ui.rta",associations:{rootControl:{type:"sap.ui.core.Control"}},properties:{commandStack:{type:"object"}},aggregations:{}}});function d(t){return a.getElementInstance(t)}r.prototype._lastPromise=Promise.resolve();r.prototype.setCommandStack=function(t){if(this.getCommandStack()){this.getCommandStack().removeCommandExecutionHandler(this._fnHandleCommandExecuted)}this.setProperty("commandStack",t);t.addCommandExecutionHandler(this._fnHandleCommandExecuted)};r.prototype.init=function(){this._fnHandleCommandExecuted=this.handleCommandExecuted.bind(this)};r.prototype.exit=function(){this.getCommandStack().removeCommandExecutionHandler(this._fnHandleCommandExecuted)};r.prototype._isPersistedChange=function(t){return!!this.getCommandStack()._aPersistedChanges&&this.getCommandStack()._aPersistedChanges.indexOf(t.getId())!==-1};r.prototype.handleCommandExecuted=function(t){return function(t){const o=t;this._lastPromise=this._lastPromise.catch(function(){}).then(function(){const t=this.getCommandStack().getSubCommands(o.command);let a;const s=[];if(o.undo){t.forEach(function(t){if(!(t instanceof e||t instanceof n)||t.getRuntimeOnly()){return}const o=t.getPreparedChange();a=t.getAppComponent();if(a){s.push(o)}});if(a){return i.remove({flexObjects:s,selector:a})}return Promise.resolve()}const r=[];t.forEach(function(t){if(t.getRuntimeOnly()){return}if(t instanceof e){a=t.getAppComponent();if(a){const e=t.getPreparedChange();if(!this._isPersistedChange(e)){s.push(t.getPreparedChange())}}}else if(t instanceof n){r.push(t.createAndStoreChange())}}.bind(this));if(a){i.add({flexObjects:s,selector:a})}return Promise.all(r)}.bind(this));return this._lastPromise}.bind(this)(t)};r.prototype.needsReload=function(){this._lastPromise=this._lastPromise.catch(function(){}).then(function(){const t=this.getCommandStack().getAllExecutedCommands();return t.some(function(t){return!!t.needsReload})}.bind(this));return this._lastPromise};r.prototype.saveCommands=function(t){this._lastPromise=this._lastPromise.catch(function(t){s.error(t)}).then(function(){const e=d(this.getRootControl());if(!e){throw new Error("Can't save commands without root control instance!")}return i.save({selector:e,skipUpdateCache:false,draft:!!t.saveAsDraft,layer:t.layer,removeOtherLayerChanges:!!t.removeOtherLayerChanges,version:t.version,adaptationId:t.adaptationId,condenseAnyLayer:t.condenseAnyLayer})}.bind(this)).then(function(){s.info("UI adaptation successfully wrote changes to the persistence");this.getCommandStack().setSaved(true);this.getCommandStack().removeAllCommands()}.bind(this));return this._lastPromise};r.prototype._triggerUndoChanges=function(t){const e=this.getCommandStack();let n=[];const a=e.getAllExecutedCommands();if(t){a.forEach(function(){n.push(e.undo.bind(e))})}else{a.forEach(function(t){n.push(t.undo.bind(t))});n=n.reverse()}return o.execPromiseQueueSequentially(n,false,true)};r.prototype.clearCommandStack=function(t){const e=this.getCommandStack();if(!t){e.detachCommandExecuted(this.handleCommandExecuted.bind(this))}return this._triggerUndoChanges(t).then(function(){e.removeAllCommands();if(!t){e.attachCommandExecuted(this.handleCommandExecuted.bind(this))}return true}.bind(this))};return r});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/rta/command/LocalReset", ["sap/ui/rta/command/BaseCommand","sap/ui/fl/Utils","sap/ui/fl/write/api/LocalResetAPI"],function(e,t,n){"use strict";var r=e.extend("sap.ui.rta.command.LocalReset",{metadata:{library:"sap.ui.rta",properties:{currentVariant:{type:"string"},changeType:{type:"string"},jsOnly:{type:"boolean"}},associations:{},events:{}}});r.prototype.prepare=function(e){var r=this.getElement();this._oAppComponent=t.getAppComponentForControl(r);this._aAffectedChanges=n.getNestedUIChangesForControl(r,{layer:e.layer,currentVariant:this.getCurrentVariant()});return Promise.resolve(true)};r.prototype.execute=function(){return n.resetChanges(this._aAffectedChanges,this._oAppComponent)};r.prototype.undo=function(){return n.restoreChanges(this._aAffectedChanges,this._oAppComponent)};return r});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/rta/command/ManifestCommand", ["sap/ui/rta/command/BaseCommand","sap/ui/fl/descriptorRelated/api/DescriptorChange","sap/ui/fl/write/api/ChangesWriteAPI"],function(e,t,a){"use strict";const r=e.extend("sap.ui.rta.command.ManifestCommand",{metadata:{library:"sap.ui.rta",properties:{reference:{type:"string"},appComponent:{type:"object"},layer:{type:"string"},changeType:{type:"string"},parameters:{type:"object"},texts:{type:"object"}},events:{}}});r.prototype.needsReload=true;r.prototype.prepare=function(e){this.setLayer(e.layer);return true};r.prototype.getPreparedChange=function(){return this._oPreparedChange};r.prototype.setCompositeId=function(e){this._sCompositeId=e};r.prototype.createAndStoreChange=async function(){const e=await a.create({changeSpecificData:{changeType:this.getChangeType(),content:this.getParameters(),texts:this.getTexts(),support:{compositeCommand:this._sCompositeId||""},reference:this.getReference(),layer:this.getLayer()},selector:this.getAppComponent(),generator:"sap.ui.rta.ManifestCommand"});if(!(e instanceof t)){throw new Error(`With the given changeSpecificData, no manifest change could be created. Provided change content: ${JSON.stringify(this.getParameters())} and change type: ${this.getChangeType()}.`)}const r=e.store();this._oPreparedChange=r};return r});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/rta/command/Move", ["sap/ui/rta/command/FlexCommand"],function(e){"use strict";var t=e.extend("sap.ui.rta.command.Move",{metadata:{library:"sap.ui.rta",properties:{movedElements:{type:"any[]",group:"content"},target:{type:"any",group:"content"},source:{type:"any",group:"content"}},associations:{},events:{}}});t.prototype._getChangeSpecificData=function(){var e=this.getSource();var t=this.getTarget();if(e.parent){e.id=e.parent.getId();delete e.parent}if(t.parent){t.id=t.parent.getId();delete t.parent}var n={changeType:this.getChangeType(),content:{source:e,target:t,movedElements:[]}};this.getMovedElements().forEach(function(e){n.content.movedElements.push({id:e.id||e.element&&e.element.getId(),sourceIndex:e.sourceIndex,targetIndex:e.targetIndex})});return n};return t});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/rta/command/Property", ["sap/ui/rta/command/FlexCommand"],function(e){"use strict";var t=e.extend("sap.ui.rta.command.Property",{metadata:{library:"sap.ui.rta",properties:{propertyName:{type:"string",group:"content"},newValue:{type:"any",group:"content"},semanticMeaning:{type:"string",group:"content"},changeType:{type:"string",defaultValue:"propertyChange"}},associations:{},events:{}}});t.prototype._getChangeSpecificData=function(){var e=this.getElement();return{changeType:this.getChangeType(),selector:{id:e.getId(),type:e.getMetadata().getName()},content:{property:this.getPropertyName(),newValue:this.getNewValue(),semantic:this.getSemanticMeaning()}}};return t});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/rta/command/Remove", ["sap/ui/rta/command/FlexCommand"],function(e){"use strict";var t=e.extend("sap.ui.rta.command.Remove",{metadata:{library:"sap.ui.rta",properties:{removedElement:{type:"any",group:"content"}},associations:{},events:{}}});t.prototype._getChangeSpecificData=function(){var e=this.getRemovedElement()||this.getElement();var t={changeType:this.getChangeType(),removedElement:{id:e.getId()}};return t};return t});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/rta/command/Rename", ["sap/ui/rta/command/FlexCommand"],function(e){"use strict";var t=e.extend("sap.ui.rta.command.Rename",{metadata:{library:"sap.ui.rta",properties:{renamedElement:{type:"object",group:"content"},newValue:{type:"string",defaultValue:"new text",group:"content"}},associations:{},events:{}}});t.prototype._getChangeSpecificData=function(){var e={changeType:this.getChangeType(),content:{renamedElement:{id:this.getRenamedElement().getId()},value:this.getNewValue()}};return e};return t});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/rta/command/Resize", ["sap/ui/rta/command/FlexCommand"],function(e){"use strict";var a=e.extend("sap.ui.rta.command.Resize",{metadata:{library:"sap.ui.rta",properties:{content:{type:"any"},changeType:{type:"string",defaultValue:"resize"}},associations:{},events:{}}});return a});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/rta/command/Reveal", ["sap/ui/rta/command/FlexCommand"],function(e){"use strict";var t=e.extend("sap.ui.rta.command.Reveal",{metadata:{library:"sap.ui.rta",properties:{revealedElementId:{type:"string",group:"content"},directParent:"object"}}});t.prototype._getChangeSpecificData=function(){var e={changeType:this.getChangeType(),content:{}};if(this.getRevealedElementId()){e.content.revealedElementId=this.getRevealedElementId()}return e};return t});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/rta/command/Settings", ["sap/ui/rta/command/FlexCommand"],function(t){"use strict";var e=t.extend("sap.ui.rta.command.Settings",{metadata:{library:"sap.ui.rta",properties:{content:{type:"any"}},associations:{},events:{}}});e.prototype.execute=function(...e){if(this.getElement()){return t.prototype.execute.apply(this,e)}return Promise.resolve()};e.prototype.undo=function(...e){if(this.getElement()){return t.prototype.undo.apply(this,e)}return Promise.resolve()};return e});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/rta/command/Split", ["sap/ui/rta/command/FlexCommand"],function(e){"use strict";var t=e.extend("sap.ui.rta.command.Split",{metadata:{library:"sap.ui.rta",properties:{newElementIds:{type:"string[]",group:"content"},source:{type:"any",group:"content"},parentElement:{type:"any",group:"content"}},associations:{},events:{}}});t.prototype._getChangeSpecificData=function(){var e={changeType:this.getChangeType(),content:{newElementIds:this.getNewElementIds(),sourceControlId:this.getSource().getId(),parentId:this.getParentElement().getId()}};return e};return t});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/rta/command/Stack", ["sap/ui/base/ManagedObject","sap/ui/fl/write/api/PersistenceWriteAPI","sap/ui/fl/Utils","sap/ui/rta/command/Settings","sap/ui/rta/command/CompositeCommand","sap/ui/core/util/reflection/JsControlTreeModifier","sap/ui/rta/util/showMessageBox","sap/ui/core/Lib"],function(e,t,n,o,i,r,a,s){"use strict";function u(e,t,n){var o=e[n];if(o){t.push(o)}return t}function d(e,t,n,a){var s=a.getSelector&&a.getSelector();var u=new o({selector:s,changeType:a.getChangeType(),element:r.bySelector(s,e)});u._oPreparedChange=a;var d=a.getSupportInformation().compositeCommand;if(d){if(!t[d]){t[d]=new i;n.pushExecutedCommand(t[d])}t[d].addCommand(u)}else{n.pushExecutedCommand(u)}}function m(e,t){const n=this.getAllExecutedCommands();e.forEach(e=>{n.some(n=>{const o=n.getPreparedChange?.();if(Array.isArray(o)){return o.some(o=>{if(o.getId()===e.getId()){n.setRelevantForSave(t);return true}return false})}else if(o){if(o.getId()===e.getId()){n.setRelevantForSave(t);return true}return false}return false})})}var c=e.extend("sap.ui.rta.command.Stack",{metadata:{library:"sap.ui.rta",properties:{saved:{type:"boolean",defaultValue:false},lastCommandExecuted:{type:"object",defaultValue:Promise.resolve()}},aggregations:{commands:{type:"sap.ui.rta.command.BaseCommand",multiple:true}},events:{modified:{},commandExecuted:{parameters:{command:{type:"object"},undo:{type:"boolean"}}}}}});c.initializeWithChanges=function(e,o){var i=new c;i._aPersistedChanges=o;if(o&&o.length>0){var r=n.getAppComponentForControl(e);var a={selector:r,invalidateCache:false};return t._getUIChanges(a).then(function(e){var t={};var n={};e.forEach(function(e){n[e.getId()]=e});o.reduce(u.bind(null,n),[]).forEach(d.bind(null,r,t,i));return i})}return Promise.resolve(i)};c.prototype.addCommandExecutionHandler=function(e){this._aCommandExecutionHandler.push(e)};c.prototype.removeCommandExecutionHandler=function(e){var t=this._aCommandExecutionHandler.indexOf(e);if(t>-1){this._aCommandExecutionHandler.splice(t,1)}};c.prototype.init=function(){this._aCommandExecutionHandler=[];this._toBeExecuted=-1};c.prototype._waitForCommandExecutionHandler=function(e){return Promise.all(this._aCommandExecutionHandler.map(function(t){return t(e)}))};c.prototype._getCommandToBeExecuted=function(){return this.getCommands()[this._toBeExecuted]};c.prototype.pushExecutedCommand=function(e){this.push(e,true);this.fireModified()};c.prototype.push=function(e,t){if(this._bUndoneCommands){this._bUndoneCommands=false;while(this._toBeExecuted>-1){this.pop()}}this.insertCommand(e,0);if(!t){this._toBeExecuted++}};c.prototype.top=function(){return this.getCommands()[0]};c.prototype.pop=function(){if(this._toBeExecuted>-1){this._toBeExecuted--}return this.removeCommand(0)};c.prototype.removeCommand=function(e,t){var n=this.removeAggregation("commands",e,t);return n};c.prototype.removeAllCommands=function(e){var t=this.removeAllAggregation("commands",e);this._toBeExecuted=-1;this.fireModified();return t};c.prototype.isEmpty=function(){return this.getCommands().length===0};c.prototype.execute=function(){this.setLastCommandExecuted(this.getLastCommandExecuted().catch(function(){}).then(function(){var e=this._getCommandToBeExecuted();if(e){var t={command:e,undo:false};return e.execute().then(this._waitForCommandExecutionHandler.bind(this,t)).then(function(){this._toBeExecuted--;const n=e.getDiscardedChanges?.();if(n){m.call(this,n,false)}this.fireCommandExecuted(t);this.fireModified()}.bind(this)).catch(function(t){t||=new Error("Executing of the change failed.");t.index=this._toBeExecuted;t.command=this.removeCommand(this._toBeExecuted);this._toBeExecuted--;var n=s.getResourceBundleFor("sap.ui.rta");const o=e.isA("sap.ui.rta.command.AddXMLAtExtensionPoint")?t.message:n.getText("MSG_GENERIC_ERROR_MESSAGE",[t.message]);a(o,{title:n.getText("HEADER_ERROR")},"error");return Promise.reject(t)}.bind(this))}return undefined}.bind(this)));return this.getLastCommandExecuted()};c.prototype._unExecute=function(){if(this.canUndo()){this._bUndoneCommands=true;this._toBeExecuted++;var e=this._getCommandToBeExecuted();const n=e.getDiscardedChanges?.();if(e){var t={command:e,undo:true};return e.undo().then(this._waitForCommandExecutionHandler.bind(this,t)).then(function(){if(n){m.call(this,n,true)}this.fireCommandExecuted(t);this.fireModified()}.bind(this))}return Promise.resolve()}return Promise.resolve()};c.prototype.canUndo=function(){return this._toBeExecuted+1<this.getCommands().length};c.prototype.canSave=function(){return this.canUndo()&&this.getAllExecutedCommands().some(function(e){return e.getRelevantForSave()})};c.prototype.undo=function(){return this._unExecute()};c.prototype.canRedo=function(){return!!this._getCommandToBeExecuted()};c.prototype.redo=function(){return this.execute()};c.prototype.pushAndExecute=function(e){this.push(e);return this.execute()};c.prototype.getAllExecutedCommands=function(){var e=[];var t=this.getCommands();for(var n=t.length-1;n>this._toBeExecuted;n--){var o=this.getSubCommands(t[n]);e=e.concat(o)}return e};c.prototype.getSubCommands=function(e){var t=[];if(e.getCommands){e.getCommands().forEach(function(e){var n=this.getSubCommands(e);t=t.concat(n)},this)}else{t.push(e)}return t};c.prototype.compositeLastTwoCommands=function(){var e=this.pop();var t=this.pop();var n=new i;n.addCommand(t);n.addCommand(e);this.push(n)};return c});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/rta/command/compVariant/CompVariantContent", ["sap/ui/rta/command/BaseCommand","sap/ui/fl/write/api/SmartVariantManagementWriteAPI","sap/ui/rta/library"],function(t,e,r){"use strict";var i=t.extend("sap.ui.rta.command.compVariant.CompVariantContent",{metadata:{library:"sap.ui.rta",properties:{variantId:{type:"string"},persistencyKey:{type:"string"},newContent:{type:"object"},isModifiedBefore:{type:"boolean"}}}});function n(t,r,i){var n={...i,...this.mInformation,id:r,control:this.getElement()};return e[t](n)}function a(t){var e=this.getElement();var r=e._getVariantContent(this.getVariantId());var i={...r};if(e.isPageVariant()){var n={};n[this.getPersistencyKey()]=t;e._applyVariantByPersistencyKey(this.getPersistencyKey(),n,"KEY_USER");i[this.getPersistencyKey()]=t}else{e._applyVariant(e._getPersoController(),t,"KEY_USER");i=t}return i}i.prototype.prepare=function(t,e,i){this.mInformation={layer:t.layer,command:i,generator:r.GENERATOR_NAME};return true};i.prototype.execute=function(){this.getElement().setModified(true);var t=a.call(this,this.getNewContent());n.call(this,"updateVariantContent",this.getVariantId(),{content:t});return Promise.resolve()};i.prototype.undo=function(){var t=n.call(this,"revert",this.getVariantId(),{});this.getElement().setModified(this.getIsModifiedBefore());var e=this.getElement();if(e.isPageVariant()){a.call(this,t.getContent()[this.getPersistencyKey()])}else{a.call(this,t.getContent())}return Promise.resolve()};return i});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/rta/command/compVariant/CompVariantSaveAs", ["sap/ui/fl/write/api/SmartVariantManagementWriteAPI","sap/ui/rta/command/BaseCommand","sap/ui/rta/library"],function(t,e,a){"use strict";var i=e.extend("sap.ui.rta.command.compVariant.CompVariantSaveAs",{metadata:{library:"sap.ui.rta",properties:{newVariantProperties:{type:"object"},previousDirtyFlag:{type:"boolean"},previousVariantId:{type:"string"},previousDefault:{type:"string"},activateAfterUndo:{type:"boolean"}}}});i.prototype.prepare=function(t,e,i){this.mInformation={layer:t.layer,command:i,generator:a.GENERATOR_NAME};return true};i.prototype.getPreparedChange=function(){return this._oVariant};i.prototype.execute=function(){var e=this.getNewVariantProperties();var a={changeSpecificData:{id:this._oVariant?this._oVariant.getVariantId():undefined,type:e.type,texts:{variantName:e.text},content:e.content,executeOnSelection:e.executeOnSelection,favorite:true,contexts:e.contexts,layer:this.mInformation.layer},control:this.getElement(),command:this.mInformation.command,generator:this.mInformation.generator};this._oVariant=t.addVariant(a);if(e.default){t.setDefaultVariantId({...this.mInformation,control:this.getElement(),defaultVariantId:this._oVariant.getVariantId()})}this.getElement().addVariant(this._oVariant,e.default);this.getElement().activateVariant(this._oVariant.getVariantId());return Promise.resolve()};i.prototype.undo=function(){t.removeVariant({id:this._oVariant.getVariantId(),control:this.getElement(),revert:true});if(this.getNewVariantProperties().default){t.setDefaultVariantId({...this.mInformation,control:this.getElement(),defaultVariantId:this.getPreviousDefault()})}this.getElement().removeWeakVariant({previousDirtyFlag:this.getPreviousDirtyFlag(),previousVariantId:this.getPreviousVariantId(),previousDefault:this.getPreviousDefault(),variantId:this._oVariant.getVariantId()});if(this.getElement().getCurrentVariantId()!==""){this.getElement()._getVariantById(this.getPreviousVariantId()).setContent(this.getNewVariantProperties().content)}if(this.getActivateAfterUndo()){this.getElement().activateVariant(this.getPreviousVariantId())}if(this.getElement().getCurrentVariantId()!==""){this.getElement().setModified(this.getPreviousDirtyFlag())}return Promise.resolve()};return i});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/rta/command/compVariant/CompVariantSwitch", ["sap/ui/rta/command/BaseCommand","sap/ui/fl/write/api/SmartVariantManagementWriteAPI"],function(t,e){"use strict";var a=t.extend("sap.ui.rta.command.compVariant.CompVariantSwitch",{metadata:{library:"sap.ui.rta",properties:{sourceVariantId:{type:"string"},targetVariantId:{type:"string"},discardVariantContent:{type:"boolean"}}},constructor:function(...e){t.apply(this,e);this.setRelevantForSave(false)}});a.prototype.execute=function(){this.getElement().activateVariant(this.getTargetVariantId());if(this.getDiscardVariantContent()){this.getElement().setModified(false);e.discardVariantContent({control:this.getElement(),id:this.getSourceVariantId()})}return Promise.resolve()};a.prototype.undo=function(){if(this.getDiscardVariantContent()){e.revert({control:this.getElement(),id:this.getSourceVariantId()})}this.getElement().activateVariant(this.getSourceVariantId());if(this.getDiscardVariantContent()){this.getElement().setModified(true)}return Promise.resolve()};return a});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/rta/command/compVariant/CompVariantUpdate", ["sap/base/util/each","sap/ui/fl/write/api/SmartVariantManagementWriteAPI","sap/ui/rta/command/BaseCommand","sap/ui/rta/library"],function(t,e,a,i){"use strict";var r=a.extend("sap.ui.rta.command.compVariant.CompVariantUpdate",{metadata:{library:"sap.ui.rta",properties:{newVariantProperties:{type:"object"},newDefaultVariantId:{type:"string"},oldDefaultVariantId:{type:"string"},oldSelectedVariantId:{type:"string"},onlySave:{type:"boolean"},isModifiedBefore:{type:"boolean"}}}});r.prototype.prepare=function(t,e,a){this.mInformation={layer:t.layer,command:a,generator:i.GENERATOR_NAME};return true};function n(t,a,i){var r={...i,...this.mInformation,id:a,control:this.getElement()};return e[t](r)}r.prototype.execute=function(){if(this.getOnlySave()){this.setIsModifiedBefore(this.getElement().getModified());this.getElement().setModified(false);var e=Object.keys(this.getNewVariantProperties())[0];n.call(this,"saveVariantContent",e,this.getNewVariantProperties()[e])}else{t(this.getNewVariantProperties(),function(t,e){if(e.deleted){n.call(this,"removeVariant",t,{});this.getElement().removeVariant({variantId:t});if(this.getElement().getCurrentVariantId()===t){this.getElement().activateVariant("*standard*")}}else{var a=n.call(this,"updateVariantMetadata",t,e);this.getElement().updateVariant(a)}}.bind(this));if(this.getNewDefaultVariantId()){n.call(this,"setDefaultVariantId",undefined,{defaultVariantId:this.getNewDefaultVariantId()});this.getElement().setDefaultVariantId(this.getNewDefaultVariantId())}}return Promise.resolve()};r.prototype.undo=function(){if(this.getOnlySave()){var e=Object.keys(this.getNewVariantProperties())[0];n.call(this,"revert",e,{});this.getElement().setModified(this.getIsModifiedBefore())}else{t(this.getNewVariantProperties(),function(t,e){var a=n.call(this,"revert",t,{});if(e.deleted){this.getElement().addVariant(a);if(this.getOldSelectedVariantId()===t){this.getElement().activateVariant(t)}}else{this.getElement().updateVariant(a)}}.bind(this));if(this.getNewDefaultVariantId()){n.call(this,"revertSetDefaultVariantId",this.getOldDefaultVariantId());this.getElement().setDefaultVariantId(this.getOldDefaultVariantId())}}return Promise.resolve()};return r});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/rta/command/manifest/AddLibrary", ["sap/ui/core/Lib","sap/ui/rta/command/ManifestCommand"],function(e,t){"use strict";const a=t.extend("sap.ui.rta.command.manifest.AddLibrary",{metadata:{library:"sap.ui.rta",events:{}}});a.prototype.init=function(){this.setChangeType("appdescr_ui5_addLibraries")};a.prototype.execute=function(){const t=[];if(this.getParameters().libraries){const a=Object.keys(this.getParameters().libraries);a.forEach(function(a){t.push(e.load({name:a}))})}return Promise.all(t)};return a},true);
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/rta/enablement/TestDelegate", ["sap/base/util/isPlainObject","sap/base/util/merge"],function(e,r){"use strict";function t(e,r){return e[r]&&typeof e[r]==="string"}function n(r){if(!r.appComponent.isA("sap.ui.core.Component")){return false}if(!e(r.modifier)){return false}if(r.modifier.targets==="xmlTree"&&!t(r.view,"nodeName")){return false}if(r.payload&&!e(r.payload)){return false}return["aggregationName","bindingPath"].every(t.bind(null,r))}var o={getPropertyInfo(e){return Promise.resolve().then(function(){var r=e.element.isA("sap.ui.core.Element")&&e.aggregationName&&typeof e.aggregationName==="string"&&(!e.payload||typeof e.payload==="object");if(r){return[]}return undefined})},createLabel(e){return Promise.resolve().then(function(){var r=n(e)&&t(e,"labelFor");if(r){return e.modifier.createControl("sap.m.Label",e.appComponent,e.view,`${e.labelFor}-label`,{labelFor:e.labelFor,text:e.bindingPath},true)}return undefined})},createControlForProperty(o){return Promise.resolve().then(function(){var a=n(o)&&(t(o.element,"nodeName")||o.element.isA("sap.ui.core.Element"))&&e(o.fieldSelector)&&t(o.fieldSelector,"id");if(a){var i=[o.modifier.createControl("sap.m.Text",o.appComponent,o.view,o.fieldSelector,{text:`{${o.bindingPath}}`})];if(o.payload.valueHelpId){var l=r({},o.fieldSelector,{id:`${o.fieldSelector.id}-${o.payload.valueHelpId}`});i.push(o.modifier.createControl("sap.ui.core.Element",o.appComponent,o.view,l,true))}return Promise.all(i).then(function(e){return{control:e[0],valueHelp:e[1]}})}return undefined})},createLayout(e){var t=n(e)&&e.fieldSelector&&typeof e.fieldSelector==="object"&&typeof e.fieldSelector.id==="string";if(t){if(!e.payload.useCreateLayout){return Promise.resolve()}var a;var i;var l;var u=r({},e);var f=u.modifier;u.fieldSelector.id+="-field";return o.createControlForProperty(u).then(function(r){l=r;i=l.valueHelp;return f.createControl(u.payload.layoutType,u.appComponent,u.view,e.fieldSelector)}).then(function(e){a=e;return f.insertAggregation(a,u.payload.aggregation,l.control,0,u.view)}).then(function(){if(u.payload.labelAggregation){var e={labelFor:f.getId(l.control),...u};return o.createLabel(e)}return undefined}).then(function(e){if(e){return f.insertAggregation(a,u.payload.labelAggregation,e,0,u.view)}return undefined}).then(function(){return{control:a,valueHelp:i}})}return undefined}};return o});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/rta/enablement/elementActionTest", ["sap/ui/core/mvc/XMLView","sap/ui/core/ComponentContainer","sap/ui/core/UIComponent","sap/ui/core/util/reflection/JsControlTreeModifier","sap/ui/dt/DesignTime","sap/ui/dt/DesignTimeStatus","sap/ui/dt/OverlayRegistry","sap/ui/fl/apply/_internal/changes/Utils","sap/ui/fl/changeHandler/condenser/Classification","sap/ui/fl/write/api/PersistenceWriteAPI","sap/ui/fl/Layer","sap/ui/model/Model","sap/ui/rta/command/CommandFactory","sap/ui/rta/util/changeVisualization/ChangeCategories","sap/ui/rta/util/changeVisualization/ChangeVisualization","sap/ui/qunit/utils/nextUIUpdate","sap/ui/thirdparty/sinon-4","test-resources/sap/ui/fl/api/FlexTestAPI","test-resources/sap/ui/fl/qunit/FlQUnitUtils","sap/ui/fl/library"],function(e,t,n,i,a,o,s,r,c,l,h,d,m,u,g,f,p,C,w){"use strict";function y(v,b){if(y._only&&v.indexOf(y._only)<0){return}if(typeof b.xmlView==="string"){b.xmlView={viewContent:b.xmlView}}const A=p.createSandbox();b.before||=function(){};b.after||=function(){};QUnit.module(v,function(){QUnit.test("When using the 'elementActionTest' function to test if your control is ready for UI adaptation at runtime",function(e){e.ok(b.afterAction,"then you implement a function to check if your action has been successful: See the afterAction parameter.");e.ok(b.afterUndo,"then you implement a function to check if the undo has been successful: See the afterUndo parameter.");e.ok(b.afterRedo,"then you implement a function to check if the redo has been successful: See the afterRedo parameter.");e.ok(b.xmlView,"then you provide an XML view to test on: See the.xmlView parameter.");const t=(new DOMParser).parseFromString(b.xmlView.viewContent,"application/xml").documentElement;e.ok(t.tagName.match("View$"),"then you use the sap.ui.core.mvc View tag as the first tag in your view");e.ok(b.action,"then you provide an action: See the action parameter.");e.ok(b.action.name,"then you provide an action name: See the action.name parameter.");e.ok(b.action.controlId||b.action.control,"then you provide the control or control's id to operate the action on: See the action.controlId.")})});const U="sap.ui.rta.control.enabling.comp";const V=false;const x=true;const I=n.extend(U,{metadata:{interfaces:["sap.ui.core.IAsyncContentCreation"],manifest:{"sap.app":{id:U,type:"application"}}},createContent(){const t={...b.xmlView};t.id=this.createId("view");if(t.async===undefined){t.async=this.getComponentData().async}t.definition=t.viewContent;this.oViewPromise=e.create(t);return this.oViewPromise}});function k(e){this.oUiComponent=new I({id:"comp",componentData:{async:e}});return this.oUiComponent.oViewPromise.then(async function(){this.oUiComponentContainer=new t({component:this.oUiComponent,height:"100%"});this.oUiComponentContainer.placeAt(b.placeAt||"qunit-fixture");this.oView=this.oUiComponent.getRootControl();if(b.model instanceof d){this.oView.setModel(b.model)}await f();return b.model&&b.model.getMetaModel()&&b.model.getMetaModel().loaded()}.bind(this))}function D(e,t){const n=[].concat(b.previousActions||[],b.action);const i=[];async function a(n,a){const o=await R.call(this,e,n);i.push(o);await o.execute();if(a&&t?.relevantForDuplicateChangeCheck&&await $.call(this,o,n)){await X(this.oDesignTime);t.duplicateChangeCheckActive=true;const a=await R.call(this,e,n);i.push(a);try{await a.execute()}catch(t){e.strictEqual(a.getPreparedChange()?.hasApplyProcessFailed(),true,`then on second application of the same action returns the following error message: ${t.message||t}`)}}await X(this.oDesignTime)}return n.reduce(function(e,t,i){return e.then(a.bind(this,t,i===n.length-1))}.bind(this),Promise.resolve()).then(function(){return i})}function P(e){if(typeof e.control==="function"){return e.control(this.oView)}return this.oView.byId(e.controlId)}function E(e){return e.designtimeActionControl?e.designtimeActionControl(this.oView):undefined}function T(){this.oDesignTime=new a({rootElements:[this.oView]});return new Promise(function(e){this.oDesignTime.attachEventOnce("synced",e)}.bind(this))}function M(e){if(e){return typeof e==="function"?e(this.oView):e}return{}}function S(e,t,n,i,a,o){if(Array.isArray(t.name)){const i=a.getAction(t.name[0],n,t.name[1]);e.ok(i,`the ${t[0]} via ${t.name[1]} action is available in the designtime`)}else if(t.name==="createContainer"||t.name==="addIFrame"){e.ok(o.getAction(t.name,n),`the ${t.name} action is available in the calculated designtime metadata during execution`)}else if(t.name==="move"){e.ok(a.getAction(t.name,i),`the ${t.name} action is available in the calculated designtime metadata during execution`)}else{e.ok(a.getAction(t.name,n),`the ${t.name} action is available in the calculated designtime metadata during execution`)}}async function R(e,t){try{let n=t.name;let i;let a;let o=await P.call(this,t);const r=M.call(this,t.parameter);const c=await E.call(this,t);await T.call(this);let l=s.getOverlay(c||o);if(!l){throw new Error(`The provided control ${o.getId()}does not have any overlay existing during test execution. `+"With this testsetup it is no possible to check for designtime action definition. In some cases it is not "+"possible to identify the control with the designtime metadata automatically just by the given 'action.control'. "+"In this case please provide the 'action.designtimeActionControl' property with a valid control containing "+"the designtime metadata definition for this check.")}let d=l.getDesignTimeMetadata();const u=d.getResponsibleElement(o);if(b.label){e.strictEqual(d.getLabel(o),b.label,"then the control label is correct")}if(t.name==="move"){a=r.movedElements[0].element||r.movedElements[0].id;const e=s.getOverlay(a);const t=e.getRelevantContainer();o=t;d=e.getParentAggregationOverlay().getDesignTimeMetadata()}else if(Array.isArray(t.name)){const e=d.getActionDataFromAggregations(t.name[0],o,undefined,t.name[1]);const i=l.getAggregationOverlay(e[0].aggregation);d=i.getDesignTimeMetadata();n="addDelegateProperty"}else if(t.name==="createContainer"||t.name==="addIFrame"){const e=d.getActionDataFromAggregations(t.name,c||o);const n=l.getAggregationOverlay(e[0].aggregation);i=n.getDesignTimeMetadata()}else if(u){if(t.name==="reveal"){o=t.revealedElement(this.oView);l=s.getOverlay(t.revealedElement(this.oView));d=l.getDesignTimeMetadata();if(t.label){const n=d.getAction("reveal");e.strictEqual(n.getLabel(o),t.label,"then the control label is correct")}}else{o=u;l=s.getOverlay(o);d=l.getDesignTimeMetadata();o.getMetadata().loadDesignTime(o)}}S(e,t,o,a,d,i);const g=new m({flexSettings:{layer:b.layer||h.CUSTOMER}});const f=await g.getCommandFor(o,n,r,d);e.ok(f,"then the registration for action to change type, the registration for change and "+`control type to change handler is available and ${b.action.name} is a valid action`);return f}catch(e){throw new Error(e)}}function O(e){return e.reduce(function(e,t){return e.then(t.execute.bind(t))},Promise.resolve())}function F(e){const t=e.slice().reverse();return t.reduce(function(e,t){return e.then(t.undo.bind(t))},Promise.resolve())}async function W(e,t){if(t?.duplicateChangeCheckActive){const t=e[e.length-1];await t.undo()}}function z(e){e.forEach(e=>{e.destroy()})}async function Q(e,t,n){const i={remainingCommands:[],deletedCommands:[]};if(t.length===1){i.remainingCommands.push(t[0]);return Promise.resolve(i)}const a=t.map(e=>e.getPreparedChange());const o=await l._condense({selector:e,changes:a});if(b.changesAfterCondensing!==undefined){n.equal(o.length,b.changesAfterCondensing,"after condensing the amount of changes is correct")}const s=o.map(e=>e.getId());t.forEach(e=>{if(s.indexOf(e.getPreparedChange().getId())>-1){i.remainingCommands.push(e)}else{i.deletedCommands.push(e)}});return i}async function q(e,t,n){if(!b.changeVisualization){return}let i;if(typeof b.changeVisualization==="function"){i=b.changeVisualization(e)}else{i=b.changeVisualization}const a=new g({rootControlId:e.getId(),isActive:true});A.stub(a,"_updateChangeIndicators");const o=t.map(e=>e.getPreparedChange());A.stub(a,"_collectChanges").resolves(o);await a._updateChangeRegistry();await a._selectChangeCategory(u.ALL);const s=a._oChangeIndicatorRegistry;const r=s.getSelectorsWithRegisteredChanges();const c=i.displayElementId;const l=c?e.createId(c):e.getId();n.ok(r[l]&&r[l].length,"there is a change indicator at the correct element");const h=s.getAllRegisteredChanges();const d=o[o.length-1];const m=h.find(e=>e.change.getId()===d.getId());const f=i.info;function p(t){return t.map(t=>e.createId(t))}if(f){if(f.affectedControls){const e=p(f.affectedControls);n.deepEqual(e,m.visualizationInfo.affectedElementIds,"then the affected control ids are correct")}if(f.dependentControls){const e=p(f.dependentControls);n.deepEqual(e,m.visualizationInfo.dependentElementIds,"then the dependent control ids are correct")}if(f.displayControls){const e=p(f.displayControls);n.deepEqual(e,m.visualizationInfo.displayElementIds,"then the display control ids are correct")}if(f.descriptionPayload){n.deepEqual(f.descriptionPayload,m.visualizationInfo.descriptionPayload,"then the descriptionPayload is correct")}}}function L(e){const t=[];e.forEach(function(e){const n=e.getPreparedChange();if(e.getAppComponent){t.push(l.remove({change:n,selector:e.getAppComponent()}))}});return Promise.all(t)}async function $(e,t){let n;const a=await P.call(this,t);const o=e.getPreparedChange();o.setRevertData(o.getRevertData()||{});try{const t=await r.getChangeHandler({flexObject:o,control:a,controlType:a.getMetadata().getName(),modifier:i});if(t&&typeof t.getCondenserInfo==="function"){n=await t.getCondenserInfo(o,{modifier:i,appComponent:e.getAppComponent()})}return n?.classification===c.Create}catch(e){return false}}async function _(e,t){await k.call(this,V);await j.call(this,e,t)}function j(e,t){const n=[].concat(b.previousActions||[],b.action);const i=[];let a;async function o(n,o){const s=await R.call(this,e,n);i.push(s);a=s.getAppComponent();let r;if(o&&t?.relevantForDuplicateChangeCheck&&await $.call(this,s,n)){t.duplicateChangeCheckActive=true;r=await R.call(this,e,n);i.push(r)}this.oUiComponentContainer.destroy();l.add({change:s.getPreparedChange(),selector:a});if(r){l.add({change:r.getPreparedChange(),selector:a})}return await k.call(this,x)}return n.reduce(function(e,t,i){return e.then(o.bind(this,t,i===n.length-1))}.bind(this),Promise.resolve()).then(function(){this.aCommands=i;const e=i.map(e=>e.getPreparedChange());return l.remove({flexObjects:e,selector:a})}.bind(this))}if(!b.jsOnly){QUnit.module(`${v} on async views`,{before(e){this.hookContext={};return b.before.call(this.hookContext,e)},after(e){return b.after.call(this.hookContext,e)},async beforeEach(){await w.initializeFlexStateWithData(A,U,{changes:[]})},afterEach(){this.oUiComponentContainer.destroy();this.oDesignTime.destroy();z(this.aCommands);C.reset();A.restore()}},function(){QUnit.test("When applying the change directly on the XMLView",async function(e){await _.call(this,e);await q(this.oView,this.aCommands,e);await b.afterAction(this.oUiComponent,this.oView,e)});QUnit.test("When executing on XML and reverting the change in JS (e.g. variant switch)",async function(e){await _.call(this,e);await F(this.aCommands);await L(this.aCommands);await f();await b.afterUndo(this.oUiComponent,this.oView,e)});QUnit.test("When executing on XML, reverting the change in JS (e.g. variant switch) and applying again",async function(e){await _.call(this,e);const t=await Q(this.oView,this.aCommands,e);this.aRemainingCommands=t.remainingCommands;await F(this.aCommands);await L(this.aCommands);await O(this.aRemainingCommands);await f();await b.afterRedo(this.oUiComponent,this.oView,e)});QUnit.test("When executing on XML and applying the create change twice (check for duplicate change errors) and reverting just one change in JS",async function(e){const t={relevantForDuplicateChangeCheck:true};await _.call(this,e,t);await W(this.aCommands,t);await L(this.aCommands);f();await b.afterAction(this.oUiComponent,this.oView,e)})})}function X(e){if(e.getStatus()!==o.SYNCED){return new Promise(function(t){e.attachEventOnce("synced",t)})}return Promise.resolve()}QUnit.module(v,{before(e){this.hookContext={};return b.before.call(this.hookContext,e)},after(e){return b.after.call(this.hookContext,e)},async beforeEach(e){await w.initializeFlexStateWithData(A,U,{changes:[]});return k.call(this,V).then(D.bind(this,e)).then(function(e){this.aCommands=e}.bind(this))},afterEach(){this.oDesignTime.destroy();this.oUiComponentContainer.destroy();z(this.aCommands);C.reset();A.restore()}},function(){QUnit.test("When executing the underlying command on the control at runtime",async function(e){await X(this.oDesignTime);await q(this.oView,this.aCommands,e);await f();await b.afterAction(this.oUiComponent,this.oView,e)});QUnit.test("When executing and undoing the command",async function(e){await X(this.oDesignTime);await F(this.aCommands);await L(this.aCommands);await f();await b.afterUndo(this.oUiComponent,this.oView,e)});QUnit.test("When executing, undoing and redoing the command",async function(e){await X(this.oDesignTime);const t=await Q(this.oView,this.aCommands,e);this.aRemainingCommands=t.remainingCommands;await F(this.aCommands);await L(this.aCommands);await O(this.aRemainingCommands);await f();await b.afterRedo(this.oUiComponent,this.oView,e)});QUnit.test("When executing and applying the create change twice (check for duplicate change errors) and undoing just one command",async function(e){this.oUiComponentContainer.destroy();await k.call(this,V);const t={relevantForDuplicateChangeCheck:true};const n=await D.call(this,e,t);this.aCommands=n;await X(this.oDesignTime);await W(this.aCommands,t);await L(this.aCommands);f();await b.afterAction(this.oUiComponent,this.oView,e)})})}y.skip=function(){};y.only=function(e){y._only=e};return y});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/rta/library", ["sap/ui/core/Lib","sap/ui/core/library","sap/m/library","sap/ui/fl/library","sap/ui/dt/library"],function(i){"use strict";var a=i.init({name:"sap.ui.rta",apiVersion:2,version:"1.136.0",dependencies:["sap.ui.core","sap.m","sap.ui.fl","sap.ui.dt"],types:[],interfaces:[],controls:[],elements:[]});a.GENERATOR_NAME="sap.ui.rta.command";return a});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/rta/plugin/AddXMLAtExtensionPoint", ["sap/ui/rta/plugin/Plugin","sap/ui/dt/Util","sap/ui/fl/Utils","sap/ui/fl/apply/api/ExtensionPointRegistryAPI","sap/ui/fl/apply/_internal/flexState/ManifestUtils","sap/base/util/values","sap/ui/base/DesignTime"],function(t,n,e,i,o,r,a){"use strict";const s=t.extend("sap.ui.rta.plugin.AddXMLAtExtensionPoint",{metadata:{library:"sap.ui.rta",properties:{fragmentHandler:{type:"function"}},associations:{},events:{}}});const u="addXMLAtExtensionPoint";const c="appdescr_ui5_setFlexExtensionPointEnabled";function l(t){const n=t.getId();const e=i.getExtensionPointInfoByParentId({parentId:n});return e.length?e:r(i.getExtensionPointInfoByViewId({viewId:n}))}function d(t){return l(t).length>0}function f(){return a.isDesignModeEnabled()}function m(t){const n=l(t.getElement())[0]?.view;return n&&e.checkControlId(n)}s.prototype.bManifestCommandAlreadyAvailable=false;s.prototype._isEditable=function(t){if(f()){const n=t.getElement();return this.hasChangeHandler(u,n).then(function(e){return e&&d(n)&&m(t)})}return Promise.resolve(false)};s.prototype.isEnabled=function(t){const n=t.length===1;return n&&!!m(t[0])};s.prototype.isAvailable=function(t){if(f()){const n=t[0].getElement();return d(n)}return false};function p(t,n,i){const o=n.extensionPointName;const r=e.getViewForControl(t);const a={name:o,view:r};const s={fragment:n.fragment,fragmentPath:n.fragmentPath};return this.getCommandFactory().getCommandFor(a,u,s).then(function(t){return i.addCommand(t)})}function g(t,n){const i=o.isFlexExtensionPointHandlingEnabled(t);if(i||this.bManifestCommandAlreadyAvailable){return Promise.resolve()}const r=e.getAppComponentForControl(t);const a=r.getManifestEntry("sap.app").id;return this.getCommandFactory().getCommandFor(t,"manifest",{reference:a,appComponent:r,changeType:c,parameters:{flexExtensionPointEnabled:true},texts:{}}).then(function(t){this.bManifestCommandAlreadyAvailable=true;return n.addCommand(t)}.bind(this))}function h(t,n){let e;const i=t[0];const o=i.getElement();return this.getCommandFactory().getCommandFor(o,"composite").then(function(t){e=t}).then(function(){return p.call(this,o,n,e)}.bind(this)).then(function(){return g.call(this,o,e)}.bind(this)).then(function(){return e})}s.prototype.handler=function(t,e){return Promise.resolve().then(function(){const n=e.fragmentHandler||this.getFragmentHandler();if(!n){return Promise.reject("Fragment handler function is not available in the handler")}const i=t[0];const o=i.getElement();const r=l(o);return n(i,r)}.bind(this)).then(function(t){if(!t.extensionPointName||!(typeof t.extensionPointName==="string")){return Promise.reject("Extension point name is not selected!")}if(!t.fragmentPath||!(typeof t.fragmentPath==="string")){return Promise.reject("Fragment path is not available")}return t}).then(function(n){return h.call(this,t,n)}.bind(this)).then(function(t){this.fireElementModified({command:t})}.bind(this)).catch(function(t){throw n.propagateError(t,"AddXMLAtExtensionPoint#handler","Error occurred in AddXMLAtExtensionPoint handler function","sap.ui.rta")})};s.prototype.getMenuItems=function(t){return this._getMenuItems(t,{pluginId:"CTX_ADDXML_AT_EXTENSIONPOINT",icon:"sap-icon://add-equipment"})};s.prototype.getActionName=function(){return"AddXMLAtExtensionPoint"};s.prototype.getAction=function(){return{changeType:u}};return s});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/rta/plugin/AddXMLPlugin", ["sap/ui/core/Lib","sap/ui/dt/Util","sap/ui/rta/plugin/Plugin"],function(t,e,n){"use strict";const a=n.extend("sap.ui.rta.plugin.AddXML",{metadata:{library:"sap.ui.rta",properties:{fragmentHandler:{type:"function"}},associations:{},events:{}}});const o="addXML";a.prototype._isEditable=async function(t){const e=this.getAction(t);if(e===null){return Promise.resolve(false)}const n=await this.hasChangeHandler(o,t.getElement());return n};a.prototype.isEnabled=function(t){const e=t.length===1&&!this.isInReuseComponentOnS4HanaCloud(t[0])&&this.hasStableId(t[0]);return e};a.prototype.getActionText=function(e,n,a){const o=n.name;const i=e.getElement();let r;if(o){if(typeof o==="function"){return o(i)}r=e.getDesignTimeMetadata()?e.getDesignTimeMetadata().getLibraryText(i,o):""}else{r=t.getResourceBundleFor("sap.ui.rta").getText(a)}if(this.isInReuseComponentOnS4HanaCloud(e)){r+=` (${t.getResourceBundleFor("sap.ui.rta").getText("CTX_DISABLED_REUSE")})`}else if(!this.hasStableId(e)){r+=` (${t.getResourceBundleFor("sap.ui.rta").getText("CTX_DISABLED_NO_STABLE_ID")})`}return r};a.prototype.handler=async function(t,n){try{const e=n.fragmentHandler||this.getFragmentHandler();if(!e){throw Error("Fragment handler function is not available in the handler")}const a=t[0];const i=this.getAction(a)?.excludedAggregations||[];const r=await e(a,i);const s=await this.getCommandFactory().getCommandFor(a.getElement(),o,r);this.fireElementModified({command:s})}catch(t){throw e.propagateError(t,"AddXML#handler","Error occurred in AddXML handler function","sap.ui.rta")}};a.prototype.getMenuItems=function(t){return this._getMenuItems(t,{pluginId:"CTX_ADDXML",icon:"sap-icon://attachment-html"})};a.prototype.getActionName=function(){return"addXML"};a.prototype.getAction=function(t){const e=n.prototype.getAction.apply(this,[t]);return e||{changeType:o}};return a});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/rta/plugin/BaseCreate", ["sap/ui/core/Lib","sap/ui/rta/plugin/Plugin","sap/ui/fl/Utils","sap/ui/rta/Utils"],function(e,t,r,n){"use strict";var a=t.extend("sap.ui.rta.plugin.BaseCreate",{metadata:{library:"sap.ui.rta",properties:{},associations:{},events:{}}});a.prototype._isEditable=function(e){return Promise.all([this._isEditableCheck(e,true),this._isEditableCheck(e,false)]).then(function(e){return{asSibling:e[0],asChild:e[1]}})};a.prototype._isEditableCheck=function(e,t){var n=this._getParentOverlay(t,e);var a;if(!n||!n.getParentElementOverlay()){return Promise.resolve(false)}if(t){a=e.getParentAggregationOverlay().getAggregationName()}return this.checkAggregationsOnSelf(n,this.getActionName(),a).then(function(t){if(t){var a=r.getViewForControl(n.getElement());return this.hasStableId(e)&&r.checkControlId(a)}return false}.bind(this))};a.prototype._getParentOverlay=function(e,t){var r;var n=this.getResponsibleElementOverlay(t);if(e){r=n.getParentElementOverlay()}else{r=n}return r};a.prototype.getCreateActions=function(e,t){var r=this.getResponsibleElementOverlay(t);var n=this._getParentOverlay(e,r);var a=n.getDesignTimeMetadata();var i=a.getActionDataFromAggregations(this.getActionName(),r.getElement());if(e){var o=r.getParentAggregationOverlay().getAggregationName();return i.filter(function(e){return e.aggregation===o})}return i};a.prototype.getCreateAction=function(e,t,r){var n=this.getCreateActions(e,t);if(r){var a;n.some(function(e){if(e.aggregation===r){a=e;return true}});return a}return n[0]};a.prototype.isAvailable=function(e,t){return this._isEditableByPlugin(e[0],t)};a.prototype.isActionEnabled=function(e,t,r){if(!e){return false}if(e.isEnabled&&typeof e.isEnabled==="function"){var n=e.isEnabled;var a=this._getParentOverlay(t,r);return n(a.getElement())}return true};a.prototype.getCreatedContainerId=function(e,t){var r=t;if(e.getCreatedContainerId&&typeof e.getCreatedContainerId==="function"){var n=e.getCreatedContainerId;r=n(t)}return r};a.prototype._determineIndex=function(e,t,r,a){return n.getIndex(e,t,r,a)};a.prototype._getText=function(t,r,n,a){if(!t){return a}var i=n.getAggregationDescription(t.aggregation,r);if(!i){return a}var o=i.singular;var g=e.getResourceBundleFor("sap.ui.rta");return g.getText(a,[o])};a.prototype.getActionName=function(){throw new Error("abstract")};function i(){}a.prototype.getMenuItems=function(e){i(e);throw new Error("abstract")};a.prototype.handleCreate=function(e,t){i(e,t);throw new Error("abstract")};return a});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/rta/plugin/Combine", ["sap/ui/rta/plugin/Plugin","sap/ui/rta/Utils","sap/ui/fl/Utils","sap/ui/dt/Util","sap/base/util/uid"],function(e,t,n,i,r){"use strict";var a=e.extend("sap.ui.rta.plugin.Combine",{metadata:{library:"sap.ui.rta",properties:{},associations:{},events:{}}});a.prototype._isEditable=function(e){var t=this.getAction(e);if(!e.isRoot()&&t&&t.changeOnRelevantContainer){return this._checkChangeHandlerAndStableId(e)}return Promise.resolve(false)};a.prototype._checkForSameRelevantContainer=function(e){var t=[];for(var n=0,i=e.length;n<i;n++){t[n]=e[n].getRelevantContainer();var r=this.getAction(e[n]);if(!r||!r.changeType){return false}if(n>0){if(t[0]!==t[n]||this.getAction(e[0]).changeType!==r.changeType){return false}}}return true};a.prototype._checkBindingCompatibilityOfControls=function(e,n){return e.every(function(i){return e.every(function(e){return i!==e?t.checkSourceTargetBindingCompatibility(i,e,n):true})})};a.prototype.isAvailable=function(e){if(e.length<=1){return false}return e.every(function(e){return this._isEditableByPlugin(e)},this)&&this._checkForSameRelevantContainer(e)};a.prototype.isEnabled=function(e){if(!this.isAvailable(e)||e.length<=1){return false}var t=e.map(function(e){return e.getElement()});var n=e.every(function(e){var n=this.getAction(e);if(!n){return false}if(typeof n.isEnabled!=="undefined"){if(typeof n.isEnabled==="function"){return n.isEnabled(t)}return n.isEnabled}return true},this);if(n){var i=t[0]&&t[0].getModel();return this._checkBindingCompatibilityOfControls(t,i)}return n};a.prototype.handleCombine=function(e,t){var a;var o=e.map(function(e){if(e.getElement().getId()===t.getId()){a=e}return e.getElement()});var u=a.getDesignTimeMetadata();var s=this.getVariantManagementReference(a);var c=n.getViewForControl(t);var l=c.createId(r());return this.getCommandFactory().getCommandFor(t,"combine",{newElementId:l,source:t,combineElements:o},u,s).then(function(e){this.fireElementModified({command:e})}.bind(this)).catch(function(e){throw i.createError("Combine#handleCombine",e,"sap.ui.rta")})};a.prototype.getMenuItems=function(e){return this._getMenuItems(e,{pluginId:"CTX_GROUP_FIELDS",icon:"sap-icon://combine"})};a.prototype.getActionName=function(){return"combine"};a.prototype.handler=function(e,t){this.handleCombine(e,t.contextElement)};return a});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/rta/plugin/CompVariant", ["sap/base/util/restricted/_omit","sap/base/util/isEmptyObject","sap/m/MessageBox","sap/ui/core/Lib","sap/ui/dt/OverlayRegistry","sap/ui/dt/Util","sap/ui/fl/write/api/ContextSharingAPI","sap/ui/rta/plugin/rename/RenameDialog","sap/ui/rta/plugin/Plugin","sap/ui/rta/Utils"],function(t,e,n,a,i,r,o,s,c,l){"use strict";var d=c.extend("sap.ui.rta.plugin.CompVariant",{metadata:{library:"sap.ui.rta",properties:{oldValue:{type:"string"}}}});function g(t){return t.getMetadata().getName()==="sap.ui.comp.smartvariants.SmartVariantManagement"}function u(t,e,n,a){var i=t.getDesignTimeMetadata();var o=a||t.getElement();return Promise.resolve().then(function(){if(e.length===1){return this.getCommandFactory().getCommandFor(o,e[0],n,i)}var t;return this.getCommandFactory().getCommandFor(o,"composite").then(function(a){t=a;var r=[];e.forEach(function(t){r.push(this.getCommandFactory().getCommandFor(o,t,n[t],i))}.bind(this));return Promise.all(r).then(function(e){e.forEach(t.addCommand.bind(t));return t})}.bind(this))}.bind(this)).then(function(t){this.fireElementModified({command:t})}.bind(this)).catch(function(t){throw r.createError(e[0],t,"sap.ui.rta.plugin.CompVariant")})}function p(t){return t.getElement().getAllVariants()}d.prototype.init=function(...t){c.prototype.init.apply(this,t);this._oDialog=new s};async function m(t){const[e]=t;const n=e.getElement().getPresentVariantId();const a=e.getDesignTimeMetadata().getData().variantRenameDomRef;const i=await this._oDialog.openDialogAndHandleRename({overlay:e,domRef:a,action:this.getAction(e)});if(!i){return}const r={newVariantProperties:{[n]:{name:i}}};u.call(this,e,["compVariantUpdate"],r)}d.prototype.isRenameAvailable=function(t){const e=t.getElement();if(g(e)){const n=p(t);const a=n.find(function(t){return t.getVariantId()===e.getPresentVariantId()});const i=this.getCommandFactory().getFlexSettings().layer;return a.isRenameEnabled(i)}return false};d.prototype.isRenameEnabled=function(t){return this.isRenameAvailable(t[0])};function h(n){var a=n[0].getElement();var i=this.getCommandFactory().getFlexSettings();i.variantManagementControl=a;const r=a.getCurrentVariantId();var s={layer:this.getCommandFactory().getFlexSettings().layer,contextSharingComponentContainer:o.createComponent(i),rtaStyleClass:l.getRtaStyleClassName()};a.openManageViewsDialogForKeyUser(s,function(i){if(!e(i)){u.call(this,n[0],["compVariantUpdate"],{newVariantProperties:t(i,["default"]),newDefaultVariantId:i.default,oldDefaultVariantId:a.getDefaultVariantId(),oldSelectedVariantId:r})}}.bind(this))}function A(t,e,i){if(i===n.Action.CANCEL){return}var r=a.getResourceBundleFor("sap.ui.rta");var o=t.getElement();var s;if(i===r.getText("BTN_MODIFIED_VARIANT_SAVE")){C(o).then(function(n){s={compVariantSwitch:{targetVariantId:e,sourceVariantId:o.getPresentVariantId()},compVariantUpdate:n};u.call(this,t,["compVariantUpdate","compVariantSwitch"],s)}.bind(this))}if(i===r.getText("BTN_MODIFIED_VARIANT_DISCARD")){u.call(this,t,["compVariantSwitch"],{targetVariantId:e,sourceVariantId:o.getPresentVariantId(),discardVariantContent:true})}}function V(t){return p(t[0]).length>1}function f(t,e){var i=t[0];var r=i.getElement();if(r.getModified()){var o=a.getResourceBundleFor("sap.ui.rta");var s=e.eventItem.getParameters().item.getProperty("key");n.warning(o.getText("MSG_CHANGE_MODIFIED_VARIANT"),{onClose:A.bind(this,i,s),actions:[o.getText("BTN_MODIFIED_VARIANT_SAVE"),o.getText("BTN_MODIFIED_VARIANT_DISCARD"),n.Action.CANCEL],emphasizedAction:o.getText("BTN_MODIFIED_VARIANT_SAVE"),styleClass:l.getRtaStyleClassName(),id:"compVariantWarningDialog"})}else{u.call(this,i,["compVariantSwitch"],{targetVariantId:e.eventItem.getParameters().item.getProperty("key"),sourceVariantId:r.getPresentVariantId()})}}function C(t){return t.getPresentVariantContent().then(function(e){var n={onlySave:true,newVariantProperties:{}};n.newVariantProperties[t.getPresentVariantId()]={content:e};return n})}function _(t){var e=t[0].getElement();C(e).then(function(e){u.call(this,t[0],["compVariantUpdate"],e)}.bind(this))}function I(t){return t[0].getElement().currentVariantGetModified()}function T(t,e){var n=t[0].getElement();var a=this.getCommandFactory().getFlexSettings();a.variantManagementControl=n;var i=o.createComponent(a);return new Promise(function(a){n.openSaveAsDialogForKeyUser(l.getRtaStyleClassName(),function(i){if(i){u.call(this,t[0],["compVariantSaveAs"],{newVariantProperties:{default:i.default,executeOnSelection:i.executeOnSelection,content:i.content,type:i.type,text:i.text,contexts:i.contexts},previousDirtyFlag:n.getModified(),previousVariantId:n.getPresentVariantId(),previousDefault:n.getDefaultVariantId(),activateAfterUndo:!!e})}a(i)}.bind(this),i)}.bind(this))}function E(t,e,n){var r=a.getResourceBundleFor("sap.ui.rta");if(n===r.getText("BTN_CREATE_NEW_VIEW")){T.call(this,[i.getOverlay(t)],true).then(function(n){if(!n){t.activateVariant(e)}})}else{t.activateVariant(e)}}function v(t,e){var i=a.getResourceBundleFor("sap.ui.rta");var r=e[0];var o=r.getElement();t=t.action||t;var s=o.getVariantManagement();var c=s.getModified();return t.handler(o,{styleClass:l.getRtaStyleClassName()}).then(function(t){if(t&&t.length){var e=t[0].changeSpecificData.content.persistencyKey;var a=s.getAllVariants();var o=a.find(function(t){return t.getVariantId()===s.getPresentVariantId()});if(o.isEditEnabled(this.getCommandFactory().getFlexSettings().layer)){u.call(this,r,["compVariantContent"],{variantId:t[0].changeSpecificData.content.key,newContent:t[0].changeSpecificData.content.content,persistencyKey:e,isModifiedBefore:c},s)}else{n.warning(i.getText("MSG_CHANGE_READONLY_VARIANT"),{onClose:E.bind(this,s,o.getVariantId()),actions:[i.getText("BTN_CREATE_NEW_VIEW"),n.Action.CANCEL],emphasizedAction:i.getText("BTN_CREATE_NEW_VIEW"),styleClass:l.getRtaStyleClassName()})}}}.bind(this))}d.prototype._isEditable=function(t){return this.hasStableId(t)&&!!this.getAction(t)};d.prototype.getMenuItems=function(t){var e=t[0];var n=e.getElement();const i=this.getAction(e);var r=[];if(this.isAvailable([e])){if(i){if(i.changeType==="variantContent"){r.push({id:"CTX_COMP_VARIANT_CONTENT",additionalInfo:this._getAdditionalInfo(e,i),text:this.getActionText(e,i),handler:v.bind(this,i),enabled:true,rank:this.getRank("CTX_COMP_VARIANT_CONTENT"),icon:"sap-icon://key-user-settings"})}else{var o=this.getCommandFactory().getFlexSettings().layer;var s=a.getResourceBundleFor("sap.ui.rta");var c=p(e);var l=c.find(function(t){return t.getVariantId()===n.getPresentVariantId()});if(l.isRenameEnabled(o)){r.push({id:"CTX_COMP_VARIANT_RENAME",text:s.getText("CTX_RENAME"),handler:m.bind(this),enabled:true,rank:this.getRank("CTX_COMP_VARIANT_RENAME"),icon:"sap-icon://edit"})}if(l.isEditEnabled(o)){r.push({id:"CTX_COMP_VARIANT_SAVE",text:s.getText("CTX_VARIANT_SAVE"),handler:_.bind(this),enabled:I,rank:this.getRank("CTX_COMP_VARIANT_SAVE"),icon:"sap-icon://save"})}r.push({id:"CTX_COMP_VARIANT_SAVE_AS",text:s.getText("CTX_VARIANT_SAVEAS"),handler:T.bind(this),enabled:true,rank:this.getRank("CTX_COMP_VARIANT_SAVE_AS"),icon:"sap-icon://duplicate"});r.push({id:"CTX_COMP_VARIANT_MANAGE",text:s.getText("CTX_VARIANT_MANAGE"),handler:h.bind(this),enabled:true,rank:this.getRank("CTX_COMP_VARIANT_MANAGE"),icon:"sap-icon://action-settings"});var d=c.map(function(t){var e=n.getPresentVariantId()===t.getVariantId();var a={id:t.getVariantId(),text:t.getText("variantName"),icon:e?"sap-icon://accept":"blank",enabled:!e};return a});r.push({id:"CTX_COMP_VARIANT_SWITCH",text:s.getText("CTX_VARIANT_SWITCH"),handler:f.bind(this),enabled:V,submenu:d,rank:this.getRank("CTX_COMP_VARIANT_SWITCH"),icon:"sap-icon://switch-views"})}}}return r};d.prototype.getActionName=function(){return"compVariant"};d.prototype.destroy=function(...t){c.prototype.destroy.apply(this,t);this._oDialog.destroy();delete this._oDialog};return d});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/rta/plugin/ControlVariant", ["sap/base/Log","sap/m/MessageBox","sap/ui/base/ManagedObject","sap/ui/core/Element","sap/ui/core/Lib","sap/ui/dt/ElementOverlay","sap/ui/dt/OverlayRegistry","sap/ui/dt/OverlayUtil","sap/ui/dt/Util","sap/ui/fl/apply/api/ControlVariantApplyAPI","sap/ui/fl/variants/VariantManagement","sap/ui/fl/variants/VariantManager","sap/ui/fl/write/api/ContextSharingAPI","sap/ui/fl/Layer","sap/ui/fl/Utils","sap/ui/rta/plugin/rename/RenameDialog","sap/ui/rta/plugin/Plugin","sap/ui/rta/Utils"],function(t,e,a,n,i,r,o,s,g,l,c,m,d,u,p,h,f,v){"use strict";r.prototype._variantManagement=undefined;r.prototype.getVariantManagement=function(){return this._variantManagement};r.prototype.setVariantManagement=function(t){this._variantManagement=t};r.prototype.hasVariantManagement=function(){return!!this._variantManagement};function V(t){var e=t.getElement().getManageDialog();if(e&&!e.bIsDestroyed){e.destroy()}}var A=f.extend("sap.ui.rta.plugin.ControlVariant",{metadata:{library:"sap.ui.rta",properties:{oldValue:"string"},associations:{},events:{}}});function _(t){var e=t.getElement();var a=t.getDesignTimeMetadata();var n=this._getVariantModel(e);var i=t.getVariantManagement();return this.getCommandFactory().getCommandFor(e,"save",{model:n},a,i)}function y(t,e,a,n){var i=t.getElement();var r=t.getDesignTimeMetadata();return this.getCommandFactory().getCommandFor(i,"switch",{targetVariantReference:e,sourceVariantReference:a,discardVariantContent:n},r)}A.prototype.init=function(...t){f.prototype.init.apply(this,t);this._oDialog=new h};A.prototype.registerElementOverlay=function(...t){const[e]=t;var i=e.getElement();var r;f.prototype.registerElementOverlay.apply(this,t);if(i instanceof c){var s=i.getFor();var g;var l=p.getAppComponentForControl(i);var m=i.getId();r=l.getLocalId(m)||m;e.setVariantManagement(r);if(!s||Array.isArray(s)&&s.length===0){return}g=!Array.isArray(s)?[s]:s;g.forEach(function(t){var e=t instanceof a?t:n.getElementById(t);var i=o.getOverlay(e);if(!i){const e=(t,a)=>{const n=t.getParameter("elementOverlay");if(n.getElement().getId()===a){this._propagateVariantManagement(n,r);this.getDesignTime().detachEvent("elementOverlayCreated",e)}};this.getDesignTime().attachEvent("elementOverlayCreated",t,e,this)}else{this._propagateVariantManagement(i,r)}}.bind(this));V(e)}else if(!e.getVariantManagement()){r=this._getVariantManagementFromParent(e);if(r){e.setVariantManagement(r)}}};A.prototype._isPersonalizationMode=function(){return this.getCommandFactory().getFlexSettings().layer===u.USER};A.prototype._propagateVariantManagement=function(t,e){var a=[];t.setVariantManagement(e);a=s.getAllChildOverlays(t);a.forEach(function(t){a=a.concat(this._propagateVariantManagement(t,e))}.bind(this));return a};A.prototype._getVariantManagementFromParent=function(t){var e=t.getVariantManagement();if(!e&&t.getParentElementOverlay()){return this._getVariantManagementFromParent(t.getParentElementOverlay())}return e};A.prototype.deregisterElementOverlay=function(...t){const e=t[0];if(this._isVariantManagementControl(e)){V(e)}this.removeFromPluginsList(e);f.prototype.deregisterElementOverlay.apply(this,t)};A.prototype._getVariantModel=function(t){var e=p.getAppComponentForControl(t);return e?e.getModel(l.getVariantModelName()):undefined};A.prototype._isEditable=function(t){if(this._isPersonalizationMode()){return false}return this._isVariantManagementControl(t)&&this.hasStableId(t)};A.prototype._isVariantManagementControl=function(t){var e=t.getElement();var a=e.getAssociation("for");return!!(a&&e instanceof c)};A.prototype.isVariantSwitchAvailable=function(t){return this._isVariantManagementControl(t)};A.prototype.isVariantSwitchEnabled=function(t){var e=t[0];var a=[];if(this._isVariantManagementControl(e)){var n=e.getElement();var i=e.getVariantManagement?e.getVariantManagement():undefined;if(!i){return false}var r=this._getVariantModel(n);if(r){a=r.getData()[i].variants.reduce(function(t,e){if(e.visible){return t.concat(e)}return t},[])}var o=a.length>1;return o}return false};A.prototype.isRenameAvailable=function(t){return this._isVariantManagementControl(t)};A.prototype.isRenameEnabled=function(t){return this._isVariantManagementControl(t[0])};A.prototype.isVariantSaveAvailable=function(t){return this._isVariantManagementControl(t)};A.prototype.isVariantSaveEnabled=function(t){var e=t[0];var a=e.getElement();var n=this._getVariantModel(a);var i=e.getVariantManagement();return n.oData[i]&&n.oData[i].modified};A.prototype.isVariantSaveAsAvailable=function(t){return this._isVariantManagementControl(t)};A.prototype.isVariantSaveAsEnabled=function(t){return this._isVariantManagementControl(t[0])};A.prototype.isVariantConfigureAvailable=function(t){return this._isVariantManagementControl(t)};A.prototype.isVariantConfigureEnabled=function(t){return this._isVariantManagementControl(t[0])};A.prototype.switchVariant=function(t,a,n){var r=t.getElement();var o=i.getResourceBundleFor("sap.ui.rta");function s(i){if(i===e.Action.CANCEL){return}if(i===o.getText("BTN_MODIFIED_VARIANT_SAVE")){var s;this.getCommandFactory().getCommandFor(r,"composite").then(function(e){s=e;return _.call(this,t)}.bind(this)).then(function(e){s.addCommand(e);return y.call(this,t,a,n)}.bind(this)).then(function(t){s.addCommand(t);this.fireElementModified({command:s})}.bind(this))}if(i===o.getText("BTN_MODIFIED_VARIANT_DISCARD")){y.call(this,t,a,n,true).then(function(t){this.fireElementModified({command:t})}.bind(this))}}if(r.getModified()){e.warning(o.getText("MSG_CHANGE_MODIFIED_VARIANT"),{onClose:s.bind(this),actions:[o.getText("BTN_MODIFIED_VARIANT_SAVE"),o.getText("BTN_MODIFIED_VARIANT_DISCARD"),e.Action.CANCEL],emphasizedAction:o.getText("BTN_MODIFIED_VARIANT_SAVE"),styleClass:v.getRtaStyleClassName(),id:"controlVariantWarningDialog"})}else{y.call(this,t,a,n).then(function(t){this.fireElementModified({command:t})}.bind(this)).catch(function(t){throw g.createError("ControlVariant#switchVariant",t,"sap.ui.rta")})}};A.prototype.renameVariant=async function(t){const[e]=t;const a=e.getVariantManagement();const n=e.getDesignTimeMetadata();const i=e.getElement();const r=n.getData().variantRenameDomRef;const o=await this._oDialog.openDialogAndHandleRename({overlay:e,domRef:r,action:this.getAction(e)});if(!o){return}const s=await this._createSetTitleCommand({text:o,element:i,designTimeMetadata:n,variantManagementReference:a});this.fireElementModified({command:s})};A.prototype.createSaveCommand=function(t){var e=t[0];return _.call(this,e).then(function(t){this.fireElementModified({command:t})}.bind(this))};A.prototype.createSaveAsCommand=function(t){var e=t[0];var a=e.getElement();var n=e.getDesignTimeMetadata();var i=this._getVariantModel(a);var r=e.getVariantManagement();var o=i.getCurrentVariantReference(r);return this.getCommandFactory().getCommandFor(a,"saveAs",{sourceVariantReference:o,model:i},n,r).then(function(t){this.fireElementModified({command:t})}.bind(this))};A.prototype._createSetTitleCommand=function(e){return this.getCommandFactory().getCommandFor(e.element,"setTitle",{newText:e.text},e.designTimeMetadata,e.variantManagementReference).catch(function(e){t.error("Error during rename: ",e)})};A.prototype.configureVariants=function(t){var e=t[0];var a=e.getElement();var n=e.getVariantManagement();var i=e.getDesignTimeMetadata();var r=this.getCommandFactory().getFlexSettings();var o=r;o.variantManagementControl=a;return m.manageVariants(a,n,r.layer,v.getRtaStyleClassName(),d.createComponent(o)).then(function(t){if(t.changes.length>0){return this.getCommandFactory().getCommandFor(a,"configure",{control:a,changes:t.changes,deletedVariants:t.variantsToBeDeleted},i,n)}return undefined}.bind(this)).then(function(t){if(t){this.fireElementModified({command:t})}}.bind(this)).catch(function(t){throw g.createError("ControlVariant#configureVariants",t,"sap.ui.rta")})};A.prototype.getMenuItems=function(t){var e=t[0];var a=[];if(this.isRenameAvailable(e)){a.push({id:"CTX_VARIANT_SET_TITLE",text:i.getResourceBundleFor("sap.ui.rta").getText("CTX_RENAME"),handler:this.renameVariant.bind(this),enabled:this.isRenameEnabled.bind(this),rank:this.getRank("CTX_VARIANT_SET_TITLE"),icon:"sap-icon://edit"})}if(this.isVariantSaveAvailable(e)){a.push({id:"CTX_VARIANT_SAVE",text:i.getResourceBundleFor("sap.ui.rta").getText("CTX_VARIANT_SAVE"),handler:this.createSaveCommand.bind(this),enabled:this.isVariantSaveEnabled.bind(this),rank:this.getRank("CTX_VARIANT_SAVE"),icon:"sap-icon://save"})}if(this.isVariantSaveAsAvailable(e)){a.push({id:"CTX_VARIANT_SAVEAS",text:i.getResourceBundleFor("sap.ui.rta").getText("CTX_VARIANT_SAVEAS"),handler:this.createSaveAsCommand.bind(this),enabled:this.isVariantSaveAsEnabled.bind(this),rank:this.getRank("CTX_VARIANT_SAVEAS"),icon:"sap-icon://duplicate"})}if(this.isVariantConfigureAvailable(e)){a.push({id:"CTX_VARIANT_MANAGE",text:i.getResourceBundleFor("sap.ui.rta").getText("CTX_VARIANT_MANAGE"),handler:this.configureVariants.bind(this),enabled:this.isVariantConfigureEnabled.bind(this),startSection:true,rank:this.getRank("CTX_VARIANT_MANAGE"),icon:"sap-icon://action-settings"})}if(this.isVariantSwitchAvailable(e)){var n=this._getVariantModel(e.getElement());var r=e.getVariantManagement();var o=n.getData()[r].variants.reduce(function(t,e){if(e.visible){var a=n.getData()[r].currentVariant===e.key;var i={id:e.key,text:e.title,icon:a?"sap-icon://accept":"blank",enabled:!a};return t.concat(i)}return t},[]);a.push({id:"CTX_VARIANT_SWITCH_SUBMENU",text:i.getResourceBundleFor("sap.ui.rta").getText("CTX_VARIANT_SWITCH"),handler:function(t,e){var a=e.eventItem.getParameters().item.getProperty("key");var i=t[0];var o=n.getData()[r].currentVariant;return this.switchVariant(i,a,o)}.bind(this),enabled:this.isVariantSwitchEnabled.bind(this),submenu:o,rank:this.getRank("CTX_VARIANT_SWITCH_SUBMENU"),icon:"sap-icon://switch-views"})}return a};A.prototype.getActionName=function(){return"controlVariant"};A.prototype.destroy=function(...t){f.prototype.destroy.apply(this,t);this._oDialog.destroy();delete this._oDialog};return A});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/rta/plugin/CreateContainer", ["sap/ui/rta/plugin/BaseCreate","sap/ui/fl/Utils","sap/ui/dt/Util","sap/base/util/uid"],function(t,e,a,r){"use strict";var n=t.extend("sap.ui.rta.plugin.CreateContainer",{metadata:{library:"sap.ui.rta",properties:{},associations:{},events:{}}});n.prototype.isEnabled=function(t,e){var a=t[0];var r=this.getCreateAction(e,a);return this.isActionEnabled(r,e,a)};n.prototype.getCreateContainerText=function(t,e){var a=this.getCreateAction(t,e);var r=this._getParentOverlay(t,e);var n=r.getDesignTimeMetadata();var i=r.getElement();var o="CTX_CREATE_CONTAINER";return this._getText(a,i,n,o)};n.prototype._getContainerTitle=function(t,e,a){var r="TITLE_CREATE_CONTAINER";return this._getText(t,e,a,r)};n.prototype.handleCreate=function(t,n){var i=this.getCreateAction(t,n);var o=this._getParentOverlay(t,n);var s=o.getElement();var g=o.getDesignTimeMetadata();var d=e.getViewForControl(s);var C;if(t){C=n.getElement()}var u=d.createId(r());var h=g.getAggregation(i.aggregation).getIndex;var l=this._determineIndex(s,C,i.aggregation,h);var c=this.getVariantManagementReference(o);return this.getCommandFactory().getCommandFor(s,"createContainer",{newControlId:u,label:this._getContainerTitle(i,s,g),index:l,parentId:s.getId()},g,c).then(function(t){this.fireElementModified({command:t,action:i,newControlId:u})}.bind(this)).catch(function(t){throw a.createError("CreateContainer#handleCreate",t,"sap.ui.rta")})};n.prototype.getMenuItems=function(t){var e=true;var a="CTX_CREATE_SIBLING_CONTAINER";var r=this.getRank(a);var n=[];var i=function(t,e){return this.isEnabled(e,t)}.bind(this);for(var o=0;o<2;o++){if(this.isAvailable(t,e)){n.push({id:a,text:this.getCreateContainerText.bind(this,e),handler:this.handleCreate.bind(this,e,t[0]),enabled:i.bind(this,e),icon:"sap-icon://add-folder",rank:r})}e=false;a="CTX_CREATE_CHILD_CONTAINER";r=this.getRank(a)}return n};n.prototype.getActionName=function(){return"createContainer"};return n});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/rta/plugin/CutPaste", ["sap/ui/core/Lib","sap/ui/dt/plugin/CutPaste","sap/ui/dt/Util","sap/ui/rta/plugin/Plugin","sap/ui/rta/plugin/RTAElementMover","sap/ui/rta/Utils"],function(t,e,i,n,r,a){"use strict";var o=e.extend("sap.ui.rta.plugin.CutPaste",{metadata:{library:"sap.ui.rta",properties:{commandFactory:{type:"object",multiple:false},commandStack:{type:"object",multiple:false}},events:{dragStarted:{},elementModified:{command:{type:"sap.ui.rta.command.BaseCommand"}}}}});a.extendWith(o.prototype,n.prototype,function(t,e,i){return i!=="getMetadata"});o.prototype.init=function(...t){e.prototype.init.apply(this,t);this.setElementMover(new r({commandFactory:this.getCommandFactory()}))};o.prototype._isEditable=function(t,e){return this.getElementMover().isEditable(t,e.onRegistration).then(function(e){if(e){return true}return this._isPasteEditable(t)}.bind(this))};o.prototype._isPasteEditable=function(t){var e=this.getElementMover();if(!this.hasStableId(t)){return Promise.resolve(false)}return e.isMoveAvailableOnRelevantContainer(t).then(function(i){if(!i){return false}return a.doIfAllControlsAreAvailable([t],function(){return e.isMoveAvailableForChildren(t)})})};o.prototype.isAvailable=function(t){return t.every(function(t){return t.getMovable()})};o.prototype.registerElementOverlay=function(...t){e.prototype.registerElementOverlay.apply(this,t);n.prototype.registerElementOverlay.apply(this,t)};o.prototype.deregisterElementOverlay=function(...t){e.prototype.deregisterElementOverlay.apply(this,t);n.prototype.removeFromPluginsList.apply(this,t)};o.prototype.paste=function(t){this._executePaste(t);i.waitForSynced(this.getDesignTime())().then(function(){return this.getElementMover().buildMoveCommand()}.bind(this)).then(function(t){this.fireElementModified({command:t});this.stopCutAndPaste()}.bind(this)).catch(function(t){throw i.createError("CutPaste#paste",t,"sap.ui.rta")})};o.prototype.cut=function(...t){const[i]=t;return e.prototype.cut.apply(this,t).then(function(){i.setSelected(false)})};o.prototype.getMenuItems=function(e){var i=[];var n=this.enhanceItemWithResponsibleElement({id:"CTX_PASTE",text:t.getResourceBundleFor("sap.ui.rta").getText("CTX_PASTE"),handler:function(t){return this.paste(t[0])}.bind(this),enabled:function(t){return this.isElementPasteable(t[0])}.bind(this),rank:this.getRank("CTX_PASTE"),icon:"sap-icon://paste"},e,["move"]);var r=n.responsible||e;if(this.isAvailable(r)){var a=this.enhanceItemWithResponsibleElement({id:"CTX_CUT",text:t.getResourceBundleFor("sap.ui.rta").getText("CTX_CUT"),handler:function(t){return this.cut(t[0])}.bind(this),enabled(t){return t.length===1},rank:this.getRank("CTX_CUT"),icon:"sap-icon://scissors"},e,["move"]);i.push(a,n);return i}return this._isPasteEditable(e[0]).then(function(t){if(t){i.push(n)}return i})};return o});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/rta/plugin/DragDrop", ["sap/ui/dt/plugin/ControlDragDrop","sap/ui/dt/Util","sap/ui/dt/OverlayRegistry","sap/ui/rta/plugin/RTAElementMover","sap/ui/rta/plugin/Plugin","sap/ui/rta/Utils"],function(t,e,r,a,o,n){"use strict";var i=t.extend("sap.ui.rta.plugin.DragDrop",{metadata:{library:"sap.ui.rta",properties:{commandFactory:{type:"object",multiple:false},commandStack:{type:"object",multiple:false}},events:{dragStarted:{},elementModified:{command:{type:"sap.ui.rta.command.BaseCommand"}}}}});n.extendWith(i.prototype,o.prototype,function(t,e,r){return r!=="getMetadata"});i.prototype.init=function(...e){t.prototype.init.apply(this,e);this.setElementMover(new a({commandFactory:this.getCommandFactory()}))};i.prototype.setCommandFactory=function(t){this.setProperty("commandFactory",t);this.getElementMover().setCommandFactory(t)};i.prototype._isEditable=function(t,e){return this.getElementMover().isEditable(t,e.onRegistration)};i.prototype.registerElementOverlay=function(...e){t.prototype.registerElementOverlay.apply(this,e);o.prototype.registerElementOverlay.apply(this,e)};i.prototype.deregisterElementOverlay=function(...e){t.prototype.deregisterElementOverlay.apply(this,e);o.prototype.removeFromPluginsList.apply(this,e)};i.prototype.onDragStart=function(...e){const[r]=e;this.fireDragStarted();t.prototype.onDragStart.apply(this,e);this.getSelectedOverlays().forEach(function(t){t.setSelected(false)});r.getDomRef().classList.add("sapUiRtaOverlayPlaceholder")};i.prototype.onDragEnd=function(r){this.getElementMover().buildMoveCommand().then(function(...e){const[a]=e;this.fireElementModified({command:a});r.getDomRef().classList.remove("sapUiRtaOverlayPlaceholder");r.setSelected(true);r.focus();t.prototype.onDragEnd.apply(this,e);this._updateRelevantOverlays()}.bind(this)).catch(function(t){throw e.propagateError(t,"DragDrop#onDragEnd","Error accured during onDragEnd execution","sap.ui.rta.plugin")})};i.prototype.onMovableChange=function(...e){t.prototype.onMovableChange.apply(this,e)};i.prototype._updateRelevantOverlays=function(){var t=this.getElementMover().getSourceAndTargetParentInformation();var e=t.sourceParentInformation.parent;var a=t.targetParentInformation.parent;var o=t.sourceParentInformation.aggregation;var n=t.targetParentInformation.aggregation;var i=e&&e.getAggregation(o);var p=[];if(i&&i.length>0){var s=r.getOverlay(i[0]);p=this._getRelevantOverlays(s,o)}if(a&&(a!==e||a===e&&o!==n)){var l=a&&a.getAggregation(n);if(l&&l.length>1){var g=t.targetParentInformation.index;var y=l[g+1]||l[g-1];var c=r.getOverlay(y);var d=this._getRelevantOverlays(c,n);p=p.concat(d)}}if(p.length>0){p=p.filter(function(t,e,r){return e===r.indexOf(t)});this.evaluateEditable(p,{onRegistration:false})}};return i});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/rta/plugin/ExtendControllerPlugin", ["sap/ui/core/Lib","sap/ui/dt/Util","sap/ui/rta/plugin/Plugin"],function(t,e,n){"use strict";const o=n.extend("sap.ui.rta.plugin.ExtendController",{metadata:{library:"sap.ui.rta",properties:{handlerFunction:{type:"function"}},associations:{},events:{}}});const r="codeExt";o.prototype._isEditable=function(){return Promise.resolve(true)};o.prototype.isEnabled=function(t){const e=t.length===1&&!this.isInReuseComponentOnS4HanaCloud(t[0]);return e};o.prototype.getActionText=function(e,n,o){const r=n.name;const i=e.getElement();let a;if(r){if(typeof r==="function"){return r(i)}a=e.getDesignTimeMetadata()?e.getDesignTimeMetadata().getLibraryText(i,r):""}else{a=t.getResourceBundleFor("sap.ui.rta").getText(o)}if(this.isInReuseComponentOnS4HanaCloud(e)){a+=` (${t.getResourceBundleFor("sap.ui.rta").getText("CTX_DISABLED_REUSE")})`}return a};o.prototype.handler=async function(t,n){try{const e=n.handlerFunction||this.getHandlerFunction();if(!e){throw Error("Controller handler function is not available in the handler")}const o=t[0];const i=await e(o);const a=await this.getCommandFactory().getCommandFor(o.getElement(),r,i);this.fireElementModified({command:a})}catch(t){throw e.propagateError(t,"ExtentController#handler","Error occurred in ExtentController handler function","sap.ui.rta")}};o.prototype.getMenuItems=function(t){return this._getMenuItems(t,{pluginId:"CTX_EXTEND_CONTROLLER",icon:"sap-icon://create-form"})};o.prototype.getActionName=function(){return"extendController"};o.prototype.getAction=function(t){const e=n.prototype.getAction.apply(this,[t]);return e||{changeType:r}};return o});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/rta/plugin/LocalReset", ["sap/ui/core/Element","sap/ui/core/Lib","sap/ui/rta/plugin/Plugin","sap/ui/dt/Util","sap/ui/fl/Utils","sap/ui/fl/apply/api/ControlVariantApplyAPI","sap/ui/fl/write/api/LocalResetAPI","sap/ui/rta/command/CompositeCommand","sap/m/MessageToast","sap/ui/dt/OverlayRegistry"],function(e,t,a,n,r,i,o,s,l,u){"use strict";function p(e,t){return t?e.getCurrentVariantReference(t):""}var d=a.extend("sap.ui.rta.plugin.LocalReset",{metadata:{library:"sap.ui.rta",properties:{},associations:{},events:{}}});d.prototype._isEditable=function(e){if(!this.hasStableId(e)){return false}var t=this.getAction(e);return!!t};d.prototype.isEnabled=function(e){if(e.length!==1){return false}var t=e[0];var a=t.getElement();var n=this.getAction(t);if(!n){return false}var s=true;if(typeof n.isEnabled!=="undefined"){if(typeof n.isEnabled==="function"){s=n.isEnabled(a)}else{s=n.isEnabled}}var l=n.changeOnRelevantContainer?t.getRelevantContainer():a;var d=u.getOverlay(l);var c=r.getAppComponentForControl(l);var g=c.getModel(i.getVariantModelName());var f=p(g,this.getVariantManagementReference(d));return s&&o.isResetEnabled(l,{layer:this.getCommandFactory().getFlexSettings().layer,currentVariant:f})};d.prototype.getMenuItems=function(e){return this._getMenuItems(e,{pluginId:"CTX_LOCAL_RESET",icon:"sap-icon://reset",additionalInfoKey:"LOCALRESET_RTA_CONTEXT_MENU_INFO"})};d.prototype.getActionName=function(){return"localReset"};d.prototype.handler=function(a){var o=a[0];var u=o.getElement();var d=o.getDesignTimeMetadata();var c=this.getVariantManagementReference(o);var g=r.getAppComponentForControl(u);var f=g.getModel(i.getVariantModelName());var m=p(f,c);var v=!!m;var E=v?g.byId(c)||e.getElementById(c):undefined;var h=this.getCommandFactory();var y=new s;return Promise.all([h.getCommandFor(u,"localReset",{currentVariant:m},d,c),v&&h.getCommandFor(E,"save",{model:f},d,c)].filter(Boolean)).then(function(e){e.forEach(function(e){y.addCommand(e)});this.fireElementModified({command:y});if(v){var a=t.getResourceBundleFor("sap.ui.rta").getText("MSG_LOCAL_RESET_VARIANT_SAVE");l.show(a,{duration:5e3})}}.bind(this)).catch(function(e){throw n.propagateError(e,"LocalReset#handler","Error occurred during handler execution","sap.ui.rta.plugin")})};return d});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/rta/plugin/Plugin", ["sap/base/util/restricted/_debounce","sap/ui/core/util/reflection/JsControlTreeModifier","sap/ui/dt/OverlayRegistry","sap/ui/dt/OverlayUtil","sap/ui/dt/Plugin","sap/ui/fl/write/api/ChangesWriteAPI","sap/ui/fl/Utils","sap/ui/rta/util/hasStableId","sap/ui/rta/util/isReuseComponent","sap/ui/rta/Utils"],function(e,t,i,n,a,s,r,o,l,u){"use strict";const g={CTX_ADDXML:3,CTX_EXTEND_CONTROLLER:5,CTX_RENAME:10,CTX_ANNOTATION_CHANGE_SINGLE_LABEL:12,CTX_ADD_ELEMENTS_AS_SIBLING:20,CTX_ADD_ELEMENTS_AS_CHILD:25,CTX_ADD_ELEMENTS_CHILD_AND_SIBLING:30,CTX_CREATE_SIBLING_CONTAINER:40,CTX_CREATE_CHILD_CONTAINER:50,CTX_REMOVE:60,CTX_LOCAL_RESET:65,CTX_CUT:70,CTX_PASTE:80,CTX_GROUP_FIELDS:90,CTX_UNGROUP_FIELDS:100,CTX_ADDXML_AT_EXTENSIONPOINT:105,CTX_SETTINGS:110,CTX_CREATE_SIBLING_IFRAME:130,CTX_VARIANT_SET_TITLE:200,CTX_COMP_VARIANT_RENAME:200,CTX_VARIANT_SAVE:210,CTX_COMP_VARIANT_SAVE:210,CTX_VARIANT_SAVEAS:220,CTX_COMP_VARIANT_SAVE_AS:220,CTX_VARIANT_MANAGE:230,CTX_COMP_VARIANT_MANAGE:230,CTX_VARIANT_SWITCH_SUBMENU:240,CTX_COMP_VARIANT_SWITCH:240,CTX_COMP_VARIANT_CONTENT:250,CTX_ANNOTATION:300};function c(e,t,i){var n=i;if(typeof this.getActionName()==="string"){if(this.isResponsibleElementActionAvailable(i)){n=this.getResponsibleElementOverlay(i)}}var a=n.getElement()&&n.getDesignTimeMetadata()&&!n.getDesignTimeMetadata().markedAsNotAdaptable()&&this._isEditable(n,{sourceElementOverlay:i,...e});if(a&&typeof a.then==="function"){a.then(function(e){this._handleModifyPluginList(i,e)}.bind(this));t.push(a)}else{this._handleModifyPluginList(i,a)}return t}var f=a.extend("sap.ui.rta.plugin.Plugin",{metadata:{abstract:true,library:"sap.ui.rta",properties:{commandFactory:{type:"object",multiple:false},commandStack:{type:"object",multiple:false}},events:{elementModified:{command:{type:"sap.ui.rta.command.BaseCommand"}}}}});f.prototype._isEditable=function(){};f.prototype.executeWhenVisible=function(e,t){var i=function(n){if(n.getSource().getGeometry()&&n.getSource().getGeometry().visible){e.detachEvent("geometryChanged",i,this);t()}};var n=e.getGeometry();if(e.getElementVisibility()&&(!n||!n.visible)){e.attachEvent("geometryChanged",i,this)}else{t()}};function h(t,i,n,a){var s=i.getId();t[s]||={};t[s][n]||=e(a,16);t[s][n]()}var d=async function(e){if(this.getCommandStack()){await this.getCommandStack().getLastCommandExecuted()}if(!this._mDebounceFunctions){this._mDebounceFunctions={insertOrRemove:{},addOrSet:{}}}var t=e.getParameters();var i;var n=e.getSource();if(t.type==="propertyChanged"&&t.name==="visible"){i=this._getRelevantOverlays(n);if(t.value===true){this.executeWhenVisible(n,function(){this.evaluateEditable(i,{onRegistration:false})}.bind(this))}else{this.evaluateEditable(i,{onRegistration:false})}}else if(t.type==="afterRendering"){if(this.getDesignTime().getStatus()==="synced"){this.evaluateEditable([n],{onRegistration:false})}else{this.getDesignTime().attachEventOnce("synced",function(){this.evaluateEditable([n],{onRegistration:false})},this)}}else if(t.type==="insertAggregation"||t.type==="removeAggregation"){h(this._mDebounceFunctions.insertOrRemove,n,t.name,function(){i=this._getRelevantOverlays(n,t.name);this.evaluateEditable(i,{onRegistration:false})}.bind(this))}else if(t.type==="addOrSetAggregation"){h(this._mDebounceFunctions.addOrSet,n,t.name,function(){var e=this.getDesignTime();if(!e){return}if(e.getStatus()==="synced"){i=this._getRelevantOverlays(n,t.name);this.evaluateEditable(i,{onRegistration:false})}else{e.attachEventOnce("synced",function(){i=this._getRelevantOverlays(n,t.name);this.evaluateEditable(i,{onRegistration:false})},this)}}.bind(this))}};f.prototype._getRelevantOverlays=function(e,t){var i=e.getRelevantOverlays();if(i.length===0){var a=[];if(!e.getIsPartOfTemplate()){a=n.findAllOverlaysInContainer(e);if(t){var s=e.getAggregationOverlay(t);var r=s?s.getChildren():[];r=r.filter(function(e){return a.indexOf(e)===-1});a=a.concat(r)}}e.setRelevantOverlays(a);return a}return i};f.prototype.evaluateEditable=async function(e,t){if(!t.onRegistration&&this.getDesignTime()&&this.getDesignTime().getBusyPlugins().length){return}this.setProcessingStatus(true);var i=e.reduce(c.bind(this,t),[]);if(i.length){try{await Promise.all(i);this.setProcessingStatus(false)}catch(e){this.setProcessingStatus(false)}}else{this.setProcessingStatus(false)}};f.prototype._handleModifyPluginList=function(e,t){if(t!==undefined&&t!==null){if(typeof t==="boolean"){this._modifyPluginList(e,t)}else{this._modifyPluginList(e,t.asChild,false);this._modifyPluginList(e,t.asSibling,true)}}};f.prototype._modifyPluginList=function(e,t,i){if(t){this.addToPluginsList(e,i)}else{this.removeFromPluginsList(e,i)}};f.prototype._retrievePluginName=function(e){var t=this.getMetadata().getName();if(e!==undefined){t+=e?".asSibling":".asChild"}return t};f.prototype._isEditableByPlugin=function(e,t){var i=this._retrievePluginName(t);return e.getEditableByPlugins()[i]};f.prototype.registerElementOverlay=function(e){this.executeWhenVisible(e,function(){this.evaluateEditable([e],{onRegistration:true});e.attachElementModified(d,this)}.bind(this))};f.prototype.deregisterElementOverlay=function(e){this.removeFromPluginsList(e);this.removeFromPluginsList(e,true);this.removeFromPluginsList(e,false);e.detachElementModified(d,this)};f.prototype.hasStableId=function(e){return o(e)};f.prototype.getVariantManagementReference=function(e){var t;if(e.getVariantManagement){t=e.getVariantManagement()}return t};f.prototype.checkAggregationsOnSelf=function(e,t,n,a){var s=e.getDesignTimeMetadata();var r=e.getElement();var o=s.getActionDataFromAggregations(t,r,undefined,a);var l=o.filter(function(e){if(e&&n){return e.aggregation===n}return true})[0];var u=l?l.changeType:null;var g=l&&l.changeOnRelevantContainer;if(g){r=e.getRelevantContainer();var c=i.getOverlay(r);if(!this.hasStableId(c)){return Promise.resolve(false)}}if(u){return this.hasChangeHandler(u,r)}return Promise.resolve(false)};f.prototype.removeFromPluginsList=function(e,t){const i=this._retrievePluginName(t);const n=e.getEditableByPlugins();e.setEditableByPlugins({...n,[i]:false});if(!Object.values(e.getEditableByPlugins()).some(Boolean)){e.setEditable(false)}};f.prototype.addToPluginsList=function(e,t){const i=this._retrievePluginName(t);const n=e.getEditableByPlugins();if(!n[i]){e.setEditableByPlugins({...n,[i]:true});e.setEditable(true)}};f.prototype.hasChangeHandler=function(e,i,n){return s.getChangeHandler({changeType:e,element:i,modifier:t,layer:this.getCommandFactory().getFlexSettings().layer,controlType:n}).then(function(){return true}).catch(function(){return false})};f.prototype.isAvailable=function(e){return e.every(function(e){return this._isEditableByPlugin(e)},this)};f.prototype._checkRelevantContainerStableID=function(e,t){if(e.changeOnRelevantContainer){var n=t.getRelevantContainer();var a=i.getOverlay(n);if(!this.hasStableId(a)){return false}}return true};f.prototype._checkChangeHandlerAndStableId=function(e){var t=this.getAction(e);if(t&&t.changeType){var i=t.changeOnRelevantContainer?e.getRelevantContainer():e.getElement();return this.hasChangeHandler(t.changeType,i).then(function(i){return i&&this._checkRelevantContainerStableID(t,e)&&this.hasStableId(e)}.bind(this))}return Promise.resolve(false)};f.prototype.getRank=function(e){return g[e]};f.prototype._getMenuItems=function(e,t){t.rank||=this.getRank(t.pluginId);return a.prototype._getMenuItems.apply(this,[e,t])};f.prototype.isInReuseComponentOnS4HanaCloud=function(e){const t=r.getComponentForControl(e.getElement());const i=u.isS4HanaCloud();return l(t)&&i};return f});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/rta/plugin/RTAElementMover", ["sap/ui/dt/plugin/ElementMover","sap/ui/dt/OverlayUtil","sap/ui/dt/ElementUtil","sap/ui/rta/Utils","sap/ui/rta/command/CommandFactory","sap/ui/rta/plugin/Plugin","sap/ui/dt/OverlayRegistry"],function(e,t,n,r,a,i,o){"use strict";var s=e.extend("sap.ui.rta.plugin.RTAElementMover",{metadata:{library:"sap.ui.rta",properties:{commandFactory:{type:"any",defaultValue:a},movableTypes:{type:"string[]",defaultValue:["sap.ui.core.Element"]}},associations:{},events:{}}});s.prototype.init=function(){this.oBasePlugin=new i({commandFactory:this.getCommandFactory()})};s.prototype.exit=function(){this.oBasePlugin.destroy()};s.prototype.setCommandFactory=function(e){this.setProperty("commandFactory",e);this.oBasePlugin.setCommandFactory(e)};s.prototype.isEditable=function(e,t){var n=e.getElement();if(!this.isMovableType(n)){return Promise.resolve(false)}return this.checkMovable(e,t).then(function(t){e.setMovable(t);return t})};function l(e,t){var r=e.getDesignTimeMetadata();var a=e.getParentElementOverlay();var i=r.markedAsNotAdaptable();if(!r||!a||i){return Promise.resolve(false)}var s=e.getElement();if(s.isDestroyStarted()||n.isElementDirectTemplateChild(s)){return Promise.resolve(false)}var l=e.getRelevantContainer();var v=o.getOverlay(l);if(!v){return Promise.resolve(false)}return this.isMoveAvailableOnRelevantContainer(e).then(function(t){t&&=this.oBasePlugin.hasStableId(e)&&this.oBasePlugin.hasStableId(a)&&this.oBasePlugin.hasStableId(v);return t}.bind(this)).then(function(n){if(n){return u.call(this,e,v,t)}return n}.bind(this))}function u(e,n,r){var a=t.findAllUniqueAggregationOverlaysInContainer(e,n);var i=a.map(function(t){return this.checkTargetZone(t,e,r).then(function(e){return e?t:undefined})}.bind(this));return Promise.all(i).then(function(e){e=e.filter(function(e){return!!e});if(e.length<1){return false}else if(e.length===1){var t=e[0].getChildren().filter(function(e){var t=e.getElement();return t&&t.getVisible()&&t.getParent()});return t.length>1}return true})}e.prototype._getMoveAction=function(e){var t;var n=e.getParentAggregationOverlay();if(n){t=n.getDesignTimeMetadata()}return t?t.getAction("move",e.getElement()):undefined};e.prototype.isMovableType=function(){return true};s.prototype.checkMovable=function(e,t){return l.call(this,e,t)};s.prototype.checkTargetZone=function(e,t,n){var a=t||this.getMovedOverlay();return r.checkTargetZone(e,a,this.oBasePlugin,n)};s.prototype.isMoveAvailableOnRelevantContainer=function(e){var t;var n=this._getMoveAction(e);if(n&&n.changeType){t=e.getRelevantContainer();var r=o.getOverlay(t);if(!this.oBasePlugin.hasStableId(r)){return Promise.resolve(false)}return this.oBasePlugin.hasChangeHandler(n.changeType,t)}return Promise.resolve(false)};s.prototype.isMoveAvailableForChildren=function(e){var t=e.getDesignTimeMetadata();var n=t.getAggregationNamesWithAction("move");var r=[];n.forEach(function(t){var n=e.getAggregationOverlay(t);if(n){var a=n.getChildren();var i=a.map(this.checkMovable.bind(this));r=r.concat(i)}else{r.push(Promise.resolve(false))}}.bind(this));return Promise.all(r).then(function(e){return e.some(function(e){return e})})};s.prototype.buildMoveCommand=function(){var e=this.getMovedOverlay();var n=e.getParentAggregationOverlay();var r=e.getElement();var a=this._getSource();var i=e.getRelevantContainer();var o=t.getParentInformation(e);var s=a.index;var l=o.index;var u=this._compareSourceAndTarget(a,o);if(u){return Promise.resolve()}delete a.index;delete o.index;var v=this.oBasePlugin.getVariantManagementReference(e);return this.getCommandFactory().getCommandFor(i,"Move",{movedElements:[{element:r,sourceIndex:s,targetIndex:l}],source:a,target:o},n.getDesignTimeMetadata(),v)};return s});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/rta/plugin/Remove", ["sap/ui/rta/plugin/Plugin","sap/ui/rta/Utils","sap/ui/rta/command/CompositeCommand","sap/ui/dt/OverlayRegistry","sap/ui/events/KeyCodes","sap/base/Log"],function(e,t,n,r,i,o){"use strict";var a=e.extend("sap.ui.rta.plugin.Remove",{metadata:{library:"sap.ui.rta",properties:{},associations:{},events:{}}});a.prototype.registerElementOverlay=function(...t){const[n]=t;if(this.isEnabled([n])){n.attachBrowserEvent("keydown",this._onKeyDown,this)}e.prototype.registerElementOverlay.apply(this,t)};a.prototype._isEditable=function(e){return this._checkChangeHandlerAndStableId(e)};a.prototype.isEnabled=function(e){var t=e.map(function(e){return this.getResponsibleElementOverlay(e)}.bind(this));var n=t[0];var r=this.getAction(n);var i=false;if(!r){return i}if(typeof r.isEnabled!=="undefined"){if(typeof r.isEnabled==="function"){i=r.isEnabled(n.getElement())}else{i=r.isEnabled}}else{i=true}return i&&this._canBeRemovedFromAggregation(t)};a.prototype._canBeRemovedFromAggregation=function(e){var t=function(e){var t=e.getParentAggregationOverlay();if(t){var n=this.getAction(t);return!!(n&&n.removeLastElement)}return false}.bind(this);var n=e[0];var i=n.getElement();var o=i.getParent();if(!o){return false}var a=o.getAggregation(i.sParentAggregationName);if(!Array.isArray(a)){return true}var s=e.length;var l=a.filter(function(e){var t=r.getOverlay(e);return!(t&&t.getElementVisibility())});var g=l.length+s===a.length;if(g){return t(n)}return true};a.prototype._getConfirmationText=function(e){var t=this.getAction(e);if(t&&t.getConfirmationText){return t.getConfirmationText(e.getElement())}};a.prototype.deregisterElementOverlay=function(...t){const[n]=t;if(this.isEnabled([n])){n.detachBrowserEvent("keydown",this._onKeyDown,this)}e.prototype.deregisterElementOverlay.apply(this,t)};a.prototype._onKeyDown=function(e){if(e.keyCode===i.DELETE||e.keyCode===i.BACKSPACE){e.stopPropagation();this.removeElement()}};a.prototype.removeElement=function(e){var t=e||this.getSelectedOverlays();t=t.filter(function(e){return this.isEnabled([e])},this);if(t.length>0){this.handler(t)}};a.prototype._getRemoveCommand=function(e,t,n){return this.getCommandFactory().getCommandFor(e,"Remove",{removedElement:e},t,n)};a.prototype._fireElementModified=function(e){if(e.getCommands().length){this.fireElementModified({command:e})}};a.prototype.handler=function(e){var r=[];var i=new n;function s(e){e.setSelected(true);setTimeout(function(){e.focus()},0)}var l=a._getElementToFocus(e);e.forEach(function(n){var o=this.getResponsibleElementOverlay(n);var a=o.getElement();var s=o.getDesignTimeMetadata();var g=this.getVariantManagementReference(o);var u=this._getConfirmationText(o);r.push(Promise.resolve().then(function(){if(u){return t.openRemoveConfirmationDialog(a,u)}return true}).then(function(e){if(!e){throw Error("Cancelled")}return this._getRemoveCommand(a,s,g)}.bind(this)).then(function(e){i.addCommand(e)}).catch(function(t){if(t&&t.message==="Cancelled"){if(e.length===1){l=n}}else{throw t}}));n.setSelected(false)},this);if(r.length){return Promise.all(r).then(function(){s(l);this._fireElementModified(i)}.bind(this)).catch(function(e){o.error("Error during remove: ",e)})}};a._getElementToFocus=function(e){var t;if(e.length===1){var n=e[0];var i=n.getParent().getAggregation(n.sParentAggregationName);if(i.length>1){var o=i.indexOf(n);var a=i.slice(o+1);if(o!==0){a=a.concat(i.slice(0,o).reverse())}t=a.filter(function(e){return e.getElement().getVisible()}).shift()}}t||=r.getOverlay(e[0].getRelevantContainer());return t};a.prototype.getMenuItems=function(e){return this._getMenuItems(e,{pluginId:"CTX_REMOVE",icon:"sap-icon://less"})};a.prototype.getActionName=function(){return"remove"};return a});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/rta/plugin/Resize", ["sap/base/i18n/Localization","sap/ui/rta/plugin/Plugin","sap/ui/dt/Overlay","sap/ui/dt/OverlayRegistry","sap/ui/dt/util/ZIndexManager","sap/ui/dt/Util"],function(e,t,n,i,r,a){"use strict";var o=t.extend("sap.ui.rta.plugin.Resize",{metadata:{library:"sap.ui.rta",properties:{handle:"object",dragging:"boolean"},associations:{},events:{}}});var s="sapUiRtaResizeHandle";var l="sapUiRtaResizeHandleExtension";var h="sapUiRtaFullScreenDiv";var d=15;var c=e.getRTL();var u=c?-1:1;var v=c?"right":"left";var g=15*u;function m(e){return e.getDomRef().offsetWidth}function f(){this._oFullScreenDiv=document.createElement("div");this._oFullScreenDiv.className=h;this._oFullScreenDiv.style["z-index"]=r.getNextZIndex();var e=n.getOverlayContainer();e.append(this._oFullScreenDiv)}function p(){this._oFullScreenDiv.removeEventListener("mouseup",this._fnOnMouseUp);this._oFullScreenDiv.removeEventListener("mousemove",this._fnOnMouseMove);this._oFullScreenDiv.remove();delete this._oFullScreenDiv}o.prototype._isEditable=function(e){var t=this.getAction(e);if(t&&t.handler){return Promise.resolve(this.hasStableId(e))}return this._checkChangeHandlerAndStableId(e)};o.prototype._createResizeCommand=function(e,t,n){var i=this.getVariantManagementReference(e);return this.getCommandFactory().getCommandFor(t.selectorElement,"resize",t.changeSpecificData,undefined,i).then(function(e){return n.addCommand(e)})};o.prototype._createCompositeCommand=function(e,t,n){var i;return this.getCommandFactory().getCommandFor(t,"composite").then(function(t){i=t;return n.reduce(function(t,n){return t.then(this._createResizeCommand.bind(this,e,n,i))}.bind(this),Promise.resolve())}.bind(this)).then(function(){return i})};o.prototype._createCommand=function(e,t){var n=e.getElement();var i=this.getAction(e);var r=i.handler;return Promise.resolve().then(function(){if(r){var o={newWidth:t};return r(n,o).then(function(t){if(t.length>0){return this._createCompositeCommand(e,n,t)}return undefined}.bind(this)).catch(function(e){throw a.propagateError(e,"Resize#handler","Error occurred during handler execution","sap.ui.rta.plugin")})}return this._createCompositeCommand(e,n,[{changeSpecificData:{changeType:i.changeType,content:{resizedElementId:n.getId(),newWidth:t}},selectorElement:n}])}.bind(this)).then(function(e){if(e&&e.getCommands().length>0){this.fireElementModified({command:e})}}.bind(this))};o.prototype._onHandleMouseDown=function(e,t){this.setBusy(true);if(t.detail===2){this._onDoubleClick(e);this.setBusy(false);return}f.call(this);var n=this.getAction(e);var i=this.getHandle();var r=e.getElement();var a=e.getDomRef();var o=Math.round(a.getBoundingClientRect()[v]);var s=Math.round(i.offsetWidth/2);var h=t.clientX;var d;var c=m(e);i.style[v]=`${(h-o)*u-s}px`;this.setDragging(true);e.focus();this._fnOnMouseMove=y.bind(this);this._fnOnMouseUp=_.bind(this);if(n.getHandleExtensionHeight){var g=n.getHandleExtensionHeight(r);d=document.createElement("div");d.className=l;d.style.height=`${g}px`;d.style["pointer-events"]="none"}function y(t){if(d){i.append(d);i.extension=d}c=(t.clientX-o)*u+s;c=this._limitNewWidth(e,c);i.style[v]=`${c-i.offsetWidth}px`}function _(){this._finalizeResize(e,c);p.call(this);this.setDragging(false);this.setBusy(false)}this._oFullScreenDiv.addEventListener("mousemove",this._fnOnMouseMove);this._oFullScreenDiv.addEventListener("mouseup",this._fnOnMouseUp)};o.prototype._onDoubleClick=function(e){var t=this.getAction(e);if(t.getDoubleClickWidth){var n=t.getDoubleClickWidth(e.getElement());this._finalizeResize(e,n)}};o.prototype._finalizeResize=function(e,t){var n=m(e);if(t===n){return Promise.resolve()}var i=function(){e.setSelected(true);e.focus();e.detachEvent("geometryChanged",i,this);e.attachEvent("geometryChanged",this._onOverlayGeometryChanged,this)};e.detachEvent("geometryChanged",this._onOverlayGeometryChanged,this);e.attachEvent("geometryChanged",i,this);e.setSelected(false);return this._createCommand(e,t).catch(function(e){i.call(this);throw a.propagateError(e,"Resize","Error occurred during resize command creation","sap.ui.rta.plugin")}.bind(this))};o.prototype._limitNewWidth=function(e,t){var n=this.getAction(e);var i=e.getElement();var r=n.getSizeLimits&&n.getSizeLimits(i);var a=r&&r.minimumWidth||d;var o=r&&r.maximumWidth;if(a&&t<a){t=a}if(o&&t>o){t=o}return t};o.prototype._createHandle=function(e){var t=this.getHandle();var n=i.getOverlay(e.target.id);if(!this.isEnabled([n])){this._removeHandle(false);return}if(!t&&!this.getDragging()){var a=n.getDomRef();var o=document.createElement("div");o.className=s;a.append(o);o.style[v]=`${a.clientWidth-o.clientWidth}px`;o.style["z-index"]=r.getNextZIndex();o.addEventListener("mousedown",this._onHandleMouseDown.bind(this,n));this.setHandle(o)}};o.prototype._removeHandle=function(e){var t=this.getHandle();if(t&&(e||!this.getDragging())){t.remove();this.setDragging(false);this.setHandle(null)}};o.prototype._onOverlayMouseMove=function(e){var t=i.getOverlay(e.target.id);if(t&&t.isSelectable()){this._createHandle(e)}};o.prototype._onOverlayKeyDown=function(e){var t=i.getOverlay(e.target.id);var n;if(e.key==="Escape"){this._removeHandle(true);if(this._oFullScreenDiv){p.call(this)}e.stopImmediatePropagation();return}if(!e.shiftKey||e.ctrlKey||e.metaKey||e.altKey){return}var r=m(t);if(e.key==="ArrowLeft"||e.key==="ArrowRight"){var a=e.key==="ArrowLeft"?g*-1:g;n=this._limitNewWidth(t,r+a);this._finalizeResize(t,n)}};o.prototype._onOverlayMouseLeave=function(){this._removeHandle(false)};o.prototype._onOverlaySelectionChange=function(e){if(e.getParameter("selected")){this._removeHandle(false);e.target={id:e.getParameter("id")};this._createHandle(e)}else{this._removeHandle()}};o.prototype._onOverlayFocus=function(e){var t=i.getOverlay(e.target.id);if(t.getSelected()&&!this.getHandle()){this._createHandle(e)}};o.prototype._onOverlayGeometryChanged=function(e){var t=i.getOverlay(e.getParameter("id"));if(t.getSelected()&&t.hasFocus()){this._removeHandle();this._createHandle(e)}};o.prototype.registerElementOverlay=function(...e){const[n]=e;if(this.isEnabled([n])){n.attachBrowserEvent("mousemove",this._onOverlayMouseMove,this);n.attachBrowserEvent("mouseleave",this._onOverlayMouseLeave,this);n.attachBrowserEvent("keydown",this._onOverlayKeyDown,this);n.attachBrowserEvent("focus",this._onOverlayFocus,this);n.attachEvent("selectionChange",this._onOverlaySelectionChange,this);n.attachEvent("geometryChanged",this._onOverlayGeometryChanged,this)}t.prototype.registerElementOverlay.apply(this,e)};o.prototype.deregisterElementOverlay=function(...e){const[n]=e;n.detachBrowserEvent("mousemove",this._onOverlayMouseMove,this);n.detachBrowserEvent("mouseleave",this._onOverlayMouseLeave,this);n.detachBrowserEvent("keydown",this._onOverlayKeyDown,this);n.detachBrowserEvent("focus",this._onOverlayFocus,this);n.detachEvent("selectionChange",this._onOverlaySelectionChange,this);n.detachEvent("geometryChanged",this._onOverlayGeometryChanged,this);t.prototype.deregisterElementOverlay.apply(this,e)};o.prototype.getActionName=function(){return"resize"};return o});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/rta/plugin/Selection", ["sap/m/InstanceManager","sap/ui/core/Element","sap/ui/dt/OverlayRegistry","sap/ui/dt/OverlayUtil","sap/ui/events/KeyCodes","sap/ui/rta/plugin/Plugin","sap/ui/rta/Utils"],function(e,t,i,r,a,s,n){"use strict";var o=s.extend("sap.ui.rta.plugin.Selection",{metadata:{library:"sap.ui.rta",properties:{multiSelectionRequiredPlugins:{type:"string[]"},isActive:{type:"boolean",defaultValue:true}},associations:{},events:{elementEditableChange:{parameters:{editable:{type:"boolean"}}}}}});function l(e){e.preventDefault();e.stopPropagation()}function u(e,t){var i=t.slice();e.forEach(function(e){i=i.filter(function(t){return e.getEditableByPlugins()[t]})});return i.length>0}function c(e){return e.every(function(t){return t.getRelevantContainer()===e[0].getRelevantContainer()})}function v(e){return e.every(function(t){return t.getParentElementOverlay()===e[0].getParentElementOverlay()})}function g(e){return e.every(function(t){return t.getElement().getMetadata().getName()===e[0].getElement().getMetadata().getName()})}o.prototype.init=function(...e){this._multiSelectionValidator=this._multiSelectionValidator.bind(this);s.prototype.init.apply(this,e)};o.prototype._checkDeveloperMode=function(e,t){if(t){var i=this.getCommandFactory().getFlexSettings().developerMode;if(i&&this.hasStableId(e)){e.setEditable(true);e.setSelectable(true);this.fireElementEditableChange({editable:true});return true}}return false};o.prototype.setIsActive=function(e){this.setProperty("isActive",e);if(e===false){this._deselectOverlays()}};o.prototype.registerElementOverlay=function(e){var t=e.getDesignTimeMetadata();if(!t.markedAsNotAdaptable()&&!this._checkDeveloperMode(e,t)){e.attachEditableChange(this._onEditableChange,this);this._adaptSelectable(e)}e.attachBrowserEvent("click",this._selectOverlay,this);e.attachBrowserEvent("contextmenu",this._selectOverlay,this);e.attachBrowserEvent("keydown",this._onKeyDown,this);e.attachBrowserEvent("mousedown",this._onMouseDown,this);e.attachBrowserEvent("mouseover",this._onMouseover,this);e.attachBrowserEvent("mouseleave",this._onMouseleave,this)};o.prototype._onEditableChange=function(e){var t=e.getSource();this._adaptSelectable(t)};o.prototype._adaptSelectable=function(e){var t=e.getEditable();if(e.getSelectable()!==t){e.setSelectable(t);if(!t){this._removePreviousHover()}this.fireElementEditableChange({editable:t})}};o.prototype.deregisterElementOverlay=function(e){e.detachBrowserEvent("click",this._selectOverlay,this);e.detachBrowserEvent("contextmenu",this._selectOverlay,this);e.detachBrowserEvent("keydown",this._onKeyDown,this);e.detachBrowserEvent("mousedown",this._onMouseDown,this);e.detachBrowserEvent("mouseover",this._onMouseover,this);e.detachBrowserEvent("mouseleave",this._onMouseleave,this);e.detachEditableChange(this._onEditableChange,this)};o.prototype._setFocusOnOverlay=function(e,t){if(e&&e.getSelectable()){e.focus();t.stopPropagation()}};o.prototype._getFocusedOverlay=function(){if(document.activeElement){var e=t.getElementById(document.activeElement.id);if(e&&e.isA("sap.ui.dt.ElementOverlay")){return e}}return undefined};o.prototype._onKeyDown=function(e){if(!this.getIsActive()){return}var t=this._getFocusedOverlay();if(e.keyCode===a.ENTER){this._selectOverlay(e)}else if(e.keyCode===a.ARROW_UP&&e.shiftKey===false&&e.altKey===false){if(t){var i=n.getFocusableParentOverlay(t);this._setFocusOnOverlay(i,e);e.preventDefault()}}else if(e.keyCode===a.ARROW_DOWN&&e.shiftKey===false&&e.altKey===false){if(t){var r=n.getFirstFocusableDescendantOverlay(t);this._setFocusOnOverlay(r,e);e.preventDefault()}}else if(e.keyCode===a.ARROW_LEFT&&e.shiftKey===false&&e.altKey===false){if(t){var s=n.getPreviousFocusableSiblingOverlay(t);this._setFocusOnOverlay(s,e);e.preventDefault()}}else if(e.keyCode===a.ARROW_RIGHT&&e.shiftKey===false&&e.altKey===false){if(t){var o=n.getNextFocusableSiblingOverlay(t);this._setFocusOnOverlay(o,e);e.preventDefault()}}else if(e.keyCode===a.ESCAPE){if(t){this._deselectOverlays()}}};o.prototype._deselectOverlays=function(){this.getDesignTime().getSelectionManager().reset()};o.prototype._selectOverlay=function(e){var t=i.getOverlay(e.currentTarget.id);if(!this.getIsActive()){if(t.isRoot()){l(e)}return}var r=e.metaKey||e.ctrlKey||e.shiftKey;var a=e.type==="contextmenu";if(t&&t.getSelectable()){if(t.isSelected()){if(!a){this.getDesignTime().getSelectionManager().remove(t)}}else if(r){this.getDesignTime().getSelectionManager().add(t)}else{this.getDesignTime().getSelectionManager().set(t)}l(e)}else if(t&&t.isRoot()){l(e)}};o.prototype._onMouseDown=function(t){if(!this.getIsActive()){var r=i.getOverlay(t.currentTarget.id);if(r.isRoot()){l(t)}e.getOpenPopovers().forEach(function(e){if(e._bOpenedByChangeIndicator){e.close()}});return}};o.prototype._onMouseover=function(e){var t=i.getOverlay(e.currentTarget.id);if(!this.getIsActive()||this.getDesignTime()&&this.getDesignTime().getBusyPlugins().length){if(t.isRoot()){l(e)}return}if(t.isSelectable()){r.setFirstParentMovable(t,false);if(t!==this._oHoverTarget){this._removePreviousHover();this._oHoverTarget=t;this.getDesignTime().getSelectionManager().addHover(t)}l(e)}};o.prototype._onMouseleave=function(e){var t=i.getOverlay(e.currentTarget.id);if(!this.getIsActive()){if(t.isRoot()){l(e)}return}if(t.isSelectable()){r.setFirstParentMovable(t,true);this._removePreviousHover();l(e)}};o.prototype._removePreviousHover=function(){if(this._oHoverTarget){this.getDesignTime().getSelectionManager().removeHover(this._oHoverTarget)}delete this._oHoverTarget};o.prototype.setDesignTime=function(...e){if(this.getDesignTime()){this.getDesignTime().getSelectionManager().removeValidator(this._multiSelectionValidator)}s.prototype.setDesignTime.apply(this,e);if(this.getDesignTime()){this.getDesignTime().getSelectionManager().addValidator(this._multiSelectionValidator)}};o.prototype._multiSelectionValidator=function(e){return e.length===1||u(e,this.getMultiSelectionRequiredPlugins())&&c(e)&&(v(e)||g(e))};return o});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/rta/plugin/Settings", ["sap/base/Log","sap/ui/dt/OverlayRegistry","sap/ui/dt/Util","sap/ui/fl/Utils","sap/ui/rta/plugin/Plugin","sap/ui/rta/Utils"],function(e,t,n,i,a,o){"use strict";const r=a.extend("sap.ui.rta.plugin.Settings",{metadata:{library:"sap.ui.rta",associations:{},events:{}}});const s="CTX_SETTINGS";function c(t,n){if(t.handler){return[t]}const i=[];Object.keys(t).forEach(a=>{let o=t[a];if(typeof o==="function"){o=o(n.getElement())}if(o.handler){o.key=a;i.push(o)}else{e.warning("Handler not found for settings action")}});return i}r.prototype._isEditable=function(e){const t=this.getAction(e);if(t){const n=c(t,e);return n.some(t=>this._checkRelevantContainerStableID(t,e))}return false};r.prototype.isEnabled=function(e){const t=e[0];const n=this.getResponsibleElementOverlay(t);const i=this.getAction(n);if(i){const e=c(i,n);return e.some(e=>{if(typeof e.isEnabled!=="undefined"){if(typeof e.isEnabled==="function"){return e.isEnabled(n.getElement())}return e.isEnabled}return!!e.handler})}return false};r.prototype._getUnsavedChanges=function(e,t){let n;const i=this.getCommandStack().getAllExecutedCommands().filter(function(i){n=i.getElementId&&i.getElementId()||i.getElement&&i.getElement().getId();return n===e&&t.indexOf(i.getChangeType())>=0}).map(function(e){return e.getPreparedChange()});return i};r.prototype._handleFlexChangeCommand=function(e,t,n,i){const a=e.changeSpecificData;let o;const r=e.selectorElement||e.selectorControl;let s;let c;if(r.controlType){s=r.controlType}else{c=r}return this.hasChangeHandler(a.changeType,c,s).then(function(e){if(t[0].getVariantManagement&&e&&!i.CAUTION_variantIndependent){o=t[0].getVariantManagement()}return this.getCommandFactory().getCommandFor(r,"settings",a,undefined,o)}.bind(this)).then(function(e){const t=i.runtimeOnly;if(e&&t){e.setRuntimeOnly(t)}return n.addCommand(e)})};r.prototype._handleManifestChangeCommand=function(e,t,n){const i=e.changeSpecificData;const a=e.appComponent;const o=a.getManifest();const r=o["sap.app"].id;return this.getCommandFactory().getCommandFor(t,"manifest",{reference:r,appComponent:a,changeType:i.appDescriptorChangeType,parameters:i.content.parameters,texts:i.content.texts}).then(function(e){return n.addCommand(e)})};r.prototype._handleCompositeCommand=function(e,t,n,a){let o;return this.getCommandFactory().getCommandFor(t,"composite").then(function(e){o=e}).then(function(){return n.map(function(n){const i=n.changeSpecificData;if(i.changeType){return()=>this._handleFlexChangeCommand(n,e,o,a)}else if(i.appDescriptorChangeType){return()=>this._handleManifestChangeCommand(n,t,o)}return undefined},this)}.bind(this)).then(function(e){return i.execPromiseQueueSequentially(e)}).then(function(){if(o.getCommands().length>0){this.fireElementModified({command:o})}}.bind(this))};r.prototype.handler=function(e,t,i){t||={};const a=e[0].getElement();let{fnHandler:r}=t;r||=e[0].getDesignTimeMetadata().getAction("settings").handler;if(!r){throw new Error("Handler not found for settings action")}t.getUnsavedChanges=this._getUnsavedChanges.bind(this);t.styleClass=o.getRtaStyleClassName();return r(a,t).then(function(t){if(t.length>0){return this._handleCompositeCommand(e,a,t,i)}return undefined}.bind(this)).catch(function(e){throw n.propagateError(e,"Settings#handler","Error occurred during handler execution","sap.ui.rta.plugin")})};r.prototype.getMenuItems=async function(t){const n=t[0];const i=this.getResponsibleElementOverlay(n);const a=this.getAction(i);const o=[];if(a){const t=this.getRank("CTX_SETTINGS");const n=c(a,i);if(this._isEditableByPlugin(i)===undefined){await this.evaluateEditable([i],{onRegistration:false})}n.forEach(function(n,a,r){if(this._checkRelevantContainerStableID(n,i)&&this.isAvailable([i])){const e=r.length===1;o.push({id:e?s:s+a,additionalInfo:this._getAdditionalInfo(i,n),rank:e?t:t+a,text:this.getActionText(i,n,s),icon:u(n),enabled:typeof n.isEnabled==="function"&&function(e){return n.isEnabled(e[0].getElement())}||n.isEnabled||this.isEnabled([i]),handler:function(e,t,i){i||={};i.fnHandler=e;return this.handler(t,i,n)}.bind(this,n.handler),submenu:l(n.submenu)})}else{e.warning("Action is not available or relevant container has no stable id")}},this)}return o};function l(e){if(e){return e.map(function(e,t){return{id:e.key||`${s}_SUB_${t}`,icon:e.icon||"blank",text:e.name||"",enabled:e.hasOwnProperty("enabled")?e.enabled:true}})}return undefined}function u(t){const n="sap-icon://key-user-settings";const i=t.icon;if(!i){return n}if(typeof i!=="string"){e.error("Icon setting for settingsAction should be a string");return n}return i}r.prototype.getActionName=function(){return"settings"};return r});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/rta/plugin/Split", ["sap/ui/rta/plugin/Plugin","sap/ui/dt/Util","sap/ui/fl/Utils","sap/base/util/uid"],function(t,e,n,i){"use strict";var r=t.extend("sap.ui.rta.plugin.Split",{metadata:{library:"sap.ui.rta",properties:{},associations:{},events:{}}});r.prototype._isEditable=function(t){var e=this.getAction(t);if(e&&e.changeOnRelevantContainer){return this._checkChangeHandlerAndStableId(t)}return Promise.resolve(false)};r.prototype.isAvailable=function(t){if(t.length!==1){return false}var e=t[0];if(!this._isEditableByPlugin(e)){return false}var n=this.getAction(e);var i=e.getElement();if(n&&n.getControlsCount(i)<=1){return false}return true};r.prototype.isEnabled=function(t){var e=t[0];var n=this.getAction(e);if(!n||!this.isAvailable(t)){return false}var i=true;if(typeof n.isEnabled!=="undefined"){if(typeof n.isEnabled==="function"){i=n.isEnabled(e.getElement())}else{i=n.isEnabled}}return i};r.prototype.handleSplit=function(t){var r=t.getElement();var a=r.getParent();var o=t.getDesignTimeMetadata();var s=this.getAction(t).getControlsCount(r);var l=n.getViewForControl(r);var u=[];for(var p=0;p<s;p++){u.push(l.createId(i()))}var c=this.getAction(t);var d=this.getVariantManagementReference(t,c);return this.getCommandFactory().getCommandFor(r,"split",{newElementIds:u,source:r,parentElement:a},o,d).then(function(t){this.fireElementModified({command:t})}.bind(this)).catch(function(t){throw e.propagateError(t,"Split#handleSplit","Error occurred during handleSplit execution","sap.ui.rta.plugin")})};r.prototype.getMenuItems=function(t){return this._getMenuItems(t,{pluginId:"CTX_UNGROUP_FIELDS",icon:"sap-icon://split"})};r.prototype.getActionName=function(){return"split"};r.prototype.handler=function(t){this.handleSplit(t[0])};return r});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/rta/plugin/Stretch", ["sap/ui/rta/plugin/Plugin","sap/ui/dt/OverlayRegistry","sap/ui/dt/OverlayUtil","sap/base/util/restricted/_debounce"],function(e,t,n,i){"use strict";var r=e.extend("sap.ui.rta.plugin.Stretch",{metadata:{library:"sap.ui.rta",properties:{},associations:{stretchCandidates:{type:"sap.ui.core.Control",multiple:true}},events:{}}});r.STRETCHSTYLECLASS="sapUiRtaStretchPaddingTop";function a(e,t){return e&&e.getGeometry()&&t.getGeometry()&&e.getGeometry().position.top===t.getGeometry().position.top&&e.getGeometry().position.left===t.getGeometry().position.left}function s(e,t){var n=e.getElement();if(n.addStyleClass&&n.removeStyleClass){if(t){n.addStyleClass(r.STRETCHSTYLECLASS)}else{n.removeStyleClass(r.STRETCHSTYLECLASS)}}else{var i=e.getAssociatedDomRef();if(i){if(t){i.classList.add(r.STRETCHSTYLECLASS)}else{i.classList.remove(r.STRETCHSTYLECLASS)}}}}function l(e,t,i){var r=e.getGeometry();if(!r){return false}var a=r.size.height;if(i){a-=parseInt(window.getComputedStyle(r.domRef,null).getPropertyValue("padding-top"))}var s=Math.round(r.size.width)*Math.round(a);t||=n.getAllChildOverlays(e);var l=t.map(function(e){return e.getGeometry()});var o=n.getGeometry(l);if(!o){return false}var d=Math.round(o.size.width)*Math.round(o.size.height);return d===s}function o(e,t){var i=t.some(function(e){return e.getEditable()&&e.getGeometry()});if(i){return true}var r=[];t.forEach(function(e){r=r.concat(n.getAllChildOverlays(e))});if(!r.length){return false}if(l(e,r)){return o(e,r)}return false}r.prototype.setDesignTime=function(...t){const[n]=t;e.prototype.setDesignTime.apply(this,t);if(n){n.attachEventOnce("synced",this._onDTSynced,this)}};r.prototype.exit=function(){if(this.getDesignTime()){this.getDesignTime().detachEvent("elementOverlayAdded",this._onElementOverlayChanged);this.getDesignTime().detachEvent("elementOverlayMoved",this._onElementOverlayChanged);this.getDesignTime().detachEvent("elementPropertyChanged",this._onElementPropertyChanged);this.getDesignTime().detachEvent("elementOverlayEditableChanged",this._onElementOverlayEditableChanged);this.getDesignTime().detachEvent("elementOverlayDestroyed",this._onElementOverlayDestroyed)}};r.prototype.addStretchCandidate=function(e){var t=e.getElement();if(!this.getStretchCandidates().includes(t.getId())){this.addAssociation("stretchCandidates",t)}};r.prototype.removeStretchCandidate=function(e){this.removeAssociation("stretchCandidates",e.getElement());s(e,false)};r.prototype.registerElementOverlay=function(...t){const[n]=t;this._checkParentAndAddToStretchCandidates(n);n.attachElementModified(this._onElementModified,this);e.prototype.registerElementOverlay.apply(this,t)};r.prototype.deregisterElementOverlay=function(...t){const[n]=t;s(n,false);e.prototype.deregisterElementOverlay.apply(this,t)};r.prototype._isEditable=function(){return false};r.prototype._onDTSynced=function(){this._setStyleClassForAllStretchCandidates();this.getDesignTime().attachEvent("elementOverlayAdded",this._onElementOverlayChanged,this);this.getDesignTime().attachEvent("elementOverlayMoved",this._onElementOverlayChanged,this);this.getDesignTime().attachEvent("elementPropertyChanged",this._onElementPropertyChanged,this);this.getDesignTime().attachEvent("elementOverlayEditableChanged",this._onElementOverlayEditableChanged,this);this.getDesignTime().attachEvent("elementOverlayDestroyed",this._onElementOverlayDestroyed,this)};r.prototype._onElementModified=function(e){if(this.getDesignTime().getBusyPlugins().length){return}var t=e.getParameters();var n=e.getSource();if(t.type==="afterRendering"){this.fnDebounced||=i(function(){this._setStyleClassForAllStretchCandidates(this._getNewStretchCandidates(this._aOverlaysCollected));this._aOverlaysCollected=[];this.fnDebounced=undefined}.bind(this),16);this._aOverlaysCollected||=[];if(!this._aOverlaysCollected.includes(n)){this._aOverlaysCollected.push(n);this.fnDebounced()}}};r.prototype._onElementOverlayDestroyed=function(e){if(this.getDesignTime().getBusyPlugins().length){return}var t=[];var n=e.getParameters().elementOverlay.getParentElementOverlay();if(n&&!n._bIsBeingDestroyed){var i=this._getRelevantOverlays(n).filter(function(e){return e.getElement()});t=this._getNewStretchCandidates(i)}this._setStyleClassForAllStretchCandidates(t)};r.prototype._onElementOverlayEditableChanged=function(e){var n=t.getOverlay(e.getParameters().id);if(this.getDesignTime().getBusyPlugins().length||!n){return}var i=this._getRelevantOverlaysOnEditableChange(n);this._setStyleClassForAllStretchCandidates(i)};r.prototype._onElementPropertyChanged=function(e){var n=t.getOverlay(e.getParameters().id);if(this.getDesignTime().getBusyPlugins().length||!n){return}var r=this._getRelevantOverlays(n);var a=i(function(){if(!this.bIsDestroyed&&!n.bIsDestroyed){var e=this._getNewStretchCandidates(r).concat(this._getRelevantOverlaysOnEditableChange(n));e=e.filter(function(e,t,n){return n.indexOf(e)===t});this._setStyleClassForAllStretchCandidates(e)}}.bind(this));r.forEach(function(e){e.attachEventOnce("geometryChanged",a)})};r.prototype._onElementOverlayChanged=function(e){var n=t.getOverlay(e.getParameters().id);if(this.getDesignTime().getBusyPlugins().length||!n){return}var i=this._getRelevantOverlays(n);var r=this._getNewStretchCandidates(i);this._setStyleClassForAllStretchCandidates(r)};r.prototype._getRelevantOverlaysOnEditableChange=function(e){var t=this.getStretchCandidates().includes(e.getElement().getId())?[e.getElement().getId()]:[];var n=e.getParentAggregationOverlay();if(!n){return t}var i=n.getChildren();i.splice(i.indexOf(e),1);var r=i.some(function(e){return e.getEditable()&&e.getGeometry()});if(r){return t}return t.concat(this._getRelevantParents(e))};r.prototype._getRelevantParents=function(e){var t=[];for(var n=0;n<25;n++){e=e.getParentElementOverlay();if(!e){return t}if(!this.getStretchCandidates().includes(e.getElement().getId())){return t}t.push(e.getElement().getId())}return t};r.prototype._getNewStretchCandidates=function(e){var t=[];e.forEach(function(e){if(this._reevaluateStretching(e)){t.push(e.getElement().getId())}},this);return t};r.prototype._reevaluateStretching=function(e){if(!e.bIsDestroyed){var t=Array.isArray(e.getAssociatedDomRef())?e.getAssociatedDomRef()[0]:e.getAssociatedDomRef();if(t){var n=t.classList.contains(r.STRETCHSTYLECLASS);var i=l(e,undefined,n);if(n&&!i){this.removeStretchCandidate(e)}else if(!n&&i){this.addStretchCandidate(e);return true}}}return false};r.prototype._checkParentAndAddToStretchCandidates=function(e){var t=e.getParentElementOverlay();var n=t?.getAssociatedDomRef();if(n){if(a(t,e)){if(l(t)){this.addStretchCandidate(t)}}}};r.prototype._setStyleClassForAllStretchCandidates=function(e){if(!Array.isArray(e)){e=this.getStretchCandidates()}e.forEach(function(e){var i=t.getOverlay(e);var r=n.getAllChildOverlays(i);var a=i.getEditable()&&o(i,r);s(i,a)},this)};return r});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/rta/plugin/additionalElements/ActionExtractor", ["sap/base/util/merge","sap/base/Log","sap/ui/core/util/reflection/JsControlTreeModifier","sap/ui/core/Lib","sap/ui/dt/ElementUtil","sap/ui/dt/OverlayRegistry","sap/ui/fl/apply/api/DelegateMediatorAPI","sap/ui/rta/plugin/additionalElements/AdditionalElementsUtils","sap/ui/rta/Utils"],function(e,t,n,a,r,i,o,l,s){"use strict";const c={};async function g(e,t,n){const a=await n.hasChangeHandler(e.changeType,e.element);if(a){return{aggregationName:e.aggregation,addPropertyActionData:{designTimeMetadata:t,action:e,delegateInfo:{payload:e.delegateInfo.payload||{},delegate:e.delegateInfo.instance,modelType:e.delegateInfo.modelType,requiredLibraries:e.delegateInfo.requiredLibraries,delegateType:e.delegateInfo.delegateType}}}}return undefined}function u(e,t,n){const a=e.getElement();if(!a){return[]}const o=r.getAggregation(a,t,n).filter(function(t){const a=i.getOverlay(t);if(!n.hasStableId(a)){return false}const r=e.getRelevantContainer(true);const o=i.getOverlay(r);let l=e;let s=false;do{s=!l.getElementVisibility();if(s){break}if(l===o){break}else{l=l.getParentElementOverlay()}}while(l);if(s){return true}return a.getElementVisibility()===false},this);return o.map(function(e){return{element:e,sourceAggregation:t}})}function d(e,t){return t.sParentAggregationName}function f(e,t,n,a){let r=n.changeType&&a.hasStableId(e);if(r&&e!==t.relevantContainerOverlay){r=a.hasStableId(t.relevantContainerOverlay)}return r}async function m(e,t,n,a,r){const i=e.reduce(function(e,t){let n=[];a.forEach(function(e){n=n.concat(u.call(this,t,e,r))}.bind(this),[]);return t?e.concat(n):e}.bind(this),[]);let o={elements:[],controlTypeNames:[]};for(const e of i){o=await h(o,e,r,n)}if(o.elements.length>0){t[n]={reveal:o}}return t}function y(e,t,n){return e.filter(e=>{const a=e.changeOnRelevantContainer?t.relevantContainer:t.parent;const r=i.getOverlay(a);return f(r,t,e,n)})}async function p(e){const n=Object.keys(e||{});try{for(const e of n){await a.load({name:e})}return true}catch(e){t.error("Required library not available: ",e);return false}}function v(e,t){const a=e.reduce(async function(e,a){const r=await e;const i=a.changeOnRelevantContainer?t.relevantContainer:t.parent;const l=await o.getReadDelegateForControl({control:i,modifier:n});const s=await o.getWriteDelegateForControl({control:i,modifier:n});const c=await p(s?.requiredLibraries);if(l?.instance&&s?.controlType&&c){a.element=i;a.delegateInfo=l;a.delegateInfo.requiredLibraries=s.requiredLibraries;r.push(a)}return r},Promise.resolve([]));return a}async function h(e,t,n,a){const o=i.getOverlay(t.element);if(o){const i=o.getDesignTimeMetadata();const c=i&&i.getAction("reveal",t.element);if(c&&c.changeType){let g=t.element;if(c.changeOnRelevantContainer){g=o.getRelevantContainer()}if(r.isElementValid(t.element)){const r=l.getParents(true,o,n);const u=await n.hasChangeHandler(c.changeType,g);if(u){let l=c.changeOnRelevantContainer?n.hasStableId(r.relevantContainerOverlay)&&n.hasStableId(r.parentOverlay):true;c.getAggregationName||=d;if(l&&t.sourceAggregation!==a){const e=r.parentOverlay.getAggregationOverlay(a);l=await s.checkTargetZone(e,o,n)}if(l){e.elements.push({element:t.element,designTimeMetadata:i,action:c,sourceAggregation:t.sourceAggregation,targetAggregation:a});const n=i.getName(t.element);if(n){e.controlTypeNames.push(n)}}}}}}return e}c.getActions=async function(t,n,a,r,i){const o=t?"asSibling":"asChild";if(!r&&n._mAddActions){return n._mAddActions[o]}const[l,s]=await Promise.all([this._getRevealActions(t,n,a,i),this._getAddViaDelegateActions(t,n,a)]);const c=e(l,s);n._mAddActions||={asSibling:{},asChild:{}};n._mAddActions[o]=c;return c};c.getActionsOrUndef=function(e,t){const n=e?"asSibling":"asChild";return t._mAddActions&&t._mAddActions[n]};let A={};let b=true;c._getRevealActions=async function(e,t,n,a){if(b){b=false;a.attachEventOnce("synced",function(){A={};b=true},this)}const o=l.getParents(e,t,n);let s=[o.parentOverlay];if(o.relevantContainer!==o.parent){s=r.findAllSiblingsInContainer(o.parent,o.relevantContainer).map(function(e){return i.getOverlay(e)}).filter(function(e){return e})}let c=[];if(o.parentOverlay){const t=A[o.parentOverlay.getId()];if(t&&e){return t}c=o.parentOverlay.getChildren().filter(function(e){return!e.getDesignTimeMetadata().isIgnored(o.parent)}).map(function(e){return e.getAggregationName()});const a=await c.reduce(function(e,t){return e.then(function(e){return m(s,e,t,c,n)})},Promise.resolve({}));if(e){A[o.parentOverlay.getId()]=a}return a}return{}};c._getAddViaDelegateActions=async function(e,t,n){const a=l.getParents(e,t,n);const r=a.parentOverlay&&a.parentOverlay.getDesignTimeMetadata();let i=r?await r.getActionDataFromAggregations("add",a.parent,undefined,"delegate"):[];i=await y(i,a,n);i=await v(i,a);return i.reduce(async function(e,t){const i=await e;const o=await g.call(this,t,r,n);if(o){o.addPropertyActionData.relevantContainer=a.relevantContainer;i[o.aggregationName]||={};i[o.aggregationName].addViaDelegate=o.addPropertyActionData}return i}.bind(this),Promise.resolve({}))};return c});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/rta/plugin/additionalElements/AddElementsDialog", ["sap/ui/base/ManagedObject","sap/ui/core/Element","sap/ui/core/Fragment","sap/ui/model/json/JSONModel","sap/ui/model/Filter","sap/ui/model/FilterOperator","sap/ui/model/resource/ResourceModel","sap/ui/model/Sorter","sap/ui/rta/Utils"],function(t,e,i,o,s,n,l,r,a){"use strict";const u=t.extend("sap.ui.rta.plugin.additionalElements.AddElementsDialog",{metadata:{library:"sap.ui.rta",properties:{businessContextVisible:{type:"boolean",defaultValue:false},title:{type:"string"}},events:{opened:{},triggerExtensibilityAction:{}}}});let p;u.prototype.init=function(){this._oDialogPromise=i.load({id:this.getId(),name:"sap.ui.rta.plugin.additionalElements.AddElementsDialog",controller:this});this._oDialogModel=new o({elements:[],customFieldButtonText:"",customFieldButtonVisible:false,businessContextVisible:false,customFieldButtonTooltip:"",businessContextTexts:[{text:""}],extensibilityMenuButtonActive:false,extensibilityMenuButtonText:"",extensibilityMenuButtonTooltip:"",extensibilityOptions:[]});this._oDialogPromise.then(function(t){t.setModel(this._oDialogModel);p||=new l({bundleName:"sap.ui.rta.messagebundle"});t.setModel(p,"i18n");t.addStyleClass(a.getRtaStyleClassName());this._oDialogModel.setProperty("/listNoDataText",p.getProperty("MSG_NO_FIELDS").toLowerCase());this._oList=e.getElementById(`${this.getId()}--rta_addElementsDialogList`);this._bDescendingSortOrder=false}.bind(this))};u.prototype.exit=function(...e){this._oDialogPromise.then(function(t){t.destroy()});if(t.prototype.exit){t.prototype.exit.apply(this,e)}};u.prototype.setCustomFieldButtonVisible=function(t){this._oDialogModel.setProperty("/customFieldButtonVisible",t)};u.prototype.getCustomFieldButtonVisible=function(){return this._oDialogModel.getProperty("/customFieldButtonVisible")};u.prototype._submitDialog=async function(){const t=await this._oDialogPromise;t.close();this._fnResolveOnDialogConfirm()};u.prototype._cancelDialog=function(){this._oDialogModel.getObject("/elements").forEach(function(t){t.selected=false});this._oDialogPromise.then(function(t){t.close()});this._fnRejectOnDialogCancel()};u.prototype.setElements=function(t){this._oDialogModel.setProperty("/elements",t)};u.prototype.getElements=function(){return this._oDialogModel.getProperty("/elements")};u.prototype.getSelectedElements=function(){return this._oDialogModel.getObject("/elements").filter(function(t){return t.selected})};u.prototype.open=function(){return new Promise(function(t,e){this._fnResolveOnDialogConfirm=t;this._fnRejectOnDialogCancel=e;this._oDialogPromise.then(function(t){t.attachAfterOpen(function(){this.fireOpened()}.bind(this));t.open()}.bind(this))}.bind(this))};u.prototype._resortList=function(){this._bDescendingSortOrder=!this._bDescendingSortOrder;const t=this._oList.getBinding("items");const e=[];e.push(new r("label",this._bDescendingSortOrder));t.sort(e)};u.prototype._updateModelFilter=function(t){const e=t.getParameter("newValue");const i=this._oList.getBinding("items");if(typeof e==="string"){const t=new s("label",n.Contains,e);const o=new s("originalLabel",n.Contains,e);const l=new s("parentPropertyName",n.Contains,e);const r=new s("duplicateName",n.EQ,true);const a=new s({filters:[l,r],and:true});const u=new s({filters:[t,o,a],and:false});i.filter([u])}else{i.filter([])}};u.prototype._redirectToExtensibilityAction=function(t){this.fireTriggerExtensibilityAction({actionKey:t});this._oDialogPromise.then(function(t){t.close()})};u.prototype.setTitle=async function(e){t.prototype.setProperty.call(this,"title",e,true);const i=await this._oDialogPromise;i.setTitle(e)};u.prototype.setExtensibilityOptions=function(t){const e=t.UITexts.options;this._oDialogModel.setProperty("/extensibilityOptions",e);if(e.length===1){this._oDialogModel.setProperty("/customFieldButtonText",e[0].text);if(e[0]?.tooltip){this._oDialogModel.setProperty("/customFieldButtonTooltip",e[0].tooltip)}this.setCustomFieldButtonVisible(true)}else{this._oDialogModel.setProperty("/extensibilityMenuButtonActive",true);this._oDialogModel.setProperty("/extensibilityMenuButtonText",t.UITexts.buttonText);this._oDialogModel.setProperty("/extensibilityMenuButtonTooltip",t.UITexts.tooltip)}};u.prototype.getExtensibilityOptions=function(){return this._oDialogModel.getProperty("/extensibilityOptions")};u.prototype._setBusinessContextVisible=function(t){this.setProperty("businessContextVisible",t,true);this._oDialogModel.setProperty("/businessContextVisible",t)};u.prototype.addExtensibilityInfo=function(t){const e=t?.extensionData;this._removeExtensionDataTexts();const i=this._oDialogModel.getObject("/businessContextTexts");if(e&&e.length>0){e.forEach(function(t){i.push({text:t.description})},this)}else{i.push({text:p.getProperty("MSG_NO_BUSINESS_CONTEXTS")})}this._setBusinessContextVisible(true);this._oDialogModel.setProperty("/businessContextTexts/0/text",t?.UITexts?.headerText)};u.prototype._removeExtensionDataTexts=function(){const t=this._oDialogModel.getObject("/businessContextTexts");t.splice(1)};return u});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/rta/plugin/additionalElements/AdditionalElementsAnalyzer", ["sap/base/util/isPlainObject","sap/base/util/ObjectPath","sap/ui/core/util/reflection/JsControlTreeModifier","sap/ui/dt/ElementUtil","sap/ui/fl/apply/api/DelegateMediatorAPI","sap/ui/rta/util/BindingsExtractor"],function(e,t,n,a,r,i){"use strict";function o(e,t,n){if(!e){return false}const a=e.getBindingInfo(t,n);let r=a&&a.path;if(!r){return false}if(r.indexOf(">")>-1){r=r.split(">").pop()}return r.indexOf("/")===0}function l(e,t,n,a){let r;if(t){r=e.getBindingInfo(n,a);if(typeof r.model==="string"&&r.model!==a){r=undefined}}else{r=e.getBindingContext(a)}return r}function u(e,t,n){const a=o(e,t,n);const r=l(e,a,t,n);if(r){return a?r.path:r.getPath()}}function c(e){const t=e.reduce(function(e,t){if(Array.isArray(t.properties)){e=e.concat(t.properties.map(function(e){e.parentPropertyName=t.label||t.name;return e}))}else{e.push(t)}return e},[]);return t}async function s(e,t,n){const a=await n.delegateInfo.delegate.getPropertyInfo({element:e,aggregationName:t,payload:n.delegateInfo.payload||{}});return c(a)}async function g(e,t){const a=await r.getReadDelegateForControl({control:e,modifier:n});if(a&&a.instance){return a.instance.getPropertyInfo({element:e,aggregationName:t,payload:a.payload||{}})}return[]}async function f(e,t,n){const a=n.addViaDelegate;let r;if(a){r=s.bind(null,e,t,a)}else{r=g.bind(null,e,t)}const i=await r();return _(i)}function d(e){return e.filter(function(e){return!(e.unsupported||e.hideFromReveal)})}function p(e){return{selected:false,label:e.label||e.name,parentPropertyName:e.parentPropertyName?e.parentPropertyName:"",duplicateName:e.duplicateName?e.duplicateName:false,tooltip:e.tooltip||e.label,originalLabel:"",type:"delegate",entityType:e.entityType,name:e.name,bindingPath:e.bindingPath}}function m(e){const t=e.element;const n=e.action;return{selected:false,label:t.__label||a.getLabelForElement(t,n.getLabel),tooltip:t.__tooltip||a.getLabelForElement(t,n.getLabel)||t.__bindingPath,parentPropertyName:t.__parentPropertyName?t.__parentPropertyName:"",duplicateName:t.__duplicateName?t.__duplicateName:false,originalLabel:t.__renamedLabel&&t.__label!==t.__originalLabel?t.__originalLabel:"",bindingPath:t.__bindingPath,type:"invisible",elementId:t.getId(),sourceAggregation:e.sourceAggregation}}function b(e,t,n,r){if(t&&t!==e){const i=u(e,n,r);return a.findAllSiblingsInContainer(e,t).filter(function(e){return i===u(e,n,r)})}return[e]}function _(e){e.forEach(function(e,t,n){if(e.duplicateName!==true){for(let a=t+1;a<n.length-1;a++){if(e.label===n[a].label){e.duplicateName=true;n[a].duplicateName=true}}}});return e}function P(e,t){return t.some(function(t){return t.label===e.__label})}function y(e){return Array.isArray(e)&&e.length>0}function h(e,t){return t.sort(function(e,t){return!!t.hideFromReveal-!!e.hideFromReveal}).filter(function(t){return e.some(function(e){return e===t.bindingPath||e.startsWith(`${t.bindingPath}/`)})}).pop()}function N(t){return e(t)?t.parts[0].path:!!t.getPath&&t.getPath()}function I(e,t,n,a){const r=e.getModel(n);const o=b(e,t.relevantContainer,a,n);let l=[];o.forEach(function(e){l=l.concat(i.getBindings({element:e,model:r,parent:e.getParent()}).map(N))});return l}function L(e,t){const n={element:e.relevantContainer,aggregationName:t,payload:e.delegateInfo.payload||{}};return e.delegateInfo.delegate.getRepresentedProperties(n)}async function A(e,t,n,a){const r=await L(t,a);if(r===undefined){return I(e,t,n,a)}let i=[];r.forEach(function(e){i=i.concat(e.bindingPaths)});return i}function v(e,n,a,r){const i=!!t.get("delegateInfo.delegate.getRepresentedProperties",n);if(i){return A(e,n,a,r)}return I(e,n,a,r)}function E(e,t){e.__originalLabel=t.label;e.__tooltip=t.tooltip;e.__bindingPath=t.name;if(e.__label!==e.__originalLabel){e.__renamedLabel=true}if(t.parentPropertyName){e.__parentPropertyName=t.parentPropertyName}}function R(e,n){const a=!!t.get("delegateInfo.delegate.getRepresentedProperties",e);if(a){return L(e,n)}}function B(e,t){let n;t.some(function(t){if(t.id===e.getId()){n=t;return true}});return n.bindingPaths||[]}function F(e,t,n,a){if(!y(n)){return true}const r=h(n,t);if(r){if(r.hideFromReveal){return false}if(a){E(e,r)}return true}return!a}function C(e,t,n,a,r,o){const l=a.addViaDelegate;const c=w(l);const s=e.getModel(c);let g=true;let f=[];const d=n.element;const p=n.action.depthOfRelevantBindings;if(r){f=B(d,r)}else if(u(e,t,c)===u(d,t,c)){f=i.collectBindingPaths(d,s,null,p).bindingPaths}else if(l&&i.getBindings({element:d,model:s}).length>0){g=false}if(g){d.__duplicateName=P(d,o);g=F(d,o,f,!!l)}return g}function w(e){return t.get("delegateInfo.payload.modelName",e)}const D={async enhanceInvisibleElements(e,t){const n=t.reveal;const r=t.addViaDelegate;const i=e.getMetadata().getAggregation();const o=i?i.name:t.aggregation;const[l,u]=await Promise.all([f(e,o,t),R(r,o)]);const c=[];const s=n.elements||[];s.forEach(function(n){const r=n.element;const i=n.action;r.__label=a.getLabelForElement(r,i.getLabel);const s=C(e,o,n,t,u,l);if(s){c.push({element:r,action:i,sourceAggregation:n.sourceAggregation})}});return c.map(m)},async getUnrepresentedDelegateProperties(e,t){const n=w(t);const a=e.getMetadata().getAggregation();const r=a?a.name:t.action.aggregation;const[i,o]=await Promise.all([s(e,r,t),v(e,t,n,r)]);const l=t.action.filter?t.action.filter:function(){return true};let u=d(i);u=u.filter(function(e){let n=false;if(o){n=o.some(function(t){return t===e.bindingPath})}return!n&&l(t.relevantContainer,e)});u=_(u);return u.map(p)}};return D});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/rta/plugin/additionalElements/AdditionalElementsPlugin", ["sap/base/util/each","sap/base/Log","sap/ui/core/EventBus","sap/ui/core/IconPool","sap/ui/core/Lib","sap/ui/dt/OverlayRegistry","sap/ui/dt/OverlayUtil","sap/ui/fl/write/api/FieldExtensibility","sap/ui/rta/plugin/additionalElements/ActionExtractor","sap/ui/rta/plugin/additionalElements/AddElementsDialog","sap/ui/rta/plugin/additionalElements/AdditionalElementsAnalyzer","sap/ui/rta/plugin/additionalElements/AdditionalElementsUtils","sap/ui/rta/plugin/additionalElements/CommandBuilder","sap/ui/rta/plugin/Plugin","sap/ui/rta/Utils"],function(e,t,i,n,s,a,l,o,r,c,u,g,d,h,E){"use strict";const f=true;const m=false;function b(e,t){const i=t.responsibleElementOverlay.getParentAggregationOverlay().getAggregationName();return Object.keys(e).some(function(e){return e===i})}async function p(e){const t=e.getModel();if(t&&t.sServiceUrl){const e=await o.isServiceOutdated(t.sServiceUrl);if(e){o.setServiceValid(t.sServiceUrl);i.getInstance().publish("sap.ui.core.UnrecoverableClientStateCorruption","RequestReload",{})}}}async function _(e){await o.onControlSelected(e);const t=await o.isExtensibilityEnabled(e);if(t){await p(e);const t=await o.getExtensionData(e);if(t){t.UITexts=await o.getTexts()||{}}return t}return undefined}function y(e){const t=this.getExtensibilityInfo(e);if(!t){this.getDialog().setCustomFieldButtonVisible(false);return}const i=t.UITexts?.options;if(!i){const e=s.getResourceBundleFor("sap.ui.rta");t.UITexts.options=[{actionKey:undefined,text:e.getText("BTN_ADDITIONAL_ELEMENTS_CREATE_CUSTOM_FIELDS"),tooltip:t.UITexts.tooltip}]}this.getDialog().setExtensibilityOptions(t);this.getDialog().detachEvent("triggerExtensibilityAction",this._onTriggerExtensibilityAction,this);this.getDialog().attachEvent("triggerExtensibilityAction",e,this._onTriggerExtensibilityAction,this);this.getDialog().addExtensibilityInfo(t)}const A=h.extend("sap.ui.rta.plugin.additionalElements.AdditionalElementsPlugin",{constructor:function(...e){this._getMenuItemsPromise=Promise.resolve();const[t]=e;t.dialog=new c;h.apply(this,e)},metadata:{library:"sap.ui.rta",properties:{commandFactory:"object"},aggregations:{dialog:{type:"sap.ui.rta.plugin.additionalElements.AddElementsDialog",multiple:false}},associations:{},events:{}},_getRelevantOverlays(e){const t=l.findAllOverlaysInContainer(e,true);e.setRelevantOverlays(t);return t},getContextMenuText(e,t,i,n){let a;function l(){a=s.getResourceBundleFor("sap.ui.rta");return a.getText("CTX_ADD_ELEMENTS",[a.getText("MULTIPLE_CONTROL_NAME")])}if(i==="$$OnlyChildCustomField$$"){return l()}if(n){a=s.getResourceBundleFor("sap.ui.rta");return a.getText("CTX_ADD_ELEMENTS_WITH_SUBMENU")}const o=g.getParents(e,t,this);const c=r.getActionsOrUndef(e,t);i||=Object.keys(c)[0];const u=c[i];if(!u){return l()}u.aggregation=i;return g.getText("CTX_ADD_ELEMENTS",u,o.parent,f)},isAvailable(e,t){return e.every(function(e){return this._isEditableByPlugin(e,t)},this)},isEnabled(e,t,i){if(e.length>1){return false}if(this.getExtensibilityInfo(t)){return true}const n=this.getResponsibleElementOverlay(e[0]);let s;let a=false;if(t){s=n.getParentElementOverlay();if(s){a=true}}else{const e=r.getActionsOrUndef(t,n);const s=e[i];if(s&&(s.reveal&&s.reveal.elements.length>0||s.addViaDelegate)){a=true}}const l=this.getCachedElements(t);const o=!!(l&&l.length>0);a&&=o;return a},async registerElementOverlay(...e){const[t]=e;const i=t.getElement().getModel();if(i){const e=i.getMetaModel();if(e&&e.loaded){await e.loaded();this.evaluateEditable([t],{onRegistration:true})}}h.prototype.registerElementOverlay.apply(this,e)},_checkIfCreateFunctionIsAvailable(e){return!e||e&&e.content&&e.content.createFunction},async showAvailableElements(e,i,n,l,o,c){const u=n[0];const h=g.getParents(e,u,this);const E=e&&u.getElement();const f=await r.getActions(e,u,this,undefined,this.getDesignTime());let m=[];const b=f[i];if(i!=="$$OnlyChildCustomField$$"){try{m=await this.getAllElements(e,[h.responsibleElementOverlay],o,c)}catch(e){if(e instanceof Error){throw e}else{t.info("Service not up to date, skipping add dialog","sap.ui.rta");return}}}y.call(this,e);const p=m.filter(function(e){return e.aggregation===i})[0];const _=p?p.elements:[];this.getDialog().setElements(_);if(c){const e=s.getResourceBundleFor("sap.ui.rta");const t=e.getText("HEADER_ADDITIONAL_ELEMENTS_WITH_AGGREGATION",[c]);this.getDialog().setTitle(t)}else if(i||o){this._setDialogTitle(b||{},h.parent,o)}try{await this.getDialog().open();const e=this.getDialog().getSelectedElements();await d.createCommands(h,E,b,l,e,i,this);const t=a.getOverlay(E)||u;t.focus()}catch(e){if(e instanceof Error){throw e}}},_setDialogTitle(e,t,i){const n=g.getText("HEADER_ADDITIONAL_ELEMENTS",e,t,m,i);this.getDialog().setTitle(n)},_onTriggerExtensibilityAction(e,t){const i=E.getRtaStyleClassName();const n=e.getParameters().actionKey;return o.onTriggerCreateExtensionData(this.getExtensibilityInfo(t),i,n)},async _isEditable(e,i){try{const[e,t]=await Promise.all([this._isEditableCheck(i.sourceElementOverlay,true),this._isEditableCheck(i.sourceElementOverlay,false)]);return{asSibling:e,asChild:t}}catch(e){t.error(e)}},async _isEditableCheck(e,t){const i=g.getParents(t,e,this);if(!i.relevantContainerOverlay){return false}const n=await r.getActions(t,e,this,true,this.getDesignTime());await this._getMenuItemsPromise;this.clearCachedElements();return E.doIfAllControlsAreAvailable([e,i.parentOverlay],function(){let s=false;if(t){s=b(n,i)}else{s=Object.keys(n).some(function(e){if(n[e].addViaDelegate){s=this.checkAggregationsOnSelf(i.parentOverlay,"add",undefined,"delegate")}if(!s&&n[e].reveal){return true}return s}.bind(this))}s&&=this.hasStableId(e)&&this.hasStableId(i.parentOverlay);return s}.bind(this))},async getAllElements(t,i){const n=i[0];const s=g.getParents(t,n,this);let a;const l=[];let o=false;const c=this.getCachedElements(t);if(c){return c}this.clearExtensibilityInfo(t);const d=await r.getActions(t,n,this,undefined,this.getDesignTime());e(d,function(e){a=d[e];a.aggregation=e;if(a.addViaDelegate){o=true}l.push({aggregation:e,elementPromises:[a.reveal?u.enhanceInvisibleElements(s.parent,a):Promise.resolve([]),a.addViaDelegate?u.getUnrepresentedDelegateProperties(s.parent,a.addViaDelegate):Promise.resolve([])]})});const h=o&&await _(s.parent);this.setExtensibilityInfo(t,h);const E=await this._combineAnalyzerResults(l);this.setCachedElements(E,t);return E},getMenuItems(e){const t=[];let i;this.clearCachedElements();this._getMenuItemsPromise=Promise.all([this.getAllElements(false,e),this.getAllElements(true,e)]).then(function(n){const s=n[0].length>0;const a=n[0].length>1;const l=n[1].length>0;const o=this.isAvailable(e,false);const r=this.isAvailable(e,true);if(r&&(!o||!s)){i=this._buildMenuItem("CTX_ADD_ELEMENTS_AS_SIBLING",true,e,n,false)}else if(o&&(!r||!l)&&!a){i=this._buildMenuItem("CTX_ADD_ELEMENTS_AS_CHILD",false,e,n,false)}else if(o&&(!r||!l)&&a){i=this._buildMenuItem("CTX_ADD_ELEMENTS_AS_CHILD",false,e,n,true)}else if(o&&r&&s&&l){i=this._buildMenuItem("CTX_ADD_ELEMENTS_CHILD_AND_SIBLING",false,e,n,true)}if(i){t.push(this.enhanceItemWithResponsibleElement(i,e,["addViaDelegate","reveal","custom"]))}return t}.bind(this));return this._getMenuItemsPromise},_buildMenuItem(e,t,i,n,s){let a;let l;let o;const r=i[0];if(t){const e=g.getParents(t,r,this);o=e.responsibleElementOverlay.getParentAggregationOverlay().getAggregationName()}else{const e=n[0].length===0&&n[1].length===0;o=e?"$$OnlyChildCustomField$$":n[0]&&n[0][0]&&n[0][0].aggregation}if(s){a=this._buildSubmenuItems(false,i,n[0]);if(e==="CTX_ADD_ELEMENTS_CHILD_AND_SIBLING"){a=a.concat(this._buildSubmenuItems(true,i,n[1]))}}else{l=function(e,t){return this.showAvailableElements(e,o,t)}.bind(this,t)}const c={id:e,text:this.getContextMenuText.bind(this,t,r,o,s),enabled:s||function(e,t){return this.isEnabled(t,e,o)}.bind(this,t),rank:this.getRank(e),icon:"sap-icon://add",handler:l};if(s){c.submenu=a}return c},_buildSubmenuItems(e,t,i){const s=[];const a=e?"CTX_ADD_ELEMENTS_AS_SIBLING":"CTX_ADD_ELEMENTS_AS_CHILD";let l=0;n.registerFont({collectionName:"BusinessSuiteInAppSymbols",fontFamily:"BusinessSuiteInAppSymbols",fontURI:sap.ui.require.toUrl("sap/ushell/themes/base/fonts/"),lazy:true});function o(e,t,i){i=e?i.getParentElementOverlay():i;const n=i.getDesignTimeMetadata();const s=n.getAggregationDisplayName(t,i.getElement());return s?s.plural:t}i.forEach(function(i){const n=i.aggregation;const r=this.getResponsibleElementOverlay(t[0]);const c=o(e,n,r);const u={id:`${a}_${l}`,text:c,enabled:function(t){return this.isEnabled(t,e,n)}.bind(this),handler:function(e,t){return this.showAvailableElements(e,n,t,undefined,undefined,c)}.bind(this,e),icon:e?"sap-icon://BusinessSuiteInAppSymbols/icon-add-outside":"sap-icon://add"};s.push(this.enhanceItemWithResponsibleElement(u,t,["addViaDelegate","reveal","custom"]));l++}.bind(this));return s},async _combineAnalyzerResults(e){const t=[];e.forEach(function(e){t.push(Promise.all(e.elementPromises).then(function(t){const i=t[0];const n=t[1];const s=i.concat(n);return{aggregation:e.aggregation,elements:s}}))});const i=await Promise.all(t);return i.filter(function(e){const t=e&&e.elements;return t.length>0})},clearCachedElements(){this._oCachedElements=undefined},setCachedElements(e,t){this._oCachedElements||={};this._oCachedElements[t?"asSibling":"asChild"]=e},getCachedElements(e){if(this._oCachedElements){return this._oCachedElements[e?"asSibling":"asChild"]}return undefined},clearExtensibilityInfo(e){if(this._oExtensibilityInfo){this._oExtensibilityInfo[e?"asSibling":"asChild"]=undefined}},setExtensibilityInfo(e,t){this._oExtensibilityInfo||={};this._oExtensibilityInfo[e?"asSibling":"asChild"]=t},getExtensibilityInfo(e){if(this._oExtensibilityInfo){return this._oExtensibilityInfo[e?"asSibling":"asChild"]}return undefined},exit(...e){this.getDialog().destroy();if(h.prototype.exit){h.prototype.exit.apply(this,e)}}});return A});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/rta/plugin/additionalElements/AdditionalElementsUtils", ["sap/ui/core/Lib","sap/ui/dt/OverlayRegistry"],function(e,a){"use strict";var r={};function t(e){return e.addViaDelegate&&e.addViaDelegate.designTimeMetadata}r.getParents=function(e,r,t){var n;var i=r;var l=["add.delegate","reveal"].some(function(e){return t.isResponsibleElementActionAvailable(r,e)});if(l){i=t.getResponsibleElementOverlay(r)}var s=i.getRelevantContainer(!e);var u=a.getOverlay(s);if(e){n=i.getParentElementOverlay()}else{n=i}return{responsibleElementOverlay:i,relevantContainerOverlay:u,parentOverlay:n,relevantContainer:s,parent:n&&n.getElement()}};r.getText=function(a,r,n,i,l){var s=[];var u;var v;var g=r.aggregation;if(r.addViaCustom||r.addViaDelegate){var o=t(r);u=o.getAggregationDescription(g,n);if(u){v=i?u.singular:u.plural;s.push(v)}}if(r.reveal){r.reveal.controlTypeNames.forEach(function(e){v=i?e.singular:e.plural;s.push(v)})}var d=s.reduce(function(e,a){if(e.indexOf(a)===-1){e.push(a)}return e},[]);var f=e.getResourceBundleFor("sap.ui.rta");if(d.length===1){[v]=d}else if(l){v=l}else{v=f.getText("MULTIPLE_CONTROL_NAME")}return f.getText(a,[v])};return r});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/rta/plugin/additionalElements/CommandBuilder", ["sap/base/Log","sap/ui/dt/ElementUtil","sap/ui/dt/OverlayRegistry","sap/ui/dt/Util","sap/ui/fl/Utils","sap/ui/rta/Utils"],function(e,t,n,a,r,o){"use strict";const i={};function s(e,t){let n;e.reveal.elements.some(function(e){if(e.element.getId()===t.getId()){n=e;return false}return undefined});return n}async function g(t){const n=await c(t.selectedElement,t.actions,t.parents,t.plugin);t.compositeCommand.addCommand(n);const a=await d(t.selectedElement,t.parents,t.siblingElement,t.index,t.targetAggregation,t.plugin);if(a){t.compositeCommand.addCommand(a)}else{e.warning(`No move action configured for ${t.parents.parent.getMetadata().getName()}, aggregation: ${t.selectedElement.aggregation}`,"sap.ui.rta")}return t.compositeCommand}function c(e,a,r,o){const i=t.getElementInstance(e.elementId);const g=n.getOverlay(i);const c=s(a,i);const d=g?o.getVariantManagementReference(g):undefined;if(c.action.changeOnRelevantContainer){return o.getCommandFactory().getCommandFor(i,"reveal",{revealedElementId:i.getId(),directParent:r.parent},c.designTimeMetadata,d)}return o.getCommandFactory().getCommandFor(i,"reveal",{},c.designTimeMetadata,d)}function d(e,a,r,i,s,g){const c=t.getElementInstance(e.elementId);const d=n.getOverlay(c);const m=d.getParentElementOverlay().getElement()||a.parent;const l=o.getIndex(a.parent,r,s);const p=o.getIndex(m,c,e.sourceAggregation)-1;const u=i!==undefined?i:t.adjustIndexForMove(m,a.parent,p,l);if(u!==p||a.parent!==c.getParent()||e.sourceAggregation!==s){const t=n.getOverlay(c)?n.getOverlay(c).getParentAggregationOverlay():a.relevantContainerOverlay;const r=t.getDesignTimeMetadata();const o=g.getVariantManagementReference(d);return g.getCommandFactory().getCommandFor(a.relevantContainer,"move",{movedElements:[{element:c,sourceIndex:p,targetIndex:u}],source:{parent:m,aggregation:e.sourceAggregation},target:{parent:a.parent,aggregation:s}},r,o)}return Promise.resolve()}function m(e,t){const n=e.getManifestEntry("/sap.ui5/dependencies/libs");return Object.keys(t).some(function(e){return!n[e]||n[e].lazy})}function l(e,t,n,a){if(t){const o=r.getAppComponentForControl(e.relevantContainer);if(m(o,t)){const r=o.getManifest();const i=r["sap.app"].id;return a.getCommandFactory().getCommandFor(e.publicParent,"addLibrary",{reference:i,parameters:{libraries:t},appComponent:o},n)}}return Promise.resolve()}async function p(e){const t=e.actions.addViaDelegate.action;const n=e.parents.parentOverlay.getAggregationOverlay(e.actions.aggregation);const a=n.getDesignTimeMetadata();const r=await l(e.parents,t.delegateInfo.requiredLibraries,a,e.plugin);if(r){e.compositeCommand.addCommand(r)}const o=await C(e,a);if(o){e.compositeCommand.addCommand(o)}return e.compositeCommand}function u(e){let t="";if(e){const n=e.getEntry?e.getEntry("sap.app"):e["sap.app"];if(n?.dataSources?.mainService?.uri){t=n.dataSources.mainService.uri}}return t}function f(e,t,n){return`${e.getId()}_${t}_${n}`.replace("/","_")}function C(e,t){const n=e.parents;const a=e.actions.addViaDelegate.action;const i=a.changeOnRelevantContainer?n.relevantContainer:n.parent;const s=a.changeOnRelevantContainer?n.relevantContainerOverlay:n.parentOverlay;const g=o.getIndex(n.parent,e.siblingElement,e.actions.aggregation,t.getData().getIndex);return e.plugin.getCommandFactory().getCommandFor(n.parent,"addDelegateProperty",{newControlId:f(i,e.selectedElement.entityType,e.selectedElement.bindingPath),index:e.index!==undefined?e.index:g,bindingString:e.selectedElement.bindingPath,entityType:e.selectedElement.entityType,parentId:n.parent.getId(),propertyName:e.selectedElement.name,oDataServiceVersion:e.selectedElement.oDataServiceVersion,oDataServiceUri:u(r.getAppComponentForControl(n.parent).getManifest()),modelType:a.delegateInfo.modelType,relevantContainerId:n.relevantContainer.getId()},t,e.plugin.getVariantManagementReference(s))}i.createCommands=async function(t,n,r,o,i,s,c){i.sort(function(e,t){if(e.label>t.label){return-1}if(e.label<t.label){return 1}return 0});if(i.length>0){try{const a=await c.getCommandFactory().getCommandFor(t.parent,"composite");for(const d of i){const i={compositeCommand:a,selectedElement:d,parents:t,siblingElement:n,actions:r,index:o,targetAggregation:s,plugin:c};switch(d.type){case"invisible":await g(i);break;case"delegate":await p(i);break;default:e.error(`Can't create command for untreated element.type ${d.type}`)}}c.fireElementModified({command:a})}catch(e){throw a.propagateError(e,"AdditionalElementsPlugin#_createCommands","Error occurred during _createCommands execution","sap.ui.rta.plugin")}}};return i});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/rta/plugin/annotations/AnnotationChangeDialog", ["sap/ui/base/ManagedObject","sap/ui/core/Fragment","sap/ui/dt/ElementUtil","sap/ui/fl/write/api/PersistenceWriteAPI","sap/ui/model/json/JSONModel","sap/ui/model/resource/ResourceModel","sap/ui/rta/plugin/annotations/AnnotationChangeDialogController","sap/ui/rta/Utils"],function(t,e,o,n,a,i,l,s){"use strict";const r=t.extend("sap.ui.rta.plugin.annotations.AnnotationChangeDialog");function p(t,e,o){const n=t.find(t=>t.annotationPath===e);if(n){n.currentValue=o;n.originalValue=o}}function c(t,e,n){const a=o.getLabelForElement(n);p(t,e,a)}function u(t,e,o){t.forEach(t=>{const n=t.getContent().annotationPath;p(e,n,o?JSON.stringify(t.getValue()):t.getValue())})}r.prototype._createDialog=async function(){this._oController=new l;const t=await e.load({name:"sap.ui.rta.plugin.annotations.AnnotationChangeDialog",controller:this._oController});t.addStyleClass(s.getRtaStyleClassName());this.oChangeAnnotationModel=new a;t.setModel(this.oChangeAnnotationModel);const o=new i({bundleName:"sap.ui.rta.messagebundle"});t.setModel(o,"i18n");return t};r.prototype._openDialog=function(){this._oDialog.open();return this._oController.initialize()};r.prototype.openDialogAndHandleChanges=async function(t){const{title:e,type:o,delegate:a,control:i,annotation:l,description:s,singleRename:r}=t;const{serviceUrl:p,properties:g,possibleValues:h,preSelectedProperty:d}=await a.getAnnotationsChangeInfo(i,l);const f=!!h?.some(t=>typeof t.key==="object");const y=g.map(t=>({...t,currentValue:f?JSON.stringify(t.currentValue):t.currentValue,originalValue:f?JSON.stringify(t.currentValue):t.currentValue,label:t.label||t.propertyName}));const C=(h||[]).map(t=>({...t,key:f?JSON.stringify(t.key):t.key}));y.sort((t,e)=>t.label.localeCompare(e.label));const m=n._getAnnotationChanges({control:i});const _=m.map(t=>t.getContent().annotationPath);this._oDialog||=await this._createDialog();const D=d&&y.find(t=>t.annotationPath===d)?.label||"";if(y.length>100){this.oChangeAnnotationModel.setSizeLimit(y.length)}if(r){c(y,d,i)}u(m.filter(t=>!t._appliedOnModel),y,f);this.oChangeAnnotationModel.setData({objectAsKey:f,control:i,title:e,description:s||"",properties:y,changedProperties:y.filter(({annotationPath:t})=>_.includes(t)),propertiesToDisplay:y,showChangedPropertiesOnly:false,filterText:D,singleRename:r||false,possibleValues:C,valueType:o,serviceUrl:p});if(D){this._oController.filterProperties(D,!!r)}this.oChangeAnnotationModel.refresh(true);const b=await this._openDialog();this._oController.filterProperties("");this._oDialog.close();return b};r.prototype.destroy=function(...e){t.prototype.destroy.apply(this,e);if(this._oDialog){this._oDialog.destroy()}if(this._oController){this._oController.destroy()}};return r});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/rta/plugin/annotations/AnnotationChangeDialogController", ["sap/m/Input","sap/m/Label","sap/m/Select","sap/m/Switch","sap/ui/core/mvc/Controller","sap/ui/core/Element","sap/ui/core/Item","sap/ui/layout/form/FormElement","sap/ui/model/Filter","sap/ui/model/FilterOperator","sap/ui/rta/plugin/annotations/AnnotationTypes"],function(e,t,n,o,r,a,i,s,l,p,u){"use strict";const c=r.extend("sap.ui.rta.plugin.annotations.AnnotationChangeDialogController");c.prototype.initialize=function(){return new Promise(e=>{this._fnResolveAfterClose=e})};c.prototype.filterProperties=function(e,t){const n=[];if(e&&e.length>0){const o=new l("label",t?p.EQ:p.Contains,e);n.push(o)}const o=a.getElementById("sapUiRtaChangeAnnotationDialog_propertyList");const r=o.getBinding("formElements");r.filter(n)};c.prototype.onFilterProperties=function(e){const t=e.getSource().getValue();this.filterProperties(t)};c.prototype.switchDisplayMode=function(e){const t=e.getParameter("state");const n=a.getElementById("sapUiRtaChangeAnnotationDialog_propertyList");const o=n.getModel();o.setProperty("/showChangedPropertiesOnly",t);if(t){const e=o.getProperty("/changedProperties");const t=o.getProperty("/properties").filter(t=>e.some(e=>e.annotationPath===t.annotationPath)||t.originalValue!==t.currentValue);o.setProperty("/propertiesToDisplay",t)}else{o.setProperty("/propertiesToDisplay",o.getProperty("/properties"))}};c.prototype.onSave=function(e){const t=e.getSource().getModel().getData();const n=t.properties.map(e=>{if(e.originalValue===e.currentValue){return null}const n={serviceUrl:t.serviceUrl,content:{annotationPath:e.annotationPath}};n.content[t.valueType===u.StringType?"text":"value"]=t.objectAsKey?JSON.parse(e.currentValue):e.currentValue;return n}).filter(Boolean);this._fnResolveAfterClose(n)};c.prototype.onCancel=function(){this._fnResolveAfterClose([])};function g(t){if(t===u.ValueListType){const e=new n({selectedKey:"{currentValue}"});const t=new i({key:"{key}",text:"{text}"});e.bindItems({path:"/possibleValues",template:t,templateShareable:false});return e}if(t===u.StringType){return new e({value:"{currentValue}",liveChange:e=>{const t=e.getParameter("newValue");const n=e.getSource().getBindingContext();e.getSource().getModel().setProperty("currentValue",t,n)}})}if(t===u.BooleanType){return new o({state:"{currentValue}"})}throw new Error(`Unsupported value type: ${t}`)}c.prototype.editorFactory=function(e,n){const o=n.getProperty("/valueType");const r=n.getProperty("/singleRename");return new s({id:e,label:new t({text:r?"{i18n>ANNOTATION_CHANGE_DIALOG_SINGLE_RENAME_LABEL}":"{= ${label} || ${propertyName}}",tooltip:"{tooltip}"}),fields:[g.call(this,o)]})};return c});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/rta/plugin/annotations/AnnotationPlugin", ["sap/base/Log","sap/ui/base/DesignTime","sap/ui/core/util/reflection/JsControlTreeModifier","sap/ui/dt/OverlayRegistry","sap/ui/dt/Util","sap/ui/fl/write/api/PersistenceWriteAPI","sap/ui/fl/Utils","sap/ui/rta/plugin/annotations/AnnotationChangeDialog","sap/ui/rta/plugin/annotations/AnnotationTypes","sap/ui/rta/plugin/Plugin"],function(e,t,n,i,o,a,s,r,l,c){"use strict";async function u(e,t,n,i){const o=await this.getCommandFactory().getCommandFor(e,"composite");for(const a of n){const n=await this.getCommandFactory().getCommandFor(e,"annotation",{changeType:t.changeType,serviceUrl:a.serviceUrl,content:{...a.content,objectTemplateInfo:t.objectTemplateInfo},changesToDelete:i});o.addCommand(n)}if(o.getCommands().length>0){this.fireElementModified({command:o})}}function p(t,n,i){const o=n.title;const a=i||t.getElement();if(o){if(typeof o==="function"){return o(a)}const e=t.getDesignTimeMetadata()?.getLibraryText(a,o);if(e){return e}}e.error("Annotation action title is not properly defined in the designtime metadata");return undefined}function g(t){const n=t.type===l.StringType?"sap-icon://edit":"sap-icon://request";const i=t.icon;if(!i){return n}if(typeof i!=="string"){e.error("Icon setting for annotation action should be a string");return n}return i}function d(t){if(t.singleRename&&!t.controlBasedRenameChangeType){e.error("When using singleRename, controlBasedRenameChangeType must also be defined");return false}return true}const f=c.extend("sap.ui.rta.plugin.annotations.AnnotationPlugin",{metadata:{library:"sap.ui.rta",associations:{},events:{}}});const h="CTX_ANNOTATION";const y="CTX_ANNOTATION_CHANGE_SINGLE_LABEL";f.prototype.init=function(...e){c.prototype.init.apply(this,e);this._oDialog=new r};f.prototype._isEditable=function(e){if(t.isDesignModeEnabled()){return false}const n=this.getAction(e);if(n){return Object.values(n).some(e=>e.changeType)}return false};f.prototype.isEnabled=function(e){if(e.length!==1){return false}const t=e[0];const n=this.getResponsibleElementOverlay(t);const i=this.getAction(n);if(i){return Object.values(i).some(e=>{if(typeof e.isEnabled!=="undefined"){if(typeof e.isEnabled==="function"){return e.isEnabled(n.getElement())}return e.isEnabled}return true})}return false};f.prototype.handler=async function(e,t){const i=e[0];const r=i.getElement();try{const e=await this._oDialog.openDialogAndHandleChanges({title:p(i,t),type:t.type,control:r,delegate:t.delegate,annotation:t.annotation,description:t.description,singleRename:t.singleRename,controlBasedRenameChangeType:t.controlBasedRenameChangeType});if(e.length){const i=[];if(t.singleRename){const e=await a._getUIChanges({selector:r});const o=s.getAppComponentForControl(r);i.push(...e.filter(e=>e.getChangeType()===t.controlBasedRenameChangeType&&n.getControlIdBySelector(e.getSelector(),o)===r.getId()))}return u.call(this,r,t,e,i)}return undefined}catch(e){throw o.propagateError(e,"AnnotationPlugin#handler","Error occurred during handler execution","sap.ui.rta.plugin.annotations.AnnotationPlugin")}};f.prototype.getMenuItems=async function(e){const t=e[0];const n=this.getResponsibleElementOverlay(t);const i=this.getAction(n);const o=[];if(i){if(this._isEditableByPlugin(n)===undefined){await this.evaluateEditable([n],{onRegistration:false})}Object.entries(i).forEach(function([t,i],a){const s=i.type===l.StringType&&i.singleRename?y:h;const r=this.getRank(s);if(this.isAvailable([n])&&d(i)){const l=p(n,i);if(!l){return}o.push({id:`${s}_${t}`,rank:r+a,text:l,icon:g(i),enabled:typeof i.isEnabled==="function"&&i.isEnabled(e[0].getElement())||i.isEnabled!==false&&this.isEnabled(e),handler:this.handler.bind(this,e,i),additionalInfo:this._getAdditionalInfo(n,i)})}},this)}return o};f.prototype.getActionName=function(){return"annotation"};f.prototype.destroy=function(...e){c.prototype.destroy.apply(this,e);this._oDialog.destroy();delete this._oDialog};return f});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/rta/plugin/annotations/AnnotationTypes", [],function(){"use strict";return{ValueListType:"ValueList",BooleanType:"Boolean",StringType:"String"}});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/rta/plugin/iframe/AddIFrame", ["sap/ui/core/Lib","sap/ui/rta/plugin/BaseCreate","sap/ui/fl/Utils","sap/ui/dt/Util","sap/base/util/uid","sap/ui/core/IconPool","sap/ui/rta/plugin/iframe/AddIFrameDialog"],function(t,e,a,i,n,r,o){"use strict";function s(t,e,a,i){var n=!t;var r=this.getCreateAction(n,i,t);return a.getText(e,[r.text])}function d(t,e,i,r){var o=a.getViewForControl(t);var s=o.createId(n());var d;var g;if(e.frameWidth){d=e.frameWidth+e.frameWidthUnit}else{d="100%"}if(e.frameHeight){g=e.frameHeight+e.frameHeightUnit}else{g="100%"}return this.getCommandFactory().getCommandFor(t,"addIFrame",{targetAggregation:e.aggregation,baseId:s,index:e.index,url:e.frameUrl,width:d,height:g,title:e.title,advancedSettings:e.advancedSettings},i,r)}function g(t,e){var a=e[0];var n=!t;var r=this.getCreateAction(n,a,t);var s=this._getParentOverlay(n,a);var g=s.getElement();var l=s.getDesignTimeMetadata();var c=0;if(n){var u=a.getElement();var h=l.getAggregation(r.aggregation).getIndex;c=this._determineIndex(g,u,r.aggregation,h)}var f=this.getVariantManagementReference(s);var m=!!r.getCreatedContainerId;var v=new o;var I;o.buildUrlBuilderParametersFor(g).then(function(t){var e={parameters:t,asContainer:m};return v.open(e,g)}).then(function(t){if(!t){return Promise.reject()}t.index=c;t.aggregation=r.aggregation;I=t.title;return d.call(this,g,t,l,f)}.bind(this)).then(function(t){this.fireElementModified({command:t,newControlId:t.getBaseId(),action:m?r:undefined,title:I})}.bind(this)).catch(function(t){if(t){throw i.createError("AddIFrame#handler",t,"sap.ui.rta")}})}var l=e.extend("sap.ui.rta.plugin.AddIFrame",{metadata:{library:"sap.ui.rta",properties:{},associations:{},events:{}}});l.prototype.isEnabled=function(t,e){var a=e[0];var i=!t;var n=this.getCreateAction(i,a,t);return this.isActionEnabled(n,i,a)};l.prototype.getMenuItems=async function(e){function a(e){var a=t.getResourceBundleFor("sap.ui.rta");var i=a.getText("CTX_ADDIFRAME_GROUP");return{text:s.bind(this,e,"CTX_ADDIFRAME",a),handler:g.bind(this,e),enabled:this.isEnabled.bind(this,e),isSibling:!e,icon:"sap-icon://tnt/content-enricher",group:i}}r.registerFont({collectionName:"tnt",fontFamily:"SAP-icons-TNT",fontURI:sap.ui.require.toUrl("sap/tnt/themes/base/fonts"),lazy:false});await r.fontLoaded("tnt");var i=this.getRank("CTX_CREATE_SIBLING_IFRAME");var n=[];var o=true;if(this.isAvailable(e,o)){var d=this.getCreateAction(o,e[0]);if(d){var l={id:"CTX_CREATE_SIBLING_IFRAME",additionalInfo:this._getAdditionalInfo(e[0],d,{additionalInfoKey:"IFRAME_RTA_CONTEXT_MENU_INFO"}),rank:i,action:d,...a.call(this)};n.push(this.enhanceItemWithResponsibleElement(l,e))}}o=false;if(this.isAvailable(e,o)){n=n.concat(this.getCreateActions(o,e[0]).map(function(t){var n={action:t,id:`CTX_CREATE_CHILD_IFRAME_${t.aggregation.toUpperCase()}`,additionalInfo:this._getAdditionalInfo(e[0],t,{additionalInfoKey:"IFRAME_RTA_CONTEXT_MENU_INFO"}),rank:++i,...a.call(this,t.aggregation)};return this.enhanceItemWithResponsibleElement(n,e)},this))}return n};l.prototype.getActionName=function(){return"addIFrame"};return l});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/rta/plugin/iframe/AddIFrameDialog", ["sap/base/Log","sap/ui/base/ManagedObject","sap/ui/core/Fragment","sap/ui/core/library","sap/ui/core/Element","sap/ui/core/Lib","sap/ui/model/json/JSONModel","sap/ui/rta/Utils","sap/ui/rta/plugin/iframe/AddIFrameDialogController","sap/ui/fl/util/getContainerUserInfo"],function(e,t,a,i,A,_,n,o,l,r){"use strict";var{ValueState:E}=i;var I=_.getResourceBundleFor("sap.ui.rta");var D="https://help.sap.com/docs/search?q=Embedding%20Content%20%28Object%20Pages%29";var T=`${I.getText("IFRAME_ADDIFRAME_DIALOG_URL_WARNING_TEXT")} (`+`<a href=${D}>${I.getText("IFRAME_ADDIFRAME_DIALOG_URL_WARNING_LINKTEXT")}</a>)`;var s={dialogTitle:I.getText("IFRAME_ADDIFRAME_DIALOG_TITLE"),dialogCreateTitle:I.getText("IFRAME_ADDIFRAME_DIALOG_TITLE"),dialogUpdateTitle:I.getText("IFRAME_ADDIFRAME_DIALOG_UPDATE_TITLE"),sizeTitle:I.getText("IFRAME_ADDIFRAME_DIALOG_SIZE_TITLE"),widthLabel:I.getText("IFRAME_ADDIFRAME_DIALOG_WIDTH_LABEL"),widthUnitLabel:I.getText("IFRAME_ADDIFRAME_DIALOG_WIDTH_UNITLABEL"),heightLabel:I.getText("IFRAME_ADDIFRAME_DIALOG_HEIGHT_LABEL"),heightUnitLabel:I.getText("IFRAME_ADDIFRAME_DIALOG_HEIGHT_UNITLABEL"),dimensionsErrorText:I.getText("IFRAME_ADDIFRAME_DIALOG_DIMENSIONS_ERROR"),saveText:I.getText("IFRAME_ADDIFRAME_DIALOG_BUTTON_SAVE"),cancelText:I.getText("IFRAME_ADDIFRAME_DIALOG_BUTTON_CANCEL"),previewUrlLabel:I.getText("IFRAME_ADDIFRAME_DIALOG_PREVIEW_URL_LABEL"),previewUrlMessage:I.getText("IFRAME_ADDIFRAME_DIALOG_BUTTON_PREVIEW_MESSAGE"),previewButtonText:I.getText("IFRAME_ADDIFRAME_DIALOG_BUTTON_SHOW_PREVIEW"),showPreviewButton:I.getText("IFRAME_ADDIFRAME_DIALOG_BUTTON_SHOW_PREVIEW"),updatePreviewButton:I.getText("IFRAME_ADDIFRAME_DIALOG_BUTTON_UPDATE_PREVIEW"),previewFrameLabel:I.getText("IFRAME_ADDIFRAME_DIALOG_PREVIEW_FRAME_LABEL"),parameterSearchLabel:I.getText("IFRAME_ADDIFRAME_DIALOG_PARAMETER_SEARCH_LABEL"),editUrlLabel:I.getText("IFRAME_ADDIFRAME_DIALOG_EDIT_URL_LABEL"),parametersLabel:I.getText("IFRAME_ADDIFRAME_DIALOG_PARAMETERS_LABEL"),columnParameterLabel:I.getText("IFRAME_ADDIFRAME_DIALOG_TABLE_PARAMETER_LABEL"),columnUiValueLabel:I.getText("IFRAME_ADDIFRAME_DIALOG_TABLE_UI_VALUE_LABEL"),containerTitleLabel:I.getText("IFRAME_ADDIFRAME_DIALOG_CONTAINER_TITLE_LABEL"),containerTitleDefaultValue:I.getText("IFRAME_ADDIFRAME_DIALOG_CONTAINER_TITLE_DEFAULT_VALUE_TEXT"),selectAdditionalTextPercentSection:I.getText("IFRAME_ADDIFRAME_DIALOG_SELECT_ADDITIONAL_TEXT_PERCENT_SECTION"),selectAdditionalTextPercentHeader:I.getText("IFRAME_ADDIFRAME_DIALOG_SELECT_ADDITIONAL_TEXT_PERCENT_HEADER"),selectAdditionalTextVh:I.getText("IFRAME_ADDIFRAME_DIALOG_SELECT_ADDITIONAL_TEXT_VH"),selectAdditionalTextPx:I.getText("IFRAME_ADDIFRAME_DIALOG_SELECT_ADDITIONAL_TEXT_PX"),selectAdditionalTextRem:I.getText("IFRAME_ADDIFRAME_DIALOG_SELECT_ADDITIONAL_TEXT_REM"),advancedSettingsTitle:I.getText("IFRAME_ADDIFRAME_ADVANCED_SETTINGS"),additionalParametersSecurityWarningText:I.getText("IFRAME_ADDIFRAME_ADDITIONAL_PARAMETERS_SECURITY_WARNING_TEXT"),additionalParametersWarningMoreInfoText:I.getText("IFRAME_ADDIFRAME_ADDITIONAL_PARAMETERS_WARNING_MORE_INFO_TEXT"),additionalSandboxParametersLabel:I.getText("IFRAME_ADDIFRAME_ADD_ADDITIONAL_SANDBOX_PARAMETERS_LABEL"),additionalSandboxParametersPlaceholder:I.getText("IFRAME_ADDIFRAME_ADD_ADDITIONAL_SANDBOX_PARAMETERS_PLACEHOLDER")};function d(e,t,a,i,A){s.dialogTitle=e?s.dialogUpdateTitle:s.dialogCreateTitle;var _=t?s.selectAdditionalTextPercentSection:s.selectAdditionalTextPercentHeader;return new n({text:s,asContainer:{value:t},title:{value:s.containerTitleDefaultValue,valueState:E.None,id:"sapUiRtaAddIFrameDialog_ContainerTitle_TitleInput"},frameWidth:{value:parseFloat(a)||100,valueState:E.None,id:"sapUiRtaAddIFrameDialog_WidthInput"},frameWidthUnit:{value:"%"},frameHeight:{value:parseFloat(i)||50,valueState:E.None,id:"sapUiRtaAddIFrameDialog_HeightInput"},frameHeightUnit:{value:"vh"},frameUrl:{value:"",valueState:E.None},previousFrameUrl:{value:""},frameUrlError:{value:undefined},previewUrl:{value:""},documentationLink:{HTML:T},parameters:{value:[]},unitsOfWidthMeasure:[{unit:"%",descriptionText:_},{unit:"px",descriptionText:s.selectAdditionalTextPx},{unit:"rem",descriptionText:s.selectAdditionalTextRem}],unitsOfHeightMeasure:[{unit:"vh",descriptionText:s.selectAdditionalTextVh},{unit:"px",descriptionText:s.selectAdditionalTextPx},{unit:"rem",descriptionText:s.selectAdditionalTextRem}],advancedSettings:{value:{allowForms:true,allowScripts:true,allowSameOrigin:true,additionalSandboxParameters:[],...A}},settingsUpdate:{value:false}})}var R=t.extend("sap.ui.rta.plugin.iframe.AddIFrameDialog",{metadata:{library:"sap.ui.rta",events:{opened:{}}}});R.prototype.open=function(e,t){return new Promise(function(a){this._fnResolve=a;this._createDialog(e,t)}.bind(this))};R.prototype._createDialog=function(t,i){this._oJSONModel=d(!!t?.updateMode,!!t?.asContainer,t?.frameWidth,t?.frameHeight,t?.advancedSettings);this._oController=new l(this._oJSONModel,t);a.load({name:"sap.ui.rta.plugin.iframe.AddIFrameDialog",controller:this._oController}).then(function(e){this._oDialog=e;this._oDialog.addStyleClass(o.getRtaStyleClassName());this._oDialog.setModel(this._oJSONModel,"dialogInfo");this._oDialog.setModel(i.getModel());this._oDialog.setBindingContext(i.getBindingContext());this._openDialog()}.bind(this)).catch(function(t){e.error("Error loading fragment sap.ui.rta.plugin.iframe.AddIFrameDialog: ",t)})};R.prototype._openDialog=function(){this._oDialog.attachAfterOpen(function(){this._disablePanelExpand();const e=A.getElementById("sapUiRtaAddIFrameDialog_PreviewFrame");const t=e.getModel("$user");this._oDialog.setModel(t,"$user");this.fireOpened()}.bind(this));this._oDialog.attachAfterClose(function(){this._oDialog.destroy();this._oDialog=null;this._fnResolve(this._oController.getSettings());this._oController=null}.bind(this));this._oDialog.open()};R.prototype._disablePanelExpand=function(){var e=A.getElementById("sapUiRtaAddIFrameDialog_PreviewLinkPanel").getDependents()[0];if(e){e.setEnabled(false)}};R.buildUrlBuilderParametersFor=async function(e){const t=await r();const a=Object.keys(t).map(function(e){return{label:e,key:`{$user>/${e}}`,value:t[e]}});const i=e.getBindingContext();let A;if(i){const e=i.getObject();A=Object.keys(e).filter(function(t){return typeof e[t]!=="object"}).map(async function(t){const a=i.getModel();const A={label:t,key:`{${t}}`,value:e[t]};if(a.isA("sap.ui.model.odata.v4.ODataModel")){const e=a.getMetaModel();const _=e.getMetaPath(i.getPath());const n=await e.requestObject(`${_}/${t}/$Type`);if(n){A.type=n}}return A})}else{A=[]}return a.concat(await Promise.all(A))};return R});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/rta/plugin/iframe/AddIFrameDialogController", ["sap/base/Log","sap/m/Token","sap/ui/core/mvc/Controller","sap/ui/core/Element","sap/ui/core/Lib","sap/ui/core/library","sap/ui/rta/util/validateText","sap/ui/fl/util/IFrame","sap/ui/model/Filter","sap/ui/model/FilterOperator","sap/ui/rta/plugin/iframe/urlCleaner"],function(e,t,r,a,i,s,o,l,n,d,u){"use strict";var{ValueState:c}=s;const _=i.getResourceBundleFor("sap.ui.rta");var g=["frameUrl","title"];var p=["frameWidth","frameHeight"];var h=["frameWidthUnit","frameHeightUnit","advancedSettings"];function R(e){if(typeof e!=="string"||e.trim()===""){return{result:false,error:l.VALIDATION_ERROR.INVALID_URL}}return l.isValidUrl(encodeURI(e))}function v(e){const r=e.text;return new t({key:r,text:r})}return r.extend("sap.ui.rta.plugin.iframe.AddIFrameDialogController",{constructor:function(e,t){this._oJSONModel=e;this._importSettings(t)},configureMultiInput(){const e=a.getElementById("sapUiRtaAddIFrameDialog_AddAdditionalParametersInput");e.addValidator(v)},onSwitchChange(){this._oJSONModel.setProperty("/settingsUpdate/value",true)},onTokenUpdate(e){let t=this._oJSONModel.getProperty("/advancedSettings/value/additionalSandboxParameters");if(e.getParameter("type")==="added"){e.getParameter("addedTokens").forEach(function(e){t=[...t,e.getText()]})}else if(e.getParameter("type")==="removed"){e.getParameter("removedTokens").forEach(function(e){t=t.filter(function(t){return t!==e.getText()})})}this._oJSONModel.setProperty("/advancedSettings/value/additionalSandboxParameters",t);this._oJSONModel.setProperty("/settingsUpdate/value",true)},onValidationSuccess(e){e.getSource().setValueState(c.None);this._oJSONModel.setProperty("/areAllFieldsValid",this._areAllTextFieldsValid()&&this._areAllValueStateNones())},onValidationError(e){e.getSource().setValueState(c.Error);this._oJSONModel.setProperty("/areAllFieldsValid",false);this._setFocusOnInvalidInput()},onSavePress(){const e=this._buildPreviewURL();if(R(e).result&&this._areAllTextFieldsValid()&&this._areAllValueStateNones()){this._close(this._buildReturnedSettings())}else{this._setFocusOnInvalidInput()}},onShowPreview(){const t=this._buildReturnedURL();const r=this._buildPreviewURL();if(!R(r).result){return}const i=a.getElementById("sapUiRtaAddIFrameDialog_PreviewFrame");const s=a.getElementById("sapUiRtaAddIFrameDialog_PreviewLinkPanel");const o=s.getDependents()[0];if(r){o.setEnabled(true)}else{s.setExpanded(false);o.setEnabled(false)}try{this._oJSONModel.setProperty("/previousFrameUrl/value",t);this._oJSONModel.setProperty("/settingsUpdate/value",false);i.applySettings({url:r,advancedSettings:{...this._oJSONModel.getProperty("/advancedSettings/value")}});this._oJSONModel.setProperty("/previewUrl/value",i.getUrl())}catch(t){e.error("Error previewing the URL: ",t)}},onParameterPress(e){const t=e.getSource().getBindingContext("dialogInfo").getObject();this._oJSONModel.setProperty("/frameUrl/value",this._addURLParameter(t));this.onValidateUrl()},onLiveChange(e){var t=new n("label",d.Contains,e.getParameter("newValue"));var r=a.getElementById("sapUiRtaAddIFrameDialog_ParameterTable").getBinding("items");r.filter([t])},_buildPreviewURL(){const e=this._buildReturnedURL();const t=a.getElementById("sapUiRtaAddIFrameDialog_PreviewLinkResolver");try{t.applySettings({text:e})}catch(e){return undefined}return t.getText()},_addURLParameter(e){const t=e.key;let r;if(e.type&&e.type!=="Edm.String"){const[,e]=t.match(/\{(.+?)\}/);r=`{path:'${e}',targetType:'any'}`}else{r=t}const i=a.getElementById("sapUiRtaAddIFrameDialog_EditUrlTA");const s=i.getFocusDomRef().selectionStart;const o=i.getFocusDomRef().selectionEnd;const l=this._buildReturnedURL();return`${l.substring(0,s)}${r}${l.substring(o)}`},_buildReturnedURL(){return u(this._oJSONModel.getProperty("/frameUrl/value"))},onValidateUrl(){const e=this._buildPreviewURL();const{result:t,error:r}=R(e);if(t){this._oJSONModel.setProperty("/frameUrlError/value","")}else{const e={[l.VALIDATION_ERROR.UNSAFE_PROTOCOL]:"IFRAME_ADDIFRAME_ERROR_UNSAFE_PROTOCOL",[l.VALIDATION_ERROR.MIXED_CONTENT]:"IFRAME_ADDIFRAME_ERROR_MIXED_CONTENT",[l.VALIDATION_ERROR.FORBIDDEN_URL]:"IFRAME_ADDIFRAME_ERROR_FORBIDDEN_URL",[l.VALIDATION_ERROR.INVALID_URL]:"IFRAME_ADDIFRAME_ERROR_INVALID_URL"}[r];const t=_.getText(e);this._oJSONModel.setProperty("/frameUrlError/value",t)}},onCancelPress(){this._close()},onContainerTitleChange(e){var t=e.getSource();var r="None";var a=false;var i=t.getValue();if(i.trim()===""){r="Error";t.setValueState(r);this._oJSONModel.setProperty("/areAllFieldsValid",false);return true}try{o(i)}catch(e){r="Error";a=true}const s=this._areAllTextFieldsValid()&&this._areAllValueStateNones()&&!a;this._oJSONModel.setProperty("/areAllFieldsValid",s);t.setValueState(r);return a},_close(e){var t=a.getElementById("sapUiRtaAddIFrameDialog");this._mSettings=e;t.close()},getSettings(){return this._mSettings},_areAllValueStateNones(){var e=this._oJSONModel.getData();return g.concat(p).every(function(t){return e[t].valueState===c.None},this)},_areAllTextFieldsValid(){var e=this._oJSONModel;var t=this._oJSONModel.getProperty("asContainer/value");return g.reduce(function(r,a){if(a==="title"&&!t){return true}var i=`/${a}/value`;var s;if(e.getProperty(i).trim()===""){s=c.Error}else{s=c.None}e.setProperty(`${i}State`,s);return r&&s===c.None},true)},_buildReturnedSettings(){var e={};var t=this._oJSONModel.getData();g.concat(p,h).forEach(function(r){var a=t[r].value;if(r==="frameUrl"){a=u(a)}e[r]=a});return e},_importSettings(e){if(e){Object.keys(e).forEach(function(t){if(t==="frameWidth"||t==="frameHeight"){this._importIFrameSize(t,e[t])}else if(t==="advancedSettings"&&!e[t]){return}else{this._oJSONModel.setProperty(`/${t}/value`,e[t])}},this)}},_importIFrameSize(e,t){var r=t.split(/(px|rem|%|vh)/);if(r.length>=2){this._oJSONModel.setProperty(`/${e}/value`,parseFloat(r[0]));this._oJSONModel.setProperty(`/${e}Unit/value`,r[1])}},_setFocusOnInvalidInput(){var e=this._oJSONModel.getData();p.some(function(t){if(e[t].valueState===c.Error){var r=a.getElementById(e[t].id);r.focus();return true}return false},this)}})});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/rta/plugin/iframe/urlCleaner", [],function(){"use strict";return function(n){return n.replace(/\t|\r|\n/g,"")}});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/rta/plugin/rename/Rename", ["sap/base/Log","sap/ui/rta/plugin/rename/RenameDialog","sap/ui/rta/plugin/Plugin"],function(e,t,n){"use strict";var i=n.extend("sap.ui.rta.plugin.Rename",{metadata:{library:"sap.ui.rta",properties:{oldValue:"string"},associations:{},events:{editable:{},nonEditable:{}}}});i.prototype.init=function(...e){n.prototype.init.apply(this,e);this._oDialog=new t};i.prototype.startEdit=async function(e){const t=this.getResponsibleElementOverlay(e);const n=this.getAction(e).domRef;const i=await this._oDialog.openDialogAndHandleRename({overlay:e,domRef:n,action:this.getAction(t)});if(i){this.createRenameCommand(e,i)}};i.prototype.handler=function(e){const t=this.getSelectedOverlays();const[n]=t?.length>0?t:e;this.startEdit(n)};i.prototype.isRenameAvailable=function(e){return this._isEditableByPlugin(e)};i.prototype.isRenameEnabled=function(e){return this.isEnabled(e)};i.prototype.isEnabled=function(e){if(e.length>1){return false}var t=e[0];var n=this.getResponsibleElementOverlay(t);var i=true;if(!this.getAction(n)){i=false}var a=this.getAction(t);if(i&&typeof a.isEnabled!=="undefined"){if(typeof a.isEnabled==="function"){i=a.isEnabled(t.getElement())}else{i=a.isEnabled}}if(i){var o=t.getDesignTimeMetadata();var r=o.getAssociatedDomRef(t.getElement(),a.domRef);if(!r){i=false}}return i};i.prototype._isEditable=function(e){return this._checkChangeHandlerAndStableId(e)};i.prototype.createRenameCommand=function(t,n){var i=this.getResponsibleElementOverlay(t);var a=i.getElement();var o=i.getDesignTimeMetadata();var r=this.getVariantManagementReference(i);return this.getCommandFactory().getCommandFor(a,"rename",{renamedElement:a,newValue:n},o,r).then(function(e){this.fireElementModified({command:e})}.bind(this)).catch(function(t){e.error("Error during rename: ",t)})};i.prototype.getMenuItems=function(e){return this._getMenuItems(e,{pluginId:"CTX_RENAME",icon:"sap-icon://edit"})};i.prototype.getActionName=function(){return"rename"};i.prototype.destroy=function(...e){n.prototype.destroy.apply(this,e);this._oDialog.destroy();delete this._oDialog};return i});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/rta/plugin/rename/RenameDialog", ["sap/ui/base/ManagedObject","sap/ui/core/Element","sap/ui/core/Fragment","sap/ui/model/json/JSONModel","sap/ui/model/resource/ResourceModel","sap/ui/rta/util/validateText","sap/ui/rta/Utils"],function(e,t,o,a,i,s,n){"use strict";const l=e.extend("sap.ui.rta.plugin.rename.RenameDialog");l.prototype._createPopup=async function(){const e=await o.load({name:"sap.ui.rta.plugin.rename.RenameDialog",controller:this});e.addStyleClass(n.getRtaStyleClassName());this.oDialogModel=new a;e.setModel(this.oDialogModel);const t=new i({bundleName:"sap.ui.rta.messagebundle"});e.setModel(t,"i18n");return e};l.prototype._openPopup=function(){this._oDialog.open();const e=t.getElementById("sapUiRtaRenameDialog_input");e.getFocusDomRef().select();return new Promise(e=>{this._fnResolveAfterClose=e})};l.prototype.openDialogAndHandleRename=async function(e){this._oDialog=await this._createPopup();const t=e.overlay;const o=t.getElement();const a=t.getDesignTimeMetadata();const i=a.getAssociatedDomRef(o,e.domRef);const s=typeof e.action.getTextMutators==="function"?e.action.getTextMutators(o).getText():i.textContent;this.oDialogModel.setData({oldText:s,newText:s});this.oDialogModel.refresh(true);this.oAction=e.action;const n=await this._openPopup();const l=new Promise(e=>{this._oDialog.attachAfterClose(()=>{this._oDialog.destroy();e()})});this._oDialog.close();await l;return n};const r={VALID:"VALID",INVALID:"INVALID",SAME_TEXT:"SAME_TEXT"};l.prototype.checkValidRename=function(){const e=this.oDialogModel.getData();const t=e.newText||"";const o=e.oldText||"";try{s(t,o,this.oAction);this.oDialogModel.setProperty("/validationError",undefined);return r.VALID}catch(e){if(e.message==="sameTextError"){this.oDialogModel.setProperty("/validationError",undefined);return r.SAME_TEXT}this.oDialogModel.setProperty("/validationError",e.message);this.oDialogModel.setProperty("/isValidRename",false);return r.INVALID}};l.prototype.onTextChange=function(e){const t=e.getParameter("value").trim("");this.oDialogModel.setProperty("/newText",t.length?t:" ");this.checkValidRename()};l.prototype.onSave=function(){if(this.checkValidRename()===r.VALID){this._fnResolveAfterClose(this.oDialogModel.getData().newText)}else if(this.checkValidRename()===r.SAME_TEXT){this._fnResolveAfterClose()}};l.prototype.onCancel=function(){this._fnResolveAfterClose()};l.prototype.destroy=function(...t){e.prototype.destroy.apply(this,t);if(this._oDialog){this._oDialog.destroy()}};return l});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/rta/service/Action", ["sap/ui/dt/OverlayRegistry","sap/ui/dt/Util","sap/base/util/restricted/_castArray","sap/base/util/restricted/_pick"],function(r,t,n,e){"use strict";return function(t){function i(r,t){return typeof r==="function"?r(t):r}function o(r){var n=t._oDesignTime.getPlugins().map(function(t){return t.getMenuItems(r)});return Promise.all(n).then(function(t){return t.reduce(function(r,t){return t?r.concat(t):r},[]).map(function(t){return{...t,enabled:i(t.enabled,r),text:i(t.text,r[0])}})})}function u(t){var i=n(t);var u=i.map(function(t){var n=r.getOverlay(t);if(!n){throw new Error(`Control with id="${t}" is not under a root element or ignored.'`)}return n});return o(u).then(function(r){return r.map(function(r){return e(r,["id","icon","rank","group","enabled","text"])})})}function a(t,e){var i=n(t);var u=i.map(function(t){var n=r.getOverlay(t);if(!n){throw new Error(`Control with id="${t}" is not under a root element or ignored.`)}return n});return o(u).then(function(r){var t=r.filter(function(r){return r.id===e}).pop();if(!t){throw new Error("No action found by specified ID")}else{return t.handler(u,{})}})}return{exports:{get:u,execute:a}}}});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/rta/service/ControllerExtension", ["sap/ui/core/Element","sap/ui/dt/OverlayRegistry","sap/ui/dt/Util","sap/ui/fl/apply/api/FlexRuntimeInfoAPI","sap/ui/fl/write/api/ChangesWriteAPI","sap/ui/fl/write/api/PersistenceWriteAPI","sap/ui/fl/Utils"],function(e,r,t,o,a,n,i){"use strict";return function(l){async function s(e){const r=await fetch(`${sap.ui.require.toUrl(e)}.js`);if(!r.ok){throw new Error(`resource ${e} could not be loaded from ${e}. Check for 'file not found' or parse errors. Reason: ${r.statusText}`)}return r.text()}return{exports:{add(r,s){var c=l.getFlexSettings();if(!c.developerMode){throw t.createError("service.ControllerExtension#add","code extensions can only be created in developer mode","sap.ui.rta")}if(!r){throw t.createError("service.ControllerExtension#add","can't create controller extension without codeRef","sap.ui.rta")}if(!r.endsWith(".js")){throw t.createError("service.ControllerExtension#add","codeRef has to end with 'js'")}var d=e.getElementById(s);var p=i.getAppComponentForControl(d);var u=d.getControllerModuleName()?`module:${d.getControllerModuleName()}`:d.getController()?.getMetadata().getName();var f=o.getFlexReference({element:p});var g=f.replace(/\.Component/g,"").replace(/\./g,"/");g+="/changes/";g+=r.replace(/\.js/g,"");var v={codeRef:r,controllerName:u,changeType:"codeExt",layer:c.layer,namespace:c.namespace,reference:f,moduleName:g,generator:"rta.service.ControllerExtension"};var m=a.create({changeSpecificData:v,selector:p});n.add({change:m,selector:p});return m.convertToFileContent()},getTemplate(e){var o=r.getOverlay(e);if(!o){throw t.createError("service.ControllerExtension#getTemplate","no overlay found for the given view ID","sap.ui.rta")}var a=o.getDesignTimeMetadata().getControllerExtensionTemplate();return s(`${a}-dbg`).catch(function(){return s(a)})}}}}});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/rta/service/Outline", ["sap/base/Log","sap/base/util/deepEqual","sap/base/util/isEmptyObject","sap/base/util/merge","sap/base/util/restricted/_omit","sap/ui/dt/AggregationOverlay","sap/ui/dt/ElementOverlay","sap/ui/dt/OverlayRegistry","sap/ui/dt/Util","sap/ui/fl/apply/api/ExtensionPointRegistryAPI","sap/ui/fl/Utils","sap/ui/core/mvc/View","sap/ui/base/DesignTime"],function(e,t,n,i,a,r,s,o,g,l,d,u,m){"use strict";function v(e,t){var n=l.getExtensionPointInfoByViewId({viewId:e});return a(n,t)}function c(e){return a(e,["bIsView"])}return function(p,f){var h={};h.mExtensionPointMetadata={palette:{icons:{svg:"sap/ui/core/designtime/Icon.icon.svg"}}};h._aConsideredExtensionPoints=[];h._attachNotConsideredExtensionPoints=function(e,t){var n=d.getViewForControl(e.getElement()).getId();var i=v(n,this._aConsideredExtensionPoints);Object.keys(i).forEach(function(e,a){var r=i[e];var s=this._getExtensionPointData(r);s.id=n;t.elements.splice(a,0,s);this._aConsideredExtensionPoints.push(s.name)}.bind(this))};h._getOutline=function(e,t){var n;if(!t&&g.isInteger(e)){t=e;e=undefined}var i=[];if(!e){i=p._oDesignTime.getRootElements().map(function(e){return o.getOverlay(e)})}else{var a=o.getOverlay(e);if(!a){throw g.createError("services.Outline#get",`Cannot find element with id= ${e}. A valid or empty value for the initial element id should be provided.`,"sap.ui.rta")}i.push(a)}n=i.map(function(e){return this._getChildrenNodes(e,t)},this);this._aConsideredExtensionPoints=[];return n};h._getExtensionPoints=function(e){var t=e.id;var n=e.technicalName;return l.getExtensionPointInfoByParentId({parentId:t}).filter(function(e){return e.aggregationName===n})};h._getExtensionPointData=function(e){return{id:e.targetControl.getId(),name:e.name,technicalName:"sap.ui.extensionpoint",type:"extensionPoint",icon:this.mExtensionPointMetadata.palette.icons.svg,extensionPointInfo:{defaultContent:e.defaultContent.map(function(e){return e.getId()}),createdControls:e.createdControls||[]}}};h._enrichExtensionPointData=function(e,t){var n=m.isDesignModeEnabled();if(!n){return undefined}if(e.type==="aggregation"){var i=this._getExtensionPoints(e).sort(function(e,t){return t.index-e.index});i.forEach(function(t){var n=this._getExtensionPointData(t);e.elements.splice(t.index,0,n);this._aConsideredExtensionPoints.push(n.name)}.bind(this))}else if(e.bIsView){return this._attachNotConsideredExtensionPoints(t,e)}return undefined};function y(e,t,n){var i=e.getAggregationName&&e.getAggregationName();if(i){var a=e.getParent().getId();if(n[i]){return{templateFor:a,...n[i]}}return(t&&t.elements||[]).map(function(e){if(e.type==="aggregationBindingTemplate"||e.parentAggregationName===i){return{templateFor:a,...e}}return e.technicalName===i&&e}).filter(Boolean)[0]}var r=e.getParentElementOverlay().getAggregationBindingTemplateOverlays&&e.getParentElementOverlay().getAggregationBindingTemplateOverlays().reduce(function(e,t){return e.concat(t.getChildren())},[])||[];if(r.includes(e)){return undefined}if(!t){return undefined}var s=e.getParentElementOverlay();if(s.getId()===t.templateFor){return t}var o=e.getParent().getChildren().indexOf(e);return t.elements[o]}h._getChildrenNodes=function(e,t,a,r){var s=g.isInteger(t);var o={};if(e.getShouldBeDestroyed()){return{}}var l=this._getNodeProperties(e,a,r)||{};var d=e.getChildren();var u=e.getAggregationBindingTemplateOverlays&&e.getAggregationBindingTemplateOverlays()||[];if(u.length>0){d=u.reduce(function(e,t){var n=t.getChildren()[0];o[n.getId()]=t.getAggregationName();return[n].concat(e)},d)}if((!s||s&&t>0)&&d.length>0&&!n(l)){t=s?t-1:t;var m={};l.elements=d.map(function(e){var n=y(e,r,m);var a=this._getChildrenNodes(e,t,e.getParent(),n);if(a.type==="aggregationBindingTemplate"){var s=o[e.getId()];m[s]=i({},a)}return a},this).filter(function(e){return!n(e)});this._enrichExtensionPointData(l,e)}return c(l)};function E(e,t,n){var i=e.getParentElementOverlay();return i&&n&&i.getAggregationOverlay(n,"AggregationBindingTemplateOverlays")===t}function _(e,t,n){var i={editable:e.getEditable(),bIsView:e.getElement()instanceof u};if(t.isA("sap.ui.core.Component")){i.component=true}if(typeof e.isVisible()==="boolean"){i.visible=e.isVisible()}var a=e.getParent()&&e.getParentAggregationOverlay();var r=a&&a.getAggregationName()||"";if(E(e,a,r)){i.type="aggregationBindingTemplate";i.icon="sap-icon://attachment-text-file";i.parentAggregationName=r}else{i.type="element"}var s=n.getName(t);if(s&&s.singular){i.name=s&&s.singular}return i}function O(e,t,n){var i=e.getAggregationName();var a={technicalName:e.getAggregationName(),editable:false,type:"aggregation",bIsView:e.getElement()instanceof u};if(t.getAggregation(i)){var r=t.getDesignTimeMetadata().getAggregationDescription(i,n);if(r.singular){a.name=r.singular}}if(t.getAggregationBindingTemplateOverlays().length){a.icon="sap-icon://card"}return a}function b(e,t,n){var i={id:e.getId(),technicalName:e.getMetadata().getName(),editable:false,type:null};if(n){i.templateReference=n.id}var a=P(t);if(a){i.icon=a}var r=t.getLabel(e);if(r&&r!==i.id){i.instanceName=r}return i}function P(e){var t=e.getData();return t.palette&&t.palette.icons&&t.palette.icons.svg||undefined}h._getNodeProperties=function(e,t,n){var i=e.getElement();var a=e.getDesignTimeMetadata();var r=b(i,a,n);if(e instanceof s){return{...r,..._(e,i,a)}}return{...r,...O(e,t,i)}};h._removeDuplicate=function(e,n){return e.filter(function(e){return!t(n,e,Infinity)})};h._updatesHandler=function(t){var n=t.getParameters();if(this.sStatus==="initial"){this.aUpdates=[]}var s=i({},n);var g=s.id?o.getOverlay(s.id).getElement().getId():undefined;var l=s.targetId?o.getOverlay(s.targetId).getElement().getId():undefined;switch(t.getId()){case"elementOverlayCreated":if(n.elementOverlay.isRoot()){var d=n.elementOverlay.getElement().getId();[s.element]=h._getOutline(d);s.type="new";break}return;case"elementOverlayAdded":[s.element]=h._getOutline(g);s.targetId=l;s.type="new";break;case"elementOverlayMoved":[s.element]=h._getOutline(g,0);s.targetId=l;s.type="move";break;case"elementOverlayDestroyed":var u=s.elementOverlay.getParentAggregationOverlay();if(u instanceof r&&!u._bIsBeingDestroyed||s.elementOverlay.isRoot()){s.element={};s.element.id=s.elementOverlay.getElement()?s.elementOverlay.getElement().getId():s.elementOverlay.getAssociation("element");s.type="destroy";break}return;case"elementOverlayEditableChanged":s.element={id:g,editable:s.editable};s.type="editableChange";break;case"elementPropertyChanged":[s.element]=h._getOutline(g,0);s.type="elementPropertyChange";break;default:e.error("Event type is not 'expected' by handler")}s=a(s,["elementOverlay","editable","target","id","elementId"]);this.aUpdates=h._removeDuplicate(this.aUpdates,s);this.aUpdates.push(s);if(this.sStatus==="initial"){setTimeout(function(){if(Array.isArray(this.aUpdates)&&this.aUpdates.length>0){this.sStatus="initial";f("update",this.aUpdates)}}.bind(h),200)}this.sStatus="processing"};h.destroy=function(){p._oDesignTime?.detachEvent("elementOverlayCreated",this._updatesHandler,this);p._oDesignTime?.detachEvent("elementOverlayAdded",this._updatesHandler,this);p._oDesignTime?.detachEvent("elementOverlayMoved",this._updatesHandler,this);p._oDesignTime?.detachEvent("elementOverlayDestroyed",this._updatesHandler,this);p._oDesignTime?.detachEvent("elementPropertyChanged",this._updatesHandler,this);p._oDesignTime?.detachEvent("elementOverlayEditableChanged",this._updatesHandler,this);delete this.aUpdates;delete this.sStatus};h.aUpdates=[];h.sStatus="initial";p._oDesignTime.attachEvent("elementOverlayCreated",h._updatesHandler,h);p._oDesignTime.attachEvent("elementOverlayAdded",h._updatesHandler,h);p._oDesignTime.attachEvent("elementOverlayMoved",h._updatesHandler,h);p._oDesignTime.attachEvent("elementOverlayDestroyed",h._updatesHandler,h);p._oDesignTime.attachEvent("elementPropertyChanged",h._updatesHandler,h);p._oDesignTime.attachEvent("elementOverlayEditableChanged",h._updatesHandler,h);return{events:["update"],exports:{get:h._getOutline.bind(h)},destroy:h.destroy.bind(h)}}});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/rta/service/Property", ["sap/ui/dt/OverlayRegistry","sap/ui/dt/Util","sap/base/util/isEmptyObject","sap/base/util/merge","sap/base/util/restricted/_omit"],function(e,t,n,r,i){"use strict";var o="[NOT SERIALIZABLE]";function a(e,t,n){if(Object(e)!==e){return true}if(typeof e==="function"){return false}if(typeof e==="object"){if(Array.isArray(e)){return e.every(a)}else if(e instanceof Map){var r={};e.forEach(function(e,t){r[t]=e});if(n){n[t]=r}e=r}return Object.keys(e).every(function(t){return a(e[t],t,e)})}return false}function u(e){return a(e)?e:o}return function(){var o={};o._getDesignTimeProperties=function(i){var a=e.getOverlay(i);if(!a){return t.createError("service.Property#get","A valid control id was not passed","sap.ui.rta")}var s=a.getElement();var l=s.getMetadata().getAllProperties();var g=a.getDesignTimeMetadata();var f=r({},g.getData());var c=f.properties||{};var d=f.annotations||{};var p=f.getLabel;return Promise.all([o._getConsolidatedAnnotations(d,s),o._getConsolidatedProperties(c||{},l,s),o._getResolvedFunction(p,s),o._getResolvedLinks(f.links,s)]).then(function(e){return{...e[0]&&!n(e[0])&&{annotations:e[0]},...e[1]&&{properties:e[1]},...e[2]&&{label:u(e[2])},...f.name&&{name:g.getName(s)},...!n(e[3])&&{links:e[3]}}})};o._getConsolidatedProperties=function(e,n,a){var s=Object.keys(n).reduce(function(e,t){e[t]={value:u(a.getProperty(t)),virtual:false,type:n[t].type,name:n[t].name,ignore:false,group:n[t].group,deprecated:n[t].deprecated,defaultValue:n[t].defaultValue,visibility:n[t].visibility};var r=o._getBindingInfo(t,a);Object.assign(e[t],r&&{binding:r});return e},{});return o._getResolvedFunction(e,a).then(function(e){return Promise.all(Object.keys(e).map(function(n){return o._getResolvedFunction(e[n].ignore,a).then(function(r){if(typeof r!=="boolean"){throw t.createError("services.Property#get",`Invalid ignore property value found in designtime for element with id ${a.getId()} .`,"sap.ui.rta")}var l={};if(!s[n]){if(e[n].virtual===true){l=o._getEvaluatedVirtualProperty(e,n,a,r)}else{l[n]={value:u(i(e[n],"ignore")),virtual:false,ignore:r}}}else{l[n]={ignore:r}}return l})}))}).then(function(e){return e.reduce(function(e,t){return r(e,t)},s)})};o._getEvaluatedVirtualProperty=function(e,t,n,r){var i={};i[t]={value:u(e[t].get(n)),virtual:true,type:e[t].type,name:e[t].name,group:e[t].group,ignore:r};var a=o._getBindingInfo(t,n);return o._getResolvedFunction(e[t].possibleValues,n).then(function(n){Object.assign(i[t],a&&{binding:a},n&&{possibleValues:u(n)},typeof e[t].nullable==="boolean"&&{nullable:e[t].nullable});return i})};o._getConsolidatedAnnotations=function(e,r){return Promise.all(Object.keys(e).map(function(i){return o._getResolvedFunction(e[i].ignore,r).then(function(a){var u={};if(typeof a!=="boolean"&&typeof a!=="undefined"){throw t.createError("services.Property#get",`Invalid ignore property value found in designtime for element with id ${r.getId()} .`,"sap.ui.rta")}e[i].ignore=a;if(!a){u[i]={...e[i]};return o._getResolvedLinks(u[i].links,r).then(function(e){if(!n(e)){u[i].links=e}return u})}})})).then(function(e){return e.reduce(function(e,t){return Object.assign(e,t)},{})})};o._getResolvedLinks=function(e,n){var r=[];var i={...e};Object.keys(i).forEach(function(e){if(Array.isArray(i[e])){i[e].forEach(function(e){r.push(t.wrapIntoPromise(function(){if(typeof e.text==="function"){return e.text(n)}})(e).then(function(t){e.text=u(t||e.text)}))})}});return Promise.all(r).then(function(){return i})};o._getBindingInfo=function(e,t){var n=t.getBindingInfo(e);if(!n){return}return r({},n.parts&&{parts:n.parts},n.binding&&{bindingValues:{values:n.binding.getValue()}},n.binding&&n.binding.getOriginalValue&&{bindingValues:{originalValues:n.binding.getOriginalValue()}},n.bindingString&&{bindingString:n.bindingString})};o._getResolvedFunction=function(e,n){return t.wrapIntoPromise(function(){return typeof e==="function"?e(n)||false:e||false})(e,n)};return{exports:{get:o._getDesignTimeProperties.bind(o)}}}});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/rta/service/Receiver", ["sap/ui/core/postmessage/Bus","sap/ui/dt/Util","sap/base/util/uid"],function(e,t,s){"use strict";var i="sap.ui.rta.service.receiver";var r;return function(n){var c={};var a=function(e){var a=e.data;var u=a.body;switch(e.eventId){case"getService":var o=u.arguments[0];n.getService(o).then(function(t){var s={};var c=[];Object.keys(t).forEach(function(e){if(typeof t[e]==="function"){if(!/^(at|de)tach/.test(e)){c.push(e)}}else{s[e]=t[e]}});r.publish({target:e.source,origin:e.origin,channelId:i,eventId:"getService",data:{id:a.id,type:"response",body:{methods:c,properties:s,events:n._mServices[o].service.events}}})});break;case"callMethod":n.getService(u.service).then(function(t){t[u.method].apply(null,u.arguments).then(function(t){r.publish({target:e.source,origin:e.origin,channelId:i,eventId:"callMethod",data:{type:"response",status:"success",id:a.id,body:t}})})}).catch(function(s){var n=t.propagateError(s,"service.Receiver",`Unexpected error: Can't execute method ${u.method} of service ${u.service}`,"sap.ui.rta");r.publish({target:e.source,origin:e.origin,channelId:i,eventId:"callMethod",data:{type:"response",status:"error",id:a.id,body:n.toString()}})});break;case"subscribe":n.getService(u.service).then(function(t){var n=function(t){r.publish({target:e.source,origin:e.origin,channelId:i,eventId:"event",data:{body:{service:u.service,event:u.event,data:t}}})};var o=s();c[o]=n;t.attachEvent(u.event,n);r.publish({target:e.source,origin:e.origin,channelId:i,eventId:"subscribe",data:{type:"response",status:"success",id:a.id,body:{id:o}}})});break;case"unsubscribe":n.getService(u.service).then(function(t){t.detachEvent(u.event,c[u.id]);delete c[u.id];r.publish({target:e.source,origin:e.origin,channelId:i,eventId:"unsubscribe",data:{type:"response",status:"success",id:a.id}})});break;default:}};r=e.getInstance();r.publish({channelId:i,eventId:e.event.READY});r.subscribe(i,"getService",a);r.subscribe(i,"callMethod",a);r.subscribe(i,"subscribe",a);r.subscribe(i,"unsubscribe",a);return{destroy(){if(r){r.unsubscribe(i,"getService",a);r.unsubscribe(i,"callMethod",a);r.unsubscribe(i,"subscribe",a);r.unsubscribe(i,"unsubscribe",a)}}}}});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/rta/service/Selection", function(){"use strict";return function(e,n){var t=e._oDesignTime.getSelectionManager();function r(e){return e.map(function(e){return e.getElement().getId()})}t.attachEvent("change",function(e){n("change",r(e.getParameter("selection")))});return{events:["change"],exports:{get(){return r(t.get())},set:t.set.bind(t),add:t.add.bind(t),remove:t.remove.bind(t),reset:t.reset.bind(t),addHover:t.addHover.bind(t),removeHover:t.removeHover.bind(t)}}}});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/rta/service/SupportTools", ["sap/base/Log","sap/ui/core/Element","sap/ui/core/util/reflection/JsControlTreeModifier","sap/ui/dt/OverlayRegistry","sap/ui/fl/write/api/ChangesWriteAPI"],function(e,t,n,i,o){"use strict";const a="sapUiFlexibilitySupportExtension_Selected";const l="ui5flex$temp";window[l]={};const s=window[l];let r=0;function c(e,t){console.log(`Flextention: ${e}`);if(t){console.log(t)}}function d(e,t,i){const a=e.getAction(t);if(a&&a.changeType){const e=a.changeOnRelevantContainer?t.getRelevantContainer():t.getElement();return o.getChangeHandler({changeType:a.changeType,element:e,modifier:n,layer:i.getLayer()}).then(function(e){return e}).catch(function(){return})}return Promise.resolve(undefined)}function u(e){if(e.endsWith(".asSibling")){return true}if(e.endsWith(".asChild")){return false}return undefined}function g(e,t){const n=u(t);const i=e.getPlugins();return Object.values(i).find(function(e){const i=e._retrievePluginName?e._retrievePluginName(n):e.getMetadata().getName();return i===t})}function f(){const e=document.getElementsByClassName(a);if(e.length>0){e[0].classList.remove(a)}}async function p(e,n){const i=t.getElementById(n.overlayId);if(!i){return null}const o=i.getElement();if(i.getSelectable()){f()}const a=i.getEditableByPlugins();const l=Object.keys(a).filter(function(e){return a[e]});const s=await Promise.all(l.map(async function(t){const n=g(e,t);const o=u(t);const a=await d(n,i,e);return{name:t,isAvailable:n.isAvailable([i],o),hasChangeHandler:!!a}}));return{elementId:o.getId(),elementControlType:o.getMetadata().getName(),overlayId:i.getId(),plugins:s}}async function y(e,n){const i=t.getElementById(n.overlayId);const o=g(e,n.pluginName);const a=await d(o,i,e);if(o){try{const e=o.getId();const t=s[e]&&s[e].savedAs||`ui5flex$${r++}`;s[e]={description:`ChangeHandler for Plugin: ${e} - ${n.pluginName}`,changeHandler:a,savedAs:t};const i=s[e];window[t]=s[e];const d=`ChangeHandler copied to global var ${t}, all vars are collected in global var ${l}`;c(d,i)}catch(e){}}else{c("ChangeHandler could not be logged",undefined)}}function m(e){if(document.getElementsByClassName("sapUiDtContextMenu").length>0){const t=e.getPlugins().contextMenu;t.oContextMenuControl.close()}}function v(e,n){const i=t.getElementById(n.overlayId);i.focus();window.postMessage({type:"getOverlayInfo",id:"ui5FlexibilitySupport.submodules.overlayInfo",content:{overlayId:i.getId()}});f();m(e);const o=e.getSelection();o.forEach(function(e){e.setSelected(false)});if(i.getSelectable()){i.setSelected(true)}else if(i.getDomRef()){i.getDomRef().classList.add("sapUiFlexibilitySupportExtension_Selected")}}function b(){const e=i.getOverlays();const t=[];e.forEach(function(e){if(!e.isA("sap.ui.dt.AggregationOverlay")){const n=e.getParentElementOverlay()?.getId();const i=e.getChildren().map(function(e){return e.getId()});t.push({id:e.getId(),parentId:n,elementId:e.getElement().getId(),visible:e.getSelectable()&&e.isVisible(),idNum:parseInt(e.getId().replace("__overlay","")),children:i,hasParent:n!==undefined})}});return t}function I(e,n){const i=t.getElementById(n.overlayId);const o=i.getDesignTimeMetadata().getData();if(o){try{const e=i.getDesignTimeMetadata().getId();const t=s[e]&&s[e].savedAs||`ui5flex$${r++}`;s[e]={description:`DesignTimeMetaData: ${e} for Overlay: ${n.overlayId}`,metaData:o,savedAs:t};const a=s[e];window[t]=s[e];const d=`MetaData copied to global var ${t}, all vars are collected in global var ${l}`;c(d,a)}catch(e){}}else{c("DesignTimeMetaData could not be logged",undefined)}}const h={getOverlayInfo:{handler:p,returnMessageType:"overlayInfo",id:"ui5FlexibilitySupport.submodules.overlayInfo"},printChangeHandler:{handler:y,id:"ui5FlexibilitySupport.submodules.overlayInfo"},printDesignTimeMetadata:{handler:I,id:"ui5FlexibilitySupport.submodules.overlayInfo"},changeOverlaySelection:{handler:v,id:"ui5FlexibilitySupport.submodules.overlayInfo"},collectOverlayTableData:{handler:b,returnMessageType:"overlayInfoTableData",id:"ui5FlexibilitySupport.submodules.overlayInfo"}};function w(){window.postMessage({type:"rtaStopped",id:"ui5FlexibilitySupport.submodules.overlayInfo",content:{}})}function S(){window.postMessage({type:"rtaStarted",id:"ui5FlexibilitySupport.submodules.overlayInfo",content:{}})}function M(e,t){if(t.source!==window){return}const n=Object.entries(h).find(function(e){return e[0]===t.data.type&&e[1].id===t.data.id});const i=n&&n[1];if(i){Promise.resolve(i.handler(e,t.data.content)).then(function(e){if(i.returnMessageType){t.source.postMessage({id:i.id,type:i.returnMessageType,content:e})}})}}return function(e){const t=M.bind(null,e);window.addEventListener("message",t);e.attachEventOnce("stop",w);S();return{destroy(){window.removeEventListener("message",t)}}}});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/rta/service/index", function(){"use strict";return Object.freeze({selection:"sap.ui.rta.service.Selection",receiver:"sap.ui.rta.service.Receiver",controllerExtension:"sap.ui.rta.service.ControllerExtension",outline:"sap.ui.rta.service.Outline",action:"sap.ui.rta.service.Action",property:"sap.ui.rta.service.Property",supportTools:"sap.ui.rta.service.SupportTools"})});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/rta/toolbar/Adaptation", ["sap/base/Log","sap/m/MessageBox","sap/m/MessageStrip","sap/m/Popover","sap/ui/core/message/MessageType","sap/ui/core/BusyIndicator","sap/ui/core/Element","sap/ui/core/Fragment","sap/ui/core/Popup","sap/ui/fl/apply/api/FlexRuntimeInfoAPI","sap/ui/fl/initial/api/Version","sap/ui/fl/write/api/ContextBasedAdaptationsAPI","sap/ui/model/json/JSONModel","sap/ui/performance/Measurement","sap/ui/rta/appVariant/Feature","sap/ui/rta/toolbar/contextBased/ManageAdaptations","sap/ui/rta/toolbar/contextBased/SaveAsAdaptation","sap/ui/rta/toolbar/translation/Translation","sap/ui/rta/toolbar/versioning/Versioning","sap/ui/rta/toolbar/AdaptationRenderer","sap/ui/rta/toolbar/Base","sap/ui/rta/util/guidedTour/content/GeneralTour","sap/ui/rta/util/guidedTour/GuidedTour","sap/ui/rta/util/whatsNew/WhatsNewOverview","sap/ui/rta/Utils"],function(t,e,i,o,n,s,r,a,h,c,d,l,u,p,f,g,b,_,m,A,I,T,v,w,D){"use strict";var R=I.extend("sap.ui.rta.toolbar.Adaptation",{renderer:A,animation:true,metadata:{library:"sap.ui.rta",events:{undo:{},redo:{},exit:{},save:{},restore:{},publishVersion:{},modeChange:{},activate:{},discardDraft:{},switchVersion:{},switchAdaptation:{},deleteAdaptation:{},openChangeCategorySelectionPopover:{},saveAndReload:{}}}});R.LEFT_SECTION="toolbarIconAndDraftSection";R.MIDDLE_SECTION="toolbarSwitcherSection";R.RIGHT_SECTION="toolbarActionsSection";var S=124;R.prototype.init=function(...t){this._mSizeLimits={switchToIcons:undefined};I.prototype.init.apply(this,t);this._pFragmentLoaded=this._pFragmentLoaded.then(function(){this._onResize=this._onResize.bind(this);window.addEventListener("resize",this._onResize);this._aIntersectionObservers=[]}.bind(this))};R.prototype._calculateWindowWidth=function(t){var e=t[0].intersectionRect.width;return e*2+this._iSwitcherToolbarWidth+80};R.prototype.exit=function(...t){window.removeEventListener("resize",this._onResize);this._aIntersectionObservers.forEach(function(t){t.disconnect()});I.prototype.exit.apply(this,t)};R.prototype._restoreHiddenElements=function(){delete this._iOnResizeAnimationFrame;if(window.innerWidth>this._mSizeLimits.switchToIcons){this._switchToTexts();delete this._mSizeLimits.switchToIcons}};R.prototype._onResize=function(){if(this._iOnResizeAnimationFrame){window.cancelAnimationFrame(this._iOnResizeAnimationFrame)}this._iOnResizeAnimationFrame=window.requestAnimationFrame(this._restoreHiddenElements.bind(this))};R.prototype.initialAdjustToolbarSectionWidths=function(){var t=this.getControl("modeSwitcher").getDomRef().getBoundingClientRect().width;this._iSwitcherToolbarWidthWithTexts=t+16;this._iSwitcherToolbarWidth=this._iSwitcherToolbarWidthWithTexts;this.adjustToolbarSectionWidths()};R.prototype.adjustToolbarSectionWidths=function(){this.getControl(R.MIDDLE_SECTION).setWidth(`${this._iSwitcherToolbarWidth}px`);[R.LEFT_SECTION,R.RIGHT_SECTION].forEach(function(t){this.getControl(t).getDomRef().style.setProperty("width",`calc(50% - ${Math.ceil(this._iSwitcherToolbarWidth/2)}px)`,"important")}.bind(this))};R.prototype._observeIntersections=function(){this._aIntersectionObservers.forEach(function(t){t.disconnect()});[R.LEFT_SECTION,R.RIGHT_SECTION].forEach(function(t){var e=this._createIntersectionObserver(t);this._observeToolbarIntersection(t,e);this._aIntersectionObservers.push(e)}.bind(this))};R.prototype._hideElementsOnIntersection=function(t,e){if(e[0].intersectionRatio===0){this.adjustToolbarSectionWidths();this._observeIntersections();return}if(e[0].intersectionRatio<1){if(!this._mSizeLimits.switchToIcons){this._mSizeLimits.switchToIcons=this._calculateWindowWidth(e);this._switchToIcons()}}};R.prototype._createIntersectionObserver=function(t){return new IntersectionObserver(this._hideElementsOnIntersection.bind(this,t),{threshold:1,root:this.getControl(t).getDomRef()})};R.prototype._observeToolbarIntersection=function(t,e){var i=this.getControl(t);i.getItems().map(function(t){var i=t.getDomRef();e.observe(i)})};R.prototype.show=function(){return I.prototype.show.call(this,this.initialAdjustToolbarSectionWidths.bind(this)).then(function(){this._observeIntersections()}.bind(this))};function y(t,e,i,o){var n=this.getControl(t);var s=i?this.getTextResources().getText(i):"";var r=o?this.getTextResources().getText(o):"";n.setText(s||"");n.setTooltip(r||"");n.setIcon(e||"")}R.prototype.formatPublishVersionVisibility=function(t,e,i,o){return this.getExtension("versioning",m).formatPublishVersionVisibility(t,e,i,o)};R.prototype.formatDiscardDraftVisible=function(t,e,i){return this.getExtension("versioning",m).formatDiscardDraftVisible(t,e,i)};R.prototype.formatVersionButtonText=function(t,e){return this.getExtension("versioning",m).formatVersionButtonText(t,e)};R.prototype.showVersionHistory=function(t){return this.getExtension("versioning",m).showVersionHistory(t)};R.prototype._openVersionTitleDialog=function(t){return this.getExtension("versioning",m).openActivateVersionDialog(t)};R.prototype.showHardReloadInfoPopover=function(t){this._oHardReloadInfoPopover||=new o({placement:"Bottom",content:[new i({text:this.getTextResources().getText("MSG_HARD_RELOAD_INFO"),type:n.Warning,showIcon:true})],showHeader:false,contentWidth:"18rem"});this.addDependent(this._oHardReloadInfoPopover);this._oHardReloadInfoPopover.openBy(t.getSource())};R.prototype.showActionsMenu=function(t){var e=t.getSource();if(!this._oActionsMenuFragment){return a.load({id:`${this.getId()}_actionsMenu_fragment`,name:"sap.ui.rta.toolbar.ActionsMenu",controller:{openDownloadTranslationDialog:x.bind(this),openUploadTranslationDialog:C.bind(this),manageApps:z.bind(this),overviewForKeyUser:W.bind(this),overviewForDeveloper:k.bind(this),restore:this.eventHandler.bind(this,"Restore"),formatSaveAsEnabled:E,saveAs:O.bind(this),openWhatsNewOverviewDialog:U,openGuidedTour:$}}).then(function(t){t.addStyleClass(D.getRtaStyleClassName());this.addDependent(t);t.openBy(e,true,h.Dock.CenterTop,h.Dock.CenterBottom);this._oActionsMenuFragment=t}.bind(this))}this._oActionsMenuFragment.openBy(e,true,h.Dock.CenterTop,h.Dock.CenterBottom);return Promise.resolve()};R.prototype._showButtonIcon=function(t,e,i){y.call(this,t,e,"",i)};R.prototype._showButtonText=function(t,e){y.call(this,t,"",e,"")};R.prototype._switchToIcons=function(){this._showButtonIcon("adaptationSwitcherButton","sap-icon://wrench","BTN_ADAPTATION");this._showButtonIcon("navigationSwitcherButton","sap-icon://explorer","BTN_NAVIGATION");this._showButtonIcon("visualizationSwitcherButton","sap-icon://show","BTN_VISUALIZATION");this._iSwitcherToolbarWidth=S;this.adjustToolbarSectionWidths()};R.prototype._switchToTexts=function(){this._showButtonText("adaptationSwitcherButton","BTN_ADAPTATION");this._showButtonText("navigationSwitcherButton","BTN_NAVIGATION");this._showButtonText("visualizationSwitcherButton","BTN_VISUALIZATION");this._iSwitcherToolbarWidth=this._iSwitcherToolbarWidthWithTexts;this.adjustToolbarSectionWidths()};R.prototype.buildControls=function(){return a.load({name:"sap.ui.rta.toolbar.Adaptation",id:`${this.getId()}_fragment`,controller:{activate:this._openVersionTitleDialog.bind(this),discardDraft:this.eventHandler.bind(this,"DiscardDraft"),formatDiscardDraftVisible:this.formatDiscardDraftVisible.bind(this),formatPublishVersionVisibility:this.formatPublishVersionVisibility.bind(this),modeChange:this.eventHandler.bind(this,"ModeChange"),undo:this.eventHandler.bind(this,"Undo"),redo:this.eventHandler.bind(this,"Redo"),openChangeCategorySelectionPopover:this.eventHandler.bind(this,"OpenChangeCategorySelectionPopover"),saveAsAdaptation:N.bind(this),editAdaptation:F.bind(this),deleteAdaptation:P.bind(this),manageAdaptations:L.bind(this),switchAdaptation:G.bind(this),formatAdaptationsMenuText:H.bind(this),publishVersion:this.eventHandler.bind(this,"PublishVersion"),save:this.eventHandler.bind(this,"Save"),exit:this.eventHandler.bind(this,"Exit"),formatVersionButtonText:this.formatVersionButtonText.bind(this),showVersionHistory:this.showVersionHistory.bind(this),showActionsMenu:this.showActionsMenu.bind(this),showFeedbackForm:this.showFeedbackForm.bind(this),showHardReloadInfoPopover:this.showHardReloadInfoPopover.bind(this),saveAndReloadApp:this.eventHandler.bind(this,"SaveAndReload")}})};function x(){var t={layer:this.getRtaInformation().flexSettings.layer,selector:this.getRtaInformation().rootControl};this.getExtension("translation",_).openDownloadTranslationDialog(t)}function C(){this.getExtension("translation",_).openUploadTranslationDialog()}function E(t,e){return t&&e!==d.Number.Draft}function O(){f.onSaveAs(true,true,this.getRtaInformation().flexSettings.layer,null)}function M(t){var i=t.commandStack.canSave();return D.showMessageBox("confirm",i?"DAC_DIALOG_MIGRATION_DIRTY_DESCRIPTION":"DAC_DIALOG_MIGRATION_DESCRIPTION",{titleKey:"DAC_DIALOG_MIGRATION_HEADER",actionKeys:["DAC_DIALOG_MIGRATION_HEADER"],showCancel:true}).then(function(o){if(o!==e.Action.CANCEL){if(i){return new Promise(function(t){this.fireEvent("save",{callback:t})}.bind(this)).then(function(){return B.call(this,t)}.bind(this))}return B.call(this,t)}}.bind(this))}function B(e){s.show();p.start("onCBAMigration","Measurement of migration to context-based adaptation");return l.migrate({control:e.rootControl,layer:e.flexSettings.layer}).finally(function(){p.end("onCBAMigration");p.getActive()&&t.info(`onCBAMigration: ${p.getMeasurement("onCBAMigration").time} ms`);s.hide()}).then(D.showMessageBox.bind(undefined,"information","DAC_DIALOG_MIGRATION_SUCCESSFULL_DESCRIPTION",{titleKey:"DAC_DIALOG_MIGRATION_HEADER"})).then(function(){return new Promise(function(t){this.fireEvent("switchAdaptation",{adaptationId:"DEFAULT",callback:t})}.bind(this))}.bind(this)).catch(function(e){t.error(e.stack||e);var i="DAC_DIALOG_MIGRATION_ERROR_DESCRIPTION";var o={titleKey:"DAC_DIALOG_MIGRATION_HEADER",details:e.userMessage||e};D.showMessageBox("error",i,o)})}function N(){var e=this.getRtaInformation();D.checkDraftOverwrite(this.getModel("versions")).then(function(){p.start("onCBACanMigrate","Measurement if its possible to migrate to context-based adaptation");return l.canMigrate({control:e.rootControl,layer:e.flexSettings.layer})}).then(function(i){p.end("onCBACanMigrate");p.getActive()&&t.info(`onCBACanMigrate: ${p.getMeasurement("onCBACanMigrate").time} ms`);if(i){M.call(this,e)}else{this.getExtension("contextBasedSaveAs",b).openAddAdaptationDialog(e.flexSettings.layer)}}.bind(this)).catch(V)}function F(){D.checkDraftOverwrite(this.getModel("versions")).then(function(){this.getExtension("contextBasedSaveAs",b).openAddAdaptationDialog(this.getRtaInformation().flexSettings.layer,true)}.bind(this)).catch(V)}function V(e){if(e!=="cancel"){D.showMessageBox("error","MSG_LREP_TRANSFER_ERROR",{error:e});t.error(`sap.ui.rta: ${e.stack||e.message||e}`)}}function P(){D.checkDraftOverwrite(this.getModel("versions")).then(function(){this.fireEvent("deleteAdaptation")}.bind(this)).catch(V)}function L(){this.getExtension("contextBasedManage",g).openManageAdaptationDialog()}function G(t){this.fireEvent("switchAdaptation",{adaptationId:t})}function H(t,e){if(t>0){if(e===""){return this.getTextResources().getText("TXT_DEFAULT_APP")}return this.getTextResources().getText("BTN_ADAPTING_FOR",[e])}return this.getTextResources().getText("BTN_ADAPTING_FOR_ALL_USERS")}function W(){return f.onGetOverview(true,this.getRtaInformation().flexSettings.layer)}function k(){return f.onGetOverview(false,this.getRtaInformation().flexSettings.layer)}function z(){f.onGetOverview(true,this.getRtaInformation().flexSettings.layer)}function U(){w.openWhatsNewOverviewDialog()}function $(){(new v).start(T.getTourContent())}R.prototype.getControl=function(t){var e=r.getElementById(`${this.getId()}_fragment--sapUiRta_${t}`);if(!e&&this._oActionsMenuFragment){e=r.getElementById(this._oActionsMenuFragment.getId().replace("sapUiRta_actions","sapUiRta_")+t)}return e};R.prototype.hide=function(...t){this._aIntersectionObservers.forEach(function(t){t.disconnect()});return I.prototype.hide.apply(this,t)};R.prototype.showFeedbackForm=async function(){const e="https://sapinsights.eu.qualtrics.com/jfe/form/";const i="SV_4MANxRymEIl9K06";const o=e+i;const n=new URLSearchParams;const s={rootControl:this.getRtaInformation().rootControl};const r=await c.getFeedbackInformation(s);n.set("version",r.version);n.set("feature",r.connector==="KeyUserConnector"?"BTP":"ABAP");n.set("appId",r.appId);n.set("appVersion",r.appVersion);var h=new u({url:`${o}?${n.toString()}`});return a.load({name:"sap.ui.rta.toolbar.FeedbackDialog",controller:this}).then(function(t){this._oFeedbackDialog=t;this._oFeedbackDialog.addStyleClass(D.getRtaStyleClassName());this._oFeedbackDialog.setModel(h,"feedbackModel");this._oFeedbackDialog.setModel(this.getModel("i18n"),"i18n");this._oFeedbackDialog.open()}.bind(this)).catch(function(e){t.error("Error loading fragment sap.ui.rta.toolbar.FeedbackDialog: ",e)})};R.prototype.closeFeedbackForm=function(){if(this._oFeedbackDialog){this._oFeedbackDialog.close();this._oFeedbackDialog.destroy()}};return R});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/rta/toolbar/AdaptationRenderer", ["sap/ui/rta/toolbar/BaseRenderer"],function(a){"use strict";var e=a.extend("sap.ui.rta.toolbar.AdaptationRenderer");e.apiVersion=1;e.render=function(e,r){e.class("sapUiRtaToolbarAdaptation");a.render(e,r)};return e});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/rta/toolbar/Base", ["sap/m/HBox","sap/ui/core/Element","sap/ui/core/StaticArea","sap/ui/core/Lib","sap/ui/dt/util/ZIndexManager","sap/ui/model/resource/ResourceModel","sap/ui/rta/util/Animation","./BaseRenderer"],function(t,e,i,o,n,s,r,a){"use strict";var l=t.extend("sap.ui.rta.toolbar.Base",{metadata:{library:"sap.ui.rta",properties:{color:{type:"string",defaultValue:"default"},zIndex:{type:"int"},rtaInformation:{type:"object",defaultValue:{flexSettings:{}}},textResources:"object"}},constructor:function(...e){t.apply(this,e);this._oExtensions={};this.setAlignItems("Center");this.setVisible(false);this.placeToContainer()},type:null,animation:false,renderer:a});l.prototype.init=function(...e){this._oResourceModel=new s({bundle:o.getResourceBundleFor("sap.ui.rta")});t.prototype.init.apply(this,e);this.setModel(this._oResourceModel,"i18n");this._fnOnScrollBound=this._onScroll.bind(this);window.addEventListener("scroll",this._fnOnScrollBound,true);this._pFragmentLoaded=this.buildContent()};l.prototype.exit=function(...e){Object.values(this._oExtensions).forEach(function(t){t.destroy()});this._oExtensions={};window.removeEventListener("scroll",this._fnOnScrollBound,true);t.prototype.exit.apply(this,e)};l.prototype.getExtension=function(t,e){if(!Object.keys(this._oExtensions).includes(t)){this._oExtensions[t]=new e({toolbar:this})}return this._oExtensions[t]};l.prototype.setTextResources=function(t){this.setProperty("textResources",t);this._oResourceModel=new s({bundle:o.getResourceBundleFor("sap.ui.rta")})};l.prototype.onFragmentLoaded=function(){return Promise.resolve()};l.prototype.eventHandler=function(t,e){this[`fire${t}`](e.getParameters())};l.prototype.buildControls=function(){return Promise.resolve([])};l.prototype.placeToContainer=function(){this.placeAt(i.getDomRef())};l.prototype.buildContent=function(){return this.buildControls().then(function(t){t.forEach(this.addItem,this)}.bind(this))};l.prototype.onFragmentLoaded=function(){return this._pFragmentLoaded};l.prototype.show=function(t){return new Promise(function(t){var e={onAfterRendering(){this.removeEventDelegate(e);t()}};this.addEventDelegate(e,this);this.bringToFront();this.setVisible(true)}.bind(this)).then(function(){if(t&&typeof t==="function"){t()}return this.animation?r.waitTransition(this.getDomRef(),this.addStyleClass.bind(this,"is_visible")):Promise.resolve()}.bind(this)).then(function(){this.focus()}.bind(this))};l.prototype.hide=function(t){var e=Promise.resolve();if(this.animation){if(t){this.removeStyleClass("is_visible")}else{e=r.waitTransition(this.getDomRef(),this.removeStyleClass.bind(this,"is_visible"))}}return e.then(function(){this.setVisible(false)}.bind(this))};l.prototype.getControl=function(t){return e.getElementById(`sapUiRta_${t}`)};l.prototype.bringToFront=function(){this.setZIndex(n.getNextZIndex())};l.prototype._onScroll=function(){var t=this.getDomRef();if(!t){return}var e="sapUiRtaToolbar_scrolling";t.classList.toggle(e,window.scrollY>0)};return l});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/rta/toolbar/BaseRenderer", ["sap/ui/core/Renderer","sap/m/HBoxRenderer"],function(e,r){"use strict";var a=e.extend.call(r,"sap.ui.rta.toolbar.BaseRenderer");a.apiVersion=1;a.render=function(e,a){e.class("sapUiRtaToolbar");e.class(`color_${a.getColor()}`);a.type&&e.class(`type_${a.type}`);var s=a.getZIndex();s&&e.style("z-index",s);r.render(e,a)};return a});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/rta/toolbar/Fiori", ["sap/m/Image","./Adaptation","../Utils","sap/base/Log","sap/ui/rta/toolbar/AdaptationRenderer"],function(t,i,e,o,n){"use strict";const s="sapUiRtaFioriHeaderInvisible";const r=i.extend("sap.ui.rta.toolbar.Fiori",{metadata:{library:"sap.ui.rta",properties:{ushellApi:{type:"any",defaultValue:null}}},renderer:n,type:"fiori"});r.prototype.init=function(...t){this._oRenderer=e.getFiori2Renderer();this._oFioriHeader=this._oRenderer.getRootControl().getShellHeader();i.prototype.init.apply(this,t)};r.prototype.show=function(...t){this._oFioriHeader.addStyleClass(s);return i.prototype.show.apply(this,t)};r.prototype.buildControls=function(...e){return i.prototype.buildControls.apply(this,e).then(function(i){const e=this.getUshellApi().getLogo();if(e){const i=this._oFioriHeader.getDomRef().querySelector("#shell-header-icon");let o;let n;if(i){o=i.getBoundingClientRect().width;n=i.getBoundingClientRect().height;this._checkLogoSize(i,o,n)}this.getControl("iconSpacer").setWidth("8px");this._iLogoWidth=o+8;this.getControl("iconBox").addItem(new t(`${this.getId()}_fragment--sapUiRta_icon`,{src:e,width:typeof o==="number"?`${o}px`:o,height:typeof n==="number"?`${n}px`:n}))}return i}.bind(this))};r.prototype.hide=function(...t){return i.prototype.hide.apply(this,t).then(function(){this._oFioriHeader.removeStyleClass(s)}.bind(this))};r.prototype._checkLogoSize=function(t,i,e){const n=t.naturalWidth;const s=t.naturalHeight;if(Math.round(i)!==n||Math.round(e)!==s){o.error(["sap.ui.rta: please check Fiori Launchpad logo, expected size is",`${i}x${e},`,`but actual is ${n}x${s}`].join(" "))}};r.prototype._restoreHiddenElements=function(){if(this._iLogoVisibilityLimit&&window.innerWidth>this._iLogoVisibilityLimit){this._setLogoVisibility(true);delete this._iLogoVisibilityLimit}i.prototype._restoreHiddenElements.apply(this)};r.prototype._hideElementsOnIntersection=function(...t){const[e,o]=t;let n;if(o[0].intersectionRatio===0){this.adjustToolbarSectionWidths();this._observeIntersections();return}if(o[0].intersectionRatio<1){if(!this._iLogoVisibilityLimit&&e===i.LEFT_SECTION){const e=o[0].boundingClientRect.width-o[0].intersectionRect.width;n=e>this._iLogoWidth;this._iLogoVisibilityLimit=this._calculateWindowWidth(o);this._setLogoVisibility(false);if(n){i.prototype._hideElementsOnIntersection.apply(this,t)}return}}i.prototype._hideElementsOnIntersection.apply(this,t)};r.prototype._setLogoVisibility=function(t){const i=this.getControl("iconBox");const e=this.getControl("iconSpacer");i.setVisible(t);e.setVisible(t)};r.prototype.destroy=function(...t){this._oFioriHeader.removeStyleClass(s);i.prototype.destroy.apply(this,t)};return r});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/rta/toolbar/FioriLike", ["./Adaptation","sap/ui/rta/toolbar/AdaptationRenderer"],function(a,r){"use strict";var t=a.extend("sap.ui.rta.toolbar.FioriLike",{metadata:{library:"sap.ui.rta"},renderer:r,type:"fiori"});return t});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/rta/toolbar/OverflowToolbarButton", ["sap/m/OverflowToolbarButton","sap/m/ButtonRenderer","sap/m/Button"],function(t,e,o){"use strict";var r=t.extend("sap.ui.rta.toolbar.OverflowToolbarButton",{metadata:{library:"sap.ui.rta",interfaces:["sap.m.IOverflowToolbarContent"],properties:{visibleIcon:{type:"string",defaultValue:""}}},renderer:e});r.prototype._onBeforeEnterOverflow=function(...e){t.prototype._onBeforeEnterOverflow.apply(this,e);this.setVisibleIcon(this.getIcon());this.setIcon("")};r.prototype._onAfterExitOverflow=function(...e){t.prototype._onAfterExitOverflow.apply(this,e);this.setIcon(this.getVisibleIcon())};r.prototype._getText=function(){if(this.getIcon()===""&&this.getVisibleIcon()===""||this._bInOverflow){return o.prototype._getText.call(this)}return""};r.prototype.getOverflowToolbarConfig=function(){return{canOverflow:true,onBeforeEnterOverflow:this._onBeforeEnterOverflow.bind(this),onAfterExitOverflow:this._onAfterExitOverflow.bind(this)}};return r});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/rta/toolbar/Standalone", ["./Adaptation","./AdaptationRenderer"],function(a,t){"use strict";var e=a.extend("sap.ui.rta.toolbar.Standalone",{metadata:{library:"sap.ui.rta"},renderer:t,type:"standalone"});return e});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/rta/toolbar/contextBased/ManageAdaptations", ["sap/base/i18n/Localization","sap/base/util/restricted/_isEqual","sap/base/util/restricted/_union","sap/base/Log","sap/ui/base/ManagedObject","sap/ui/core/Fragment","sap/ui/fl/write/api/ContextBasedAdaptationsAPI","sap/m/ColumnListItem","sap/ui/rta/Utils","sap/ui/model/Filter","sap/ui/model/FilterOperator","sap/ui/model/json/JSONModel","sap/ui/core/date/UI5Date","sap/ui/performance/Measurement"],function(t,e,a,o,n,i,s,r,l,d,c,p,u,g){"use strict";var h={Initial:0,Default:1024,Before(t){return t+1024},Between(t,e){return(t+e)/2},After(t){return t+.5}};var f=n.extend("sap.ui.rta.toolbar.contextBased.ManageAdaptations",{metadata:{properties:{toolbar:{type:"any"}}},constructor:function(...t){n.prototype.constructor.apply(this,t);this.oTextResources=this.getToolbar().getTextResources()}});f.prototype.openManageAdaptationDialog=function(){g.start("onCBAOpenManageAdaptationDialog","Measurement of opening the manage context-based adaptation dialog");if(!this._oManageAdaptationDialogPromise){this._oManageAdaptationDialogPromise=i.load({name:"sap.ui.rta.toolbar.contextBased.ManageAdaptationsDialog",id:`${this.getToolbar().getId()}_fragment--sapUiRta_manageAdaptationDialog`,controller:{formatContextColumnCell:A.bind(this),formatContextColumnTooltip:m.bind(this),formatCreatedChangedOnColumnCell:C.bind(this),onLiveSearch:_.bind(this),moveUp:v.bind(this),moveDown:P.bind(this),onDropSelectedAdaptation:S.bind(this),onSaveReorderedAdaptations:V.bind(this),isAdaptationsSelected:k.bind(this),getIndexOfSelectedAdaptation:U.bind(this),onCancel:$.bind(this)}}).then(function(t){this._oManageAdaptationDialog=t;t.addStyleClass(l.getRtaStyleClassName());this.getToolbar().addDependent(this._oManageAdaptationDialog)}.bind(this))}else{b.call(this);N.call(this,true);D.call(this,false)}return this._oManageAdaptationDialogPromise.then(function(){this._oRtaInformation=this.getToolbar().getRtaInformation();return s.load({control:this._oRtaInformation.rootControl,layer:this._oRtaInformation.flexSettings.layer})}.bind(this)).then(function(t){this.oAdaptationsModel=s.getAdaptationsModel({control:this._oRtaInformation.rootControl,layer:this._oRtaInformation.flexSettings.layer});this.oAdaptationsModel.updateAdaptations(t.adaptations);this.oReferenceAdaptationsData=JSON.parse(JSON.stringify(this.oAdaptationsModel.getProperty("/adaptations")));this._oOriginAdaptationsData=JSON.parse(JSON.stringify(this.oAdaptationsModel.getProperty("/allAdaptations")));this._oControlConfigurationModel=new p({isTableItemSelected:false});this._oManageAdaptationDialog.setModel(this.oAdaptationsModel,"contextBased");this._oManageAdaptationDialog.setModel(this._oControlConfigurationModel,"controlConfiguration");R.call(this).attachSelectionChange(M.bind(this));g.end("onCBAOpenManageAdaptationDialog");g.getActive()&&o.info(`onCBAOpenManageAdaptationDialog: ${g.getMeasurement("onCBAOpenManageAdaptationDialog").time} ms`);return this._oManageAdaptationDialog.open()}.bind(this)).catch(function(t){o.error(t.stack);var e="MSG_LREP_TRANSFER_ERROR";var a={titleKey:"BTN_MANAGE_APP_CTX"};a.details=t.userMessage;l.showMessageBox("error",e,a)})};function A(t){return`${t.length} ${t.length>1?this.oTextResources.getText("TXT_TABLE_CONTEXT_CELL_ROLES"):this.oTextResources.getText("TXT_TABLE_CONTEXT_CELL_ROLE")}`}function m(t){return t.join("\n")}function C(e,a){var o=u.getInstance(a);var n={year:"numeric",month:"short",day:"numeric",hour:"numeric",minute:"numeric"};var i=t.getLanguage();return`${e}\n${o.toLocaleTimeString(i,n)}`}function M(t){if(t.getParameter("selected")===true){this._oControlConfigurationModel.setProperty("/isTableItemSelected",true);b.call(this)}}function b(){var t=O.call(this,"moveUpButton");var e=O.call(this,"moveDownButton");if(w.call(this)){if(k.call(this)){t.setEnabled(U.call(this)>0);e.setEnabled(U.call(this)<this.oAdaptationsModel.getProperty("/count")-1)}else{t.setEnabled(false);e.setEnabled(false)}}else{t.setEnabled(false);e.setEnabled(false)}}function _(t){var e;var a=t.getSource().getValue();var o=R.call(this);var n=E.call(this);var i=I.call(this);if(a&&a.length>0){b.call(this);N.call(this,false);var s=new d("title",c.Contains,a);var r=new d({path:"contexts/role",test(t){return t.some(function(t){return t.includes(a.toUpperCase())})}});var l=new d("createdBy",c.Contains,a);var p=new d("changedBy",c.Contains,a);e=new d([s,r,l,p]);if(i.toUpperCase().includes(a.toUpperCase())){n.setVisible(true)}else{n.setVisible(false)}}else{N.call(this,true);if(this._oControlConfigurationModel.getProperty("/isTableItemSelected")){b.call(this)}n.setVisible(true)}var u=o.getBinding("items");u.filter(e,"Application")}function v(t){x.call(this,"Up");t.getSource().focus()}function P(t){x.call(this,"Down");t.getSource().focus()}function y(t,e){return t.rank-e.rank}function T(t){var e=t.getProperty("/adaptations")||[];e.sort(y);t.setProperty("/adaptations",e);t.refresh(true)}function x(t){var e=R.call(this);var a=e.getSelectedItem(0);var o=a.getBindingContext("contextBased");var n=e.indexOfItem(a)+(t==="Up"?-1:1);var i=e.getItems()[n];var s=i?i.getBindingContext("contextBased"):undefined;if(!s){return}var r=s.getProperty("rank");var l=o.getProperty("rank");this.oAdaptationsModel.setProperty("rank",r,o);this.oAdaptationsModel.setProperty("rank",l,s);T(this.oAdaptationsModel);e.getItems()[n].setSelected(true).focus();D.call(this,B.call(this));b.call(this)}function S(t){const e=t.getParameter("draggedControl");const o=e.getBindingContext("contextBased");if(!o){return}let n=h.Default;const i=t.getParameter("droppedControl");if(i instanceof r){const e=t.getParameter("dropPosition");const a=i.getBindingContext("contextBased");const s=a.getProperty("rank");const r=i.getParent();const l=r.indexOfItem(i);if(a===o){return}const d=l+(e==="After"?1:-1);const c=r.getItems()[d];if(!c||d===-1){n=d===-1?.5:h[e](s)}else{const t=c.getBindingContext("contextBased");n=h.Between(s,t.getProperty("rank"))}}this.oAdaptationsModel.setProperty("rank",n,o);T(this.oAdaptationsModel);const s=a(this.oAdaptationsModel.getProperty("/adaptations"),this.oAdaptationsModel.getProperty("/allAdaptations"));this.oAdaptationsModel.updateAdaptations(s);D.call(this,B.call(this))}function B(){return!e(this.oAdaptationsModel.getProperty("/adaptations").map(function(t){return t.id}),this.oReferenceAdaptationsData.map(function(t){return t.id}))}function D(t){var e=O.call(this,"manageAdaptations-saveButton");e.setTooltip(t?"":this.oTextResources.getText("TOOLTIP_APP_CTX_DIALOG_SAVE"));e.setEnabled(t)}function R(){return O.call(this,"manageAdaptationsTable")}function O(t){return this.getToolbar().getControl(`manageAdaptationDialog--${t}`)}function E(){return O.call(this,"defaultContext")}function I(){return O.call(this,"defaultApplicationTitle").getProperty("text")}function L(){return O.call(this,"searchField")}function w(){return L.call(this).getValue().length===0}function N(t){R.call(this).getDragDropConfig()[0].setEnabled(t)}function k(){var t=R.call(this);return t.getSelectedContextPaths().length>0}function U(){var t=R.call(this);if(t.getSelectedContextPaths().length>0){var e=t.getSelectedContextPaths()[0].split("/");var a=Number(e[e.length-1]);return a}return-1}function V(){l.checkDraftOverwrite(this.getToolbar().getModel("versions")).then(function(){var t=this.getToolbar().getRtaInformation();var e=this.oAdaptationsModel.getProperty("/adaptations").map(function(t){return t.id});return s.reorder({control:t.rootControl,layer:t.flexSettings.layer,parameters:{priorities:e}})}.bind(this)).then(function(){const t=a(this.oAdaptationsModel.getProperty("/adaptations"),this.oAdaptationsModel.getProperty("/allAdaptations"));this.oAdaptationsModel.updateAdaptations(t);X.call(this)}.bind(this)).catch(function(t){if(t!=="cancel"){l.showMessageBox("error","MSG_LREP_TRANSFER_ERROR",{titleKey:"BTN_MANAGE_APP_CTX",error:t});o.error(`sap.ui.rta: ${t.stack||t.message||t}`)}})}function $(){this.oAdaptationsModel.updateAdaptations(this._oOriginAdaptationsData);X.call(this)}function X(){this._oControlConfigurationModel.setProperty("/isTableItemSelected",false);L.call(this).setValue("");var t=R.call(this);t.getBinding("items").filter([]);t.removeSelections();E.call(this).setVisible(true);this._oManageAdaptationDialog.close()}return f});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/rta/toolbar/contextBased/SaveAsAdaptation", ["sap/ui/base/ManagedObject","sap/base/Log","sap/base/strings/formatMessage","sap/ui/core/BusyIndicator","sap/ui/core/Element","sap/ui/core/Fragment","sap/ui/core/library","sap/ui/fl/Layer","sap/ui/fl/write/api/ContextBasedAdaptationsAPI","sap/ui/fl/write/api/ContextSharingAPI","sap/ui/rta/Utils","sap/ui/model/json/JSONModel","sap/ui/performance/Measurement"],function(t,e,o,i,a,n,s,r,d,l,p,h,g){"use strict";var{ValueState:u}=s;var c=t.extend("sap.ui.rta.toolbar.contextBased.SaveAsAdaptation",{metadata:{properties:{toolbar:{type:"any"}}},constructor:function(...e){t.prototype.constructor.apply(this,e);this.oTextResources=this.getToolbar().getTextResources()}});c.prototype.openAddAdaptationDialog=function(t,e){this._bIsEditMode=e;if(!this._oAddAdaptationDialogPromise){this._oAddAdaptationDialogPromise=n.load({name:"sap.ui.rta.toolbar.contextBased.SaveAsAdaptationDialog",id:`${this.getToolbar().getId()}_fragment--sapUiRta_addAdaptationDialog`,controller:{onAdaptationTitleChange:f.bind(this),onSaveAsAdaptation:T.bind(this),onCancelAdaptationDialog:x.bind(this),onPriorityChange:E.bind(this)}}).then(function(t){this._oAddAdaptationDialog=t;this._oAddAdaptationDialog.attachBeforeClose(R.bind(this));t.addStyleClass(p.getRtaStyleClassName());this.getToolbar().addDependent(this._oAddAdaptationDialog);this.oDialogModel=new h;this._oAddAdaptationDialog.setModel(this.oDialogModel,"dialogModel")}.bind(this))}else{var o=this.getToolbar().getControl("addAdaptationDialog--saveAdaptation-title-input");o.setValue("");o.setValueState(u.None)}return this._oAddAdaptationDialogPromise.then(function(){return v.call(this,t)}.bind(this)).then(function(){var t=this.getToolbar().getRtaInformation();this.oAdaptationsModel=d.getAdaptationsModel({control:t.rootControl,layer:t.flexSettings.layer});if(e){C.call(this)}else{this.oDialogModel.setProperty("/title",this.oTextResources.getText("SAC_DIALOG_HEADER"));this.oDialogModel.refresh(true)}return A.call(this)}.bind(this))};function A(){_.call(this,this.oAdaptationsModel.getProperty("/adaptations"));return this._oAddAdaptationDialog.open()}function C(){this.oDialogModel.setProperty("/title",this.oTextResources.getText("EAC_DIALOG_HEADER"));this.oDialogModel.refresh(true);var t=this.oAdaptationsModel.getProperty("/displayedAdaptation");this._mEditProperties={adaptationId:t.id,title:t.title,priority:t.rank-1,roles:t.contexts.role};this.getToolbar().getControl("addAdaptationDialog--saveAdaptation-title-input").setValue(this._mEditProperties.title);this._oContextComponentInstance.setSelectedContexts({role:this._mEditProperties.roles})}function _(t){var e=[{key:"0",title:this.oTextResources.getText("TXT_SELECT_FIRST_PRIO")}];var i=this.oTextResources.getText("TXT_SELECT_PRIO");var a=this._mEditProperties?this._mEditProperties.priority:undefined;t.forEach(function(t,n){if(a!==undefined&&a===n){return}var s=e.length;e.push({key:s.toString(),title:o(i,[t.title,s+1])})});this.oDialogModel.setProperty("/selected",a?e[a].key:e[0].key);this.oDialogModel.setProperty("/priority",e)}function f(){y.call(this);b.call(this)}function m(){b.call(this)}function x(){this._oAddAdaptationDialog.close()}function T(){var t={};t.title=S.call(this);t.contexts=this._oContextComponentInstance.getSelectedContexts();t.priority=D.call(this);var o=this.getToolbar().getRtaInformation();if(this._bIsEditMode){g.start("onCBAUpdateAdaptation","Measurement of updating a context-based adaptation");t.adaptationId=this._mEditProperties.adaptationId;d.update({control:o.rootControl,layer:o.flexSettings.layer,contextBasedAdaptation:t,adaptationId:this._mEditProperties.adaptationId}).then(function(t,o){if(o.status===200){this.oAdaptationsModel.updateAdaptationContent(t);g.end("onCBAUpdateAdaptation");g.getActive()&&e.info(`onCBAUpdateAdaptation: ${g.getMeasurement("onCBAUpdateAdaptation").time} ms`)}}.bind(this,t)).catch(function(t){e.error(t.stack);var o="MSG_LREP_TRANSFER_ERROR";var i={titleKey:"EAC_DIALOG_HEADER"};i.details=t.userMessage;p.showMessageBox("error",o,i)})}else{g.start("onCBASaveAsAdaptation","Measurement of saving a context-based adaptation");i.show();d.create({control:o.rootControl,layer:o.flexSettings.layer,contextBasedAdaptation:t}).then(function(){i.hide();this.getToolbar().fireEvent("switchAdaptation",{adaptationId:t.id,trigger:"SaveAs"});g.end("onCBASaveAsAdaptation");g.getActive()&&e.info(`onCBASaveAsAdaptation: ${g.getMeasurement("onCBASaveAsAdaptation").time} ms`)}.bind(this)).catch(function(t){i.hide();e.error(t.stack);var o="MSG_LREP_TRANSFER_ERROR";var a={titleKey:"SAC_DIALOG_HEADER"};a.details=t.userMessage;p.showMessageBox("error",o,a)})}this._oAddAdaptationDialog.close()}function E(t){b.call(this);this.sPriority=t.getParameters().selectedItem.getProperty("key")}function y(){if(this._oAddAdaptationDialog&&this._oAddAdaptationDialog.isOpen()){var t=this.getToolbar().getControl("addAdaptationDialog--saveAdaptation-title-input");var e=t.getValue().trim().length;var o=100;if(e===0){t.setValueState(u.Error);t.setValueStateText(this.oTextResources.getText("TXT_CTX_ERROR_EMPTY_TITLE"))}else if(e>o){t.setValueState(u.Error);t.setValueStateText(this.oTextResources.getText("TXT_CTX_ERROR_MAX_LEN",[o]))}else if(e>0){var i=this.oAdaptationsModel.getProperty("/adaptations").findIndex(function(e){if(e.title.trim().toLowerCase()===t.getValue().trim().toLowerCase()){if(this._mEditProperties&&this._mEditProperties.title.toLowerCase()===t.getValue().toLowerCase()){return false}return true}return false}.bind(this));if(i>-1){t.setValueState(u.Error);t.setValueStateText(this.oTextResources.getText("TXT_CTX_ERROR_DUPLICATE_TITLE"))}else{t.setValueState(u.None);t.setValueStateText(null)}}}}function v(t){var e={layer:t||r.CUSTOMER};return l.createComponent(e).then(function(t){this._oContextComponent=t;this._oContextComponentInstance=t.getComponentInstance();this._oContextComponentInstance.resetSelectedContexts();this._oAddAdaptationDialog.addContent(this._oContextComponent);var e=a.getElementById("contextSharing---ContextVisibility--selectedContextsList");e.attachUpdateFinished(m.bind(this));e.getHeaderToolbar().getContent()[0].setRequired(true);this._oContextComponentInstance.setEmptyListTextWithAdvice();this._oContextComponentInstance.showMessageStrip(false)}.bind(this))}function S(){var t=this.getToolbar().getControl("addAdaptationDialog--saveAdaptation-title-input");return t?t.getValue().trim():""}function D(){if(this._bIsEditMode&&!this.sPriority){this.sPriority=this.oDialogModel.getProperty("/selected")}return Number(this.sPriority)||0}function b(){var t=this.getToolbar().getControl("addAdaptationDialog--saveAdaptation-title-input");var e;var o=this._oContextComponentInstance.getSelectedContexts().role.length>0&&t.getValueState()===u.None&&t.getValue().length>0;if(this._bIsEditMode&&this._mEditProperties&&this.oDialogModel){e=o&&(t.getValue()!==this._mEditProperties.title||this.oDialogModel.getProperty("/selected")!==this._mEditProperties.priority.toString()||this._oContextComponentInstance.getSelectedContexts().role.length!==this._mEditProperties.roles.length||!this._oContextComponentInstance.getSelectedContexts().role.every(function(t){return this._mEditProperties.roles.indexOf(t)>-1}.bind(this)))}else{e=o}this.getToolbar().getControl("addAdaptationDialog--saveAdaptation-saveButton").setEnabled(e)}function R(){this._mEditProperties=undefined;this._oAddAdaptationDialog.removeContent(this._oContextComponent);this._oContextComponentInstance.destroy();this._oContextComponent.destroy()}return c});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/rta/toolbar/translation/Translation", ["sap/base/Log","sap/ui/base/ManagedObject","sap/ui/core/Element","sap/ui/core/Fragment","sap/ui/core/Lib","sap/ui/rta/Utils","sap/ui/model/json/JSONModel","sap/m/MessageBox","sap/m/MessageToast","sap/ui/fl/write/api/TranslationAPI","sap/ui/fl/Layer","sap/ui/core/util/File"],function(a,o,t,e,n,i,l,r,s,d,g,u){"use strict";function p(o){var t=o.userMessage||o.stack||o.message||o.status||o;var e=n.getResourceBundleFor("sap.ui.rta");a.error(t);var l=`${e.getText("MSG_LREP_TRANSFER_ERROR")}\n${e.getText("MSG_ERROR_REASON",[t])}`;r.error(l,{styleClass:i.getRtaStyleClassName()})}var c=o.extend("sap.ui.rta.toolbar.translation.Translation",{metadata:{properties:{toolbar:{type:"any"}}},constructor:function(...a){o.prototype.constructor.apply(this,a);this._oTranslationModel=new l(D())}});function h(a){var o=a.getSource().getModel("translation");var t=o.getProperty("/sourceLanguage");var e=o.getProperty("/targetLanguage");var n=`${t}_${e}_TranslationXLIFF`;var i={layer:g.CUSTOMER,sourceLanguage:t,targetLanguage:e,selector:this.getToolbar().getRtaInformation().rootControl};var l=new Promise(function(a){if(o.getProperty("/translationRelevantDirtyChangesExist")){l=this.getToolbar().fireSave({callback:a})}else{a()}}.bind(this));l.then(d.getTexts.bind(undefined,i)).then(function(a){u.save(a,n,"xml","application/xml");this._oDownloadDialog.close()}.bind(this)).catch(function(a){p(a)})}c.prototype._createDownloadTranslationDialog=function(){return e.load({name:"sap.ui.rta.toolbar.translation.DownloadTranslationDialog",id:`${this.getToolbar().getId()}_download_translation_fragment`,controller:{onDownloadFile:h.bind(this),onCancelDownloadDialog:function(){this._oDownloadDialog.close()}.bind(this)}}).then(function(a){this._oDownloadDialog=a;this._oDownloadDialog.setModel(this._oTranslationModel,"translation");this.getToolbar().addDependent(this._oDownloadDialog);return a}.bind(this))};c.prototype._createUploadTranslationDialog=function(){var a=`${this.getToolbar().getId()}_upload_translation_fragment`;return e.load({name:"sap.ui.rta.toolbar.translation.UploadTranslationDialog",id:a,controller:{onCancelUploadDialog:function(){this._oUploadDialog.close()}.bind(this),formatUploadEnabled(){var o=t.getElementById(`${a}--fileUploader`);return o.checkFileReadable()},saveFiles:function(a){this._oTranslationModel.setProperty("/file",a.getParameter("files")[0])}.bind(this),handleUploadPress:f.bind(this,a)}}).then(function(a){this._oUploadDialog=a;this._oUploadDialog.setModel(this._oTranslationModel,"translation");this.getToolbar().addDependent(this._oUploadDialog);return this._oUploadDialog}.bind(this))};function f(a){var o=t.getElementById(`${a}--fileUploader`);o.checkFileReadable().then(function(){if(this._oTranslationModel.getProperty("/file")){var a={layer:g.CUSTOMER,payload:new FormData};a.payload.append("file",this._oTranslationModel.getProperty("/file"),o.getValue());return d.uploadTranslationTexts(a).then(function(){var a=n.getResourceBundleFor("sap.ui.rta");var o=a.getText("MSG_UPLOAD_TRANSLATION_SUCCESS");s.show(o,{styleClass:i.getRtaStyleClassName()});this._oUploadDialog.close()}.bind(this)).catch(function(a){p(a)}).finally(o.clear.bind(o))}}.bind(this))}function D(){return{sourceLanguage:"",sourceLanguages:[],downloadChangedTexts:false,file:undefined}}c.prototype.openDownloadTranslationDialog=function(a){var o=d.hasTranslationRelevantDirtyChanges(a);this._oTranslationModel.setProperty("/translationRelevantDirtyChangesExist",o);return d.getSourceLanguages(a).then(function(a){if(a){this._oTranslationModel.setProperty("/sourceLanguages",a);this._oTranslationModel.setProperty("/sourceLanguage",a[0]||"")}}.bind(this)).then(function(){if(this._oDownloadDialogPromise){this._oTranslationModel.setProperty("/targetLanguage","")}else{this._oDownloadDialogPromise=this._createDownloadTranslationDialog()}return this._oDownloadDialogPromise}.bind(this)).then(function(a){return a.open()}).catch(function(a){p(a)})};c.prototype.openUploadTranslationDialog=function(){this._oUploadDialogPromise||=this._createUploadTranslationDialog();return this._oUploadDialogPromise.then(function(a){this.getToolbar().addDependent(a);return a.open()}.bind(this))};return c});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/rta/toolbar/versioning/Versioning", ["sap/base/security/encodeXML","sap/m/GroupHeaderListItem","sap/ui/base/ManagedObject","sap/ui/core/format/DateFormat","sap/ui/core/Fragment","sap/ui/core/message/MessageType","sap/ui/fl/initial/api/Version","sap/ui/model/Sorter","sap/ui/rta/Utils"],function(e,t,i,o,r,s,n,a,l){"use strict";var u="sapUiRtaDraftVersionAccent";var c="sapUiRtaActiveVersionAccent";var g="sapUiRtaVersionColor";var T=i.extend("sap.ui.rta.toolbar.versioning.Versioning",{metadata:{properties:{toolbar:{type:"any"}}},constructor:function(...e){i.prototype.constructor.apply(this,e);this.oTextResources=this.getToolbar().getTextResources()}});function h(e){var t=e.getSource().getBindingContext("versions");var i=n.Number.Original;if(t){i=t.getProperty("version")}this.getToolbar().fireEvent("switchVersion",{version:i})}function f(e){return e.some(function(e){return e.type===n.Type.Active})}function p(e){return f(e)?s.None:s.Success}function v(e){return f(e)?this.oTextResources.getText("LBL_INACTIVE"):this.oTextResources.getText("LBL_ACTIVE")}function d(e){switch(e){case n.Type.Draft:return s.Warning;case n.Type.Active:return s.Success;default:return s.None}}function V(e){switch(e){case n.Type.Draft:return this.oTextResources.getText("TIT_DRAFT");case n.Type.Active:return this.oTextResources.getText("LBL_ACTIVE");default:return this.oTextResources.getText("LBL_INACTIVE")}}function y(t,i){if(i===n.Type.Draft){return this.oTextResources.getText("TIT_DRAFT")}return t?e(t):this.oTextResources.getText("TIT_VERSION_1")}function b(e,t){var i=t||e;if(!i){return""}if(i.indexOf("Z")===-1){i=`${i}Z`}return o.getInstance({format:"yMMMdjm"}).format(new Date(i))}function m(e){return new t({title:e.key?this.oTextResources.getText("TIT_VERSION_HISTORY_PUBLISHED"):this.oTextResources.getText("TIT_VERSION_HISTORY_UNPUBLISHED"),visible:this.getToolbar().getModel("versions").getProperty("/publishVersionVisible")}).addStyleClass("sapUiRtaVersionHistoryGrouping").addStyleClass("sapUiRtaVersionHistory")}function D(e,t){switch(t){case n.Type.Draft:e.addStyleClass(u);e.removeStyleClass(c);e.removeStyleClass(g);break;case n.Type.Active:e.addStyleClass(c);e.removeStyleClass(u);e.removeStyleClass(g);break;default:e.addStyleClass(g);e.removeStyleClass(c);e.removeStyleClass(u)}}T.prototype.formatVersionButtonText=function(e,t){var i="";var o="Active";e||=[];if(t===undefined||t===n.Number.Original){i=this.oTextResources.getText("TIT_ORIGINAL_APP");o=n.Type.Inactive;if(e.length===0||e.length===1&&e[0].type===n.Type.Draft){o=n.Type.Active}}else{var r=e.find(function(e){return e.version===t});if(r){o=r.type;if(t===n.Number.Draft){i=this.oTextResources.getText("TIT_DRAFT")}else{i=r.title||this.oTextResources.getText("TIT_VERSION_1")}}}D(this.getToolbar().getControl("versionButton"),o);return i};T.prototype.formatPublishVersionVisibility=function(e,t,i,o){return e&&t&&i!==n.Number.Draft&&o==="adaptation"};T.prototype.formatDiscardDraftVisible=function(e,t,i){return e===n.Number.Draft&&t&&i==="adaptation"};T.prototype.showVersionHistory=function(e){var t=e.getSource();this._oVersionHistoryDialogPromise||=r.load({name:"sap.ui.rta.toolbar.versioning.VersionHistory",id:`${this.getToolbar().getId()}_fragment--sapUiRta_versionHistoryDialog`,controller:{formatVersionTitle:y.bind(this),formatVersionTimeStamp:b,formatHighlight:d,formatHighlightText:V.bind(this),formatOriginalAppHighlight:p,formatOriginalAppHighlightText:v.bind(this),versionSelected:h.bind(this),getGroupHeaderFactory:m.bind(this)}}).then(function(e){this.getToolbar().addDependent(e);return e}.bind(this));return this._oVersionHistoryDialogPromise.then(function(e){if(!e.isOpen()){e.openBy(t);if(this.getToolbar().getModel("versions").getProperty("/publishVersionVisible")){var i=this.getToolbar().getControl("versionHistoryDialog--versionList");var o=new a({path:"isPublished",group:true});i.getBinding("items").sort(o)}}else{e.close()}}.bind(this))};T.prototype.openActivateVersionDialog=function(e){if(!this._oActivateVersionDialogPromise){this._oActivateVersionDialogPromise=r.load({name:"sap.ui.rta.toolbar.versioning.VersionTitleDialog",id:`${this.getToolbar().getId()}_fragment--sapUiRta_activateVersionDialog`,controller:{onConfirmVersioningDialog:function(){var e=this.getToolbar().getControl("activateVersionDialog--versionTitleInput").getValue();if(e.length>0){this.getToolbar().fireEvent("activate",{versionTitle:e});this._oActivateVersionDialog.close()}}.bind(this),onCancelVersioningDialog:function(){this._oActivateVersionDialog.close()}.bind(this),onVersionTitleLiveChange:function(e){var t=e.getParameter("value");this.getToolbar().getControl("activateVersionDialog--confirmVersionTitleButton").setEnabled(!!t)}.bind(this)}}).then(function(e){this._oActivateVersionDialog=e;e.addStyleClass(l.getRtaStyleClassName());this.getToolbar().addDependent(this._oActivateVersionDialog)}.bind(this))}else{this.getToolbar().getControl("activateVersionDialog--versionTitleInput").setValue("");this.getToolbar().getControl("activateVersionDialog--confirmVersionTitleButton").setEnabled(false)}return this._oActivateVersionDialogPromise.then(function(){var t=this.oTextResources.getText("TIT_VERSION_TITLE_DIALOG");if(e!==n.Number.Draft){t=this.oTextResources.getText("TIT_REACTIVATE_VERSION_TITLE_DIALOG")}this._oActivateVersionDialog.setTitle(t);return this._oActivateVersionDialog.open()}.bind(this))};return T});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/rta/util/Animation", [],function(){"use strict";var n={};n.waitTransition=function(n,e){if(typeof e!=="function"){throw new Error("fnCallback should be a function")}return new Promise(function(i){n.addEventListener("transitionend",i,{once:true});var t;var r=function(n){t||=n;if(n!==t){e()}else{window.requestAnimationFrame(r)}};window.requestAnimationFrame(r)})};return n});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/rta/util/BindingsExtractor", ["sap/ui/dt/ElementUtil","sap/ui/dt/OverlayRegistry","sap/base/util/isPlainObject","sap/base/util/restricted/_uniqWith","sap/base/util/deepEqual"],function(t,e,n,a,i){"use strict";var r={};r.collectBindingPaths=function(e,a,i,g){var o={bindingPaths:[],bindingContextPaths:[]};var d=e.sParentAggregationName;var l=e.getParent();var s=r.getBindings({element:e,model:a,relevantContainerElement:i,parent:l,depth:g});if(l){var u=l.getMetadata().getAggregation();if(u){var f=t.getAggregation(l,d).indexOf(e);var p=u.name;var v=l.getBindingInfo(p);var c=v&&v.template;if(c){var m=c.getMetadata().getAggregation();if(m){var h=m.name;var P=t.getAggregation(c,h)[f];s=s.concat(r.getBindings({model:a,element:P,template:true,relevantContainerElement:i,parent:l,depth:g}))}}}}for(var B=0,b=s.length;B<b;B++){if(s[B].getPath){var C=s[B].getPath();if(C&&o.bindingPaths.indexOf(C)===-1){o.bindingPaths.push(C)}}if(s[B].getContext&&s[B].getContext()&&s[B].getContext().getPath){var M=s[B].getContext().getPath();if(M&&o.bindingContextPaths.indexOf(M)===-1){o.bindingContextPaths.push(M)}}if(n(s[B])){var x=s[B].parts[0]&&s[B].parts[0].path;if(x&&o.bindingPaths.indexOf(x)===-1){o.bindingPaths.push(x)}}}return o};function g(t,n){if(n&&t!==n){var a=e.getOverlay(t);var i=a&&(a.getRelevantContainer()||a.getElement());return i?i.getId()===n.getId():true}return true}r.getBindings=function(t){var e=t.element;var n=t.model;var d=t.parent;var s=t.aggregationName;var u=t.relevantContainerElement;var f=[];if(g(e,u)){f=t.template?l(e,d,n):r.getBindingsFromProperties(e,n)}var p=s?[s]:Object.keys(e.getMetadata().getAllAggregations());if(!Number.isInteger(t.depth)||t.depth>0){p.forEach(function(a){f=f.concat(o(e,n,t.template,a,u,t.depth&&t.depth-1))})}return a(f,i)};function o(e,n,a,i,o,d){var s=[];var u=[];var f;var p=a;var v=e.getModel();var c=e.getBindingInfo(i);f=c&&c.template;if(f&&v&&v!==n){return[]}if(f){p=true;u=[f]}else{u=t.getAggregation(e,i)}u.forEach(function(t){if(t.getMetadata){if(g(e,o)){s=s.concat(p?l(t,e,n):r.getBindingsFromProperties(t,n))}s=s.concat(r.getBindings({element:t,model:n,template:p,relevantContainerElement:o,parent:e,depth:d}))}});return s}r.filterAndFlattenBindings=function(t,e){var n=[];var a=t.getMetadata().getName();if(a==="sap.ui.model.CompositeBinding"){t.getBindings().forEach(function(t){n=n.concat(r.filterAndFlattenBindings(t,e))})}else if((a==="sap.ui.model.odata.ODataPropertyBinding"||a==="sap.ui.model.odata.v2.ODataPropertyBinding"||a==="sap.ui.model.odata.v4.ODataPropertyBinding"||a==="sap.ui.model.json.JSONPropertyBinding"||a==="sap.ui.model.json.XMLPropertyBinding"||a==="sap.ui.model.resource.ResourcePropertyBinding")&&t.getModel()===e&&t.isRelative()&&typeof t.getPath==="function"&&t.getPath()){n.push(t)}return n};function d(t){var e=[];var n=t.parts;n.forEach(function(t){e.push({parts:[t]})});return e}r.getBindingsFromProperties=function(t,e){var n=Object.keys(t.getMetadata().getAllProperties());return n.filter(t.getBinding.bind(t)).reduce(function(n,a){return n.concat(r.filterAndFlattenBindings(t.getBinding(a),e))},[])};function l(t,e,n){var a=Object.keys(t.getMetadata().getAllProperties());var i;return a.filter(function(a){var r=t.mBindingInfos[a];var g=r&&r.parts[0]&&r.parts[0].model;i=n===e.getModel(g);if(!g){var o=e.getDefaultModel?e.getDefaultModel():null;var d=t.getDefaultModel?t.getDefaultModel():null;i=o===d}else{i=n===e.getModel(g)}return r&&i}).reduce(function(e,n){return e.concat(d(t.mBindingInfos[n]))},[])}r.getBindingContextPath=function(t){if(t.getBindingContext()&&t.getBindingContext().getPath){return t.getBindingContext().getPath()}return undefined};return r});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/rta/util/PluginManager", ["sap/base/util/isEmptyObject","sap/base/util/values","sap/ui/base/ManagedObject","sap/ui/dt/plugin/ContextMenu","sap/ui/dt/plugin/ToolHooks","sap/ui/fl/write/api/FeaturesAPI","sap/ui/fl/Layer","sap/ui/rta/command/CommandFactory","sap/ui/rta/plugin/additionalElements/AdditionalElementsPlugin","sap/ui/rta/plugin/annotations/AnnotationPlugin","sap/ui/rta/plugin/iframe/AddIFrame","sap/ui/rta/plugin/Combine","sap/ui/rta/plugin/CompVariant","sap/ui/rta/plugin/ControlVariant","sap/ui/rta/plugin/CreateContainer","sap/ui/rta/plugin/CutPaste","sap/ui/rta/plugin/DragDrop","sap/ui/rta/plugin/LocalReset","sap/ui/rta/plugin/Remove","sap/ui/rta/plugin/rename/Rename","sap/ui/rta/plugin/Resize","sap/ui/rta/plugin/RTAElementMover","sap/ui/rta/plugin/Selection","sap/ui/rta/plugin/Settings","sap/ui/rta/plugin/Split","sap/ui/rta/plugin/Stretch"],function(t,a,e,i,n,o,s,u,l,r,m,g,d,c,p,h,y,f,P,_,C,F,D,b,E,w){"use strict";var v=e.extend("sap.ui.rta.util.PluginManager",{metadata:{properties:{plugins:{type:"any",defaultValue:{}}}}});v.prototype.init=function(){this.iEditableOverlaysCount=0};v.prototype.getEditableOverlaysCount=function(){return this.iEditableOverlaysCount};v.prototype.getDefaultPlugins=function(t){if(!this._mDefaultPlugins){this._oCommandFactory=new u({flexSettings:t});this._mDefaultPlugins={};this._mDefaultPlugins.selection=new D({commandFactory:this._oCommandFactory,multiSelectionRequiredPlugins:[g.getMetadata().getName(),P.getMetadata().getName()],elementEditableChange:this.onElementEditableChange.bind(this)});this._oRTAElementMover=new F({commandFactory:this._oCommandFactory});this._mDefaultPlugins.dragDrop=new y({elementMover:this._oRTAElementMover,commandFactory:this._oCommandFactory,dragStarted:this.handleStopCutPaste.bind(this)});this._mDefaultPlugins.rename=new _({commandFactory:this._oCommandFactory,editable:this.handleStopCutPaste.bind(this)});this._mDefaultPlugins.additionalElements=new l({commandFactory:this._oCommandFactory});this._mDefaultPlugins.createContainer=new p({commandFactory:this._oCommandFactory});this._mDefaultPlugins.remove=new P({commandFactory:this._oCommandFactory});this._mDefaultPlugins.cutPaste=new h({elementMover:this._oRTAElementMover,commandFactory:this._oCommandFactory});this._mDefaultPlugins.settings=new b({commandFactory:this._oCommandFactory});this._mDefaultPlugins.combine=new g({commandFactory:this._oCommandFactory});this._mDefaultPlugins.split=new E({commandFactory:this._oCommandFactory});this._mDefaultPlugins.resize=new C({commandFactory:this._oCommandFactory});this._mDefaultPlugins.contextMenu=new i;this._mDefaultPlugins.stretch=new w;if(o.isVariantAdaptationEnabled()){this._mDefaultPlugins.compVariant=new d({commandFactory:this._oCommandFactory})}this._mDefaultPlugins.controlVariant=new c({commandFactory:this._oCommandFactory});this._mDefaultPlugins.addIFrame=new m({commandFactory:this._oCommandFactory});this._mDefaultPlugins.toolHooks=new n;if(t.layer===s.CUSTOMER&&o.isLocalResetEnabled()){this._mDefaultPlugins.localReset=new f({commandFactory:this._oCommandFactory})}if(o.areAnnotationChangesEnabled()){this._mDefaultPlugins.annotation=new r({commandFactory:this._oCommandFactory})}}return{...this._mDefaultPlugins}};v.prototype.preparePlugins=function(a,e,i){if(t(this.getPlugins())){this.setPlugins(this.getDefaultPlugins(a))}else{this._destroyDefaultPlugins(this.getPlugins())}Object.keys(this.getPlugins()).forEach(t=>{if(this.getPlugin(t).attachElementModified){this.getPlugin(t).attachElementModified(e)}});this.provideCommandStack(i)};v.prototype.getPluginList=function(){return a(this.getPlugins())};v.prototype.getPlugin=function(t){return this.getPlugins()[t]};v.prototype.provideCommandStack=function(t){Object.keys(this.getPlugins()).forEach(a=>{if(this.getPlugin(a)&&this.getPlugin(a).setCommandStack){this.getPlugin(a).setCommandStack(t)}})};v.prototype.onElementEditableChange=function(t){var a=t.getParameter("editable");if(a){this.iEditableOverlaysCount+=1}else{this.iEditableOverlaysCount-=1}};v.prototype.handleStopCutPaste=function(){var t=this.getPlugin("cutPaste");if(t){t.stopCutAndPaste()}};v.prototype._destroyDefaultPlugins=function(t){for(var a in this._mDefaultPlugins){var e=this._mDefaultPlugins[a];if(e&&!e.bIsDestroyed){if(!t||t[a]!==e){e.destroy()}}}};return v});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/rta/util/PopupManager", ["sap/ui/base/ManagedObject","sap/m/InstanceManager","sap/ui/dt/Overlay","sap/ui/dt/OverlayRegistry","sap/ui/fl/Utils","sap/ui/core/Component","sap/ui/core/ComponentContainer","sap/ui/core/Element","sap/ui/dt/util/ZIndexManager","sap/m/Dialog","sap/m/Popover","sap/base/util/restricted/_curry"],function(t,e,o,n,i,a,p,r,s,u,l,d){"use strict";var c={add:"_activateFocusHandle",remove:"_deactivateFocusHandle"};var f=t.extend("sap.ui.rta.util.PopupManager",{metadata:{properties:{rta:"any"},associations:{autoCloseAreas:{type:"sap.ui.core.Control",multiple:true,singularName:"autoCloseArea"}},events:{open:{parameters:{oControl:{type:"sap.ui.core.Control"}}},close:{parameters:{oControl:{type:"sap.ui.core.Control"}}}},library:"sap.ui.rta"}});f.prototype.init=function(){this._oModalState=new Map;this._aPopupFilters=[this._isSupportedPopup.bind(this),this._isPopupAdaptable.bind(this)];this._aPopupFilters.forEach(function(t){s.addPopupFilter(t)})};f.prototype._overrideInstanceFunctions=function(){this._applyPopupAttributes({method:this._createPopupOverlays,setModal:true,bringToTop:true});this._overrideAddPopupInstance();this._overrideRemovePopupInstance()};f.prototype.getCategorizedOpenPopups=function(){var t;var o;t=e.getOpenDialogs();var n=this._getValidatedPopups(t);o=e.getOpenPopovers();var i=this._getValidatedPopups(o);var a={aDialogs:n.relevant,aPopovers:i.relevant,aAllSupportedPopups:n.allSupported.concat(i.allSupported)};return a};f.prototype._getValidatedPopups=function(t){var e=[];t=t.filter(function(t){if(this._isPopupAdaptable(t)){e.push(t);return true}else if(t instanceof u){e.push(t)}return undefined}.bind(this));return{relevant:t,allSupported:e}};f.prototype._isComponentInsidePopup=function(t){return Array.isArray(t.getContent())?t.getContent().some(function(t){if(t instanceof p){return this.oRtaRootAppComponent===this._getAppComponentForControl(a.getComponentById(t.getComponent()))}return undefined}.bind(this)):false};f.prototype._isSupportedPopup=function(t){return t instanceof u||t instanceof l};f.prototype.setRta=function(t){if(t&&t._oDesignTime){this.setProperty("rta",t);var e=t.getRootControlInstance();this.oRtaRootAppComponent=this._getAppComponentForControl(e);var o=this._onModeChange.bind(this);t.attachModeChanged(o);this._overrideInstanceFunctions()}};f.prototype._adjustRootOverlayVisibility=function(t,e){this.getRta()._oDesignTime.getRootElements().forEach(function(o){if(o.getId()!==e.getId()){n.getOverlay(o).setVisible(t)}})};f.prototype._onModeChange=function(t){var e=t.getParameters().mode;var o=function(t,e){if(t==="navigation"){e.oPopup[this._getFocusEventName("add")]()}else{e.oPopup[this._getFocusEventName("remove")]();if(this.getRta().getShowToolbars()){this.getRta().getToolbar().bringToFront()}}};if(e==="navigation"){this._applyPatchesToOpenPopups(d(o)(e))}else{this._removePatchesToOpenPopups(d(o)(e))}};f.prototype._applyPatchesToOpenPopups=function(t){this._applyPopupAttributes({method:t,focus:true,setModal:false})};f.prototype._removePatchesToOpenPopups=function(t){this._applyPopupAttributes({method:t,setModal:true})};f.prototype._getFocusEventName=function(t){return c[t]};f.prototype._overrideAddPopupInstance=function(){this._fnOriginalAddDialogInstance=e.addDialogInstance;e.addDialogInstance=this._overrideAddFunctions(this._fnOriginalAddDialogInstance);this._fnOriginalAddPopoverInstance=e.addPopoverInstance;e.addPopoverInstance=this._overrideAddFunctions(this._fnOriginalAddPopoverInstance)};f.prototype._overrideAddFunctions=function(t){return function(...o){const[n]=o;var i=t.apply(e,o);if(this._isSupportedPopup(n)){if(this._isPopupAdaptable(n)&&this.getRta()._oDesignTime){n.attachEventOnce("afterOpen",this._createPopupOverlays,this);n.attachEventOnce("afterOpen",this.fireOpen,this);this._setModal(true,n)}else if(!(n instanceof l)){this._setModal(true,n)}}return i}.bind(this)};f.prototype._setModal=function(t,e){var o=this._oModalState.get(e.oPopup);if(typeof o!=="boolean"&&t&&this.getRta().getMode()!=="navigation"){this._oModalState.set(e.oPopup,e.oPopup.getModal());if(this._isPopupAdaptable(e)){this._adjustRootOverlayVisibility(false,e)}e.oPopup.setModal(true)}else if(typeof o==="boolean"&&t===false){e.oPopup.setModal(o);if(this._isPopupAdaptable(e)){this._adjustRootOverlayVisibility(true,e)}this._oModalState.delete(e.oPopup)}};f.prototype._applyPopupAttributes=function(t){var e=this.getCategorizedOpenPopups();["aDialogs","aPopovers"].forEach(function(o){if(e[o].length>0){if(t.focus){if(e[o][0].oPopup.oContent){e[o][0].oPopup.oContent.focus()}}e[o].forEach(function(e){t.method.call(this,e)}.bind(this))}}.bind(this));e.aAllSupportedPopups.forEach(this._setModal.bind(this,t.setModal))};f.prototype._applyPopupPatch=function(t){var e=o.getOverlayContainer();var{oPopup:n}=t;var i=[n.oContent.getDomRef(),e].concat(this.getAutoCloseAreas());if(this.getRta().getShowToolbars()){var a=this.getRta().getToolbar();var p=!!a.getVisible();if(!p){this.getRta().attachEventOnce("start",function(){i.push(a.getDomRef())})}else{i.push(a.getDomRef())}}n.setExtraContent(i);this.fnOriginalPopupOnAfterRendering||=n.onAfterRendering;n.onAfterRendering=function(...t){var e=this.fnOriginalPopupOnAfterRendering.apply(n,t);n[this._getFocusEventName("remove")]();return e}.bind(this);if(this.getRta().getMode()==="adaptation"){n[this._getFocusEventName("remove")]()}};f.prototype._overrideRemovePopupInstance=function(){this._fnOriginalRemoveDialogInstance=e.removeDialogInstance;e.removeDialogInstance=this._overrideRemoveFunctions(this._fnOriginalRemoveDialogInstance);this._fnOriginalRemovePopoverInstance=e.removePopoverInstance;e.removePopoverInstance=this._overrideRemoveFunctions(this._fnOriginalRemovePopoverInstance)};f.prototype._overrideRemoveFunctions=function(t){return function(...o){const[n]=o;var i=t.apply(e,o);if(this._isSupportedPopup(n)){if(this._isPopupAdaptable(n)&&this.getRta()._oDesignTime){this.getRta()._oDesignTime.removeRootElement(n)}this._oModalState.delete(n.oPopup);this.fireClose(n)}return i}.bind(this)};f.prototype._getAppComponentForControl=function(t){var e;var o;if(t instanceof a){e=t}else{e=this._getComponentForControl(t)}if(e){o=i.getAppComponentForControl(e)}return o};f.prototype._getComponentForControl=function(t){var e;var o;var n;if(t){e=a.getOwnerComponentFor(t);if(!e&&typeof t.getParent==="function"&&t.getParent()instanceof r){n=t.getParent()}else if(e){n=e}if(n){o=this._getComponentForControl(n)}}return o||e};f.prototype._createPopupOverlays=function(t){if(!t){return}var e=t instanceof r?t:t.getSource();if(this.getRta()._oDesignTime.getRootElements().indexOf(e.getId())===-1&&!this._isComponentInsidePopup(e)){this.getRta()._oDesignTime.addRootElement(e)}e.detachAfterOpen(this._createPopupOverlays,this);this._applyPopupPatch(e)};f.prototype._restoreInstanceFunctions=function(){if(this._fnOriginalAddDialogInstance){e.addDialogInstance=this._fnOriginalAddDialogInstance}if(this._fnOriginalRemoveDialogInstance){e.removeDialogInstance=this._fnOriginalRemoveDialogInstance}if(this._fnOriginalAddPopoverInstance){e.addPopoverInstance=this._fnOriginalAddPopoverInstance}if(this._fnOriginalRemovePopoverInstance){e.removePopoverInstance=this._fnOriginalRemovePopoverInstance}this._applyPatchesToOpenPopups(this._removePopupPatch)};f.prototype._removePopupPatch=function(t){var{oPopup:e}=t;e[this._getFocusEventName("add")]();if(this.fnOriginalPopupOnAfterRendering){e.onAfterRendering=this.fnOriginalPopupOnAfterRendering}};function h(t){if(!t||t instanceof a){return true}if(!t.isPopupAdaptationAllowed||t.isPopupAdaptationAllowed()){return h(t.getParent())}return false}f.prototype._isPopupAdaptable=function(t){if(t.isPopupAdaptationAllowed&&!t.isPopupAdaptationAllowed()){return false}var e=this._getAppComponentForControl(t);if(e&&this.oRtaRootAppComponent===e||this._isComponentInsidePopup(t)){return h(t.getParent())}return false};f.prototype.exit=function(){this._restoreInstanceFunctions();delete this._oModalState;this._aPopupFilters.forEach(function(t){s.removePopupFilter(t)})};return f});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/rta/util/ReloadManager", ["sap/base/util/merge","sap/ui/fl/apply/api/FlexRuntimeInfoAPI","sap/ui/fl/write/api/ReloadInfoAPI","sap/ui/fl/write/api/VersionsAPI","sap/ui/fl/Layer","sap/ui/fl/Utils","sap/ui/rta/Utils"],function(e,t,a,r,n,i,o){"use strict";var s={};var l={};var A={NOT_NEEDED:"NO_RELOAD",VIA_HASH:"CROSS_APP_NAVIGATION",RELOAD_PAGE:"HARD_RELOAD"};function _(e){var t;var a=e.layer===n.CUSTOMER;if(e.hasHigherLayerChanges&&e.isDraftAvailable){t=a?"MSG_VIEWS_OR_PERSONALIZATION_AND_DRAFT_EXISTS":"MSG_HIGHER_LAYER_CHANGES_AND_DRAFT_EXISTS"}else if(e.hasHigherLayerChanges&&e.allContexts){t="MSG_RESTRICTED_CONTEXT_EXIST_AND_PERSONALIZATION"}else if(e.hasHigherLayerChanges){t=a?"MSG_PERSONALIZATION_OR_PUBLIC_VIEWS_EXISTS":"MSG_HIGHER_LAYER_CHANGES_EXIST"}else if(e.isDraftAvailable){t="MSG_DRAFT_EXISTS"}else if(e.allContexts){t="MSG_RESTRICTED_CONTEXT_EXIST"}return t}function u(e){var t=e.layer===n.CUSTOMER;if(e.hasHigherLayerChanges){if(!t){return"MSG_RELOAD_WITH_ALL_CHANGES"}if(e.isDraftAvailable){return"MSG_RELOAD_WITH_VIEWS_PERSONALIZATION_AND_WITHOUT_DRAFT"}if(e.allContexts){return"MSG_RELOAD_WITH_PERSONALIZATION_AND_RESTRICTED_CONTEXT"}if(e.switchEndUserAdaptation){return"MSG_RELOAD_WITH_PERSONALIZATION_AND_CONTEXT_BASED_ADAPTATION"}return"MSG_RELOAD_WITH_PERSONALIZATION_AND_VIEWS"}if(e.changesNeedReload){return"MSG_RELOAD_NEEDED"}if(e.initialDraftGotActivated||e.activeVersionNotSelected){return"MSG_RELOAD_ACTIVATED_DRAFT"}if(e.isDraftAvailable){return"MSG_RELOAD_WITHOUT_DRAFT"}if(e.allContexts){return"MSG_RELOAD_WITHOUT_ALL_CONTEXT"}if(e.switchEndUserAdaptation){return"MSG_RELOAD_OTHER_CONTEXT_BASED_ADAPTATION"}return undefined}function E(e){var t=u(e);if(t){return o.showMessageBox("information",t,{titleKey:"HEADER_RELOAD_NEEDED"})}return Promise.resolve()}function f(e,t,a){return Promise.resolve().then(function(){if(l.Navigation&&t){if(e.isDraftAvailable){return r.loadDraftForApplication({control:e.selector,layer:e.layer,allContexts:e.allContexts,adaptationId:e.adaptationId})}return r.loadVersionForApplication({control:e.selector,layer:e.layer,allContexts:e.allContexts,adaptationId:e.adaptationId})}return undefined}).then(function(){var t=_(e);return a?undefined:o.showMessageBox("information",t)}).then(function(){s.enableAutomaticStart(e.layer,e.selector);e.onStart=true;return s.triggerReload(e)}).then(function(){return true})}s.setUShellServices=function(e){l=e};s.enableAutomaticStart=function(e,a){var r=t.getFlexReference({element:a});var n=r||true;window.sessionStorage.setItem(`sap.ui.rta.restart.${e}`,n)};s.disableAutomaticStart=function(e){window.sessionStorage.removeItem(`sap.ui.rta.restart.${e}`)};s.needsAutomaticStart=function(e){return!!window.sessionStorage.getItem(`sap.ui.rta.restart.${e}`)};s.setDontShowWhatsNewAfterReload=()=>{window.sessionStorage.setItem("sap.ui.rta.whatsNew",true)};s.getDontShowWhatsNewAfterReload=()=>window.sessionStorage.getItem("sap.ui.rta.whatsNew");s.removeDontShowWhatsNewAfterReload=()=>{window.sessionStorage.removeItem("sap.ui.rta.whatsNew")};s.triggerReload=function(e){if(e.onStart){a.handleReloadInfoOnStart(e)}else{a.handleReloadInfo(e)}if(i.getUshellContainer()){l.AppLifeCycle.reloadCurrentApp()}if(!i.getUshellContainer()||e.triggerHardReload){s.reloadPage()}};s.reloadPage=function(){window.location.reload()};s.setUriParameters=function(e){document.location.search=e};s.handleReloadOnStart=function(t){e(t,{hasHigherLayerChanges:false,isDraftAvailable:false,ignoreMaxLayerParameter:false,includeCtrlVariants:true,URLParsingService:l.URLParsing});return a.getReloadReasonsForStart(t).then(function(e){if(e.hasHigherLayerChanges||e.isDraftAvailable||e.allContexts||e.switchAdaptation){return f(e,t.versioningEnabled,t.developerMode)}return undefined})};s.checkReloadOnExit=function(e){return e.changesNeedReloadPromise.then(function(t){e.changesNeedReload=t;e.URLParsingService=l.URLParsing;var r=a.getReloadMethod(e);return E(r).then(function(){r.triggerHardReload=r.reloadMethod===A.RELOAD_PAGE;return r})})};s.handleReloadOnExit=function(e){if(e.reloadMethod!==A.NOT_NEEDED){e.removeVersionParameter=true;s.triggerReload(e)}};return s});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/rta/util/ServiceEventBus", ["sap/ui/core/EventBus"],function(e){"use strict";var t=e.extend("sap.ui.rta.util.ServiceEventBus");t.prototype._callListener=function(e,t,n,i,r){e.call(t,r)};t.prototype.getChannel=function(e){return this._mChannels[e]};return t});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/rta/util/ServiceManager", ["sap/base/util/isPlainObject","sap/ui/base/ManagedObject","sap/ui/dt/Util","sap/ui/rta/service/index","sap/ui/rta/util/ServiceEventBus"],function(e,t,i,r,s){"use strict";const n="SERVICE_STARTING";const c="SERVICE_STARTED";const a="SERVICE_FAILED";const o=t.extend("sap.ui.rta.util.ServiceManager",{metadata:{properties:{services:{type:"any",defaultValue:{}}}},constructor:function(...e){t.apply(this,e)}});function u(e){if(r.hasOwnProperty(e)){return r[e].replace(/\./g,"/")}return undefined}async function v(){const e=[];Object.values(this.getServices()).forEach(t=>{e.push(t.initPromise.then(()=>{if(typeof t.service.destroy==="function"){t.service.destroy()}}))});await Promise.all(e);this.setServices({})}o.prototype.getServices=function(){return{...this.getProperty("services")}};o.prototype.startService=function(t,r){const o=u(t);const v=this.getServices();let h;if(!o){return Promise.reject(Error(`sap.ui.rta, ServiceManager#startService: Unknown service. Can't find any registered service by name '${t}'`))}h=v[t];if(h){switch(h.status){case c:{return Promise.resolve(h.exports)}case n:{return h.initPromise}case a:{return h.initPromise}default:{return Promise.reject(Error(`sap.ui.rta, ServiceManager#startService: Unknown service status. Service name = '${t}'`))}}}else{h={};h.status=n;h.location=o;h.initPromise=new Promise(function(n,u){sap.ui.require([o],async function(a){try{h.factory=a;this._oServiceEventBus||=new s;const o=await a(r,this._oServiceEventBus.publish.bind(this._oServiceEventBus,t));if(r.bIsDestroyed){throw Error(`sap.ui.rta, ServiceManager#startService: RuntimeAuthoring instance is destroyed while initializing the service '${t}'`)}if(!e(o)){throw Error(`sap.ui.rta, ServiceManager#startService: Invalid service format. Service should return simple javascript object after initialization. Service name = '${t}'`)}h.service=o;h.exports={};if(Array.isArray(o.events)&&o.events.length>0){Object.assign(h.exports,{attachEvent:this._oServiceEventBus.subscribe.bind(this._oServiceEventBus,t),detachEvent:this._oServiceEventBus.unsubscribe.bind(this._oServiceEventBus,t),attachEventOnce:this._oServiceEventBus.subscribeOnce.bind(this._oServiceEventBus,t)})}const u=o.exports||{};Object.assign(h.exports,Object.keys(u).reduce(function(e,t){const s=u[t];e[t]=typeof s==="function"?i.waitForSynced(r._oDesignTime,s):s;return e},{}));h.status=c;n(Object.freeze(h.exports))}catch(e){u(e)}}.bind(this),function(e){h.status=a;u(e)})}.bind(this)).catch(function(e){h.status=a;return Promise.reject(e)});v[t]=h;this.setServices(v);return h.initPromise}};o.prototype.destroy=function(){v.call(this);if(this._oServiceEventBus){this._oServiceEventBus.destroy()}};return o});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/rta/util/adaptationStarter", ["sap/base/Log","sap/ui/core/Control","sap/ui/core/Lib","sap/ui/core/UIComponent","sap/ui/fl/initial/api/InitialFlexAPI","sap/ui/fl/write/api/PersistenceWriteAPI","sap/ui/fl/Layer","sap/ui/fl/Utils","sap/ui/rta/util/showMessageBox","sap/ui/rta/RuntimeAuthoring"],function(e,t,r,n,o,a,i,s,u,l){"use strict";function f(e){if(i.CUSTOMER===e){return o.isKeyUser().then(function(e){if(!e){var t=r.getResourceBundleFor("sap.ui.rta");var n=new Error(t.getText("MSG_NO_KEY_USER_RIGHTS_ERROR_MESSAGE"));n.reason="isKeyUser";throw n}})}return Promise.resolve()}function T(e){var t=new URLSearchParams(window.location.search).get("fiori-tools-rta-mode");if(!t||t==="false"){var r=e.getManifest()||{};var n=r["sap.ui5"]&&r["sap.ui5"].flexEnabled;if(n===false){var o=Error("This app is not enabled for key user adaptation");o.reason="flexEnabled";throw o}}}function c(e){const t=e.getComponentData?.();if(t?.startupParameters&&Array.isArray(t.startupParameters["sap-app-id"])){const t=e.getManifest();const n=t["sap.app"]?.ach;const o=r.getResourceBundleFor("sap.ui.rta");const a=o.getText("MSG_PSEUDO_APP_VARIANT_ERROR_MESSAGE",[n]);const i=Error(a);i.reason="pseudoAppVariant";throw i}}function p(o,p,A,_,E){var g;return Promise.resolve().then(function(){if(!(o.rootControl instanceof t)&&!(o.rootControl instanceof n)){var e=Error("An invalid root control was passed");e.reason="rootControl";throw e}o.rootControl=s.getAppComponentForControl(o.rootControl)}).then(f.bind(undefined,o.flexSettings.layer)).then(function(){return T(o.rootControl)}).then(c.bind(undefined,o.rootControl)).then(function(){g=new l(o);if(A){g.attachEvent("start",A)}if(_){g.attachEvent("failed",_)}var e=E||function(){g.destroy()};g.attachEvent("stop",e);if(p){return p(g)}return undefined}).then(function(){return g.start()}).then(function(){if(o.flexSettings.layer==="CUSTOMER"){var e={oComponent:o.rootControl,selector:o.rootControl,invalidateCache:false,includeCtrlVariants:true,currentLayer:i.CUSTOMER};a.getChangesWarning(e).then(function(e){if(e.showWarning){var t=r.getResourceBundleFor("sap.ui.rta");var n=e.warningType==="mixedChangesWarning"?{text:"MSG_ADAPTATION_STARTER_MIXED_CHANGES_WARNING",title:"TIT_ADAPTATION_STARTER_MIXED_CHANGES_TITLE"}:{text:"MSG_ADAPTATION_STARTER_NO_CHANGES_IN_P_WARNING",title:"TIT_ADAPTATION_STARTER_NO_CHANGES_IN_P_TITLE"};u(t.getText(n.text),{title:t.getText(n.title)},"warning")}})}return g}).catch(function(t){if(t.message!=="Reload triggered"&&!(s.getUshellContainer()&&t.reason==="flexEnabled")){var n=r.getResourceBundleFor("sap.ui.rta");if(t.reason==="isKeyUser"||t.reason==="pseudoAppVariant"){u(t.message,{title:n.getText("MSG_ADAPTATION_COULD_NOT_START")},"error")}else{u(n.getText("MSG_GENERIC_ERROR_MESSAGE",[t.message]),{title:n.getText("MSG_ADAPTATION_COULD_NOT_START")},"error")}e.error("UI Adaptation could not be started",t.message)}throw t})}return p});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/rta/util/changeVisualization/ChangeCategories", ["sap/ui/fl/changeHandler/common/ChangeCategories"],function(e){"use strict";var a={};a.ALL="all";var n={};n[e.ADD]=["createContainer","addDelegateProperty","reveal","addIFrame"];n[e.MOVE]=["move"];n[e.RENAME]=["rename"];n[e.COMBINESPLIT]=["combine","split"];n[e.REMOVE]=["remove"];n[e.OTHER]=[];var o={};o[a.ALL]="sap-icon://show";o[e.ADD]="sap-icon://add";o[e.MOVE]="sap-icon://move";o[e.RENAME]="sap-icon://edit";o[e.COMBINESPLIT]="sap-icon://combine";o[e.REMOVE]="sap-icon://less";o[e.OTHER]="sap-icon://key-user-settings";a.getCategories=function(){return n};a.getIconForCategory=function(e){return o[e]};return a});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/rta/util/changeVisualization/ChangeIndicator", ["sap/ui/core/format/DateFormat","sap/ui/core/Control","sap/ui/core/Element","sap/ui/core/Fragment","sap/ui/core/Lib","sap/ui/core/StaticArea","sap/ui/events/KeyCodes","sap/ui/fl/util/resolveBinding","sap/ui/fl/Utils","sap/ui/model/json/JSONModel","sap/ui/rta/util/changeVisualization/commands/getCommandVisualization","sap/ui/rta/util/changeVisualization/ChangeCategories","sap/ui/rta/util/changeVisualization/ChangeVisualizationUtils","sap/ui/dt/OverlayRegistry"],function(e,t,o,i,n,s,a,r,l,c,p,h,g,d){"use strict";const u=t.extend("sap.ui.rta.util.changeVisualization.ChangeIndicator",{metadata:{library:"sap.ui.rta",properties:{changes:{type:"array",defaultValue:[]},posX:{type:"int"},posY:{type:"int"},overlayId:{type:"string"},selectorId:{type:"string"},connectedElementId:{type:"string"}},aggregations:{_popover:{type:"sap.m.Popover",multiple:false,visibility:"hidden"}},events:{selectChange:{parameters:{changeId:{type:"string"}}},keyPress:{parameters:{originalEvent:{type:"object"}}},detailPopoverOpened:{}}},renderer:{apiVersion:2,render(e,t){e.openStart("div",t);e.class("sapUiRtaChangeIndicator");e.class("sapUiRtaChangeIndicatorChange");const o=t.getTooltip_AsString();if(o){e.attr("title",o)}e.openEnd();if(o){e.openStart("span",`${t.getId()}-tooltip`);e.class("sapUiInvisibleText");e.openEnd();e.text(o);e.close("span")}e.close("div")}},constructor:function(...e){this._oDetailModel=new c;this._oDetailModel.setDefaultBindingMode("OneWay");this._fnHoverTrue=this._setHoverStyleClasses.bind(this,true);this._fnHoverFalse=this._setHoverStyleClasses.bind(this,false);t.prototype.constructor.apply(this,e);this._bEventAttachedToElement=false;this._oRenderPromise=new Promise(e=>{this._fnRendered=e})}});function f(e,t){e[t]("click",this._onSelect,this);e[t]("tap",this._onSelect,this);e[t]("keydown",this._onKeyDown,this);e[t]("mouseover",this._fnHoverTrue);e[t]("focusin",this._fnHoverTrue);e[t]("mouseout",this._fnHoverFalse);e[t]("focusout",this._fnHoverFalse)}function y(e,t){e[t]("click",this._onSelect,this);e[t]("tap",this._onSelect,this);e[t]("keydown",this._onKeyDown,this);e[t]("mouseover",this._fnHoverTrue);e[t]("focusin",this._fnHoverTrue);e[t]("mouseout",this._fnHoverFalse);e[t]("focusout",this._fnHoverFalse)}function v(e){const t=e.getDomRef();const i=o.getElementById(e.getOverlayId()).getDomRef().offsetHeight;const n=t.offsetHeight;if(i<n*5){e.addStyleClass("sapUiRtaChangeIndicatorVerticallyCentered")}else{e.removeStyleClass("sapUiRtaChangeIndicatorVerticallyCentered")}}function _(e,t,i){const n=o.getElementById(e.affectedElementId);const s=Object.keys(e.descriptionPayload||{}).reduce(function(t,o){const i=e.descriptionPayload[o];const s=l.isBinding(i);const a=s?r(i,n):i;t[o]=a;return t},{});const a={appComponent:l.getAppComponentForControl(n)};const c=o.getElementById(i);const h=c.getDesignTimeMetadata().getLabel(n);const d=p(e);const u=d?.getDescription(s,h,a)||{};let f=e.commandName;let y;let v;if(f==="settings"&&s.description){u.descriptionText=s.description;u.descriptionTooltip=s.descriptionTooltip}else if(e.changeCategory==="other"){f="other"}if(u.descriptionText){y=u.descriptionText;v=u.descriptionTooltip||""}else{const e=g.shortenString(h);const o=`TXT_CHANGEVISUALIZATION_CHANGE_${f.toUpperCase()}`;y=t.getText(o,[e]);v=t.getText(o,[h])}v=y.length<v.length?v:null;const _=u&&u.buttonText;const I=t.getText(`TXT_CHANGEVISUALIZATION_OVERVIEW_${e.changeCategory.toUpperCase()}`);return{description:y,tooltip:v,buttonText:_,iconTooltip:I}}function I(t,o){const i=t.change.getCreation();const n=new Date(i);const s=o.getText("TXT_CHANGEVISUALIZATION_CREATED_IN_SESSION_DATE");return{fullDate:i?e.getDateTimeInstance().format(n):s,relativeDate:i?e.getDateTimeInstance({relative:"true"}).format(n):s}}function m(e,t){const o=n.getResourceBundleFor("sap.ui.rta");const i=_(t,o,e);const s=I(t,o);return{id:t.id,change:t,description:i.description,descriptionTooltip:i.tooltip,fullDate:s.fullDate,relativeDate:s.relativeDate,detailButtonText:i.buttonText,icon:h.getIconForCategory(t.changeCategory),iconTooltip:i.iconTooltip}}u.prototype.init=function(){this._iOldTabIndex=0;y.call(this,this,"attachBrowserEvent")};u.prototype.setVisible=function(...e){const[i]=e;t.prototype.setVisible.apply(this,e);const n=o.getElementById(this.getOverlayId());if(n){if(i&&!this._bEventAttachedToElement){f.call(this,n,"attachBrowserEvent");this._bEventAttachedToElement=true}if(!i){f.call(this,n,"detachBrowserEvent");this._bEventAttachedToElement=false;if(this.getAggregation("_popover")){this.getAggregation("_popover").destroy()}this._oRenderPromise=new Promise(e=>{this._fnRendered=e})}}return this};u.prototype.focus=function(...e){if(this.getDomRef()){t.prototype.focus.apply(this,e);this._bScheduledForFocus=false;return}this._bScheduledForFocus=true};u.prototype.setOverlayId=function(e){const t=this.getDomRef();if(t){t.parentNode.removeChild(t)}this.placeAt(s.getDomRef());this.setProperty("overlayId",e);return this};u.prototype.onAfterRendering=function(){const e=o.getElementById(this.getOverlayId());if(e){e.getDomRef().appendChild(this.getDomRef());v(this)}this.getDomRef().tabIndex=this._iOldTabIndex;if(this._bScheduledForFocus){this.focus();this._setHoverStyleClasses(true)}this._fnRendered()};u.prototype.waitForRendering=function(){return this._oRenderPromise};u.prototype.exit=function(){const e=this.getDomRef();const t=o.getElementById(this.getOverlayId());if(e){e.parentNode.removeChild(e)}if(t){if(this.getAggregation("_popover")){this.getAggregation("_popover").destroy()}f.call(this,t,"detachBrowserEvent")}y.call(this,this,"detachBrowserEvent")};u.prototype.setChanges=function(e){const t=n.getResourceBundleFor("sap.ui.rta");this.setProperty("changes",e);const o=e?e.sort((e,t)=>new Date(e.change.getCreation()||new Date)-new Date(t.change.getCreation()||new Date)).reverse():[];const i=o.map(m.bind(this,this.getOverlayId()));this._oDetailModel.setData(i);if(e&&e.length===1){this.setTooltip(t.getText("TXT_CHANGEVISUALIZATION_INDICATOR_TOOLTIP_SING"))}else if(e){this.setTooltip(t.getText("TXT_CHANGEVISUALIZATION_INDICATOR_TOOLTIP_PLUR",[e.length]))}};u.prototype._onSelect=function(e){this.focus();e.stopPropagation();this._toggleDetailPopover()};u.prototype._onKeyDown=function(e){if(e.keyCode===a.ENTER){this._onSelect(e)}this.fireKeyPress({originalEvent:e})};u.prototype.onDetailPopoverOpened=function(e){e.preventDefault();this._setHoverStyleClasses(true)};u.prototype.onIndicatorBrowserInteraction=function(e,t){t.stopPropagation();t.preventDefault();this._setHoverStyleClasses(e)};u.prototype._setHoverStyleClasses=function(e,t){if(t){t.stopPropagation();t.preventDefault()}const i=o.getElementById(this.getOverlayId());if(i.getMetadata().getName()!=="sap.ui.dt.ElementOverlay"){return}const n=e?"addStyleClass":"removeStyleClass";i[n]("sapUiRtaChangeIndicatorHovered");this[n]("sapUiRtaHover");if(this.getConnectedElementId()){const e=d.getOverlay(this.getConnectedElementId());e[n]("sapUiRtaChangeIndicatorHovered")}};u.prototype._toggleDetailPopover=function(){if(!this.getAggregation("_popover")){this._iOldTabIndex=this.getDomRef().getAttribute("tabindex");i.load({name:"sap.ui.rta.util.changeVisualization.ChangeIndicatorPopover",id:`${this.sId}Info`,controller:this}).then(function(e){e._bOpenedByChangeIndicator=true;this.setAggregation("_popover",e);e.setModel(this._oDetailModel,"details");e.openBy(this);this._setHoverStyleClasses(true)}.bind(this))}else{if(this.getAggregation("_popover").isOpen()){return this.getAggregation("_popover").close()}this.getAggregation("_popover").openBy(this);this._setHoverStyleClasses(true)}return undefined};u.prototype._showDependentElements=function(e){this.getAggregation("_popover").close();const t=this.getChanges().length>1?e.getSource().getBindingContext("details").getObject().id:this.getChanges()[0].id;this.fireSelectChange({changeId:t})};return u});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/rta/util/changeVisualization/ChangeIndicatorRegistry", ["sap/base/util/values","sap/base/util/restricted/_omit","sap/base/Log","sap/ui/base/ManagedObject","sap/ui/core/util/reflection/JsControlTreeModifier","sap/ui/dt/ElementUtil","sap/ui/fl/write/api/ChangesWriteAPI","sap/ui/fl/Utils","sap/ui/fl/changeHandler/common/ChangeCategories","sap/ui/rta/util/changeVisualization/ChangeStates"],function(e,t,n,i,o,r,s,a,c,g){"use strict";const d=i.extend("sap.ui.rta.util.changeVisualization.ChangeIndicatorRegistry",{metadata:{properties:{changeCategories:{type:"object",defaultValue:[]},rootControlId:{type:"string"}}},constructor:function(...e){i.prototype.constructor.apply(this,e);this._oRegisteredChanges={};this._oChangeIndicators={}}});d.prototype.exit=function(){this.reset()};d.prototype.getAllRegisteredChanges=function(){return e(this._oRegisteredChanges||{}).map(function(e){return{...e}})};d.prototype.getRegisteredChangeIds=function(){return Object.keys(this._oRegisteredChanges||{})};d.prototype.getRegisteredChange=function(e){return this._oRegisteredChanges[e]&&{...this._oRegisteredChanges[e]}};d.prototype.getSelectorsWithRegisteredChanges=function(){const n={};let i;function o(e,o,r,s){if(n[e]===undefined){n[e]=[]}n[e].push({id:r.change.getId(),dependent:s,affectedElementId:o||i,displayElementsKey:r.visualizationInfo.displayElementIds.toString(),descriptionPayload:r.visualizationInfo.descriptionPayload||{},...t(r,["visualizationInfo"])});i=o||i}e(this._oRegisteredChanges).forEach(function(e){e.visualizationInfo.displayElementIds.forEach(function(t,n){o(t,e.visualizationInfo.affectedElementIds[n],e,false)})});return n};d.prototype.getRelevantChangesWithSelector=function(){const e=this.getSelectorsWithRegisteredChanges();let t=[];Object.keys(e).forEach(function(n){const i=e[n].filter(function(e){return!e.dependent});t=t.concat(i)});return t};d.prototype.getChangeIndicator=function(e){return this._oChangeIndicators[e]};d.prototype.getChangeIndicators=function(){return e(this._oChangeIndicators||{})};d.prototype.registerChange=function(e,t,n){const i=a.getAppComponentForControl(r.getElementInstance(this.getRootControlId()));return l(e,i).then(function(i){const o=this.getChangeCategories();let r;if(t==="settings"&&Object.keys(o).includes(i.descriptionPayload.category)){r=i.descriptionPayload.category}else{r=Object.keys(o).find(function(e){return o[e].includes(t)});r||=c.OTHER}let s;let a=[];if(n){a=n.getData().draftFilenames}if(e.getState()==="NEW"){s=g.getDraftAndDirtyStates()}else if(a&&a.includes(e.getId())){s=[g.DRAFT]}else{s=[g.ALL]}this._oRegisteredChanges[e.getId()]={change:e,commandName:t,changeCategory:r,changeStates:s,visualizationInfo:i}}.bind(this))};function l(e,t){function n(e){if(!e){return undefined}return e.map(function(e){const n=typeof e.getId==="function"?e:o.bySelector(e,t);return n&&n.getId()}).filter(Boolean)}return u(t,e).then(function(t){const i=t||{};const o=e.getSelector&&e.getSelector()&&[e.getSelector()];const r=i.affectedControls||o||[];const s=e.getOriginalSelector&&e.getOriginalSelector();const a=s?o:r;return{affectedElementIds:n(r),dependentElementIds:n(i.dependentControls)||[],displayElementIds:n(i.displayControls||n(a)),updateRequired:i.updateRequired,descriptionPayload:i.descriptionPayload||{}}})}function u(e,t){let i=t.getOriginalSelector&&t.getOriginalSelector();i||=t.getSelector&&t.getSelector();const r=o.bySelector(i,e);if(r){return s.getChangeHandler({changeType:t.getChangeType(),element:r,modifier:o,layer:t.getLayer()}).then(function(n){if(n&&typeof n.getChangeVisualizationInfo==="function"&&t.isSuccessfullyApplied&&t.isSuccessfullyApplied()){return n.getChangeVisualizationInfo(t,e)}return undefined}).catch(function(e){n.error(e);return undefined})}return Promise.resolve()}d.prototype.registerChangeIndicator=function(e,t){this._oChangeIndicators[e]=t};d.prototype.waitForIndicatorRendering=function(){return Promise.all(this.getChangeIndicators().map(e=>e.waitForRendering()))};d.prototype.reset=function(){Object.keys(this._oRegisteredChanges).forEach(function(e){this.removeRegisteredChange(e)}.bind(this));e(this._oChangeIndicators).forEach(function(e){e.destroy()});this._oChangeIndicators={}};d.prototype.removeRegisteredChange=function(e){delete this._oRegisteredChanges[e]};d.prototype.removeOutdatedRegisteredChanges=function(){this.getAllRegisteredChanges().forEach(function(e){if(e.visualizationInfo&&e.visualizationInfo.updateRequired){this.removeRegisteredChange(e.change.getId())}}.bind(this))};d.prototype.removeRegisteredChangesWithoutVizInfo=function(){this.getAllRegisteredChanges().forEach(function(e){if(e.visualizationInfo&&e.visualizationInfo.displayElementIds.length===0){this.removeRegisteredChange(e.change.getId())}}.bind(this))};return d});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/rta/util/changeVisualization/ChangeStates", [],function(){"use strict";var t={};t.ALL="all";t.DRAFT="draft";t.DIRTY="dirty";t.getDraftAndDirtyStates=function(){return[this.DRAFT,this.DIRTY]};return t});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/rta/util/changeVisualization/ChangeVisualization", ["sap/ui/core/Element","sap/ui/core/Fragment","sap/ui/core/Lib","sap/base/util/isEmptyObject","sap/base/util/restricted/_difference","sap/base/util/deepEqual","sap/ui/core/util/reflection/JsControlTreeModifier","sap/ui/core/Control","sap/ui/dt/OverlayRegistry","sap/ui/dt/ElementUtil","sap/ui/fl/write/api/PersistenceWriteAPI","sap/ui/fl/Layer","sap/ui/fl/Utils","sap/ui/model/resource/ResourceModel","sap/ui/model/json/JSONModel","sap/ui/rta/util/changeVisualization/ChangeIndicator","sap/ui/rta/util/changeVisualization/ChangeIndicatorRegistry","sap/ui/rta/util/changeVisualization/ChangeCategories","sap/ui/rta/util/changeVisualization/ChangeStates"],function(e,t,n,o,i,a,s,r,g,l,h,c,u,d,C,p,y,f,_){"use strict";function I(){const e=this.getPopover();if(e&&e.isOpen()){e.close()}}function v(e){return!e||!e.getDomRef()||!e.isVisible()}function V(e,t){let n=g.getOverlay(e);if(!n){const e=g.getOverlay(t);const o=e&&e.getRelevantContainer();if(o){n=g.getOverlay(o)}}return n}const M=r.extend("sap.ui.rta.util.changeVisualization.ChangeVisualization",{metadata:{library:"sap.ui.rta",properties:{rootControlId:{type:"string"},isActive:{type:"boolean",defaultValue:false}},aggregations:{popover:{type:"sap.m.Popover",multiple:false}}},renderer:null,constructor:function(...e){this._oChangeIndicatorRegistry=new y({changeCategories:f.getCategories()});r.prototype.constructor.apply(this,e);this._oTextBundle=n.getResourceBundleFor("sap.ui.rta");this.setModel(new d({bundle:this._oTextBundle}),"i18n");this._oChangeVisualizationModel=new C({active:this.getIsActive(),changeState:_.ALL});this._oChangeVisualizationModel.setDefaultBindingMode("TwoWay");this._sSelectedChangeCategory=f.ALL;this._bSetModeChanged=false;this._fnOnClickHandler=I.bind(this)}});M.prototype.setVersionsModel=function(e){this.oVersionsModel=e.getModel("versions")};M.prototype.setRootControlId=function(e){if(this.getRootControlId()&&this.getRootControlId()!==e){this._reset()}this.setProperty("rootControlId",e);this._oChangeIndicatorRegistry.setRootControlId(e)};M.prototype._getComponent=function(){return u.getAppComponentForControl(l.getElementInstance(this.getRootControlId()))};M.prototype.setIsActive=function(e){if(e===this.getIsActive()){return}this.setProperty("isActive",e);if(this._oChangeVisualizationModel){this._updateVisualizationModel({active:e})}};M.prototype.exit=function(){this._oChangeIndicatorRegistry.destroy();this._toggleRootOverlayClickHandler(false)};M.prototype.updateAfterSave=function(e){if(this.getProperty("rootControlId")){this._oChangeIndicatorRegistry.reset();this._updateChangeRegistry().then(function(){this._selectChangeCategory(this._sSelectedChangeCategory);this._selectChangeState(_.ALL);this._updateVisualizationModelMenuData();e.setModel(this._oChangeVisualizationModel,"visualizationModel")}.bind(this))}};M.prototype._reset=function(){this._oChangeIndicatorRegistry.reset()};M.prototype._determineChangeVisibility=function(e,t,n){function o(e){return e.filter(function(e){if(!n||n===_.ALL||e.changeStates.includes(n)){return true}return false})}const i=[];const a=[];let s=false;let r=false;const g=t.map(function(e){return e.id});e.forEach(function(e){if(e.changeStates.includes(_.DIRTY)){s=true;r=true}else if(e.changeStates.includes(_.DRAFT)){s=true}const t=V(e.visualizationInfo.displayElementIds[0],e.visualizationInfo.affectedElementIds[0]);if(!g.includes(e.change.getId())){i.push(e)}else if(v(t)){i.push(e)}else{a.push(e)}});const l=o(i);const h=o(a);return{relevantHiddenChanges:l,relevantVisualizedChanges:h,hasDirtyChanges:r,hasDraftChanges:s}};M.prototype._updateVisualizationModelMenuData=function(){const e=this._oChangeVisualizationModel.getData().changeState;const t=this._oChangeIndicatorRegistry.getAllRegisteredChanges();const n=this._oChangeIndicatorRegistry.getRelevantChangesWithSelector();const o=t.filter(function(e){if(!e.dependent){return true}return false});const i=this._determineChangeVisibility(o,n,e);const a=Object.keys(f.getCategories()).map(function(e){const t=this._getChangeCategoryLabel(e,this._getChangesForChangeCategory(e,i.relevantVisualizedChanges).length);return{key:e,count:this._getChangesForChangeCategory(e,i.relevantVisualizedChanges).length,title:t,icon:f.getIconForCategory(e)}}.bind(this));a.unshift({key:f.ALL,count:this._getChangesForChangeCategory(f.ALL,i.relevantVisualizedChanges).length,title:this._getChangeCategoryLabel(f.ALL,this._getChangesForChangeCategory(f.ALL,i.relevantVisualizedChanges).length),icon:f.getIconForCategory(f.ALL)});this._updateVisualizationModel({changeCategories:a,hasDraftChanges:i.hasDraftChanges,hasDirtyChanges:i.hasDirtyChanges,popupInfoMessage:this._oTextBundle.getText("MSG_CHANGEVISUALIZATION_HIDDEN_CHANGES_INFO",[i.relevantHiddenChanges.length]),sortedChanges:i})};M.prototype._getChangesForChangeCategory=function(e,t){return t.filter(function(t){return e===f.ALL?t.changeCategory!==undefined:e===t.changeCategory})};M.prototype._getChangeCategoryLabel=function(e,t){const n=`TXT_CHANGEVISUALIZATION_OVERVIEW_${e.toUpperCase()}`;return this._oTextBundle.getText(n,[t])};M.prototype._getChangeCategoryButtonText=function(e){const t=`BTN_CHANGEVISUALIZATION_OVERVIEW_${e.toUpperCase()}`;const n=this._oTextBundle.getText(t);const o=this._oChangeVisualizationModel.getData().changeState;if(o===_.ALL){return n}const i=this._oTextBundle.getText(`BUT_CHANGEVISUALIZATION_VERSIONING_${o.toUpperCase()}`);return`${n} (${i})`};M.prototype.openChangeCategorySelectionPopover=function(n){this._oToolbarButton||=e.getElementById(n.getParameter("id"));const o=this.getPopover();if(!o){t.load({name:"sap.ui.rta.util.changeVisualization.ChangeIndicatorCategorySelection",id:`${this._oToolbarButton.sId}--ChangeIndicatorCategorySelection`,controller:this}).then(function(e){this._oToolbarButton.addDependent(e);e.setModel(this._oChangeVisualizationModel,"visualizationModel");e.openBy(this._oToolbarButton);this.setPopover(e);e.close();e.openBy(this._oToolbarButton)}.bind(this));return}if(o.isOpen()){o.close()}else{o.openBy(this._oToolbarButton)}};M.prototype.onChangeCategorySelection=function(e){const t=e.getSource().getBindingContext("visualizationModel").getObject().key;this._selectChangeCategory(t);this.getPopover()?.close()};M.prototype.onVersioningCategoryChange=function(e){const t=e.getSource().getSelectedKey();this._selectChangeState(t)};M.prototype._selectChangeCategory=function(e){this._sSelectedChangeCategory=e;const t=this._getChangeCategoryButtonText(e);this._updateVisualizationModel({changeCategory:e,changeCategoryText:t});this._updateChangeIndicators();this._setFocusedIndicator()};M.prototype._selectChangeState=function(e){this._sSelectedChangeState=e;const t=this._oChangeVisualizationModel.getData().changeCategory;const n=this._getChangeCategoryButtonText(t);this._updateVisualizationModel({changeState:e,changeCategoryText:n});this._updateChangeIndicators();this._updateVisualizationModelMenuData()};M.prototype._getCommandForChange=function(e){const t=e.getSupportInformation().command;if(t){return t}if(!e.canBeVisualized()){return false}const n=this._getComponent();const o=s.bySelector(e.getSelector(),n);const i=e.getDependentSelectorList().slice(-1)[0];const a=s.bySelector(i,n);function r(t,n){const i=t.getElement();const a=t.getDesignTimeMetadata().getCommandName(e.getChangeType(),i,n);if(a){return a}const s=t.getParentElementOverlay();const g=t.getParentAggregationOverlay();if(t.getElement().getId()===o.getId()||!s){return undefined}return r(s,g&&g.getAggregationName())}return o&&a&&r(g.getOverlay(a))};M.prototype._collectChanges=function(){const e=this._getComponent();const t={selector:e,invalidateCache:false,includeCtrlVariants:true,currentLayer:c.CUSTOMER,includeDirtyChanges:true,onlyCurrentVariants:true};return h._getUIChanges(t)};M.prototype._updateChangeRegistry=function(){return this._collectChanges().then(function(e){this._oChangeIndicatorRegistry.removeOutdatedRegisteredChanges();this._oChangeIndicatorRegistry.removeRegisteredChangesWithoutVizInfo();if(this._oChangeVisualizationModel.getData().displayedVersion!=="0"){this._oChangeIndicatorRegistry.reset()}const t=this._oChangeIndicatorRegistry.getRegisteredChangeIds();const n=e.reduce(function(e,t){e[t.getId()]=t;return e},{});const o=Object.keys(n);i(t,o).forEach(function(e){this._oChangeIndicatorRegistry.removeRegisteredChange(e)}.bind(this));const a=[];i(o,t).forEach(function(e){const t=n[e];const o=this._getCommandForChange(t);a.push(this._oChangeIndicatorRegistry.registerChange(t,o,this.oVersionsModel))}.bind(this));return Promise.all(a)}.bind(this))};M.prototype.selectChange=function(e){const t=e.getParameter("changeId");this._selectChange(t)};M.prototype._selectChange=function(e){const t=this._oChangeIndicatorRegistry.getRegisteredChange(e).visualizationInfo.dependentElementIds;t.forEach(function(e){const t=g.getOverlay(e).getDomRef();t.scrollIntoView({block:"nearest"});t.classList.add("sapUiRtaChangeIndicatorDependent");t.addEventListener("animationend",function(){t.classList.remove("sapUiRtaChangeIndicatorDependent")},{once:true})})};M.prototype._updateVisualizationModel=function(e){this._oChangeVisualizationModel.setData({...this._oChangeVisualizationModel.getData(),...e})};M.prototype._updateChangeIndicators=function(){const e=this._oChangeIndicatorRegistry.getSelectorsWithRegisteredChanges();const t={};this._mDisplayElementsKeyMap={};const n=this._oDesignTime?.getSelectionManager?.().getConnectedElements();Object.keys(e).forEach(function(o){const i=e[o];const a=this._filterRelevantChanges(e[o]);const s=V(o,i[0].affectedElementId);if(v(s)){return undefined}const r=s.getDomRef().getClientRects()[0]||{left:0,top:0};t[o]={posX:parseInt(r.left),posY:parseInt(r.top),changes:a};const g=this._oChangeIndicatorRegistry.getChangeIndicator(o);const l=s.getId();const h=n?.[s.getAssociation("element")];if(!g){this._createChangeIndicator(s,o,h);const e=i[0].displayElementsKey;if(!this._mDisplayElementsKeyMap[e]){this._mDisplayElementsKeyMap[e]=[o]}else{this._mDisplayElementsKeyMap[e].push(o)}}else if(g.getOverlayId()!==l){g.setOverlayId(l);g.setVisible(true)}return undefined}.bind(this));if(!a(t,this._oChangeVisualizationModel.getData().content)){this._updateVisualizationModel({content:t})}};M.prototype._filterRelevantChanges=function(e){if(!Array.isArray(e)){return e}const t=this._oChangeVisualizationModel.getData();return e.filter(function(e){return!e.dependent&&e.changeCategory&&(t.changeCategory===f.ALL||t.changeCategory===e.changeCategory)&&(!t.changeState||t.changeState===_.ALL||e.changeStates.includes(t.changeState))})};M.prototype._createChangeIndicator=function(e,t,n){const o=new p({changes:"{changes}",posX:"{posX}",posY:"{posY}",visible:"{= ${/active} && (${changes} || []).length > 0}",overlayId:e.getId(),selectorId:t,selectChange:this.selectChange.bind(this),connectedElementId:n});o.setModel(this._oChangeVisualizationModel);o.bindElement(`/content/${t}`);o.setModel(this.getModel("i18n"),"i18n");this._oChangeIndicatorRegistry.registerChangeIndicator(t,o)};M.prototype._setFocusedIndicator=async function(){await this._oChangeIndicatorRegistry.waitForIndicatorRendering();const e=[];this._oChangeIndicatorRegistry.getChangeIndicators().forEach(t=>{const n=g.getOverlay(t.getOverlayId());if(!n){return}if(t.getVisible()){n.setFocusable(true);e.push(t)}else{n.setFocusable(false)}});if(e.length>0){e.sort(function(e,t){const n=e.getPosY()-t.getPosY();const o=e.getPosX()-t.getPosX();return n||o});const t=[];e.forEach(function(e,n){const o=g.getOverlay(e.getOverlayId());o.setFocusable(true);e.getDomRef().tabIndex=n+2;if(e.getPosY()>0){t.push(e)}});if(t.length>0){t[0].focus()}else{e[0].focus()}}};M.prototype._toggleRootOverlayClickHandler=function(e){const t=this.oRootOverlay&&this.oRootOverlay.getDomRef();if(t){if(e){t.addEventListener("click",this._fnOnClickHandler,{capture:true})}else{t.removeEventListener("click",this._fnOnClickHandler,{capture:true})}}};M.prototype.triggerModeChange=function(e,t){this.oMenuButton=t.getControl("toggleChangeVisualizationMenuButton");this.oRootOverlay=g.getOverlay(e);this.setVersionsModel(t);this.aFocusableOverlays||=g.getOverlays().filter(function(e){return e.getFocusable()});const n=e=>{this.aFocusableOverlays.forEach(function(t){t.setFocusable(e)})};if(this.oVersionsModel&&this.oVersionsModel.getData().versioningEnabled){this._updateVisualizationModel({versioningAvailable:this.oVersionsModel.getData().versioningEnabled,displayedVersion:this.oVersionsModel.getData().displayedVersion})}else{this._updateVisualizationModel({versioningAvailable:false,displayedVersion:"0"})}if(this.getIsActive()){this.setIsActive(false);this._toggleRootOverlayClickHandler(false);n(true);delete this.aFocusableOverlays;return}n(false);this._toggleRootOverlayClickHandler(true);if(!this.getRootControlId()){this.setRootControlId(e)}this.setIsActive(true);this._updateChangeRegistry().then(function(){this._selectChangeCategory(this._sSelectedChangeCategory);t.adjustToolbarSectionWidths();this._updateVisualizationModelMenuData();return this._oChangeIndicatorRegistry.waitForIndicatorRendering()}.bind(this)).then(function(){t.setModel(this._oChangeVisualizationModel,"visualizationModel")}.bind(this))};return M});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/rta/util/changeVisualization/ChangeVisualizationUtils", [],function(){"use strict";var r={};r.shortenString=function(r){if(!r){return null}var n=r.length;if(n>60){var t=r.substring(0,27);var i=r.substring(n-27);r=`${t}(...)${i}`}return r};return r});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/rta/util/changeVisualization/commands/CombineVisualization", ["sap/ui/core/Element","sap/ui/core/Lib","sap/ui/core/util/reflection/JsControlTreeModifier","sap/ui/dt/ElementUtil","sap/ui/rta/util/changeVisualization/ChangeVisualizationUtils"],function(e,t,i,r,n){"use strict";var o=t.getResourceBundleFor("sap.ui.rta");var a={};a.getDescription=function(t,a,T){var l=(t.originalSelectors||[]).length;if(l<2){return{descriptionText:o.getText("TXT_CHANGEVISUALIZATION_CHANGE_COMBINE",[n.shortenString(a)]),descriptionTooltip:o.getText("TXT_CHANGEVISUALIZATION_CHANGE_COMBINE",[a])}}var s=T.appComponent;var u=t.originalSelectors;var p=u.map(function(t){var n=i.getControlIdBySelector(t,s);var o=e.getElementById(n);return o?r.getLabelForElement(o):n});var I=p.map(n.shortenString);if(l===2){return{descriptionText:o.getText("TXT_CHANGEVISUALIZATION_CHANGE_COMBINE_TWO",I),descriptionTooltip:o.getText("TXT_CHANGEVISUALIZATION_CHANGE_COMBINE_TWO",p)}}return{descriptionText:o.getText("TXT_CHANGEVISUALIZATION_CHANGE_COMBINE_MANY",[p.length]),descriptionTooltip:p.map(function(e){return`"${e}"`}).join(",\n")}};return a});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/rta/util/changeVisualization/commands/CreateContainerVisualization", ["sap/ui/core/Lib","sap/ui/rta/util/changeVisualization/ChangeVisualizationUtils"],function(i,t){"use strict";var e={};e.getDescription=function(e,r){var a=i.getResourceBundleFor("sap.ui.rta");var n=e.originalLabel||r;var o=t.shortenString(n);var s="TXT_CHANGEVISUALIZATION_CHANGE_CREATECONTAINER";return{descriptionText:a.getText(s,[o]),descriptionTooltip:a.getText(s,[n])}};return e});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/rta/util/changeVisualization/commands/MoveVisualization", ["sap/ui/core/Lib","sap/ui/rta/util/changeVisualization/ChangeVisualizationUtils","sap/ui/core/util/reflection/JsControlTreeModifier"],function(t,e,r){"use strict";var i={};i.getDescription=function(i,n,o){var a=t.getResourceBundleFor("sap.ui.rta");var T=a.getText("TXT_CHANGEVISUALIZATION_CHANGE_MOVE_WITHIN",[e.shortenString(n)]);var I=a.getText("TXT_CHANGEVISUALIZATION_CHANGE_MOVE_WITHIN",[n]);var N;var A=o.appComponent;var s=i.sourceContainer&&r.getControlIdBySelector(i.sourceContainer,A);var u=i.targetContainer&&r.getControlIdBySelector(i.targetContainer,A);if(s!==u){T=a.getText("TXT_CHANGEVISUALIZATION_CHANGE_MOVE",[e.shortenString(n)]);I=s&&a.getText("TXT_CHANGEVISUALIZATION_CHANGE_MOVE",[n])||"";N=s&&a.getText("BTN_CHANGEVISUALIZATION_SHOW_DEPENDENT_CONTAINER_MOVE")}return{descriptionText:T,descriptionTooltip:I,buttonText:N}};return i});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/rta/util/changeVisualization/commands/RenameVisualization", ["sap/ui/core/Lib","sap/ui/rta/util/changeVisualization/ChangeVisualizationUtils"],function(i,e){"use strict";var t={};t.getDescription=function(t,a){var r=i.getResourceBundleFor("sap.ui.rta");var n=t.originalLabel?"TXT_CHANGEVISUALIZATION_CHANGE_RENAME_FROM_TO":"TXT_CHANGEVISUALIZATION_CHANGE_RENAME_TO";var o=r.getText(n,[e.shortenString(t.newLabel)||a,e.shortenString(t.originalLabel)]);var s=r.getText(n,[t.newLabel||a,t.originalLabel]);return{descriptionText:o,descriptionTooltip:s}};return t});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/rta/util/changeVisualization/commands/SplitVisualization", ["sap/ui/core/Lib","sap/ui/rta/util/changeVisualization/ChangeVisualizationUtils"],function(t,e){"use strict";var i={};i.getDescription=function(i,r){var T=t.getResourceBundleFor("sap.ui.rta");var n=T.getText("TXT_CHANGEVISUALIZATION_CHANGE_SPLIT",[e.shortenString(r)]);var a=T.getText("TXT_CHANGEVISUALIZATION_CHANGE_SPLIT",[r]);var u=T.getText("BTN_CHANGEVISUALIZATION_SHOW_DEPENDENT_CONTAINER_SPLIT");return{descriptionText:n,descriptionTooltip:a,buttonText:u}};return i});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/rta/util/changeVisualization/commands/getCommandVisualization", ["sap/ui/rta/util/changeVisualization/commands/RenameVisualization","sap/ui/rta/util/changeVisualization/commands/MoveVisualization","sap/ui/rta/util/changeVisualization/commands/CombineVisualization","sap/ui/rta/util/changeVisualization/commands/SplitVisualization","sap/ui/rta/util/changeVisualization/commands/CreateContainerVisualization"],function(a,i,n,t,e){"use strict";var s={rename:a,move:i,combine:n,split:t,createContainer:e};return function(a){var i=a.commandName;if(i==="settings"){i=a.changeCategory}return s[i]}});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/rta/util/guidedTour/GuidedTour", ["sap/m/MessageBox","sap/ui/base/ManagedObject","sap/ui/core/Element","sap/ui/core/Fragment","sap/ui/model/json/JSONModel","sap/ui/model/resource/ResourceModel","sap/ui/rta/Utils"],function(t,e,o,s,i,r,n){"use strict";const a=e.extend("sap.ui.rta.util.guidedTour.GuidedTour",{metadata:{properties:{steps:{type:"object"},initialStateSelectors:{type:"object"},currentStep:{type:"int",defaultValue:0},forwardDirection:{type:"boolean",defaultValue:true}},events:{tourClosed:{}}}});function u(t){return new Promise((e,s)=>{const i=o.getElementById(t);const r=i?.getDomRef();let a=false;if(n.isElementVisible(r)){e(i);return}const u=new MutationObserver(()=>{const s=o.getElementById(t);const i=s?.getDomRef();if(n.isElementVisible(i)){a=true;u.disconnect();e(s)}});u.observe(document.body,{childList:true,subtree:true,attributes:true});setTimeout(()=>{if(!a){u.disconnect();s(new Error(`Element with ID "${t}" not found`))}},700)})}function c(){if(this.getProperty("forwardDirection")===true){this.onNextPress()}else{this.onPreviousPress()}}function d(t){if(t.key==="Escape"||t.key==="Esc"){this.onClosePress()}}a.prototype.autoStart=async function(e){const o=await n.showMessageBox("information","TXT_TOUR_GENERAL_DESCRIPTION",{actions:[t.Action.YES,t.Action.NO],emphasizedAction:t.Action.YES,titleKey:"TIT_TOUR_GENERAL_TITLE",id:"autoStartGuidedTour"});if(o===t.Action.YES){this.start(e)}else{this.fireTourClosed()}};a.prototype.start=async function(t){this.setProperty("steps",t.steps);this.setProperty("initialStateSelectors",t.initialStateSelectors);const e=new r({bundleName:"sap.ui.rta.messagebundle"});this._oPopover=await s.load({id:"guidedTourMarker",name:"sap.ui.rta.util.guidedTour.TourMarker",controller:this});this.oGuidedTourModel=new i;this.updateGuidedTourModel(0);this._oPopover.setModel(e,"i18n");this._oPopover.setModel(this.oGuidedTourModel);this._oPopover.addEventDelegate({onAfterRendering:function(){const t=this._oPopover.getDomRef();if(t){t.addEventListener("keydown",d.bind(this))}}.bind(this)});this.showMarker(0)};a.prototype.showMarker=async function(t){const e=this.getProperty("steps")[t];const s=e.markerSelector;const i=e.actionSelectors||[];try{for(const t of i){const e=await u.call(this,t);e.firePress()}const t=e.waitForElement?await u.call(this,s):o.getElementById(s);if(t&&t.getVisible()){this._oPopover.openBy(t)}else{c.call(this)}}catch(t){c.call(this)}};a.prototype.updateGuidedTourModel=function(t){const e=t===this.getProperty("steps").length-1;const o=t===0;this.oGuidedTourModel.setData({...this.oGuidedTourModel.getData(),...this.getProperty("steps")[t],isLastStep:e,isFirstStep:o,progress:100/this.getProperty("steps").length*(t+1)})};a.prototype.onNextPress=function(){this.setProperty("forwardDirection",true);this._oPopover.close();const t=this.getCurrentStep();if(t<this.getProperty("steps").length-1){const e=t+1;this.updateGuidedTourModel(e);this.setCurrentStep(e);this.showMarker(e)}else{this.fireTourClosed();this.destroy()}};a.prototype.onPreviousPress=function(){this.setProperty("forwardDirection",false);this._oPopover.close();const t=this.getCurrentStep();const e=t-1;this.updateGuidedTourModel(e);this.setCurrentStep(e);this.showMarker(e)};a.prototype.returnToInitialState=async function(){try{const t=this.getProperty("initialStateSelectors");if(t.length===0){return}for(const e of t){const t=await u.call(this,e);t.firePress()}}catch(t){this.destroy()}};a.prototype.onClosePress=async function(){this._oPopover.close();this.fireTourClosed();this.destroy();await this.returnToInitialState()};a.prototype.destroy=function(...t){e.prototype.destroy.apply(this,t);if(this._oPopover){this._oPopover.destroy()}};return a});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/rta/util/guidedTour/content/GeneralTour", ["sap/ui/core/Element","sap/ui/core/Lib"],function(t,e){"use strict";const T={};const _=e.getResourceBundleFor("sap.ui.rta");function a(e){const T=t.getElementById("sapUIRta_toolbar").getModel("controls").getData();const a={newFeaturesOverview:T.newFeaturesOverview.visible,translation:T.translation.visible,generalTour:true,appVariantMenu:T.appVariantMenu.visible,restore:T.restore.visible};const i=e.steps.findIndex(t=>t.title===_.getText("TIT_TOUR_GENERAL_STEP_BURGER_MENU_TITLE"));e.steps[i].listContent=e.steps[i].listContent.filter(t=>a[t.id]);return e}const i={initialStateSelectors:["sapUIRta_toolbar_fragment--sapUiRta_adaptationSwitcherButton-button"],steps:[{title:_.getText("TIT_TOUR_GENERAL_STEP_UI_ADAPTATION_BUTTON_TITLE"),description:_.getText("TXT_TOUR_GENERAL_STEP_UI_ADAPTATION_BUTTON_DESCRIPTION"),listContent:[],markerSelector:"sapUIRta_toolbar_fragment--sapUiRta_adaptationSwitcherButton-button",actionSelectors:["sapUIRta_toolbar_fragment--sapUiRta_adaptationSwitcherButton-button"]},{title:_.getText("TIT_TOUR_GENERAL_STEP_NAVIGATION_BUTTON_TITLE"),description:_.getText("TXT_TOUR_GENERAL_STEP_NAVIGATION_BUTTON_DESCRIPTION"),listContent:[],markerSelector:"sapUIRta_toolbar_fragment--sapUiRta_navigationSwitcherButton-button",actionSelectors:["sapUIRta_toolbar_fragment--sapUiRta_navigationSwitcherButton-button"]},{title:_.getText("TIT_TOUR_GENERAL_STEP_VISUALIZATION_BUTTON_TITLE"),description:_.getText("TXT_TOUR_GENERAL_STEP_VISUALIZATION_BUTTON_DESCRIPTION"),listContent:[],markerSelector:"sapUIRta_toolbar_fragment--sapUiRta_visualizationSwitcherButton-button",actionSelectors:["sapUIRta_toolbar_fragment--sapUiRta_visualizationSwitcherButton-button"]},{title:_.getText("TIT_TOUR_GENERAL_STEP_CHANGE_LIST_DROPDOWN_TITLE"),description:_.getText("TXT_TOUR_GENERAL_STEP_CHANGE_LIST_DROPDOWN_DESCRIPTION"),listContent:[],markerSelector:"sapUIRta_toolbar_fragment--sapUiRta_toggleChangeVisualizationMenuButton--ChangeIndicatorCategorySelection--popover",waitForElement:true,actionSelectors:["sapUIRta_toolbar_fragment--sapUiRta_visualizationSwitcherButton-button","sapUIRta_toolbar_fragment--sapUiRta_toggleChangeVisualizationMenuButton"]},{title:_.getText("TIT_TOUR_GENERAL_STEP_SAVE_BUTTON_TITLE"),description:_.getText("TXT_TOUR_GENERAL_STEP_SAVE_BUTTON_DESCRIPTION"),listContent:[],markerSelector:"sapUIRta_toolbar_fragment--sapUiRta_save",waitForElement:true,actionSelectors:["sapUIRta_toolbar_fragment--sapUiRta_adaptationSwitcherButton-button"]},{title:_.getText("TIT_TOUR_GENERAL_STEP_UNDO_BUTTON_TITLE"),description:_.getText("TXT_TOUR_GENERAL_STEP_UNDO_BUTTON_DESCRIPTION"),listContent:[],markerSelector:"sapUIRta_toolbar_fragment--sapUiRta_undo"},{title:_.getText("TIT_TOUR_GENERAL_STEP_REDO_BUTTON_TITLE"),description:_.getText("TXT_TOUR_GENERAL_STEP_REDO_BUTTON_DESCRIPTION"),listContent:[],markerSelector:"sapUIRta_toolbar_fragment--sapUiRta_redo"},{title:_.getText("TIT_TOUR_GENERAL_STEP_ACTIVATE_VERSION_BUTTON_TITLE"),description:_.getText("TXT_TOUR_GENERAL_STEP_ACTIVATE_VERSION_BUTTON_DESCRIPTION"),listContent:[],markerSelector:"sapUIRta_toolbar_fragment--sapUiRta_activate"},{title:_.getText("TIT_TOUR_GENERAL_STEP_VERSIONS_DROPDOWN_TITLE"),description:_.getText("TXT_TOUR_GENERAL_STEP_VERSIONS_DROPDOWN_DESCRIPTION"),listContent:[],markerSelector:"sapUIRta_toolbar_fragment--sapUiRta_versionHistoryDialog--originalVersionList",waitForElement:true,actionSelectors:["sapUIRta_toolbar_fragment--sapUiRta_versionButton"]},{title:_.getText("TIT_TOUR_GENERAL_STEP_PUBLISH_BUTTON_TITLE"),description:_.getText("TXT_TOUR_GENERAL_STEP_PUBLISH_BUTTON_DESCRIPTION"),listContent:[],markerSelector:"sapUIRta_toolbar_fragment--sapUiRta_publishVersion"},{title:_.getText("TIT_TOUR_GENERAL_STEP_BURGER_MENU_TITLE"),description:_.getText("TXT_TOUR_GENERAL_STEP_BURGER_MENU_DESCRIPTION"),listContent:[{id:"translation",title:_.getText("BTN_TRANSLATE"),description:_.getText("TXT_TOUR_GENERAL_STEP_BURGER_MENU_TRANSLATIONS"),icon:"sap-icon://translate"},{id:"appVariantMenu",title:_.getText("BTN_MANAGE_APPS_TXT"),description:_.getText("TXT_TOUR_GENERAL_STEP_BURGER_MENU_APP_VARIANTS"),icon:"sap-icon://BusinessSuiteInAppSymbols/icon-variant-configuration"},{id:"restore",title:_.getText("BTN_RESTORE"),description:_.getText("TXT_TOUR_GENERAL_STEP_BURGER_MENU_RESTORE"),icon:"sap-icon://reset"},{id:"newFeaturesOverview",title:_.getText("BTN_WHATS_NEW_DIALOG_OVERVIEW"),description:_.getText("TXT_TOUR_GENERAL_STEP_BURGER_MENU_NEW_FEATURES"),icon:"sap-icon://newspaper"},{id:"generalTour",title:_.getText("BTN_GUIDED_TOUR_START"),description:_.getText("TXT_TOUR_GENERAL_STEP_BURGER_MENU_GENERAL_TOUR"),icon:"sap-icon://map-3"}],markerSelector:"sapUIRta_toolbar_fragment--sapUiRta_actionsMenu"},{title:_.getText("TIT_TOUR_GENERAL_STEP_CONTEXT_BASED_ADAPTATIONS_TITLE"),description:_.getText("TXT_TOUR_GENERAL_STEP_CONTEXT_BASED_ADAPTATIONS_DESCRIPTION"),listContent:[],markerSelector:"sapUIRta_toolbar_fragment--sapUiRta_contextBasedAdaptationsButton"},{title:_.getText("TIT_TOUR_GENERAL_STEP_FEEDBACK_BUTTON_TITLE"),description:_.getText("TXT_TOUR_GENERAL_STEP_FEEDBACK_BUTTON_DESCRIPTION"),listContent:[],markerSelector:"sapUIRta_toolbar_fragment--sapUiRta_feedback"},{title:_.getText("TIT_TOUR_GENERAL_STEP_EXIT_BUTTON_TITLE"),description:_.getText("TXT_TOUR_GENERAL_STEP_EXIT_BUTTON_DESCRIPTION"),listContent:[],markerSelector:"sapUIRta_toolbar_fragment--sapUiRta_exit"}]};T.getTourContent=function(){return a(i)};return T});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/rta/util/hasStableId", ["sap/ui/fl/Utils","sap/ui/dt/ElementUtil","sap/base/util/isPlainObject"],function(e,t,a){"use strict";function n(e){var{sParentAggregationName:t}=e;var a=e.getParent();if(a&&t){var r=a.getBindingInfo(t);if(r){if(r.template&&e instanceof r.template.getMetadata().getClass()){return r.template}return false}return n(a)}return false}return function r(i){if(!i||i._bIsBeingDestroyed){return false}if(typeof i.data("hasStableId")!=="boolean"){var l=i.getDesignTimeMetadata().getStableElements(i);var s=false;if(l.length>0){if(n(i.getElement())){s=l.some(function(n){var r;var i;var l=false;if(a(n)){r=n.id;i=n.appComponent}else{r=n}l=!e.checkControlId(r,i);if(l){var s=t.getElementInstance(r);if(t.getElementInstance(r)){var o=t.getAggregationInformation(s);l=!e.checkControlId(t.extractTemplateId(o),i)}}return l})}else{s=l.some(function(t){var a=t.id||t;return!e.checkControlId(a,t.appComponent)})}}i.data("hasStableId",!s)}return i.data("hasStableId")}});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/rta/util/isReuseComponent", ["sap/ui/fl/Utils"],function(t){"use strict";function e(e){if(!e){return false}const n=t.getAppComponentForControl(e);if(!n){return false}const s=e.getManifest();const r=n.getManifest();const o=s?.["sap.app"]?.id;const i=r?.["sap.ui5"]?.componentUsages;return Object.values(i||{}).some(t=>{if(t.name===o){return true}return false})}return e});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/rta/util/showMessageBox", ["sap/m/MessageBox","sap/ui/layout/HorizontalLayout","sap/m/Link","sap/m/Text"],function(e,r,t,n){"use strict";var a="\\[(.*?)\\]\\((.*?)\\)";function i(e){var r=o(e);return Array.isArray(r)&&r.length>0}function u(e){var r=new RegExp(`^${a}$`);return Array.isArray(r.exec(e))}function s(e){var r=new RegExp(a).exec(e);return{text:r[1],href:r[2]}}function o(e){var r=new RegExp(a,"g");return e.match(r)}function c(e){var a=new r({allowWrapping:true,content:e.map(function(e){if(u(e)){var r=s(e);return new t({text:r.text,href:r.href,target:"_blank",emphasized:true,wrapping:true})}return new n({text:e,renderWhitespace:true})})});a.addStyleClass("sapUiRtaMessageBox");return a}function p(e){var r=[e];var t=o(e);t.forEach(function(e){var t=0;while(t<r.length){var n=r[t];if(u(n)){t++}else{var a=n.split(e);var i=[];a.forEach(function(r,t,n){i.push(r);if(t!==n.length-1){i.push(e)}});r.splice.apply(r,[t,1].concat(i));t+=i.length}}});return r}return function r(t,n,a){var u;if(i(t)){var s=p(t);u=c(s)}else{u=t}e[a||"show"](u,n)}});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/rta/util/validateFlexEnabled", ["sap/ui/fl/Utils","sap/m/MessageBox","sap/base/util/ObjectPath","sap/ui/rta/util/validateStableIds","sap/ui/rta/util/showMessageBox","sap/base/Log","sap/ui/rta/Utils","sap/ui/dt/Util"],function(e,t,a,n,o,i,s,r){"use strict";return function(l){var g={};var u=[];var p=e.getAppComponentForControl(l.getRootControlInstance());function f(e,a,n,i,r){var l=a.getId();if(!g[l]){o(e._getTextResources().getText(n),{icon:t.Icon[i],title:e._getTextResources().getText(r),styleClass:s.getRtaStyleClassName()},"show");c(l,true)}}function c(e,t){g[e]=t}function d(e){var t=e.getManifest();return a.get(["sap.app","id"],t)!=="sap.ui.documentation.sdk"&&!(a.get(["sap.app","id"],t)||"").startsWith("sap.ui.rta")&&!a.get(["sap.ovp"],t)}function m(){return"QUnit"in window||window.frameElement&&(window.frameElement.getAttribute("id")||"").toLowerCase()==="opaframe"}function v(e){return e&&!e._bIsBeingDestroyed}function E(t){var a=t.getParameters().mode;if(a==="adaptation"){var n=t.getSource();var o=e.getAppComponentForControl(n.getRootControlInstance());u=u.filter(v);R(n,o,u);u=[]}}function I(t,a){var n=t.getParameters().elementOverlay;if(a.getMode()==="adaptation"){var o=e.getAppComponentForControl(a.getRootControlInstance());r.waitForSynced(a._oDesignTime,function(e){if(v(e)){R(a,o,[e])}})(n)}else{u.push(n)}}function R(e,t,a){var o=n(a,t);if(o.length){o.forEach(function(e){i.error("Control ID was generated dynamically by SAPUI5. To support SAPUI5 flexibility, a stable control ID is needed to assign the changes to.",e.getElement().getId())});f(e,t,"MSG_UNSTABLE_ID_FOUND","ERROR","HEADER_ERROR")}}l.attachEventOnce("stop",function(){c(p.getId(),false)});if(p&&d(p)){var C=p.getManifest();var _=a.get(["sap.ui5","flexEnabled"],C);if(typeof _!=="boolean"){if(!m()){f(l,p,"MSG_NO_FLEX_ENABLED_FLAG","WARNING","HEADER_WARNING")}}else{l.attachEvent("modeChanged",E);l._oDesignTime.attachEvent("elementOverlayCreated",l,I);R(l,p,l._oDesignTime.getElementOverlays())}}}});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/rta/util/validateStableIds", ["sap/base/util/ObjectPath","sap/ui/rta/util/hasStableId","sap/ui/core/mvc/View","sap/ui/core/Fragment","sap/ui/dt/OverlayUtil","sap/base/util/isPlainObject"],function(e,t,a,i,r,n){"use strict";function s(t){var a=t.getManifest();var i=!!e.get(["sap.ui5","dependencies","libs","sap.fe.templates"],a);var r=!!e.get(["sap.ui.generic.app"],a);var n=!!e.get(["sap.ovp"],a);return r||i||n}function u(t){var a=t.getManifest();var i=e.get(["sap.ui5","extends","extensions","sap.ui.viewExtensions"],a);var r=[];if(n(i)){Object.keys(i).forEach(function(e){if(e.startsWith("sap.suite.ui.generic.template")){var t=i[e];Object.keys(t).forEach(function(e){r.push(t[e])})}})}return r}function c(e,t){var n=[];for(var s=0,u=t.length;s<u;s++){var c=t[s];var f=c.getElement();var p=e.some(function(e){var t=sap.ui.require(e.className.replace(/\./g,"/"));var r;var n;if(f instanceof a){n=f.getViewName();r=e.viewName}else if(f instanceof i){n=f.getFragmentName()}else{return false}return f instanceof t&&n===r});if(p){n.push(c);if(n.length===e.length){break}}}var v=[];n.forEach(function(e){r.iterateOverlayElementTree(e,function(e){v.push(e)})});return v}return function(e,a){var i=[];var r=e.slice(0);if(s(a)){var n=u(a);r=n.length?c(n,r):[]}i=r.filter(function(e){return!e.getDesignTimeMetadata().markedAsNotAdaptable()&&!t(e)});return i}});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/rta/util/validateText", ["sap/ui/base/BindingParser","sap/ui/core/Lib"],function(r,e){"use strict";var t=" ";var o={noEmptyText:{validatorFunction(r){return r!==t},errorMessage:e.getResourceBundleFor("sap.ui.rta").getText("RENAME_EMPTY_ERROR_TEXT")}};function a(t,o){if(o===t){throw Error("sameTextError")}var a;var i;try{a=r.complexParser(t,undefined,true)}catch(r){i=true}if(a&&typeof a==="object"||i){throw Error(e.getResourceBundleFor("sap.ui.rta").getText("RENAME_BINDING_ERROR_TEXT"))}}return function(r,e,t){a(r,e);var i;var n=t&&t.validators||[];n.some(function(e){var t;if(typeof e==="string"&&o[e]){t=o[e]}else{t=e}if(!t.validatorFunction(r)){i=t.errorMessage;return true}return false});if(i){throw Error(i)}}});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/rta/util/whatsNew/WhatsNew", ["sap/m/library","sap/ui/base/ManagedObject","sap/ui/core/Element","sap/ui/core/Fragment","sap/ui/fl/write/api/FeaturesAPI","sap/ui/model/json/JSONModel","sap/ui/model/resource/ResourceModel","sap/ui/rta/util/ReloadManager","sap/ui/rta/util/whatsNew/WhatsNewUtils"],function(e,t,a,s,o,i,n,r,l){"use strict";const h=e.URLHelper;const u=t.extend("sap.ui.rta.util.whatsNew.WhatsNew",{metadata:{properties:{dontShowAgainFeatureIds:{type:"array",defaultValue:[]},layer:{type:"string",defaultValue:""}},aggregations:{whatsNewDialog:{type:"sap.m.Dialog",multiple:false}}}});u.prototype.setDontShowAgainFeatureIds=async function(e){this.setProperty("dontShowAgainFeatureIds",e);this.aUnseenFeatures=await l.getFilteredFeatures(e,this.getLayer())};u.prototype.initializeWhatsNewDialog=async function(e=[]){const t=await o.getSeenFeatureIds({layer:this.getLayer()});await this.setDontShowAgainFeatureIds(t);if(this.aUnseenFeatures.length===0||this.getLayer()!=="CUSTOMER"){return}const a=new i;const s=this.aUnseenFeatures.filter(t=>!e.includes(t.featureId));if(s.length===0){return}a.setData({featureCollection:s});if(!this.oWhatsNewDialog){await this.createWhatsNewDialog(a)}r.setDontShowWhatsNewAfterReload();this.oWhatsNewDialog.open()};u.prototype.createWhatsNewDialog=async function(e){const t=new n({bundleName:"sap.ui.rta.messagebundle"});this.oWhatsNewDialog=await s.load({name:"sap.ui.rta.util.whatsNew.WhatsNewDialog",controller:this});this.oWhatsNewDialog.setModel(t,"i18n");this.oWhatsNewDialog.setModel(e,"whatsNewModel")};u.prototype.closeWhatsNewDialog=function(){if(this.oWhatsNewDialog){const e=a.getElementById("whatsNewDialog_DontShowAgain");if(e.getSelected()){const e=this.aUnseenFeatures.map(e=>e.featureId);const t=[...this.getDontShowAgainFeatureIds(),...e];const a={layer:this.getLayer(),seenFeatureIds:t};o.setSeenFeatureIds(a)}this.oWhatsNewDialog.close()}};u.prototype.onLearnMorePress=function(){const e=a.getElementById("sapWhatsNewDialogCarousel").getActivePage();const t=l.getLearnMoreURL(e,this.aUnseenFeatures);h.redirect(t,true)};u.prototype.destroy=function(...e){t.prototype.destroy.apply(this,e);if(this.oWhatsNewDialog){this.oWhatsNewDialog.destroy()}};return u});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/rta/util/whatsNew/WhatsNewOverview", ["sap/m/library","sap/ui/core/Fragment","sap/ui/model/json/JSONModel","sap/ui/model/resource/ResourceModel","sap/ui/rta/util/whatsNew/WhatsNewUtils"],function(e,t,o,n,a){"use strict";const i={};const s=e.URLHelper;let r;let c;async function l(){const e=await a.getFilteredFeatures([]);return[...e].reverse()}i.openWhatsNewOverviewDialog=async function(){const e=new o;c=await l();e.setData({featureCollection:c});e.setProperty("overviewActive",true);if(!r){await i.createWhatsNewOverviewDialog(e)}r.open();return r};i.createWhatsNewOverviewDialog=async function(e){const o=new n({bundleName:"sap.ui.rta.messagebundle"});r=await t.load({name:"sap.ui.rta.util.whatsNew.WhatsNewOverviewDialog",controller:i});r.setModel(o,"i18n");r.setModel(e,"whatsNewModel")};i.closeWhatsNewOverviewDialog=function(){if(r){const e=r.getBindingContext("whatsNewModel");e?.setProperty("overviewActive",true);r.close()}};i.backToOverview=function(){const e=r.getBindingContext("whatsNewModel");e.setProperty("overviewActive",true)};i.onSelectListItem=function(e){const t=e.getSource();const o=t.getBindingContext("whatsNewModel");const n=o.getPath();o.setProperty("overviewActive",false);r.bindElement({path:n,model:"whatsNewModel"})};i.onLearnMorePress=function(e){const t=e.getSource().getBindingContext("whatsNewModel").getPath();const o=a.getLearnMoreURL(t,c);s.redirect(o,true)};return i});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/rta/util/whatsNew/WhatsNewUtils", ["sap/ui/fl/apply/api/FlexRuntimeInfoAPI","sap/ui/rta/Utils","sap/ui/rta/util/whatsNew/whatsNewContent/WhatsNewFeatures"],function(t,e,n){"use strict";function r(t,e){return t.filter(t=>!e?.includes(t.featureId))}async function a(t,e){const n=await Promise.all(t.map(t=>{if(typeof t.isFeatureApplicable==="function"){return t.isFeatureApplicable(e)}return true}));const r=t.filter((t,e)=>n[e]);return r}const s={getLearnMoreURL(n,r){const a=n.slice(-1);const s=!!t.getSystem();if(s){if(e.isS4HanaCloud()){return r[a].documentationUrls.s4HanaCloudUrl}return r[a].documentationUrls.s4HanaOnPremUrl}return r[a].documentationUrls.btpUrl},getFilteredFeatures(t,e){const s=n.getAllFeatures();const u=r(s,t);return a(u,e)}};return s});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/rta/util/whatsNew/whatsNewContent/WhatsNewFeatures", ["sap/ui/core/Lib"],function(e){"use strict";const t={};const T=e.getResourceBundleFor("sap.ui.rta");function a(e){const t="sap/ui/rta/util/";return`${sap.ui.require.toUrl(t)}whatsNew/whatsNewContent/whatsNewImages/${e}`}const _=[{featureId:"GuidedTour",title:T.getText("TIT_WHATS_NEW_RTA_TOUR_TITLE"),description:T.getText("TXT_WHATS_NEW_DIALOG_RTA_TOUR_DESCRIPTION"),documentationUrls:{btpUrl:"https://help.sap.com/docs/ui5-flexibility-for-key-users/ui5-flexibility-for-key-users/adapting-ui",s4HanaCloudUrl:"https://help.sap.com/docs/SAP_S4HANA_CLOUD/4fc8d03390c342da8a60f8ee387bca1a/d868950a1e8c4b0f9b9453176939a19b.html",s4HanaOnPremUrl:"https://help.sap.com/docs/ABAP_PLATFORM_NEW/a7b390faab1140c087b8926571e942b7/d868950a1e8c4b0f9b9453176939a19b.html"},information:[{text:T.getText("TXT_WHATS_NEW_DIALOG_RTA_TOUR_TEXT"),image:a("GuidedTour.png")}]},{featureId:"RenameRework",title:T.getText("TIT_WHATS_NEW_RENAME_REWORK_TITLE"),description:T.getText("TXT_WHATS_NEW_DIALOG_RENAME_REWORK_DESCRIPTION"),documentationUrls:{btpUrl:"https://help.sap.com/docs/ui5-flexibility-for-key-users/ui5-flexibility-for-key-users/making-ui-changes#renaming-a-ui-element",s4HanaCloudUrl:"https://help.sap.com/docs/SAP_S4HANA_CLOUD/4fc8d03390c342da8a60f8ee387bca1a/54270a390b194c3e97be2424592c3352.html#renaming-a-ui-element",s4HanaOnPremUrl:"https://help.sap.com/docs/ABAP_PLATFORM_NEW/a7b390faab1140c087b8926571e942b7/54270a390b194c3e97be2424592c3352.html#renaming-a-ui-element"},information:[{text:T.getText("TXT_WHATS_NEW_DIALOG_RENAME_REWORK_TEXT_1"),image:a("RenameDialog.png")},{text:T.getText("TXT_WHATS_NEW_DIALOG_RENAME_REWORK_TEXT_2"),image:a("ChangeLabelsAction.png")},{text:T.getText("TXT_WHATS_NEW_DIALOG_RENAME_REWORK_TEXT_3"),image:a("ReloadButtonToolbar.png")}]},{featureId:"TextArrangement",title:T.getText("TIT_WHATS_NEW_TEXT_ARRANGEMENT_TITLE"),description:T.getText("TXT_WHATS_NEW_DIALOG_TEXT_ARRANGEMENT_DESCRIPTION"),documentationUrls:{btpUrl:"https://help.sap.com/docs/ui5-flexibility-for-key-users/ui5-flexibility-for-key-users/making-ui-changes#text-arrangement",s4HanaCloudUrl:"https://help.sap.com/docs/SAP_S4HANA_CLOUD/4fc8d03390c342da8a60f8ee387bca1a/54270a390b194c3e97be2424592c3352.html#text-arrangement",s4HanaOnPremUrl:"https://help.sap.com/docs/ABAP_PLATFORM_NEW/a7b390faab1140c087b8926571e942b7/54270a390b194c3e97be2424592c3352.html#text-arrangement"},information:[{text:T.getText("TXT_WHATS_NEW_DIALOG_TEXT_ARRANGEMENT_TEXT_1"),image:a("DisplayBehavior.png")},{text:T.getText("TXT_WHATS_NEW_DIALOG_TEXT_ARRANGEMENT_TEXT_2"),image:null},{text:T.getText("TXT_WHATS_NEW_DIALOG_TEXT_ARRANGEMENT_TEXT_3"),image:a("ReloadButtonToolbar.png")}]},{featureId:"ExtendedActions",title:T.getText("TIT_WHATS_NEW_EXTENDED_ACTIONS_TITLE"),description:T.getText("TXT_WHATS_NEW_DIALOG_EXTENDED_ACTIONS_DESCRIPTION"),documentationUrls:{btpUrl:"https://help.sap.com/docs/ui5-flexibility-for-key-users/ui5-flexibility-for-key-users/adapting-ui",s4HanaCloudUrl:"https://help.sap.com/docs/SAP_S4HANA_CLOUD/4fc8d03390c342da8a60f8ee387bca1a/d868950a1e8c4b0f9b9453176939a19b.html",s4HanaOnPremUrl:"https://help.sap.com/docs/ABAP_PLATFORM_NEW/a7b390faab1140c087b8926571e942b7/d868950a1e8c4b0f9b9453176939a19b.html"},information:[{text:T.getText("TXT_WHATS_NEW_DIALOG_EXTENDED_ACTIONS_TEXT_1"),image:null},{text:T.getText("TXT_WHATS_NEW_DIALOG_EXTENDED_ACTIONS_TEXT_2"),image:a("ExtendedActions.png")}]},{featureId:"WhatsNewFeature",title:T.getText("TIT_WHATS_NEW_DIALOG_WHATS_NEW_FEATURE_TITLE"),description:T.getText("TXT_WHATS_NEW_DIALOG_WHATS_NEW_FEATURE_DESCRIPTION"),documentationUrls:{btpUrl:"https://help.sap.com/docs/ui5-flexibility-for-key-users/ui5-flexibility-for-key-users/adapting-ui",s4HanaCloudUrl:"https://help.sap.com/docs/SAP_S4HANA_CLOUD/4fc8d03390c342da8a60f8ee387bca1a/d868950a1e8c4b0f9b9453176939a19b.html",s4HanaOnPremUrl:"https://help.sap.com/docs/ABAP_PLATFORM_NEW/a7b390faab1140c087b8926571e942b7/d868950a1e8c4b0f9b9453176939a19b.html"},information:[{text:T.getText("TXT_WHATS_NEW_DIALOG_WHATS_NEW_FEATURE_TEXT"),image:null},{text:T.getText("TXT_WHATS_NEW_DIALOG_WHATS_NEW_OVERVIEW_TEXT"),image:a("WhatsNewOverview.png")}]},{featureId:"IFrameSandboxProperties",description:T.getText("TXT_WHATS_NEW_DIALOG_IFRAME_SANDBOX_DESCRIPTION"),documentationUrls:{btpUrl:"https://help.sap.com/docs/ui5-flexibility-for-key-users/ui5-flexibility-for-key-users/embedding-content",s4HanaCloudUrl:"https://help.sap.com/docs/SAP_S4HANA_CLOUD/4fc8d03390c342da8a60f8ee387bca1a/8db25610e91342919fcf63d4e5868ae9.html",s4HanaOnPremUrl:"https://help.sap.com/docs/ABAP_PLATFORM_NEW/a7b390faab1140c087b8926571e942b7/8db25610e91342919fcf63d4e5868ae9.html"},title:T.getText("TIT_WHATS_NEW_DIALOG_IFRAME_SANDBOX_TITLE"),information:[{text:T.getText("TXT_WHATS_NEW_DIALOG_IFRAME_SANDBOX_TEXT"),image:null},{text:T.getText("TXT_WHATS_NEW_DIALOG_IFRAME_SANDBOX_TEXT_2"),image:a("FullIframe.png")},{text:T.getText("TXT_WHATS_NEW_DIALOG_IFRAME_SANDBOX_TEXT_3"),image:a("AdvancedSettingsImage.png")}]},{featureId:"MinimenuRemoval",title:T.getText("TIT_WHATS_NEW_DIALOG_MINIMENU_REMOVAL_TITLE"),description:T.getText("TXT_WHATS_NEW_DIALOG_MINIMENU_REMOVAL_DESCRIPTION"),documentationUrls:{btpUrl:"https://help.sap.com/docs/ui5-flexibility-for-key-users/ui5-flexibility-for-key-users/adapting-ui",s4HanaCloudUrl:"https://help.sap.com/docs/SAP_S4HANA_CLOUD/4fc8d03390c342da8a60f8ee387bca1a/d868950a1e8c4b0f9b9453176939a19b.html",s4HanaOnPremUrl:"https://help.sap.com/docs/ABAP_PLATFORM_NEW/a7b390faab1140c087b8926571e942b7/d868950a1e8c4b0f9b9453176939a19b.html"},information:[{text:T.getText("TXT_WHATS_NEW_DIALOG_MINIMENU_REMOVAL_TEXT"),image:a("MiniMenu.png")}]}];t.getAllFeatures=function(){return _};return t});
sap.ui.require.preload({
	"sap/ui/rta/appVariant/manageApps/webapp/index.js":function(){
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.require(["sap/m/Shell","sap/ui/core/ComponentContainer","sap/ui/core/Core"],function(a,e,p){"use strict";p.ready().then(()=>{new a({app:new e({height:"100%",name:"sap.ui.rta.appVariant.manageApps",settings:{id:"sap.ui.rta.appVariant.manageApps"}})}).placeAt("content")})});
},
	"sap/ui/rta/appVariant/manageApps/webapp/manifest.json":'{"_version":"1.21.0","sap.app":{"id":"sap.ui.rta.appVariant.manageApps","type":"application","i18n":{"bundleUrl":"i18n/i18n.properties","supportedLocales":["","ar","bg","ca","cs","da","de","el","en","en_US_sappsd","en_US_saptrc","es","et","fi","fr","hi","hr","hu","it","iw","ja","kk","ko","lt","lv","ms","nl","no","pl","pt","ro","ru","sh","sk","sl","sv","th","tr","uk","vi","zh_CN","zh_TW"],"fallbackLocale":"en"},"applicationVersion":{"version":"1.0.0"},"title":"{{appTitle}}","description":"{{appDescription}}","resources":"resources.json","ach":"ach","sourceTemplate":{"id":"ui5template.basicSAPUI5ApplicationProject","version":"1.40.12"}},"sap.ui":{"technology":"UI5","icons":{"icon":"","favIcon":"","phone":"","phone@2":"","tablet":"","tablet@2":""},"deviceTypes":{"desktop":true,"tablet":true,"phone":true}},"sap.ui5":{"rootView":{"viewName":"sap.ui.rta.appVariant.manageApps.webapp.view.ManageApps","type":"XML","async":true},"dependencies":{"minUI5Version":"1.30.0","libs":{"sap.m":{},"sap.ui.core":{},"sap.ui.layout":{},"sap.ui.rta":{}}},"contentDensities":{"compact":true,"cozy":true},"models":{"i18n":{"type":"sap.ui.model.resource.ResourceModel","settings":{"bundleName":"sap.ui.rta.appVariant.manageApps.webapp.i18n.i18n","supportedLocales":["","ar","bg","ca","cs","da","de","el","en","en_US_sappsd","en_US_saptrc","es","et","fi","fr","hi","hr","hu","it","iw","ja","kk","ko","lt","lv","ms","nl","no","pl","pt","ro","ru","sh","sk","sl","sv","th","tr","uk","vi","zh_CN","zh_TW"],"fallbackLocale":"en"}}},"resources":{"css":[{"uri":"css/style.css"}]}}}',
	"sap/ui/rta/appVariant/manageApps/webapp/view/ManageApps.view.xml":'<mvc:View\n\tcontrollerName="sap.ui.rta.appVariant.manageApps.webapp.controller.ManageApps"\n\txmlns:mvc="sap.ui.core.mvc"\n\txmlns:core="sap.ui.core"\n\txmlns="sap.m"><Table id="Table1"\n\t\tshowNoData="false"\n\t\tinset="false"\n\t\tgrowing="true"\n\t\tgrowingThreshold="500"\n\t\tsticky="ColumnHeaders"\n\t\titems="{/appVariants}"><columns><Column\n\t\t\t\twidth="8rem"\n\t\t\t\thAlign="Left"><Text text="{i18n>MAA_DIALOG_APP_TYPE}" /></Column><Column\n\t\t\t\twidth="4rem"\n\t\t\t\tminScreenWidth="tablet"\n\t\t\t\tdemandPopin="true"\n\t\t\t\tpopinDisplay="Inline"\n\t\t\t\thAlign="Left"><core:InvisibleText text="{i18n>MAA_DIALOG_ICON}" /></Column><Column\n\t\t\t\tminScreenWidth="tablet"\n\t\t\t\tdemandPopin="true"\n\t\t\t\tpopinDisplay="Inline"\n\t\t\t\thAlign="Left"><Text text="{i18n>MAA_DIALOG_TITLE}" /></Column><Column\n\t\t\t\tminScreenWidth="tablet"\n\t\t\t\tdemandPopin="true"\n\t\t\t\tpopinDisplay="Inline"\n\t\t\t\thAlign="Left"><Text text="{i18n>MAA_DIALOG_DESCRIPTION}" /></Column><Column\n\t\t\t\twidth="8rem"\n\t\t\t\tminScreenWidth="Desktop"\n\t\t\t\tdemandPopin="true"\n\t\t\t\tpopinDisplay="Inline"\n\t\t\t\thAlign="End"><core:InvisibleText text="{i18n>MAA_DIALOG_ACTIONS_HEADER}" /></Column></columns><items><ColumnListItem highlight="{path: \'currentStatus\', formatter:\'.formatRowHighlight\'}"><cells><ObjectIdentifier\n\t\t\t\t\t\ttitle="{typeOfApp}"\n\t\t\t\t\t\ttext="{currentStatus}" /><core:Icon src="{icon}" tooltip="{iconText}" class="sapUiListTableIconSize" /><ObjectIdentifier\n\t\t\t\t\t\ttitle="{title}"\n\t\t\t\t\t\ttext="{subTitle}" /><Text text="{description}" /><MenuButton text="{i18n>MAA_DIALOG_ACTIONS}"><menu><Menu itemSelected="onMenuAction"><items><MenuItem text="{i18n>MAA_DIALOG_ADAPT_UI}"\n\t\t\t\t\t\t\t\t\t\tvisible="{parts: [{path: \'adaptUIButtonVisibility\'}, {path: \'isKeyUser\'}], formatter:\'.formatAdaptUIButtonVisibility\'}"\n\t\t\t\t\t\t\t\t\t\tenabled="{adaptUIButtonEnabled}"\n\t\t\t\t\t\t\t\t\t\ttooltip="{parts: [{path: \'adaptUIButtonEnabled\'}, {path: \'appVarStatus\'}], formatter:\'.formatAdaptUIButtonTooltip\'}"\n\t\t\t\t\t\t\t\t\t\ticon="sap-icon://wrench"/><MenuItem text="{i18n>MAA_DIALOG_COPY_ID}" tooltip="{i18n>TOOLTIP_MAA_DIALOG_COPY_ID}" icon="sap-icon://copy" /><MenuItem text="{i18n>MAA_DIALOG_DELETE_APPVAR}"\n\t\t\t\t\t\t\t\t\t\tenabled="{delAppVarButtonEnabled}"\n\t\t\t\t\t\t\t\t\t\tvisible="{delAppVarButtonVisibility}"\n\t\t\t\t\t\t\t\t\t\ttooltip="{parts: [{path: \'delAppVarButtonEnabled\'}, {path: \'isS4HanaCloud\'}], formatter:\'.formatDelButtonTooltip\'}"\n\t\t\t\t\t\t\t\t\t\ticon="sap-icon://delete" /></items></Menu></menu></MenuButton></cells></ColumnListItem></items></Table></mvc:View>',
	"sap/ui/rta/manifest.json":'{"_version":"1.21.0","sap.app":{"id":"sap.ui.rta","type":"library","embeds":["appVariant/manageApps/webapp"],"applicationVersion":{"version":"1.136.0"},"title":"SAPUI5 library with RTA controls.","description":"SAPUI5 library with RTA controls.","ach":"CA-UI5-FL-RTA","resources":"resources.json","offline":true},"sap.ui":{"technology":"UI5","supportedThemes":["base","sap_hcb"]},"sap.ui5":{"dependencies":{"minUI5Version":"1.136","libs":{"sap.ui.core":{"minVersion":"1.136.0"},"sap.ui.layout":{"minVersion":"1.136.0"},"sap.m":{"minVersion":"1.136.0"},"sap.ui.fl":{"minVersion":"1.136.0"},"sap.ui.dt":{"minVersion":"1.136.0"}}},"library":{"i18n":{"bundleUrl":"messagebundle.properties","supportedLocales":["","ar","bg","ca","cnr","cs","cy","da","de","el","en","en-GB","en-US-sappsd","en-US-saprigi","en-US-saptrc","es","es-MX","et","fi","fr","fr-CA","hi","hr","hu","id","it","iw","ja","kk","ko","lt","lv","mk","ms","nl","no","pl","pt","pt-PT","ro","ru","sh","sk","sl","sr","sv","th","tr","uk","vi","zh-CN","zh-TW"]},"content":{"controls":[],"elements":[],"types":[],"interfaces":[]}}}}',
	"sap/ui/rta/plugin/additionalElements/AddElementsDialog.fragment.xml":'<core:FragmentDefinition\n\txmlns="sap.m"\n\txmlns:core="sap.ui.core"\n\txmlns:layout="sap.ui.layout"><Dialog\n\t\tclass="sapUIRtaFieldRepositoryDialog sapUiNoContentPadding"\n\t\thorizontalScrolling="false"><buttons><Button\n\t\t\t\tid="rta_addDialogOkButton"\n\t\t\t\ttext="{i18n>BTN_FREP_OK}"\n\t\t\t\tpress="._submitDialog"\n\t\t\t\ttype="Emphasized"/><Button\n\t\t\t\ttext="{i18n>BTN_FREP_CANCEL}"\n\t\t\t\tpress="._cancelDialog"/></buttons><content><Toolbar><SearchField\n\t\t\t\t\twidth="100%"\n\t\t\t\t\tshowSearchButton="false"\n\t\t\t\t\tliveChange="._updateModelFilter"/><Button\n\t\t\t\t\ttext=""\n\t\t\t\t\ticon="sap-icon://sort"\n\t\t\t\t\tpress="._resortList"/><Button\n\t\t\t\t\tid="rta_customFieldButton"\n\t\t\t\t\ttext="{/customFieldButtonText}"\n\t\t\t\t\ttooltip="{/customFieldButtonTooltip}"\n\t\t\t\t\tvisible="{/customFieldButtonVisible}"\n\t\t\t\t\tpress="._redirectToExtensibilityAction(${/extensibilityOptions/0/actionKey})"/><MenuButton\n\t\t\t\t\tid="rta_customFieldMenuButton"\n\t\t\t\t\ttext="{/extensibilityMenuButtonText}"\n\t\t\t\t\ttooltip="{/extensibilityMenuButtonTooltip}"\n\t\t\t\t\tvisible="{/extensibilityMenuButtonActive}"><Menu\n\t\t\t\t\t\titems="{/extensibilityOptions}"><items><MenuItem\n\t\t\t\t\t\t\t\ttext="{text}"\n\t\t\t\t\t\t\t\ttooltip="{tooltip}"\n\t\t\t\t\t\t\t\tpress="_redirectToExtensibilityAction(${actionKey})"/></items></Menu></MenuButton></Toolbar><layout:VerticalLayout\n\t\t\t\tid="rta_businessContextContainer"\n\t\t\t\tclass="sapUIRtaBusinessContextContainer"\n\t\t\t\tvisible="{/businessContextVisible}"\n\t\t\t\tcontent="{/businessContextTexts}"><Text text="{text}"/></layout:VerticalLayout><ScrollContainer\n\t\t\t\tclass="sapUIRtaCCDialogScrollContainer"\n\t\t\t\tvertical="true"\n\t\t\t\thorizontal="false"><List\n\t\t\t\t\tid="rta_addElementsDialogList"\n\t\t\t\t\tmode="MultiSelect"\n\t\t\t\t\tincludeItemInSelection="true"\n\t\t\t\t\tgrowing="true"\n\t\t\t\t\tgrowingScrollToLoad="true"\n\t\t\t\t\titems="{ path: \'/elements\', sorter: { path: \'label\', descending: false}, templateShareable: false }"\n\t\t\t\t\tnoDataText="{i18n>MSG_NO_FIELDS}"><CustomListItem\n\t\t\t\t\t\tclass="sapUIRtaListItem"\n\t\t\t\t\t\ttype="Active"\n\t\t\t\t\t\tselected="{selected}"\n\t\t\t\t\t\ttooltip="{tooltip}"><VBox><Label\n\t\t\t\t\t\t\t\tdesign="Standard"\n\t\t\t\t\t\t\t\ttext="{= ${parentPropertyName} &amp;&amp; ${duplicateName} ? ${label} + \' (\' + ${parentPropertyName} + \')\' : ${label} }"/><Label\n\t\t\t\t\t\t\t\ttext="{= ${originalLabel} ? ${i18n>LBL_FREP}.replace(\'{0}\', ${originalLabel}) : \'\'}"\n\t\t\t\t\t\t\t\tvisible="{= !!${originalLabel} }"/></VBox></CustomListItem></List></ScrollContainer></content></Dialog></core:FragmentDefinition>',
	"sap/ui/rta/plugin/annotations/AnnotationChangeDialog.fragment.xml":'<core:FragmentDefinition\n\txmlns:core="sap.ui.core"\n\txmlns:f="sap.ui.layout.form"\n\txmlns="sap.m"\n><Dialog\n\t\tid="sapUiRtaChangeAnnotationDialog"\n\t\tverticalScrolling="true"\n\t\tresizable="false"\n\t\tdraggable="true"\n\t\tcontentWidth="50rem"\n\t\tcontentHeight="{= ${/singleRename} === true ? \'auto\' : \'25rem\'}"\n\t\ttitle="{/title}"\n\t\tclass="sapUiContentPadding"\n\t\tescapeHandler=".onCancel"\n\t><content><VBox><MessageStrip\n\t\t\t\t\ttext="{i18n>ANNOTATION_CHANGE_DIALOG_WARNING}"\n\t\t\t\t\ttype="Warning"\n\t\t\t\t\tshowIcon="true"\n\t\t\t\t\tclass="sapUiSmallMarginBottom"><link><Link text="{i18n>ANNOTATION_CHANGE_DIALOG_WARNING_MORE_INFO}"\n\t\t\t\t\t\t\ttarget="_blank"\n\t\t\t\t\t\t\thref=""/></link></MessageStrip><Label\n\t\t\t\t\tid="sapUiRtaChangeAnnotationDialog_description"\n\t\t\t\t\tvisible="{= ${/description}.length > 0}"\n\t\t\t\t\ttext="{/description}"/><HBox\n\t\t\t\t\tid="sapUiRtaChangeAnnotationDialog_filterHBox"\n\t\t\t\t\tfitContainer="true"\n\t\t\t\t\tvisible="{= ${/singleRename} === false}"\n\t\t\t\t><SearchField\n\t\t\t\t\t\tid="sapUiRtaChangeAnnotationDialog_propertiesFilter"\n\t\t\t\t\t\tplaceholder="{i18n>ANNOTATION_CHANGE_DIALOG_PROPERTY_SEARCH}"\n\t\t\t\t\t\tvalue="{/filterText}"\n\t\t\t\t\t\tliveChange="onFilterProperties"><layoutData><FlexItemData growFactor="1" styleClass="sapUiSmallMarginEnd"/></layoutData></SearchField><HBox alignItems="Center"><Label\n\t\t\t\t\t\t\ttext="{i18n>ANNOTATION_CHANGE_DIALOG_BUTTON_CHANGED_PROPERTIES}"/><Switch\n\t\t\t\t\t\t\tid="sapUiRtaChangeAnnotationDialog_toggleShowAllPropertiesSwitch"\n\t\t\t\t\t\t\tstate="{/showChangedPropertiesOnly}"\n\t\t\t\t\t\t\tchange="switchDisplayMode"\n\t\t\t\t\t\t\tcustomTextOn=" "\n\t\t\t\t\t\t\tcustomTextOff=" "/></HBox></HBox><f:Form editable="true"><f:layout><f:ResponsiveGridLayout\n\t\t\t\t\t\t\tlabelSpanXL="4"\n\t\t\t\t\t\t\tlabelSpanL="4"\n\t\t\t\t\t\t\tlabelSpanM="4"\n\t\t\t\t\t\t\tlabelSpanS="12"\n\t\t\t\t\t\t\tadjustLabelSpan="false"\n\t\t\t\t\t\t\temptySpanXL="0"\n\t\t\t\t\t\t\temptySpanL="0"\n\t\t\t\t\t\t\temptySpanM="0"\n\t\t\t\t\t\t\temptySpanS="0"\n\t\t\t\t\t\t\tcolumnsXL="1"\n\t\t\t\t\t\t\tcolumnsL="1"\n\t\t\t\t\t\t\tcolumnsM="1"\n\t\t\t\t\t\t\tsingleContainerFullSize="true"/></f:layout><f:FormContainer\n\t\t\t\t\t\tid="sapUiRtaChangeAnnotationDialog_propertyList"\n\t\t\t\t\t\tformElements="{path: \'/propertiesToDisplay\', factory: \'.editorFactory\'}" /></f:Form></VBox></content><beginButton><Button\n\t\t\t\tid="sapUiRtaChangeAnnotationDialog_saveButton"\n\t\t\t\ttype="Emphasized"\n\t\t\t\ttext="{i18n>ANNOTATION_CHANGE_DIALOG_CONFIRM}"\n\t\t\t\tpress="onSave"\n\t\t\t/></beginButton><endButton><Button\n\t\t\t\tid="sapUiRtaChangeAnnotationDialog_cancelButton"\n\t\t\t\ttype="Transparent"\n\t\t\t\ttext="{i18n>ANNOTATION_CHANGE_DIALOG_CANCEL}"\n\t\t\t\tpress="onCancel"\n\t\t\t/></endButton></Dialog></core:FragmentDefinition>\n',
	"sap/ui/rta/plugin/iframe/AddIFrameDialog.fragment.xml":'<core:FragmentDefinition\n\t\txmlns:core="sap.ui.core"\n\t\txmlns="sap.m"\n\t\txmlns:form="sap.ui.layout.form"\n\t\txmlns:util="sap.ui.fl.util"\n\t\txmlns:layout="sap.ui.layout"><Dialog\n\t\tid="sapUiRtaAddIFrameDialog"\n\t\ttitle="{dialogInfo>/text/dialogTitle}"\n\t\tverticalScrolling="true"\n\t\tresizable="false"\n\t\tclass="sapUiRtaAddIFrameDialog"\n\t\tdraggable="true"\n\t\tvalidationSuccess="onValidationSuccess"\n\t\tvalidationError="onValidationError"\n\t\tparseError="onValidationError"\n\t\tcontentWidth="50rem"\n\t\tcontentHeight="44rem"\n\t\tcore:require="{ FloatType: \'sap/ui/model/type/Float\' }"\n\t\tafterOpen="configureMultiInput"\n\t><content><layout:VerticalLayout\n\t\t\t\t\tid="sapUiRtaAddIFrameDialog_VL"\n\t\t\t\t\twidth="100%"\n\t\t\t\t\tclass="sapUiRtaAddIFrameDialogVlWrapper"><VBox visible="{dialogInfo>/asContainer/value}" class="sapUiRtaAddIFrameDialogContainerTitleVBox" renderType="Bare"><items><Label\n\t\t\t\t\t\t\tid="sapUiRtaAddIFrameDialog_ContainerTitleLabel"\n\t\t\t\t\t\t\ttext="{dialogInfo>/text/containerTitleLabel}"\n\t\t\t\t\t\t\tclass="sapUiRtaAddIFrameDialogContainerTitleLabel"\n\t\t\t\t\t\t\tdesign="Bold"\n\t\t\t\t\t\t/><Input\n\t\t\t\t\t\t\tid="sapUiRtaAddIFrameDialog_ContainerTitle_TitleInput"\n\t\t\t\t\t\t\tclass="sapUiRtaAddIFrameDialogContainerTitleInput"\n\t\t\t\t\t\t\tvalue="{\n\t\t\t\t\t\t\t\tpath : \'dialogInfo>/title/value\',\n\t\t\t\t\t\t\t\ttype : \'sap.ui.model.type.String\'\n\t\t\t\t\t\t\t}"\n\t\t\t\t\t\t\tliveChange=".onContainerTitleChange"\n\t\t\t\t\t\t\tvalueLiveUpdate="true"\n\t\t\t\t\t\t\tvalueState="{dialogInfo>/title/valueState}"\n\t\t\t\t\t\t/></items></VBox><VBox><items><Label id="sapUiRtaAddIFrameDialog_SizeTitle" text="{dialogInfo>/text/sizeTitle}" class="sapUiRtaAddIFrameDialogSizeTitle" design="Bold"/><layout:Grid\n\t\t\t\t\t\t\t\tid="sapUiRtaAddIFrameDialog_SizeGrid"\n\t\t\t\t\t\t\t\tcontainerQuery="true" position="Center"\n\t\t\t\t\t\t\t\tclass="sapUiRtaAddIFrameDialogSizeGrid"\n\t\t\t\t\t\t\t\tdefaultSpan="XL6 L6 M6 S12"><form:SimpleForm\n\t\t\t\t\t\t\t\t\tid="sapUiRtaAddIFrameDialog_WidthForm" editable="true" layout="ResponsiveGridLayout" class="sapUiRtaAddIFrameDialogWidthForm"\n\t\t\t\t\t\t\t\t\tadjustLabelSpan="false" singleContainerFullSize="false" ariaLabelledBy="sapUiRtaAddIFrameDialog_WidthLabel"\n\t\t\t\t\t\t\t\t\tlabelSpanXL="2" labelSpanL="2" labelSpanM="2" labelSpanS="4"\n\t\t\t\t\t\t\t\t\temptySpanXL="2" emptySpanL="2" emptySpanM="2" emptySpanS="0"\n\t\t\t\t\t\t\t><form:content><Label id="sapUiRtaAddIFrameDialog_WidthLabel" class="sapUiRtaAddIFrameDialogWidthLabel" labelFor="sapUiRtaAddIFrameDialog_WidthInput"\n\t\t\t\t\t\t\t\t\t\ttext="{dialogInfo>/text/widthLabel}"></Label><Input\n\t\t\t\t\t\t\t\t\t\tid="sapUiRtaAddIFrameDialog_WidthInput"\n\t\t\t\t\t\t\t\t\t\tclass="sapUiRtaAddIFrameDialogWidthInput"\n\t\t\t\t\t\t\t\t\t\tvalue="{path: \'dialogInfo>/frameWidth/value\', type: \'FloatType\', constraints: {minimum: 1}}"\n\t\t\t\t\t\t\t\t\t\tvalueState="{dialogInfo>/frameWidth/valueState}"\n\t\t\t\t\t\t\t\t\t\tvalueStateText="{dialogInfo>/text/dimensionsErrorText}"\n\t\t\t\t\t\t\t\t\t/><Select\n\t\t\t\t\t\t\t\t\t\tid="sapUiRtaAddIFrameDialog_WidthUnit"\n\t\t\t\t\t\t\t\t\t\tclass="sapUiRtaAddIFrameDialogWidthUnit"\n\t\t\t\t\t\t\t\t\t\tariaLabelledBy="sapUiRtaAddIFrameDialog_WidthUnitLabel"\n\t\t\t\t\t\t\t\t\t\tselectedKey="{dialogInfo>/frameWidthUnit/value}"\n\t\t\t\t\t\t\t\t\t\titems="{dialogInfo>/unitsOfWidthMeasure}"\n\t\t\t\t\t\t\t\t\t\tshowSecondaryValues="true"\n\t\t\t\t\t\t\t\t\t\tcolumnRatio="1:5"\n\t\t\t\t\t\t\t\t\t\twidth="auto"\n\t\t\t\t\t\t\t\t\t\tmaxWidth="400px"><core:ListItem key="{dialogInfo>unit}" text="{dialogInfo>unit}" additionalText="{dialogInfo>descriptionText}"/></Select></form:content></form:SimpleForm><form:SimpleForm\n\t\t\t\t\t\t\t\t\tid="sapUiRtaAddIFrameDialog_HeightForm" editable="true" layout="ResponsiveGridLayout" class="sapUiRtaAddIFrameDialogHeightForm"\n\t\t\t\t\t\t\t\t\tadjustLabelSpan="false" singleContainerFullSize="false" ariaLabelledBy="sapUiRtaAddIFrameDialog_HeightLabel"\n\t\t\t\t\t\t\t\t\tlabelSpanXL="2" labelSpanL="2" labelSpanM="2" labelSpanS="4"\n\t\t\t\t\t\t\t\t\temptySpanXL="2" emptySpanL="2" emptySpanM="2" emptySpanS="0"\n\t\t\t\t\t\t\t><form:content><Label id="sapUiRtaAddIFrameDialog_HeightLabel" class="sapUiRtaAddIFrameDialogHeightLabel" labelFor="sapUiRtaAddIFrameDialog_HeightInput"\n\t\t\t\t\t\t\t\t\t\ttext="{dialogInfo>/text/heightLabel}"/><Input\n\t\t\t\t\t\t\t\t\t\tid="sapUiRtaAddIFrameDialog_HeightInput"\n\t\t\t\t\t\t\t\t\t\tclass="sapUiRtaAddIFrameDialogHeightInput"\n\t\t\t\t\t\t\t\t\t\tvalue="{path: \'dialogInfo>/frameHeight/value\', type: \'FloatType\', constraints: {minimum: 1}}"\n\t\t\t\t\t\t\t\t\t\tvalueState="{dialogInfo>/frameHeight/valueState}"\n\t\t\t\t\t\t\t\t\t\tvalueStateText="{dialogInfo>/text/dimensionsErrorText}"\n\t\t\t\t\t\t\t\t\t/><Select\n\t\t\t\t\t\t\t\t\t\tid="sapUiRtaAddIFrameDialog_HeightUnit"\n\t\t\t\t\t\t\t\t\t\tclass="sapUiRtaAddIFrameDialogHeightUnit"\n\t\t\t\t\t\t\t\t\t\tariaLabelledBy="sapUiRtaAddIFrameDialog_HeightUnitLabel"\n\t\t\t\t\t\t\t\t\t\tselectedKey="{dialogInfo>/frameHeightUnit/value}"\n\t\t\t\t\t\t\t\t\t\tforceSelection="false"\n\t\t\t\t\t\t\t\t\t\titems="{dialogInfo>/unitsOfHeightMeasure}"\n\t\t\t\t\t\t\t\t\t\tshowSecondaryValues="true"\n\t\t\t\t\t\t\t\t\t\tcolumnRatio="1:5"\n\t\t\t\t\t\t\t\t\t\twidth="auto"\n\t\t\t\t\t\t\t\t\t\tmaxWidth="400px"><core:ListItem key="{dialogInfo>unit}" text="{= ${dialogInfo>unit} === \'vh\' ? \'%\' : ${dialogInfo>unit}}" additionalText="{dialogInfo>descriptionText}"/></Select></form:content></form:SimpleForm></layout:Grid></items></VBox><layout:Grid\n\t\t\t\t\t\tid="sapUiRtaAddIFrameDialog_PercentGrid"\n\t\t\t\t\t\tclass="sapUiRtaAddIFrameDialogPercentGrid"\n\t\t\t\t\t\tcontainerQuery="true"\n\t\t\t\t\t\tposition="Right"\n\t\t\t\t\t\tdefaultSpan="XL12 L12 M12 S12"><Text id="sapUiRtaAddIFrameDialog_PercentText" text="{dialogInfo>/text/percentUseLabel}" class="sapUiRtaAddIFrameDialogPercentText"/></layout:Grid><layout:Grid\n\t\t\t\t\t\tid="sapUiRtaAddIFrameDialog_EditGrid"\n\t\t\t\t\t\tclass="sapUiRtaAddIFrameDialogEditGrid"\n\t\t\t\t\t\tcontainerQuery="true"\n\t\t\t\t\t\tdefaultSpan="XL6 L6 M6 S12"><VBox id="sapUiRtaAddIFrameDialog_Parameters" class="sapUiRtaAddIFrameDialogParameters" renderType="Bare"><items><Label id="sapUiRtaAddIFrameDialog_ParametersLabel" text="{dialogInfo>/text/parametersLabel}" labelFor="sapUiRtaAddIFrameDialog_ParameterTable"\n\t\t\t\t\t\t\t\t   class="sapUiRtaAddIFrameDialogParametersLabel" design="Bold"/><SearchField\n\t\t\t\t\t\t\t\tid="sapUiRtaAddIFrameDialog_ParametersSearch"\n\t\t\t\t\t\t\t\tariaLabelledBy="sapUiRtaAddIFrameDialog_ParameterSearchLabel"\n\t\t\t\t\t\t\t\tclass="sapUiRtaAddIFrameDialogParametersSearch"\n\t\t\t\t\t\t\t\tliveChange="onLiveChange"\n\t\t\t\t\t\t\t\tshowSearchButton="false"\n\t\t\t\t\t\t\t/><ScrollContainer height="12rem" vertical="true" ><Table id="sapUiRtaAddIFrameDialog_ParameterTable" items="{dialogInfo>/parameters/value}" ariaLabelledBy="sapUiRtaAddIFrameDialog_ParametersLabel"\n\t\t\t\t\t\t\t\t\t   class="sapUiSizeCompact sapUiRtaAddIFrameDialogParameterTable" sticky="ColumnHeaders"><columns><Column><header><Label id="sapUiRtaAddIFrameDialog_ParameterLabel" class="sapUiRtaAddIFrameDialogParameterLabel" text="{dialogInfo>/text/columnParameterLabel}"/></header></Column><Column><header><Label id="sapUiRtaAddIFrameDialog_ValueLabel" class="sapUiRtaAddIFrameDialog_ValueLabel" text="{dialogInfo>/text/columnUiValueLabel}"/></header></Column></columns><items><ColumnListItem type="Active" press="onParameterPress"><cells><Text\n\t\t\t\t\t\t\t\t\t\t\t\t\ttext="{dialogInfo>label}"\n\t\t\t\t\t\t\t\t\t\t\t\t\ttooltip="{dialogInfo>label}"\n\t\t\t\t\t\t\t\t\t\t\t\t/><Text\n\t\t\t\t\t\t\t\t\t\t\t\t\ttext="{dialogInfo>value}"\n\t\t\t\t\t\t\t\t\t\t\t\t\ttooltip="{=${dialogInfo>value}.toString()}"\n\t\t\t\t\t\t\t\t\t\t\t\t\twrapping="false"\n\t\t\t\t\t\t\t\t\t\t\t\t/></cells></ColumnListItem></items></Table></ScrollContainer></items></VBox><VBox id="sapUiRtaAddIFrameDialog_EditUrl" class="sapUiRtaAddIFrameDialogEditUrl" renderType="Bare"><items><Label id="sapUiRtaAddIFrameDialog_EditUrlLabel" labelFor="sapUiRtaAddIFrameDialog_EditUrlTA"\n\t\t\t\t\t\t\t\t   class="sapUiRtaAddIFrameDialogEditUrlLabel" text="{dialogInfo>/text/editUrlLabel}" design="Bold" /><TextArea\n\t\t\t\t\t\t\t\tid="sapUiRtaAddIFrameDialog_EditUrlTA"\n\t\t\t\t\t\t\t\tfieldGroupIds = "sapUiRtaAddIFrameDialog_EditUrlTA"\n\t\t\t\t\t\t\t\tariaLabelledBy="sapUiRtaAddIFrameDialog_EditUrlLabel"\n\t\t\t\t\t\t\t\tclass="sapUiRtaAddIFrameDialog_EditUrlTA"\n\t\t\t\t\t\t\t\tvalueLiveUpdate="true"\n\t\t\t\t\t\t\t\tvalue="{dialogInfo>/frameUrl/value}"\n\t\t\t\t\t\t\t\tvalueState="{= !!${dialogInfo>/frameUrlError/value} ? \'Error\' : \'None\'}"\n\t\t\t\t\t\t\t\tvalueStateText="{dialogInfo>/frameUrlError/value}"\n\t\t\t\t\t\t\t\tvalidateFieldGroup="onValidateUrl"\n\t\t\t\t\t\t\t\trows="11"\n\t\t\t\t\t\t\t\twidth="100%" /></items></VBox></layout:Grid><layout:Grid\n\t\t\t\t\t\tid="sapUiRtaAddIFrameDialog_UrlWarningGrid"\n\t\t\t\t\t\tclass="sapUiRtaAddIFrameDialogUrlWarningGrid"\n\t\t\t\t\t\tcontainerQuery="true"\n\t\t\t\t\t\tdefaultSpan="XL12 L12 M12 S12"><FormattedText\n\t\t\t\t\t\t\tid="sapUiRtaAddIFrameDialog_DocumentationLink"\n\t\t\t\t\t\t\thtmlText="{dialogInfo>/documentationLink/HTML}" class="sapUiRtaAddIFrameDialogDocumentationLink"/></layout:Grid><layout:Grid\n\t\t\t\t\tid="sapUiRtaAddIFrameDialog_PreviewLinkGrid"\n\t\t\t\t\tclass="sapUiRtaAddIFrameDialogPreviewLinkGrid"\n\t\t\t\t\tcontainerQuery="true"\n\t\t\t\t\tdefaultSpan="XL12 L12 M12 S12"><Panel id="sapUiRtaAddIFrameDialog_PreviewLinkPanel"\n\t\t\t\t\t\t   expandable="true" width="auto" expanded="false"\n\t\t\t\t\t\t   class="sapUiResponsiveMargin sapUiRtaAddIFrameDialogPreviewLinkPanel"><headerToolbar><OverflowToolbar\n\t\t\t\t\t\t\t\t\tid="sapUiRtaAddIFrameDialog_PreviewLinkToolbar"\n\t\t\t\t\t\t\t\t\tclass="sapUiRtaAddIFrameDialogPreviewLinkToolbar" height="3rem" style="Clear"><Title\n\t\t\t\t\t\t\t\t\tid="sapUiRtaAddIFrameDialog_PreviewLinkTitle"\n\t\t\t\t\t\t\t\t\tclass="sapUiRtaAddIFrameDialogPreviewLinkTitle"\n\t\t\t\t\t\t\t\t\ttext="{dialogInfo>/text/previewUrlLabel}" /><ToolbarSpacer /><Button\n\t\t\t\t\t\t\t\t\tid="sapUiRtaAddIFrameDialog_PreviewButton"\n\t\t\t\t\t\t\t\t\tenabled="{= !${dialogInfo>/frameUrlError/value} &amp;&amp; (${dialogInfo>/previousFrameUrl/value} !== ${dialogInfo>/frameUrl/value} || ${dialogInfo>/settingsUpdate/value})}"\n\t\t\t\t\t\t\t\t\ttext="{=${dialogInfo>/previewUrl/value} === \'\' ? ${dialogInfo>/text/showPreviewButton} : ${dialogInfo>/text/updatePreviewButton} }"\n\t\t\t\t\t\t\t\t\tpress="onShowPreview"\n\t\t\t\t\t\t\t\t\tclass="sapUiTinyMarginTop sapUiRtaAddIFrameDialogPreviewButton" /></OverflowToolbar></headerToolbar><content><Label visible="false" id="sapUiRtaAddIFrameDialog_PreviewLinkResolver"/><Link\n\t\t\t\t\t\t\t\tid="sapUiRtaAddIFrameDialog_PreviewLink"\n\t\t\t\t\t\t\t\tclass="sapUiRtaAddIFrameDialogPreviewLink"\n\t\t\t\t\t\t\t\thref="{dialogInfo>/previewUrl/value}"\n\t\t\t\t\t\t\t\ttext="{dialogInfo>/previewUrl/value}"\n\t\t\t\t\t\t\t\twrapping="true"\n\t\t\t\t\t\t\t\tvisible="{= !!${dialogInfo>/previewUrl/value} }"\n\t\t\t\t\t\t\t\ttarget="_blank"\n\t\t\t\t\t\t\t/></content></Panel></layout:Grid><layout:Grid\n\t\t\t\t\t\tid="sapUiRtaAddIFrameDialog_PreviewGrid"\n\t\t\t\t\t\tclass="sapUiRtaAddIFrameDialogPreviewGrid"\n\t\t\t\t\t\tcontainerQuery="true"\n\t\t\t\t\t\tdefaultSpan="XL12 L12 M12 S12"><VBox\n\t\t\t\t\t\tid="sapUiRtaAddIFrameDialog_PreviewGridVB"\n\t\t\t\t\t\tclass="sapUiRtaAddIFrameDialogPreviewGridVB"\n\t\t\t\t\t\trenderType="Bare"><layoutData><FlexItemData growFactor="1"/></layoutData><items><Label\n\t\t\t\t\t\t\t\tid="sapUiRtaAddIFrameDialog_NoPreviewLabel"\n\t\t\t\t\t\t\t\tclass="sapUiRtaAddIFrameDialogNoPreviewLabel" wrapping="true"\n\t\t\t\t\t\t\t\ttext="{dialogInfo>/text/previewUrlMessage}" textAlign="Center" visible="{= !${dialogInfo>/previewUrl/value} }" /><util:IFrame\n\t\t\t\t\t\t\t\t\tid="sapUiRtaAddIFrameDialog_PreviewFrame"\n\t\t\t\t\t\t\t\t\theight="100%"\n\t\t\t\t\t\t\t\t\ttitle="{dialogInfo>/text/previewFrameLabel}"\n\t\t\t\t\t\t\t\t\tclass="sapUiRtaAddIFrameDialogPreviewFrame"\n\t\t\t\t\t\t\t\t\tadvancedSettings="{dialogInfo>/advancedSettings/value}"\n\t\t\t\t\t\t\t\t\tvisible="{= !!${dialogInfo>/previewUrl/value} }"/></items></VBox></layout:Grid><layout:Grid\n\t\t\t\t\tclass="sapUiRtaAddIFrameDialogPreviewLinkGrid"\n\t\t\t\t\tcontainerQuery="true"\n\t\t\t\t\tdefaultSpan="XL12 L12 M12 S12"><Panel\n\t\t\t\t\t\tid="sapUiRtaAddIFrameDialog_AdvancedSettingsPanel"\n\t\t\t\t\t\texpandable="true"\n\t\t\t\t\t\twidth="auto"\n\t\t\t\t\t\texpanded="false"\n\t\t\t\t\t\tclass="sapUiResponsiveMargin sapUiRtaAddIFrameDialogPreviewLinkPanel"><headerToolbar><OverflowToolbar\n\t\t\t\t\t\t\t\t\tid="sapUiRtaAddIFrameDialog_AdvancedSettingsToolbar"\n\t\t\t\t\t\t\t\t\tclass="sapUiRtaAddIFrameDialogPreviewLinkToolbar"\n\t\t\t\t\t\t\t\t\theight="3rem"\n\t\t\t\t\t\t\t\t\tstyle="Clear"><Title\n\t\t\t\t\t\t\t\t\tclass="sapUiRtaAddIFrameDialogPreviewLinkTitle"\n\t\t\t\t\t\t\t\t\ttext="{dialogInfo>/text/advancedSettingsTitle}" /><ToolbarSpacer /></OverflowToolbar></headerToolbar><content><MessageStrip\n\t\t\t\t\t\t\t\tid="sapUiRtaAddIFrameDialog_SecurityWarningMessage"\n\t\t\t\t\t\t\t\ttext="{dialogInfo>/text/additionalParametersSecurityWarningText}"\n\t\t\t\t\t\t\t\ttype="Warning"\n\t\t\t\t\t\t\t\tshowIcon="true"\n\t\t\t\t\t\t\t\tshowCloseButton="true"\n\t\t\t\t\t\t\t\tclass="sapUiSmallMarginBottom"><link><Link text="{dialogInfo>/text/additionalParametersWarningMoreInfoText}"\n\t\t\t\t\t\t\t\t\t\ttarget="_blank"\n\t\t\t\t\t\t\t\t\t\thref="https://developer.mozilla.org/en-US/docs/Web/HTML/Element/iframe#sandbox"/></link></MessageStrip><form:Form editable="true"><form:layout><form:ResponsiveGridLayout\n\t\t\t\t\t\t\t\t\t\tid="sapUiRtaAddIFrameDialog_SanboxPropertiesForm"\n\t\t\t\t\t\t\t\t\t\tadjustLabelSpan="false" singleContainerFullSize="false"\n\t\t\t\t\t\t\t\t\t\tlabelSpanXL="6" labelSpanL="6" labelSpanM="6" labelSpanS="12"\n\t\t\t\t\t\t\t\t\t\tcolumnsXL="2" columnsL="2" columnsM="2"/></form:layout><form:FormContainer><form:FormElement label="allow-forms"><Switch\n\t\t\t\t\t\t\t\t\t\t\t\t\tchange="onSwitchChange"\n\t\t\t\t\t\t\t\t\t\t\t\t\tid="sapUiRtaAddIFrameDialog_allowFormsSwitch"\n\t\t\t\t\t\t\t\t\t\t\t\t\tcustomTextOn=" "\n\t\t\t\t\t\t\t\t\t\t\t\t\tcustomTextOff=" "\n\t\t\t\t\t\t\t\t\t\t\t\t\tstate="{dialogInfo>/advancedSettings/value/allowForms}" /></form:FormElement><form:FormElement label="allow-scripts"><Switch\n\t\t\t\t\t\t\t\t\t\t\t\t\tchange="onSwitchChange"\n\t\t\t\t\t\t\t\t\t\t\t\t\tid="sapUiRtaAddIFrameDialog_allowScriptsSwitch"\n\t\t\t\t\t\t\t\t\t\t\t\t\tcustomTextOn=" "\n\t\t\t\t\t\t\t\t\t\t\t\t\tcustomTextOff=" "\n\t\t\t\t\t\t\t\t\t\t\t\t\tstate="{dialogInfo>/advancedSettings/value/allowScripts}" /></form:FormElement><form:FormElement label="allow-same-origin"><Switch\n\t\t\t\t\t\t\t\t\t\t\t\t\tchange="onSwitchChange"\n\t\t\t\t\t\t\t\t\t\t\t\t\tid="sapUiRtaAddIFrameDialog_allowSameOriginSwitch"\n\t\t\t\t\t\t\t\t\t\t\t\t\tcustomTextOn=" "\n\t\t\t\t\t\t\t\t\t\t\t\t\tcustomTextOff=" "\n\t\t\t\t\t\t\t\t\t\t\t\t\tstate="{dialogInfo>/advancedSettings/value/allowSameOrigin}" /></form:FormElement><form:FormElement label="allow-popups"><Switch\n\t\t\t\t\t\t\t\t\t\t\t\t\tchange="onSwitchChange"\n\t\t\t\t\t\t\t\t\t\t\t\t\tid="sapUiRtaAddIFrameDialog_allowPopupsSwitch"\n\t\t\t\t\t\t\t\t\t\t\t\t\tcustomTextOn=" "\n\t\t\t\t\t\t\t\t\t\t\t\t\tcustomTextOff=" "\n\t\t\t\t\t\t\t\t\t\t\t\t\tstate="{dialogInfo>/advancedSettings/value/allowPopups}" /></form:FormElement><form:FormElement label="allow-modals"><Switch\n\t\t\t\t\t\t\t\t\t\t\t\t\tchange="onSwitchChange"\n\t\t\t\t\t\t\t\t\t\t\t\t\tid="sapUiRtaAddIFrameDialog_allowModalsSwitch"\n\t\t\t\t\t\t\t\t\t\t\t\t\tcustomTextOn=" "\n\t\t\t\t\t\t\t\t\t\t\t\t\tcustomTextOff=" "\n\t\t\t\t\t\t\t\t\t\t\t\t\tstate="{dialogInfo>/advancedSettings/value/allowModals}" /></form:FormElement></form:FormContainer><form:FormContainer><form:FormElement label="allow-top-navigation"><Switch\n\t\t\t\t\t\t\t\t\t\t\t\t\tchange="onSwitchChange"\n\t\t\t\t\t\t\t\t\t\t\t\t\tid="sapUiRtaAddIFrameDialog_allowTopNavigationSwitch"\n\t\t\t\t\t\t\t\t\t\t\t\t\tcustomTextOn=" "\n\t\t\t\t\t\t\t\t\t\t\t\t\tcustomTextOff=" "\n\t\t\t\t\t\t\t\t\t\t\t\t\tstate="{dialogInfo>/advancedSettings/value/allowTopNavigation}" /></form:FormElement><form:FormElement label="allow-downloads"><Switch\n\t\t\t\t\t\t\t\t\t\t\t\t\tchange="onSwitchChange"\n\t\t\t\t\t\t\t\t\t\t\t\t\tid="sapUiRtaAddIFrameDialog_allowDownloadsSwitch"\n\t\t\t\t\t\t\t\t\t\t\t\t\tcustomTextOn=" "\n\t\t\t\t\t\t\t\t\t\t\t\t\tcustomTextOff=" "\n\t\t\t\t\t\t\t\t\t\t\t\t\tstate="{dialogInfo>/advancedSettings/value/allowDownloads}" /></form:FormElement><form:FormElement label="allow-downloads-without-user-activation"><Switch\n\t\t\t\t\t\t\t\t\t\t\t\t\tchange="onSwitchChange"\n\t\t\t\t\t\t\t\t\t\t\t\t\tid="sapUiRtaAddIFrameDialog_allowDownloadsWithoutUserActivationSwitch"\n\t\t\t\t\t\t\t\t\t\t\t\t\tcustomTextOn=" "\n\t\t\t\t\t\t\t\t\t\t\t\t\tcustomTextOff=" "\n\t\t\t\t\t\t\t\t\t\t\t\t\tstate="{dialogInfo>/advancedSettings/value/allowDownloadsWithoutUserActivation}" /></form:FormElement><form:FormElement><Label\n\t\t\t\t\t\t\t\t\t\t\t\t\tid="sapUiRtaAddIFrameDialog_AddAdditionalParametersLabel"\n\t\t\t\t\t\t\t\t\t\t\t\t\tclass="sapUiSmallMarginTop"\n\t\t\t\t\t\t\t\t\t\t\t\t\ttext="{dialogInfo>/text/additionalSandboxParametersLabel}"\n\t\t\t\t\t\t\t\t\t\t\t\t\tlabelFor="sapUiRtaAddIFrameDialog_AddAdditionalParametersInput" /></form:FormElement><form:FormElement><MultiInput\n\t\t\t\t\t\t\t\t\t\t\t\t\tid="sapUiRtaAddIFrameDialog_AddAdditionalParametersInput"\n\t\t\t\t\t\t\t\t\t\t\t\t\tplaceholder="{dialogInfo>/text/additionalSandboxParametersPlaceholder}"\n\t\t\t\t\t\t\t\t\t\t\t\t\tshowValueHelp="false"\n\t\t\t\t\t\t\t\t\t\t\t\t\ttokenUpdate="onTokenUpdate"\n\t\t\t\t\t\t\t\t\t\t\t\t\ttokens="{dialogInfo>/advancedSettings/value/additionalSandboxParameters}"\n\t\t\t\t\t\t\t\t\t\t\t\t\tariaLabelledBy="sapUiRtaAddIFrameDialog_AddAdditionalParametersLabel"><tokens><Token text="{dialogInfo>}" key="{dialogInfo>}"/></tokens></MultiInput></form:FormElement></form:FormContainer></form:Form></content></Panel></layout:Grid></layout:VerticalLayout><core:InvisibleText id="sapUiRtaAddIFrameDialog_WidthUnitLabel" text="{dialogInfo>/text/widthUnitLabel}"/><core:InvisibleText id="sapUiRtaAddIFrameDialog_HeightUnitLabel" text="{dialogInfo>/text/heightUnitLabel}"/><core:InvisibleText id="sapUiRtaAddIFrameDialog_ParameterSearchLabel" text="{dialogInfo>/text/parameterSearchLabel}"/></content><beginButton><Button\n\t\t\t\tid="sapUiRtaAddIFrameDialogSaveButton"\n\t\t\t\tclass="sapUiRtaAddIFrameDialogSaveButton"\n\t\t\t\ttype="Emphasized"\n\t\t\t\ttext="{dialogInfo>/text/saveText}"\n\t\t\t\tpress="onSavePress"\n\t\t\t\tenabled="{=!!${dialogInfo>/frameUrl/value} &amp;&amp; !${dialogInfo>/frameUrlError/value} &amp;&amp; ${dialogInfo>/areAllFieldsValid}}"\n\t\t\t/></beginButton><endButton><Button\n\t\t\t\tid="sapUiRtaAddIFrameDialogCancelButton"\n\t\t\t\tclass="sapUiRtaAddIFrameDialogCancelButton"\n\t\t\t\ttype="Transparent"\n\t\t\t\ttext="{dialogInfo>/text/cancelText}"\n\t\t\t\tpress="onCancelPress"\n\t\t\t/></endButton></Dialog></core:FragmentDefinition>\n',
	"sap/ui/rta/plugin/rename/RenameDialog.fragment.xml":'<core:FragmentDefinition\n\txmlns:core="sap.ui.core"\n\txmlns="sap.m"\n><Dialog\n\t\tid="sapUiRtaRenameDialog"\n\t\tresizable="false"\n\t\tdraggable="true"\n\t\tcontentWidth="50rem"\n\t\ttitle="{i18n>RENAME_DIALOG_TITLE}"\n\t\tclass="sapUiContentPadding"\n\t\tinitialFocus="sapUiRtaRenameDialog_input"\n\t\tescapeHandler=".onCancel"\n\t><content><HBox\n\t\t\t\talignItems="Center"\n\t\t\t\tjustifyContent="Start"\n\t\t\t\tfitContainer="true"\n\t\t\t><Label\n\t\t\t\t\ttext="{i18n>RENAME_DIALOG_LABEL}"\n\t\t\t\t\tlabelFor="sapUiRtaRenameDialog_input"\n\t\t\t\t\twrapping="true"\n\t\t\t\t><layoutData><FlexItemData maxWidth="10rem" /></layoutData></Label><Input\n\t\t\t\t\tid="sapUiRtaRenameDialog_input"\n\t\t\t\t\tvalue="{/newText}"\n\t\t\t\t\tplaceholder="{i18n>RENAME_DIALOG_PLACEHOLDER}"\n\t\t\t\t\tliveChange="onTextChange"\n\t\t\t\t\tvalueState="{= ${/validationError} === undefined ? \'None\' : \'Error\'}"\n\t\t\t\t\tvalueStateText="{/validationError}"\n\t\t\t\t\twidth="100%"\n\t\t\t\t><layoutData><FlexItemData growFactor="1" styleClass="sapUiTinyMarginBegin" /></layoutData></Input></HBox></content><beginButton><Button\n\t\t\t\tid="sapUiRtaRenameDialog_saveButton"\n\t\t\t\tenabled="{= ${/validationError} === undefined }"\n\t\t\t\ttype="Emphasized"\n\t\t\t\ttext="{i18n>RENAME_DIALOG_CONFIRM}"\n\t\t\t\tpress="onSave"\n\t\t\t/></beginButton><endButton><Button\n\t\t\t\tid="sapUiRtaRenameDialog_cancelButton"\n\t\t\t\ttype="Transparent"\n\t\t\t\ttext="{i18n>RENAME_DIALOG_CANCEL}"\n\t\t\t\tpress="onCancel"\n\t\t\t/></endButton></Dialog></core:FragmentDefinition>\n',
	"sap/ui/rta/toolbar/ActionsMenu.fragment.xml":'<core:FragmentDefinition\n\t\txmlns="sap.m"\n\t\txmlns:core="sap.ui.core"><Menu\n\t\t\tid="sapUiRta_actions"\n\t\t\tclass="sapUiRtaToolbarVisualizationSelection"><MenuItem\n\t\t\t\tid="sapUiRta_translateMenu"\n\t\t\t\ticon="sap-icon://translate"\n\t\t\t\tvisible="{= ${controls>/translation/visible}}"\n\t\t\t\tenabled="{controls>/translation/enabled}"\n\t\t\t\ttooltip="{i18n>BTN_TRANSLATE}"\n\t\t\t\ttext="{i18n>BTN_TRANSLATE}" ><items><MenuItem\n\t\t\t\t\t\ttext="{i18n>BTN_OPEN_DOWNLOAD_TRANSLATION}"\n\t\t\t\t\t\tpress=".openDownloadTranslationDialog"\n\t\t\t\t\t\ticon="sap-icon://download"/><MenuItem\n\t\t\t\t\t\ttext="{i18n>BTN_OPEN_UPLOAD_TRANSLATION}"\n\t\t\t\t\t\tpress=".openUploadTranslationDialog"\n\t\t\t\t\t\tenabled="{= ${translation>/sourceLanguages}.length > 0}"\n\t\t\t\t\t\ticon="sap-icon://upload"/></items></MenuItem><MenuItem\n\t\t\t\tid="sapUiRta_appVariantMenu"\n\t\t\t\ticon="sap-icon://BusinessSuiteInAppSymbols/icon-variant-configuration"\n\t\t\t\tenabled="{controls>/appVariantMenu/enabled}"\n\t\t\t\tvisible="{= (${controls>/appVariantMenu/visible} &amp;&amp; ${controls>/modeSwitcher} === \'adaptation\')}"\n\t\t\t\ttext="{i18n>BTN_MANAGE_APPS_TXT}" ><items><MenuItem\n\t\t\t\t\t\tid="sapUiRta_appVariantOverview"\n\t\t\t\t\t\ticon="sap-icon://action-settings"\n\t\t\t\t\t\tenabled="{controls>/appVariantMenu/overview/enabled}"\n\t\t\t\t\t\tvisible="{= (${controls>/appVariantMenu/overview/visible} &amp;&amp; ${controls>/modeSwitcher} === \'adaptation\')}"\n\t\t\t\t\t\ttext="{i18n>BTN_MANAGE_APPS_ITEM}" ><items><MenuItem\n\t\t\t\t\t\t\t\tid="sapUiRta_keyUser"\n\t\t\t\t\t\t\t\tpress=".overviewForKeyUser"\n\t\t\t\t\t\t\t\ticon="sap-icon://key-user-settings"\n\t\t\t\t\t\t\t\ttext="{i18n>MENU_ITEM_KEY_USER}" /><MenuItem\n\t\t\t\t\t\t\t\tid="sapUiRta_developer"\n\t\t\t\t\t\t\t\tpress=".overviewForDeveloper"\n\t\t\t\t\t\t\t\ticon="sap-icon://developer-settings"\n\t\t\t\t\t\t\t\ttext="{i18n>MENU_ITEM_SAP_DEVELOPER}" /></items></MenuItem><MenuItem\n\t\t\t\t\t\tid="sapUiRta_manageApps"\n\t\t\t\t\t\ticon="sap-icon://action-settings"\n\t\t\t\t\t\tpress=".manageApps"\n\t\t\t\t\t\tenabled="{controls>/appVariantMenu/manageApps/enabled}"\n\t\t\t\t\t\tvisible="{= (${controls>/appVariantMenu/manageApps/visible} &amp;&amp; ${controls>/modeSwitcher} === \'adaptation\')}"\n\t\t\t\t\t\ttext="{i18n>BTN_MANAGE_APPS_ITEM}" /><MenuItem\n\t\t\t\t\t\tid="sapUiRta_saveAs"\n\t\t\t\t\t\tvisible="{= (${controls>/appVariantMenu/saveAs/visible} &amp;&amp; ${controls>/modeSwitcher} === \'adaptation\')}"\n\t\t\t\t\t\tenabled="{parts: [\'controls>/appVariantMenu/saveAs/enabled\', \'versions>/displayedVersion\'], formatter: \'.formatSaveAsEnabled\'}"\n\t\t\t\t\t\tpress=".saveAs"\n\t\t\t\t\t\ticon="sap-icon://copy"\n\t\t\t\t\t\ttext="{i18n>BTN_SAVE_AS}" /></items></MenuItem><MenuItem\n\t\t\t\tid="sapUiRta_restore"\n\t\t\t\ticon="sap-icon://reset"\n\t\t\t\tenabled="{controls>/restore/enabled}"\n\t\t\t\tvisible="{= (${controls>/restore/visible} &amp;&amp; ((${controls>/modeSwitcher} === \'visualization\') || (${controls>/modeSwitcher} === \'adaptation\')))}"\n\t\t\t\tpress=".restore"\n\t\t\t\ttext="{i18n>BTN_RESTORE}" /><MenuItem\n\t\t\t\tid="sapUiRta_newFeaturesOverview"\n\t\t\t\ticon="sap-icon://newspaper"\n\t\t\t\tenabled="{controls>/newFeaturesOverview/enabled}"\n\t\t\t\tvisible="{controls>/newFeaturesOverview/visible}"\n\t\t\t\ttext="{i18n>BTN_WHATS_NEW_DIALOG_OVERVIEW}"\n\t\t\t\ttooltip="{i18n>BTN_WHATS_NEW_DIALOG_OVERVIEW_TOOLTIP}"\n\t\t\t\tpress=".openWhatsNewOverviewDialog"/><MenuItem\n\t\t\t\tid="sapUiRta_generalTour"\n\t\t\t\ticon="sap-icon://map-3"\n\t\t\t\ttext="{i18n>BTN_GUIDED_TOUR_START}"\n\t\t\t\tpress=".openGuidedTour"/></Menu></core:FragmentDefinition>',
	"sap/ui/rta/toolbar/Adaptation.fragment.xml":'<core:FragmentDefinition\n\t\txmlns="sap.m"\n\t\txmlns:core="sap.ui.core"\n\t\txmlns:toolbar="sap.ui.rta.toolbar"><HBox\n\t\t\tid="sapUiRta_toolbarIconAndDraftSection"\n\t\t\tclass="sapUiRtaToolbarIconAndDraftSection" ><OverflowToolbar\n\t\t\tid="sapUiRta_iconAndDraftToolbar"\n\t\t\tclass="sapUiRtaIconAndDraftToolbar"><content><HBox id="sapUiRta_iconBox" /><ToolbarSpacer\n\t\t\t\t\t\tid="sapUiRta_iconSpacer"\n\t\t\t\t\t\twidth="0%"\n\t\t\t\t\t\tvisible="true" /><Button\n\t\t\t\t\t\tid="sapUiRta_versionButton"\n\t\t\t\t\t\ttype="Transparent"\n\t\t\t\t\t\tclass="sapUiRtaVersionButton"\n\t\t\t\t\t\ticon="sap-icon://megamenu"\n\t\t\t\t\t\ticonFirst="false"\n\t\t\t\t\t\tvisible="{= (${versions>/versioningEnabled} &amp;&amp; ${controls>/modeSwitcher} === \'adaptation\' &amp;&amp; ${controls>/changesNeedHardReload} === false)}"\n\t\t\t\t\t\ttext="{parts: [{path: \'versions>/versions\'}, {path: \'versions>/displayedVersion\'}], formatter: \'.formatVersionButtonText\'}"\n\t\t\t\t\t\ttooltip="{i18n>TOL_SHOW_VERSION_HISTORY}"\n\t\t\t\t\t\tpress=".showVersionHistory"><layoutData><OverflowToolbarLayoutData priority="NeverOverflow"/></layoutData></Button><Button\n\t\t\t\t\tid="sapUiRta_hardReloadButton"\n\t\t\t\t\ttype="Attention"\n\t\t\t\t\tvisible="{= ${controls>/changesNeedHardReload} === true}"\n\t\t\t\t\ttext="{i18n>SAVE_AND_RELOAD}"\n\t\t\t\t\ticonFirst="true"\n\t\t\t\t\ticon="sap-icon://refresh"\n\t\t\t\t\tpress=".saveAndReloadApp"\n\t\t\t\t/><Button\n\t\t\t\t\tid="sapUiRta_hardReloadInfoButton"\n\t\t\t\t\ttype="Attention"\n\t\t\t\t\tvisible="{= ${controls>/changesNeedHardReload} === true}"\n\t\t\t\t\tpress=".showHardReloadInfoPopover"\n\t\t\t\t\ticon="sap-icon://question-mark"\n\t\t\t\t\tclass="sapUiNoMarginBeginEnd sapUiRtaHardReloadInfoButton"\n\t\t\t\t\ttooltip="{i18n>TOL_SHOW_HARD_RELOAD_INFO}"\n\t\t\t\t/><toolbar:OverflowToolbarButton\n\t\t\t\t\t\tid="sapUiRta_activate"\n\t\t\t\t\t\ticon="sap-icon://activate"\n\t\t\t\t\t\tpress=".activate(${versions>/displayedVersion})"\n\t\t\t\t\t\tvisible="{= (${versions>/versioningEnabled} &amp;&amp; ${controls>/modeSwitcher} === \'adaptation\')}"\n\t\t\t\t\t\tenabled="{versions>/activateEnabled}"\n\t\t\t\t\t\ttype="Transparent"\n\t\t\t\t\t\ttext="{i18n>TOL_ACTIVATE}"\n\t\t\t\t\t\ttooltip="{i18n>TOL_ACTIVATE}" /><toolbar:OverflowToolbarButton\n\t\t\t\t\t\tid="sapUiRta_discardDraft"\n\t\t\t\t\t\ticon="sap-icon://delete"\n\t\t\t\t\t\tpress=".discardDraft"\n\t\t\t\t\t\tvisible="{parts: [\'versions>/displayedVersion\', \'versions>/versioningEnabled\', \'controls>/modeSwitcher\' ], formatter: \'.formatDiscardDraftVisible\'}"\n\t\t\t\t\t\ttype="Transparent"\n\t\t\t\t\t\ttext="{i18n>TOL_DISCARD_DRAFT}"\n\t\t\t\t\t\ttooltip="{i18n>TOL_DISCARD_DRAFT}" /><toolbar:OverflowToolbarButton\n\t\t\t\t\t\tid="sapUiRta_publishVersion"\n\t\t\t\t\t\tenabled="{versions>/publishVersionEnabled}"\n\t\t\t\t\t\tvisible="{parts: [\'versions>/publishVersionVisible\', \'versions>/versioningEnabled\', \'versions>/displayedVersion\', \'controls>/modeSwitcher\'], formatter: \'.formatPublishVersionVisibility\'}"\n\t\t\t\t\t\tpress=".publishVersion"\n\t\t\t\t\t\ttype="Transparent"\n\t\t\t\t\t\ticon="sap-icon://shipping-status"\n\t\t\t\t\t\ttooltip="{i18n>TOL_PUBLISH_VERSION}" /></content></OverflowToolbar></HBox><HBox\n\t\t\tid="sapUiRta_toolbarSwitcherSection"\n\t\t\tclass="sapUiRtaToolbarSwitcherSection" ><Toolbar><content><SegmentedButton\n\t\t\t\t\t\tid="sapUiRta_modeSwitcher"\n\t\t\t\t\t\tselectionChange=".modeChange"\n\t\t\t\t\t\tselectedKey="{controls>/modeSwitcher}"\n\t\t\t\t\t\twidth="100%" ><items><SegmentedButtonItem\n\t\t\t\t\t\t\t\tid="sapUiRta_adaptationSwitcherButton"\n\t\t\t\t\t\t\t\ttext="{i18n>BTN_ADAPTATION}"\n\t\t\t\t\t\t\t\twidth="auto"\n\t\t\t\t\t\t\t\tkey="adaptation" /><SegmentedButtonItem\n\t\t\t\t\t\t\t\tid="sapUiRta_navigationSwitcherButton"\n\t\t\t\t\t\t\t\ttext="{i18n>BTN_NAVIGATION}"\n\t\t\t\t\t\t\t\twidth="auto"\n\t\t\t\t\t\t\t\tkey="navigation" /><SegmentedButtonItem\n\t\t\t\t\t\t\t\tid="sapUiRta_visualizationSwitcherButton"\n\t\t\t\t\t\t\t\tvisible="{controls>/visualizationButton/visible}"\n\t\t\t\t\t\t\t\ttext="{i18n>BTN_VISUALIZATION}"\n\t\t\t\t\t\t\t\twidth="auto"\n\t\t\t\t\t\t\t\tkey="visualization" /></items></SegmentedButton></content></Toolbar></HBox><HBox\n\t\t\tid="sapUiRta_toolbarActionsSection"\n\t\t\tclass="sapUiRtaToolbarActionsSection"\n\t\t\tjustifyContent="End" ><OverflowToolbar\n\t\t\t\tid="sapUiRta_actionsToolbar"\n\t\t\t\tclass="sapUiRtaActionsToolbar"><content><ToolbarSpacer /><Button\n\t\t\t\t\t\tid="sapUiRta_toggleChangeVisualizationMenuButton"\n\t\t\t\t\t\tvisible="{= ${controls>/modeSwitcher} === \'visualization\'}"\n\t\t\t\t\t\ttext="{visualizationModel>/changeCategoryText}"\n\t\t\t\t\t\ttype="Transparent"\n\t\t\t\t\t\ticon="sap-icon://slim-arrow-down"\n\t\t\t\t\t\ticonFirst="false"\n\t\t\t\t\t\tpress=".openChangeCategorySelectionPopover"\n\t\t\t\t\t\ttooltip="{i18n>BUT_CHANGEVISUALIZATION_SELECTCHANGES}"/><Button\n\t\t\t\t\t\tid="sapUiRta_actionsMenu"\n\t\t\t\t\t\ticon="sap-icon://menu2"\n\t\t\t\t\t\tvisible="{=\n\t\t\t\t\t\t\t\t${controls>/modeSwitcher} === \'adaptation\'\n\t\t\t\t\t\t}"\n\t\t\t\t\t\tenabled="{controls>/actionsMenuButton/enabled}"\n\t\t\t\t\t\ttype="Transparent"\n\t\t\t\t\t\ttooltip="{i18n>BTN_MENU}"\n\t\t\t\t\t\tpress=".showActionsMenu"\n\t\t\t\t\t\tariaHasPopup="Menu" ><layoutData><OverflowToolbarLayoutData priority="NeverOverflow" /></layoutData></Button><Button\n\t\t\t\t\t\tid="sapUiRta_undo"\n\t\t\t\t\t\ticon="sap-icon://undo"\n\t\t\t\t\t\tpress=".undo"\n\t\t\t\t\t\tenabled="{controls>/undo/enabled}"\n\t\t\t\t\t\tvisible="{= ${controls>/modeSwitcher} === \'adaptation\'}"\n\t\t\t\t\t\ttype="Transparent"\n\t\t\t\t\t\ttooltip="{i18n>BTN_UNDO}" ><layoutData><OverflowToolbarLayoutData priority="NeverOverflow" /></layoutData></Button><Button\n\t\t\t\t\t\tid="sapUiRta_redo"\n\t\t\t\t\t\ticon="sap-icon://redo"\n\t\t\t\t\t\tpress=".redo"\n\t\t\t\t\t\tenabled="{controls>/redo/enabled}"\n\t\t\t\t\t\tvisible="{= ${controls>/modeSwitcher} === \'adaptation\'}"\n\t\t\t\t\t\ttype="Transparent"\n\t\t\t\t\t\ttooltip="{i18n>BTN_REDO}" ><layoutData><OverflowToolbarLayoutData priority="NeverOverflow" /></layoutData></Button><MenuButton\n\t\t\t\t\t\tid="sapUiRta_contextBasedAdaptationMenu"\n\t\t\t\t\t\ttooltip="{parts: [{path: \'contextBasedAdaptations>/count\'}, {path: \'contextBasedAdaptations>/displayedAdaptation/title\'}], formatter: \'.formatAdaptationsMenuText\'}"\n\t\t\t\t\t\ttext="{parts: [{path: \'contextBasedAdaptations>/count\'}, {path: \'contextBasedAdaptations>/displayedAdaptation/title\'}], formatter: \'.formatAdaptationsMenuText\'}"\n\t\t\t\t\t\tvisible="{= (${controls>/contextBasedAdaptation/visible} &amp;&amp; ${controls>/modeSwitcher} === \'adaptation\')}"><Menu><MenuItem\n\t\t\t\t\t\t\t\tid="sapUiRta_saveAsAdaptation"\n\t\t\t\t\t\t\t\ttext="{i18n>SAC_DIALOG_HEADER}"\n\t\t\t\t\t\t\t\tpress=".saveAsAdaptation"\n\t\t\t\t\t\t\t\ticon="sap-icon://copy"/><MenuItem\n\t\t\t\t\t\t\t\tid="sapUiRta_editAdaptation"\n\t\t\t\t\t\t\t\tvisible="{= (${contextBasedAdaptations>/count} > 0 &amp;&amp; ${contextBasedAdaptations>/displayedAdaptation/title} !== \'\')}"\n\t\t\t\t\t\t\t\ttext="{i18n>EAC_DIALOG_HEADER}"\n\t\t\t\t\t\t\t\tpress=".editAdaptation"\n\t\t\t\t\t\t\t\ticon="sap-icon://edit"/><MenuItem\n\t\t\t\t\t\t\t\tid="sapUiRta_deleteAdaptation"\n\t\t\t\t\t\t\t\ttext="{i18n>DAC_DIALOG_HEADER}"\n\t\t\t\t\t\t\t\tpress=".deleteAdaptation"\n\t\t\t\t\t\t\t\tvisible="{= (${contextBasedAdaptations>/count} > 0 &amp;&amp; ${contextBasedAdaptations>/displayedAdaptation/title} !== \'\')}"\n\t\t\t\t\t\t\t\ticon="sap-icon://delete"/><MenuItem\n\t\t\t\t\t\t\t\tid="sapUiRta_manageAdaptations"\n\t\t\t\t\t\t\t\ttext="{i18n>MANAGE_ADAPTATIONS_DIALOG_HEADER}"\n\t\t\t\t\t\t\t\tpress=".manageAdaptations"\n\t\t\t\t\t\t\t\ticon="sap-icon://action-settings"/><MenuItem\n\t\t\t\t\t\t\t\tid="sapUiRta_switchAdaptations"\n\t\t\t\t\t\t\t\tvisible="{= (${contextBasedAdaptations>/count} > 0)}"\n\t\t\t\t\t\t\t\ttext="{i18n>BTN_SWITCH_ADAPTATIONS}"\n\t\t\t\t\t\t\t\ticon="sap-icon://switch-views"\n\t\t\t\t\t\t\t\titems="{contextBasedAdaptations>/allAdaptations}"><items><MenuItem\n\t\t\t\t\t\t\t\t\tid="sapUiRta_switchAdaptations_items"\n\t\t\t\t\t\t\t\t\tenabled="{= (${contextBasedAdaptations>id} !== ${contextBasedAdaptations>/displayedAdaptation/id}) }"\n\t\t\t\t\t\t\t\t\ticon="{= (${contextBasedAdaptations>id} === ${contextBasedAdaptations>/displayedAdaptation/id} ? \'sap-icon://accept\' : \'blank\')}"\n\t\t\t\t\t\t\t\t\ttext="{= (${contextBasedAdaptations>title} ? ${contextBasedAdaptations>title} : ${i18n>TXT_DEFAULT_APP})}"\n\t\t\t\t\t\t\t\t\tpress=".switchAdaptation(${contextBasedAdaptations>id})"/></items></MenuItem></Menu><layoutData><OverflowToolbarLayoutData priority="NeverOverflow" /></layoutData></MenuButton><Button\n\t\t\t\t\t\tid="sapUiRta_feedback"\n\t\t\t\t\t\ticon="sap-icon://feedback"\n\t\t\t\t\t\tpress=".showFeedbackForm"\n\t\t\t\t\t\tvisible="{controls>/feedbackButton/visible}"\n\t\t\t\t\t\ttype="Transparent"\n\t\t\t\t\t\ttooltip="{i18n>BTN_FEEDBACK}" ><layoutData><OverflowToolbarLayoutData priority="NeverOverflow" /></layoutData></Button><toolbar:OverflowToolbarButton\n\t\t\t\t\t\tid="sapUiRta_save"\n\t\t\t\t\t\ttype="Transparent"\n\t\t\t\t\t\tpress=".save"\n\t\t\t\t\t\tenabled="{controls>/save/enabled}"\n\t\t\t\t\t\ttooltip="{= ${versions>/versioningEnabled} ? ${i18n>BTN_SAVE_DRAFT} : ${i18n>BTN_SAVE} }"\n\t\t\t\t\t\ticon="sap-icon://save" ><toolbar:layoutData><OverflowToolbarLayoutData priority="High" /></toolbar:layoutData></toolbar:OverflowToolbarButton><toolbar:OverflowToolbarButton\n\t\t\t\t\t\tid="sapUiRta_exit"\n\t\t\t\t\t\ttype="Transparent"\n\t\t\t\t\t\tpress=".exit"\n\t\t\t\t\t\ttooltip="{i18n>BTN_EXIT}"\n\t\t\t\t\t\ticon="sap-icon://decline" ><toolbar:layoutData><OverflowToolbarLayoutData priority="High" /></toolbar:layoutData></toolbar:OverflowToolbarButton></content></OverflowToolbar><layoutData><FlexItemData growFactor="0" /></layoutData></HBox></core:FragmentDefinition>',
	"sap/ui/rta/toolbar/FeedbackDialog.fragment.xml":'<core:FragmentDefinition\n\txmlns:core="sap.ui.core"\n\txmlns="sap.m"\n\txmlns:util="sap.ui.fl.util"><Dialog\n\t\tid="sapUiRtaFeedbackIFrameDialog"\n\t\ttitle="{i18n>TIT_FEEDBACK}"\n\t\tcontentWidth="50rem"\n\t\tcontentHeight="50rem"\n\t\tdraggable="true"><content><util:IFrame\n\t\t\t\tid="sapUiRtaFeedbackIFrameDialog_iFrame"\n\t\t\t\turl="{feedbackModel>/url}"\n\t\t\t\theight="46rem"/></content><buttons><Button\n\t\t\t\tid="sapUiRtaFeedbackIFrameDialog_ButtonClose"\n\t\t\t\ttext="{i18n>BTN_CLOSE_FEEDBACK_DIALOG}"\n\t\t\t\tpress=".closeFeedbackForm"/></buttons></Dialog></core:FragmentDefinition>',
	"sap/ui/rta/toolbar/contextBased/ManageAdaptationsDialog.fragment.xml":'<core:FragmentDefinition\n\txmlns:core="sap.ui.core"\n\txmlns:dnd="sap.ui.core.dnd"\n\txmlns="sap.m"><Dialog\n\t\tresizable="true"\n\t\tdraggable="true"\n\t\tcontentWidth="830px"\n\t\tcontentHeight="450px"\n\t\thorizontalScrolling="false"\n\t\ttitle="{i18n>MANAGE_ADAPTATIONS_DIALOG_HEADER}"><Table id="manageAdaptationsTable"\n\t\t\tshowNoData="false"\n\t\t\tinset="false"\n\t\t\tsticky="HeaderToolbar"\n\t\t\tmode="SingleSelectMaster"\n\t\t\titems="{\n\t\t\tpath: \'contextBased>/adaptations\',\n\t\t\tsorter: {path: \'rank\', descending: false}\n\t\t}"><headerToolbar><OverflowToolbar><SearchField id="searchField" liveChange=".onLiveSearch" width="80%" /><ToolbarSpacer/><Button id="moveUpButton"\n\t\t\t\t\t\ticon="sap-icon://navigation-up-arrow"\n\t\t\t\t\t\ttooltip="{i18n>BTN_TOOLTIP_MOVE_UP}"\n\t\t\t\t\t\tpress=".moveUp"\n\t\t\t\t\t\tenabled="false"/><Button id="moveDownButton"\n\t\t\t\t\t\ticon="sap-icon://navigation-down-arrow"\n\t\t\t\t\t\ttooltip="{i18n>BTN_TOOLTIP_MOVE_DOWN}"\n\t\t\t\t\t\tpress=".moveDown"\n\t\t\t\t\t\tenabled="false"/></OverflowToolbar></headerToolbar><columns><Column width="5rem"\n\t\t\t\t\tminScreenWidth="tablet"\n\t\t\t\t\tdemandPopin="true"\n\t\t\t\t\tpopinDisplay="Inline"\n\t\t\t\t\thAlign="Left"><Text text="{i18n>CLM_HEADER_PRIORITY}" /></Column><Column minScreenWidth="tablet"\n\t\t\t\t\tdemandPopin="true"\n\t\t\t\t\tpopinDisplay="Inline"\n\t\t\t\t\thAlign="Left"><Text text="{i18n>CLM_HEADER_ADAPTATIONS_TITLE}" /></Column><Column width="6rem"\n\t\t\t\t\tminScreenWidth="tablet"\n\t\t\t\t\tdemandPopin="true"\n\t\t\t\t\tpopinDisplay="Inline"\n\t\t\t\t\thAlign="Left"><Text text="{i18n>CLM_HEADER_CONTEXT}" /></Column><Column minScreenWidth="tablet"\n\t\t\t\t\tdemandPopin="true"\n\t\t\t\t\tpopinDisplay="Inline"\n\t\t\t\t\thAlign="Left"><Text text="{i18n>CLM_HEADER_ADAPTATIONS_CREATED_ON}" /></Column><Column minScreenWidth="tablet"\n\t\t\t\t\tdemandPopin="true"\n\t\t\t\t\tpopinDisplay="Inline"\n\t\t\t\t\thAlign="Left"><Text text="{i18n>CLM_HEADER_ADAPTATIONS_CHANGED_ON}" /></Column></columns><dragDropConfig><dnd:DragDropInfo sourceAggregation="items"\n\t\t\t\t\ttargetAggregation="items"\n\t\t\t\t\tdropPosition="Between"\n\t\t\t\t\tdrop=".onDropSelectedAdaptation"/></dragDropConfig><items><ColumnListItem><cells><Text text="{contextBased>rank}"/><Text wrapping="false" maxLines="1" text="{contextBased>title}"\n\t\t\t\t\t\t\t\t\ttooltip="{contextBased>title}"/><Text text="{ parts: [\'contextBased>contexts/role\'], formatter: \'.formatContextColumnCell\'}"\n\t\t\t\t\t\t\ttooltip="{ parts: [\'contextBased>contexts/role\'], formatter: \'.formatContextColumnTooltip\'}" /><Text text="{ parts: [\'contextBased>createdBy\', \'contextBased>createdAt\'], formatter: \'.formatCreatedChangedOnColumnCell\'}"/><Text text="{ parts: [\'contextBased>changedBy\', \'contextBased>changedAt\'], formatter: \'.formatCreatedChangedOnColumnCell\'}"/></cells></ColumnListItem></items></Table><Table id="defaultContext"><columns><Column width="4.195rem"\n\t\t\t\t\tminScreenWidth="tablet"\n\t\t\t\t\tdemandPopin="true"\n\t\t\t\t\tpopinDisplay="Inline"\n\t\t\t\t\thAlign="Left"></Column><Column minScreenWidth="tablet"\n\t\t\t\t\tdemandPopin="true"\n\t\t\t\t\tpopinDisplay="Inline"\n\t\t\t\t\thAlign="Left"></Column><Column width="8rem"\n\t\t\t\t\tminScreenWidth="tablet"\n\t\t\t\t\tdemandPopin="true"\n\t\t\t\t\tpopinDisplay="Inline"\n\t\t\t\t\thAlign="Left"></Column></columns><items><ColumnListItem highlight="Information"><cells><Text text=""/><CustomListItem><HBox><VBox class="sapUiSmallMarginTopBottom"><Text id="defaultApplicationTitle" text="{i18n>TXT_DEFAULT_APP}"/><FormattedText htmlText=""/></VBox></HBox></CustomListItem><Text text="" /></cells></ColumnListItem></items></Table><beginButton><Button id="manageAdaptations-saveButton"\n\t\t\t\tenabled="false"\n\t\t\t\ttype="Emphasized"\n\t\t\t\ttext="{i18n>APP_CTX_DIALOG_SAVE}"\n\t\t\t\ttooltip="{i18n>TOOLTIP_APP_CTX_DIALOG_SAVE}"\n\t\t\t\tpress=".onSaveReorderedAdaptations"/></beginButton><endButton><Button id="manageAdaptations-closeButton"\n\t\t\t\ttext="{i18n>APP_CTX_DIALOG_CANCEL}"\n\t\t\t\tpress=".onCancel"/></endButton></Dialog></core:FragmentDefinition>',
	"sap/ui/rta/toolbar/contextBased/SaveAsAdaptationDialog.fragment.xml":'<core:FragmentDefinition\n\txmlns:form="sap.ui.layout.form"\n\txmlns="sap.m"\n\txmlns:core="sap.ui.core"><Dialog id="selectContextsDialog"\n\t\tresizable="true"\n\t\tdraggable="true"\n\t\ttitle="{dialogModel>/title}"><Panel id="saveAdaptation-information-panel"><headerToolbar><Toolbar id="toolbar"><Label id="label"\n\t\t\t\t\t\ttext="Information"\n\t\t\t\t\t\tdesign="Bold"></Label></Toolbar></headerToolbar><form:Form id="saveAdaptation-form"\n\t\t\t\teditable="true"><form:layout><form:ResponsiveGridLayout labelSpanXL="3"\n\t\t\t\t\t\tlabelSpanL="3"\n\t\t\t\t\t\tlabelSpanM="3"\n\t\t\t\t\t\tlabelSpanS="12"\n\t\t\t\t\t\tadjustLabelSpan="false"\n\t\t\t\t\t\temptySpanXL="4"\n\t\t\t\t\t\temptySpanL="4"\n\t\t\t\t\t\temptySpanM="4"\n\t\t\t\t\t\temptySpanS="0"\n\t\t\t\t\t\tcolumnsXL="1"\n\t\t\t\t\t\tcolumnsL="1"\n\t\t\t\t\t\tcolumnsM="1"\n\t\t\t\t\t\tsingleContainerFullSize="false"/></form:layout><form:FormContainer><form:formElements><form:FormElement ><form:label><Label id="saveAdaptation-title-label"\n\t\t\t\t\t\t\t\t\ttext="{i18n>APP_DIALOG_TITLE_TEXT}"\n\t\t\t\t\t\t\t\t\trequired="true"></Label></form:label><Input id="saveAdaptation-title-input"\n\t\t\t\t\t\t\t\tvalue="{/title}"\n\t\t\t\t\t\t\t\tvalueLiveUpdate="true"\n\t\t\t\t\t\t\t\tliveChange=".onAdaptationTitleChange"\n\t\t\t\t\t\t\t\tplaceholder="{i18n>SAVE_AS_DIALOG_PLACEHOLDER_TITLE_TEXT}"></Input></form:FormElement><form:FormElement ><form:label><Label id="saveAdaptation-rank-label"\n\t\t\t\t\t\t\t\t\ttext="{i18n>CLM_HEADER_PRIORITY}"\n\t\t\t\t\t\t\t\t\trequired="true"></Label></form:label><Select\n\t\t\t\t\t\t\t\t\tid="saveAdaptation-rank-select"\n\t\t\t\t\t\t\t\t\tforceSelection="true"\n\t\t\t\t\t\t\t\t\tselectedKey="{dialogModel>/selected}"\n\t\t\t\t\t\t\t\t\titems="{dialogModel>/priority}"\n\t\t\t\t\t\t\t\t\tchange=".onPriorityChange"><core:Item key="{dialogModel>key}" text="{dialogModel>title}" /></Select></form:FormElement></form:formElements></form:FormContainer></form:Form></Panel><beginButton><Button id="saveAdaptation-saveButton"\n\t\t\t\ttype="Emphasized"\n\t\t\t\ttext="{i18n>APP_CTX_DIALOG_SAVE}"\n\t\t\t\tpress=".onSaveAsAdaptation"/></beginButton><endButton><Button id="saveAdaptation-cancelButton"\n\t\t\t\ttext="{i18n>APP_CTX_DIALOG_CANCEL}"\n\t\t\t\tpress=".onCancelAdaptationDialog"/></endButton></Dialog></core:FragmentDefinition>',
	"sap/ui/rta/toolbar/translation/DownloadTranslationDialog.fragment.xml":'<core:FragmentDefinition\n\t\txmlns="sap.m"\n\t\txmlns:core="sap.ui.core" ><Dialog\n\t\ttitle="{i18n>TIT_DOWNLOAD_CHANGED_TEXTS}"\n\t\ttype="Message"\n\t\tcontentWidth="33%"><Label\n\t\t\tlabelFor="languageSelection"\n\t\t\twrappingType="Hyphenated"\n\t\t\twrapping="true"\n\t\t\twidth="auto"\n\t\t\ttext="{i18n>MSG_DOWNLOAD_CHANGED_TEXTS}"\n\t\t\tclass="sapUiTinyMarginBottom"></Label><MessageStrip\n\t\t\tid="dirtyChangesExistsMessage"\n\t\t\ttext="{i18n>MSG_DOWNLOAD_CHANGED_TEXTS_DIRTY_CHANGES_EXIST}"\n\t\t\tclass="sapUiTinyMarginBottom"\n\t\t\tvisible="{translation>/translationRelevantDirtyChangesExist}"></MessageStrip><Select\n\t\t\twidth="100%"\n\t\t\tid="selectedSourceLanguage"\n\t\t\titems="{translation>/sourceLanguages}"\n\t\t\tselectedKey="{translation>/sourceLanguage}"><core:Item key="{translation>}" text="{translation>}"/></Select><Input\n\t\t\twidth="100%"\n\t\t\tid="selectedTargetLanguage"\n\t\t\tvalue="{translation>/targetLanguage}"\n\t\t\tplaceholder="{i18n>TXT_TARGET_LANGUAGE}"></Input><beginButton><Button\n\t\t\t\tid="downloadTranslation"\n\t\t\t\ttext="{i18n>BTN_DOWNLOAD_CHANGED_TEXTS}"\n\t\t\t\ttype="Emphasized"\n\t\t\t\ticon="sap-icon://download"\n\t\t\t\tenabled="{= !!${translation>/sourceLanguages}.length}"\n\t\t\t\tpress=".onDownloadFile" /></beginButton><endButton><Button\n\t\t\t\tid="cancelDownloadTranslation"\n\t\t\t\ttext="{i18n>BUT_DOWNLOAD_CHANGED_TEXTS_CANCEL}"\n\t\t\t\tpress=".onCancelDownloadDialog" /></endButton></Dialog></core:FragmentDefinition>',
	"sap/ui/rta/toolbar/translation/TranslationPopover.fragment.xml":'<core:FragmentDefinition\n\t\txmlns="sap.m"\n\t\txmlns:core="sap.ui.core" ><Popover\n\t\t\tplacement="Bottom"\n\t\t\tshowHeader="false"><List><ActionListItem text="{i18n>BTN_OPEN_DOWNLOAD_TRANSLATION}"\n\t\t\t\t\tpress=".openDownloadTranslationDialog"/><ActionListItem text="{i18n>BTN_OPEN_UPLOAD_TRANSLATION}"\n\t\t\t\t\tpress=".openUploadTranslationDialog"/></List></Popover></core:FragmentDefinition>\n',
	"sap/ui/rta/toolbar/translation/UploadTranslationDialog.fragment.xml":'<core:FragmentDefinition\n\t\txmlns="sap.m"\n\t\txmlns:core="sap.ui.core"\n\t\txmlns:u="sap.ui.unified"><Dialog\n\t\ttitle="{i18n>TIT_UPLOAD_CHANGED_TEXTS}"\n\t\ttype="Message"><Label\n\t\t\tlabelFor="fileUploader"\n\t\t\twrappingType="Hyphenated"\n\t\t\twrapping="true"\n\t\t\twidth="auto"\n\t\t\ttext="{i18n>MSG_UPLOAD_CHANGED_TEXTS}"\n\t\t\tclass="sapUiTinyMarginBottom"></Label><u:FileUploader\n\t\t\tid="fileUploader"\n\t\t\tsameFilenameAllowed="true"\n\t\t\tfileType="xml"\n\t\t\twidth="100%"\n\t\t\tvalue="{translation>/filePath}"\n\t\t\ticon="sap-icon://upload"\n\t\t\tchange=".saveFiles"><u:xhrSettings><u:FileUploaderXHRSettings withCredentials = "true"/></u:xhrSettings></u:FileUploader><beginButton><Button\n\t\t\t\tid="uploadTranslation"\n\t\t\t\ttext="{i18n>BTN_UPLOAD_CHANGED_TEXTS}"\n\t\t\t\tenabled="{= !!${translation>/filePath}}"\n\t\t\t\ttype="Emphasized"\n\t\t\t\tpress=".handleUploadPress" /></beginButton><endButton><Button\n\t\t\t\tid="cancelTranslationUpload"\n\t\t\t\ttext="{i18n>BUT_UPLOAD_CHANGED_TEXTS_CANCEL}"\n\t\t\t\tpress=".onCancelUploadDialog" /></endButton></Dialog></core:FragmentDefinition>',
	"sap/ui/rta/toolbar/versioning/VersionHistory.fragment.xml":'<core:FragmentDefinition\n        xmlns="sap.m"\n        xmlns:core="sap.ui.core" ><Popover\n            id="popover"\n            class="sapUiRtaVersionHistory"\n            showHeader="false"\n            placement="Bottom" ><List\n                id="versionList"\n                class="sapUiRtaVersionsList"\n                visible="{= ${versions>/versions/length} > 0}"\n                items="{path: \'versions>/versions\', groupHeaderFactory: \'.getGroupHeaderFactory\'}" ><FeedListItem\n                text="{parts: [{path: \'versions>title\'}, {path: \'versions>type\'}], formatter: \'.formatVersionTitle\'}"\n                info="{versions>activatedBy}"\n                timestamp="{parts: [\'versions>activatedAt\', \'versions>importedAt\'], formatter: \'.formatVersionTimeStamp\'}"\n                type="Active"\n                press=".versionSelected"\n                highlight="{path: \'versions>type\', formatter: \'.formatHighlight\'}"\n                highlightText="{path: \'versions>type\', formatter: \'.formatHighlightText\'}"\n                showIcon="false" /></List><List id="originalVersionList"><FeedListItem\n                text="{i18n>TIT_ORIGINAL_APP}"\n                type="Active"\n                press=".versionSelected"\n                highlight="{path: \'versions>/versions\', formatter: \'.formatOriginalAppHighlight\'}"\n                highlightText="{path: \'versions>/versions\', formatter: \'.formatOriginalAppHighlightText\'}"\n                showIcon="false" /></List></Popover></core:FragmentDefinition>',
	"sap/ui/rta/toolbar/versioning/VersionTitleDialog.fragment.xml":'<core:FragmentDefinition\n        xmlns="sap.m"\n        xmlns:core="sap.ui.core" ><Dialog\n            id="dialog"\n            title="{i18n>TIT_VERSION_TITLE_DIALOG}"\n            type="Message" ><content><Input\n                    id="versionTitleInput"\n                    type="Text"\n                    maxLength="200"\n                    liveChange=".onVersionTitleLiveChange"\n                    submit=".onConfirmVersioningDialog"\n                    placeholder="{i18n>TXT_VERSION_TITLE_INPUT_PLACEHOLDER}" /></content><beginButton><Button\n                id="confirmVersionTitleButton"\n                text="{i18n>BUT_VERSION_TITLE_DIALOG_CONFIRM}"\n                type="Emphasized"\n                enabled="false"\n                press=".onConfirmVersioningDialog" /></beginButton><endButton><Button\n                text="{i18n>BUT_VERSION_TITLE_DIALOG_CANCEL}"\n                press=".onCancelVersioningDialog" /></endButton></Dialog></core:FragmentDefinition>',
	"sap/ui/rta/util/changeVisualization/ChangeIndicatorCategorySelection.fragment.xml":'<core:FragmentDefinition\n\txmlns:core="sap.ui.core"\n\txmlns="sap.m"\n\txmlns:l="sap.ui.layout"><Popover\n\t\tshowHeader="false"\n\t\tplacement="Bottom"\n\t\tid="popover"><SegmentedButton selectedKey="{visualizationModel>/changeState}" width="420px" selectionChange=".onVersioningCategoryChange"><items><SegmentedButtonItem\n\t\t\t\t\ttext="{i18n>BUT_CHANGEVISUALIZATION_VERSIONING_ALL}"\n\t\t\t\t\tkey="all"/><SegmentedButtonItem\n\t\t\t\t\ttext="{i18n>BUT_CHANGEVISUALIZATION_VERSIONING_DRAFT}"\n\t\t\t\t\tkey="draft"\n\t\t\t\t\tvisible="{visualizationModel>/versioningAvailable}"\n\t\t\t\t\tenabled="{= ${visualizationModel>/hasDraftChanges} ||  ${visualizationModel>/hasDirtyChanges}}"/><SegmentedButtonItem\n\t\t\t\t\ttext="{i18n>BUT_CHANGEVISUALIZATION_VERSIONING_DIRTY}"\n\t\t\t\t\tkey="dirty"\n\t\t\t\t\tenabled="{visualizationModel>/hasDirtyChanges}"/></items></SegmentedButton><List\n\t\t\tclass="sapUiRtaChangesList"\n\t\t\titems="{visualizationModel>/changeCategories/}"><StandardListItem\n\t\t\t\ttitle="{visualizationModel>title}"\n\t\t\t\tcounter="{visualizationModel>count}"\n\t\t\t\ttype="{= ${visualizationModel>count} > 0 ? \'Active\' : \'Inactive\'}"\n\t\t\t\ticon="{visualizationModel>icon}"\n\t\t\t\tpress=".onChangeCategorySelection"/></List><MessageStrip\n\t\t\ttext="{visualizationModel>/popupInfoMessage}"\n\t\t\ttype="Information"\n\t\t\tshowIcon="true"\n\t\t\tvisible="{= ${visualizationModel>/sortedChanges/relevantHiddenChanges}.length > 0 }"><link><Link text="{i18n>BUT_CHANGEVISUALIZATION_LEARNMORE}"\n\t\t\t\t\ttarget="_blank"\n\t\t\t\t\thref="https://ui5.sap.com/#/topic/35274280504f42cd87cc4fd3d403ca91.html#loio35274280504f42cd87cc4fd3d403ca91/visualization"/></link></MessageStrip></Popover></core:FragmentDefinition>',
	"sap/ui/rta/util/changeVisualization/ChangeIndicatorPopover.fragment.xml":'<core:FragmentDefinition\n\txmlns:core="sap.ui.core"\n\txmlns="sap.m"\n\txmlns:l="sap.ui.layout"><Popover\n\t\tshowHeader="false"\n\t\tplacement="PreferredTopOrFlip"\n\t\tid="popover"\n\t\tclass="sapUiRtaPopover sapUiRtaChangeVisualizationPopover"><Table\n\t\t\tariaLabelledBy="Changes"\n\t\t\titems="{details>/}"\n\t\t\tinset="false"\n\t\t\tfixedLayout="false"\n\t\t\twidth="auto"><columns><Column\n\t\t\t\t\twidth="auto"><Text text="{i18n>TIT_CHANGEVISUALIZATION_TYPE}" /></Column><Column\n\t\t\t\t\twidth="auto"><Text text="{i18n>TIT_CHANGEVISUALIZATION_DESCRIPTION}" /></Column><Column\n\t\t\t\t\twidth="auto"><Text text="{i18n>TIT_CHANGEVISUALIZATION_DATE}" /></Column></columns><items><ColumnListItem><cells><core:Icon\n\t\t\t\t\t\t\tsrc="{details>icon}"\n\t\t\t\t\t\t\tclass="sapUiTinyMarginBegin"\n\t\t\t\t\t\t\ttooltip="{details>iconTooltip}"/><HBox alignItems="Center"><Text\n\t\t\t\t\t\t\t\ttext="{details>description}"\n\t\t\t\t\t\t\t\ttooltip="{details>descriptionTooltip}"/><Button\n\t\t\t\t\t\t\t\tvisible="{= !!${details>detailButtonText}}"\n\t\t\t\t\t\t\t\ttext="{details>detailButtonText}"\n\t\t\t\t\t\t\t\tpress="._showDependentElements"\n\t\t\t\t\t\t\t\tclass="sapUiTinyMarginBegin"/></HBox><Text\n\t\t\t\t\t\t\ttext="{details>relativeDate}"\n\t\t\t\t\t\t\ttooltip="{details>fullDate}"/></cells></ColumnListItem></items></Table></Popover></core:FragmentDefinition>',
	"sap/ui/rta/util/guidedTour/TourMarker.fragment.xml":'<core:FragmentDefinition\n\txmlns="sap.m"\n\txmlns:core="sap.ui.core"><Popover\n\t\tid="guidedTourMarkerPopover"\n\t\ttitle="{/title}"\n\t\tclass="sapUiResponsivePadding--header sapUiResponsivePadding--footer sapUiContentPadding"\n\t\tplacement="PreferredBottomOrFlip"\n\t\tmodal="true"\n\t\tcontentWidth="32rem"\n\t\tinitialFocus="continueButton"><endButton><Button\n\t\t\t\tid="closeButton"\n\t\t\t\ticon="sap-icon://decline"\n\t\t\t\tpress=".onClosePress"\n\t\t\t\ttooltip="{i18n>TOOLTIP_GUIDED_TOUR_END}" /></endButton><content><VBox><FormattedText htmlText="{/description}" class="sapUiTinyMargin"/><List\n\t\t\t\t\tvisible="{= ${/listContent}.length > 0}"\n\t\t\t\t\titems="{/listContent}"\n\t\t\t\t\tid="navigationList"><StandardListItem  wrapping="true" title="{title}" description="{description}" icon="{icon}" /></List><ProgressIndicator\n\t\t\t\t\tid="progressIndicator"\n\t\t\t\t\tpercentValue="{/progress}"\n\t\t\t\t\tstate="None"\n\t\t\t\t\tdisplayOnly="true"/></VBox></content><footer><OverflowToolbar><ToolbarSpacer/><Button\n\t\t\t\t\tid="previewsButton"\n\t\t\t\t\ttext="{i18n>BTN_GUIDED_TOUR_PREV}"\n\t\t\t\t\tvisible="{= !${/isFirstStep}}"\n\t\t\t\t\tpress=".onPreviousPress" /><Button\n\t\t\t\t\tid="continueButton"\n\t\t\t\t\ttext="{= ${/isLastStep} ? ${i18n>BTN_GUIDED_TOUR_END} : ${i18n>BTN_GUIDED_TOUR_NEXT} }"\n\t\t\t\t\tpress=".onNextPress" /></OverflowToolbar></footer></Popover></core:FragmentDefinition>',
	"sap/ui/rta/util/whatsNew/WhatsNewDialog.fragment.xml":'<core:FragmentDefinition\n\txmlns:core="sap.ui.core"\n\txmlns="sap.m"\n\txmlns:grid="sap.ui.layout.cssgrid"\n\txmlns:f="sap.f"\n\txmlns:util="sap.ui.fl.util"><Dialog\n\t\tid="sapUiRtaWhatsNewDialog"\n\t\tclass="sapUiRtaWhatsNewDialog"\n\t\ttitle="{i18n>TIT_WHATS_NEW_DIALOG}"\n\t\tcontentWidth="50rem"\n\t\tcontentHeight="33rem"\n\t\thorizontalScrolling="false"><content><Carousel\n\t\t\t\tid="sapWhatsNewDialogCarousel"\n\t\t\t\tloop="true"\n\t\t\t\tpages="{path: \'whatsNewModel>/featureCollection\',  templateShareable: false}"\n\t\t\t\theight="33rem"\n\t\t\t\twidth="100%"><pages><Page enableScrolling="true" showHeader="false"><VBox height="100%" width="100%"><Title text="{whatsNewModel>title}" class="sapUiMediumMarginTop sapUiSmallMarginBegin sapUiTinyMarginBottom" level="H3"/><f:Card width="100%" height="24rem" class="sapUiSmallMarginBottom"><f:content><Page showHeader="false" backgroundDesign="Transparent"><VBox items="{path: \'whatsNewModel>information\', templateShareable: false}" class="sapUiSmallMargin"><HBox alignItems="Center" class="sapUiTinyMargin"><FormattedText\n\t\t\t\t\t\t\t\t\t\t\t\t\t\tvisible="{= (${whatsNewModel>image} === null ? true : false) &amp;&amp; (${whatsNewModel>text} !== null ? true : false)}"\n\t\t\t\t\t\t\t\t\t\t\t\t\t\thtmlText="{whatsNewModel>text}"\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t/><Image\n\t\t\t\t\t\t\t\t\t\t\t\t\t\tsrc= "{whatsNewModel>image}"\n\t\t\t\t\t\t\t\t\t\t\t\t\t\tvisible="{= (${whatsNewModel>image} !== null ? true : false) &amp;&amp; (${whatsNewModel>text} === null ? true : false)}"\n\t\t\t\t\t\t\t\t\t\t\t\t\t\tclass="whatsNewImage"\n\t\t\t\t\t\t\t\t\t\t\t\t\t\twidth="100%"\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t/><grid:CSSGrid\n\t\t\t\t\t\t\t\t\t\t\t\t\t\tvisible="{= (${whatsNewModel>image} !== null ? true : false) &amp;&amp; (${whatsNewModel>text} !== null ? true : false)}"\n\t\t\t\t\t\t\t\t\t\t\t\t\t\tgridTemplateColumns="2fr 3fr"\n\t\t\t\t\t\t\t\t\t\t\t\t\t\tgridGap="1rem"><Image\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tsrc= "{whatsNewModel>image}"\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tclass="whatsNewImage"\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\twidth="100%"/><HBox alignItems="Center"><FormattedText htmlText="{whatsNewModel>text}"/></HBox></grid:CSSGrid></HBox></VBox></Page></f:content></f:Card></VBox></Page></pages></Carousel></content><footer><Toolbar><content><CheckBox\n\t\t\t\t\t\tid="whatsNewDialog_DontShowAgain"\n\t\t\t\t\t\ttext="{i18n>TXT_DONT_SHOW_AGAIN_WHATS_NEW_DIALOG}"></CheckBox><ToolbarSpacer /><Button\n\t\t\t\t\t\tid="sapUiRtaWhatsNewDialog_LearnMore"\n\t\t\t\t\t\ttext="{i18n>BTN_LEARN_MORE_WHATS_NEW_DIALOG}"\n\t\t\t\t\t\tpress=".onLearnMorePress"/><Button\n\t\t\t\t\t\tid="sapUiRtaWhatsNewDialog_ButtonClose"\n\t\t\t\t\t\ttext="{i18n>BTN_CLOSE_FEEDBACK_DIALOG}"\n\t\t\t\t\t\tpress=".closeWhatsNewDialog"/></content></Toolbar></footer></Dialog></core:FragmentDefinition>',
	"sap/ui/rta/util/whatsNew/WhatsNewOverviewDialog.fragment.xml":'<core:FragmentDefinition\n\txmlns:core="sap.ui.core"\n\txmlns="sap.m"\n\txmlns:grid="sap.ui.layout.cssgrid"\n\txmlns:f="sap.f"\n\txmlns:util="sap.ui.fl.util"><Dialog\n\t\tid="sapUiRtaWhatsNewOverviewDialog"\n\t\ttitle="{i18n>TIT_WHATS_NEW_DIALOG_OVERVIEW}"\n\t\tcontentWidth="50rem"\n\t\tcontentHeight="33rem"\n\t\thorizontalScrolling="false"><List id="whatsNewOverview" items="{path: \'whatsNewModel>/featureCollection\'}" visible="{whatsNewModel>overviewActive}"><StandardListItem\n\t\t\t\t\tdescription="{whatsNewModel>description}"\n\t\t\t\t\ttitle="{whatsNewModel>title}"\n\t\t\t\t\tpress=".onSelectListItem"\n\t\t\t\t\twrapping="true"\n\t\t\t\t\twrapCharLimit="10000"\n\t\t\t\t\ttype="Active"/></List><VBox  id="whatsNewItemPage" visible="{= ${whatsNewModel>overviewActive} === false}"><VBox height="100%" width="100%" ><Title text="{whatsNewModel>title}" class="sapUiMediumMarginTop sapUiLargeMarginBegin sapUiTinyMarginBottom" level="H3"/><VBox class="sapUiSmallMargin sapUiLargeMarginBegin sapUiLargeMarginEnd" ><VBox height="100%" width="100%" items="{whatsNewModel>information}"><HBox alignItems="Center" class=" sapUiSmallMarginBottom "><FormattedText\n\t\t\t\t\t\t\t\t\tvisible="{= (${whatsNewModel>image} === null ? true : false) &amp;&amp; (${whatsNewModel>text} !== null ? true : false)}"\n\t\t\t\t\t\t\t\t\thtmlText="{whatsNewModel>text}"\n\t\t\t\t\t\t\t\t\tclass="sapUiMediumMarginEnd"/><Image\n\t\t\t\t\t\t\t\t\tsrc= "{whatsNewModel>image}"\n\t\t\t\t\t\t\t\t\tvisible="{= (${whatsNewModel>image} !== null ? true : false) &amp;&amp; (${whatsNewModel>text} === null ? true : false)}"\n\t\t\t\t\t\t\t\t\tclass=" sapUiMediumMarginEnd whatsNewImage"\n\t\t\t\t\t\t\t\t\twidth="100%"\n\t\t\t\t\t\t\t\t\t/><grid:CSSGrid\n\t\t\t\t\t\t\t\t\tvisible="{= (${whatsNewModel>image} !== null ? true : false) &amp;&amp; (${whatsNewModel>text} !== null ? true : false)}"\n\t\t\t\t\t\t\t\t\tgridTemplateColumns="2fr 3fr"\n\t\t\t\t\t\t\t\t\tgridGap="1rem"><Image\n\t\t\t\t\t\t\t\t\t\tsrc= "{whatsNewModel>image}"\n\t\t\t\t\t\t\t\t\t\tdecorative="true"\n\t\t\t\t\t\t\t\t\t\tdensityAware="false"\n\t\t\t\t\t\t\t\t\t\tclass=" sapUiMediumMarginEnd whatsNewImage"\n\t\t\t\t\t\t\t\t\t\twidth="100%"\n\t\t\t\t\t\t\t\t\t\t/><HBox alignItems="Center"><FormattedText htmlText="{whatsNewModel>text}"/></HBox></grid:CSSGrid></HBox></VBox></VBox></VBox></VBox><footer><Toolbar><content><ToolbarSpacer /><Button\n\t\t\t\t\t\tid="sapUiRtaWhatsNewOverviewDialog_LearnMore"\n\t\t\t\t\t\tvisible="{= ${whatsNewModel>overviewActive} === false}"\n\t\t\t\t\t\ttext="{i18n>BTN_LEARN_MORE_WHATS_NEW_DIALOG}"\n\t\t\t\t\t\tpress=".onLearnMorePress"/><Button\n\t\t\t\t\t\tid="sapUiRtaWhatsNewOverviewDialog_ButtonBack"\n\t\t\t\t\t\tvisible="{= ${whatsNewModel>overviewActive} === false}"\n\t\t\t\t\t\ttext="{i18n>BTN_BACK_WHATS_NEW_OVERVIEW_DIALOG}"\n\t\t\t\t\t\tpress=".backToOverview"/><Button\n\t\t\t\t\t\tid="sapUiRtaWhatsNewOverviewDialog_ButtonClose"\n\t\t\t\t\t\tvisible="true"\n\t\t\t\t\t\ttext="{i18n>BTN_CLOSE_FEEDBACK_DIALOG}"\n\t\t\t\t\t\tpress=".closeWhatsNewOverviewDialog"/></content></Toolbar></footer></Dialog></core:FragmentDefinition>',
	"sap/ui/rta/view/RemoveElementDialog.fragment.xml":'<core:FragmentDefinition xmlns:core="sap.ui.core"\n\txmlns:commons="sap.ui.commons" xmlns:layout="sap.ui.layout"\n\txmlns:sap.m="sap.m"><sap.m:Dialog class="sapUiRtaConfirmationDialog" verticalScrolling="false" title="{/titleText}" icon="{/icon}"><layout:VerticalLayout width="100%"><sap.m:Text class="sapUiRtaConfirmationDialogText" text="{/messageText}" /></layout:VerticalLayout><sap.m:beginButton><sap.m:Button class="sapUiRtaConfirmationDialogRemoveButton" text="{/removeText}" press="removeField" /></sap.m:beginButton><sap.m:endButton><sap.m:Button class="sapUiRtaConfirmationDialogCancelButton" text="{/cancelText}" press="closeDialog" /></sap.m:endButton></sap.m:Dialog></core:FragmentDefinition>'
});
//# sourceMappingURL=library-preload.js.map
