/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/base/Log","sap/m/MessageBox","sap/ui/base/ManagedObject","sap/ui/core/Element","sap/ui/core/Lib","sap/ui/dt/ElementOverlay","sap/ui/dt/OverlayRegistry","sap/ui/dt/OverlayUtil","sap/ui/dt/Util","sap/ui/fl/apply/api/ControlVariantApplyAPI","sap/ui/fl/variants/VariantManagement","sap/ui/fl/variants/VariantManager","sap/ui/fl/write/api/ContextSharingAPI","sap/ui/fl/Layer","sap/ui/fl/Utils","sap/ui/rta/plugin/rename/RenameDialog","sap/ui/rta/plugin/Plugin","sap/ui/rta/Utils"],function(t,e,a,n,i,r,o,s,g,l,c,m,d,u,p,h,f,v){"use strict";r.prototype._variantManagement=undefined;r.prototype.getVariantManagement=function(){return this._variantManagement};r.prototype.setVariantManagement=function(t){this._variantManagement=t};r.prototype.hasVariantManagement=function(){return!!this._variantManagement};function V(t){var e=t.getElement().getManageDialog();if(e&&!e.bIsDestroyed){e.destroy()}}var A=f.extend("sap.ui.rta.plugin.ControlVariant",{metadata:{library:"sap.ui.rta",properties:{oldValue:"string"},associations:{},events:{}}});function _(t){var e=t.getElement();var a=t.getDesignTimeMetadata();var n=this._getVariantModel(e);var i=t.getVariantManagement();return this.getCommandFactory().getCommandFor(e,"save",{model:n},a,i)}function y(t,e,a,n){var i=t.getElement();var r=t.getDesignTimeMetadata();return this.getCommandFactory().getCommandFor(i,"switch",{targetVariantReference:e,sourceVariantReference:a,discardVariantContent:n},r)}A.prototype.init=function(...t){f.prototype.init.apply(this,t);this._oDialog=new h};A.prototype.registerElementOverlay=function(...t){const[e]=t;var i=e.getElement();var r;f.prototype.registerElementOverlay.apply(this,t);if(i instanceof c){var s=i.getFor();var g;var l=p.getAppComponentForControl(i);var m=i.getId();r=l.getLocalId(m)||m;e.setVariantManagement(r);if(!s||Array.isArray(s)&&s.length===0){return}g=!Array.isArray(s)?[s]:s;g.forEach(function(t){var e=t instanceof a?t:n.getElementById(t);var i=o.getOverlay(e);if(!i){const e=(t,a)=>{const n=t.getParameter("elementOverlay");if(n.getElement().getId()===a){this._propagateVariantManagement(n,r);this.getDesignTime().detachEvent("elementOverlayCreated",e)}};this.getDesignTime().attachEvent("elementOverlayCreated",t,e,this)}else{this._propagateVariantManagement(i,r)}}.bind(this));V(e)}else if(!e.getVariantManagement()){r=this._getVariantManagementFromParent(e);if(r){e.setVariantManagement(r)}}};A.prototype._isPersonalizationMode=function(){return this.getCommandFactory().getFlexSettings().layer===u.USER};A.prototype._propagateVariantManagement=function(t,e){var a=[];t.setVariantManagement(e);a=s.getAllChildOverlays(t);a.forEach(function(t){a=a.concat(this._propagateVariantManagement(t,e))}.bind(this));return a};A.prototype._getVariantManagementFromParent=function(t){var e=t.getVariantManagement();if(!e&&t.getParentElementOverlay()){return this._getVariantManagementFromParent(t.getParentElementOverlay())}return e};A.prototype.deregisterElementOverlay=function(...t){const e=t[0];if(this._isVariantManagementControl(e)){V(e)}this.removeFromPluginsList(e);f.prototype.deregisterElementOverlay.apply(this,t)};A.prototype._getVariantModel=function(t){var e=p.getAppComponentForControl(t);return e?e.getModel(l.getVariantModelName()):undefined};A.prototype._isEditable=function(t){if(this._isPersonalizationMode()){return false}return this._isVariantManagementControl(t)&&this.hasStableId(t)};A.prototype._isVariantManagementControl=function(t){var e=t.getElement();var a=e.getAssociation("for");return!!(a&&e instanceof c)};A.prototype.isVariantSwitchAvailable=function(t){return this._isVariantManagementControl(t)};A.prototype.isVariantSwitchEnabled=function(t){var e=t[0];var a=[];if(this._isVariantManagementControl(e)){var n=e.getElement();var i=e.getVariantManagement?e.getVariantManagement():undefined;if(!i){return false}var r=this._getVariantModel(n);if(r){a=r.getData()[i].variants.reduce(function(t,e){if(e.visible){return t.concat(e)}return t},[])}var o=a.length>1;return o}return false};A.prototype.isRenameAvailable=function(t){return this._isVariantManagementControl(t)};A.prototype.isRenameEnabled=function(t){return this._isVariantManagementControl(t[0])};A.prototype.isVariantSaveAvailable=function(t){return this._isVariantManagementControl(t)};A.prototype.isVariantSaveEnabled=function(t){var e=t[0];var a=e.getElement();var n=this._getVariantModel(a);var i=e.getVariantManagement();return n.oData[i]&&n.oData[i].modified};A.prototype.isVariantSaveAsAvailable=function(t){return this._isVariantManagementControl(t)};A.prototype.isVariantSaveAsEnabled=function(t){return this._isVariantManagementControl(t[0])};A.prototype.isVariantConfigureAvailable=function(t){return this._isVariantManagementControl(t)};A.prototype.isVariantConfigureEnabled=function(t){return this._isVariantManagementControl(t[0])};A.prototype.switchVariant=function(t,a,n){var r=t.getElement();var o=i.getResourceBundleFor("sap.ui.rta");function s(i){if(i===e.Action.CANCEL){return}if(i===o.getText("BTN_MODIFIED_VARIANT_SAVE")){var s;this.getCommandFactory().getCommandFor(r,"composite").then(function(e){s=e;return _.call(this,t)}.bind(this)).then(function(e){s.addCommand(e);return y.call(this,t,a,n)}.bind(this)).then(function(t){s.addCommand(t);this.fireElementModified({command:s})}.bind(this))}if(i===o.getText("BTN_MODIFIED_VARIANT_DISCARD")){y.call(this,t,a,n,true).then(function(t){this.fireElementModified({command:t})}.bind(this))}}if(r.getModified()){e.warning(o.getText("MSG_CHANGE_MODIFIED_VARIANT"),{onClose:s.bind(this),actions:[o.getText("BTN_MODIFIED_VARIANT_SAVE"),o.getText("BTN_MODIFIED_VARIANT_DISCARD"),e.Action.CANCEL],emphasizedAction:o.getText("BTN_MODIFIED_VARIANT_SAVE"),styleClass:v.getRtaStyleClassName(),id:"controlVariantWarningDialog"})}else{y.call(this,t,a,n).then(function(t){this.fireElementModified({command:t})}.bind(this)).catch(function(t){throw g.createError("ControlVariant#switchVariant",t,"sap.ui.rta")})}};A.prototype.renameVariant=async function(t){const[e]=t;const a=e.getVariantManagement();const n=e.getDesignTimeMetadata();const i=e.getElement();const r=n.getData().variantRenameDomRef;const o=await this._oDialog.openDialogAndHandleRename({overlay:e,domRef:r,action:this.getAction(e)});if(!o){return}const s=await this._createSetTitleCommand({text:o,element:i,designTimeMetadata:n,variantManagementReference:a});this.fireElementModified({command:s})};A.prototype.createSaveCommand=function(t){var e=t[0];return _.call(this,e).then(function(t){this.fireElementModified({command:t})}.bind(this))};A.prototype.createSaveAsCommand=function(t){var e=t[0];var a=e.getElement();var n=e.getDesignTimeMetadata();var i=this._getVariantModel(a);var r=e.getVariantManagement();var o=i.getCurrentVariantReference(r);return this.getCommandFactory().getCommandFor(a,"saveAs",{sourceVariantReference:o,model:i},n,r).then(function(t){this.fireElementModified({command:t})}.bind(this))};A.prototype._createSetTitleCommand=function(e){return this.getCommandFactory().getCommandFor(e.element,"setTitle",{newText:e.text},e.designTimeMetadata,e.variantManagementReference).catch(function(e){t.error("Error during rename: ",e)})};A.prototype.configureVariants=function(t){var e=t[0];var a=e.getElement();var n=e.getVariantManagement();var i=e.getDesignTimeMetadata();var r=this.getCommandFactory().getFlexSettings();var o=r;o.variantManagementControl=a;return m.manageVariants(a,n,r.layer,v.getRtaStyleClassName(),d.createComponent(o)).then(function(t){if(t.changes.length>0){return this.getCommandFactory().getCommandFor(a,"configure",{control:a,changes:t.changes,deletedVariants:t.variantsToBeDeleted},i,n)}return undefined}.bind(this)).then(function(t){if(t){this.fireElementModified({command:t})}}.bind(this)).catch(function(t){throw g.createError("ControlVariant#configureVariants",t,"sap.ui.rta")})};A.prototype.getMenuItems=function(t){var e=t[0];var a=[];if(this.isRenameAvailable(e)){a.push({id:"CTX_VARIANT_SET_TITLE",text:i.getResourceBundleFor("sap.ui.rta").getText("CTX_RENAME"),handler:this.renameVariant.bind(this),enabled:this.isRenameEnabled.bind(this),rank:this.getRank("CTX_VARIANT_SET_TITLE"),icon:"sap-icon://edit"})}if(this.isVariantSaveAvailable(e)){a.push({id:"CTX_VARIANT_SAVE",text:i.getResourceBundleFor("sap.ui.rta").getText("CTX_VARIANT_SAVE"),handler:this.createSaveCommand.bind(this),enabled:this.isVariantSaveEnabled.bind(this),rank:this.getRank("CTX_VARIANT_SAVE"),icon:"sap-icon://save"})}if(this.isVariantSaveAsAvailable(e)){a.push({id:"CTX_VARIANT_SAVEAS",text:i.getResourceBundleFor("sap.ui.rta").getText("CTX_VARIANT_SAVEAS"),handler:this.createSaveAsCommand.bind(this),enabled:this.isVariantSaveAsEnabled.bind(this),rank:this.getRank("CTX_VARIANT_SAVEAS"),icon:"sap-icon://duplicate"})}if(this.isVariantConfigureAvailable(e)){a.push({id:"CTX_VARIANT_MANAGE",text:i.getResourceBundleFor("sap.ui.rta").getText("CTX_VARIANT_MANAGE"),handler:this.configureVariants.bind(this),enabled:this.isVariantConfigureEnabled.bind(this),startSection:true,rank:this.getRank("CTX_VARIANT_MANAGE"),icon:"sap-icon://action-settings"})}if(this.isVariantSwitchAvailable(e)){var n=this._getVariantModel(e.getElement());var r=e.getVariantManagement();var o=n.getData()[r].variants.reduce(function(t,e){if(e.visible){var a=n.getData()[r].currentVariant===e.key;var i={id:e.key,text:e.title,icon:a?"sap-icon://accept":"blank",enabled:!a};return t.concat(i)}return t},[]);a.push({id:"CTX_VARIANT_SWITCH_SUBMENU",text:i.getResourceBundleFor("sap.ui.rta").getText("CTX_VARIANT_SWITCH"),handler:function(t,e){var a=e.eventItem.getParameters().item.getProperty("key");var i=t[0];var o=n.getData()[r].currentVariant;return this.switchVariant(i,a,o)}.bind(this),enabled:this.isVariantSwitchEnabled.bind(this),submenu:o,rank:this.getRank("CTX_VARIANT_SWITCH_SUBMENU"),icon:"sap-icon://switch-views"})}return a};A.prototype.getActionName=function(){return"controlVariant"};A.prototype.destroy=function(...t){f.prototype.destroy.apply(this,t);this._oDialog.destroy();delete this._oDialog};return A});
//# sourceMappingURL=ControlVariant.js.map