/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/base/util/restricted/_debounce","sap/ui/core/util/reflection/JsControlTreeModifier","sap/ui/dt/OverlayRegistry","sap/ui/dt/OverlayUtil","sap/ui/dt/Plugin","sap/ui/fl/write/api/ChangesWriteAPI","sap/ui/fl/Utils","sap/ui/rta/util/hasStableId","sap/ui/rta/util/isReuseComponent","sap/ui/rta/Utils"],function(e,t,i,n,a,s,r,o,l,u){"use strict";const g={CTX_ADDXML:3,CTX_EXTEND_CONTROLLER:5,CTX_RENAME:10,CTX_ANNOTATION_CHANGE_SINGLE_LABEL:12,CTX_ADD_ELEMENTS_AS_SIBLING:20,CTX_ADD_ELEMENTS_AS_CHILD:25,CTX_ADD_ELEMENTS_CHILD_AND_SIBLING:30,CTX_CREATE_SIBLING_CONTAINER:40,CTX_CREATE_CHILD_CONTAINER:50,CTX_REMOVE:60,CTX_LOCAL_RESET:65,CTX_CUT:70,CTX_PASTE:80,CTX_GROUP_FIELDS:90,CTX_UNGROUP_FIELDS:100,CTX_ADDXML_AT_EXTENSIONPOINT:105,CTX_SETTINGS:110,CTX_CREATE_SIBLING_IFRAME:130,CTX_VARIANT_SET_TITLE:200,CTX_COMP_VARIANT_RENAME:200,CTX_VARIANT_SAVE:210,CTX_COMP_VARIANT_SAVE:210,CTX_VARIANT_SAVEAS:220,CTX_COMP_VARIANT_SAVE_AS:220,CTX_VARIANT_MANAGE:230,CTX_COMP_VARIANT_MANAGE:230,CTX_VARIANT_SWITCH_SUBMENU:240,CTX_COMP_VARIANT_SWITCH:240,CTX_COMP_VARIANT_CONTENT:250,CTX_ANNOTATION:300};function c(e,t,i){var n=i;if(typeof this.getActionName()==="string"){if(this.isResponsibleElementActionAvailable(i)){n=this.getResponsibleElementOverlay(i)}}var a=n.getElement()&&n.getDesignTimeMetadata()&&!n.getDesignTimeMetadata().markedAsNotAdaptable()&&this._isEditable(n,{sourceElementOverlay:i,...e});if(a&&typeof a.then==="function"){a.then(function(e){this._handleModifyPluginList(i,e)}.bind(this));t.push(a)}else{this._handleModifyPluginList(i,a)}return t}var f=a.extend("sap.ui.rta.plugin.Plugin",{metadata:{abstract:true,library:"sap.ui.rta",properties:{commandFactory:{type:"object",multiple:false},commandStack:{type:"object",multiple:false}},events:{elementModified:{command:{type:"sap.ui.rta.command.BaseCommand"}}}}});f.prototype._isEditable=function(){};f.prototype.executeWhenVisible=function(e,t){var i=function(n){if(n.getSource().getGeometry()&&n.getSource().getGeometry().visible){e.detachEvent("geometryChanged",i,this);t()}};var n=e.getGeometry();if(e.getElementVisibility()&&(!n||!n.visible)){e.attachEvent("geometryChanged",i,this)}else{t()}};function h(t,i,n,a){var s=i.getId();t[s]||={};t[s][n]||=e(a,16);t[s][n]()}var d=async function(e){if(this.getCommandStack()){await this.getCommandStack().getLastCommandExecuted()}if(!this._mDebounceFunctions){this._mDebounceFunctions={insertOrRemove:{},addOrSet:{}}}var t=e.getParameters();var i;var n=e.getSource();if(t.type==="propertyChanged"&&t.name==="visible"){i=this._getRelevantOverlays(n);if(t.value===true){this.executeWhenVisible(n,function(){this.evaluateEditable(i,{onRegistration:false})}.bind(this))}else{this.evaluateEditable(i,{onRegistration:false})}}else if(t.type==="afterRendering"){if(this.getDesignTime().getStatus()==="synced"){this.evaluateEditable([n],{onRegistration:false})}else{this.getDesignTime().attachEventOnce("synced",function(){this.evaluateEditable([n],{onRegistration:false})},this)}}else if(t.type==="insertAggregation"||t.type==="removeAggregation"){h(this._mDebounceFunctions.insertOrRemove,n,t.name,function(){i=this._getRelevantOverlays(n,t.name);this.evaluateEditable(i,{onRegistration:false})}.bind(this))}else if(t.type==="addOrSetAggregation"){h(this._mDebounceFunctions.addOrSet,n,t.name,function(){var e=this.getDesignTime();if(!e){return}if(e.getStatus()==="synced"){i=this._getRelevantOverlays(n,t.name);this.evaluateEditable(i,{onRegistration:false})}else{e.attachEventOnce("synced",function(){i=this._getRelevantOverlays(n,t.name);this.evaluateEditable(i,{onRegistration:false})},this)}}.bind(this))}};f.prototype._getRelevantOverlays=function(e,t){var i=e.getRelevantOverlays();if(i.length===0){var a=[];if(!e.getIsPartOfTemplate()){a=n.findAllOverlaysInContainer(e);if(t){var s=e.getAggregationOverlay(t);var r=s?s.getChildren():[];r=r.filter(function(e){return a.indexOf(e)===-1});a=a.concat(r)}}e.setRelevantOverlays(a);return a}return i};f.prototype.evaluateEditable=async function(e,t){if(!t.onRegistration&&this.getDesignTime()&&this.getDesignTime().getBusyPlugins().length){return}this.setProcessingStatus(true);var i=e.reduce(c.bind(this,t),[]);if(i.length){try{await Promise.all(i);this.setProcessingStatus(false)}catch(e){this.setProcessingStatus(false)}}else{this.setProcessingStatus(false)}};f.prototype._handleModifyPluginList=function(e,t){if(t!==undefined&&t!==null){if(typeof t==="boolean"){this._modifyPluginList(e,t)}else{this._modifyPluginList(e,t.asChild,false);this._modifyPluginList(e,t.asSibling,true)}}};f.prototype._modifyPluginList=function(e,t,i){if(t){this.addToPluginsList(e,i)}else{this.removeFromPluginsList(e,i)}};f.prototype._retrievePluginName=function(e){var t=this.getMetadata().getName();if(e!==undefined){t+=e?".asSibling":".asChild"}return t};f.prototype._isEditableByPlugin=function(e,t){var i=this._retrievePluginName(t);return e.getEditableByPlugins()[i]};f.prototype.registerElementOverlay=function(e){this.executeWhenVisible(e,function(){this.evaluateEditable([e],{onRegistration:true});e.attachElementModified(d,this)}.bind(this))};f.prototype.deregisterElementOverlay=function(e){this.removeFromPluginsList(e);this.removeFromPluginsList(e,true);this.removeFromPluginsList(e,false);e.detachElementModified(d,this)};f.prototype.hasStableId=function(e){return o(e)};f.prototype.getVariantManagementReference=function(e){var t;if(e.getVariantManagement){t=e.getVariantManagement()}return t};f.prototype.checkAggregationsOnSelf=function(e,t,n,a){var s=e.getDesignTimeMetadata();var r=e.getElement();var o=s.getActionDataFromAggregations(t,r,undefined,a);var l=o.filter(function(e){if(e&&n){return e.aggregation===n}return true})[0];var u=l?l.changeType:null;var g=l&&l.changeOnRelevantContainer;if(g){r=e.getRelevantContainer();var c=i.getOverlay(r);if(!this.hasStableId(c)){return Promise.resolve(false)}}if(u){return this.hasChangeHandler(u,r)}return Promise.resolve(false)};f.prototype.removeFromPluginsList=function(e,t){const i=this._retrievePluginName(t);const n=e.getEditableByPlugins();e.setEditableByPlugins({...n,[i]:false});if(!Object.values(e.getEditableByPlugins()).some(Boolean)){e.setEditable(false)}};f.prototype.addToPluginsList=function(e,t){const i=this._retrievePluginName(t);const n=e.getEditableByPlugins();if(!n[i]){e.setEditableByPlugins({...n,[i]:true});e.setEditable(true)}};f.prototype.hasChangeHandler=function(e,i,n){return s.getChangeHandler({changeType:e,element:i,modifier:t,layer:this.getCommandFactory().getFlexSettings().layer,controlType:n}).then(function(){return true}).catch(function(){return false})};f.prototype.isAvailable=function(e){return e.every(function(e){return this._isEditableByPlugin(e)},this)};f.prototype._checkRelevantContainerStableID=function(e,t){if(e.changeOnRelevantContainer){var n=t.getRelevantContainer();var a=i.getOverlay(n);if(!this.hasStableId(a)){return false}}return true};f.prototype._checkChangeHandlerAndStableId=function(e){var t=this.getAction(e);if(t&&t.changeType){var i=t.changeOnRelevantContainer?e.getRelevantContainer():e.getElement();return this.hasChangeHandler(t.changeType,i).then(function(i){return i&&this._checkRelevantContainerStableID(t,e)&&this.hasStableId(e)}.bind(this))}return Promise.resolve(false)};f.prototype.getRank=function(e){return g[e]};f.prototype._getMenuItems=function(e,t){t.rank||=this.getRank(t.pluginId);return a.prototype._getMenuItems.apply(this,[e,t])};f.prototype.isInReuseComponentOnS4HanaCloud=function(e){const t=r.getComponentForControl(e.getElement());const i=u.isS4HanaCloud();return l(t)&&i};return f});
//# sourceMappingURL=Plugin.js.map