/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/m/InstanceManager","sap/ui/core/Element","sap/ui/dt/OverlayRegistry","sap/ui/dt/OverlayUtil","sap/ui/events/KeyCodes","sap/ui/rta/plugin/Plugin","sap/ui/rta/Utils"],function(e,t,i,r,a,s,n){"use strict";var o=s.extend("sap.ui.rta.plugin.Selection",{metadata:{library:"sap.ui.rta",properties:{multiSelectionRequiredPlugins:{type:"string[]"},isActive:{type:"boolean",defaultValue:true}},associations:{},events:{elementEditableChange:{parameters:{editable:{type:"boolean"}}}}}});function l(e){e.preventDefault();e.stopPropagation()}function u(e,t){var i=t.slice();e.forEach(function(e){i=i.filter(function(t){return e.getEditableByPlugins()[t]})});return i.length>0}function c(e){return e.every(function(t){return t.getRelevantContainer()===e[0].getRelevantContainer()})}function v(e){return e.every(function(t){return t.getParentElementOverlay()===e[0].getParentElementOverlay()})}function g(e){return e.every(function(t){return t.getElement().getMetadata().getName()===e[0].getElement().getMetadata().getName()})}o.prototype.init=function(...e){this._multiSelectionValidator=this._multiSelectionValidator.bind(this);s.prototype.init.apply(this,e)};o.prototype._checkDeveloperMode=function(e,t){if(t){var i=this.getCommandFactory().getFlexSettings().developerMode;if(i&&this.hasStableId(e)){e.setEditable(true);e.setSelectable(true);this.fireElementEditableChange({editable:true});return true}}return false};o.prototype.setIsActive=function(e){this.setProperty("isActive",e);if(e===false){this._deselectOverlays()}};o.prototype.registerElementOverlay=function(e){var t=e.getDesignTimeMetadata();if(!t.markedAsNotAdaptable()&&!this._checkDeveloperMode(e,t)){e.attachEditableChange(this._onEditableChange,this);this._adaptSelectable(e)}e.attachBrowserEvent("click",this._selectOverlay,this);e.attachBrowserEvent("contextmenu",this._selectOverlay,this);e.attachBrowserEvent("keydown",this._onKeyDown,this);e.attachBrowserEvent("mousedown",this._onMouseDown,this);e.attachBrowserEvent("mouseover",this._onMouseover,this);e.attachBrowserEvent("mouseleave",this._onMouseleave,this)};o.prototype._onEditableChange=function(e){var t=e.getSource();this._adaptSelectable(t)};o.prototype._adaptSelectable=function(e){var t=e.getEditable();if(e.getSelectable()!==t){e.setSelectable(t);if(!t){this._removePreviousHover()}this.fireElementEditableChange({editable:t})}};o.prototype.deregisterElementOverlay=function(e){e.detachBrowserEvent("click",this._selectOverlay,this);e.detachBrowserEvent("contextmenu",this._selectOverlay,this);e.detachBrowserEvent("keydown",this._onKeyDown,this);e.detachBrowserEvent("mousedown",this._onMouseDown,this);e.detachBrowserEvent("mouseover",this._onMouseover,this);e.detachBrowserEvent("mouseleave",this._onMouseleave,this);e.detachEditableChange(this._onEditableChange,this)};o.prototype._setFocusOnOverlay=function(e,t){if(e&&e.getSelectable()){e.focus();t.stopPropagation()}};o.prototype._getFocusedOverlay=function(){if(document.activeElement){var e=t.getElementById(document.activeElement.id);if(e&&e.isA("sap.ui.dt.ElementOverlay")){return e}}return undefined};o.prototype._onKeyDown=function(e){if(!this.getIsActive()){return}var t=this._getFocusedOverlay();if(e.keyCode===a.ENTER){this._selectOverlay(e)}else if(e.keyCode===a.ARROW_UP&&e.shiftKey===false&&e.altKey===false){if(t){var i=n.getFocusableParentOverlay(t);this._setFocusOnOverlay(i,e);e.preventDefault()}}else if(e.keyCode===a.ARROW_DOWN&&e.shiftKey===false&&e.altKey===false){if(t){var r=n.getFirstFocusableDescendantOverlay(t);this._setFocusOnOverlay(r,e);e.preventDefault()}}else if(e.keyCode===a.ARROW_LEFT&&e.shiftKey===false&&e.altKey===false){if(t){var s=n.getPreviousFocusableSiblingOverlay(t);this._setFocusOnOverlay(s,e);e.preventDefault()}}else if(e.keyCode===a.ARROW_RIGHT&&e.shiftKey===false&&e.altKey===false){if(t){var o=n.getNextFocusableSiblingOverlay(t);this._setFocusOnOverlay(o,e);e.preventDefault()}}else if(e.keyCode===a.ESCAPE){if(t){this._deselectOverlays()}}};o.prototype._deselectOverlays=function(){this.getDesignTime().getSelectionManager().reset()};o.prototype._selectOverlay=function(e){var t=i.getOverlay(e.currentTarget.id);if(!this.getIsActive()){if(t.isRoot()){l(e)}return}var r=e.metaKey||e.ctrlKey||e.shiftKey;var a=e.type==="contextmenu";if(t&&t.getSelectable()){if(t.isSelected()){if(!a){this.getDesignTime().getSelectionManager().remove(t)}}else if(r){this.getDesignTime().getSelectionManager().add(t)}else{this.getDesignTime().getSelectionManager().set(t)}l(e)}else if(t&&t.isRoot()){l(e)}};o.prototype._onMouseDown=function(t){if(!this.getIsActive()){var r=i.getOverlay(t.currentTarget.id);if(r.isRoot()){l(t)}e.getOpenPopovers().forEach(function(e){if(e._bOpenedByChangeIndicator){e.close()}});return}};o.prototype._onMouseover=function(e){var t=i.getOverlay(e.currentTarget.id);if(!this.getIsActive()||this.getDesignTime()&&this.getDesignTime().getBusyPlugins().length){if(t.isRoot()){l(e)}return}if(t.isSelectable()){r.setFirstParentMovable(t,false);if(t!==this._oHoverTarget){this._removePreviousHover();this._oHoverTarget=t;this.getDesignTime().getSelectionManager().addHover(t)}l(e)}};o.prototype._onMouseleave=function(e){var t=i.getOverlay(e.currentTarget.id);if(!this.getIsActive()){if(t.isRoot()){l(e)}return}if(t.isSelectable()){r.setFirstParentMovable(t,true);this._removePreviousHover();l(e)}};o.prototype._removePreviousHover=function(){if(this._oHoverTarget){this.getDesignTime().getSelectionManager().removeHover(this._oHoverTarget)}delete this._oHoverTarget};o.prototype.setDesignTime=function(...e){if(this.getDesignTime()){this.getDesignTime().getSelectionManager().removeValidator(this._multiSelectionValidator)}s.prototype.setDesignTime.apply(this,e);if(this.getDesignTime()){this.getDesignTime().getSelectionManager().addValidator(this._multiSelectionValidator)}};o.prototype._multiSelectionValidator=function(e){return e.length===1||u(e,this.getMultiSelectionRequiredPlugins())&&c(e)&&(v(e)||g(e))};return o});
//# sourceMappingURL=Selection.js.map