/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/base/Log","sap/ui/dt/OverlayRegistry","sap/ui/dt/Util","sap/ui/fl/Utils","sap/ui/rta/plugin/Plugin","sap/ui/rta/Utils"],function(e,t,n,i,a,o){"use strict";const r=a.extend("sap.ui.rta.plugin.Settings",{metadata:{library:"sap.ui.rta",associations:{},events:{}}});const s="CTX_SETTINGS";function c(t,n){if(t.handler){return[t]}const i=[];Object.keys(t).forEach(a=>{let o=t[a];if(typeof o==="function"){o=o(n.getElement())}if(o.handler){o.key=a;i.push(o)}else{e.warning("Handler not found for settings action")}});return i}r.prototype._isEditable=function(e){const t=this.getAction(e);if(t){const n=c(t,e);return n.some(t=>this._checkRelevantContainerStableID(t,e))}return false};r.prototype.isEnabled=function(e){const t=e[0];const n=this.getResponsibleElementOverlay(t);const i=this.getAction(n);if(i){const e=c(i,n);return e.some(e=>{if(typeof e.isEnabled!=="undefined"){if(typeof e.isEnabled==="function"){return e.isEnabled(n.getElement())}return e.isEnabled}return!!e.handler})}return false};r.prototype._getUnsavedChanges=function(e,t){let n;const i=this.getCommandStack().getAllExecutedCommands().filter(function(i){n=i.getElementId&&i.getElementId()||i.getElement&&i.getElement().getId();return n===e&&t.indexOf(i.getChangeType())>=0}).map(function(e){return e.getPreparedChange()});return i};r.prototype._handleFlexChangeCommand=function(e,t,n,i){const a=e.changeSpecificData;let o;const r=e.selectorElement||e.selectorControl;let s;let c;if(r.controlType){s=r.controlType}else{c=r}return this.hasChangeHandler(a.changeType,c,s).then(function(e){if(t[0].getVariantManagement&&e&&!i.CAUTION_variantIndependent){o=t[0].getVariantManagement()}return this.getCommandFactory().getCommandFor(r,"settings",a,undefined,o)}.bind(this)).then(function(e){const t=i.runtimeOnly;if(e&&t){e.setRuntimeOnly(t)}return n.addCommand(e)})};r.prototype._handleManifestChangeCommand=function(e,t,n){const i=e.changeSpecificData;const a=e.appComponent;const o=a.getManifest();const r=o["sap.app"].id;return this.getCommandFactory().getCommandFor(t,"manifest",{reference:r,appComponent:a,changeType:i.appDescriptorChangeType,parameters:i.content.parameters,texts:i.content.texts}).then(function(e){return n.addCommand(e)})};r.prototype._handleCompositeCommand=function(e,t,n,a){let o;return this.getCommandFactory().getCommandFor(t,"composite").then(function(e){o=e}).then(function(){return n.map(function(n){const i=n.changeSpecificData;if(i.changeType){return()=>this._handleFlexChangeCommand(n,e,o,a)}else if(i.appDescriptorChangeType){return()=>this._handleManifestChangeCommand(n,t,o)}return undefined},this)}.bind(this)).then(function(e){return i.execPromiseQueueSequentially(e)}).then(function(){if(o.getCommands().length>0){this.fireElementModified({command:o})}}.bind(this))};r.prototype.handler=function(e,t,i){t||={};const a=e[0].getElement();let{fnHandler:r}=t;r||=e[0].getDesignTimeMetadata().getAction("settings").handler;if(!r){throw new Error("Handler not found for settings action")}t.getUnsavedChanges=this._getUnsavedChanges.bind(this);t.styleClass=o.getRtaStyleClassName();return r(a,t).then(function(t){if(t.length>0){return this._handleCompositeCommand(e,a,t,i)}return undefined}.bind(this)).catch(function(e){throw n.propagateError(e,"Settings#handler","Error occurred during handler execution","sap.ui.rta.plugin")})};r.prototype.getMenuItems=async function(t){const n=t[0];const i=this.getResponsibleElementOverlay(n);const a=this.getAction(i);const o=[];if(a){const t=this.getRank("CTX_SETTINGS");const n=c(a,i);if(this._isEditableByPlugin(i)===undefined){await this.evaluateEditable([i],{onRegistration:false})}n.forEach(function(n,a,r){if(this._checkRelevantContainerStableID(n,i)&&this.isAvailable([i])){const e=r.length===1;o.push({id:e?s:s+a,additionalInfo:this._getAdditionalInfo(i,n),rank:e?t:t+a,text:this.getActionText(i,n,s),icon:u(n),enabled:typeof n.isEnabled==="function"&&function(e){return n.isEnabled(e[0].getElement())}||n.isEnabled||this.isEnabled([i]),handler:function(e,t,i){i||={};i.fnHandler=e;return this.handler(t,i,n)}.bind(this,n.handler),submenu:l(n.submenu)})}else{e.warning("Action is not available or relevant container has no stable id")}},this)}return o};function l(e){if(e){return e.map(function(e,t){return{id:e.key||`${s}_SUB_${t}`,icon:e.icon||"blank",text:e.name||"",enabled:e.hasOwnProperty("enabled")?e.enabled:true}})}return undefined}function u(t){const n="sap-icon://key-user-settings";const i=t.icon;if(!i){return n}if(typeof i!=="string"){e.error("Icon setting for settingsAction should be a string");return n}return i}r.prototype.getActionName=function(){return"settings"};return r});
//# sourceMappingURL=Settings.js.map