/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/base/ManagedObject","sap/ui/core/Element","sap/ui/core/Fragment","sap/ui/model/json/JSONModel","sap/ui/model/Filter","sap/ui/model/FilterOperator","sap/ui/model/resource/ResourceModel","sap/ui/model/Sorter","sap/ui/rta/Utils"],function(t,e,i,o,s,n,l,r,a){"use strict";const u=t.extend("sap.ui.rta.plugin.additionalElements.AddElementsDialog",{metadata:{library:"sap.ui.rta",properties:{businessContextVisible:{type:"boolean",defaultValue:false},title:{type:"string"}},events:{opened:{},triggerExtensibilityAction:{}}}});let p;u.prototype.init=function(){this._oDialogPromise=i.load({id:this.getId(),name:"sap.ui.rta.plugin.additionalElements.AddElementsDialog",controller:this});this._oDialogModel=new o({elements:[],customFieldButtonText:"",customFieldButtonVisible:false,businessContextVisible:false,customFieldButtonTooltip:"",businessContextTexts:[{text:""}],extensibilityMenuButtonActive:false,extensibilityMenuButtonText:"",extensibilityMenuButtonTooltip:"",extensibilityOptions:[]});this._oDialogPromise.then(function(t){t.setModel(this._oDialogModel);p||=new l({bundleName:"sap.ui.rta.messagebundle"});t.setModel(p,"i18n");t.addStyleClass(a.getRtaStyleClassName());this._oDialogModel.setProperty("/listNoDataText",p.getProperty("MSG_NO_FIELDS").toLowerCase());this._oList=e.getElementById(`${this.getId()}--rta_addElementsDialogList`);this._bDescendingSortOrder=false}.bind(this))};u.prototype.exit=function(...e){this._oDialogPromise.then(function(t){t.destroy()});if(t.prototype.exit){t.prototype.exit.apply(this,e)}};u.prototype.setCustomFieldButtonVisible=function(t){this._oDialogModel.setProperty("/customFieldButtonVisible",t)};u.prototype.getCustomFieldButtonVisible=function(){return this._oDialogModel.getProperty("/customFieldButtonVisible")};u.prototype._submitDialog=async function(){const t=await this._oDialogPromise;t.close();this._fnResolveOnDialogConfirm()};u.prototype._cancelDialog=function(){this._oDialogModel.getObject("/elements").forEach(function(t){t.selected=false});this._oDialogPromise.then(function(t){t.close()});this._fnRejectOnDialogCancel()};u.prototype.setElements=function(t){this._oDialogModel.setProperty("/elements",t)};u.prototype.getElements=function(){return this._oDialogModel.getProperty("/elements")};u.prototype.getSelectedElements=function(){return this._oDialogModel.getObject("/elements").filter(function(t){return t.selected})};u.prototype.open=function(){return new Promise(function(t,e){this._fnResolveOnDialogConfirm=t;this._fnRejectOnDialogCancel=e;this._oDialogPromise.then(function(t){t.attachAfterOpen(function(){this.fireOpened()}.bind(this));t.open()}.bind(this))}.bind(this))};u.prototype._resortList=function(){this._bDescendingSortOrder=!this._bDescendingSortOrder;const t=this._oList.getBinding("items");const e=[];e.push(new r("label",this._bDescendingSortOrder));t.sort(e)};u.prototype._updateModelFilter=function(t){const e=t.getParameter("newValue");const i=this._oList.getBinding("items");if(typeof e==="string"){const t=new s("label",n.Contains,e);const o=new s("originalLabel",n.Contains,e);const l=new s("parentPropertyName",n.Contains,e);const r=new s("duplicateName",n.EQ,true);const a=new s({filters:[l,r],and:true});const u=new s({filters:[t,o,a],and:false});i.filter([u])}else{i.filter([])}};u.prototype._redirectToExtensibilityAction=function(t){this.fireTriggerExtensibilityAction({actionKey:t});this._oDialogPromise.then(function(t){t.close()})};u.prototype.setTitle=async function(e){t.prototype.setProperty.call(this,"title",e,true);const i=await this._oDialogPromise;i.setTitle(e)};u.prototype.setExtensibilityOptions=function(t){const e=t.UITexts.options;this._oDialogModel.setProperty("/extensibilityOptions",e);if(e.length===1){this._oDialogModel.setProperty("/customFieldButtonText",e[0].text);if(e[0]?.tooltip){this._oDialogModel.setProperty("/customFieldButtonTooltip",e[0].tooltip)}this.setCustomFieldButtonVisible(true)}else{this._oDialogModel.setProperty("/extensibilityMenuButtonActive",true);this._oDialogModel.setProperty("/extensibilityMenuButtonText",t.UITexts.buttonText);this._oDialogModel.setProperty("/extensibilityMenuButtonTooltip",t.UITexts.tooltip)}};u.prototype.getExtensibilityOptions=function(){return this._oDialogModel.getProperty("/extensibilityOptions")};u.prototype._setBusinessContextVisible=function(t){this.setProperty("businessContextVisible",t,true);this._oDialogModel.setProperty("/businessContextVisible",t)};u.prototype.addExtensibilityInfo=function(t){const e=t?.extensionData;this._removeExtensionDataTexts();const i=this._oDialogModel.getObject("/businessContextTexts");if(e&&e.length>0){e.forEach(function(t){i.push({text:t.description})},this)}else{i.push({text:p.getProperty("MSG_NO_BUSINESS_CONTEXTS")})}this._setBusinessContextVisible(true);this._oDialogModel.setProperty("/businessContextTexts/0/text",t?.UITexts?.headerText)};u.prototype._removeExtensionDataTexts=function(){const t=this._oDialogModel.getObject("/businessContextTexts");t.splice(1)};return u});
//# sourceMappingURL=AddElementsDialog.js.map