/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/base/Log","sap/ui/base/DesignTime","sap/ui/core/util/reflection/JsControlTreeModifier","sap/ui/dt/OverlayRegistry","sap/ui/dt/Util","sap/ui/fl/write/api/PersistenceWriteAPI","sap/ui/fl/Utils","sap/ui/rta/plugin/annotations/AnnotationChangeDialog","sap/ui/rta/plugin/annotations/AnnotationTypes","sap/ui/rta/plugin/Plugin"],function(e,t,n,i,o,a,s,r,l,c){"use strict";async function u(e,t,n,i){const o=await this.getCommandFactory().getCommandFor(e,"composite");for(const a of n){const n=await this.getCommandFactory().getCommandFor(e,"annotation",{changeType:t.changeType,serviceUrl:a.serviceUrl,content:{...a.content,objectTemplateInfo:t.objectTemplateInfo},changesToDelete:i});o.addCommand(n)}if(o.getCommands().length>0){this.fireElementModified({command:o})}}function p(t,n,i){const o=n.title;const a=i||t.getElement();if(o){if(typeof o==="function"){return o(a)}const e=t.getDesignTimeMetadata()?.getLibraryText(a,o);if(e){return e}}e.error("Annotation action title is not properly defined in the designtime metadata");return undefined}function g(t){const n=t.type===l.StringType?"sap-icon://edit":"sap-icon://request";const i=t.icon;if(!i){return n}if(typeof i!=="string"){e.error("Icon setting for annotation action should be a string");return n}return i}function d(t){if(t.singleRename&&!t.controlBasedRenameChangeType){e.error("When using singleRename, controlBasedRenameChangeType must also be defined");return false}return true}const f=c.extend("sap.ui.rta.plugin.annotations.AnnotationPlugin",{metadata:{library:"sap.ui.rta",associations:{},events:{}}});const h="CTX_ANNOTATION";const y="CTX_ANNOTATION_CHANGE_SINGLE_LABEL";f.prototype.init=function(...e){c.prototype.init.apply(this,e);this._oDialog=new r};f.prototype._isEditable=function(e){if(t.isDesignModeEnabled()){return false}const n=this.getAction(e);if(n){return Object.values(n).some(e=>e.changeType)}return false};f.prototype.isEnabled=function(e){if(e.length!==1){return false}const t=e[0];const n=this.getResponsibleElementOverlay(t);const i=this.getAction(n);if(i){return Object.values(i).some(e=>{if(typeof e.isEnabled!=="undefined"){if(typeof e.isEnabled==="function"){return e.isEnabled(n.getElement())}return e.isEnabled}return true})}return false};f.prototype.handler=async function(e,t){const i=e[0];const r=i.getElement();try{const e=await this._oDialog.openDialogAndHandleChanges({title:p(i,t),type:t.type,control:r,delegate:t.delegate,annotation:t.annotation,description:t.description,singleRename:t.singleRename,controlBasedRenameChangeType:t.controlBasedRenameChangeType});if(e.length){const i=[];if(t.singleRename){const e=await a._getUIChanges({selector:r});const o=s.getAppComponentForControl(r);i.push(...e.filter(e=>e.getChangeType()===t.controlBasedRenameChangeType&&n.getControlIdBySelector(e.getSelector(),o)===r.getId()))}return u.call(this,r,t,e,i)}return undefined}catch(e){throw o.propagateError(e,"AnnotationPlugin#handler","Error occurred during handler execution","sap.ui.rta.plugin.annotations.AnnotationPlugin")}};f.prototype.getMenuItems=async function(e){const t=e[0];const n=this.getResponsibleElementOverlay(t);const i=this.getAction(n);const o=[];if(i){if(this._isEditableByPlugin(n)===undefined){await this.evaluateEditable([n],{onRegistration:false})}Object.entries(i).forEach(function([t,i],a){const s=i.type===l.StringType&&i.singleRename?y:h;const r=this.getRank(s);if(this.isAvailable([n])&&d(i)){const l=p(n,i);if(!l){return}o.push({id:`${s}_${t}`,rank:r+a,text:l,icon:g(i),enabled:typeof i.isEnabled==="function"&&i.isEnabled(e[0].getElement())||i.isEnabled!==false&&this.isEnabled(e),handler:this.handler.bind(this,e,i),additionalInfo:this._getAdditionalInfo(n,i)})}},this)}return o};f.prototype.getActionName=function(){return"annotation"};f.prototype.destroy=function(...e){c.prototype.destroy.apply(this,e);this._oDialog.destroy();delete this._oDialog};return f});
//# sourceMappingURL=AnnotationPlugin.js.map