/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/base/Log","sap/m/Token","sap/ui/core/mvc/Controller","sap/ui/core/Element","sap/ui/core/Lib","sap/ui/core/library","sap/ui/rta/util/validateText","sap/ui/fl/util/IFrame","sap/ui/model/Filter","sap/ui/model/FilterOperator","sap/ui/rta/plugin/iframe/urlCleaner"],function(e,t,r,a,i,s,o,l,n,d,u){"use strict";var{ValueState:c}=s;const _=i.getResourceBundleFor("sap.ui.rta");var g=["frameUrl","title"];var p=["frameWidth","frameHeight"];var h=["frameWidthUnit","frameHeightUnit","advancedSettings"];function R(e){if(typeof e!=="string"||e.trim()===""){return{result:false,error:l.VALIDATION_ERROR.INVALID_URL}}return l.isValidUrl(encodeURI(e))}function v(e){const r=e.text;return new t({key:r,text:r})}return r.extend("sap.ui.rta.plugin.iframe.AddIFrameDialogController",{constructor:function(e,t){this._oJSONModel=e;this._importSettings(t)},configureMultiInput(){const e=a.getElementById("sapUiRtaAddIFrameDialog_AddAdditionalParametersInput");e.addValidator(v)},onSwitchChange(){this._oJSONModel.setProperty("/settingsUpdate/value",true)},onTokenUpdate(e){let t=this._oJSONModel.getProperty("/advancedSettings/value/additionalSandboxParameters");if(e.getParameter("type")==="added"){e.getParameter("addedTokens").forEach(function(e){t=[...t,e.getText()]})}else if(e.getParameter("type")==="removed"){e.getParameter("removedTokens").forEach(function(e){t=t.filter(function(t){return t!==e.getText()})})}this._oJSONModel.setProperty("/advancedSettings/value/additionalSandboxParameters",t);this._oJSONModel.setProperty("/settingsUpdate/value",true)},onValidationSuccess(e){e.getSource().setValueState(c.None);this._oJSONModel.setProperty("/areAllFieldsValid",this._areAllTextFieldsValid()&&this._areAllValueStateNones())},onValidationError(e){e.getSource().setValueState(c.Error);this._oJSONModel.setProperty("/areAllFieldsValid",false);this._setFocusOnInvalidInput()},onSavePress(){const e=this._buildPreviewURL();if(R(e).result&&this._areAllTextFieldsValid()&&this._areAllValueStateNones()){this._close(this._buildReturnedSettings())}else{this._setFocusOnInvalidInput()}},onShowPreview(){const t=this._buildReturnedURL();const r=this._buildPreviewURL();if(!R(r).result){return}const i=a.getElementById("sapUiRtaAddIFrameDialog_PreviewFrame");const s=a.getElementById("sapUiRtaAddIFrameDialog_PreviewLinkPanel");const o=s.getDependents()[0];if(r){o.setEnabled(true)}else{s.setExpanded(false);o.setEnabled(false)}try{this._oJSONModel.setProperty("/previousFrameUrl/value",t);this._oJSONModel.setProperty("/settingsUpdate/value",false);i.applySettings({url:r,advancedSettings:{...this._oJSONModel.getProperty("/advancedSettings/value")}});this._oJSONModel.setProperty("/previewUrl/value",i.getUrl())}catch(t){e.error("Error previewing the URL: ",t)}},onParameterPress(e){const t=e.getSource().getBindingContext("dialogInfo").getObject();this._oJSONModel.setProperty("/frameUrl/value",this._addURLParameter(t));this.onValidateUrl()},onLiveChange(e){var t=new n("label",d.Contains,e.getParameter("newValue"));var r=a.getElementById("sapUiRtaAddIFrameDialog_ParameterTable").getBinding("items");r.filter([t])},_buildPreviewURL(){const e=this._buildReturnedURL();const t=a.getElementById("sapUiRtaAddIFrameDialog_PreviewLinkResolver");try{t.applySettings({text:e})}catch(e){return undefined}return t.getText()},_addURLParameter(e){const t=e.key;let r;if(e.type&&e.type!=="Edm.String"){const[,e]=t.match(/\{(.+?)\}/);r=`{path:'${e}',targetType:'any'}`}else{r=t}const i=a.getElementById("sapUiRtaAddIFrameDialog_EditUrlTA");const s=i.getFocusDomRef().selectionStart;const o=i.getFocusDomRef().selectionEnd;const l=this._buildReturnedURL();return`${l.substring(0,s)}${r}${l.substring(o)}`},_buildReturnedURL(){return u(this._oJSONModel.getProperty("/frameUrl/value"))},onValidateUrl(){const e=this._buildPreviewURL();const{result:t,error:r}=R(e);if(t){this._oJSONModel.setProperty("/frameUrlError/value","")}else{const e={[l.VALIDATION_ERROR.UNSAFE_PROTOCOL]:"IFRAME_ADDIFRAME_ERROR_UNSAFE_PROTOCOL",[l.VALIDATION_ERROR.MIXED_CONTENT]:"IFRAME_ADDIFRAME_ERROR_MIXED_CONTENT",[l.VALIDATION_ERROR.FORBIDDEN_URL]:"IFRAME_ADDIFRAME_ERROR_FORBIDDEN_URL",[l.VALIDATION_ERROR.INVALID_URL]:"IFRAME_ADDIFRAME_ERROR_INVALID_URL"}[r];const t=_.getText(e);this._oJSONModel.setProperty("/frameUrlError/value",t)}},onCancelPress(){this._close()},onContainerTitleChange(e){var t=e.getSource();var r="None";var a=false;var i=t.getValue();if(i.trim()===""){r="Error";t.setValueState(r);this._oJSONModel.setProperty("/areAllFieldsValid",false);return true}try{o(i)}catch(e){r="Error";a=true}const s=this._areAllTextFieldsValid()&&this._areAllValueStateNones()&&!a;this._oJSONModel.setProperty("/areAllFieldsValid",s);t.setValueState(r);return a},_close(e){var t=a.getElementById("sapUiRtaAddIFrameDialog");this._mSettings=e;t.close()},getSettings(){return this._mSettings},_areAllValueStateNones(){var e=this._oJSONModel.getData();return g.concat(p).every(function(t){return e[t].valueState===c.None},this)},_areAllTextFieldsValid(){var e=this._oJSONModel;var t=this._oJSONModel.getProperty("asContainer/value");return g.reduce(function(r,a){if(a==="title"&&!t){return true}var i=`/${a}/value`;var s;if(e.getProperty(i).trim()===""){s=c.Error}else{s=c.None}e.setProperty(`${i}State`,s);return r&&s===c.None},true)},_buildReturnedSettings(){var e={};var t=this._oJSONModel.getData();g.concat(p,h).forEach(function(r){var a=t[r].value;if(r==="frameUrl"){a=u(a)}e[r]=a});return e},_importSettings(e){if(e){Object.keys(e).forEach(function(t){if(t==="frameWidth"||t==="frameHeight"){this._importIFrameSize(t,e[t])}else if(t==="advancedSettings"&&!e[t]){return}else{this._oJSONModel.setProperty(`/${t}/value`,e[t])}},this)}},_importIFrameSize(e,t){var r=t.split(/(px|rem|%|vh)/);if(r.length>=2){this._oJSONModel.setProperty(`/${e}/value`,parseFloat(r[0]));this._oJSONModel.setProperty(`/${e}Unit/value`,r[1])}},_setFocusOnInvalidInput(){var e=this._oJSONModel.getData();p.some(function(t){if(e[t].valueState===c.Error){var r=a.getElementById(e[t].id);r.focus();return true}return false},this)}})});
//# sourceMappingURL=AddIFrameDialogController.js.map