/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/base/ManagedObject","sap/ui/core/Element","sap/ui/core/Fragment","sap/ui/model/json/JSONModel","sap/ui/model/resource/ResourceModel","sap/ui/rta/util/validateText","sap/ui/rta/Utils"],function(e,t,o,a,i,s,n){"use strict";const l=e.extend("sap.ui.rta.plugin.rename.RenameDialog");l.prototype._createPopup=async function(){const e=await o.load({name:"sap.ui.rta.plugin.rename.RenameDialog",controller:this});e.addStyleClass(n.getRtaStyleClassName());this.oDialogModel=new a;e.setModel(this.oDialogModel);const t=new i({bundleName:"sap.ui.rta.messagebundle"});e.setModel(t,"i18n");return e};l.prototype._openPopup=function(){this._oDialog.open();const e=t.getElementById("sapUiRtaRenameDialog_input");e.getFocusDomRef().select();return new Promise(e=>{this._fnResolveAfterClose=e})};l.prototype.openDialogAndHandleRename=async function(e){this._oDialog=await this._createPopup();const t=e.overlay;const o=t.getElement();const a=t.getDesignTimeMetadata();const i=a.getAssociatedDomRef(o,e.domRef);const s=typeof e.action.getTextMutators==="function"?e.action.getTextMutators(o).getText():i.textContent;this.oDialogModel.setData({oldText:s,newText:s});this.oDialogModel.refresh(true);this.oAction=e.action;const n=await this._openPopup();const l=new Promise(e=>{this._oDialog.attachAfterClose(()=>{this._oDialog.destroy();e()})});this._oDialog.close();await l;return n};const r={VALID:"VALID",INVALID:"INVALID",SAME_TEXT:"SAME_TEXT"};l.prototype.checkValidRename=function(){const e=this.oDialogModel.getData();const t=e.newText||"";const o=e.oldText||"";try{s(t,o,this.oAction);this.oDialogModel.setProperty("/validationError",undefined);return r.VALID}catch(e){if(e.message==="sameTextError"){this.oDialogModel.setProperty("/validationError",undefined);return r.SAME_TEXT}this.oDialogModel.setProperty("/validationError",e.message);this.oDialogModel.setProperty("/isValidRename",false);return r.INVALID}};l.prototype.onTextChange=function(e){const t=e.getParameter("value").trim("");this.oDialogModel.setProperty("/newText",t.length?t:" ");this.checkValidRename()};l.prototype.onSave=function(){if(this.checkValidRename()===r.VALID){this._fnResolveAfterClose(this.oDialogModel.getData().newText)}else if(this.checkValidRename()===r.SAME_TEXT){this._fnResolveAfterClose()}};l.prototype.onCancel=function(){this._fnResolveAfterClose()};l.prototype.destroy=function(...t){e.prototype.destroy.apply(this,t);if(this._oDialog){this._oDialog.destroy()}};return l});
//# sourceMappingURL=RenameDialog.js.map