/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/base/Log","sap/m/MessageBox","sap/m/MessageStrip","sap/m/Popover","sap/ui/core/message/MessageType","sap/ui/core/BusyIndicator","sap/ui/core/Element","sap/ui/core/Fragment","sap/ui/core/Popup","sap/ui/fl/apply/api/FlexRuntimeInfoAPI","sap/ui/fl/initial/api/Version","sap/ui/fl/write/api/ContextBasedAdaptationsAPI","sap/ui/model/json/JSONModel","sap/ui/performance/Measurement","sap/ui/rta/appVariant/Feature","sap/ui/rta/toolbar/contextBased/ManageAdaptations","sap/ui/rta/toolbar/contextBased/SaveAsAdaptation","sap/ui/rta/toolbar/translation/Translation","sap/ui/rta/toolbar/versioning/Versioning","sap/ui/rta/toolbar/AdaptationRenderer","sap/ui/rta/toolbar/Base","sap/ui/rta/util/guidedTour/content/GeneralTour","sap/ui/rta/util/guidedTour/GuidedTour","sap/ui/rta/util/whatsNew/WhatsNewOverview","sap/ui/rta/Utils"],function(t,e,i,o,n,s,r,a,h,c,d,l,u,p,f,g,b,_,m,A,I,T,v,w,D){"use strict";var R=I.extend("sap.ui.rta.toolbar.Adaptation",{renderer:A,animation:true,metadata:{library:"sap.ui.rta",events:{undo:{},redo:{},exit:{},save:{},restore:{},publishVersion:{},modeChange:{},activate:{},discardDraft:{},switchVersion:{},switchAdaptation:{},deleteAdaptation:{},openChangeCategorySelectionPopover:{},saveAndReload:{}}}});R.LEFT_SECTION="toolbarIconAndDraftSection";R.MIDDLE_SECTION="toolbarSwitcherSection";R.RIGHT_SECTION="toolbarActionsSection";var S=124;R.prototype.init=function(...t){this._mSizeLimits={switchToIcons:undefined};I.prototype.init.apply(this,t);this._pFragmentLoaded=this._pFragmentLoaded.then(function(){this._onResize=this._onResize.bind(this);window.addEventListener("resize",this._onResize);this._aIntersectionObservers=[]}.bind(this))};R.prototype._calculateWindowWidth=function(t){var e=t[0].intersectionRect.width;return e*2+this._iSwitcherToolbarWidth+80};R.prototype.exit=function(...t){window.removeEventListener("resize",this._onResize);this._aIntersectionObservers.forEach(function(t){t.disconnect()});I.prototype.exit.apply(this,t)};R.prototype._restoreHiddenElements=function(){delete this._iOnResizeAnimationFrame;if(window.innerWidth>this._mSizeLimits.switchToIcons){this._switchToTexts();delete this._mSizeLimits.switchToIcons}};R.prototype._onResize=function(){if(this._iOnResizeAnimationFrame){window.cancelAnimationFrame(this._iOnResizeAnimationFrame)}this._iOnResizeAnimationFrame=window.requestAnimationFrame(this._restoreHiddenElements.bind(this))};R.prototype.initialAdjustToolbarSectionWidths=function(){var t=this.getControl("modeSwitcher").getDomRef().getBoundingClientRect().width;this._iSwitcherToolbarWidthWithTexts=t+16;this._iSwitcherToolbarWidth=this._iSwitcherToolbarWidthWithTexts;this.adjustToolbarSectionWidths()};R.prototype.adjustToolbarSectionWidths=function(){this.getControl(R.MIDDLE_SECTION).setWidth(`${this._iSwitcherToolbarWidth}px`);[R.LEFT_SECTION,R.RIGHT_SECTION].forEach(function(t){this.getControl(t).getDomRef().style.setProperty("width",`calc(50% - ${Math.ceil(this._iSwitcherToolbarWidth/2)}px)`,"important")}.bind(this))};R.prototype._observeIntersections=function(){this._aIntersectionObservers.forEach(function(t){t.disconnect()});[R.LEFT_SECTION,R.RIGHT_SECTION].forEach(function(t){var e=this._createIntersectionObserver(t);this._observeToolbarIntersection(t,e);this._aIntersectionObservers.push(e)}.bind(this))};R.prototype._hideElementsOnIntersection=function(t,e){if(e[0].intersectionRatio===0){this.adjustToolbarSectionWidths();this._observeIntersections();return}if(e[0].intersectionRatio<1){if(!this._mSizeLimits.switchToIcons){this._mSizeLimits.switchToIcons=this._calculateWindowWidth(e);this._switchToIcons()}}};R.prototype._createIntersectionObserver=function(t){return new IntersectionObserver(this._hideElementsOnIntersection.bind(this,t),{threshold:1,root:this.getControl(t).getDomRef()})};R.prototype._observeToolbarIntersection=function(t,e){var i=this.getControl(t);i.getItems().map(function(t){var i=t.getDomRef();e.observe(i)})};R.prototype.show=function(){return I.prototype.show.call(this,this.initialAdjustToolbarSectionWidths.bind(this)).then(function(){this._observeIntersections()}.bind(this))};function y(t,e,i,o){var n=this.getControl(t);var s=i?this.getTextResources().getText(i):"";var r=o?this.getTextResources().getText(o):"";n.setText(s||"");n.setTooltip(r||"");n.setIcon(e||"")}R.prototype.formatPublishVersionVisibility=function(t,e,i,o){return this.getExtension("versioning",m).formatPublishVersionVisibility(t,e,i,o)};R.prototype.formatDiscardDraftVisible=function(t,e,i){return this.getExtension("versioning",m).formatDiscardDraftVisible(t,e,i)};R.prototype.formatVersionButtonText=function(t,e){return this.getExtension("versioning",m).formatVersionButtonText(t,e)};R.prototype.showVersionHistory=function(t){return this.getExtension("versioning",m).showVersionHistory(t)};R.prototype._openVersionTitleDialog=function(t){return this.getExtension("versioning",m).openActivateVersionDialog(t)};R.prototype.showHardReloadInfoPopover=function(t){this._oHardReloadInfoPopover||=new o({placement:"Bottom",content:[new i({text:this.getTextResources().getText("MSG_HARD_RELOAD_INFO"),type:n.Warning,showIcon:true})],showHeader:false,contentWidth:"18rem"});this.addDependent(this._oHardReloadInfoPopover);this._oHardReloadInfoPopover.openBy(t.getSource())};R.prototype.showActionsMenu=function(t){var e=t.getSource();if(!this._oActionsMenuFragment){return a.load({id:`${this.getId()}_actionsMenu_fragment`,name:"sap.ui.rta.toolbar.ActionsMenu",controller:{openDownloadTranslationDialog:x.bind(this),openUploadTranslationDialog:C.bind(this),manageApps:z.bind(this),overviewForKeyUser:W.bind(this),overviewForDeveloper:k.bind(this),restore:this.eventHandler.bind(this,"Restore"),formatSaveAsEnabled:E,saveAs:O.bind(this),openWhatsNewOverviewDialog:U,openGuidedTour:$}}).then(function(t){t.addStyleClass(D.getRtaStyleClassName());this.addDependent(t);t.openBy(e,true,h.Dock.CenterTop,h.Dock.CenterBottom);this._oActionsMenuFragment=t}.bind(this))}this._oActionsMenuFragment.openBy(e,true,h.Dock.CenterTop,h.Dock.CenterBottom);return Promise.resolve()};R.prototype._showButtonIcon=function(t,e,i){y.call(this,t,e,"",i)};R.prototype._showButtonText=function(t,e){y.call(this,t,"",e,"")};R.prototype._switchToIcons=function(){this._showButtonIcon("adaptationSwitcherButton","sap-icon://wrench","BTN_ADAPTATION");this._showButtonIcon("navigationSwitcherButton","sap-icon://explorer","BTN_NAVIGATION");this._showButtonIcon("visualizationSwitcherButton","sap-icon://show","BTN_VISUALIZATION");this._iSwitcherToolbarWidth=S;this.adjustToolbarSectionWidths()};R.prototype._switchToTexts=function(){this._showButtonText("adaptationSwitcherButton","BTN_ADAPTATION");this._showButtonText("navigationSwitcherButton","BTN_NAVIGATION");this._showButtonText("visualizationSwitcherButton","BTN_VISUALIZATION");this._iSwitcherToolbarWidth=this._iSwitcherToolbarWidthWithTexts;this.adjustToolbarSectionWidths()};R.prototype.buildControls=function(){return a.load({name:"sap.ui.rta.toolbar.Adaptation",id:`${this.getId()}_fragment`,controller:{activate:this._openVersionTitleDialog.bind(this),discardDraft:this.eventHandler.bind(this,"DiscardDraft"),formatDiscardDraftVisible:this.formatDiscardDraftVisible.bind(this),formatPublishVersionVisibility:this.formatPublishVersionVisibility.bind(this),modeChange:this.eventHandler.bind(this,"ModeChange"),undo:this.eventHandler.bind(this,"Undo"),redo:this.eventHandler.bind(this,"Redo"),openChangeCategorySelectionPopover:this.eventHandler.bind(this,"OpenChangeCategorySelectionPopover"),saveAsAdaptation:N.bind(this),editAdaptation:F.bind(this),deleteAdaptation:P.bind(this),manageAdaptations:L.bind(this),switchAdaptation:G.bind(this),formatAdaptationsMenuText:H.bind(this),publishVersion:this.eventHandler.bind(this,"PublishVersion"),save:this.eventHandler.bind(this,"Save"),exit:this.eventHandler.bind(this,"Exit"),formatVersionButtonText:this.formatVersionButtonText.bind(this),showVersionHistory:this.showVersionHistory.bind(this),showActionsMenu:this.showActionsMenu.bind(this),showFeedbackForm:this.showFeedbackForm.bind(this),showHardReloadInfoPopover:this.showHardReloadInfoPopover.bind(this),saveAndReloadApp:this.eventHandler.bind(this,"SaveAndReload")}})};function x(){var t={layer:this.getRtaInformation().flexSettings.layer,selector:this.getRtaInformation().rootControl};this.getExtension("translation",_).openDownloadTranslationDialog(t)}function C(){this.getExtension("translation",_).openUploadTranslationDialog()}function E(t,e){return t&&e!==d.Number.Draft}function O(){f.onSaveAs(true,true,this.getRtaInformation().flexSettings.layer,null)}function M(t){var i=t.commandStack.canSave();return D.showMessageBox("confirm",i?"DAC_DIALOG_MIGRATION_DIRTY_DESCRIPTION":"DAC_DIALOG_MIGRATION_DESCRIPTION",{titleKey:"DAC_DIALOG_MIGRATION_HEADER",actionKeys:["DAC_DIALOG_MIGRATION_HEADER"],showCancel:true}).then(function(o){if(o!==e.Action.CANCEL){if(i){return new Promise(function(t){this.fireEvent("save",{callback:t})}.bind(this)).then(function(){return B.call(this,t)}.bind(this))}return B.call(this,t)}}.bind(this))}function B(e){s.show();p.start("onCBAMigration","Measurement of migration to context-based adaptation");return l.migrate({control:e.rootControl,layer:e.flexSettings.layer}).finally(function(){p.end("onCBAMigration");p.getActive()&&t.info(`onCBAMigration: ${p.getMeasurement("onCBAMigration").time} ms`);s.hide()}).then(D.showMessageBox.bind(undefined,"information","DAC_DIALOG_MIGRATION_SUCCESSFULL_DESCRIPTION",{titleKey:"DAC_DIALOG_MIGRATION_HEADER"})).then(function(){return new Promise(function(t){this.fireEvent("switchAdaptation",{adaptationId:"DEFAULT",callback:t})}.bind(this))}.bind(this)).catch(function(e){t.error(e.stack||e);var i="DAC_DIALOG_MIGRATION_ERROR_DESCRIPTION";var o={titleKey:"DAC_DIALOG_MIGRATION_HEADER",details:e.userMessage||e};D.showMessageBox("error",i,o)})}function N(){var e=this.getRtaInformation();D.checkDraftOverwrite(this.getModel("versions")).then(function(){p.start("onCBACanMigrate","Measurement if its possible to migrate to context-based adaptation");return l.canMigrate({control:e.rootControl,layer:e.flexSettings.layer})}).then(function(i){p.end("onCBACanMigrate");p.getActive()&&t.info(`onCBACanMigrate: ${p.getMeasurement("onCBACanMigrate").time} ms`);if(i){M.call(this,e)}else{this.getExtension("contextBasedSaveAs",b).openAddAdaptationDialog(e.flexSettings.layer)}}.bind(this)).catch(V)}function F(){D.checkDraftOverwrite(this.getModel("versions")).then(function(){this.getExtension("contextBasedSaveAs",b).openAddAdaptationDialog(this.getRtaInformation().flexSettings.layer,true)}.bind(this)).catch(V)}function V(e){if(e!=="cancel"){D.showMessageBox("error","MSG_LREP_TRANSFER_ERROR",{error:e});t.error(`sap.ui.rta: ${e.stack||e.message||e}`)}}function P(){D.checkDraftOverwrite(this.getModel("versions")).then(function(){this.fireEvent("deleteAdaptation")}.bind(this)).catch(V)}function L(){this.getExtension("contextBasedManage",g).openManageAdaptationDialog()}function G(t){this.fireEvent("switchAdaptation",{adaptationId:t})}function H(t,e){if(t>0){if(e===""){return this.getTextResources().getText("TXT_DEFAULT_APP")}return this.getTextResources().getText("BTN_ADAPTING_FOR",[e])}return this.getTextResources().getText("BTN_ADAPTING_FOR_ALL_USERS")}function W(){return f.onGetOverview(true,this.getRtaInformation().flexSettings.layer)}function k(){return f.onGetOverview(false,this.getRtaInformation().flexSettings.layer)}function z(){f.onGetOverview(true,this.getRtaInformation().flexSettings.layer)}function U(){w.openWhatsNewOverviewDialog()}function $(){(new v).start(T.getTourContent())}R.prototype.getControl=function(t){var e=r.getElementById(`${this.getId()}_fragment--sapUiRta_${t}`);if(!e&&this._oActionsMenuFragment){e=r.getElementById(this._oActionsMenuFragment.getId().replace("sapUiRta_actions","sapUiRta_")+t)}return e};R.prototype.hide=function(...t){this._aIntersectionObservers.forEach(function(t){t.disconnect()});return I.prototype.hide.apply(this,t)};R.prototype.showFeedbackForm=async function(){const e="https://sapinsights.eu.qualtrics.com/jfe/form/";const i="SV_4MANxRymEIl9K06";const o=e+i;const n=new URLSearchParams;const s={rootControl:this.getRtaInformation().rootControl};const r=await c.getFeedbackInformation(s);n.set("version",r.version);n.set("feature",r.connector==="KeyUserConnector"?"BTP":"ABAP");n.set("appId",r.appId);n.set("appVersion",r.appVersion);var h=new u({url:`${o}?${n.toString()}`});return a.load({name:"sap.ui.rta.toolbar.FeedbackDialog",controller:this}).then(function(t){this._oFeedbackDialog=t;this._oFeedbackDialog.addStyleClass(D.getRtaStyleClassName());this._oFeedbackDialog.setModel(h,"feedbackModel");this._oFeedbackDialog.setModel(this.getModel("i18n"),"i18n");this._oFeedbackDialog.open()}.bind(this)).catch(function(e){t.error("Error loading fragment sap.ui.rta.toolbar.FeedbackDialog: ",e)})};R.prototype.closeFeedbackForm=function(){if(this._oFeedbackDialog){this._oFeedbackDialog.close();this._oFeedbackDialog.destroy()}};return R});
//# sourceMappingURL=Adaptation.js.map