/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/base/i18n/Localization","sap/base/util/restricted/_isEqual","sap/base/util/restricted/_union","sap/base/Log","sap/ui/base/ManagedObject","sap/ui/core/Fragment","sap/ui/fl/write/api/ContextBasedAdaptationsAPI","sap/m/ColumnListItem","sap/ui/rta/Utils","sap/ui/model/Filter","sap/ui/model/FilterOperator","sap/ui/model/json/JSONModel","sap/ui/core/date/UI5Date","sap/ui/performance/Measurement"],function(t,e,a,o,n,i,s,r,l,d,c,p,u,g){"use strict";var h={Initial:0,Default:1024,Before(t){return t+1024},Between(t,e){return(t+e)/2},After(t){return t+.5}};var f=n.extend("sap.ui.rta.toolbar.contextBased.ManageAdaptations",{metadata:{properties:{toolbar:{type:"any"}}},constructor:function(...t){n.prototype.constructor.apply(this,t);this.oTextResources=this.getToolbar().getTextResources()}});f.prototype.openManageAdaptationDialog=function(){g.start("onCBAOpenManageAdaptationDialog","Measurement of opening the manage context-based adaptation dialog");if(!this._oManageAdaptationDialogPromise){this._oManageAdaptationDialogPromise=i.load({name:"sap.ui.rta.toolbar.contextBased.ManageAdaptationsDialog",id:`${this.getToolbar().getId()}_fragment--sapUiRta_manageAdaptationDialog`,controller:{formatContextColumnCell:A.bind(this),formatContextColumnTooltip:m.bind(this),formatCreatedChangedOnColumnCell:C.bind(this),onLiveSearch:_.bind(this),moveUp:v.bind(this),moveDown:P.bind(this),onDropSelectedAdaptation:S.bind(this),onSaveReorderedAdaptations:V.bind(this),isAdaptationsSelected:k.bind(this),getIndexOfSelectedAdaptation:U.bind(this),onCancel:$.bind(this)}}).then(function(t){this._oManageAdaptationDialog=t;t.addStyleClass(l.getRtaStyleClassName());this.getToolbar().addDependent(this._oManageAdaptationDialog)}.bind(this))}else{b.call(this);N.call(this,true);D.call(this,false)}return this._oManageAdaptationDialogPromise.then(function(){this._oRtaInformation=this.getToolbar().getRtaInformation();return s.load({control:this._oRtaInformation.rootControl,layer:this._oRtaInformation.flexSettings.layer})}.bind(this)).then(function(t){this.oAdaptationsModel=s.getAdaptationsModel({control:this._oRtaInformation.rootControl,layer:this._oRtaInformation.flexSettings.layer});this.oAdaptationsModel.updateAdaptations(t.adaptations);this.oReferenceAdaptationsData=JSON.parse(JSON.stringify(this.oAdaptationsModel.getProperty("/adaptations")));this._oOriginAdaptationsData=JSON.parse(JSON.stringify(this.oAdaptationsModel.getProperty("/allAdaptations")));this._oControlConfigurationModel=new p({isTableItemSelected:false});this._oManageAdaptationDialog.setModel(this.oAdaptationsModel,"contextBased");this._oManageAdaptationDialog.setModel(this._oControlConfigurationModel,"controlConfiguration");R.call(this).attachSelectionChange(M.bind(this));g.end("onCBAOpenManageAdaptationDialog");g.getActive()&&o.info(`onCBAOpenManageAdaptationDialog: ${g.getMeasurement("onCBAOpenManageAdaptationDialog").time} ms`);return this._oManageAdaptationDialog.open()}.bind(this)).catch(function(t){o.error(t.stack);var e="MSG_LREP_TRANSFER_ERROR";var a={titleKey:"BTN_MANAGE_APP_CTX"};a.details=t.userMessage;l.showMessageBox("error",e,a)})};function A(t){return`${t.length} ${t.length>1?this.oTextResources.getText("TXT_TABLE_CONTEXT_CELL_ROLES"):this.oTextResources.getText("TXT_TABLE_CONTEXT_CELL_ROLE")}`}function m(t){return t.join("\n")}function C(e,a){var o=u.getInstance(a);var n={year:"numeric",month:"short",day:"numeric",hour:"numeric",minute:"numeric"};var i=t.getLanguage();return`${e}\n${o.toLocaleTimeString(i,n)}`}function M(t){if(t.getParameter("selected")===true){this._oControlConfigurationModel.setProperty("/isTableItemSelected",true);b.call(this)}}function b(){var t=O.call(this,"moveUpButton");var e=O.call(this,"moveDownButton");if(w.call(this)){if(k.call(this)){t.setEnabled(U.call(this)>0);e.setEnabled(U.call(this)<this.oAdaptationsModel.getProperty("/count")-1)}else{t.setEnabled(false);e.setEnabled(false)}}else{t.setEnabled(false);e.setEnabled(false)}}function _(t){var e;var a=t.getSource().getValue();var o=R.call(this);var n=E.call(this);var i=I.call(this);if(a&&a.length>0){b.call(this);N.call(this,false);var s=new d("title",c.Contains,a);var r=new d({path:"contexts/role",test(t){return t.some(function(t){return t.includes(a.toUpperCase())})}});var l=new d("createdBy",c.Contains,a);var p=new d("changedBy",c.Contains,a);e=new d([s,r,l,p]);if(i.toUpperCase().includes(a.toUpperCase())){n.setVisible(true)}else{n.setVisible(false)}}else{N.call(this,true);if(this._oControlConfigurationModel.getProperty("/isTableItemSelected")){b.call(this)}n.setVisible(true)}var u=o.getBinding("items");u.filter(e,"Application")}function v(t){x.call(this,"Up");t.getSource().focus()}function P(t){x.call(this,"Down");t.getSource().focus()}function y(t,e){return t.rank-e.rank}function T(t){var e=t.getProperty("/adaptations")||[];e.sort(y);t.setProperty("/adaptations",e);t.refresh(true)}function x(t){var e=R.call(this);var a=e.getSelectedItem(0);var o=a.getBindingContext("contextBased");var n=e.indexOfItem(a)+(t==="Up"?-1:1);var i=e.getItems()[n];var s=i?i.getBindingContext("contextBased"):undefined;if(!s){return}var r=s.getProperty("rank");var l=o.getProperty("rank");this.oAdaptationsModel.setProperty("rank",r,o);this.oAdaptationsModel.setProperty("rank",l,s);T(this.oAdaptationsModel);e.getItems()[n].setSelected(true).focus();D.call(this,B.call(this));b.call(this)}function S(t){const e=t.getParameter("draggedControl");const o=e.getBindingContext("contextBased");if(!o){return}let n=h.Default;const i=t.getParameter("droppedControl");if(i instanceof r){const e=t.getParameter("dropPosition");const a=i.getBindingContext("contextBased");const s=a.getProperty("rank");const r=i.getParent();const l=r.indexOfItem(i);if(a===o){return}const d=l+(e==="After"?1:-1);const c=r.getItems()[d];if(!c||d===-1){n=d===-1?.5:h[e](s)}else{const t=c.getBindingContext("contextBased");n=h.Between(s,t.getProperty("rank"))}}this.oAdaptationsModel.setProperty("rank",n,o);T(this.oAdaptationsModel);const s=a(this.oAdaptationsModel.getProperty("/adaptations"),this.oAdaptationsModel.getProperty("/allAdaptations"));this.oAdaptationsModel.updateAdaptations(s);D.call(this,B.call(this))}function B(){return!e(this.oAdaptationsModel.getProperty("/adaptations").map(function(t){return t.id}),this.oReferenceAdaptationsData.map(function(t){return t.id}))}function D(t){var e=O.call(this,"manageAdaptations-saveButton");e.setTooltip(t?"":this.oTextResources.getText("TOOLTIP_APP_CTX_DIALOG_SAVE"));e.setEnabled(t)}function R(){return O.call(this,"manageAdaptationsTable")}function O(t){return this.getToolbar().getControl(`manageAdaptationDialog--${t}`)}function E(){return O.call(this,"defaultContext")}function I(){return O.call(this,"defaultApplicationTitle").getProperty("text")}function L(){return O.call(this,"searchField")}function w(){return L.call(this).getValue().length===0}function N(t){R.call(this).getDragDropConfig()[0].setEnabled(t)}function k(){var t=R.call(this);return t.getSelectedContextPaths().length>0}function U(){var t=R.call(this);if(t.getSelectedContextPaths().length>0){var e=t.getSelectedContextPaths()[0].split("/");var a=Number(e[e.length-1]);return a}return-1}function V(){l.checkDraftOverwrite(this.getToolbar().getModel("versions")).then(function(){var t=this.getToolbar().getRtaInformation();var e=this.oAdaptationsModel.getProperty("/adaptations").map(function(t){return t.id});return s.reorder({control:t.rootControl,layer:t.flexSettings.layer,parameters:{priorities:e}})}.bind(this)).then(function(){const t=a(this.oAdaptationsModel.getProperty("/adaptations"),this.oAdaptationsModel.getProperty("/allAdaptations"));this.oAdaptationsModel.updateAdaptations(t);X.call(this)}.bind(this)).catch(function(t){if(t!=="cancel"){l.showMessageBox("error","MSG_LREP_TRANSFER_ERROR",{titleKey:"BTN_MANAGE_APP_CTX",error:t});o.error(`sap.ui.rta: ${t.stack||t.message||t}`)}})}function $(){this.oAdaptationsModel.updateAdaptations(this._oOriginAdaptationsData);X.call(this)}function X(){this._oControlConfigurationModel.setProperty("/isTableItemSelected",false);L.call(this).setValue("");var t=R.call(this);t.getBinding("items").filter([]);t.removeSelections();E.call(this).setVisible(true);this._oManageAdaptationDialog.close()}return f});
//# sourceMappingURL=ManageAdaptations.js.map