/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/base/ManagedObject","sap/base/Log","sap/base/strings/formatMessage","sap/ui/core/BusyIndicator","sap/ui/core/Element","sap/ui/core/Fragment","sap/ui/core/library","sap/ui/fl/Layer","sap/ui/fl/write/api/ContextBasedAdaptationsAPI","sap/ui/fl/write/api/ContextSharingAPI","sap/ui/rta/Utils","sap/ui/model/json/JSONModel","sap/ui/performance/Measurement"],function(t,e,o,i,a,n,s,r,d,l,p,h,g){"use strict";var{ValueState:u}=s;var c=t.extend("sap.ui.rta.toolbar.contextBased.SaveAsAdaptation",{metadata:{properties:{toolbar:{type:"any"}}},constructor:function(...e){t.prototype.constructor.apply(this,e);this.oTextResources=this.getToolbar().getTextResources()}});c.prototype.openAddAdaptationDialog=function(t,e){this._bIsEditMode=e;if(!this._oAddAdaptationDialogPromise){this._oAddAdaptationDialogPromise=n.load({name:"sap.ui.rta.toolbar.contextBased.SaveAsAdaptationDialog",id:`${this.getToolbar().getId()}_fragment--sapUiRta_addAdaptationDialog`,controller:{onAdaptationTitleChange:f.bind(this),onSaveAsAdaptation:T.bind(this),onCancelAdaptationDialog:x.bind(this),onPriorityChange:E.bind(this)}}).then(function(t){this._oAddAdaptationDialog=t;this._oAddAdaptationDialog.attachBeforeClose(R.bind(this));t.addStyleClass(p.getRtaStyleClassName());this.getToolbar().addDependent(this._oAddAdaptationDialog);this.oDialogModel=new h;this._oAddAdaptationDialog.setModel(this.oDialogModel,"dialogModel")}.bind(this))}else{var o=this.getToolbar().getControl("addAdaptationDialog--saveAdaptation-title-input");o.setValue("");o.setValueState(u.None)}return this._oAddAdaptationDialogPromise.then(function(){return v.call(this,t)}.bind(this)).then(function(){var t=this.getToolbar().getRtaInformation();this.oAdaptationsModel=d.getAdaptationsModel({control:t.rootControl,layer:t.flexSettings.layer});if(e){C.call(this)}else{this.oDialogModel.setProperty("/title",this.oTextResources.getText("SAC_DIALOG_HEADER"));this.oDialogModel.refresh(true)}return A.call(this)}.bind(this))};function A(){_.call(this,this.oAdaptationsModel.getProperty("/adaptations"));return this._oAddAdaptationDialog.open()}function C(){this.oDialogModel.setProperty("/title",this.oTextResources.getText("EAC_DIALOG_HEADER"));this.oDialogModel.refresh(true);var t=this.oAdaptationsModel.getProperty("/displayedAdaptation");this._mEditProperties={adaptationId:t.id,title:t.title,priority:t.rank-1,roles:t.contexts.role};this.getToolbar().getControl("addAdaptationDialog--saveAdaptation-title-input").setValue(this._mEditProperties.title);this._oContextComponentInstance.setSelectedContexts({role:this._mEditProperties.roles})}function _(t){var e=[{key:"0",title:this.oTextResources.getText("TXT_SELECT_FIRST_PRIO")}];var i=this.oTextResources.getText("TXT_SELECT_PRIO");var a=this._mEditProperties?this._mEditProperties.priority:undefined;t.forEach(function(t,n){if(a!==undefined&&a===n){return}var s=e.length;e.push({key:s.toString(),title:o(i,[t.title,s+1])})});this.oDialogModel.setProperty("/selected",a?e[a].key:e[0].key);this.oDialogModel.setProperty("/priority",e)}function f(){y.call(this);b.call(this)}function m(){b.call(this)}function x(){this._oAddAdaptationDialog.close()}function T(){var t={};t.title=S.call(this);t.contexts=this._oContextComponentInstance.getSelectedContexts();t.priority=D.call(this);var o=this.getToolbar().getRtaInformation();if(this._bIsEditMode){g.start("onCBAUpdateAdaptation","Measurement of updating a context-based adaptation");t.adaptationId=this._mEditProperties.adaptationId;d.update({control:o.rootControl,layer:o.flexSettings.layer,contextBasedAdaptation:t,adaptationId:this._mEditProperties.adaptationId}).then(function(t,o){if(o.status===200){this.oAdaptationsModel.updateAdaptationContent(t);g.end("onCBAUpdateAdaptation");g.getActive()&&e.info(`onCBAUpdateAdaptation: ${g.getMeasurement("onCBAUpdateAdaptation").time} ms`)}}.bind(this,t)).catch(function(t){e.error(t.stack);var o="MSG_LREP_TRANSFER_ERROR";var i={titleKey:"EAC_DIALOG_HEADER"};i.details=t.userMessage;p.showMessageBox("error",o,i)})}else{g.start("onCBASaveAsAdaptation","Measurement of saving a context-based adaptation");i.show();d.create({control:o.rootControl,layer:o.flexSettings.layer,contextBasedAdaptation:t}).then(function(){i.hide();this.getToolbar().fireEvent("switchAdaptation",{adaptationId:t.id,trigger:"SaveAs"});g.end("onCBASaveAsAdaptation");g.getActive()&&e.info(`onCBASaveAsAdaptation: ${g.getMeasurement("onCBASaveAsAdaptation").time} ms`)}.bind(this)).catch(function(t){i.hide();e.error(t.stack);var o="MSG_LREP_TRANSFER_ERROR";var a={titleKey:"SAC_DIALOG_HEADER"};a.details=t.userMessage;p.showMessageBox("error",o,a)})}this._oAddAdaptationDialog.close()}function E(t){b.call(this);this.sPriority=t.getParameters().selectedItem.getProperty("key")}function y(){if(this._oAddAdaptationDialog&&this._oAddAdaptationDialog.isOpen()){var t=this.getToolbar().getControl("addAdaptationDialog--saveAdaptation-title-input");var e=t.getValue().trim().length;var o=100;if(e===0){t.setValueState(u.Error);t.setValueStateText(this.oTextResources.getText("TXT_CTX_ERROR_EMPTY_TITLE"))}else if(e>o){t.setValueState(u.Error);t.setValueStateText(this.oTextResources.getText("TXT_CTX_ERROR_MAX_LEN",[o]))}else if(e>0){var i=this.oAdaptationsModel.getProperty("/adaptations").findIndex(function(e){if(e.title.trim().toLowerCase()===t.getValue().trim().toLowerCase()){if(this._mEditProperties&&this._mEditProperties.title.toLowerCase()===t.getValue().toLowerCase()){return false}return true}return false}.bind(this));if(i>-1){t.setValueState(u.Error);t.setValueStateText(this.oTextResources.getText("TXT_CTX_ERROR_DUPLICATE_TITLE"))}else{t.setValueState(u.None);t.setValueStateText(null)}}}}function v(t){var e={layer:t||r.CUSTOMER};return l.createComponent(e).then(function(t){this._oContextComponent=t;this._oContextComponentInstance=t.getComponentInstance();this._oContextComponentInstance.resetSelectedContexts();this._oAddAdaptationDialog.addContent(this._oContextComponent);var e=a.getElementById("contextSharing---ContextVisibility--selectedContextsList");e.attachUpdateFinished(m.bind(this));e.getHeaderToolbar().getContent()[0].setRequired(true);this._oContextComponentInstance.setEmptyListTextWithAdvice();this._oContextComponentInstance.showMessageStrip(false)}.bind(this))}function S(){var t=this.getToolbar().getControl("addAdaptationDialog--saveAdaptation-title-input");return t?t.getValue().trim():""}function D(){if(this._bIsEditMode&&!this.sPriority){this.sPriority=this.oDialogModel.getProperty("/selected")}return Number(this.sPriority)||0}function b(){var t=this.getToolbar().getControl("addAdaptationDialog--saveAdaptation-title-input");var e;var o=this._oContextComponentInstance.getSelectedContexts().role.length>0&&t.getValueState()===u.None&&t.getValue().length>0;if(this._bIsEditMode&&this._mEditProperties&&this.oDialogModel){e=o&&(t.getValue()!==this._mEditProperties.title||this.oDialogModel.getProperty("/selected")!==this._mEditProperties.priority.toString()||this._oContextComponentInstance.getSelectedContexts().role.length!==this._mEditProperties.roles.length||!this._oContextComponentInstance.getSelectedContexts().role.every(function(t){return this._mEditProperties.roles.indexOf(t)>-1}.bind(this)))}else{e=o}this.getToolbar().getControl("addAdaptationDialog--saveAdaptation-saveButton").setEnabled(e)}function R(){this._mEditProperties=undefined;this._oAddAdaptationDialog.removeContent(this._oContextComponent);this._oContextComponentInstance.destroy();this._oContextComponent.destroy()}return c});
//# sourceMappingURL=SaveAsAdaptation.js.map