/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/base/ManagedObject","sap/m/InstanceManager","sap/ui/dt/Overlay","sap/ui/dt/OverlayRegistry","sap/ui/fl/Utils","sap/ui/core/Component","sap/ui/core/ComponentContainer","sap/ui/core/Element","sap/ui/dt/util/ZIndexManager","sap/m/Dialog","sap/m/Popover","sap/base/util/restricted/_curry"],function(t,e,o,n,i,a,p,r,s,u,l,d){"use strict";var c={add:"_activateFocusHandle",remove:"_deactivateFocusHandle"};var f=t.extend("sap.ui.rta.util.PopupManager",{metadata:{properties:{rta:"any"},associations:{autoCloseAreas:{type:"sap.ui.core.Control",multiple:true,singularName:"autoCloseArea"}},events:{open:{parameters:{oControl:{type:"sap.ui.core.Control"}}},close:{parameters:{oControl:{type:"sap.ui.core.Control"}}}},library:"sap.ui.rta"}});f.prototype.init=function(){this._oModalState=new Map;this._aPopupFilters=[this._isSupportedPopup.bind(this),this._isPopupAdaptable.bind(this)];this._aPopupFilters.forEach(function(t){s.addPopupFilter(t)})};f.prototype._overrideInstanceFunctions=function(){this._applyPopupAttributes({method:this._createPopupOverlays,setModal:true,bringToTop:true});this._overrideAddPopupInstance();this._overrideRemovePopupInstance()};f.prototype.getCategorizedOpenPopups=function(){var t;var o;t=e.getOpenDialogs();var n=this._getValidatedPopups(t);o=e.getOpenPopovers();var i=this._getValidatedPopups(o);var a={aDialogs:n.relevant,aPopovers:i.relevant,aAllSupportedPopups:n.allSupported.concat(i.allSupported)};return a};f.prototype._getValidatedPopups=function(t){var e=[];t=t.filter(function(t){if(this._isPopupAdaptable(t)){e.push(t);return true}else if(t instanceof u){e.push(t)}return undefined}.bind(this));return{relevant:t,allSupported:e}};f.prototype._isComponentInsidePopup=function(t){return Array.isArray(t.getContent())?t.getContent().some(function(t){if(t instanceof p){return this.oRtaRootAppComponent===this._getAppComponentForControl(a.getComponentById(t.getComponent()))}return undefined}.bind(this)):false};f.prototype._isSupportedPopup=function(t){return t instanceof u||t instanceof l};f.prototype.setRta=function(t){if(t&&t._oDesignTime){this.setProperty("rta",t);var e=t.getRootControlInstance();this.oRtaRootAppComponent=this._getAppComponentForControl(e);var o=this._onModeChange.bind(this);t.attachModeChanged(o);this._overrideInstanceFunctions()}};f.prototype._adjustRootOverlayVisibility=function(t,e){this.getRta()._oDesignTime.getRootElements().forEach(function(o){if(o.getId()!==e.getId()){n.getOverlay(o).setVisible(t)}})};f.prototype._onModeChange=function(t){var e=t.getParameters().mode;var o=function(t,e){if(t==="navigation"){e.oPopup[this._getFocusEventName("add")]()}else{e.oPopup[this._getFocusEventName("remove")]();if(this.getRta().getShowToolbars()){this.getRta().getToolbar().bringToFront()}}};if(e==="navigation"){this._applyPatchesToOpenPopups(d(o)(e))}else{this._removePatchesToOpenPopups(d(o)(e))}};f.prototype._applyPatchesToOpenPopups=function(t){this._applyPopupAttributes({method:t,focus:true,setModal:false})};f.prototype._removePatchesToOpenPopups=function(t){this._applyPopupAttributes({method:t,setModal:true})};f.prototype._getFocusEventName=function(t){return c[t]};f.prototype._overrideAddPopupInstance=function(){this._fnOriginalAddDialogInstance=e.addDialogInstance;e.addDialogInstance=this._overrideAddFunctions(this._fnOriginalAddDialogInstance);this._fnOriginalAddPopoverInstance=e.addPopoverInstance;e.addPopoverInstance=this._overrideAddFunctions(this._fnOriginalAddPopoverInstance)};f.prototype._overrideAddFunctions=function(t){return function(...o){const[n]=o;var i=t.apply(e,o);if(this._isSupportedPopup(n)){if(this._isPopupAdaptable(n)&&this.getRta()._oDesignTime){n.attachEventOnce("afterOpen",this._createPopupOverlays,this);n.attachEventOnce("afterOpen",this.fireOpen,this);this._setModal(true,n)}else if(!(n instanceof l)){this._setModal(true,n)}}return i}.bind(this)};f.prototype._setModal=function(t,e){var o=this._oModalState.get(e.oPopup);if(typeof o!=="boolean"&&t&&this.getRta().getMode()!=="navigation"){this._oModalState.set(e.oPopup,e.oPopup.getModal());if(this._isPopupAdaptable(e)){this._adjustRootOverlayVisibility(false,e)}e.oPopup.setModal(true)}else if(typeof o==="boolean"&&t===false){e.oPopup.setModal(o);if(this._isPopupAdaptable(e)){this._adjustRootOverlayVisibility(true,e)}this._oModalState.delete(e.oPopup)}};f.prototype._applyPopupAttributes=function(t){var e=this.getCategorizedOpenPopups();["aDialogs","aPopovers"].forEach(function(o){if(e[o].length>0){if(t.focus){if(e[o][0].oPopup.oContent){e[o][0].oPopup.oContent.focus()}}e[o].forEach(function(e){t.method.call(this,e)}.bind(this))}}.bind(this));e.aAllSupportedPopups.forEach(this._setModal.bind(this,t.setModal))};f.prototype._applyPopupPatch=function(t){var e=o.getOverlayContainer();var{oPopup:n}=t;var i=[n.oContent.getDomRef(),e].concat(this.getAutoCloseAreas());if(this.getRta().getShowToolbars()){var a=this.getRta().getToolbar();var p=!!a.getVisible();if(!p){this.getRta().attachEventOnce("start",function(){i.push(a.getDomRef())})}else{i.push(a.getDomRef())}}n.setExtraContent(i);this.fnOriginalPopupOnAfterRendering||=n.onAfterRendering;n.onAfterRendering=function(...t){var e=this.fnOriginalPopupOnAfterRendering.apply(n,t);n[this._getFocusEventName("remove")]();return e}.bind(this);if(this.getRta().getMode()==="adaptation"){n[this._getFocusEventName("remove")]()}};f.prototype._overrideRemovePopupInstance=function(){this._fnOriginalRemoveDialogInstance=e.removeDialogInstance;e.removeDialogInstance=this._overrideRemoveFunctions(this._fnOriginalRemoveDialogInstance);this._fnOriginalRemovePopoverInstance=e.removePopoverInstance;e.removePopoverInstance=this._overrideRemoveFunctions(this._fnOriginalRemovePopoverInstance)};f.prototype._overrideRemoveFunctions=function(t){return function(...o){const[n]=o;var i=t.apply(e,o);if(this._isSupportedPopup(n)){if(this._isPopupAdaptable(n)&&this.getRta()._oDesignTime){this.getRta()._oDesignTime.removeRootElement(n)}this._oModalState.delete(n.oPopup);this.fireClose(n)}return i}.bind(this)};f.prototype._getAppComponentForControl=function(t){var e;var o;if(t instanceof a){e=t}else{e=this._getComponentForControl(t)}if(e){o=i.getAppComponentForControl(e)}return o};f.prototype._getComponentForControl=function(t){var e;var o;var n;if(t){e=a.getOwnerComponentFor(t);if(!e&&typeof t.getParent==="function"&&t.getParent()instanceof r){n=t.getParent()}else if(e){n=e}if(n){o=this._getComponentForControl(n)}}return o||e};f.prototype._createPopupOverlays=function(t){if(!t){return}var e=t instanceof r?t:t.getSource();if(this.getRta()._oDesignTime.getRootElements().indexOf(e.getId())===-1&&!this._isComponentInsidePopup(e)){this.getRta()._oDesignTime.addRootElement(e)}e.detachAfterOpen(this._createPopupOverlays,this);this._applyPopupPatch(e)};f.prototype._restoreInstanceFunctions=function(){if(this._fnOriginalAddDialogInstance){e.addDialogInstance=this._fnOriginalAddDialogInstance}if(this._fnOriginalRemoveDialogInstance){e.removeDialogInstance=this._fnOriginalRemoveDialogInstance}if(this._fnOriginalAddPopoverInstance){e.addPopoverInstance=this._fnOriginalAddPopoverInstance}if(this._fnOriginalRemovePopoverInstance){e.removePopoverInstance=this._fnOriginalRemovePopoverInstance}this._applyPatchesToOpenPopups(this._removePopupPatch)};f.prototype._removePopupPatch=function(t){var{oPopup:e}=t;e[this._getFocusEventName("add")]();if(this.fnOriginalPopupOnAfterRendering){e.onAfterRendering=this.fnOriginalPopupOnAfterRendering}};function h(t){if(!t||t instanceof a){return true}if(!t.isPopupAdaptationAllowed||t.isPopupAdaptationAllowed()){return h(t.getParent())}return false}f.prototype._isPopupAdaptable=function(t){if(t.isPopupAdaptationAllowed&&!t.isPopupAdaptationAllowed()){return false}var e=this._getAppComponentForControl(t);if(e&&this.oRtaRootAppComponent===e||this._isComponentInsidePopup(t)){return h(t.getParent())}return false};f.prototype.exit=function(){this._restoreInstanceFunctions();delete this._oModalState;this._aPopupFilters.forEach(function(t){s.removePopupFilter(t)})};return f});
//# sourceMappingURL=PopupManager.js.map