/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/core/format/DateFormat","sap/ui/core/Control","sap/ui/core/Element","sap/ui/core/Fragment","sap/ui/core/Lib","sap/ui/core/StaticArea","sap/ui/events/KeyCodes","sap/ui/fl/util/resolveBinding","sap/ui/fl/Utils","sap/ui/model/json/JSONModel","sap/ui/rta/util/changeVisualization/commands/getCommandVisualization","sap/ui/rta/util/changeVisualization/ChangeCategories","sap/ui/rta/util/changeVisualization/ChangeVisualizationUtils","sap/ui/dt/OverlayRegistry"],function(e,t,o,i,n,s,a,r,l,c,p,h,g,d){"use strict";const u=t.extend("sap.ui.rta.util.changeVisualization.ChangeIndicator",{metadata:{library:"sap.ui.rta",properties:{changes:{type:"array",defaultValue:[]},posX:{type:"int"},posY:{type:"int"},overlayId:{type:"string"},selectorId:{type:"string"},connectedElementId:{type:"string"}},aggregations:{_popover:{type:"sap.m.Popover",multiple:false,visibility:"hidden"}},events:{selectChange:{parameters:{changeId:{type:"string"}}},keyPress:{parameters:{originalEvent:{type:"object"}}},detailPopoverOpened:{}}},renderer:{apiVersion:2,render(e,t){e.openStart("div",t);e.class("sapUiRtaChangeIndicator");e.class("sapUiRtaChangeIndicatorChange");const o=t.getTooltip_AsString();if(o){e.attr("title",o)}e.openEnd();if(o){e.openStart("span",`${t.getId()}-tooltip`);e.class("sapUiInvisibleText");e.openEnd();e.text(o);e.close("span")}e.close("div")}},constructor:function(...e){this._oDetailModel=new c;this._oDetailModel.setDefaultBindingMode("OneWay");this._fnHoverTrue=this._setHoverStyleClasses.bind(this,true);this._fnHoverFalse=this._setHoverStyleClasses.bind(this,false);t.prototype.constructor.apply(this,e);this._bEventAttachedToElement=false;this._oRenderPromise=new Promise(e=>{this._fnRendered=e})}});function f(e,t){e[t]("click",this._onSelect,this);e[t]("tap",this._onSelect,this);e[t]("keydown",this._onKeyDown,this);e[t]("mouseover",this._fnHoverTrue);e[t]("focusin",this._fnHoverTrue);e[t]("mouseout",this._fnHoverFalse);e[t]("focusout",this._fnHoverFalse)}function y(e,t){e[t]("click",this._onSelect,this);e[t]("tap",this._onSelect,this);e[t]("keydown",this._onKeyDown,this);e[t]("mouseover",this._fnHoverTrue);e[t]("focusin",this._fnHoverTrue);e[t]("mouseout",this._fnHoverFalse);e[t]("focusout",this._fnHoverFalse)}function v(e){const t=e.getDomRef();const i=o.getElementById(e.getOverlayId()).getDomRef().offsetHeight;const n=t.offsetHeight;if(i<n*5){e.addStyleClass("sapUiRtaChangeIndicatorVerticallyCentered")}else{e.removeStyleClass("sapUiRtaChangeIndicatorVerticallyCentered")}}function _(e,t,i){const n=o.getElementById(e.affectedElementId);const s=Object.keys(e.descriptionPayload||{}).reduce(function(t,o){const i=e.descriptionPayload[o];const s=l.isBinding(i);const a=s?r(i,n):i;t[o]=a;return t},{});const a={appComponent:l.getAppComponentForControl(n)};const c=o.getElementById(i);const h=c.getDesignTimeMetadata().getLabel(n);const d=p(e);const u=d?.getDescription(s,h,a)||{};let f=e.commandName;let y;let v;if(f==="settings"&&s.description){u.descriptionText=s.description;u.descriptionTooltip=s.descriptionTooltip}else if(e.changeCategory==="other"){f="other"}if(u.descriptionText){y=u.descriptionText;v=u.descriptionTooltip||""}else{const e=g.shortenString(h);const o=`TXT_CHANGEVISUALIZATION_CHANGE_${f.toUpperCase()}`;y=t.getText(o,[e]);v=t.getText(o,[h])}v=y.length<v.length?v:null;const _=u&&u.buttonText;const I=t.getText(`TXT_CHANGEVISUALIZATION_OVERVIEW_${e.changeCategory.toUpperCase()}`);return{description:y,tooltip:v,buttonText:_,iconTooltip:I}}function I(t,o){const i=t.change.getCreation();const n=new Date(i);const s=o.getText("TXT_CHANGEVISUALIZATION_CREATED_IN_SESSION_DATE");return{fullDate:i?e.getDateTimeInstance().format(n):s,relativeDate:i?e.getDateTimeInstance({relative:"true"}).format(n):s}}function m(e,t){const o=n.getResourceBundleFor("sap.ui.rta");const i=_(t,o,e);const s=I(t,o);return{id:t.id,change:t,description:i.description,descriptionTooltip:i.tooltip,fullDate:s.fullDate,relativeDate:s.relativeDate,detailButtonText:i.buttonText,icon:h.getIconForCategory(t.changeCategory),iconTooltip:i.iconTooltip}}u.prototype.init=function(){this._iOldTabIndex=0;y.call(this,this,"attachBrowserEvent")};u.prototype.setVisible=function(...e){const[i]=e;t.prototype.setVisible.apply(this,e);const n=o.getElementById(this.getOverlayId());if(n){if(i&&!this._bEventAttachedToElement){f.call(this,n,"attachBrowserEvent");this._bEventAttachedToElement=true}if(!i){f.call(this,n,"detachBrowserEvent");this._bEventAttachedToElement=false;if(this.getAggregation("_popover")){this.getAggregation("_popover").destroy()}this._oRenderPromise=new Promise(e=>{this._fnRendered=e})}}return this};u.prototype.focus=function(...e){if(this.getDomRef()){t.prototype.focus.apply(this,e);this._bScheduledForFocus=false;return}this._bScheduledForFocus=true};u.prototype.setOverlayId=function(e){const t=this.getDomRef();if(t){t.parentNode.removeChild(t)}this.placeAt(s.getDomRef());this.setProperty("overlayId",e);return this};u.prototype.onAfterRendering=function(){const e=o.getElementById(this.getOverlayId());if(e){e.getDomRef().appendChild(this.getDomRef());v(this)}this.getDomRef().tabIndex=this._iOldTabIndex;if(this._bScheduledForFocus){this.focus();this._setHoverStyleClasses(true)}this._fnRendered()};u.prototype.waitForRendering=function(){return this._oRenderPromise};u.prototype.exit=function(){const e=this.getDomRef();const t=o.getElementById(this.getOverlayId());if(e){e.parentNode.removeChild(e)}if(t){if(this.getAggregation("_popover")){this.getAggregation("_popover").destroy()}f.call(this,t,"detachBrowserEvent")}y.call(this,this,"detachBrowserEvent")};u.prototype.setChanges=function(e){const t=n.getResourceBundleFor("sap.ui.rta");this.setProperty("changes",e);const o=e?e.sort((e,t)=>new Date(e.change.getCreation()||new Date)-new Date(t.change.getCreation()||new Date)).reverse():[];const i=o.map(m.bind(this,this.getOverlayId()));this._oDetailModel.setData(i);if(e&&e.length===1){this.setTooltip(t.getText("TXT_CHANGEVISUALIZATION_INDICATOR_TOOLTIP_SING"))}else if(e){this.setTooltip(t.getText("TXT_CHANGEVISUALIZATION_INDICATOR_TOOLTIP_PLUR",[e.length]))}};u.prototype._onSelect=function(e){this.focus();e.stopPropagation();this._toggleDetailPopover()};u.prototype._onKeyDown=function(e){if(e.keyCode===a.ENTER){this._onSelect(e)}this.fireKeyPress({originalEvent:e})};u.prototype.onDetailPopoverOpened=function(e){e.preventDefault();this._setHoverStyleClasses(true)};u.prototype.onIndicatorBrowserInteraction=function(e,t){t.stopPropagation();t.preventDefault();this._setHoverStyleClasses(e)};u.prototype._setHoverStyleClasses=function(e,t){if(t){t.stopPropagation();t.preventDefault()}const i=o.getElementById(this.getOverlayId());if(i.getMetadata().getName()!=="sap.ui.dt.ElementOverlay"){return}const n=e?"addStyleClass":"removeStyleClass";i[n]("sapUiRtaChangeIndicatorHovered");this[n]("sapUiRtaHover");if(this.getConnectedElementId()){const e=d.getOverlay(this.getConnectedElementId());e[n]("sapUiRtaChangeIndicatorHovered")}};u.prototype._toggleDetailPopover=function(){if(!this.getAggregation("_popover")){this._iOldTabIndex=this.getDomRef().getAttribute("tabindex");i.load({name:"sap.ui.rta.util.changeVisualization.ChangeIndicatorPopover",id:`${this.sId}Info`,controller:this}).then(function(e){e._bOpenedByChangeIndicator=true;this.setAggregation("_popover",e);e.setModel(this._oDetailModel,"details");e.openBy(this);this._setHoverStyleClasses(true)}.bind(this))}else{if(this.getAggregation("_popover").isOpen()){return this.getAggregation("_popover").close()}this.getAggregation("_popover").openBy(this);this._setHoverStyleClasses(true)}return undefined};u.prototype._showDependentElements=function(e){this.getAggregation("_popover").close();const t=this.getChanges().length>1?e.getSource().getBindingContext("details").getObject().id:this.getChanges()[0].id;this.fireSelectChange({changeId:t})};return u});
//# sourceMappingURL=ChangeIndicator.js.map