/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/core/Element","sap/ui/core/Fragment","sap/ui/core/Lib","sap/base/util/isEmptyObject","sap/base/util/restricted/_difference","sap/base/util/deepEqual","sap/ui/core/util/reflection/JsControlTreeModifier","sap/ui/core/Control","sap/ui/dt/OverlayRegistry","sap/ui/dt/ElementUtil","sap/ui/fl/write/api/PersistenceWriteAPI","sap/ui/fl/Layer","sap/ui/fl/Utils","sap/ui/model/resource/ResourceModel","sap/ui/model/json/JSONModel","sap/ui/rta/util/changeVisualization/ChangeIndicator","sap/ui/rta/util/changeVisualization/ChangeIndicatorRegistry","sap/ui/rta/util/changeVisualization/ChangeCategories","sap/ui/rta/util/changeVisualization/ChangeStates"],function(e,t,n,o,i,a,s,r,g,l,h,c,u,d,C,p,y,f,_){"use strict";function I(){const e=this.getPopover();if(e&&e.isOpen()){e.close()}}function v(e){return!e||!e.getDomRef()||!e.isVisible()}function V(e,t){let n=g.getOverlay(e);if(!n){const e=g.getOverlay(t);const o=e&&e.getRelevantContainer();if(o){n=g.getOverlay(o)}}return n}const M=r.extend("sap.ui.rta.util.changeVisualization.ChangeVisualization",{metadata:{library:"sap.ui.rta",properties:{rootControlId:{type:"string"},isActive:{type:"boolean",defaultValue:false}},aggregations:{popover:{type:"sap.m.Popover",multiple:false}}},renderer:null,constructor:function(...e){this._oChangeIndicatorRegistry=new y({changeCategories:f.getCategories()});r.prototype.constructor.apply(this,e);this._oTextBundle=n.getResourceBundleFor("sap.ui.rta");this.setModel(new d({bundle:this._oTextBundle}),"i18n");this._oChangeVisualizationModel=new C({active:this.getIsActive(),changeState:_.ALL});this._oChangeVisualizationModel.setDefaultBindingMode("TwoWay");this._sSelectedChangeCategory=f.ALL;this._bSetModeChanged=false;this._fnOnClickHandler=I.bind(this)}});M.prototype.setVersionsModel=function(e){this.oVersionsModel=e.getModel("versions")};M.prototype.setRootControlId=function(e){if(this.getRootControlId()&&this.getRootControlId()!==e){this._reset()}this.setProperty("rootControlId",e);this._oChangeIndicatorRegistry.setRootControlId(e)};M.prototype._getComponent=function(){return u.getAppComponentForControl(l.getElementInstance(this.getRootControlId()))};M.prototype.setIsActive=function(e){if(e===this.getIsActive()){return}this.setProperty("isActive",e);if(this._oChangeVisualizationModel){this._updateVisualizationModel({active:e})}};M.prototype.exit=function(){this._oChangeIndicatorRegistry.destroy();this._toggleRootOverlayClickHandler(false)};M.prototype.updateAfterSave=function(e){if(this.getProperty("rootControlId")){this._oChangeIndicatorRegistry.reset();this._updateChangeRegistry().then(function(){this._selectChangeCategory(this._sSelectedChangeCategory);this._selectChangeState(_.ALL);this._updateVisualizationModelMenuData();e.setModel(this._oChangeVisualizationModel,"visualizationModel")}.bind(this))}};M.prototype._reset=function(){this._oChangeIndicatorRegistry.reset()};M.prototype._determineChangeVisibility=function(e,t,n){function o(e){return e.filter(function(e){if(!n||n===_.ALL||e.changeStates.includes(n)){return true}return false})}const i=[];const a=[];let s=false;let r=false;const g=t.map(function(e){return e.id});e.forEach(function(e){if(e.changeStates.includes(_.DIRTY)){s=true;r=true}else if(e.changeStates.includes(_.DRAFT)){s=true}const t=V(e.visualizationInfo.displayElementIds[0],e.visualizationInfo.affectedElementIds[0]);if(!g.includes(e.change.getId())){i.push(e)}else if(v(t)){i.push(e)}else{a.push(e)}});const l=o(i);const h=o(a);return{relevantHiddenChanges:l,relevantVisualizedChanges:h,hasDirtyChanges:r,hasDraftChanges:s}};M.prototype._updateVisualizationModelMenuData=function(){const e=this._oChangeVisualizationModel.getData().changeState;const t=this._oChangeIndicatorRegistry.getAllRegisteredChanges();const n=this._oChangeIndicatorRegistry.getRelevantChangesWithSelector();const o=t.filter(function(e){if(!e.dependent){return true}return false});const i=this._determineChangeVisibility(o,n,e);const a=Object.keys(f.getCategories()).map(function(e){const t=this._getChangeCategoryLabel(e,this._getChangesForChangeCategory(e,i.relevantVisualizedChanges).length);return{key:e,count:this._getChangesForChangeCategory(e,i.relevantVisualizedChanges).length,title:t,icon:f.getIconForCategory(e)}}.bind(this));a.unshift({key:f.ALL,count:this._getChangesForChangeCategory(f.ALL,i.relevantVisualizedChanges).length,title:this._getChangeCategoryLabel(f.ALL,this._getChangesForChangeCategory(f.ALL,i.relevantVisualizedChanges).length),icon:f.getIconForCategory(f.ALL)});this._updateVisualizationModel({changeCategories:a,hasDraftChanges:i.hasDraftChanges,hasDirtyChanges:i.hasDirtyChanges,popupInfoMessage:this._oTextBundle.getText("MSG_CHANGEVISUALIZATION_HIDDEN_CHANGES_INFO",[i.relevantHiddenChanges.length]),sortedChanges:i})};M.prototype._getChangesForChangeCategory=function(e,t){return t.filter(function(t){return e===f.ALL?t.changeCategory!==undefined:e===t.changeCategory})};M.prototype._getChangeCategoryLabel=function(e,t){const n=`TXT_CHANGEVISUALIZATION_OVERVIEW_${e.toUpperCase()}`;return this._oTextBundle.getText(n,[t])};M.prototype._getChangeCategoryButtonText=function(e){const t=`BTN_CHANGEVISUALIZATION_OVERVIEW_${e.toUpperCase()}`;const n=this._oTextBundle.getText(t);const o=this._oChangeVisualizationModel.getData().changeState;if(o===_.ALL){return n}const i=this._oTextBundle.getText(`BUT_CHANGEVISUALIZATION_VERSIONING_${o.toUpperCase()}`);return`${n} (${i})`};M.prototype.openChangeCategorySelectionPopover=function(n){this._oToolbarButton||=e.getElementById(n.getParameter("id"));const o=this.getPopover();if(!o){t.load({name:"sap.ui.rta.util.changeVisualization.ChangeIndicatorCategorySelection",id:`${this._oToolbarButton.sId}--ChangeIndicatorCategorySelection`,controller:this}).then(function(e){this._oToolbarButton.addDependent(e);e.setModel(this._oChangeVisualizationModel,"visualizationModel");e.openBy(this._oToolbarButton);this.setPopover(e);e.close();e.openBy(this._oToolbarButton)}.bind(this));return}if(o.isOpen()){o.close()}else{o.openBy(this._oToolbarButton)}};M.prototype.onChangeCategorySelection=function(e){const t=e.getSource().getBindingContext("visualizationModel").getObject().key;this._selectChangeCategory(t);this.getPopover()?.close()};M.prototype.onVersioningCategoryChange=function(e){const t=e.getSource().getSelectedKey();this._selectChangeState(t)};M.prototype._selectChangeCategory=function(e){this._sSelectedChangeCategory=e;const t=this._getChangeCategoryButtonText(e);this._updateVisualizationModel({changeCategory:e,changeCategoryText:t});this._updateChangeIndicators();this._setFocusedIndicator()};M.prototype._selectChangeState=function(e){this._sSelectedChangeState=e;const t=this._oChangeVisualizationModel.getData().changeCategory;const n=this._getChangeCategoryButtonText(t);this._updateVisualizationModel({changeState:e,changeCategoryText:n});this._updateChangeIndicators();this._updateVisualizationModelMenuData()};M.prototype._getCommandForChange=function(e){const t=e.getSupportInformation().command;if(t){return t}if(!e.canBeVisualized()){return false}const n=this._getComponent();const o=s.bySelector(e.getSelector(),n);const i=e.getDependentSelectorList().slice(-1)[0];const a=s.bySelector(i,n);function r(t,n){const i=t.getElement();const a=t.getDesignTimeMetadata().getCommandName(e.getChangeType(),i,n);if(a){return a}const s=t.getParentElementOverlay();const g=t.getParentAggregationOverlay();if(t.getElement().getId()===o.getId()||!s){return undefined}return r(s,g&&g.getAggregationName())}return o&&a&&r(g.getOverlay(a))};M.prototype._collectChanges=function(){const e=this._getComponent();const t={selector:e,invalidateCache:false,includeCtrlVariants:true,currentLayer:c.CUSTOMER,includeDirtyChanges:true,onlyCurrentVariants:true};return h._getUIChanges(t)};M.prototype._updateChangeRegistry=function(){return this._collectChanges().then(function(e){this._oChangeIndicatorRegistry.removeOutdatedRegisteredChanges();this._oChangeIndicatorRegistry.removeRegisteredChangesWithoutVizInfo();if(this._oChangeVisualizationModel.getData().displayedVersion!=="0"){this._oChangeIndicatorRegistry.reset()}const t=this._oChangeIndicatorRegistry.getRegisteredChangeIds();const n=e.reduce(function(e,t){e[t.getId()]=t;return e},{});const o=Object.keys(n);i(t,o).forEach(function(e){this._oChangeIndicatorRegistry.removeRegisteredChange(e)}.bind(this));const a=[];i(o,t).forEach(function(e){const t=n[e];const o=this._getCommandForChange(t);a.push(this._oChangeIndicatorRegistry.registerChange(t,o,this.oVersionsModel))}.bind(this));return Promise.all(a)}.bind(this))};M.prototype.selectChange=function(e){const t=e.getParameter("changeId");this._selectChange(t)};M.prototype._selectChange=function(e){const t=this._oChangeIndicatorRegistry.getRegisteredChange(e).visualizationInfo.dependentElementIds;t.forEach(function(e){const t=g.getOverlay(e).getDomRef();t.scrollIntoView({block:"nearest"});t.classList.add("sapUiRtaChangeIndicatorDependent");t.addEventListener("animationend",function(){t.classList.remove("sapUiRtaChangeIndicatorDependent")},{once:true})})};M.prototype._updateVisualizationModel=function(e){this._oChangeVisualizationModel.setData({...this._oChangeVisualizationModel.getData(),...e})};M.prototype._updateChangeIndicators=function(){const e=this._oChangeIndicatorRegistry.getSelectorsWithRegisteredChanges();const t={};this._mDisplayElementsKeyMap={};const n=this._oDesignTime?.getSelectionManager?.().getConnectedElements();Object.keys(e).forEach(function(o){const i=e[o];const a=this._filterRelevantChanges(e[o]);const s=V(o,i[0].affectedElementId);if(v(s)){return undefined}const r=s.getDomRef().getClientRects()[0]||{left:0,top:0};t[o]={posX:parseInt(r.left),posY:parseInt(r.top),changes:a};const g=this._oChangeIndicatorRegistry.getChangeIndicator(o);const l=s.getId();const h=n?.[s.getAssociation("element")];if(!g){this._createChangeIndicator(s,o,h);const e=i[0].displayElementsKey;if(!this._mDisplayElementsKeyMap[e]){this._mDisplayElementsKeyMap[e]=[o]}else{this._mDisplayElementsKeyMap[e].push(o)}}else if(g.getOverlayId()!==l){g.setOverlayId(l);g.setVisible(true)}return undefined}.bind(this));if(!a(t,this._oChangeVisualizationModel.getData().content)){this._updateVisualizationModel({content:t})}};M.prototype._filterRelevantChanges=function(e){if(!Array.isArray(e)){return e}const t=this._oChangeVisualizationModel.getData();return e.filter(function(e){return!e.dependent&&e.changeCategory&&(t.changeCategory===f.ALL||t.changeCategory===e.changeCategory)&&(!t.changeState||t.changeState===_.ALL||e.changeStates.includes(t.changeState))})};M.prototype._createChangeIndicator=function(e,t,n){const o=new p({changes:"{changes}",posX:"{posX}",posY:"{posY}",visible:"{= ${/active} && (${changes} || []).length > 0}",overlayId:e.getId(),selectorId:t,selectChange:this.selectChange.bind(this),connectedElementId:n});o.setModel(this._oChangeVisualizationModel);o.bindElement(`/content/${t}`);o.setModel(this.getModel("i18n"),"i18n");this._oChangeIndicatorRegistry.registerChangeIndicator(t,o)};M.prototype._setFocusedIndicator=async function(){await this._oChangeIndicatorRegistry.waitForIndicatorRendering();const e=[];this._oChangeIndicatorRegistry.getChangeIndicators().forEach(t=>{const n=g.getOverlay(t.getOverlayId());if(!n){return}if(t.getVisible()){n.setFocusable(true);e.push(t)}else{n.setFocusable(false)}});if(e.length>0){e.sort(function(e,t){const n=e.getPosY()-t.getPosY();const o=e.getPosX()-t.getPosX();return n||o});const t=[];e.forEach(function(e,n){const o=g.getOverlay(e.getOverlayId());o.setFocusable(true);e.getDomRef().tabIndex=n+2;if(e.getPosY()>0){t.push(e)}});if(t.length>0){t[0].focus()}else{e[0].focus()}}};M.prototype._toggleRootOverlayClickHandler=function(e){const t=this.oRootOverlay&&this.oRootOverlay.getDomRef();if(t){if(e){t.addEventListener("click",this._fnOnClickHandler,{capture:true})}else{t.removeEventListener("click",this._fnOnClickHandler,{capture:true})}}};M.prototype.triggerModeChange=function(e,t){this.oMenuButton=t.getControl("toggleChangeVisualizationMenuButton");this.oRootOverlay=g.getOverlay(e);this.setVersionsModel(t);this.aFocusableOverlays||=g.getOverlays().filter(function(e){return e.getFocusable()});const n=e=>{this.aFocusableOverlays.forEach(function(t){t.setFocusable(e)})};if(this.oVersionsModel&&this.oVersionsModel.getData().versioningEnabled){this._updateVisualizationModel({versioningAvailable:this.oVersionsModel.getData().versioningEnabled,displayedVersion:this.oVersionsModel.getData().displayedVersion})}else{this._updateVisualizationModel({versioningAvailable:false,displayedVersion:"0"})}if(this.getIsActive()){this.setIsActive(false);this._toggleRootOverlayClickHandler(false);n(true);delete this.aFocusableOverlays;return}n(false);this._toggleRootOverlayClickHandler(true);if(!this.getRootControlId()){this.setRootControlId(e)}this.setIsActive(true);this._updateChangeRegistry().then(function(){this._selectChangeCategory(this._sSelectedChangeCategory);t.adjustToolbarSectionWidths();this._updateVisualizationModelMenuData();return this._oChangeIndicatorRegistry.waitForIndicatorRendering()}.bind(this)).then(function(){t.setModel(this._oChangeVisualizationModel,"visualizationModel")}.bind(this))};return M});
//# sourceMappingURL=ChangeVisualization.js.map