/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/m/MessageBox","sap/ui/base/ManagedObject","sap/ui/core/Element","sap/ui/core/Fragment","sap/ui/model/json/JSONModel","sap/ui/model/resource/ResourceModel","sap/ui/rta/Utils"],function(t,e,o,s,i,r,n){"use strict";const a=e.extend("sap.ui.rta.util.guidedTour.GuidedTour",{metadata:{properties:{steps:{type:"object"},initialStateSelectors:{type:"object"},currentStep:{type:"int",defaultValue:0},forwardDirection:{type:"boolean",defaultValue:true}},events:{tourClosed:{}}}});function u(t){return new Promise((e,s)=>{const i=o.getElementById(t);const r=i?.getDomRef();let a=false;if(n.isElementVisible(r)){e(i);return}const u=new MutationObserver(()=>{const s=o.getElementById(t);const i=s?.getDomRef();if(n.isElementVisible(i)){a=true;u.disconnect();e(s)}});u.observe(document.body,{childList:true,subtree:true,attributes:true});setTimeout(()=>{if(!a){u.disconnect();s(new Error(`Element with ID "${t}" not found`))}},700)})}function c(){if(this.getProperty("forwardDirection")===true){this.onNextPress()}else{this.onPreviousPress()}}function d(t){if(t.key==="Escape"||t.key==="Esc"){this.onClosePress()}}a.prototype.autoStart=async function(e){const o=await n.showMessageBox("information","TXT_TOUR_GENERAL_DESCRIPTION",{actions:[t.Action.YES,t.Action.NO],emphasizedAction:t.Action.YES,titleKey:"TIT_TOUR_GENERAL_TITLE",id:"autoStartGuidedTour"});if(o===t.Action.YES){this.start(e)}else{this.fireTourClosed()}};a.prototype.start=async function(t){this.setProperty("steps",t.steps);this.setProperty("initialStateSelectors",t.initialStateSelectors);const e=new r({bundleName:"sap.ui.rta.messagebundle"});this._oPopover=await s.load({id:"guidedTourMarker",name:"sap.ui.rta.util.guidedTour.TourMarker",controller:this});this.oGuidedTourModel=new i;this.updateGuidedTourModel(0);this._oPopover.setModel(e,"i18n");this._oPopover.setModel(this.oGuidedTourModel);this._oPopover.addEventDelegate({onAfterRendering:function(){const t=this._oPopover.getDomRef();if(t){t.addEventListener("keydown",d.bind(this))}}.bind(this)});this.showMarker(0)};a.prototype.showMarker=async function(t){const e=this.getProperty("steps")[t];const s=e.markerSelector;const i=e.actionSelectors||[];try{for(const t of i){const e=await u.call(this,t);e.firePress()}const t=e.waitForElement?await u.call(this,s):o.getElementById(s);if(t&&t.getVisible()){this._oPopover.openBy(t)}else{c.call(this)}}catch(t){c.call(this)}};a.prototype.updateGuidedTourModel=function(t){const e=t===this.getProperty("steps").length-1;const o=t===0;this.oGuidedTourModel.setData({...this.oGuidedTourModel.getData(),...this.getProperty("steps")[t],isLastStep:e,isFirstStep:o,progress:100/this.getProperty("steps").length*(t+1)})};a.prototype.onNextPress=function(){this.setProperty("forwardDirection",true);this._oPopover.close();const t=this.getCurrentStep();if(t<this.getProperty("steps").length-1){const e=t+1;this.updateGuidedTourModel(e);this.setCurrentStep(e);this.showMarker(e)}else{this.fireTourClosed();this.destroy()}};a.prototype.onPreviousPress=function(){this.setProperty("forwardDirection",false);this._oPopover.close();const t=this.getCurrentStep();const e=t-1;this.updateGuidedTourModel(e);this.setCurrentStep(e);this.showMarker(e)};a.prototype.returnToInitialState=async function(){try{const t=this.getProperty("initialStateSelectors");if(t.length===0){return}for(const e of t){const t=await u.call(this,e);t.firePress()}}catch(t){this.destroy()}};a.prototype.onClosePress=async function(){this._oPopover.close();this.fireTourClosed();this.destroy();await this.returnToInitialState()};a.prototype.destroy=function(...t){e.prototype.destroy.apply(this,t);if(this._oPopover){this._oPopover.destroy()}};return a});
//# sourceMappingURL=GuidedTour.js.map