/*!
* OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
*/
sap.ui.define(["sap/base/Log","sap/ui/base/ManagedObject","sap/ui/core/Core","sap/ui/core/Element","sap/ui/core/ElementRegistry","sap/ui/core/ComponentRegistry","sap/ui/core/Lib","sap/ui/core/Supportability","sap/ui/support/supportRules/Analyzer","sap/ui/support/supportRules/CoreFacade","sap/ui/support/supportRules/ExecutionScope","sap/ui/support/supportRules/ui/external/Highlighter","sap/ui/support/supportRules/CommunicationBus","sap/ui/support/supportRules/IssueManager","sap/ui/support/supportRules/History","sap/ui/support/supportRules/report/DataCollector","sap/ui/support/supportRules/WCBChannels","sap/ui/support/supportRules/Constants","sap/ui/support/supportRules/RuleSetLoader","sap/ui/support/supportRules/RuleSerializer","sap/ui/support/library","sap/ui/core/ComponentContainer"],function(e,t,s,i,o,r,n,u,a,l,p,c,_,f,E,d,h,S,R,y,g,b){"use strict";var T=null;var A=null;var m=new c(S.HIGHLIGHTER_ID);var I=t.extend("sap.ui.support.Main",{constructor:function(){if(!A){this._oCore=null;this._oAnalyzer=new a;this._oAnalyzer.onNotifyProgress=function(e){_.publish(h.ON_PROGRESS_UPDATE,{currentProgress:e})};t.apply(this,arguments);var s=document.createEvent("CustomEvent");s.initCustomEvent("supportToolLoaded",true,true,{})}else{e.warning("Only one support tool allowed");return A}}});I.prototype.exit=function(){T._stop();this._pluginStarted=false;this._oCore=null;this._oCoreFacade=null;this._oDataCollector=null;this._oExecutionScope=null};I.prototype._isInIframe=function(){try{return window.self!==window.top}catch(e){return true}};I.prototype.startPlugin=function(e){if(this._pluginStarted){return}this._aSupportModeConfig=e;s.ready(this._initPlugin.bind(this))};I.prototype._initPlugin=function(){var e=this._aSupportModeConfig;this._pluginStarted=true;this._supportModeConfig=e=e||u.getSupportSettings();_.bSilentMode=e.indexOf("silent")>-1;this._setCommunicationSubscriptions();var t=this._isInIframe()&&e.indexOf("frame-force-ui")!==-1;this._oCore=s;this._oDataCollector=new d(s);this._oCoreFacade=l(s);this._oExecutionScope=null;this._createElementSpies();n.attachLibraryChanged(R._onLibraryChanged.bind(R));if(!e||e.indexOf("silent")===-1||t){sap.ui.require(["sap/ui/support/supportRules/ui/IFrameController"],function(t){T=t;T.injectFrame(e);_.allowFrame(T.getCommunicationInfo())})}else{R.updateRuleSets(function(){this.fireEvent("ready")}.bind(this))}};I.prototype._createElementSpies=function(){var e=this,t=500;this._fnDirtyTimeoutHandle=null;var s=function(s){var o=i.prototype[s];i.prototype[s]=function(){o.apply(this,arguments);clearTimeout(e._fnDirtyTimeoutHandle);e._fnDirtyTimeoutHandle=setTimeout(function(){_.publish(h.ON_CORE_STATE_CHANGE)},t)}};s("register");s("deregister")};I.prototype._setCommunicationSubscriptions=function(){_.subscribe(h.VERIFY_CREATE_RULE,function(e){var t=y.deserialize(e),s=R.getRuleLib(S.TEMP_RULESETS_NAME).ruleset,i=s.addRule(t);_.publish(h.VERIFY_RULE_CREATE_RESULT,{result:i,newRule:y.serialize(t)})},this);_.subscribe(h.VERIFY_UPDATE_RULE,function(e){var t=y.deserialize(e.updateObj),s=R.getRuleLib(S.TEMP_RULESETS_NAME).ruleset,i=s.updateRule(e.oldId,t);_.publish(h.VERIFY_RULE_UPDATE_RESULT,{result:i,updateRule:y.serialize(t)})},this);_.subscribe(h.DELETE_RULE,function(e){var t=y.deserialize(e),s=R.getRuleLib(S.TEMP_RULESETS_NAME).ruleset;s.removeRule(t)},this);_.subscribe(h.OPEN_URL,function(e){var t=window.open(e,"_blank");t.opener=null;t.focus()},this);_.subscribe(h.ON_DOWNLOAD_REPORT_REQUEST,function(e){this._getReportData(e).then(function(e){sap.ui.require(["sap/ui/support/supportRules/report/ReportProvider"],function(t){t.downloadReportZip(e)})})},this);_.subscribe(h.HIGHLIGHT_ELEMENT,function(e){var t=i.getElementById(e).$();t.css("background-color","red")},this);_.subscribe(h.TREE_ELEMENT_MOUSE_ENTER,function(e){m.highlight(e)},this);_.subscribe(h.TREE_ELEMENT_MOUSE_OUT,function(){m.hideHighLighter()},this);_.subscribe(h.TOGGLE_FRAME_HIDDEN,function(e){T.toggleHide(e)},this);_.subscribe(h.POST_UI_INFORMATION,function(e){this._oDataCollector.setSupportAssistantLocation(e.location);this._oDataCollector.setSupportAssistantVersion(e.version)},this);_.subscribe(h.GET_AVAILABLE_COMPONENTS,function(){_.publish(h.POST_AVAILABLE_COMPONENTS,Object.keys(r.all()))},this);_.subscribe(h.ON_ANALYZE_REQUEST,function(e){this.analyze(e.executionContext,e.rulePreset)},this);_.subscribe(h.ON_INIT_ANALYSIS_CTRL,function(){R.updateRuleSets(function(){this.fireEvent("ready")}.bind(this))},this);_.subscribe(h.ON_SHOW_REPORT_REQUEST,function(e){this._getReportData(e).then(function(e){sap.ui.require(["sap/ui/support/supportRules/report/ReportProvider"],function(t){t.openReport(e)})})},this);_.subscribe(h.LOAD_RULESETS,function(e){R.loadAdditionalRuleSets(e.aLibNames)},this);_.subscribe(h.REQUEST_RULES_MODEL,function(e){if(e){_.publish(h.GET_RULES_MODEL,f.getTreeTableViewModel(e))}},this);_.subscribe(h.REQUEST_ISSUES,function(e){if(e){var t=f.groupIssues(e),s=f.getIssuesViewModel(t);_.publish(h.GET_ISSUES,{groupedIssues:t,issuesModel:s})}},this);_.subscribe(h.GET_NON_LOADED_RULE_SETS,function(e){R.fetchNonLoadedRuleSets(e.loadedRulesets)},this)};I.prototype.analyze=function(t,s,i){var o=this;if(this._oAnalyzer&&this._oAnalyzer.running()){return}if(typeof s==="string"){s=g.SystemPresets[s];if(!s){e.error("System preset ID is not valid");return}}t=t||{type:"global"};if(i){this._oAnalysisMetadata=JSON.parse(JSON.stringify(i))}else{this._oAnalysisMetadata=null}var r;if(s&&s.selections){this._oSelectedRulePreset=s;r=s.selections;if(!s.id||!s.title){e.error("The preset must have an ID and a title");return}}else{this._oSelectedRulePreset=null;r=s}r=r||R.getAllRuleDescriptors();if(!this._isExecutionScopeValid(t)){_.publish(h.POST_MESSAGE,{message:"Set a valid element ID."});return}_.publish(h.ON_ANALYZE_STARTED);if(t.selectors){this._mapExecutionScope(t)}this._oAnalyzer.reset();this.setExecutionScope(t);f.clearIssues();this._setSelectedRules(r);return this._oAnalyzer.start(this._aSelectedRules,this._oCoreFacade,this._oExecutionScope).then(function(){return o._done()})};I.prototype._isExecutionScopeValid=function(t){var s=[],o=false,r;if(p.possibleScopes.indexOf(t.type)===-1){e.error("Invalid execution scope type. Type must be one of the following: "+p.possibleScopes.join(", "));return false}if(t.type==="subtree"){if(t.parentId){s.push(t.parentId)}else if(Array.isArray(t.selectors)){s=s.concat(t.selectors)}else if(t.selectors){s.push(t.selectors)}for(r=0;r<s.length;r++){if(i.getElementById(s[r])){o=true;break}}if(!o){return false}}return true};I.prototype.setExecutionScope=function(e){this._oExecutionScope=p(this._oCore,e)};I.prototype._setSelectedRules=function(t){this._aSelectedRules=[];this._oSelectedRulesIds={};if(!t){return}if(!Array.isArray(t)){t=[t]}t.forEach(function(t){var s,i;if(!t.libName||!t.ruleId){e.error("["+S.SUPPORT_ASSISTANT_NAME+"] Invalid Rule Descriptor.");return}s=R.getRuleLib(t.libName);if(!s||!s.ruleset){e.error("["+S.SUPPORT_ASSISTANT_NAME+"] Could not find Ruleset for library "+t.libName);return}i=s.ruleset.getRules();if(!i||!i[t.ruleId]){e.error("["+S.SUPPORT_ASSISTANT_NAME+"] Could not find Rule with id "+t.ruleId+" for library "+t.libName);return}this._aSelectedRules.push(i[t.ruleId]);this._oSelectedRulesIds[t.ruleId]=true},this)};I.prototype._mapExecutionScope=function(e){if(e.type==="subtree"){if(typeof e.selectors==="string"){e.parentId=e.selectors}else if(Array.isArray(e.selectors)){e.parentId=e.selectors[0]}}else if(e.type==="components"){if(typeof e.selectors==="string"){e.components=[e.selectors]}else if(Array.isArray(e.selectors)){e.components=e.selectors}}delete e.selectors};I.prototype._done=function(){_.publish(h.ON_ANALYZE_FINISH,{issues:f.getIssuesModel(),elementTree:this._createElementTree(),elapsedTime:this._oAnalyzer.getElapsedTimeString()});return E.saveAnalysis(this)};I.prototype._createElementTree=function(){var e=this._copyElementsStructure(),t=[];this._setContextElementReferences(e);for(var s in e){if(e[s].skip){continue}t.push(e[s])}return[{content:t,id:"WEBPAGE",name:"WEBPAGE"}]};I.prototype._setContextElementReferences=function(e){var t=o.all();for(var s in e){var i=e[s],r=t[s]==undefined?undefined:t[s].getParent();if(t[s]instanceof b){var n=t[s],u=n.getComponent();if(u){i.content.push(e[u]);e[u].skip=true}}if(r){var a=r.getId();if(!e[a]){continue}e[a].content.push(e[s]);e[s].skip=true}}};I.prototype._copyElementsStructure=function(){var e={};var t=function(t,s){for(var i in t){if(Object.hasOwn(t,i)){var o=t[i];var r={content:[],id:o.getId(),name:s==undefined?o.getMetadata().getName():s};e[o.getId()]=r}}};t(this._oExecutionScope.getElements());this._oExecutionScope.getElements().forEach(function(e){if(e instanceof b){var s=e.getComponent(),i=r.get(s);if(i){t([i],"sap-ui-component")}}});switch(this._oExecutionScope.getType()){case"global":t(this._oCoreFacade.getUIAreas(),"sap-ui-area");t(this._oCoreFacade.getComponents(),"sap-ui-component");break;case"subtree":var s=this._oExecutionScope._getContext().parentId;t([o.get(s)]);break;case"components":var i=this._oExecutionScope._getContext().components;i.forEach(function(e){t([r.get(e)],"sap-ui-component")});break}return e};I.prototype._getReportData=function(e){return this._oDataCollector.getTechInfoJSON().then(function(t){var s=f.groupIssues(f.getIssuesModel()),i=R.getRuleLibs(),o=this._oSelectedRulesIds,r=this._oSelectedRulePreset||null;return{issues:s,technical:t,application:this._oDataCollector.getAppInfo(),rules:f.getRulesViewModel(i,o,s),rulePreset:r,scope:{executionScope:this._oExecutionScope,scopeDisplaySettings:{executionScopes:e.executionScopes,executionScopeTitle:e.executionScopeTitle}},analysisDuration:this._oAnalyzer.getElapsedTimeString(),analysisDurationTitle:e.analysisDurationTitle,abap:E.getFormattedHistory(g.HistoryFormats.Abap),name:S.SUPPORT_ASSISTANT_NAME}}.bind(this))};I.prototype.getAnalysisHistory=function(){if(this._oAnalyzer.running()){return null}return E.getHistory()};I.prototype.getFormattedAnalysisHistory=function(e){if(this._oAnalyzer.running()){return""}return E.getFormattedHistory(e)};I.prototype.getLastAnalysisHistory=function(){var e=this.getAnalysisHistory();if(Array.isArray(e)&&e.length>0){return e[e.length-1]}else{return null}};I.prototype.addRule=function(e){if(!e){return"No rule provided."}e.selected=e.selected!==undefined?e.selected:true;e.async=e.async||false;var t=R.getRuleLib(S.TEMP_RULESETS_NAME).ruleset.addRule(e);_.publish(h.VERIFY_RULE_CREATE_RESULT,{result:t,newRule:y.serialize(e)});return t};var A=new I;return A},true);
//# sourceMappingURL=Main.js.map