/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/core/Element","sap/ui/support/supportRules/ui/controllers/BaseController","sap/ui/support/supportRules/ui/models/SelectionUtils","sap/ui/support/supportRules/ui/models/PresetsUtils","sap/ui/core/Fragment","sap/m/MessageToast","sap/m/MessageBox","sap/ui/support/supportRules/ui/models/Documentation","sap/ui/support/supportRules/util/Utils","sap/m/GroupHeaderListItem","sap/base/util/deepExtend","sap/ui/core/library","sap/ui/core/date/UI5Date"],function(e,t,r,o,s,i,p,n,a,l,u,d,c){"use strict";var I=d.ValueState;var P={SELECT_FRAGMENT_ID:"presetsSelect",EXPORT_FRAGMENT_ID:"presetExport",IMPORT_FRAGMENT_ID:"presetImport",PRESET_GROUP_NONE:"None",PRESET_GROUP_SYSTEM:"System Presets",PRESET_GROUP_CUSTOM:"Custom Presets"};var f=t.extend("sap.ui.support.supportRules.ui.controllers.PresetsController",{constructor:function(e,r){t.call(this);this.oModel=e;this.oView=r}});f.prototype.openPresetVariant=function(){var e=this.oView.byId("presetVariantBtn");e.focus();if(!this._oPresetsPopover){this._oPresetsPopover=s.load({id:P.SELECT_FRAGMENT_ID,name:"sap.ui.support.supportRules.ui.views.Presets",controller:this}).then(function(e){this.oView.addDependent(e);return e}.bind(this))}this._oPresetsPopover.then(function(t){if(!t.isOpen()){t.setInitialFocus(s.byId(P.SELECT_FRAGMENT_ID,"select").getSelectedItem().getId());t.openBy(e)}else{t.close()}})};f.prototype.onPresetChange=function(e){var t=e.getParameter("listItem").getBindingContext().getPath();this._applyPreset(this.oModel.getProperty(t))};f.prototype.onPresetItemPress=function(){s.byId(P.SELECT_FRAGMENT_ID,"presetsPopover").close()};f.prototype.onPresetItemDelete=function(t){var r=t.getSource().getBindingContext().getPath(),s=this.oModel.getProperty(r),i=this.oModel.getProperty("/customPresets"),p=t.getSource().getDomRef().closest(".sapMLIB").getAttribute("id");var n=this.oModel.getProperty("/selectionPresets");var a=n.indexOf(s);if(a!==-1){n.splice(a,1)}if(s.selected){n[0].selected=true;this._applyPreset(n[0])}this.oModel.setProperty("/selectionPresets",n);if(s.isCustomPreset){i=i.filter(function(e){return e.id!==s.id});this.oModel.setProperty("/customPresets",i)}if(o.isPersistingAllowed()){o.persistSelectionPresets();o.persistCustomPresets()}if(a!==n.length){var l=e.getElementById(p),u=l.ontap;l.ontap=function(){l.ontap=u}}};f.prototype.onPresetItemReset=function(e){var t=e.getSource().getBindingContext().getPath(),r=this.oModel.getProperty(t),s=r.isSystemPreset?o.getSystemPresets():this.oModel.getProperty("/customPresets"),i=e.getSource().getParent().getParent().getParent();i.focus();s.forEach(function(e){if(e.id===r.id){this.oModel.setProperty(t+"/title",e.title);this.oModel.setProperty(t+"/selections",e.selections);this.oModel.setProperty(t+"/isModified",false)}}.bind(this));if(r.selected){this._applyPreset(r)}};f.prototype.onImportPress=function(){if(!this._oImportDialog){this._oImportDialog=s.load({id:P.IMPORT_FRAGMENT_ID,name:"sap.ui.support.supportRules.ui.views.PresetImport",controller:this}).then(function(e){this.oView.addDependent(e);return e}.bind(this))}this._oImportDialog.then(function(e){e.open()})};f.prototype.onImportFileChange=function(e){var t=e.getSource(),r=new FileReader;if(!t.getValue()){return}this._clearImportErrors();r.onloadend=this.onImportFileLoaded.bind(this);r.onerror=this.onImportFileError.bind(this);r.readAsText(e.getParameter("files")[0],"UTF-8")};f.prototype.onImportFileMismatch=function(e){this._clearImportErrors();this._reportImportFileError('Invalid file type "'+e.getParameter("mimeType")+'". Please, import a valid "application/json" file.',e.getParameter("fileName"))};f.prototype.onImportFileError=function(e){this._reportImportFileError('Error while reading file: "'+e.target.error+'".')};f.prototype.onImportFileLoaded=function(e){var t=this._tryParseImportFile(e.target.result);if(t){this._clearImportErrors();if(!t.id){t.id=a.generateUuidV4()}if(t.dateExported){t.dateExported=c.getInstance(t.dateExported)}this.oModel.setProperty("/currentImportData",t);if(!this._isAlreadyImported(t.id)){s.byId(P.IMPORT_FRAGMENT_ID,"importBtn").setEnabled(true)}}};f.prototype.onImportCancelPress=function(){s.byId(P.IMPORT_FRAGMENT_ID,"importDialog").close()};f.prototype.onImportFinalizePress=function(){var e=this.oModel.getProperty("/currentImportData"),t="";this._importPreset(e);t='The Rule Preset "'+e.title+'" was successfully imported.';if(!o.isPersistingAllowed()){t+=" This import can be stored for your next visit if you check "+'"I agree to use local storage persistency" from Support Assistant settings.'}s.byId(P.IMPORT_FRAGMENT_ID,"importDialog").close();i.show(t,{width:"50%"})};f.prototype.onImportDialogClose=function(){this._clearImportErrors();s.byId(P.IMPORT_FRAGMENT_ID,"fileUpload").setValue(null);this.oModel.setProperty("/currentImportData",null);s.byId(P.IMPORT_FRAGMENT_ID,"importBtn").setEnabled(false)};f.prototype.onExportPress=function(){var e=this.oModel.getProperty("/selectionPresetsCurrent");if(!e.selections.length){p.error("Cannot export Rule Preset without selections.");return}this.oModel.setProperty("/currentExportData",{id:e.isMySelection||e.isSystemPreset?"":e.id,title:e.title,descriptionValue:e.description,dateExportedForDisplay:c.getInstance(),isMySelection:e.isMySelection});if(!this._oExportDialog){this._oExportDialog=s.load({id:P.EXPORT_FRAGMENT_ID,name:"sap.ui.support.supportRules.ui.views.PresetExport",controller:this}).then(function(e){this.oView.addDependent(e);return e}.bind(this))}this._oExportDialog.then(function(e){e.open()})};f.prototype.initializeExportValidations=function(){var e=this._getInputsToValidate();e.forEach(function(e){s.byId(P.EXPORT_FRAGMENT_ID,e.id).attachChange(function(t){this._changeHandler(t,e.validateMessage)}.bind(this))},this)};f.prototype._changeHandler=function(e,t){this._validateInput(e.getSource(),t)};f.prototype._validateForm=function(){var e=true,t=this._getInputsToValidate();t.forEach(function(t){var r=s.byId(P.EXPORT_FRAGMENT_ID,t.id);if(!this._validateInput(r,t.validateMessage)){e=false}},this);return e};f.prototype._validateInput=function(e,t){var r=e.getBinding("value"),o=I.None,s=true;try{if(e.getRequired()&&!e.getValue().trim()){throw{name:"RequiredException",message:e.getLabels()[0].getText()+" is required."}}if(r&&r.getType()){r.getType().validateValue(e.getValue())}}catch(r){var i=r.message;if(r.name==="ValidateException"&&t){i=t}e.setValueStateText(i);o=I.Error;s=false}e.setValueState(o);return s};f.prototype._getInputsToValidate=function(){return[{id:"title"},{id:"presetId",validateMessage:"Invalid value. Possible characters are: a-z A-Z 0-9 - . _"}]};f.prototype._clearValidationState=function(){var e=this._getInputsToValidate();e.forEach(function(e){s.byId(P.EXPORT_FRAGMENT_ID,e.id).setValueState(I.None)})};f.prototype.onExportCancelPress=function(){s.byId(P.EXPORT_FRAGMENT_ID,"exportDialog").close()};f.prototype.onExportFinalizePress=function(){var e=s.byId(P.EXPORT_FRAGMENT_ID,"presetId").getValue(),t=s.byId(P.EXPORT_FRAGMENT_ID,"title").getValue(),p=s.byId(P.EXPORT_FRAGMENT_ID,"description").getValue();if(!this._validateForm()){return}if(!e){e=a.generateUuidV4()}o.exportSelectionsToFile(e,t,p,r.getSelectedRules());i.show('The Rule Preset "'+t+'" was successfully exported.',{width:"50%"});s.byId(P.EXPORT_FRAGMENT_ID,"exportDialog").close()};f.prototype.openHelp=function(){n.openTopic("3fc864acf926406194744375aa464fe7")};f.prototype._reportImportFileError=function(e,t){var r=s.byId(P.IMPORT_FRAGMENT_ID,"fileError"),o=s.byId(P.IMPORT_FRAGMENT_ID,"fileUpload"),i=s.byId(P.IMPORT_FRAGMENT_ID,"fileName"),p=s.byId(P.IMPORT_FRAGMENT_ID,"importBtn");r.setText(e).setVisible(true);i.addStyleClass("sapUiSupportToolError");this.oModel.setProperty("/currentImportData",{fileName:t||o.getValue()});p.setEnabled(false)};f.prototype._isAlreadyImported=function(e){var t=this.oModel.getProperty("/selectionPresets"),r=t.some(function(t){return t.id===e});if(r){s.byId(P.IMPORT_FRAGMENT_ID,"duplicateIdError").setText("A preset with ID '"+e+"' is already imported.").setVisible(true);s.byId(P.IMPORT_FRAGMENT_ID,"presetId").addStyleClass("sapUiSupportToolError");return true}else{return false}};f.prototype._clearImportErrors=function(){s.byId(P.IMPORT_FRAGMENT_ID,"fileError").setText("").setVisible(false);s.byId(P.IMPORT_FRAGMENT_ID,"fileName").removeStyleClass("sapUiSupportToolError");s.byId(P.IMPORT_FRAGMENT_ID,"duplicateIdError").setText("").setVisible(false);s.byId(P.IMPORT_FRAGMENT_ID,"presetId").removeStyleClass("sapUiSupportToolError")};f.prototype._tryParseImportFile=function(e){var t={};var r='The file cannot be uploaded. Please, choose an "application/json" file exported from the Support Assistant.';try{t=JSON.parse(e)}catch(e){this._reportImportFileError(r);return false}var i=[];if(!o.isValidSelectionImport(t,i)){this._reportImportFileError(r);return false}t.fileName=s.byId(P.IMPORT_FRAGMENT_ID,"fileUpload").getValue();return t};f.prototype._importPreset=function(e){var t=this.oModel.getProperty("/selectionPresets"),r=this.oModel.getProperty("/customPresets");var s={id:e.id,title:e.title,description:e.description,dateExported:e.dateExported,version:e.version,selections:e.selections};t.forEach(function(e){e.selected=false});s.selected=true;s.isCustomPreset=true;t.push(s);r.push(u({},s));if(o.isPersistingAllowed()){o.persistCustomPresets()}this._applyPreset(s)};f.prototype._applyPreset=function(e){this.oModel.setProperty("/selectionPresetsCurrent",e);r.setSelectedRules(e.selections);if(o.isPersistingAllowed()){o.persistSelectionPresets()}};f.prototype.grouper=function(e){if(e.getProperty("isSystemPreset")){return P.PRESET_GROUP_SYSTEM}if(e.getProperty("isCustomPreset")){return P.PRESET_GROUP_CUSTOM}return P.PRESET_GROUP_NONE};f.prototype.getGroupHeader=function(e){var t=!(e.key===P.PRESET_GROUP_NONE);return new l({title:e.key,visible:t}).addStyleClass("sapUiSupportToolGHLI")};return f});
//# sourceMappingURL=PresetsController.js.map