/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["./AnalyticalColumn","./Column","./Table","./TreeTable","./TableRenderer","./menus/AnalyticalTableContextMenu","sap/ui/core/Element","sap/ui/model/analytics/ODataModelAdapter","./utils/TableUtils","./plugins/BindingSelection","sap/base/Log","sap/ui/thirdparty/jquery","sap/ui/model/controlhelper/TreeBindingProxy"],function(e,t,o,n,i,s,r,a,l,p,u,jQuery,d){"use strict";const c=l.createWeakMapFacade();const y=o.extend("sap.ui.table.AnalyticalTable",{metadata:{library:"sap.ui.table",properties:{sumOnTop:{type:"boolean",group:"Appearance",defaultValue:false,deprecated:true},numberOfExpandedLevels:{type:"int",group:"Misc",defaultValue:0,deprecated:true},autoExpandMode:{type:"string",group:"Misc",defaultValue:"Bundled",deprecated:true},columnVisibilityMenuSorter:{type:"any",group:"Appearance",defaultValue:null},collapseRecursive:{type:"boolean",defaultValue:true,deprecated:true},dirty:{type:"boolean",group:"Appearance",defaultValue:null,deprecated:true},extendedGroupHeaderMenu:{type:"boolean",group:"Behavior",defaultValue:true,visibility:"hidden"}},events:{group:{allowPreventDefault:true,parameters:{column:{type:"sap.ui.table.AnalyticalColumn"}}}},designtime:"sap/ui/table/designtime/AnalyticalTable.designtime"},renderer:i});y.prototype._getFixedBottomRowContexts=function(){const e=this.getBinding();return e?[e.getGrandTotalNode()]:[]};y.prototype._getContexts=function(e,t,o){if(!this.getVisible()){return[]}const n=this.getBinding();if(n){return n.getNodes(e,t,o)}else{return[]}};y.prototype._getRowContexts=n.prototype._getRowContexts;y.prototype.init=function(){o.prototype.init.apply(this,arguments);this.addStyleClass("sapUiAnalyticalTable");this.setShowColumnVisibilityMenu(true);this.setEnableColumnFreeze(true);this.setEnableCellFilter(true);this.setProperty("rowCountConstraints",{fixedTop:false,fixedBottom:false});this._aGroupedColumns=[];this._bSuspendUpdateAnalyticalInfo=false;l.Grouping.setToDefaultGroupMode(this);l.Hook.register(this,l.Hook.Keys.Row.UpdateState,f,this);l.Hook.register(this,l.Hook.Keys.Row.Expand,g,this);l.Hook.register(this,l.Hook.Keys.Row.Collapse,h,this);this._oProxy=new d(this,"rows")};y.prototype.setFixedRowCount=function(){u.error("The property fixedRowCount is not supported by control sap.ui.table.AnalyticalTable!");return this};y.prototype.setFixedBottomRowCount=function(){u.error("The property fixedBottomRowCount is managed by control sap.ui.table.AnalyticalTable!");return this};y.prototype.setDirty=function(e){u.error("The property dirty of control sap.ui.table.AnalyticalTable is deprecated. Please use showOverlay instead.");this.setProperty("dirty",e,true);this.setShowOverlay(this.getDirty());return this};y.prototype.setEnableGrouping=function(){u.error("The property enableGrouping is not supported by the sap.ui.table.AnalyticalTable control");return this};y.prototype.setGroupBy=function(){u.warning("The groupBy association is not supported by the sap.ui.table.AnalyticalTable control");return this};y.prototype.getModel=function(e){const t=o.prototype.getModel.apply(this,arguments);const n=this.getBindingInfo("rows");if(t&&n&&n.model===e){a.apply(t)}return t};y.prototype.updateRows=function(e){o.prototype.updateRows.apply(this,arguments);if(e!=="sort"){this._invalidateColumnMenus()}};y.prototype._bindRows=function(e){delete c(this).bPendingRequest;this._applyAnalyticalBindingInfo(e);o.prototype._bindRows.call(this,e)};y.prototype._bindAggregation=function(e,t){if(e==="rows"){this._invalidateColumnMenus();this._setFirstVisibleRowIndex(0,{onlySetProperty:true})}o.prototype._bindAggregation.call(this,e,t);if(e==="rows"){this._updateTotalRow(true);l.Binding.metadataLoaded(this).then(function(){this._updateColumns(true)}.bind(this))}};y.prototype._applyAnalyticalBindingInfo=function(e){e.parameters=e.parameters||{};e.parameters.analyticalInfo=this._getColumnInformation();if(!e.parameters.hasOwnProperty("sumOnTop")){e.parameters.sumOnTop=this.getSumOnTop()}if(!e.parameters.hasOwnProperty("numberOfExpandedLevels")){e.parameters.numberOfExpandedLevels=this.getNumberOfExpandedLevels()}if(e.parameters.numberOfExpandedLevels>this._aGroupedColumns.length){e.parameters.numberOfExpandedLevels=0}if(!e.parameters.hasOwnProperty("autoExpandMode")){let t=this.getAutoExpandMode();if(t!=="Bundled"&&t!=="Sequential"){t="Bundled"}e.parameters.autoExpandMode=t}};y.prototype._getColumnInformation=function(){const t=[];const o=this.getColumns();for(let e=0;e<this._aGroupedColumns.length;e++){const o=r.getElementById(this._aGroupedColumns[e]);if(!o){continue}t.push({name:o.getLeadingProperty(),visible:o.getVisible(),grouped:o.getGrouped(),total:o.getSummed(),inResult:o.getInResult(),formatter:o.getGroupHeaderFormatter()})}for(let n=0;n<o.length;n++){const i=o[n];if(this._aGroupedColumns.indexOf(i.getId())>-1){continue}if(!(i instanceof e)){u.error("You have to use AnalyticalColumns for the Analytical table")}t.push({name:i.getLeadingProperty(),visible:i.getVisible(),grouped:i.getGrouped(),total:i.getSummed(),inResult:i.getInResult(),formatter:i.getGroupHeaderFormatter()})}return t};function f(e){const t=this.getBinding();const o=this.getBindingInfo("rows");const n=e.context;e.context=n.context;if(!e.context){return}if(t.nodeHasChildren(n)){e.type=e.Type.GroupHeader;e.expandable=true}else if(n.nodeState.sum){e.type=e.Type.Summary}e.level=n.level+(e.type===e.Type.Summary?1:0);e.expanded=n.nodeState.expanded;e.contentHidden=e.expanded&&!o.parameters.sumOnTop;e.title=e.type===e.Type.GroupHeader?t.getGroupName(n.context,n.level):""}function g(e){this.expand(e.getIndex())}function h(e){this.collapse(e.getIndex())}y.prototype.onRowsUpdated=function(e){o.prototype.onRowsUpdated.apply(this,arguments);const n=this.getRows();const i=this.getBinding();const s=this._getVisibleColumns()[0];for(let e=0;e<n.length;e++){const o=n[e];const r=o.getCells();const a=r.length;for(let e=0;e<a;e++){const n=t.ofCell(r[e]);const a=i?i.isMeasure(n.getLeadingProperty()):false;const l=jQuery(r[e].$().closest("td"));let p=false;if(o.isSummary()&&a){p=!n.getSummed()}else if(o.isGroupHeader()&&n===s){p=!a}l.toggleClass("sapUiTableCellHidden",p)}}};y.prototype.getContextByIndex=function(e){return this._oProxy.getContextByIndex(e)};y.prototype.getContextInfoByIndex=function(e){return this._oProxy.getNodeByIndex(e)};y.prototype.suspendUpdateAnalyticalInfo=function(){this._bSuspendUpdateAnalyticalInfo=true};y.prototype.resumeUpdateAnalyticalInfo=function(e,t){this._bSuspendUpdateAnalyticalInfo=false;this._updateColumns(e,t)};y.prototype.addColumn=function(e,t){const n=this._getColumn(e);if(n.getGrouped()){this._addGroupedColumn(n.getId())}o.prototype.addColumn.call(this,n,t);this._updateColumns(t);return this};y.prototype.insertColumn=function(e,t,n){const i=this._getColumn(e);if(i.getGrouped()){this._addGroupedColumn(i.getId())}o.prototype.insertColumn.call(this,i,t,n);this._updateColumns(n);return this};y.prototype.removeColumn=function(e,t){const n=o.prototype.removeColumn.apply(this,arguments);if(!this._bReorderInProcess){this._aGroupedColumns=jQuery.grep(this._aGroupedColumns,function(t){if(e.getId){return t!==e.getId()}else{return t===e}})}this.updateAnalyticalInfo(t);return n};y.prototype.removeAllColumns=function(e){this._aGroupedColumns=[];const t=o.prototype.removeAllColumns.apply(this,arguments);this._updateColumns(e);return t};y.prototype._getColumn=function(t){if(typeof t==="string"){const o=new e({leadingProperty:t,template:t,managed:true});return o}else if(t instanceof e){return t}else{throw new Error("Wrong column type. You need to define a string (property) or pass an AnalyticalColumnObject")}};y.prototype._updateColumns=function(e,t){if(!this._bSuspendUpdateAnalyticalInfo){this._updateTableColumnDetails();this.updateAnalyticalInfo(e,t);if(this.bOutput){this.invalidate()}}};y.prototype.updateAnalyticalInfo=function(e,t){if(this._bSuspendUpdateAnalyticalInfo){return}const o=this.getBinding();if(o){const n=this._getColumnInformation();const i=o.getNumberOfExpandedLevels()||0;if(i>this._aGroupedColumns.length){o.setNumberOfExpandedLevels(0)}o.updateAnalyticalInfo(n,t);this._updateTotalRow(e);if(!e){this._getRowContexts()}}};y.prototype.refreshRows=function(){o.prototype.refreshRows.apply(this,arguments);this._updateTotalRow()};y.prototype._updateTotalRow=function(e){const t=this.getBinding();this.setProperty("rowCountConstraints",{fixedTop:false,fixedBottom:t?t.providesGrandTotal()&&t.hasTotaledMeasures():false},e)};y.prototype._updateTableColumnDetails=function(){if(this._bSuspendUpdateAnalyticalInfo){return}const e=this.getBinding();const t=e&&e.getAnalyticalQueryResult();if(t){const e=this.getColumns();const o=[];let n=[];const i=[];const s={};let a;let l;for(let n=0;n<e.length;n++){a=e[n];a._isLastGroupableLeft=false;a._bLastGroupAndGrouped=false;a._bDependendGrouped=false;if(!a.getVisible()){continue}const r=a.getLeadingProperty();l=t.findDimensionByPropertyName(r);if(l){const e=l.getName();if(!s[e]){s[e]={dimension:l,columns:[a]}}else{s[e].columns.push(a)}if(a.getGrouped()&&o.indexOf(e)===-1){o.push(e)}if(i.indexOf(e)===-1){i.push(e)}}}n=jQuery.grep(i,function(e){return o.indexOf(o,e)===-1});if(o.length>0){jQuery.each(o,function(e,t){jQuery.each(s[t].columns,function(e,t){if(!t.getGrouped()){t._bDependendGrouped=true}})});if(o.length===i.length){l=t.findDimensionByPropertyName(r.getElementById(this._aGroupedColumns[this._aGroupedColumns.length-1]).getLeadingProperty());const e=s[l.getName()].columns;jQuery.each(e,function(e,t){t._bLastGroupAndGrouped=true})}}if(n.length===1){jQuery.each(s[n[0]].columns,function(e,t){t._isLastGroupableLeft=true})}}};y.prototype._getFirstMeasureColumnIndex=function(){const e=this.getBinding();const t=e&&e.getAnalyticalQueryResult();const o=this._getVisibleColumns();if(!t){return-1}for(let e=0;e<o.length;e++){const n=o[e];const i=n.getLeadingProperty();if(t.findMeasureByName(i)||t.findMeasureByPropertyName(i)){return e}}};y.prototype._getTotalRowCount=function(){let e=o.prototype._getTotalRowCount.apply(this,arguments);if(e===1){const t=this.getBinding();const o=t?t.providesGrandTotal()&&t.hasTotaledMeasures():false;if(o){e=0}}return e};y.prototype.getTotalSize=function(){const e=this.getBinding();if(e){return e.getTotalSize()}return 0};y.prototype._onPersoApplied=function(){o.prototype._onPersoApplied.apply(this,arguments);this._aGroupedColumns=[];const e=this.getColumns();for(let t=0,o=e.length;t<o;t++){if(e[t].getGrouped()){this._addGroupedColumn(e[t].getId())}}this._updateColumns()};y.prototype._addGroupedColumn=function(e){if(this._aGroupedColumns.indexOf(e)===-1){this._aGroupedColumns.push(e)}};y.prototype._removeGroupedColumn=function(e){const t=this._aGroupedColumns.indexOf(e);if(t>=0){this._aGroupedColumns.splice(t,1)}};y.prototype.getGroupedColumns=function(){return this._aGroupedColumns};y.prototype.setCollapseRecursive=function(e){this._oProxy.setCollapseRecursive(e);this.setProperty("collapseRecursive",!!e,true);return this};y.prototype.expand=n.prototype.expand;y.prototype.collapse=n.prototype.collapse;y.prototype.expandAll=function(){this._oProxy.expandToLevel(this._aGroupedColumns.length);this.setFirstVisibleRow(0);this._getSelectionPlugin().clearSelection();return this};y.prototype.collapseAll=n.prototype.collapseAll;y.prototype.isExpanded=n.prototype.isExpanded;y.prototype.getAnalyticalInfoOfRow=function(e){const t=this.getBinding();const o=e?e.getRowBindingContext():null;if(!l.isA(e,"sap.ui.table.Row")||e.getParent()!==this||!t||!o){return null}const n=o===t.getGrandTotalContext();let i=null;let s=-1;if(n){i=t.getGrandTotalContextInfo();s=0}else{i=this.getContextInfoByIndex(e.getIndex());if(i){s=i.level}}const r=i&&t.nodeHasChildren&&t.nodeHasChildren(i);const a=!r&&!n&&i&&i.nodeState&&i.nodeState.sum;const p=[];if(a||r){const e=this.getGroupedColumns();if(e.length>0&&s>0&&s<=e.length){for(let t=0;t<s;t++){p.push(e[t])}}}return{grandTotal:n,group:r,groupTotal:a,level:s,context:o,groupedColumns:p}};y.prototype._createLegacySelectionPlugin=function(){return new p};y.prototype._setRowCountConstraints=function(){};y.prototype._getDefaultContextMenu=function(){let e=this.getAggregation("_hiddenDependents").find(e=>e.isA("sap.ui.table.menus.AnalyticalTableContextMenu"));if(!e){e=new s;this.addAggregation("_hiddenDependents",e)}return e};y.prototype._onBindingDataRequested=function(e){if(e.getParameter("__simulateAsyncAnalyticalBinding")){return}const t=this.getBinding();if(!t.bUseBatchRequests){c(this).bPendingRequest=true}o.prototype._onBindingDataRequested.apply(this,arguments)};y.prototype._onBindingDataReceived=function(e){if(e.getParameter("__simulateAsyncAnalyticalBinding")){return}const t=this.getBinding();if(!t.bUseBatchRequests){c(this).bPendingRequest=false}o.prototype._onBindingDataReceived.apply(this,arguments)};y.prototype._isWaitingForData=function(){if(c(this).hasOwnProperty("bPendingRequest")){return c(this).bPendingRequest}else{return o.prototype._isWaitingForData.apply(this,arguments)}};return y});
//# sourceMappingURL=AnalyticalTable.js.map