/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["./utils/TableUtils","./menus/ColumnHeaderMenuAdapter","sap/ui/core/Element","sap/ui/core/library","sap/ui/model/Filter","sap/ui/model/FilterOperator","sap/ui/model/FilterType","sap/ui/model/Sorter","sap/ui/model/Type","sap/ui/model/type/String","sap/base/util/ObjectPath","sap/base/util/JSTokenizer","sap/base/Log"],function(e,t,r,o,n,i,l,s,a,u,p,f,d){"use strict";const g=o.HorizontalAlign;const c=o.SortOrder;const h=o.ValueState;const y={Standard:"Standard",Creation:"Creation"};const m=e.createWeakMapFacade();const b=new window.WeakMap;const T=r.extend("sap.ui.table.Column",{metadata:{library:"sap.ui.table",properties:{width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},minWidth:{type:"int",group:"Dimension",defaultValue:0},flexible:{type:"boolean",group:"Behavior",defaultValue:true,deprecated:true},resizable:{type:"boolean",group:"Behavior",defaultValue:true},hAlign:{type:"sap.ui.core.HorizontalAlign",group:"Appearance",defaultValue:g.Begin},sorted:{type:"boolean",group:"Appearance",defaultValue:false,deprecated:true},sortOrder:{type:"sap.ui.core.SortOrder",group:"Appearance",defaultValue:c.None},sortProperty:{type:"string",group:"Behavior",defaultValue:null},filtered:{type:"boolean",group:"Appearance",defaultValue:false},filterProperty:{type:"string",group:"Behavior",defaultValue:null},filterValue:{type:"string",group:"Behavior",defaultValue:null},filterOperator:{type:"string",group:"Behavior",defaultValue:null},defaultFilterOperator:{type:"string",group:"Behavior",defaultValue:null},filterType:{type:"any",group:"Misc",defaultValue:null},grouped:{type:"boolean",group:"Appearance",defaultValue:false,deprecated:true},visible:{type:"boolean",group:"Appearance",defaultValue:true},name:{type:"string",group:"Appearance",defaultValue:null},showFilterMenuEntry:{type:"boolean",group:"Appearance",defaultValue:true},showSortMenuEntry:{type:"boolean",group:"Appearance",defaultValue:true},headerSpan:{type:"any",group:"Behavior",defaultValue:1},autoResizable:{type:"boolean",group:"Behavior",defaultValue:false}},defaultAggregation:"label",aggregations:{label:{type:"sap.ui.core.Control",altTypes:["string"],multiple:false},multiLabels:{type:"sap.ui.core.Control",multiple:true,singularName:"multiLabel"},template:{type:"sap.ui.core.Control",altTypes:["string"],multiple:false},creationTemplate:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"},menu:{type:"sap.ui.unified.Menu",multiple:false},_action:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"}},associations:{headerMenu:{type:"sap.ui.core.IColumnHeaderMenu",multiple:false}},events:{columnMenuOpen:{allowPreventDefault:true,parameters:{menu:{type:"sap.ui.unified.Menu"}}}}}});T._DEFAULT_FILTER_TYPE=new u;T.prototype.init=function(){this.mSkipPropagation={template:true,creationTemplate:true};m(this).oSorter=null;m(this).mCellContentVisibilitySettings=F(this);m(this).bHasDefaultLabel=false;m(this).bHasDefaultTemplate=false;this._initTemplateClonePool()};T.prototype._initTemplateClonePool=function(){this._mTemplateClones=Object.keys(y).reduce(function(e,t){e[t]=[];return e},{})};T.prototype.exit=function(){this._destroyTemplateClones();t.unlink(this)};T.prototype.invalidate=function(t){if(t!==this.getTemplate()&&t!==this.getCreationTemplate()&&!e.isA(t,"sap.ui.table.ColumnMenu")){r.prototype.invalidate.apply(this,arguments)}};T.prototype.setLabel=function(t){let r=t;if(typeof t==="string"){if(m(this).bHasDefaultLabel){this.getLabel().setText(t);return this}r=e._getTableTemplateHelper().createLabel({text:t});m(this).bHasDefaultLabel=true}else if(m(this).bHasDefaultLabel){this.destroyLabel();m(this).bHasDefaultLabel=false}if(r&&r.setIsInColumnHeaderContext){r.setIsInColumnHeaderContext(true)}const o=this.getLabel();if(o&&r!==o&&o.setIsInColumnHeaderContext){o.setIsInColumnHeaderContext(false)}return this.setAggregation("label",r)};T.prototype.setTemplate=function(t){let r=t;const o=this._getTable();const n=this.getTemplate();let i=true;if(typeof t==="string"){if(m(this).bHasDefaulTemplate){this.getTemplate().bindProperty("text",t);i=false}else{r=e._getTableTemplateHelper().createTextView().bindProperty("text",t);m(this).bHasDefaulTemplate=true}}else if(m(this).bHasDefaulTemplate){this.destroyTemplate();m(this).bHasDefaulTemplate=false}if(i){this.setAggregation("template",r,true)}if(this.getVisible()){this.invalidate()}this._destroyTemplateClones("Standard");if(o&&this.getVisible()){if(r){o.invalidateRowsAggregation()}if(!n||!r){const e=o.getCreationRow();if(e){e._update()}}}return this};T.prototype.destroyTemplate=function(){this.destroyAggregation("template");this._destroyTemplateClones("Standard");const e=this._getTable();const t=e?e.getCreationRow():null;if(t){t._update()}return this};T.prototype.setCreationTemplate=function(e){const t=this._getTable();this.setAggregation("creationTemplate",e,true);this._destroyTemplateClones("Creation");if(e&&t&&this.getVisible()){const e=t.getCreationRow();if(e){e._update()}}return this};T.prototype.getCreationTemplate=function(){return this.getAggregation("creationTemplate")};T.prototype.destroyCreationTemplate=function(){this.destroyAggregation("creationTemplate",true);this._destroyTemplateClones("Creation");return this};T.prototype._menuHasItems=function(){const e=this._getTable();const t=(e?e.getEnableColumnFreeze():false)||(e?e.getShowColumnVisibilityMenu():false)||this.isSortableByMenu()||this.isFilterableByMenu()||this.isGroupableByMenu();return t};T.prototype.isFilterableByMenu=function(){return!!(this.getFilterProperty()&&this.getShowFilterMenuEntry())};T.prototype.isSortableByMenu=function(){return!!(this.getSortProperty()&&this.getShowSortMenuEntry())};T.prototype.isGroupableByMenu=function(){const e=this._getTable();return!!(e&&e.getEnableGrouping&&e.getEnableGrouping()&&this.getSortProperty())};T.prototype._isGroupableByMenu=function(){let e=false;e=this.isGroupableByMenu();return e};T.prototype.setSorted=function(e){if(e&&this.getSortOrder()===c.None&&!this.isBound("sortOrder")){this.setSortOrder(c.Ascending)}return this.setProperty("sorted",e)};T.prototype.setFilterValue=function(e){return this.setProperty("filterValue",e,true)};T.prototype.setFilterOperator=function(e){return this.setProperty("filterOperator",e,true)};T.prototype.setDefaultFilterOperator=function(e){return this.setProperty("defaultFilterOperator",e,true)};T.prototype._openHeaderMenu=function(e){const r=this.getHeaderMenuInstance();this._cellPressed=e;t.activateFor(this).then(function(){if(r){r.openBy(e)}})};T.prototype._isHeaderMenuOpen=function(){const e=this.getHeaderMenuInstance();return e?.isOpen()||false};T.prototype._setGrouped=function(e){const t=this._getTable();t.setGroupBy(e?this:null)};T.prototype._isAggregatableByMenu=function(){return false};T.prototype.toggleSort=function(){this.sort(this.getSorted()&&this.getSortOrder()===c.Ascending)};T.prototype.sort=function(e,t){this._sort(e?c.Descending:c.Ascending,t);return this};T.prototype._sort=function(e,t){const r=this._getTable();if(!r||this.getSortProperty()===""){return}const o=r.fireSort({column:this,sortOrder:e,columnAdded:e!==c.None&&t===true});if(!o){return}if(e===c.None){r._removeSortedColumn(this)}else{r.pushSortedColumn(this,t)}this.setSorted(e!==c.None);this.setSortOrder(e);this._updateSorters()};T.prototype._updateSorters=function(){const e=this._getTable();const t=e.getSortedColumns();const r=e.getColumns();const o=this.getSortOrder();for(let e=0,o=r.length;e<o;e++){if(t.indexOf(r[e])<0){r[e].resetProperty("sorted");r[e].resetProperty("sortOrder");delete m(r[e]).oSorter}}if(o!==c.None){m(this).oSorter=new s(this.getSortProperty(),o===c.Descending)}this._applySorters()};T.prototype._applySorters=function(){const e=this._getTable();const t=e.getBinding();if(!t){d.warning("Sorting not performed because no binding present",this);return}const r=e.getSortedColumns();const o=r.map(e=>m(e).oSorter);t.sort(o)};T.prototype._getFilterState=function(){try{this._getFilter();return h.None}catch(e){return h.Error}};T.prototype._getFilter=function(){let e;const t=this.getFilterProperty();const r=this.getFilterValue();let o=this.getFilterOperator();let l;let s;const a=this.getFilterType()||T._DEFAULT_FILTER_TYPE;const p=a instanceof u;let f;if(r){if(!o){f=r.match(/(.*)\s*\.\.\s*(.*)/);if(r.indexOf("=")===0){o=i.EQ;l=r.substr(1)}else if(r.indexOf("!=")===0){o=i.NE;l=r.substr(2)}else if(r.indexOf("<=")===0){o=i.LE;l=r.substr(2)}else if(r.indexOf("<")===0){o=i.LT;l=r.substr(1)}else if(r.indexOf(">=")===0){o=i.GE;l=r.substr(2)}else if(r.indexOf(">")===0){o=i.GT;l=r.substr(1)}else if(f){if(f[1]&&f[2]){o=i.BT;l=f[1];s=f[2]}else if(f[1]&&!f[2]){o=i.GE;l=f[1]}else{o=i.LE;l=f[2]}}else if(p&&r.indexOf("*")===0&&r.lastIndexOf("*")===r.length-1){o=i.Contains;l=r.substr(1,r.length-2)}else if(p&&r.indexOf("*")===0){o=i.EndsWith;l=r.substr(1)}else if(p&&r.lastIndexOf("*")===r.length-1){o=i.StartsWith;l=r.substr(0,r.length-1)}else{if(this.getDefaultFilterOperator()){o=this.getDefaultFilterOperator()}else if(p){o=i.Contains}else{o=i.EQ}l=r.substr(0)}if(!s){e=new n(t,o,this._parseFilterValue(l))}else{e=new n(t,o,this._parseFilterValue(l),this._parseFilterValue(s))}}else{e=new n(t,o,this._parseFilterValue(r))}}return e};T.prototype.filter=function(t){const r=this._getTable();if(!r?.getBinding()||this.getFilterProperty()===""){return}const o=r.fireFilter({column:this,value:t});if(!o){return}const n=[];const i=r.getColumns();this.setFiltered(!!t);this.setFilterValue(t);for(let t=0,r=i.length;t<r;t++){const r=i[t];let o;let l;try{o=r._getFilter();l=h.None}catch(e){l=h.Error}if(o){n.push(o)}e.Hook.call(this._getTable(),e.Hook.Keys.Column.SetFilterState,r,l)}r.getBinding().filter(n,l.Control)};T.prototype._parseFilterValue=function(e){const t=this.getFilterType();if(t){if(typeof t==="function"){e=t(e)}else{e=t.parseValue(e,"string")}}return e};T.prototype.shouldRender=function(){let e=this.getVisible()&&this.getTemplate()!=null;e=e&&!this.getGrouped();return e};T.prototype.setProperty=function(e,t){const o=this._getTable();const n=o&&this.getProperty(e)!==t;const i=n&&e==="visible";const l=n&&(e==="visible"||e==="headerSpan");const s=r.prototype.setProperty.apply(this,arguments);if(i){o.invalidateRowsAggregation();const e=o.getCreationRow();if(e){e._update()}}if(l){o._invalidateComputedFixedColumnCount()}return s};T.prototype.setFilterType=function(e){let t=e;if(typeof e==="string"){try{const r=f.parseJS(e);if(typeof r.type==="string"){let o=sap.ui.require(r.type.replaceAll(".","/"));if(!o){o=p.get(e)}t=o&&new o(r.formatOptions,r.constraints)}}catch(r){let o=sap.ui.require(e.replaceAll(".","/"));if(!o){o=p.get(e)}t=o&&new o}if(!(t instanceof a)){d.error("The filter type is not an instance of sap.ui.model.Type! Ignoring the filter type!");t=undefined}}this.setProperty("filterType",t,true);return this};T.prototype.getIndex=function(){const e=this._getTable();if(e){return e.indexOfColumn(this)}else{return-1}};T.prototype.isDragAllowed=function(t){return e.Column.isColumnMovable(this,true)};T.prototype._getFreeTemplateClone=function(e){const t=this._mTemplateClones[e];let r=null;if(!t){return null}for(let e=0;e<t.length;e++){if(!t[e]||t[e].bIsDestroyed){t.splice(e,1);e--}else if(!r&&!t[e].getParent()){r=t[e]}}return r};T.prototype.getTemplateClone=function(e,t){if(typeof e!=="number"||this.getTemplate()==null){return null}const r=t==null?"Standard":t;let o=this._getFreeTemplateClone(r);if(!o&&y.hasOwnProperty(r)){const e=this["get"+(r==="Standard"?"":r)+"Template"];const t=e.call(this);if(t){o=t.clone();if(!o.getFieldHelpDisplay()){o.setFieldHelpDisplay(this)}this._mTemplateClones[r].push(o)}}if(o){b.set(o,this);const e=this._getTable();if(e){e._getAccExtension().addColumnHeaderLabel(this,o)}}return o};function C(e){for(let t=0;t<e.length;t++){if(e[t]!=null&&!e[t].bIsDestroyed){e[t].destroy()}}}T.prototype._destroyTemplateClones=function(e){if(e==null){for(const e in y){C(this._mTemplateClones[e])}this._initTemplateClonePool()}else{C(this._mTemplateClones[e]);this._mTemplateClones[e]=[]}};T.prototype._getTable=function(){const t=this.getParent();return e.isA(t,"sap.ui.table.Table")?t:null};T.prototype._setCellContentVisibilitySettings=function(e){_(e);m(this).mCellContentVisibilitySettings=F(this,e)};T.prototype._getCellContentVisibilitySettings=function(){return m(this).mCellContentVisibilitySettings};T.prototype.getHeaderMenuInstance=function(){return r.getElementById(this.getHeaderMenu())};function _(e){if(e==null){return}S(e,null,false,["standard","groupHeader","summary"]);S(e.standard,"standard",true);S(e.groupHeader,"groupHeader",true,["nonExpandable","expanded","collapsed"]);S(e.summary,"summary",true,["group","total"])}function S(e,t,r,o){if(e!=null&&!(r&&typeof e==="boolean"||o&&typeof e==="object")){throw new Error("Invalid value"+(t?" for '"+t+"'":""))}if(o&&e!=null&&typeof e==="object"){Object.keys(e).forEach(function(r){if(o.includes(r)){if(t!=null){S(e[r],t+"."+r,true)}}else{throw new Error("Unsupported setting '"+(t?t+".":"")+r+"'")}})}}function F(e,t){t=t?t:{};return{standard:V(t.standard),groupHeader:{nonExpandable:V(t.groupHeader,"nonExpandable"),expanded:V(t.groupHeader,"expanded"),collapsed:V(t.groupHeader,"collapsed")},summary:{group:V(t.summary,"group"),total:V(t.summary,"total")}}}function V(e,t){if(typeof e==="boolean"){return e}else if(t&&e){return e[t]!==false}else{return true}}T.ofCell=function(e){return b.get(e)||null};T.prototype.autoResize=function(){if(!this.getDomRef()){throw new Error("Column is not rendered")}e.Column.autoResizeColumn(this)};T.prototype.getFieldHelpInfo=function(){return{label:e.Column.getHeaderText(this)}};return T});
//# sourceMappingURL=Column.js.map