/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["./library","sap/ui/core/Element","sap/ui/unified/Menu","sap/ui/unified/MenuItem","sap/ui/unified/MenuTextFieldItem","sap/ui/unified/MenuRenderer","./utils/TableUtils","sap/base/assert","sap/ui/thirdparty/jquery"],function(t,e,i,n,o,s,u,l,jQuery){"use strict";const r=new window.WeakMap;const a=i.extend("sap.ui.table.ColumnMenu",{metadata:{library:"sap.ui.table"},renderer:s});a.prototype.init=function(){if(i.prototype.init){i.prototype.init.apply(this,arguments)}this.addStyleClass("sapUiTableColumnMenu");this._bInvalidated=true;this._iPopupClosedTimeoutId=null};a.prototype.exit=function(){if(i.prototype.exit){i.prototype.exit.apply(this,arguments)}window.clearTimeout(this._iPopupClosedTimeoutId);a._destroyColumnVisibilityMenuItem(this._getTable())};a.prototype.onThemeChanged=function(){if(this.getDomRef()){this._invalidate()}};a.prototype.setParent=function(t){this._invalidate();return i.prototype.setParent.apply(this,arguments)};a.prototype._getColumn=function(){const t=this.getParent();return u.isA(t,"sap.ui.table.Column")?t:null};a.prototype._getTable=function(){const t=this._getColumn();return t?t._getTable():null};a._destroyColumnVisibilityMenuItem=function(t){if(!t||!t._oColumnVisibilityMenuItem){return}t._oColumnVisibilityMenuItem.destroy();t._oColumnVisibilityMenuItem=null};a.prototype._removeColumnVisibilityFromAggregation=function(){const t=this._getTable();if(!t||t._oColumnVisibilityMenuItem){return}this.removeAggregation("items",t._oColumnVisibilityMenuItem,true)};a.prototype._invalidate=function(){this._removeColumnVisibilityFromAggregation();this.destroyItems();this._bInvalidated=true};a.prototype.open=function(){if(!this._bInvalidated&&this._getColumn()){this._addColumnVisibilityMenuItem()}if(this._bInvalidated){this._bInvalidated=false;this._addMenuItems()}if(this.getItems().length>0){this._lastFocusedDomRef=arguments[4];i.prototype.open.apply(this,arguments)}};a.prototype._addMenuItems=function(){if(this._getColumn()){this._addSortMenuItem(false);this._addSortMenuItem(true);this._addFilterMenuItem();this._addGroupMenuItem();this._addFreezeMenuItem();this._addColumnVisibilityMenuItem()}};a.prototype._addSortMenuItem=function(t){const e=this._getColumn();if(e.isSortableByMenu()){const i=t?"desc":"asc";const n=t?"sort-descending":"sort-ascending";this.addItem(this._createMenuItem(i,"TBL_SORT_"+i.toUpperCase(),n,function(i){e.sort(t,i.getParameter("ctrlKey")===true)}))}};a.prototype._addFilterMenuItem=function(){const t=this._getColumn();if(t.isFilterableByMenu()){const e=t.getParent();const i=e&&e.getEnableCustomFilter();if(i){this.addItem(this._createMenuItem("filter","TBL_FILTER_ITEM","filter",function(){e.fireCustomFilter({column:t})}))}else{this.addItem(this._createMenuTextFieldItem("filter","TBL_FILTER","filter",t.getFilterValue(),function(){t.filter(this.getValue())}))}}};a.prototype._addGroupMenuItem=function(){const t=this._getColumn();if(t.isGroupableByMenu()){const e=this._getTable();this.addItem(this._createMenuItem("group","TBL_GROUP",null,function(){let i;e.setGroupBy(t);if(u.isNoDataVisible(e)){i=e.getDomRef("noDataCnt")}else{i=e.getDomRef("rowsel0")}if(i){i.focus()}}))}};a.prototype._addFreezeMenuItem=function(){const t=this._getColumn();const e=this._getTable();const i=e&&e.getEnableColumnFreeze();if(i){const i=t.getIndex();const n=i+u.Column.getHeaderSpan(t)===e.getComputedFixedColumnCount();this.addItem(this._createMenuItem("freeze",n?"TBL_UNFREEZE":"TBL_FREEZE",null,function(){const o=e.fireColumnFreeze({column:t});if(o){if(n){e.setFixedColumnCount(0)}else{e.setFixedColumnCount(i+1)}}}))}};a.prototype._addColumnVisibilityMenuItem=function(){const t=this._getTable();if(t&&t.getShowColumnVisibilityMenu()){if(!t._oColumnVisibilityMenuItem||t._oColumnVisibilityMenuItem.bIsDestroyed){t._oColumnVisibilityMenuItem=this._createMenuItem("column-visibilty","TBL_COLUMNS");const e=new i(t._oColumnVisibilityMenuItem.getId()+"-menu");t._oColumnVisibilityMenuItem.setSubmenu(e)}this.addItem(t._oColumnVisibilityMenuItem);this._updateColumnVisibilityMenuItem()}};a.prototype._createColumnVisibilityMenuItem=function(t){const e=this._getTable();const i=u.Column.getHeaderText(t);return new n({text:i,icon:t.getVisible()?"sap-icon://accept":null,ariaLabelledBy:[e.getId()+(t.getVisible()?"-ariahidecolmenu":"-ariashowcolmenu")],select:jQuery.proxy(function(i){const n=!t.getVisible();if(n||u.getVisibleColumnCount(e)>1){let i=true;if(u.isA(e,"sap.ui.table.Table")){i=e.fireColumnVisibility({column:t,newVisible:n})}if(i){if(e.getFocusDomRef().getAttribute("id")===t.getId()){const i=e._getVisibleColumns();i[Math.min(i.indexOf(t)+1,u.getVisibleColumnCount(e)-2)].focus()}t.setVisible(n)}}},this)})};a.prototype._createMenuItem=function(t,e,i,o){return new n(this.getId()+"-"+t,{text:u.getResourceText(e),icon:i?"sap-icon://"+i:null,select:o||function(){}})};a.prototype._createMenuTextFieldItem=function(t,e,i,n,s){s=s||function(){};return new o(this.getId()+"-"+t,{label:u.getResourceText(e),icon:i?"sap-icon://"+i:null,value:n,select:s||function(){}})};a.prototype._setFilterValue=function(t){const i=this.getParent();const n=i?i.getParent():undefined;const o=e.getElementById(this.getId()+"-filter");if(o&&o.setValue&&(n&&!n.getEnableCustomFilter())){o.setValue(t)}return this};a.prototype._setFilterState=function(t){const i=this.getParent();const n=i?i.getParent():undefined;const o=e.getElementById(this.getId()+"-filter");if(o&&o.setValueState&&(n&&!n.getEnableCustomFilter())){o.setValueState(t)}return this};function m(t){let e=t.getColumns();if(t.getColumnVisibilityMenuSorter&&typeof t.getColumnVisibilityMenuSorter==="function"){const i=t.getColumnVisibilityMenuSorter();if(typeof i==="function"){e=e.sort(i)}}return e}function c(t,e){if(e.isA("sap.ui.table.AnalyticalColumn")){const i=t.getAnalyticalQueryResult();const n=i.getEntityType();const o=t.getModel().getProperty("/#"+n.getTypeDescription().name+"/"+e.getLeadingProperty()+"/sap:visible");if(o&&(o.value==="false"||o.value===false)){return true}}return false}a.prototype._updateColumnVisibilityMenuItem=function(){const t=this._getTable();if(!t||!t._oColumnVisibilityMenuItem){return}const e=t._oColumnVisibilityMenuItem.getSubmenu();if(!e){return}const i=m(t);let n=e.getItems();const o=t._getVisibleColumns();const s=t.getBinding();const l=u.isA(s,"sap.ui.model.analytics.AnalyticalBinding");for(let u=0;u<i.length;u++){const a=i[u];if(l){if(c(s,a)){continue}}let m=r.get(a);if(!m||m.bIsDestroyed){m=this._createColumnVisibilityMenuItem(a);e.insertItem(m,u);r.set(a,m)}else{const t=n.indexOf(m);if(u!==t){e.removeItem(m);e.insertItem(m,u)}}const d=o.indexOf(a)>-1;const p=d?"sap-icon://accept":"";n=e.getItems();n[u].setProperty("icon",p);n[u].setEnabled(!d||o.length>1);n[u].removeAllAriaLabelledBy();n[u].addAriaLabelledBy(t.getId()+(d?"-ariahidecolmenu":"-ariashowcolmenu"))}for(let t=n.length;t>i.length;t--){n[t-1].destroy()}};return a});
//# sourceMappingURL=ColumnMenu.js.map