/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["./CreationRowRenderer","./Column","./utils/TableUtils","sap/ui/core/Control","sap/m/library","sap/m/OverflowToolbar","sap/m/ToolbarSpacer","sap/m/Button"],function(t,e,o,n,l,i,r,s){"use strict";const a=n.extend("sap.ui.table.CreationRow",{metadata:{library:"sap.ui.table",properties:{applyEnabled:{type:"boolean",group:"Behavior",defaultValue:true}},aggregations:{cells:{type:"sap.ui.core.Control",multiple:true,singularName:"cell"},toolbar:{type:"sap.ui.core.Toolbar",multiple:false},_defaultToolbar:{type:"sap.ui.core.Toolbar",multiple:false,visibility:"hidden"}},events:{apply:{allowPreventDefault:true}}},renderer:t});a.prototype.setApplyEnabled=function(t){this.setProperty("applyEnabled",t,true);this._updateDefaultToolbar();return this};a.prototype.setVisible=function(t){const e=this.getVisible();const o=this.getTable();this.setProperty("visible",t);if(e!==t&&o){o.invalidate()}return this};a.prototype.setParent=function(t){n.prototype.setParent.apply(this,arguments);this._update();return this};a.prototype.resetFocus=function(){const t=o.getFirstInteractiveElement(this);if(t){t.focus();if(t instanceof window.HTMLInputElement){t.select()}return true}return false};a.prototype.getFocusDomRef=function(){const t=o.getFirstInteractiveElement(this);if(t){return t}return n.prototype.getFocusDomRef.apply(this,arguments)};a.prototype._fireApply=function(){let t=false;if(this.fireApply()){t=this.resetFocus()}return t};function u(t,e){const o=document.activeElement;t.getTable().getDomRef("focusDummy").focus();e.setMarked();window.setTimeout(function(){if(!t._fireApply()){o.focus()}},0)}a.prototype.onsapenter=function(t){if(this.getApplyEnabled()&&!t.isMarked()){u(this,t)}};a.prototype.onsapentermodifiers=function(t){if(this.getApplyEnabled()&&(t.metaKey||t.ctrlKey)){u(this,t)}};function p(t){return new i(t.getId()+"-tb",{content:[new r,new s(t.getId()+"-applyBtn",{text:o.getResourceText("TBL_CREATIONROW_APPLY"),enabled:t.getApplyEnabled(),press:function(){t._fireApply()}})],style:l.ToolbarStyle.Clear,ariaLabelledBy:[t.getId()+"-label"]})}a.prototype._getToolbar=function(){let t=this.getToolbar();if(!t){let e=this.getAggregation("_defaultToolbar");if(!e){e=p(this);this.setAggregation("_defaultToolbar",e,true)}t=e;if(t.data("sap-ui-table-invalid")){this._updateDefaultToolbar()}}return t};a.prototype._updateDefaultToolbar=function(){const t=this.getAggregation("_defaultToolbar");if(this.getToolbar()){if(t){t.data("sap-ui-table-invalid",true)}return}if(!t){return}const e=t.getContent()[1];e.setEnabled(this.getApplyEnabled());t.data("sap-ui-table-invalid",null)};a.prototype._getCell=function(t){const o=this.getCells();const n=o.filter(function(o){return e.ofCell(o).getIndex()===t})[0];if(!n){return null}return n};a.prototype._getCellDomRef=function(t){const e=this._getCell(t);const n=e?e.getDomRef():null;const l=o.getCell(this.getTable(),n,true);if(!l){return null}return l};a.prototype._focusCell=function(t){const e=this._getCellDomRef(t);const n=o.getInteractiveElements(e);if(n){n[0].focus();if(n[0]instanceof window.HTMLInputElement){n[0].select()}return true}return false};a.prototype._takeOverKeyboardHandling=function(t){const e=this.getTable();const n=e?e.getDomRef():null;if(!n||!n.contains(document.activeElement)){return false}const l=o.getCell(this.getTable(),document.activeElement);const i=o.getCellInfo(l);let r=false;if(i.columnIndex!=null&&i.columnIndex>=0){r=this._focusCell(i.columnIndex)}else{r=this.resetFocus()}if(r&&t){t.preventDefault()}return r};a.prototype._update=function(){const t=this.getTable();if(!t){this.removeAllCells();return}const e=t.getColumns();this.removeAllCells();for(let t=0,o=e.length;t<o;t++){if(e[t].getVisible()){this.addCell(e[t].getTemplateClone(t,"Creation"))}}};a.prototype.getTable=function(){const t=this.getParent();return o.isA(t,"sap.ui.table.Table")?t:null};return a});
//# sourceMappingURL=CreationRow.js.map