/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/core/Element","./utils/TableUtils","sap/ui/thirdparty/jquery"],function(t,e,jQuery){"use strict";const o=Object.freeze({Standard:"Standard",Summary:"Summary",GroupHeader:"GroupHeader"});function n(){let t=null;let e=o.Standard;let n=false;let i="";let r=false;let s=false;let l=0;Object.defineProperties(this,{context:{get:function(){return t},set:function(e){t=e||null}},Type:{get:function(){return o}},type:{get:function(){return e},set:function(t){if(!(t in o)){throw Error("Is not a valid type for sap.ui.table.Row: "+t)}e=t}},empty:{get:function(){return this.context==null}},contentHidden:{get:function(){return this.empty?true:n},set:function(t){n=t===true}},title:{get:function(){return this.empty?"":i},set:function(t){i=typeof t==="string"?t:""}},expandable:{get:function(){return this.empty?false:s},set:function(t){s=t===true}},expanded:{get:function(){return this.expandable?r:false},set:function(t){r=t===true}},level:{get:function(){return this.empty?0:l},set:function(t){l=typeof t==="number"?Math.max(1,t||1):1}},reset:{value:function(){t=null;e=o.Standard;n=false;i="";s=false;r=false;l=1}}})}const i=new window.WeakMap;function r(t){if(!i.has(t)){i.set(t,Object.seal(new n))}return i.get(t)}const s=t.extend("sap.ui.table.Row",{metadata:{library:"sap.ui.table",defaultAggregation:"cells",aggregations:{cells:{type:"sap.ui.core.Control",multiple:true,singularName:"cell"},_rowAction:{type:"sap.ui.table.RowAction",multiple:false,visibility:"hidden"},_settings:{type:"sap.ui.table.RowSettings",multiple:false,visibility:"hidden"}}}});s.prototype.init=function(){this.initDomRefs()};s.prototype.exit=function(){this.initDomRefs()};s.prototype.getFocusInfo=function(){const e=this.getTable();return e?e.getFocusInfo():t.prototype.getFocusInfo.apply(this,arguments)};s.prototype.applyFocusInfo=function(e){const o=this.getTable();if(o){o.applyFocusInfo(e)}else{t.prototype.applyFocusInfo.apply(this,arguments)}return this};s.prototype._setFocus=function(t){const o=e.getFirstInteractiveElement(this);if(t===true&&o){o.focus()}else{this.getDomRef("col0").focus()}};s.prototype.addStyleClass=function(t){this.getDomRefs(true).row.addClass(t)};s.prototype.removeStyleClass=function(t){this.getDomRefs(true).row.removeClass(t)};s.prototype.initDomRefs=function(){this._mDomRefs={}};s.prototype.getIndex=function(){const t=this.getTable();if(!t){return-1}const e=t.indexOfRow(this);const o=t._getRowCounts();if(o.fixedTop>0&&e<o.fixedTop){return e}if(o.fixedBottom>0&&e>=o.count-o.fixedBottom){const n=t._getTotalRowCount();if(n>=o.count){return n-(o.count-e)}else{return e}}return t._getFirstRenderedRowIndex()+e};s.prototype.getDomRefs=function(t){t=t===true;const e=t?"jQuery":"dom";const o=this._mDomRefs;if(!o[e]){const n=this.getTable();const i=function(e){const o=document.getElementById(e);if(o){return t?jQuery(o):o}return null};const r=function(e){if(e){return t?e.parent():e.parentNode}return null};o[e]={};if(n){const t=n.indexOfRow(this);o[e].rowSelector=i(n.getId()+"-rowsel"+t);o[e].rowAction=i(n.getId()+"-rowact"+t)}o[e].rowHeaderPart=r(o[e].rowSelector);o[e].rowFixedPart=i(this.getId()+"-fixed");o[e].rowScrollPart=i(this.getId());o[e].rowActionPart=r(o[e].rowAction);o[e].rowSelectorText=i(this.getId()+"-rowselecttext");if(t){o[e].row=jQuery().add(o[e].rowHeaderPart).add(o[e].rowFixedPart).add(o[e].rowScrollPart).add(o[e].rowActionPart)}else{o[e].row=[o[e].rowHeaderPart,o[e].rowFixedPart,o[e].rowScrollPart,o[e].rowActionPart].filter(Boolean)}}return o[e]};s.prototype._updateSelection=function(){const t=this.getTable();const e=this._isSelected();if(e){this.addStyleClass("sapUiTableRowSel")}else{this.removeStyleClass("sapUiTableRowSel")}t._getAccExtension().updateSelectionStateOfRow(this);t._getSyncExtension?.().syncRowSelection(t.indexOfRow(this),e)};s.prototype.setRowBindingContext=function(t,o){const n=o.getBindingInfo("rows");const i=n?n.model:undefined;const s=r(this);s.reset();s.context=t;if(s.context){e.Hook.call(o,e.Hook.Keys.Row.UpdateState,s)}this.setBindingContext(s.context,i);this.getDomRefs(true).row.toggleClass("sapUiTableRowHidden",this.isContentHidden());this._updateTableCells(o)};s.prototype.getRowBindingContext=function(){return r(this).context};s.prototype.setBindingContext=function(e,o){return t.prototype.setBindingContext.call(this,e||null,o)};s.prototype._updateTableCells=function(t){const e=this.getCells();const o=this.getIndex();const n=!!t._updateTableCell;let i;let r;let s;const l=this.getRowBindingContext();for(let a=0;a<e.length;a++){i=e[a];s=!!i._updateTableCell;r=s||n?i.$().closest("td"):null;if(s){i._updateTableCell(i,l,r,o)}if(n){t._updateTableCell(i,l,r,o)}}};s.prototype.getType=function(){return r(this).type};s.prototype.isGroupHeader=function(){return this.getType()===o.GroupHeader};s.prototype.isSummary=function(){return this.getType()===o.Summary};s.prototype.isGroupSummary=function(){return this.isSummary()&&this.getLevel()>1};s.prototype.isTotalSummary=function(){return this.isSummary()&&this.getLevel()===1};s.prototype.isEmpty=function(){return r(this).empty};s.prototype.isContentHidden=function(){return r(this).contentHidden};s.prototype.getLevel=function(){return r(this).level};s.prototype.getTitle=function(){return r(this).title};s.prototype.isExpandable=function(){return r(this).expandable};s.prototype.isExpanded=function(){return r(this).expanded};s.prototype.destroy=function(){this.removeAllCells();return t.prototype.destroy.apply(this,arguments)};s.prototype.invalidate=function(){};s.prototype.getDragGhost=function(){const t=this.getTable();const e=t.getDomRef();const o=this.getDomRefs();const n=e.cloneNode();let i;let r;const s=t._getSelectionPlugin().getSelectedCount();function l(t){t.removeAttribute("id");t.removeAttribute("data-sap-ui");t.removeAttribute("data-sap-ui-related");const e=t.children.length;for(let o=0;o<e;o++){l(t.children[o])}}function a(t,e){const o=t.cloneNode();const n=t.querySelector("thead").cloneNode(true);const i=t.querySelector("tbody").cloneNode();const r=e.cloneNode(true);i.appendChild(r);o.appendChild(n);o.appendChild(i);return o}n.classList.add("sapUiTableRowGhost");n.classList.remove("sapUiTableVScr");n.classList.remove("sapUiTableHScr");n.style.width=e.getBoundingClientRect().width+"px";if(o.rowSelector){i=t.getDomRef("sapUiTableRowHdrScr").cloneNode();r=o.rowSelector.cloneNode(true);i.appendChild(r);n.appendChild(i)}if(o.rowFixedPart){i=t.getDomRef("sapUiTableCtrlScrFixed").cloneNode();r=a(t.getDomRef("table-fixed"),o.rowFixedPart);i.appendChild(r);n.appendChild(i)}if(o.rowScrollPart){const e=t.getDomRef("sapUiTableCtrlScr");i=e.cloneNode();r=a(t.getDomRef("table"),o.rowScrollPart);i.appendChild(t.getDomRef("tableCtrlCnt").cloneNode());i.firstChild.appendChild(r);n.appendChild(i)}if(o.rowAction){i=t.getDomRef("sapUiTableRowActionScr").cloneNode();r=o.rowAction.cloneNode(true);i.appendChild(r);n.appendChild(i)}if(s>1){i=document.createElement("div");i.classList.add("sapUiTableRowGhostCount");const t=document.createElement("div");t.textContent=s;i.appendChild(t);n.appendChild(i)}l(n);return n};s.prototype._setSelected=function(t){this.getTable()._getSelectionPlugin().setSelected(this,t)};s.prototype._isSelected=function(){return this.getTable()._getSelectionPlugin().isSelected(this)};s.prototype._setHovered=function(t){const e=this.getTable();if(t){this.addStyleClass("sapUiTableRowHvr")}else{this.removeStyleClass("sapUiTableRowHvr")}e._getSyncExtension?.().syncRowHover(e.indexOfRow(this),t)};s.prototype.getRowAction=function(){return this.getAggregation("_rowAction")};s.prototype.getTable=function(){const t=this.getParent();return e.isA(t,"sap.ui.table.Table")?t:null};s.prototype.expand=function(){if(this.isExpandable()&&!this.isExpanded()){e.Hook.call(this.getTable(),e.Hook.Keys.Row.Expand,this)}};s.prototype.collapse=function(){if(this.isExpandable()&&this.isExpanded()){e.Hook.call(this.getTable(),e.Hook.Keys.Row.Collapse,this)}};s.prototype.toggleExpandedState=function(){if(this.isExpanded()){this.collapse()}else{this.expand()}};s.prototype.Type=o;return s});
//# sourceMappingURL=Row.js.map