/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["./library","./utils/TableUtils","./RowActionRenderer","sap/ui/core/Control","sap/ui/core/Icon","sap/ui/unified/Menu","sap/ui/core/Popup"],function(e,t,i,s,o,n,a){"use strict";const c=s.extend("sap.ui.table.RowAction",{metadata:{library:"sap.ui.table",properties:{visible:{type:"boolean",group:"Misc",defaultValue:true}},defaultAggregation:"items",aggregations:{items:{type:"sap.ui.table.RowActionItem",multiple:true},_icons:{type:"sap.ui.core.Icon",multiple:true,visibility:"hidden"},_menu:{type:"sap.ui.unified.Menu",multiple:false,visibility:"hidden"}},events:{}},renderer:i});c.prototype.init=function(){this._bFixedLayout=true;this._aActions=["",""];this._iLastCloseTime=0;this.addAggregation("_icons",new o(this.getId()+"-icon0",{decorative:false,press:[this._onIconPress,this]}).addStyleClass("sapUiTableActionIcon")).addDelegate({onAfterRendering:function(){const e=this.getAggregation("_icons")[0].getDomRef();if(this._aActions[0]==="menu"){e.setAttribute("aria-haspopup","menu")}else{e.removeAttribute("aria-haspopup")}}},this);this.addAggregation("_icons",new o(this.getId()+"-icon1",{decorative:false,press:[this._onIconPress,this]}).addStyleClass("sapUiTableActionIcon")).addDelegate({onAfterRendering:function(){const e=this.getAggregation("_icons")[1].getDomRef();if(this._aActions[1]==="menu"){e.setAttribute("aria-haspopup","menu")}else{e.removeAttribute("aria-haspopup")}}},this)};c.prototype.onBeforeRendering=function(){const e=this.getRow();const i=e?e.getTable():null;const s=this.getAggregation("_icons");const o=this.getItems();const n=this._getVisibleItems();const a=n.length;const c=this._getSize();const r=i?i.getId()+"-rowacthdr":"";if(this._bFixedLayout&&a===1&&c===2&&o.length>1&&n[0]===o[1]){n[0]._syncIcon(s[1]);this._aActions=["","action_fixed"]}else if(a===0||c===0){this._aActions=["",""]}else if(a===1&&c>0){n[0]._syncIcon(s[0]);this._aActions=["action",""]}else if(a===2&&c===2){n[0]._syncIcon(s[0]);n[1]._syncIcon(s[1]);this._aActions=["action","action"]}else if(a>2&&c===2){n[0]._syncIcon(s[0]);s[1].setSrc("sap-icon://overflow");s[1].setTooltip(t.getResourceText("TBL_ROW_ACTION_MORE"));this._aActions=["action","menu"]}else{s[0].setSrc("sap-icon://overflow");s[0].setTooltip(t.getResourceText("TBL_ROW_ACTION_MORE"));this._aActions=["menu",""]}s.forEach(function(e,t){e.removeAllAriaLabelledBy();e.removeStyleClass("sapUiTableActionHidden");if(r){e.addAriaLabelledBy(r)}if(this._aActions[t]===""){e.addStyleClass("sapUiTableActionHidden")}}.bind(this))};c.prototype.getAccessibilityInfo=function(){const e=this.getRow();const i=this._getVisibleItems().length;const s=this._getSize();const o=this.getVisible()&&i>0&&s>0&&(!e||!e.isContentHidden()&&!e.isGroupHeader()&&!e.isSummary());let n;if(o){n=t.getResourceText(i===1?"TBL_ROW_ACTION_SINGLE_ACTION":"TBL_ROW_ACTION_MULTIPLE_ACTION",[i])}else{n=t.getResourceText("TBL_ROW_ACTION_NO_ACTION")}return{focusable:o,enabled:o,description:n}};c.prototype._getVisibleItems=function(){return this.getItems().filter(function(e){return e.getVisible()})};c.prototype.getRow=function(){const e=this.getParent();return t.isA(e,"sap.ui.table.Row")?e:null};c.prototype._getSize=function(){const e=this.getRow();const t=e?e.getTable():null;return t?t.getRowActionCount():2};c.prototype._onIconPress=function(e){const t=e.getSource();const i=this.indexOfAggregation("_icons",t);const s=this._aActions[i];if(s==="action"){this._getVisibleItems()[i]._firePress()}else if(s==="action_fixed"){this._getVisibleItems()[0]._firePress()}else if(s==="menu"){let e=this.getAggregation("_menu");if(!e){e=new n;this.setAggregation("_menu",e,true);e.getPopup().attachClosed(function(){this._iLastCloseTime=Date.now()},this)}e.removeAllItems();if(Date.now()-this._iLastCloseTime<500){return}const s=this.getItems();for(let t=i;t<s.length;t++){e.addItem(s[t]._getMenuItem())}e.open(null,t,a.Dock.EndTop,a.Dock.EndBottom,t)}};return c});
//# sourceMappingURL=RowAction.js.map