/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/base/i18n/Localization","sap/ui/Device","sap/ui/core/Control","sap/ui/core/ControlBehavior","sap/ui/core/Element","sap/ui/core/util/PasteHelper","sap/ui/model/ChangeReason","sap/ui/model/Filter","sap/ui/model/Sorter","sap/ui/model/BindingMode","./Column","./Row","./library","./utils/TableUtils","./extensions/ExtensionBase","./extensions/Accessibility","./extensions/Keyboard","./extensions/Pointer","./extensions/Scrolling","./extensions/DragAndDrop","./TableRenderer","./rowmodes/Type","./rowmodes/Fixed","./rowmodes/Interactive","./rowmodes/Auto","./plugins/SelectionPlugin","./plugins/SelectionModelSelection","./menus/ContextMenu","sap/ui/thirdparty/jquery","sap/base/Log","sap/ui/core/AnimationMode","sap/ui/core/library"],function(e,t,o,i,n,s,r,l,a,u,d,p,c,h,g,f,m,y,w,b,C,R,_,x,S,T,A,v,jQuery,I,B,M){"use strict";const F=c.GroupEventType;const D=c.SelectionMode;const P=c.SelectionBehavior;const V=M.SortOrder;const E=h.Hook.Keys.Table;const H=h.createWeakMapFacade();const U=o.extend("sap.ui.table.Table",{metadata:{library:"sap.ui.table",dnd:true,properties:{width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:"auto"},rowHeight:{type:"int",group:"Appearance",defaultValue:null,deprecated:true},columnHeaderHeight:{type:"int",group:"Appearance",defaultValue:null},columnHeaderVisible:{type:"boolean",group:"Appearance",defaultValue:true},visibleRowCount:{type:"int",group:"Appearance",defaultValue:10,deprecated:true},firstVisibleRow:{type:"int",group:"Appearance",defaultValue:0},selectionMode:{type:"sap.ui.table.SelectionMode",group:"Behavior",defaultValue:D.MultiToggle},selectionBehavior:{type:"sap.ui.table.SelectionBehavior",group:"Behavior",defaultValue:P.RowSelector},selectedIndex:{type:"int",group:"Appearance",defaultValue:-1,deprecated:true},editable:{type:"boolean",group:"Behavior",defaultValue:true,deprecated:true},navigationMode:{type:"sap.ui.table.NavigationMode",group:"Behavior",defaultValue:"Scrollbar",deprecated:true},threshold:{type:"int",group:"Behavior",defaultValue:100},scrollThreshold:{type:"int",group:"Behavior",defaultValue:-1},enableColumnReordering:{type:"boolean",group:"Behavior",defaultValue:true},enableGrouping:{type:"boolean",group:"Behavior",defaultValue:false,deprecated:true},showColumnVisibilityMenu:{type:"boolean",group:"Appearance",defaultValue:false},showNoData:{type:"boolean",group:"Appearance",defaultValue:true},visibleRowCountMode:{type:"sap.ui.table.VisibleRowCountMode",group:"Appearance",defaultValue:"Fixed",deprecated:true},minAutoRowCount:{type:"int",group:"Appearance",defaultValue:5,deprecated:true},fixedColumnCount:{type:"int",group:"Appearance",defaultValue:0},fixedRowCount:{type:"int",group:"Appearance",defaultValue:0,deprecated:true},fixedBottomRowCount:{type:"int",group:"Appearance",defaultValue:0,deprecated:true},enableColumnFreeze:{type:"boolean",group:"Behavior",defaultValue:false},enableCellFilter:{type:"boolean",group:"Behavior",defaultValue:false},showOverlay:{type:"boolean",group:"Appearance",defaultValue:false},enableSelectAll:{type:"boolean",group:"Behavior",defaultValue:true},enableCustomFilter:{type:"boolean",group:"Behavior",defaultValue:false},enableBusyIndicator:{type:"boolean",group:"Behavior",defaultValue:false},rowActionCount:{type:"int",group:"Appearance",defaultValue:0},alternateRowColors:{type:"boolean",group:"Appearance",defaultValue:false},rowCountConstraints:{type:"object",visibility:"hidden"}},defaultAggregation:"columns",aggregations:{title:{type:"sap.ui.core.Control",altTypes:["string"],multiple:false,deprecated:true},footer:{type:"sap.ui.core.Control",altTypes:["string"],multiple:false},toolbar:{type:"sap.ui.core.Toolbar",multiple:false,deprecated:true},extension:{type:"sap.ui.core.Control",multiple:true,singularName:"extension"},columns:{type:"sap.ui.table.Column",defaultClass:d,multiple:true,singularName:"column",bindable:"bindable",dnd:{layout:"Horizontal"}},rows:{type:"sap.ui.table.Row",multiple:true,singularName:"row",bindable:"bindable",selector:"#{id}-tableCCnt",dnd:true},rowMode:{type:"sap.ui.table.rowmodes.RowMode",multiple:false,altTypes:["sap.ui.table.rowmodes.Type"]},creationRow:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"},noData:{type:"sap.ui.core.Control",altTypes:["string"],multiple:false},_noColumnsMessage:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"},rowActionTemplate:{type:"sap.ui.table.RowAction",multiple:false},rowSettingsTemplate:{type:"sap.ui.table.RowSettings",multiple:false},contextMenu:{type:"sap.ui.core.IContextMenu",multiple:false},groupHeaderRowContextMenu:{type:"sap.ui.core.IContextMenu",multiple:false,visibility:"hidden"},plugins:{type:"sap.ui.table.plugins.SelectionPlugin",multiple:true,singularName:"plugin",deprecated:true},_messageStrip:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"},_hiddenDependents:{type:"sap.ui.core.Element",multiple:true,visibility:"hidden"}},associations:{groupBy:{type:"sap.ui.table.Column",multiple:false,deprecated:true},ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}},events:{rowSelectionChange:{parameters:{rowIndex:{type:"int"},rowContext:{type:"sap.ui.model.Context"},rowIndices:{type:"int[]"},selectAll:{type:"boolean"},userInteraction:{type:"boolean"}}},columnSelect:{allowPreventDefault:true,parameters:{column:{type:"sap.ui.table.Column"}}},columnResize:{allowPreventDefault:true,parameters:{column:{type:"sap.ui.table.Column"},width:{type:"sap.ui.core.CSSSize"}}},columnMove:{allowPreventDefault:true,parameters:{column:{type:"sap.ui.table.Column"},newPos:{type:"int"}}},sort:{allowPreventDefault:true,parameters:{column:{type:"sap.ui.table.Column"},sortOrder:{type:"sap.ui.core.SortOrder"},columnAdded:{type:"boolean"}}},filter:{allowPreventDefault:true,parameters:{column:{type:"sap.ui.table.Column"},value:{type:"string"}}},group:{allowPreventDefault:true,parameters:{column:{type:"sap.ui.table.Column"}},deprecated:true},columnVisibility:{allowPreventDefault:true,parameters:{column:{type:"sap.ui.table.Column"},newVisible:{type:"boolean"}}},cellClick:{allowPreventDefault:true,parameters:{cellControl:{type:"sap.ui.core.Control"},cellDomRef:{type:"Object"},rowIndex:{type:"int"},columnIndex:{type:"int"},columnId:{type:"string"},rowBindingContext:{type:"sap.ui.model.Context"}}},cellContextmenu:{allowPreventDefault:true,parameters:{cellControl:{type:"sap.ui.core.Control"},cellDomRef:{type:"Object"},rowIndex:{type:"int"},columnIndex:{type:"int"},columnId:{type:"string"},rowBindingContext:{type:"sap.ui.model.Context"}},deprecated:true},beforeOpenContextMenu:{allowPreventDefault:true,parameters:{rowIndex:{type:"int"},columnIndex:{type:"int"},contextMenu:{type:"sap.ui.core.IContextMenu"}}},columnFreeze:{allowPreventDefault:true,parameters:{column:{type:"sap.ui.table.Column"}}},customFilter:{parameters:{column:{type:"sap.ui.table.Column"},value:{type:"string"}}},firstVisibleRowChanged:{parameters:{firstVisibleRow:{type:"int"}}},busyStateChanged:{parameters:{busy:{type:"boolean"}}},paste:{allowPreventDefault:true,parameters:{data:{type:"string[][]"}}},rowsUpdated:{}},designtime:"sap/ui/table/designtime/Table.designtime"},renderer:C});U.prototype.init=function(){this.mSkipPropagation={rowActionTemplate:true,rowSettingsTemplate:true};H(this).iCachedBindingLength=0;H(this).iFirstRenderedRowIndex=0;H(this).iComputedFixedColumnCount=null;this._attachExtensions();this._bRtlMode=e.getRTL();this._bRowsBeingBound=false;this._bContextsAvailable=false;this._bScrolled=false;this._aRowClones=[];this._bRowAggregationInvalid=true;this._mTimeouts={};this._mAnimationFrames={};this._aRowHeights=[];this._aSortedColumns=[];this._aTableHeaders=[];this._bAllowColumnHeaderTextSelection=false;H(this).iPendingRequests=0;this._iBindingLength=null;this._bFirstRendering=true;this._nDevicePixelRatio=window.devicePixelRatio;if(h.isThemeApplied()){h.readThemeParameters()}this._bInvalid=true};U.prototype.applySettings=function(e,t){if(e){const i=["threshold","firstVisibleRow","rowMode"];const n={};i.push("plugins");for(let t=0;t<i.length;t++){const o=i[t];if(o in e){n[o]=e[o];delete e[o]}}if(Object.keys(n).length>0){o.prototype.applySettings.call(this,n,t)}}N(this);o.prototype.applySettings.call(this,e,t)};U.prototype._attachExtensions=function(){if(this._bExtensionsInitialized){return}g.enrich(this,y);g.enrich(this,w);g.enrich(this,m);g.enrich(this,f);g.enrich(this,b);if(t.os.ios){sap.ui.require(["sap/ui/table/extensions/ScrollingIOS"],function(e){if(!this.bIsDestroyed){g.enrich(this,e)}}.bind(this))}this._bExtensionsInitialized=true};U.prototype.exit=function(){this.invalidateRowsAggregation();this._detachExtensions();this._cleanUpTimers();this._detachEvents();ee(this);delete this._aTableHeaders};U.prototype._detachExtensions=function(){g.cleanup(this)};U.prototype.onpaste=function(e){if(e.isMarked()||/^(input|textarea)$/i.test(document.activeElement.tagName)){return}const t=s.getPastedDataAs2DArray(e.originalEvent);if(t.length===0||t[0].length===0){return}this.firePaste({data:t})};U.prototype.onfocusfail=function(){if(this._bReorderInProcess){return undefined}else{return o.prototype.onfocusfail.apply(this,arguments)}};U.prototype.onThemeChanged=function(){h.readThemeParameters();if(this.getDomRef()){this.invalidate()}};U.prototype.onLocalizationChanged=function(t){const o=t.changes||{};const i=o.hasOwnProperty("rtl");const n=o.hasOwnProperty("language");if(i){this._bRtlMode=e.getRTL()}if(n){this._invalidateColumnMenus()}if(i||n){this.invalidate()}};U.prototype.onlocalizationChanged=U.prototype.onLocalizationChanged;U.prototype._collectRowHeights=function(e){const o=this.getDomRef();if(!o){return[]}let i=this._getBaseRowHeight();const n=e?".sapUiTableColHdrTr":".sapUiTableTr";const s=o.querySelectorAll(".sapUiTableCtrlFixed > tbody > tr"+n);const r=o.querySelectorAll(".sapUiTableCtrlScroll > tbody > tr"+n);const l=e?h.getHeaderRowCount(this):this.getRows().length;let a=[];const u=t.browser.chrome&&window.devicePixelRatio!==1;if(e){if(this.getColumnHeaderHeight()>0){i=this.getColumnHeaderHeight()}else if(this.getRowMode()){i=this._getDefaultRowHeight()}}for(let e=0;e<l;e++){const t=s[e]?s[e].getBoundingClientRect().height:0;const o=r[e]?r[e].getBoundingClientRect().height:0;const n=Math.max(t,o);if(u){const e=i-n;if(e>0&&e<1){a.push(Math.max(n,i-1));continue}}a.push(Math.max(n,i))}if(a.length>0&&!e){h.dynamicCall(this._getSyncExtension,function(e){const t=e.syncRowHeights(a.slice());if(t&&t.length===a.length){a=t.slice()}})}return a};U.prototype._resetRowHeights=function(){const e=this._getBaseRowHeight();let t="";if(e){t=e+"px"}const o=this.getDomRef("tableCCnt");if(o){const e=o.querySelectorAll(".sapUiTableTr");for(let o=0;o<e.length;o++){e[o].style.height=t}}};U.prototype._resetColumnHeaderHeights=function(){const e=this.getDomRef();if(e){const t=e.querySelectorAll(".sapUiTableColHdrTr");for(let e=0;e<t.length;e++){t[e].style.height=null}}};U.prototype._collectTableSizes=function(){const e={tableCtrlScrollWidth:0,tableRowHdrScrWidth:0,tableCtrlScrWidth:0,tableCtrlFixedWidth:0,tableCntHeight:0,tableCntWidth:0};const t=this.getDomRef();if(!t){return e}const o=t.querySelector(".sapUiTableCnt");if(o){e.tableCntHeight=o.clientHeight;e.tableCntWidth=o.clientWidth}const i=t.querySelector(".sapUiTableCtrlScroll:not(.sapUiTableCHT)");if(i){e.tableCtrlScrollWidth=i.getBoundingClientRect().width}const n=t.querySelector(".sapUiTableRowHdrScr");if(n){e.tableRowHdrScrWidth=n.clientWidth}const s=t.querySelector(".sapUiTableCtrlScr:not(.sapUiTableCHA)");if(s){e.tableCtrlScrWidth=s.getBoundingClientRect().width}const r=t.querySelector(".sapUiTableCtrlScrFixed:not(.sapUiTableCHA) > .sapUiTableCtrlFixed");if(r){e.tableCtrlFixedWidth=r.clientWidth}const l=this._getSpanBasedComputedFixedColumnCount();let a=0;if(l){const e=this.getColumns();const o=t.querySelectorAll(".sapUiTableCtrlFirstCol:not(.sapUiTableCHTHR) > th");for(let t=0;t<o.length;t++){const i=parseInt(o[t].getAttribute("data-sap-ui-headcolindex"));if(!isNaN(i)&&i<l){const n=e[i];let s;if(n._iFixWidth!=null){s=n._iFixWidth}else{s=o[t].getBoundingClientRect().width}a+=s}}}if(a>0){const t=this._getScrollExtension();let o=e.tableRowHdrScrWidth;const i=t.getVerticalScrollbar();if(i&&!t.isVerticalScrollbarExternal()){o+=i.offsetWidth}if(h.hasRowActions(this)){const e=this.getDomRef("sapUiTableRowActionScr");if(e){o+=e.offsetWidth}}o+=h.Column.getMinColumnWidth();const n=e.tableCntWidth-o;const s=n>a;const r=!s;if(this._bIgnoreFixedColumnCount!==r){this._bIgnoreFixedColumnCount=r;if(this.getEnableColumnFreeze()){this._invalidateColumnMenus()}this.invalidate()}}return e};U.prototype._updateRowHeights=function(e,t){const o=this.getDomRef();if(!o){return}function i(t,o){const i=e[o];if(i){t.style.height=i+"px"}}const n=t?".sapUiTableColHdrTr":".sapUiTableTr";const s=t?[]:o.querySelectorAll(".sapUiTableRowSelectionCell");const r=t?[]:o.querySelectorAll(".sapUiTableRowActionCell");const l=o.querySelectorAll(".sapUiTableCtrlFixed > tbody > tr"+n);const a=o.querySelectorAll(".sapUiTableCtrlScroll > tbody > tr"+n);Array.prototype.forEach.call(s,i);Array.prototype.forEach.call(r,i);Array.prototype.forEach.call(l,i);Array.prototype.forEach.call(a,i)};U.prototype.onBeforeRendering=function(e){this._bInvalid=true;this._detachEvents();if(e&&e.isMarked("renderRows")){return}this._cleanUpTimers();this._aTableHeaders=[]};U.prototype.onAfterRendering=function(e){const t=e&&e.isMarked("renderRows");this._bInvalid=false;this._attachEvents();this._initRowDomRefs();if(!this._bAllowColumnHeaderTextSelection&&!t){this._disableTextSelection(this.$().find(".sapUiTableColHdrCnt"))}this.getDomRef().classList.remove("sapUiTableRActFlexible");if(!t){this._aTableHeaders=this.$().find(".sapUiTableColHdrCnt th")}this._updateTableSizes(h.RowsUpdateReason.Render,true);h.registerResizeHandler(this,"Table",this._onTableResize.bind(this));this._bFirstRendering=false};U.prototype.invalidate=function(){this._bInvalid=true;h.Column.invalidateColumnUtils(this);return o.prototype.invalidate.call(this)};U.prototype._initRowDomRefs=function(){const e=this.getRows();for(let t=0;t<e.length;t++){e[t].initDomRefs()}};U.prototype._updateTableSizes=function(e,t){t=t===true;const o=this.getDomRef();if(this._bInvalid||!o||!h.isThemeApplied()||o.offsetWidth===0){return}if(!t){this._resetRowHeights();this._resetColumnHeaderHeights()}this._aRowHeights=this._collectRowHeights(false);const i=this._collectRowHeights(true);function n(e){const t=e.getDomRef();const o=h.Column.getMinColumnWidth();const i=[];const n=e.getColumnHeaderVisible();function s(e,t){if(e<=t){return Math.max(e,t-5,o)+"px"}return-1}function r(r){const l=Math.max(r._minWidth||0,o,r.getMinWidth());const a=r.getWidth();let u;let d;let p;if(h.isVariableWidth(a)&&!h.isFixedColumn(e,r.getIndex())){u=t.querySelectorAll('th[data-sap-ui-colid="'+r.getId()+'"]');d=u[n?0:1];p=d?d.offsetWidth:null;if(p!==null){if(p<=l){return{headers:u,newWidth:s(p,l)}}else if(d&&d.style.width!==a){i.push({col:r,header:d,minWidth:l,headers:u});return{headers:u,newWidth:a}}i.push({col:r,header:d,minWidth:l,headers:u})}}return null}function l(e){if(e){Array.prototype.forEach.call(e.headers,function(t){t.style.width=e.newWidth})}}e._getVisibleColumns().map(r).forEach(l);if(i.length){let e;for(let t=0;t<i.length;t++){e=i[t].header&&i[t].header.offsetWidth;i[t].newWidth=s(e,i[t].minWidth);if(parseInt(i[t].newWidth)>=0){l(i[t])}}}}n(this);const s=this._collectTableSizes();this._updateRowHeights(this._aRowHeights,false);this._updateRowHeights(i,true);h.dynamicCall(this._getSyncExtension,function(e){e.syncLayout({top:this.getDomRef("sapUiTableCnt").offsetTop,headerHeight:this.getDomRef().querySelector(".sapUiTableColHdrCnt").getBoundingClientRect().height,contentHeight:this.getDomRef("tableCCnt").getBoundingClientRect().height})},this);const r=this.$();if(h.hasRowActions(this)||h.hasRowNavigationIndicators(this)){const e=r.hasClass("sapUiTableRActFlexible");const t=this.getDomRef("dummycolhdr");if(t){const o=t.clientWidth>2;if(!e&&o){const e=this.getColumns().reduce(function(e,t){const o=t.getDomRef();if(o&&t.getIndex()>=this.getComputedFixedColumnCount()){e+=o.offsetWidth}return e}.bind(this),0);let t=e+s.tableRowHdrScrWidth+s.tableCtrlFixedWidth;const o={};if(!h.hasRowActions(this)){t=t-h.ThemeParameters.navIndicatorWidth+h.BaseBorderWidth}o[this._bRtlMode?"right":"left"]=t;this.$("sapUiTableRowActionScr").css(o);this.$("rowacthdr").css(o);r.toggleClass("sapUiTableRActFlexible",true)}else if(e&&!o){this.$("sapUiTableRowActionScr").removeAttr("style");this.$("rowacthdr").removeAttr("style");r.toggleClass("sapUiTableRActFlexible",false)}}}r.find(".sapUiTableNoOpacity").addBack().removeClass("sapUiTableNoOpacity");h.Hook.call(this,E.UpdateSizes,e)};U.prototype.setShowOverlay=function(e){this.setProperty("showOverlay",e,true);if(this.getDomRef()){this.$().toggleClass("sapUiTableOverlay",this.getShowOverlay());this._getAccExtension().updateAriaStateForOverlayAndNoData();this._getKeyboardExtension().updateNoDataAndOverlayFocus()}return this};U.prototype._updateFixedBottomRows=function(){const e=this.getDomRef();if(!e||this._getRowCounts().fixedBottom===0){return}const t=h.getFirstFixedBottomRowIndex(this);const o=this.getRows();let i;jQuery(e).find(".sapUiTableRowLastScrollable").removeClass("sapUiTableRowLastScrollable");jQuery(e).find(".sapUiTableRowFirstFixedBottom").removeClass("sapUiTableRowFirstFixedBottom");if(t>=0&&t<o.length){i=o[t].getDomRefs(true);i.row.addClass("sapUiTableRowFirstFixedBottom",true)}if(t>=1&&t<o.length){i=o[t-1].getDomRefs(true);i.row.addClass("sapUiTableRowLastScrollable",true)}};U.prototype.focus=function(e){this._oFocusInfo=e;o.prototype.focus.apply(this,arguments);delete this._oFocusInfo};U.prototype.getFocusInfo=function(){const e=this.$().find(":focus").attr("id");if(e){return{customId:e}}else{return o.prototype.getFocusInfo.apply(this,arguments)}};U.prototype.applyFocusInfo=function(e){delete this._bApplyFocusInfoFailed;if(e&&e.customId){if(document.getElementById(e.customId)){jQuery(document.getElementById(e.customId)).trigger("focus")}else{this._bApplyFocusInfoFailed=true}}else{o.prototype.applyFocusInfo.apply(this,arguments)}return this};U.prototype.setTitle=function(e){let t=e;if(typeof e==="string"||e instanceof String){t=h._getTableTemplateHelper().createTextView({text:e});t.addStyleClass("sapUiTableHdrTitle")}this.setAggregation("title",t);return this};U.prototype.setFooter=function(e){let t=e;if(typeof e==="string"||e instanceof String){t=h._getTableTemplateHelper().createTextView({text:e})}this.setAggregation("footer",t);return this};U.prototype.setSelectionMode=function(e){if(e===D.Multi){e=D.MultiToggle;I.warning("The selection mode 'Multi' is deprecated and must not be used anymore."+" Your setting was defaulted to selection mode 'MultiToggle'",this)}if(T.findOn(this)){I.error("If a selection plugin is applied to the table, the selection mode is controlled by the plugin.",this)}else{this.setProperty("selectionMode",e);H(this).oLegacySelectionPlugin?.setSelectionMode(e)}return this};U.prototype.setFirstVisibleRow=function(e){if(e==null){e=0}else if(e<0){I.error("The index of the first visible row must be greater than or equal to 0. The value has been set to 0.",this);e=0}else if(this._bContextsAvailable){const t=this._getMaxFirstVisibleRowIndex();if(t<e){I.warning("The index of the first visible row is too high. The value has been set to "+t+".",this);e=t}}this._setFirstVisibleRowIndex(e);return this};U.prototype._setFirstVisibleRowIndex=function(e,t){t=Object.assign({onScroll:false,suppressScrolling:false,suppressEvent:false,forceEvent:false,suppressRendering:false,onlySetProperty:false},t);if(this._bContextsAvailable){e=Math.min(e,this._getMaxFirstVisibleRowIndex())}e=Math.max(0,e);const o=this.getFirstVisibleRow()!==e;const i=this._getFirstRenderedRowIndex();const n=this._bContextsAvailable?Math.min(e,this._getMaxFirstRenderedRowIndex()):e;const s=this._getScrollExtension();this.setProperty("firstVisibleRow",e,true);if(!t.suppressRendering){H(this).iFirstRenderedRowIndex=n}if(t.onlySetProperty){return false}if((o||t.forceEvent)&&!t.suppressEvent){this.fireFirstVisibleRowChanged({firstVisibleRow:e})}if(!this.getBinding()){s.updateVerticalScrollPosition();return false}let r=false;const l=this.getBinding()!=null&&n!==i;if(l){if(!t.suppressRendering){this._bScrolled=t.onScroll;$(this,t.onScroll?h.RowsUpdateReason.VerticalScroll:h.RowsUpdateReason.FirstVisibleRowChange);r=true}if(!t.onScroll&&!t.suppressScrolling){s.updateVerticalScrollPosition(r)}}else if(!t.onScroll&&!t.suppressScrolling){s.updateVerticalScrollPosition(!this._bContextsAvailable)}return r};U.prototype._setFocus=function(e,t){return new Promise(function(o){if(e===-1){e=this._getTotalRowCount()-1}if(typeof e!=="number"||e<-1){e=0}const i=this.getFirstVisibleRow();const n=this._getRowCounts().count;if(e>i&&e<i+n){this.getRows()[e-i]._setFocus(t);return o()}if(this._setFirstVisibleRowIndex(e)){this.attachEventOnce("_rowsUpdated",function(){O(this,e,t);return o()})}else{O(this,e,t);return o()}}.bind(this))};function O(e,t,o){const i=e._getTotalRowCount();const n=e._getFirstRenderedRowIndex();e.getRows()[Math.min(t,i-1)-n]._setFocus(o)}U.getMetadata().getAggregation("rows")._doesNotRequireFactory=true;U.prototype.bindAggregation=function(e,t){if(e==="rows"){this._bindRows(z(Array.prototype.slice.call(arguments,1)));return this}return o.prototype.bindAggregation.apply(this,arguments)};U.prototype.bindRows=function(e){this._bindRows(z(arguments));return this};U.prototype._bindRows=function(e){W(this);this._bRowsBeingBound=true;j(this);X(this);U._addBindingListener(e,"change",function(){this._onBindingChange.apply(this,arguments)}.bind(this));U._addBindingListener(e,"dataRequested",function(){this._onBindingDataRequested.apply(this,arguments)}.bind(this));U._addBindingListener(e,"dataReceived",function(){this._onBindingDataReceived.apply(this,arguments)}.bind(this));h.Hook.call(this,E.BindRows,e);o.prototype.bindAggregation.call(this,"rows",e);this._bRowsBeingBound=false};U.prototype._bindAggregation=function(e,t){if(e==="rows"){W(this);this._bRowsBeingBound=true}o.prototype._bindAggregation.call(this,e,t);if(e==="rows"){h.Grouping.setupExperimentalGrouping(this);const e=this.getBinding();const t=e?e.getModel():null;this._bRowsBeingBound=false;h.Hook.call(this,E.RowsBound,e);if(t&&t.getDefaultBindingMode()===u.OneTime){I.error('The binding mode of the model is set to "OneTime".'+' This binding mode is not supported for the "rows" aggregation!'+" Scrolling can not be performed.",this)}}};U.prototype.unbindAggregation=function(e,t){if(e==="rows"){this._unbindRows();return this}return o.prototype.unbindAggregation.apply(this,arguments)};U.prototype.unbindRows=function(){this._unbindRows();return this};U.prototype._unbindRows=function(){const e=this.getBindingInfo("rows");if(e){h.Hook.call(this,E.UnbindRows,e)}o.prototype.unbindAggregation.call(this,"rows",true);if(this._bRowsBeingBound||this.bIsDestroyed||this._bIsBeingDestroyed){return}this._adjustToTotalRowCount();if(e){h.Hook.call(this,E.RowsUnbound)}W(this);X(this)};function W(e){e._bRowsBeingBound=false;e._bContextsAvailable=false;H(e).iPendingRequests=0;e._iBindingLength=null}function z(e){let t;if(e==null||e[0]==null){t={}}else if(typeof e[0]==="string"){const o=e[0];let i=e[1];let n=e[2];let s=e[3];if(i instanceof a||Array.isArray(n)&&n[0]instanceof l){s=n;n=i;i=undefined}t={path:o,sorter:n,filters:s,template:i}}else{t=e[0]}return t}U._addBindingListener=function(e,t,o,i){if(!e.events){e.events={}}const n=e.events[t];e.events[t]=function(){o.apply(i,arguments);if(n){n.apply(this,arguments)}}};U.prototype._onBindingChange=function(e){};U.prototype.setRowMode=function(e){q(this);this.setAggregation("rowMode",e);N(this);return this};U.prototype.destroyRowMode=function(){this.destroyAggregation("rowMode");if(!H(this).oDefaultRowMode){N(this)}return this};function L(e){const t=e.getRowMode();if(!e.isDestroyStarted()&&!h.isA(t,"sap.ui.table.rowmodes.RowMode")&&!H(e).oDefaultRowMode){N(e)}return h.isA(t,"sap.ui.table.rowmodes.RowMode")?t:H(e).oDefaultRowMode}function N(e){const t=e.getRowMode();const o=h.isA(t,"sap.ui.table.rowmodes.RowMode")?undefined:t||R.Fixed;if(o===undefined||H(e).oDefaultRowMode){return}if(t===null){switch(e.getVisibleRowCountMode()){case R.Fixed:H(e).oDefaultRowMode=new _(true);break;case R.Interactive:H(e).oDefaultRowMode=new x(true);break;case R.Auto:H(e).oDefaultRowMode=new S(true);break;default:throw new Error("Default row mode could not be created")}e.addAggregation("_hiddenDependents",H(e).oDefaultRowMode);return}switch(o){case R.Fixed:H(e).oDefaultRowMode=new _;break;case R.Interactive:H(e).oDefaultRowMode=new x;break;case R.Auto:H(e).oDefaultRowMode=new S;break;default:throw new Error("Default row mode could not be created")}e.addAggregation("_hiddenDependents",H(e).oDefaultRowMode)}function q(e){if(H(e).oDefaultRowMode){H(e).oDefaultRowMode.destroy();delete H(e).oDefaultRowMode}}U.prototype._getRowCounts=function(){const e=L(this).getComputedRowCounts();const t=this._bVariableRowHeightEnabled&&!e.fixedTop&&!e.fixedBottom;e._fullsize=e.count;e._scrollSize=e.scrollable;if(e.count>0&&t){e.count++;e.scrollable++}return e};U.prototype._isNoDataDisabled=function(){return!this.getShowNoData()||(L(this)?.isNoDataDisabled()??false)};U.prototype.setVisibleRowCountMode=function(e){if(this.getRowMode()){I.warning('If the "rowMode" aggregation is set, setting the "visibleRowCountMode" has no effect');return this.setProperty("visibleRowCountMode",e,true)}const t=this.getVisibleRowCountMode();this.setProperty("visibleRowCountMode",e);const o=this.getVisibleRowCountMode();if(o!==t){q(this);N(this)}return this};U.prototype.setVisibleRowCount=function(e){const t=this.getVisibleRowCountMode();if(t==="Auto"){I.error("VisibleRowCount will be ignored since VisibleRowCountMode is set to Auto",this);return this}if(e!=null&&!isFinite(e)){return this}const o=this.getFixedRowCount()+this.getFixedBottomRowCount();if(e<=o&&o>0){I.error("Table: "+this.getId()+" visibleRowCount('"+e+"') must be bigger than number of"+" fixed rows('"+(this.getFixedRowCount()+this.getFixedBottomRowCount())+"')",this);return this}if(this.getRowMode()){I.warning('If the "rowMode" aggregation is set, setting the "visibleRowCount" has no effect');return this.setProperty("visibleRowCount",e,true)}e=this.validateProperty("visibleRowCount",e);this.setProperty("visibleRowCount",e);h.dynamicCall(this._getSyncExtension,function(t){t.syncRowCount(e)});return this};U.prototype.setMinAutoRowCount=function(e){if(parseInt(e)<1){I.error("The minAutoRowCount property must be greater than 0. The value has been set to 1.",this);e=1}if(this.getRowMode()){I.warning('If the "rowMode" aggregation is set, setting the "minAutoRowCount" has no effect');return this.setProperty("minAutoRowCount",e,true)}return this.setProperty("minAutoRowCount",e)};U.prototype.setTooltip=function(e){I.warning("The aggregation tooltip is not supported for sap.ui.table.Table",this);return this.setAggregation("tooltip",e,true)};U.prototype.setNavigationMode=function(){this.setProperty("navigationMode","Scrollbar",true);I.error("The navigationMode property is deprecated and must not be used anymore. Your setting was defaulted to 'Scrollbar'",this);return this};U.prototype._getRowContexts=function(e){const t=this.getBinding();const o=this._getRowCounts();let i=this._bScrolled?this._getScrollThreshold():this.getThreshold();this._bScrolled=false;e=e==null?o.count:e;if(i!==0){i=Math.max(e-o.fixedTop-o.fixedBottom,i)}e=Math.max(e,L(this).getMinRequestLength(),0);if(!t||e===0){return[]}const n=this._getFirstRenderedRowIndex();const s=[];if(o.fixedTop>0&&n>0){k(s,this._getFixedTopRowContexts(),0);k(s,this._getContexts(n+o.fixedTop,e-o.fixedBottom-o.fixedTop,i),o.fixedTop)}else{k(s,this._getContexts(n,e-o.fixedBottom,i),0)}if(o.fixedBottom>0){k(s,this._getFixedBottomRowContexts(),Math.min(o.fixedTop+o.scrollable,Math.max(this._getTotalRowCount()-o.fixedBottom,0)))}if(typeof s.bExpectMore==="boolean"){H(this).bIsWaitingForData=s.bExpectMore;X(this)}return s};function k(e,t,o){for(let i=0;i<t.length;i++){e[o+i]=t[i]}e.bExpectMore||=t.bExpectMore}U.prototype._getFixedTopRowContexts=function(){const e=this._getRowCounts();return e.fixedTop>0?this._getContexts(0,e.fixedTop,0,true):[]};U.prototype._getFixedBottomRowContexts=function(){const e=this._getRowCounts();const t=Y(this,true);if(e.fixedBottom>0&&e.count-e.fixedBottom<t){return this._getContexts(t-e.fixedBottom,e.fixedBottom,0,true)}else{return[]}};U.prototype._getContexts=function(e,t,o,i){if(!this.getVisible()){return[]}const n=this.getBinding();return n?n.getContexts(e,t,o,i):[]};U.prototype._adjustToTotalRowCount=function(){const e=this._getTotalRowCount();if(this._iBindingLength!==e){this._iBindingLength=e;this._updateFixedBottomRows();this._adjustFirstVisibleRowToTotalRowCount();h.Hook.call(this,E.TotalRowCountChanged)}};U.prototype._adjustFirstVisibleRowToTotalRowCount=function(){const e=this.getFirstVisibleRow();const t=this._getMaxFirstVisibleRowIndex();if(t<e&&this._bContextsAvailable){this._setFirstVisibleRowIndex(t,{onlySetProperty:true})}};U.prototype.refreshRows=function(e){this._bContextsAvailable=false;if(e===r.Sort||e===r.Filter){this.setFirstVisibleRow(0)}h.Hook.call(this,E.RefreshRows,e||h.RowsUpdateReason.Unknown)};U.prototype.updateRows=function(e,t){if(this.bIsDestroyed||this._bIsBeingDestroyed){return}if(t.detailedReason==="AddVirtualContext"){G(this);return}else if(t.detailedReason==="RemoveVirtualContext"){j(this);return}this._bContextsAvailable=true;if(e===r.Sort||e===r.Filter){this.setFirstVisibleRow(0)}this._adjustToTotalRowCount();$(this,e)};function G(e){const t=e._getRowContexts()[0];j(e);e._oVirtualRow=e._getRowClone("virtual");e._oVirtualRow.setBindingContext(t,e.getBindingInfo("rows").model);e.addAggregation("_hiddenDependents",e._oVirtualRow)}function j(e){if(e._oVirtualRow){e._oVirtualRow.destroy();delete e._oVirtualRow}}function $(e,t){if(e._bContextsAvailable){h.Hook.call(e,E.UpdateRows,t||h.RowsUpdateReason.Unknown)}}U.prototype.insertRow=function(){I.error('The control manages the rows aggregation. The method "insertRow" cannot be used programmatically!',this);return this};U.prototype.addRow=function(){I.error('The control manages the rows aggregation. The method "addRow" cannot be used programmatically!',this);return this};U.prototype.removeRow=function(){I.error('The control manages the rows aggregation. The method "removeRow" cannot be used programmatically!',this);return null};U.prototype.removeAllRows=function(){I.error('The control manages the rows aggregation. The method "removeAllRows" cannot be used programmatically!',this);return[]};U.prototype.destroyRows=function(){I.error('The control manages the rows aggregation. The method "destroyRows" cannot be used programmatically!',this);return this};U.prototype.setCreationRow=function(e){if(!h.isA(e,"sap.ui.table.CreationRow")){e=null}return this.setAggregation("creationRow",e)};U.prototype.getCreationRow=function(){return this.getAggregation("creationRow")};U.prototype.autoResizeColumn=function(e){const t=this._getVisibleColumns();const o=t[e];if(o?.getResizable()&&o?.getAutoResizable()){o.autoResize()}};U.prototype._attachEvents=function(){const e=this.$();const o=this.getId();if(i.getAnimationMode()!==B.none){jQuery(document.body).on("webkitTransitionEnd."+o+" transitionend."+o,function(t){if(jQuery(t.target).has(e).length>0){this._updateTableSizes(h.RowsUpdateReason.Animation)}}.bind(this))}t.resize.attachHandler(this._onWindowResize,this);g.attachEvents(this)};U.prototype._detachEvents=function(){const e=this.getId();jQuery(document.body).off("webkitTransitionEnd."+e+" transitionend."+e);h.deregisterResizeHandler(this,"Table");t.resize.detachHandler(this._onWindowResize,this);g.detachEvents(this)};U.prototype._cleanUpTimers=function(){let e;for(e in this._mTimeouts){if(this._mTimeouts[e]){window.clearTimeout(this._mTimeouts[e]);delete this._mTimeouts[e]}}for(e in this._mAnimationFrames){if(this._mAnimationFrames[e]){window.cancelAnimationFrame(this._mAnimationFrames[e]);delete this._mAnimationFrames[e]}}};function K(e){const t=e.getDomRef();if(t){e.getDomRef().classList.toggle("sapUiTableEmpty",h.isNoDataVisible(e));e._getAccExtension().updateAriaStateForOverlayAndNoData();e._getKeyboardExtension().updateNoDataAndOverlayFocus()}}U.prototype.removeColumn=function(e){e=this.removeAggregation("columns",e);if(e===null){return e}if(!this._bReorderInProcess){this._removeSortedColumn(e)}Z(this);return e};U.prototype.removeAllColumns=function(){const e=this.removeAllAggregation("columns");this._aSortedColumns=[];Z(this);return e};U.prototype.destroyColumns=function(){const e=this.destroyAggregation("columns");this._aSortedColumns=[];Z(this);return e};U.prototype.addColumn=function(e){this.addAggregation("columns",e);Z(this);return this};U.prototype.insertColumn=function(e,t){this.insertAggregation("columns",e,t);Z(this);return this};function Z(e){e.invalidateRowsAggregation();e._invalidateComputedFixedColumnCount();const t=e.getCreationRow();if(t){t._update()}}U.prototype._getTotalRowCount=function(){return Y(this)};function Y(e,t){const o=e.getBinding();const i=e.getBindingInfo("rows");if(!o){return 0}if(i.length!=null){return i.length}if(t===true){return o.getLength()}if(!e._bContextsAvailable){return H(e).iCachedBindingLength}H(e).iCachedBindingLength=o.getLength();return H(e).iCachedBindingLength}U.prototype._getMaxFirstVisibleRowIndex=function(){let e;if(h.isVariableRowHeightEnabled(this)){e=this._getTotalRowCount()-1}else{e=this._getTotalRowCount()-this._getRowCounts().count}return Math.max(0,e)};U.prototype._getMaxFirstRenderedRowIndex=function(){const e=this._getTotalRowCount()-this._getRowCounts().count;return Math.max(0,e)};U.prototype._getFirstRenderedRowIndex=function(){return H(this).iFirstRenderedRowIndex};U.prototype._getVisibleColumns=function(){const e=[];const t=this.getColumns();for(let o=0,i=t.length;o<i;o++){if(t[o].shouldRender()){e.push(t[o])}}return e};U.prototype._getColumnsWidth=function(e,t){const o=this.getColumns();let i=0;if(e!==0&&!e){e=0}if(t!==0&&!t){t=o.length}for(let n=e,s=t;n<s;n++){if(o[n]&&o[n].shouldRender()){let e=h.convertCSSSizeToPixel(o[n].getWidth());if(e==null){e=h.Column.getMinColumnWidth()}i+=e}}return i};U.prototype._onTableResize=function(e){const t=e.oldSize.width;const o=e.size.width;if(this._bInvalid||!this.getDomRef()||t===o){return}this._updateTableSizes(h.RowsUpdateReason.Resize)};U.prototype._onWindowResize=function(){if(this._bInvalid||!this.getDomRef()){return}if(t.browser.chrome&&window.devicePixelRatio!==this._nDevicePixelRatio){this._nDevicePixelRatio=window.devicePixelRatio;this._updateTableSizes(h.RowsUpdateReason.Zoom);this._adjustOutlineOffset()}};U.prototype._adjustOutlineOffset=function(){if(window.devicePixelRatio<1){this.addStyleClass("sapUiTableZoomout")}else{this.removeStyleClass("sapUiTableZoomout")}};U.prototype._disableTextSelection=function(e){jQuery(e||document.body).attr("unselectable","on").css({"-moz-user-select":"none","-webkit-user-select":"none","user-select":"none"}).on("selectstart",function(e){e.preventDefault();return false})};U.prototype._enableTextSelection=function(e){jQuery(e||document.body).attr("unselectable","off").css({"-moz-user-select":"","-webkit-user-select":"","user-select":""}).off("selectstart")};U.prototype._findAndfireCellEvent=function(e,t,o){const i=jQuery(t.target);const n=i.closest(".sapUiTableDataCell");const s=n.attr("id");const r=/.*-row(\d*)-col(\d*)/i.exec(s);let l=false;if(r){const t=r[1];const i=r[2];const s=this.getRows()[t];const a=s&&s.getCells()[i];const u=s&&s.getIndex();const p=d.ofCell(a).getId();const c=s.getRowBindingContext();const h={rowIndex:u,columnIndex:i,columnId:p,cellControl:a,rowBindingContext:c,cellDomRef:n.get(0)};l=!e.call(this,h);if(!l&&typeof o==="function"){h.cellDomRef=n[0];l=o.call(this,h)}}return l};U.prototype.getFocusDomRef=function(){this._getKeyboardExtension().initItemNavigation();if(this.getShowOverlay()){return this.getDomRef("overlay")}if(h.isNoDataVisible(this)){return this.getDomRef("noDataCnt")}const e=this._oFocusInfo&&this._oFocusInfo.targetInfo&&h.isA(this._oFocusInfo.targetInfo,"sap.ui.core.message.Message");if(e&&this.getColumnHeaderVisible()){const e=this._getVisibleColumns()[0];if(e){return e.getDomRef()}}const t=h.getFocusedItemInfo(this);if(t&&t.domRef){return t.domRef}return o.prototype.getFocusDomRef.apply(this,arguments)};U.prototype.pushSortedColumn=function(e,t){if(!t){this._aSortedColumns=[]}if(this._aSortedColumns.indexOf(e)===-1){this._aSortedColumns.push(e)}};U.prototype._removeSortedColumn=function(e){const t=this._aSortedColumns.indexOf(e);if(t>-1){this._aSortedColumns.splice(t,1)}};U.prototype.getSortedColumns=function(){return this._aSortedColumns.slice()};U.prototype.sort=function(e,t,o){if(!e){this._aSortedColumns.forEach(e=>{e.setSorted(false);e.setSortOrder(V.None)});this.getBinding()?.sort();this._aSortedColumns=[]}if(this.getColumns().indexOf(e)>=0){e._sort(t??V.Ascending,o)}};U.prototype.filter=function(e,t){if(this.getColumns().indexOf(e)>=0){if(t==null){t=""}else if(typeof t!=="string"){throw new Error("The filter value is not a string")}e.filter(t)}};U.prototype._updateSelection=function(){const e=this.getSelectionMode();if(e===D.None){return}const t=this._getSelectionPlugin().getRenderConfig();const o=this.$("selall");const i=this.getRows();for(let e=0;e<i.length;e++){const t=i[e];t._updateSelection()}if(!t.headerSelector.visible){return}if(t.headerSelector.type==="toggle"){const e=t.headerSelector.selected;o.toggleClass("sapUiTableSelAll",!e);this._getAccExtension().setSelectAllState(e)}else if(t.headerSelector.type==="custom"){o.toggleClass("sapUiTableSelAllDisabled",!t.headerSelector.enabled);if(t.headerSelector.enabled){o.removeAttr("aria-disabled")}else{o.attr("aria-disabled","true")}const e=t.headerSelector.tooltip;o.attr("title",e)}};function J(e){const t=H(this).oLegacySelectionPlugin;const o=e.getParameter("rowIndices");const i=e.getParameter("selectAll");const n=this._iSourceRowIndex!==undefined?this._iSourceRowIndex:t.getSelectedIndex();this._updateSelection();if(this.getMetadata().hasProperty("selectedIndex")){this.setProperty("selectedIndex",t.getSelectedIndex(),true)}this.fireRowSelectionChange({rowIndex:n,rowContext:this.getContextByIndex(n),rowIndices:o,selectAll:i,userInteraction:this._iSourceRowIndex!==undefined})}U.prototype.getContextByIndex=function(e){const t=this.getBinding();let o=null;if(!t||e<0){return o}if(t.getContextByIndex){o=t.getContextByIndex(e)}else{o=t.getContexts(e,1,0,true)[0]}return o||null};U.prototype.getSelectedIndex=function(){if(T.findOn(this)){throw new Error("Unsupported operation: sap.ui.table.Table#getSelectedIndex must not be called if a selection plugin is applied.")}return this._getSelectionPlugin().getSelectedIndex()};U.prototype.setSelectedIndex=function(e){if(T.findOn(this)){throw new Error("Unsupported operation: sap.ui.table.Table#setSelectedIndex must not be called if a selection plugin is applied.")}H(this).oLegacySelectionPlugin?.setSelectedIndex(e);this.setProperty("selectedIndex",e,true);return this};U.prototype.clearSelection=function(){if(T.findOn(this)){throw new Error("Unsupported operation: sap.ui.table.Table#clearSelection must not be called if a selection plugin is applied.")}this._getSelectionPlugin().clearSelection();return this};U.prototype.selectAll=function(){if(T.findOn(this)){throw new Error("Unsupported operation: sap.ui.table.Table#selectAll must not be called if a selection plugin is applied.")}if(h.hasSelectAll(this)){this._getSelectionPlugin().selectAll()}return this};U.prototype.getSelectedIndices=function(){if(T.findOn(this)){throw new Error("Unsupported operation: sap.ui.table.Table#getSelectedIndices must not be called if a selection plugin is applied.")}return this._getSelectionPlugin().getSelectedIndices()};U.prototype.addSelectionInterval=function(e,t){if(T.findOn(this)){throw new Error("Unsupported operation: sap.ui.table.Table#addSelectionInterval must not be called if a selection plugin is applied.")}this._getSelectionPlugin().addSelectionInterval(e,t);return this};U.prototype.setSelectionInterval=function(e,t){if(T.findOn(this)){throw new Error("Unsupported operation: sap.ui.table.Table#setSelectionInterval must not be called if a selection plugin is applied.")}this._getSelectionPlugin().setSelectionInterval(e,t);return this};U.prototype.removeSelectionInterval=function(e,t){if(T.findOn(this)){throw new Error("Unsupported operation: sap.ui.table.Table#removeSelectionInterval must not be called if a selection plugin is applied.")}this._getSelectionPlugin().removeSelectionInterval(e,t);return this};U.prototype.isIndexSelected=function(e){if(T.findOn(this)){throw new Error("Unsupported operation: sap.ui.table.Table#isIndexSelected must not be called if a selection plugin is applied.")}return this._getSelectionPlugin().isIndexSelected(e)};U.prototype.setGroupBy=function(e){let t=e;const o=n.getElementById(this.getGroupBy());if(typeof t==="string"){t=n.getElementById(t)}let i=false;if(t instanceof d&&t!==o){if(this.getColumns().indexOf(t)===-1){throw new Error("Column has to be part of the columns aggregation!")}const e=this.fireGroup({column:t,groupedColumns:[t.getId()],type:F.group});if(o){o.setGrouped(false);i=true}if(e&&this.getEnableGrouping()){t.setGrouped(true)}}if(!t||i){if(o){o.setGrouped(false)}h.Grouping.resetExperimentalGrouping(this)}this.setAssociation("groupBy",t);h.Grouping.setupExperimentalGrouping(this);return this};U.prototype.getBinding=function(e){return o.prototype.getBinding.call(this,e==null?"rows":e)};U.prototype.setEnableGrouping=function(e){const t=n.getElementById(this.getGroupBy());this.setProperty("enableGrouping",e);if(t){t.setGrouped(e)}if(e){h.Grouping.setupExperimentalGrouping(this)}else{h.Grouping.resetExperimentalGrouping(this)}return this};U.prototype.getComputedFixedColumnCount=function(){if(this._bIgnoreFixedColumnCount){return 0}return this._getSpanBasedComputedFixedColumnCount()};U.prototype._getSpanBasedComputedFixedColumnCount=function(){if(H(this).iComputedFixedColumnCount===null){const e=this.getColumns();let t;let o=this.getFixedColumnCount();for(let i=o-1;i>=0;i--){t=e[i];if(t){o=Math.max(o,t.getIndex()+h.Column.getHeaderSpan(t));break}}H(this).iComputedFixedColumnCount=Math.min(o,e.length)}return H(this).iComputedFixedColumnCount};U.prototype.setFixedColumnCount=function(e){this.setProperty("fixedColumnCount",e);this._invalidateComputedFixedColumnCount();const t=this.getColumns();let o;const i=this.$().find(".sapUiTableCtrlFirstCol > th");for(let e=this._getSpanBasedComputedFixedColumnCount()-1;e>=0;e--){o=t[e];if(o&&h.isVariableWidth(o.getWidth())){o._iFixWidth=i.filter("[data-sap-ui-headcolindex='"+o.getIndex()+"']").width()}}this._collectTableSizes();if(this.getEnableColumnFreeze()){this._invalidateColumnMenus()}return this};U.prototype.setFixedRowCount=function(e){if(!(parseInt(e)>=0)){I.error("Number of fixed rows must be greater or equal 0",this);return this}if(e+this.getFixedBottomRowCount()>=this.getVisibleRowCount()){I.error("Table '"+this.getId()+"' fixed rows('"+(e+this.getFixedBottomRowCount())+"') must be smaller than"+" numberOfVisibleRows('"+this.getVisibleRowCount()+"')",this);return this}if(this.getRowMode()){I.warning('If the "rowMode" aggregation is set, setting the "fixedRowCount" has no effect');return this.setProperty("fixedRowCount",e,true)}return this.setProperty("fixedRowCount",e)};U.prototype.setFixedBottomRowCount=function(e){if(!(parseInt(e)>=0)){I.error("Number of fixed bottom rows must be greater or equal 0",this);return this}if(e+this.getFixedRowCount()>=this.getVisibleRowCount()){I.error("Table '"+this.getId()+"' fixed rows('"+(e+this.getFixedRowCount())+"') must be smaller than"+" numberOfVisibleRows('"+this.getVisibleRowCount()+"')",this);return this}if(this.getRowMode()){I.warning('If the "rowMode" aggregation is set, setting the "iFixedBottomRowCount" has no effect');return this.setProperty("fixedBottomRowCount",e,true)}return this.setProperty("fixedBottomRowCount",e)};U.prototype.setThreshold=function(e){this.setProperty("threshold",e,true);return this};U.prototype.setScrollThreshold=function(e){this.setProperty("scrollThreshold",e,true);return this};U.prototype._invalidateColumnMenus=function(){h.Hook.call(this,h.Hook.Keys.Table.InvalidateColumnMenus,this)};U.prototype._isTouchEvent=function(e){return!!(e&&e.originalEvent&&e.originalEvent.touches)};U.prototype._getRowClone=function(e){const t=typeof e==="number";const o=t;let i=o?this._aRowClones[e]:null;if(i&&!i.bIsDestroyed){return i}i=new p(this.getId()+"-rows"+"-row"+(t?e:"-"+e));if(o){this._aRowClones[e]=i}const n=this.getColumns();for(let e=0,t=n.length;e<t;e++){if(n[e].getVisible()){const t=n[e].getTemplateClone(e);if(t){i.addCell(t)}}}if(h.hasRowActions(this)){const e=this.getRowActionTemplate().clone();i.setAggregation("_rowAction",e,true)}const s=this.getRowSettingsTemplate();if(s){const e=s.clone();i.setAggregation("_settings",e,true)}return i};U.prototype.invalidateRowsAggregation=function(){this._bRowAggregationInvalid=true};U.prototype._invalidateComputedFixedColumnCount=function(){H(this).iComputedFixedColumnCount=null};U.prototype._getBaseRowHeight=function(){const e=L(this).getBaseRowContentHeight();if(e>0){return e+h.RowHorizontalFrameSize}else{return this._getDefaultRowHeight()}};U.prototype._getDefaultRowHeight=function(){const e=h.getContentDensity(this);return h.DefaultRowHeight[e]};U.prototype._getDefaultRowContentHeight=function(){const e=h.getContentDensity(this);return h.BaseSize[e]};U.prototype.setNoData=function(e){const t=h.getNoContentMessage(this);this.setAggregation("noData",e,true);const o=h.getNoContentMessage(this);if(h.isA(e,"sap.m.IllustratedMessage")){Q(this)}else{this.destroyAggregation("_noColumnsMessage",true)}if(typeof t==="string"&&typeof o==="string"){if(t!==o){this.$("noDataMsg").text(o)}}else{this.invalidate()}return this};function Q(e){if(e.getAggregation("_noColumnsMessage")||H(e).bIsLoadingNoColumnsMessage){return}H(e).bIsLoadingNoColumnsMessage=true;sap.ui.require(["sap/m/table/Util"],function(t){if(!h.isA(e.getNoData(),"sap.m.IllustratedMessage")){return}const o=t.getNoColumnsIllustratedMessage();o.setEnableVerticalResponsiveness(true);e.setAggregation("_noColumnsMessage",o,h.getVisibleColumnCount(e)>0);delete H(e).bIsLoadingNoColumnsMessage})}U.prototype.exportData=function(e){const t=sap.ui.requireSync("sap/ui/core/util/Export");e=e||{};if(!e.rows){const t=this.getBinding();const o=this.getBindingInfo("rows");const i=t.aFilters.concat(t.aApplicationFilters);e.rows={path:o.path,model:o.model,sorter:t.aSorters,filters:i,parameters:o.parameters}}if(!e.exportType){const t=sap.ui.requireSync("sap/ui/core/util/ExportTypeCSV");e.exportType=new t}let o=e.rows.model;if(!o){const t=e.rows.path;const i=t.indexOf(">");if(i>0){o=t.substr(0,i)}}if(!e.columns){e.columns=[];const t=this.getColumns();for(let i=0,n=t.length;i<n;i++){const n=t[i];if(n.getSortProperty()){e.columns.push({name:n.getLabel().getText(),template:{content:{path:n.getSortProperty(),model:o}}})}}}const i=new t(e);this.addDependent(i);return i};U.prototype._onPersoApplied=function(){const e=this.getColumns();const t=[];for(let o=0,i=e.length;o<i;o++){const i=e[o];if(i.getSorted()&&i.getSortOrder()!==V.None){t.push(new a(i.getSortProperty(),i.getSortOrder()===V.Descending))}}const o=this.getBinding();if(o){if(t.length>0){o.sort(t)}}};U.prototype.setBusy=function(e){const t=this.getBusy();const i=this.getCreationRow()?"sapUiTableGridCnt":"sapUiTableCnt";const n=o.prototype.setBusy.call(this,e,i);const s=this.getBusy();if(t!==s){this.fireBusyStateChanged({busy:s})}return n};U.prototype.setEnableBusyIndicator=function(e){this.setProperty("enableBusyIndicator",e,true);if(this.getEnableBusyIndicator()){X(this)}else{this.setBusy(false);ee(this)}return this};U.prototype._onBindingDataRequested=function(){H(this).iPendingRequests++;X(this)};U.prototype._onBindingDataReceived=function(){H(this).iPendingRequests--;X(this)};U.prototype._isWaitingForData=function(){const e=H(this);return e.iPendingRequests>0&&e.bIsWaitingForData!==false};function X(e){if(!e.getEnableBusyIndicator()){return}ee(e);if(e._isWaitingForData()){e.setBusy(true)}else{H(e).hideBusyIndicatorTimeoutId=setTimeout(function(){e.setBusy(false);ee(e)},10)}}function ee(e){clearTimeout(H(e).hideBusyIndicatorTimeoutId);delete H(e).hideBusyIndicatorTimeoutId}U.prototype._setLargeDataScrolling=function(e){this._bLargeDataScrolling=!!e};U.prototype.setRowActionTemplate=function(e){this.setAggregation("rowActionTemplate",e);this.invalidateRowsAggregation();return this};U.prototype.setRowActionCount=function(e){if(typeof e==="number"){e=Math.max(0,Math.min(e,2))}return this.setProperty("rowActionCount",e)};U.prototype.setRowSettingsTemplate=function(e){this.setAggregation("rowSettingsTemplate",e);this.invalidateRowsAggregation();return this};U.prototype._getSelectionPlugin=function(){let e=T.findOn(this);let t=H(this).oLegacySelectionPlugin;if(this.getPlugins().length>0){e=this.getPlugins()[0]}if(e&&t){delete H(this).oLegacySelectionPlugin;t.destroy()}else if(!e&&!t&&!this.isDestroyed()){t=this._createLegacySelectionPlugin();H(this).oLegacySelectionPlugin=t;t.setSelectionMode(this.getSelectionMode());t.setSelectedIndex(this.getProperty("selectedIndex"));t.attachSelectionChange(J,this);this.addAggregation("_hiddenDependents",t);if(typeof this._getSelectedIndicesCount==="function"&&t.getSelectedCount!==this._getSelectedIndicesCount){t.getSelectedCount=this._getSelectedIndicesCount;["isIndexSelected","setSelectedIndex","getSelectedIndex","getSelectedIndices","setSelectionInterval","addSelectionInterval","removeSelectionInterval","selectAll","clearSelection"].forEach(e=>{t[e]=this[e]});this._onSelectionChanged=J.bind(this)}}return e||t};U.prototype._createLegacySelectionPlugin=function(){return new A};U.prototype._onSelectionPluginChange=function(){let e=T.findOn(this);if(this.getPlugins().length>0){e=this.getPlugins()[0]}if(H(this).oSelectionPlugin!==e){H(this).oSelectionPlugin?.detachSelectionChange(this._updateSelection,this);e?.attachSelectionChange(this._updateSelection,this);H(this).oSelectionPlugin=e}};U.prototype._getDefaultContextMenu=function(){let e=this.getAggregation("_hiddenDependents").find(e=>e.isA("sap.ui.table.menus.ContextMenu"));if(!e){e=new v;this.addAggregation("_hiddenDependents",e)}return e};U.prototype.insertAggregation=function(e,t,i,n){if(e==="_hiddenDependents"){return o.prototype.insertAggregation.call(this,e,t,i,true)}return o.prototype.insertAggregation.apply(this,arguments)};U.prototype.addAggregation=function(e,t,i){if(e==="_hiddenDependents"){return o.prototype.addAggregation.call(this,e,t,true)}return o.prototype.addAggregation.apply(this,arguments)};U.prototype.removeAggregation=function(e,t,i){if(e==="_hiddenDependents"){return o.prototype.removeAggregation.call(this,e,t,true)}return o.prototype.removeAggregation.apply(this,arguments)};U.prototype.removeAllAggregation=function(e,t){if(e==="_hiddenDependents"){return o.prototype.removeAllAggregation.call(this,e,true)}return o.prototype.removeAllAggregation.apply(this,arguments)};U.prototype.destroyAggregation=function(e,t){if(e==="_hiddenDependents"){return o.prototype.destroyAggregation.call(this,e,true)}o.prototype.destroyAggregation.apply(this,arguments);if(e==="rows"){this._aRowClones.forEach(function(e){e.destroy()});this._aRowClones=[]}return this};U.prototype.getCellControl=function(e,t,o){const i=h.getRowColCell(this,e,t,!o);return i.cell};U.prototype._fireRowsUpdated=function(e){const t={reason:e||h.RowsUpdateReason.Unknown};this.onRowsUpdated(t);clearTimeout(this._mTimeouts.fireRowsUpdated);this._mTimeouts.fireRowsUpdated=setTimeout(function(){this.onRowsContentUpdated(t);this.fireEvent("_rowsUpdated",t);this.fireRowsUpdated()}.bind(this),0)};U.prototype.onRowsUpdated=function(e){h.Grouping.updateGroups(this);h.Menu.closeContentCellContextMenu(this);this._getAccExtension()._updateAriaRowIndices();this._updateSelection();K(this);this.getRows().forEach(function(e){e.getCells().forEach(function(t){const o=d.ofCell(t);const i=o._getCellContentVisibilitySettings();const n=e.getDomRefs(true).row.find('td[data-sap-ui-colid="'+o.getId()+'"]');let s=true;if(!n){return}if(e.isGroupHeader()){if(!e.isExpandable()){s=i.groupHeader.nonExpandable}else if(e.isExpanded()){s=i.groupHeader.expanded}else{s=i.groupHeader.collapsed}}else if(e.isTotalSummary()){s=i.summary.total}else if(e.isGroupSummary()){s=i.summary.group}else{s=i.standard}n.toggleClass("sapUiTableCellHidden",!s)})})};U.prototype.onRowsContentUpdated=function(e){if(this.getRows().length>0){this._resetRowHeights();this._aRowHeights=this._collectRowHeights(false);this._updateRowHeights(this._aRowHeights,false);this._getAccExtension().updateAccForCurrentCell(e.reason)}};U.prototype._enableSynchronization=function(){const e=this;return new Promise(function(t,o){sap.ui.require(["sap/ui/table/extensions/Synchronization"],function(o){t(g.enrich(e,o).getInterface())},function(e){o(e)})})};U.prototype._enableLegacyMultiSelection=function(){if(T.findOn(this)){throw new Error("Unsupported operation: sap.ui.table.Table#_enableLegacyMultiSelection must not be called"+" if a selection plugin is applied.")}this._legacyMultiSelection=function(e,t){if(T.findOn(this)){throw new Error("Unsupported operation: The legacy multi selection is not supported if a selection plugin is applied")}const o=!!(t.metaKey||t.ctrlKey);if(!this.isIndexSelected(e)){if(o){this.addSelectionInterval(e,e)}else{this.setSelectedIndex(e)}}else if(o||this.getSelectedIndices().length===1){this.removeSelectionInterval(e,e)}else{this.setSelectedIndex(e)}}.bind(this)};U.prototype._setRowCountConstraints=function(e){this.setProperty("rowCountConstraints",e)};function te(e,t){const o=e.getAggregation("_hiddenDependents")||[];return t.filter(e=>!o.includes(e))}U.prototype.findAggregatedObjects=function(){return te(this,o.prototype.findAggregatedObjects.apply(this,arguments))};U.prototype.findElements=function(){return te(this,o.prototype.findElements.apply(this,arguments))};U.prototype.getPlugin=function(e){if(!e||!e.startsWith("sap.ui.table.plugins.")){throw new Error("This method can only be used to get plugins of the sap.ui.table library")}let t=this.getDependents().find(t=>t.isA(e));if(!t){t=this.getPlugins().find(t=>t.isA(e))}return t};U.prototype._getScrollThreshold=function(){const e=this.getScrollThreshold();if(e===-1){return this.getThreshold()}return e};return U});
//# sourceMappingURL=Table.js.map