/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/Device","./library","./Column","./utils/TableUtils","./extensions/ExtensionBase","sap/ui/core/Renderer","sap/ui/core/library","sap/base/Log"],function(e,t,n,s,a,i,o,l){"use strict";const r=o.SortOrder;const d=s.Column;const c={Begin:"flex-start",End:"flex-end",Left:undefined,Right:undefined,Center:"center"};const p=s.Hook.Keys.TableRenderer;const b={apiVersion:2};b.render=function(t,n){delete n._iHeaderRowCount;c.Left=n._bRtlMode?"flex-end":"flex-start";c.Right=n._bRtlMode?"flex-start":"flex-end";t.openStart("div",n);t.class("sapUiTable");if(e.browser.chrome&&window.devicePixelRatio<1){t.class("sapUiTableZoomout")}if("ontouchstart"in document){t.class("sapUiTableTouch")}t.class("sapUiTableSelMode"+n.getSelectionMode());if(n.getColumnHeaderVisible()){t.class("sapUiTableCHdr")}if(s.hasRowHeader(n)){t.class("sapUiTableRowSelectors")}if(s.hasRowHighlights(n)){t.class("sapUiTableRowHighlights")}try{const e=s._getTableTemplateHelper(true).addTableClass();if(e){t.class(e)}}catch(e){}const a=n._getScrollExtension();if(a.isVerticalScrollbarRequired()&&!a.isVerticalScrollbarExternal()){t.class("sapUiTableVScr")}if(n.getEditable&&n.getEditable()){t.class("sapUiTableEdt")}if(s.hasRowActions(n)){const e=n.getRowActionCount();t.class(e===1?"sapUiTableRActS":"sapUiTableRAct")}else if(s.hasRowNavigationIndicators(n)){t.class("sapUiTableRowNavIndicator")}if(s.isNoDataVisible(n)&&!n._isWaitingForData()){t.class("sapUiTableEmpty")}if(n.getShowOverlay()){t.class("sapUiTableOverlay")}const i=s.Grouping.getModeCssClass(n);if(i){t.class(i)}t.style("width",n.getWidth());s.Hook.call(n,p.RenderTableStyles,t);if(n._bFirstRendering){t.class("sapUiTableNoOpacity")}t.openEnd();this.renderTabElement(t,"sapUiTableOuterBefore");t.openStart("div",n.getId()+"-before");t.class("sapUiTableBefore");t.openEnd();t.renderControl(n.getAggregation("_messageStrip"));if(n.getTitle()){this.renderHeader(t,n,n.getTitle())}if(n.getToolbar()){this.renderToolbar(t,n,n.getToolbar())}if(n.getExtension()&&n.getExtension().length>0){this.renderExtensions(t,n,n.getExtension())}t.close("div");t.openStart("div",n.getId()+"-sapUiTableCnt");t.class("sapUiTableCnt");t.attr("data-sap-ui-fastnavgroup","true");t.attr("data-sap-ui-pasteregion","true");t.openEnd();if(!n._getScrollExtension().isVerticalScrollbarExternal()){this.renderVSb(t,n)}const o=n.getRows().length||n.getColumnHeaderVisible();this.renderTabElement(t,"sapUiTableCtrlBefore",o?"0":"-1");t.openStart("div",n.getId()+"-sapUiTableGridCnt");n._getAccRenderExtension().writeAriaAttributesFor(t,n,"Content");t.openEnd();this.renderColRsz(t,n);this.renderColHdr(t,n);this.renderTable(t,n);t.close("div");this.renderTabElement(t,"sapUiTableCtrlAfter",o?"0":"-1");this.renderTabElement(t,null,"-1",n.getId()+"-focusDummy");const l=n.getCreationRow();if(l&&l.getVisible()){t.renderControl(l)}this.renderHSbBackground(t,n);this.renderHSb(t,n);n._getAccRenderExtension().writeHiddenAccTexts(t,n);t.openStart("div",n.getId()+"-overlay");t.class("sapUiTableOverlayArea");t.attr("tabindex","0");n._getAccRenderExtension().writeAriaAttributesFor(t,n,"Overlay");t.openEnd();t.close("div");t.close("div");t.openStart("div",n.getId()+"-after");t.openEnd();if(n.getFooter()){this.renderFooter(t,n,n.getFooter())}s.Hook.call(n,p.RenderInTableBottomArea,t);t.close("div");this.renderTabElement(t,"sapUiTableOuterAfter");t.close("div")};b.renderHeader=function(e,t,n){e.openStart("div");e.class("sapUiTableHdr");t._getAccRenderExtension().writeAriaAttributesFor(e,t,"TableHeader");e.openEnd();e.renderControl(n);e.close("div")};b.renderToolbar=function(e,t,n){if(!s.isA(n,"sap.ui.core.Toolbar")){return}e.openStart("div");e.class("sapUiTableTbr");if(typeof n.getStandalone==="function"&&n.getStandalone()){n.setStandalone(false)}if(n.isA("sap.m.Toolbar")){n.setDesign("Transparent",true);n.addStyleClass("sapMTBHeader-CTX");e.class("sapUiTableMTbr")}t._getAccRenderExtension().writeAriaAttributesFor(e,t,"TableSubHeader");e.openEnd();e.renderControl(n);e.close("div")};b.renderExtensions=function(e,t,n){for(let s=0,a=n.length;s<a;s++){this.renderExtension(e,t,n[s])}};b.renderExtension=function(e,t,n){e.openStart("div");e.class("sapUiTableExt");t._getAccRenderExtension().writeAriaAttributesFor(e,t,"TableSubHeader");e.openEnd();e.renderControl(n);e.close("div")};b.renderTable=function(e,t){e.openStart("div",t.getId()+"-tableCCnt");s.Hook.call(t,p.RenderRowContainerStyles,e);e.class("sapUiTableCCnt");e.openEnd();this.renderTableCCnt(e,t);e.close("div")};b.renderTableCCnt=function(e,t){this.renderTableCtrl(e,t);this.renderRowHdr(e,t);this.renderRowActions(e,t);e.openStart("div",t.getId()+"-noDataCnt");e.class("sapUiTableCtrlEmpty");e.attr("tabindex","0");t._getAccRenderExtension().writeAriaAttributesFor(e,t,"NoData");e.openEnd();const n=s.getNoContentMessage(t);if(s.isA(n,"sap.ui.core.Control")){e.renderControl(n)}else{e.openStart("span",t.getId()+"-noDataMsg");e.class("sapUiTableCtrlEmptyMsg");e.openEnd();e.text(n);e.close("span")}e.close("div")};b.renderFooter=function(e,t,n){e.openStart("div");e.class("sapUiTableFtr");t._getAccRenderExtension().writeAriaAttributesFor(e,t,"TableFooter");e.openEnd();e.renderControl(n);e.close("div")};b.renderColHdr=function(e,t){const n=s.getHeaderRowCount(t);const a=t.getColumns();const i=t.getComputedFixedColumnCount();e.openStart("div",t.getId()+"-sapUiTableColHdrCnt");e.class("sapUiTableColHdrCnt");e.openEnd();this.renderColRowHdr(e,t);if(i>0){e.openStart("div");e.class("sapUiTableCHA");e.class("sapUiTableCtrlScrFixed");e.class("sapUiTableNoOpacity");e.openEnd();this.renderTableControlCnt(e,t,true,0,i,true,false,0,n,true);e.close("div")}e.openStart("div",t.getId()+"-sapUiTableColHdrScr");e.class("sapUiTableCHA");e.class("sapUiTableCtrlScr");if(a.length===0){e.class("sapUiTableHasNoColumns")}if(i>0){if(t._bRtlMode){e.style("margin-right","0")}else{e.style("margin-left","0")}}e.openEnd();this.renderTableControlCnt(e,t,false,i,a.length,false,false,0,n,true);e.close("div");if(s.hasRowActions(t)){e.openStart("div",t.getId()+"-rowacthdr");t._getAccRenderExtension().writeAriaAttributesFor(e,t,"RowActionHeader");e.class("sapUiTableCell");e.class("sapUiTableHeaderCell");e.class("sapUiTableRowActionHeaderCell");e.attr("tabindex","-1");e.openEnd();e.openStart("span");e.openEnd();e.text(s.getResourceText("TBL_ROW_ACTION_COLUMN_LABEL"));e.close("span");e.close("div")}e.openStart("div");e.class("sapUiTableVSbHeader");e.openEnd();e.close("div");e.close("div")};b.renderColRowHdr=function(e,n){let a=false;let i=false;const o=n._getSelectionPlugin().getRenderConfig();e.openStart("div");n._getAccRenderExtension().writeAriaAttributesFor(e,n,"ColumnRowHeaderRow");e.openEnd();e.openStart("div",n.getId()+"-rowcolhdr");n._getAccRenderExtension().writeAriaAttributesFor(e,n,"ColumnRowHeaderCell");e.openEnd();e.openStart("div",n.getId()+"-selall");e.class("sapUiTableCell");e.class("sapUiTableHeaderCell");e.class("sapUiTableRowSelectionHeaderCell");if(o.headerSelector.visible){const t=o.headerSelector.selected;if(o.headerSelector.type==="toggle"){e.attr("title",s.getResourceText("TBL_SELECT_ALL"))}else if(o.headerSelector.type==="custom"){const t=o.headerSelector.tooltip;e.attr("title",t);if(!o.headerSelector.enabled){e.class("sapUiTableSelAllDisabled");e.attr("aria-disabled","true")}}if(!t){e.class("sapUiTableSelAll")}else{i=true}e.class("sapUiTableSelAllVisible");a=true}e.attr("tabindex","-1");const l={enabled:a,checked:i};n._getAccRenderExtension().writeAriaAttributesFor(e,n,"ColumnRowHeader",l);e.openEnd();if(o.headerSelector.visible){if(o.headerSelector.type==="custom"&&o.headerSelector.icon){e.renderControl(o.headerSelector.icon)}else{e.openStart("div");e.class("sapUiTableSelectAllCheckBox");e.openEnd();e.close("div")}}if(s.hasRowHeader(n)&&n.getSelectionMode()===t.SelectionMode.None){e.openStart("span",n.getId()+"-rowselecthdr");e.class("sapUiPseudoInvisibleText");e.openEnd();e.text(s.getResourceText("TBL_ROW_SELECTION_COLUMN_LABEL"));e.close("span")}e.close("div").close("div").close("div")};b.renderCol=function(e,t,n,a,o,d,p,b,g){let u;const f=!o;const C=n.getIndex();const T=n.getMultiLabels();if(T.length>0){u=T[a]}else if(a===0){u=n.getLabel()}let h=n.getId();if(a===0){e.openStart("td",n)}else{h=h+"_"+a;e.openStart("td",h)}e.attr("data-sap-ui-related",n.getId());e.attr("data-sap-ui-colid",n.getId());e.attr("data-sap-ui-colindex",C);e.attr("tabindex","-1");const S={column:n,headerId:h,index:C};if(o>1){e.attr("colspan",o);S.colspan=true}if(g){const t=n.getFiltered();let s=n.getSortOrder()!==r.None;if(!n.getSorted()){s=false}if(t){e.class("sapUiTableColFiltered")}if(s){e.class("sapUiTableColSorted");if(n.getSortOrder()===r.Descending){e.class("sapUiTableColSortedD")}}}t._getAccRenderExtension().writeAriaAttributesFor(e,t,"ColumnHeader",S);e.class("sapUiTableCell");e.class("sapUiTableHeaderCell");e.class("sapUiTableHeaderDataCell");const R=n.getHeaderMenuInstance();if(t.getEnableColumnReordering()||R&&R.getAriaHasPopupType()!=="None"){e.class("sapUiTableHeaderCellActive")}if(!t.getEnableColumnReordering()&&!t.hasListeners("columnSelect")&&!R&&n._menuHasItems()){e.class("sapUiTableHeaderCellActive")}if(d){e.class("sapUiTableCellFirst")}if(p){e.class("sapUiTableCellLastFixed")}if(b){e.class("sapUiTableCellLast")}if(f){e.class("sapUiTableHidden")}if(t.getColumnHeaderHeight()>0){e.style("height",t.getColumnHeaderHeight()+"px")}const w=n.getTooltip_AsString();if(w){e.attr("title",w)}e.openEnd();e.openStart("div",h+"-inner");e.class("sapUiTableCellInner");if(!s.hasRowHeader(t)&&d&&!s.hasRowHighlights(t)&&!s.Grouping.isInTreeMode(t)){e.class("sapUiTableFirstColumnCell")}const x=n.getHAlign();const A=i.getTextAlign(x);if(A){e.style("text-align",A)}e.openEnd();e.openStart("div");e.style("justify-content",c[x]);e.openEnd();const U=n.getAggregation("_action");if(U&&a===0){if(n.getMultiLabels().length>0){l.error(`${n}: ColumnAIAction is not compatible with multi labels`)}else{e.renderControl(U)}}e.renderControl(u);e.close("div");e.close("div");e.close("td")};b.renderColRsz=function(e,t){e.openStart("div",t.getId()+"-rsz");e.class("sapUiTableColRsz");e.openEnd();e.close("div")};b.renderRowHdr=function(e,t){e.openStart("div",t.getId()+"-sapUiTableRowHdrScr");t._getAccRenderExtension().writeAriaAttributesFor(e,t,"Presentation");e.class("sapUiTableRowHdrScr");e.class("sapUiTableNoOpacity");t._getAccRenderExtension().writeAriaAttributesFor(e,t,"RowHeaderCol");e.openEnd();for(let n=0,s=t.getRows().length;n<s;n++){this.renderRowAddon(e,t,t.getRows()[n],n,true)}e.close("div")};b.renderRowActions=function(e,t){if(!s.hasRowActions(t)&&!s.hasRowNavigationIndicators(t)){return}e.openStart("div",t.getId()+"-sapUiTableRowActionScr");t._getAccRenderExtension().writeAriaAttributesFor(e,t,"Presentation");s.hasRowActions(t)?e.class("sapUiTableRowWithAction"):e.class("sapUiTableRowActionScr");e.class("sapUiTableNoOpacity");e.openEnd();for(let n=0,s=t.getRows().length;n<s;n++){this.renderRowAddon(e,t,t.getRows()[n],n,false)}e.close("div")};b.addRowCSSClasses=function(e,t,n){const a=t._getRowCounts();const i=s.getFirstFixedBottomRowIndex(t);if(n===0){e.class("sapUiTableFirstRow")}else if(n===t.getRows().length-1){e.class("sapUiTableLastRow")}if(a.fixedTop>0){if(n===a.fixedTop-1){e.class("sapUiTableRowLastFixedTop")}if(n===a.fixedTop){e.class("sapUiTableRowFirstScrollable")}}if(i>=0&&i===n){e.class("sapUiTableRowFirstFixedBottom")}else if(i>=1&&i-1===n){e.class("sapUiTableRowLastScrollable")}};b.renderRowAddon=function(e,t,n,a,i){const o=n._isSelected();e.openStart("div");t._getAccRenderExtension().writeAriaAttributesFor(e,t,"RowAddon");e.attr("data-sap-ui-related",n.getId());e.attr("data-sap-ui-rowindex",a);e.class("sapUiTableRow");e.class("sapUiTableContentRow");if(n.isContentHidden()){e.class("sapUiTableRowHidden")}else if(o){e.class("sapUiTableRowSel")}if(a%2!==0&&t.getAlternateRowColors()&&!s.Grouping.isInTreeMode(t)){e.class("sapUiTableRowAlternate")}this.addRowCSSClasses(e,t,a);e.openEnd();e.openStart("div",t.getId()+(i?"-rowsel":"-rowact")+a);e.class("sapUiTableCell");e.class("sapUiTableContentCell");e.class(i?"sapUiTableRowSelectionCell":"sapUiTableRowActionCell");s.Hook.call(t,p.RenderRowStyles,e);e.attr("tabindex","-1");const l={rowSelected:o,rowHidden:n.isEmpty()};t._getAccRenderExtension().writeAriaAttributesFor(e,t,i?"RowHeader":"RowAction",l);e.openEnd();if(i){this.writeRowHighlightContent(e,t,n,a);this.writeRowSelectorContent(e,t,n)}else{const s=n.getRowAction();if(s){e.renderControl(s)}this.writeRowNavigationContent(e,t,n,a)}e.close("div");e.close("div")};b.renderTableCtrl=function(e,t){if(t.getComputedFixedColumnCount()>0){e.openStart("div",t.getId()+"-sapUiTableCtrlScrFixed");e.class("sapUiTableCtrlScrFixed");e.openEnd();this.renderTableControl(e,t,true);e.close("div")}e.openStart("div",t.getId()+"-sapUiTableCtrlScr");e.class("sapUiTableCtrlScr");if(t.getComputedFixedColumnCount()>0){if(t._bRtlMode){e.style("margin-right","0")}else{e.style("margin-left","0")}}e.openEnd();e.openStart("div",t.getId()+"-tableCtrlCnt");e.class("sapUiTableCtrlCnt");e.openEnd();this.renderTableControl(e,t,false);e.close("div");e.close("div")};b.renderTableControl=function(e,t,n){let s;let a;if(n){s=0;a=t.getComputedFixedColumnCount()}else{s=t.getComputedFixedColumnCount();a=t.getColumns().length}const i=t._getRowCounts();const o=t.getRows();if(i.fixedTop>0){this.renderTableControlCnt(e,t,n,s,a,true,false,0,i.fixedTop)}this.renderTableControlCnt(e,t,n,s,a,false,false,i.fixedTop,o.length-i.fixedBottom);if(i.fixedBottom>0&&o.length>0){this.renderTableControlCnt(e,t,n,s,a,false,true,o.length-i.fixedBottom,o.length)}};b.renderTableControlCnt=function(e,t,n,a,i,o,l,r,d,c){let p=c?"-header":"-table";let b=t.getId()+p;const g=[];if(n){b+="-fixed";g.push("sapUiTableCtrlFixed")}else{g.push("sapUiTableCtrlScroll")}if(o){b+="-fixrow";g.push("sapUiTableCtrlRowFixed")}else if(l){b+="-fixrow-bottom";g.push("sapUiTableCtrlRowFixedBottom")}else{g.push("sapUiTableCtrlRowScroll")}e.openStart("table",b);g.forEach(function(t){e.class(t)});t._getAccRenderExtension().writeAriaAttributesFor(e,t,c?"Presentation":"Table");e.class("sapUiTableCtrl");if(c){e.class("sapUiTableCHT")}e.style(n?"width":"min-width",t._getColumnsWidth(a,i)+"px");e.openEnd();e.openStart("thead").openEnd();e.openStart("tr");e.class("sapUiTableCtrlCol");if(r===0){e.class("sapUiTableCtrlFirstCol")}if(c){e.class("sapUiTableCHTHR")}e.openEnd();const u=t.getColumns();const f=new Array(i);let C;let T;let h=!n&&i>a;const S=t._getVisibleColumns();for(C=a;C<i;C++){T=u[C];const e={shouldRender:!!(T&&T.shouldRender())};if(e.shouldRender){let t=T.getWidth();if(s.isVariableWidth(t)){h=false;if(n){T._iFixWidth=T._iFixWidth||160;t=T._iFixWidth+"px"}}else if(n){delete T._iFixWidth}e.width=t}f[C]=e}if(u.length===0){e.openStart("th").openEnd().close("th")}for(C=a;C<i;C++){p=c?"_hdr":"_col";T=u[C];const n=f[C];if(n.shouldRender){if(r===0){e.openStart("th",t.getId()+p+C);t._getAccRenderExtension().writeAriaAttributesFor(e,t,"Th",{column:T})}else{e.openStart("th")}e.style("width",n.width);e.attr("data-sap-ui-headcolindex",C);e.attr("data-sap-ui-colid",T.getId());if(T===S[0]){e.class("sapUiTableFirstVisibleColumnTH")}e.openEnd();if(r===0&&s.getHeaderRowCount(t)===0&&!c){if(T.getMultiLabels().length>0){e.renderControl(T.getMultiLabels()[0])}else{e.renderControl(T.getLabel())}}e.close("th")}}if(h){e.openStart("th",c&&t.getId()+"-dummycolhdr");t._getAccRenderExtension().writeAriaAttributesFor(e,t,"Presentation");e.openEnd().close("th")}e.close("tr");e.close("thead");e.openStart("tbody").openEnd();const R=t.getRows();let w;let x;if(c){for(w=r,x=d;w<x;w++){this.renderColumnHeaderRow(e,t,w,n,a,i,h,w===x-1)}}else{const o=s.isRowSelectionAllowed(t);const l=t.getDragDropConfig().some(function(e){return e.getMetadata().isInstanceOf("sap.ui.core.dnd.IDragInfo")&&e.getSourceAggregation()==="rows"});const c=this.getLastFixedColumnIndex(t);for(w=r,x=d;w<x;w++){this.renderTableRow(e,t,R[w],w,n,a,i,false,S,c,h,o,l)}}e.close("tbody");e.close("table")};b.writeRowSelectorContent=function(e,t,n){t._getAccRenderExtension().writeAccRowSelectorText(e,t,n);if(s.Grouping.isInGroupMode(t)){e.openStart("div");e.class("sapUiTableGroupShield");e.openEnd();e.close("div");e.openStart("div",n.getId()+"-groupHeader");e.class("sapUiTableGroupIcon");e.openEnd();e.close("div")}};b.writeRowHighlightContent=function(e,t,n,a){if(!s.hasRowHighlights(t)){return}const i=n.getAggregation("_settings");const o=i._getHighlightCSSClassName();e.openStart("div",n.getId()+"-highlight");e.class("sapUiTableRowHighlight");e.class(o);e.openEnd();t._getAccRenderExtension().writeAccRowHighlightText(e,t,n,a);e.close("div")};b.writeRowNavigationContent=function(e,t,n,a){if(!s.hasRowNavigationIndicators(t)){return}const i=n.getAggregation("_settings");e.openStart("div",n.getId()+"-navIndicator");if(i.getNavigated()){e.class("sapUiTableRowNavigated")}e.openEnd();e.close("div")};b.renderColumnHeaderRow=function(e,t,n,s,a,i,o,l){e.openStart("tr");e.class("sapUiTableRow");e.class("sapUiTableHeaderRow");e.class("sapUiTableColHdrTr");t._getAccRenderExtension().writeAriaAttributesFor(e,t,"ColumnHeaderRow",{rowIndex:n});e.openEnd();const r=this.getColumnsToRender(t,a,i);let c=0;let p=-1;function b(e,t,s){let a=d.getHeaderSpan(e,n);let i;if(c<1){if(a>1){i=e.getIndex();a=s.slice(t+1,t+a).reduce(function(e,t){return t.getIndex()-i<a?e+1:e},1)}e._nSpan=c=a;p=t}else{e._nSpan=0}c--}r.forEach(b);function g(a,i){this.renderCol(e,t,a,n,a._nSpan,i===0,s&&i===p,!s&&i===p,a._nSpan===1&&!a._bIconsRendered);a._bIconsRendered=a._bIconsRendered||a._nSpan===1;delete a._nSpan;if(l){delete a._bIconsRendered}}r.forEach(g.bind(this));if(!s&&o&&r.length>0){e.openStart("td").class("sapUiTableCellDummy");t._getAccRenderExtension().writeAriaAttributesFor(e,t,"Presentation");e.openEnd().close("td")}e.close("tr")};b.renderTableRow=function(e,t,n,a,i,o,l,r,d,c,b,g,u){if(!n){return}if(i){e.openStart("tr",n.getId()+"-fixed");e.attr("data-sap-ui-related",n.getId())}else{e.openStart("tr",n)}if(n._bDummyRow){e.style("opacity","0")}e.class("sapUiTableRow");e.class("sapUiTableContentRow");e.class("sapUiTableTr");if(u&&i){e.attr("draggable","true");e.attr("data-sap-ui-draggable","true")}if(n.isContentHidden()){e.class("sapUiTableRowHidden")}else if(n._isSelected()){e.class("sapUiTableRowSel")}if(a%2!==0&&t.getAlternateRowColors()&&!s.Grouping.isInTreeMode(t)){e.class("sapUiTableRowAlternate")}this.addRowCSSClasses(e,t,a);e.attr("data-sap-ui-rowindex",a);s.Hook.call(t,p.RenderRowStyles,e);const f=n.getAggregation("_settings");const C={index:a,fixedCol:i,rowNavigated:f?f.getNavigated():false};t._getAccRenderExtension().writeAriaAttributesFor(e,t,"Tr",C);e.openEnd();const T=!n.isEmpty()&&n._isSelected();const h=n.getCells();for(let s=0,a=h.length;s<a;s++){this.renderTableCell(e,t,n,h[s],s,i,o,l,d,c,T)}if(!i&&b&&h.length>0){e.openStart("td").class("sapUiTableCellDummy");t._getAccRenderExtension().writeAriaAttributesFor(e,t,"Presentation");e.openEnd();e.close("td")}e.close("tr")};b.renderTableCell=function(e,t,a,o,l,r,d,c,b,g,u){const f=n.ofCell(o);const C=f.getIndex();if(f.shouldRender()&&d<=C&&c>C){const n=a.getId()+"-col"+l;e.openStart("td",n);e.attr("tabindex","-1");e.attr("data-sap-ui-colid",f.getId());const d=b.length;const c=d>0&&b[0]===f;const T=d>0&&b[d-1]===f;const h=r&&g===C;const S={index:C,column:f,row:a,fixed:r,rowSelected:u};t._getAccRenderExtension().writeAriaAttributesFor(e,t,"DataCell",S);const R=i.getTextAlign(f.getHAlign());if(R){e.style("text-align",R)}e.class("sapUiTableCell");e.class("sapUiTableContentCell");e.class("sapUiTableDataCell");if(c){e.class("sapUiTableCellFirst")}if(h){e.class("sapUiTableCellLastFixed")}if(T){e.class("sapUiTableCellLast")}if(c&&s.Grouping.isInTreeMode(t)){e.class("sapUiTableCellFlex")}e.openEnd();e.openStart("div");e.class("sapUiTableCellInner");if(!s.hasRowHeader(t)&&c&&!s.hasRowHighlights(t)&&!s.Grouping.isInTreeMode(t)){e.class("sapUiTableFirstColumnCell")}s.Hook.call(t,p.RenderCellContentStyles,e);e.openEnd();this.renderTableCellControl(e,t,o,c);e.close("div");e.close("td")}};b.renderTableCellControl=function(e,t,n,a){if(a&&s.Grouping.isInTreeMode(t)){const s=n.getParent();e.openStart("span",s.getId()+"-treeicon");e.class("sapUiTableTreeIcon");e.attr("tabindex","0");t._getAccRenderExtension().writeAriaAttributesFor(e,t,"TreeIcon",{row:s});e.openEnd();e.close("span")}e.renderControl(n)};b.renderVSb=function(e,t,n){const s=t._getScrollExtension();n=Object.assign({tabIndex:true},n);e.openStart("div");e.class("sapUiTableVSbContainer");if(!s.isVerticalScrollbarRequired()){e.class("sapUiTableHidden")}e.class(n.cssClass);e.openEnd();e.openStart("div",t.getId()+"-vsb");e.class("sapUiTableVSb");e.style("max-height",s.getVerticalScrollbarHeight()+"px");if(n.tabIndex){e.attr("tabindex","-1")}e.openEnd();e.openStart("div");e.class("sapUiTableVSbContent");e.style("height",s.getVerticalScrollHeight()+"px");e.openEnd();e.close("div");e.close("div");e.close("div")};b.renderVSbExternal=function(e,t){if(a.isEnrichedWith(t,"sap.ui.table.extensions.Synchronization")){this.renderVSb(e,t,{cssClass:"sapUiTableVSbExternal",tabIndex:false})}else{l.error("This method can only be used with synchronization enabled.",t,"TableRenderer.renderVSbExternal")}};b.renderHSb=function(e,t,n){n=Object.assign({id:t.getId()+"-hsb",cssClass:"sapUiTableHSb",tabIndex:true,hidden:true,scrollWidth:0},n);e.openStart("div",n.id);e.class(n.cssClass);if(n.hidden){e.class("sapUiTableHidden")}if(n.tabIndex){e.attr("tabindex","-1")}e.openEnd();e.openStart("div",n.id+"-content");e.class("sapUiTableHSbContent");if(n.scrollWidth>0){e.style("width",n.scrollWidth+"px")}e.openEnd();e.close("div");e.close("div")};b.renderHSbExternal=function(e,t,n,s){if(a.isEnrichedWith(t,"sap.ui.table.extensions.Synchronization")){this.renderHSb(e,t,{id:n,cssClass:"sapUiTableHSbExternal",tabIndex:false,hidden:false,scrollWidth:s})}else{l.error("This method can only be used with synchronization enabled.",t,"TableRenderer.renderVSbExternal")}};b.renderHSbBackground=function(e,t){e.openStart("div",t.getId()+"-hsb-bg");e.class("sapUiTableHSbBg");e.openEnd().close("div")};b.renderTabElement=function(e,t,n,s){e.openStart("div");if(t){e.class(t)}if(s){e.attr("id",s)}e.attr("role","none");e.attr("tabindex",n==null?"0":n);e.openEnd().close("div")};b.getColumnsToRender=function(e,t,n){return e.getColumns().slice(t,n).filter(function(e){return e&&e.shouldRender()})};b.getLastFixedColumnIndex=function(e){const t=e.getComputedFixedColumnCount();const n=e.getColumns();let s;let a;for(let e=t-1;e>=0;e--){s=n[e];if(s.shouldRender()){a=e;break}}return a};return b},true);
//# sourceMappingURL=TableRenderer.js.map