/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["./Table","./TableRenderer","sap/ui/model/ClientTreeBindingAdapter","sap/ui/model/TreeBindingCompatibilityAdapter","./library","./utils/TableUtils","./plugins/BindingSelection","sap/base/Log","sap/base/assert","sap/ui/model/controlhelper/TreeBindingProxy"],function(e,t,o,n,i,r,s,p,a,l){"use strict";const u=r.createWeakMapFacade();const d=e.extend("sap.ui.table.TreeTable",{metadata:{library:"sap.ui.table",properties:{expandFirstLevel:{type:"boolean",defaultValue:false,deprecated:true},useGroupMode:{type:"boolean",group:"Appearance",defaultValue:false},groupHeaderProperty:{type:"string",group:"Data",defaultValue:null},collapseRecursive:{type:"boolean",defaultValue:true,deprecated:true},rootLevel:{type:"int",group:"Data",defaultValue:0,deprecated:true}},events:{toggleOpenState:{parameters:{rowIndex:{type:"int"},rowContext:{type:"object"},expanded:{type:"boolean"}}}}},renderer:t});d.prototype.init=function(){e.prototype.init.apply(this,arguments);u(this).bPendingRequest=false;r.Grouping.setToDefaultTreeMode(this);r.Hook.register(this,r.Hook.Keys.Row.UpdateState,y,this);r.Hook.register(this,r.Hook.Keys.Row.Expand,c,this);r.Hook.register(this,r.Hook.Keys.Row.Collapse,g,this);this._oProxy=new l(this,"rows")};d.prototype._bindRows=function(t){u(this).bPendingRequest=false;const o=this.getExpandFirstLevel()?1:0;this._oProxy.applyLegacySettingsToBindingInfo(t,{rootLevel:this.isPropertyInitial("rootLevel")?undefined:this.getRootLevel(),collapseResursive:this.isPropertyInitial("collapseRecursive")?undefined:this.getCollapseRecursive(),numberOfExpandedLevels:this.isPropertyInitial("expandFirstLevel")?undefined:o});return e.prototype._bindRows.call(this,t)};function y(e){const t=e.context["_mProxyInfo"];e.level=t.level;e.expandable=!t.isLeaf;e.expanded=t.isExpanded;if(r.Grouping.isInGroupMode(this)){const t=this.getGroupHeaderProperty();if(t){e.title=e.context.getProperty(t)}if(e.expandable){e.type=e.Type.GroupHeader;e.contentHidden=true}}}function c(e){const t=e.getIndex();this._oProxy.expand(t);const o=this._oProxy.isExpanded(t);if(typeof o==="boolean"){this._onGroupHeaderChanged(t,o)}}function g(e){const t=e.getIndex();this._oProxy.collapse(t);const o=this._oProxy.isExpanded(t);if(typeof o==="boolean"){this._onGroupHeaderChanged(t,o)}}d.prototype.setFixedRowCount=function(e){p.warning('TreeTable: the property "fixedRowCount" is not supported and will be ignored!');return this};d.prototype.isTreeBinding=function(t){t=t||"rows";if(t==="rows"){return this._oProxy.isTreeBinding()}return e.prototype.isTreeBinding.apply(this,arguments)};d.prototype.getBinding=function(t){t=t==null?"rows":t;const i=e.prototype.getBinding.call(this,t);if(i&&t==="rows"&&!i.getLength){if(i.isA("sap.ui.model.odata.ODataTreeBinding")){n(i,this)}else if(i.isA("sap.ui.model.odata.v2.ODataTreeBinding")){i.applyAdapterInterface()}else if(i.isA("sap.ui.model.ClientTreeBinding")){o.apply(i)}else{p.error("Binding not supported by sap.ui.table.TreeTable")}}return i};d.prototype._getContexts=function(e,t,o,n){if(!this.getVisible()){return[]}return this._oProxy.getContexts(e,t,o,n)};d.prototype._getRowContexts=function(e){return h(this,e)};function h(t,o,n){const i=t._getTotalRowCount();let r=e.prototype._getRowContexts.call(t,o);if(n===true){return r}const s=t._getTotalRowCount();const p=t._getFirstRenderedRowIndex();const a=t._getMaxFirstRenderedRowIndex();t._adjustToTotalRowCount();if(a<p&&t._bContextsAvailable){r=h(t,o,true)}else if(i!==s){r=h(t,o,true)}return r}d.prototype._onGroupHeaderChanged=function(e,t){this.fireToggleOpenState({rowIndex:e,rowContext:this.getContextByIndex(e),expanded:t})};d.prototype.expand=function(e){this._oProxy.expand(e);return this};d.prototype.collapse=function(e){this._oProxy.collapse(e);return this};d.prototype.collapseAll=function(){this._oProxy.collapseAll();if(this.getBinding()){this.setFirstVisibleRow(0)}return this};d.prototype.expandToLevel=function(e){this._oProxy.expandToLevel(e);return this};d.prototype.isExpanded=function(e){return this._oProxy.isExpanded(e)};d.prototype.getContextByIndex=function(e){return this._oProxy.getContextByIndex(e)};d.prototype.setRootLevel=function(e){this.setFirstVisibleRow(0);this._oProxy.setRootLevel(e);this.setProperty("rootLevel",e,true);return this};d.prototype.setCollapseRecursive=function(e){this._oProxy.setCollapseRecursive(e);this.setProperty("collapseRecursive",!!e,true);return this};d.prototype.setUseGroupMode=function(e){this.setProperty("useGroupMode",!!e);f(this);return this};d.prototype.setEnableGrouping=function(){p.warning("The property enableGrouping is not supported by the sap.ui.table.TreeTable control");return this};d.prototype.setGroupBy=function(){p.warning("The groupBy association is not supported by the sap.ui.table.TreeTable control");return this};d.prototype.setUseFlatMode=function(e){this._bFlatMode=!!e;f(this);return this};function f(e){if(e.getUseGroupMode()){r.Grouping.setHierarchyMode(e,r.Grouping.HierarchyMode.GroupedTree)}else if(e._bFlatMode){r.Grouping.setToDefaultFlatMode(e)}else if(!e._bFlatMode){r.Grouping.setToDefaultTreeMode(e)}}d.prototype._createLegacySelectionPlugin=function(){return new s};d.prototype._onBindingDataRequested=function(t){u(this).bPendingRequest=true;e.prototype._onBindingDataRequested.apply(this,arguments)};d.prototype._onBindingDataReceived=function(t){u(this).bPendingRequest=false;e.prototype._onBindingDataReceived.apply(this,arguments)};d.prototype._isWaitingForData=function(){return u(this).bPendingRequest&&e.prototype._isWaitingForData.apply(this)};return d});
//# sourceMappingURL=TreeTable.js.map