/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["./ExtensionBase","./AccessibilityRender","../utils/TableUtils","../library","sap/ui/core/ControlBehavior","sap/ui/core/Element","sap/ui/thirdparty/jquery"],function(e,t,o,i,n,a,jQuery){"use strict";const r=i.SelectionMode;const l=o.CELLTYPE;const s={getAccInfoOfControl:function(e){let t=null;if(e&&typeof e.getAccessibilityInfo==="function"){if(typeof e.getVisible==="function"&&!e.getVisible()){t=s._normalize({})}else{const o=e.getAccessibilityInfo();if(o){const e={};s._flatten(o,e);t=e}}if(t&&!t.description){t.description=o.getResourceText("TBL_CTRL_STATE_EMPTY")}}return t},_normalize:function(e){if(!e){return null}if(e._normalized){return e}e.role=e.role||"";e.type=e.type||"";e.description=e.description||"";e.enabled=e.enabled===true||e.enabled===false?e.enabled:null;e.editable=e.editable===true||e.editable===false?e.editable:null;e.children=e.children||[];e._normalized=true;return e},_flatten:function(e,t,o){o=o?o:0;s._normalize(e);if(o===0){s._normalize(t);t._descriptions=[]}t._descriptions.push(s._getFullDescription(e));e.children.forEach(function(e){if(!e.getAccessibilityInfo||e.getVisible&&!e.getVisible()){return}const i=e.getAccessibilityInfo();if(i){s._flatten(i,t,o+1)}});if(o===0){t.description=t._descriptions.join(" ").trim();t._descriptions=undefined}},_getFullDescription:function(e){let t=e.type+" "+e.description;if(e.enabled===false){t=t+" "+o.getResourceText("TBL_CTRL_STATE_DISABLED")}else if(e.editable===false){t=t+" "+o.getResourceText("TBL_CTRL_STATE_READONLY")}else if(e.required===true){t=t+" "+o.getResourceText("TBL_CTRL_STATE_REQUIRED")}return t.trim()}};const c=function(e,t,i,n){const a=i&&e.getShowOverlay()||n&&o.isNoDataVisible(e);if(a){t["aria-hidden"]="true"}let r="";if(i){r="overlay"}if(n){r=i?r.concat(",","nodata"):"nodata"}if(r){t["data-sap-ui-table-acc-covered"]=r}};const u={getColumnIndexOfFocusedCell:function(e){const t=e.getTable();const i=o.getFocusedItemInfo(t);return i.cellInRow-(o.hasRowHeader(t)?1:0)},getInfoOfFocusedCell:function(e){const t=e.getTable();const i=t._getItemNavigation();const n=t.getDomRef();if(!e.getAccMode()||!n||!i){return null}const a=i.getFocusedDomRef();if(!a||a!==document.activeElement){return null}return o.getCellInfo(a)},getRelevantColumnHeaders:function(e,t){const i=[];if(!e||!t||!e.getColumnHeaderVisible()){return i}const n=o.getHeaderRowCount(e);if(n>0){const a=t.getId();i.push(a);for(let e=1;e<n;e++){i.push(a+"_"+e)}const r=o.Column.getParentSpannedColumns(e,a);if(r&&r.length){for(let e=0;e<r.length;e++){const t=r[e].level;const o=r[e].column.getId();i[t]=t===0?o:o+"_"+t}}}return i},isHiddenCell:function(e,t){const i=o.Grouping.isInGroupHeaderRow(e);const n=o.Grouping.isInSummaryRow(e);const a=!!t&&!!t.hasStyleClass;const r=e.parent().hasClass("sapUiTableRowHidden");const l=e.hasClass("sapUiTableCellHidden");const s=i&&a&&t.hasStyleClass("sapUiAnalyticalTableGroupCellHidden");const c=n&&a&&t.hasStyleClass("sapUiAnalyticalTableSumCellHidden");return r||l||s||c},isTreeColumnCell:function(e,t){return o.Grouping.isInTreeMode(e.getTable())&&t.hasClass("sapUiTableCellFirst")},getColumnTooltip:function(e){if(!e){return null}const t=e.getLabel();function i(e){if(!e){return false}const o=t&&t.getText?t.getText():"";return e===o}let n=e.getTooltip_AsString();if(!i(n)){return n}if(o.isA(t,"sap.ui.core.Control")){n=t.getTooltip_AsString()}if(!i(n)){return n}return null},getGridSize:function(e){const t=o.hasRowHeader(e);const i=o.hasRowActions(e);const n=o.getVisibleColumnCount(e)+(t?1:0)+(i?1:0);const a=o.isNoDataVisible(e)?0:Math.max(e._getTotalRowCount(),e._getRowCounts()._fullsize);return{columnCount:n,rowCount:o.getHeaderRowCount(e)+a}},getRowIndex:function(e){return e.getIndex()+1+o.getHeaderRowCount(e.getTable())},getRowColChange:function(e){const t=e.getTable();const i=t._getItemNavigation();let n=false;let a=false;let r=false;const l=o.hasRowHeader(t);if(i){const i=u.getColumnIndexOfFocusedCell(e)+1+(l?1:0);const s=t.getRows()[o.getRowIndexOfFocusedCell(t)];const c=s?u.getRowIndex(s):0;n=e._iLastRowNumber!==c||e._iLastRowNumber===c&&e._iLastColumnNumber===i;a=e._iLastColumnNumber!==i;r=e._iLastRowNumber==null&&e._iLastColumnNumber==null;e._iLastRowNumber=c;e._iLastColumnNumber=i}return{rowChange:n,colChange:a,initial:r}},cleanupCellModifications:function(e){if(e._cleanupInfo){e._cleanupInfo.cell.attr(e._cleanupInfo.attr);e._cleanupInfo=null}},storeDefaultsBeforeCellModifications:function(e,t,o,i){e._cleanupInfo={cell:t,attr:{"aria-labelledby":o&&o.length?o.join(" "):null,"aria-describedby":i&&i.length?i.join(" "):null}}},performCellModifications:function(e,t,i,n,a,r,l,s){u.storeDefaultsBeforeCellModifications(e,t,i,n);const c=u.getRowColChange(e);const d=e.getTable();const f=d.getId();d.$("cellacc").text(l||".");if(s){s(a,r,c.rowChange,c.colChange,c.initial)}if(c.initial||c.rowChange){if(o.hasRowNavigationIndicators(d)){const e=o.getCellInfo(t);if(e.type!==o.CELLTYPE.COLUMNHEADER&&e.type!==o.CELLTYPE.COLUMNROWHEADER){const t=d.getRows()[e.rowIndex].getAggregation("_settings");if(t.getNavigated()){a.push(f+"-rownavigatedtext")}}}}const g=a&&a.length?a.join(" "):null;t.attr({"aria-labelledby":g,"aria-describedby":r&&r.length?r.join(" "):null})},modifyAccOfDataCell:function(e){const t=this.getTable();const i=t.getId();const n=t._getItemNavigation();if(!n){return}const a=jQuery(e.cell);const r=o.getRowIndexOfFocusedCell(t);const l=u.getColumnIndexOfFocusedCell(this);const c=o.getRowColCell(t,r,l,false);let d=null;const f=c.row;const g=f.getId();const b=u.isHiddenCell(a,c.cell);const p=u.isTreeColumnCell(this,a);const h=u.getAriaAttributesForDataCell(this,{index:l,column:c.column,fixed:o.isFixedColumn(t,l)})["aria-labelledby"]||[];const C=[];let T=[];const A=f.isGroupHeader();const w=f.isSummary();if(A){T.push(i+"-ariarowgrouplabel")}else if(f.isTotalSummary()){T.push(i+"-ariagrandtotallabel")}else if(f.isGroupSummary()){T.push(i+"-ariagrouptotallabel")}if(o.hasRowHighlights(t)&&!A&&!w){T.push(g+"-highlighttext")}T=T.concat(h);if(!b){d=s.getAccInfoOfControl(c.cell);T.push(d?i+"-cellacc":c.cell.getId())}let m="";if(d){m=d.description;if(o.getInteractiveElements(a)!==null){m=o.getResourceText("TBL_CELL_INCLUDES",[m])}}if(p&&!b){const e=u.getAriaAttributesForTreeIcon(this,{row:c.row});if(e&&e["aria-label"]){m=e["aria-label"].concat(" ",m)}}u.performCellModifications(this,a,h,null,T,C,m,function(e,i,n,r){if(A&&n){e.splice(1,0,g+"-groupHeader")}const l=a.find(".sapUiTableTreeIcon").not(".sapUiTableTreeIconLeaf").length===1;if((l||A)&&(n||r)){i.push(t.getId()+(!f.isExpanded()?"-rowexpandtext":"-rowcollapsetext"))}else if(!b&&!A&&!w&&o.isRowSelectionAllowed(t)&&n){e.push(g+"-rowselecttext")}})},modifyAccOfRowHeader:function(e){const t=this.getTable();const i=t.getId();const n=jQuery(e.cell);const a=t.getRows()[e.rowIndex];const r=a.getId();const l=u.getAriaAttributesForRowHeader(this)["aria-labelledby"]||[];const s=[].concat(l);if(!a.isSummary()&&!a.isGroupHeader()&&!a.isContentHidden()){s.push(r+"-rowselecttext");if(o.hasRowHighlights(t)){s.push(r+"-highlighttext")}}if(a.isGroupHeader()){s.push(i+"-ariarowgrouplabel");s.push(r+"-groupHeader");s.push(i+(a.isExpanded()?"-rowcollapsetext":"-rowexpandtext"))}if(a.isTotalSummary()){s.push(i+"-ariagrandtotallabel")}else if(a.isGroupSummary()){s.push(i+"-ariagrouptotallabel")}u.performCellModifications(this,n,l,null,s,null,null)},modifyAccOfColumnHeader:function(e){const t=this.getTable();const i=jQuery(e.cell);const n=a.getElementById(i.attr("data-sap-ui-colid"));const r=o.Column.getHeaderLabel(n);const l=u.getAriaAttributesForColumnHeader(this,{headerId:i.attr("id"),column:n,index:i.attr("data-sap-ui-colindex")});const s=u.getColumnTooltip(n);const c=l["aria-labelledby"]||[];const d=e.columnSpan;if(r?.getRequired?.()){c.push(t.getId()+"-ariarequired")}if(d>1){c.push(t.getId()+"-ariacolspan");t.$("ariacolspan").text(o.getResourceText("TBL_COL_DESC_SPAN",[""+d]))}if(s){c.push(t.getId()+"-cellacc")}if(d<=1&&n&&n.getFiltered()){c.push(t.getId()+"-ariacolfiltered")}if(c.length>0){c.unshift(i.attr("id")+"-inner")}u.performCellModifications(this,i,l["aria-labelledby"],l["aria-describedby"],c,l["aria-describedby"],s)},modifyAccOfColumnRowHeader:function(e){const t=this.getTable();const o=jQuery(e.cell);const i=o.hasClass("sapUiTableSelAllVisible");const n=u.getAriaAttributesForColumnRowHeader(this,{enabled:i,checked:i&&!t.$().hasClass("sapUiTableSelAll")});const a=n["aria-labelledby"]||[];u.performCellModifications(this,o,[],n["aria-describedby"],a,n["aria-describedby"],null)},modifyAccOfRowAction:function(e){const t=this.getTable();const i=t.getId();const n=jQuery(e.cell);const a=t.getRows()[e.rowIndex];const r=a.getId();const l=u.isHiddenCell(n);const s=u.getAriaAttributesForRowAction(this)["aria-labelledby"]||[];const c=[].concat(s);const d=[];const f=a.isGroupHeader();if(f){c.push(i+"-ariarowgrouplabel");c.push(i+(a.isExpanded()?"-rowcollapsetext":"-rowexpandtext"))}if(a.isTotalSummary()){c.push(i+"-ariagrandtotallabel")}else if(a.isGroupSummary()){c.push(i+"-ariagrouptotallabel")}if(o.hasRowHighlights(t)&&!a.isGroupHeader()&&!a.isSummary()){c.push(r+"-highlighttext")}let g="";if(!l){const e=a.getRowAction();if(e){const t=e.getAccessibilityInfo();if(t){c.push(i+"-cellacc");g=t.description}}}u.performCellModifications(this,n,s,[],c,d,g,function(e,t,o){if(f&&o){const t=e.indexOf(i+"-ariarowgrouplabel")+1;e.splice(t,0,r+"-groupHeader")}})},getAriaAttributesForColumnRowHeaderRow:function(){return{role:"row","aria-hidden":"true"}},getAriaAttributesForColumnRowHeaderCell:function(){return{role:"columnheader"}},getAriaAttributesForColumnRowHeader:function(e,t){const i={};const n=e.getTable();const a=n._getSelectionPlugin().getRenderConfig();if(n.getSelectionMode()!==r.None){i["aria-label"]=o.getResourceText("TBL_TABLE_SELECTION_COLUMNHEADER")}if(a.headerSelector.visible){if(a.headerSelector.type==="toggle"){i["role"]=["checkbox"];if(t&&t.enabled){i["aria-checked"]=t.checked?"true":"false"}}else if(a.headerSelector.type==="custom"){i["role"]=["button"];if(!t||!t.enabled){i["aria-disabled"]="true"}}}return i},getAriaAttributesForRowAddon:function(){return{role:"row","aria-hidden":"true"}},getAriaAttributesForRowHeader:function(e){const t={};const i=e.getTable();const n=i.getId();t["role"]="gridcell";t["aria-colindex"]=1;if(o.hasRowHeader(i)&&i.getSelectionMode()===r.None){t["aria-labelledby"]=[n+"-rowselecthdr"]}return t},getAriaAttributesForRowAction:function(e){const t={};const i=e.getTable();const n=i.getId();t["role"]="gridcell";t["aria-colindex"]=o.getVisibleColumnCount(i)+1+(o.hasRowHeader(i)?1:0);t["aria-labelledby"]=[n+"-rowacthdr"];return t},getAriaAttributesForColumnHeader:function(e,t){const i={};const n=e.getTable();const a=n.getId();const r=t&&t.column;const l=t&&t.colspan;i["role"]="columnheader";i["aria-colindex"]=t.index+1+(o.hasRowHeader(n)?1:0);if(t&&t.index<n.getComputedFixedColumnCount()){i["aria-labelledby"]=[a+"-ariafixedcolumn"]}if(!l&&r){i["aria-sort"]=r.getSortOrder().toLowerCase();if(!r.getSorted()){i["aria-sort"]="none"}const e=r.getHeaderMenuInstance();if(e){const t=e.getAriaHasPopupType();if(t!=="None"){i["aria-haspopup"]=t.toLowerCase()}}if(!e&&r._menuHasItems()){i["aria-haspopup"]="menu"}}return i},getAriaAttributesForDataCell:function(e,t){const i={};const n=e.getTable();const a=n.getId();i["role"]="gridcell";i["aria-colindex"]=t.index+1+(o.hasRowHeader(n)?1:0);if(t.column&&t.fixed){i["aria-labelledby"]=[a+"-ariafixedcolumn"]}return i},getAriaAttributesForTable:function(e){const t={role:"presentation"};const o=e.getTable();c(o,t,true,true);return t},getAriaAttributesForContent:function(e){const t={};const i=e.getTable();const n=i.getId();t["role"]=o.Grouping.isInGroupMode(i)||o.Grouping.isInTreeMode(i)?"treegrid":"grid";t["aria-describedby"]=[n+"-ariaselection"];t["aria-labelledby"]=[].concat(i.getAriaLabelledBy());if(i.getTitle()){t["aria-labelledby"].push(i.getTitle().getId())}if(i.getSelectionMode()===r.MultiToggle){t["aria-multiselectable"]="true"}const a=i._getRowCounts();const l=o.hasFixedColumns(i);const s=a.fixedTop>0;const c=a.fixedBottom>0;const d=o.hasRowHeader(i);const f=o.hasRowActions(i);const g=u.getGridSize(i);t["aria-owns"]=[n+"-sapUiTableColHdrCnt",n+"-table"];if(l){t["aria-owns"].push(n+"-table-fixed")}if(s){t["aria-owns"].push(n+"-table-fixrow");if(l){t["aria-owns"].push(n+"-table-fixed-fixrow")}}if(c){t["aria-owns"].push(n+"-table-fixrow-bottom");if(l){t["aria-owns"].push(n+"-table-fixed-fixrow-bottom")}}if(d){t["aria-owns"].push(n+"-sapUiTableRowHdrScr")}if(f){t["aria-owns"].push(n+"-sapUiTableRowActionScr")}t["aria-rowcount"]=g.rowCount;t["aria-colcount"]=g.columnCount;if(i.isA("sap.ui.table.AnalyticalTable")){t["aria-roledescription"]=o.getResourceText("TBL_ANALYTICAL_TABLE_ROLE_DESCRIPTION")}return t},getAriaAttributesForTableHeader:function(e){const t={role:"heading","aria-level":"2"};const o=e.getTable();c(o,t,true,false);return t},getAriaAttributesForColumnHeaderRow:function(e,t){const i={role:"row"};const n=e.getTable();const a=n.getId();i["aria-rowindex"]=t.rowIndex+1;i["aria-owns"]=[];if(o.hasRowHeader(n)){i["aria-owns"].push(a+"-rowcolhdr")}for(let e=0;e<o.getVisibleColumnCount(n);e++){i["aria-owns"].push(n._getVisibleColumns()[e].getId())}if(o.hasRowActions(n)){i["aria-owns"].push(a+"-rowacthdr")}c(n,i,true,false);return i},getAriaAttributesForCreationRow:function(e,t){const o={};const i=e.getTable();o["role"]="form";o["aria-labelledby"]=t.creationRow.getId()+"-label";c(i,o,true,false);return o},getAriaAttributesForRowHeaderCol:function(e){const t={};const o=e.getTable();c(o,t,true,true);return t},getAriaAttributesForTh:function(){return{role:"presentation",scope:"col","aria-hidden":"true"}},getAriaAttributesForTr:function(e,t){const i={};const n=e.getTable();const a=n.getId();i["role"]="row";if(t.rowNavigated){i["aria-current"]=true}i["aria-owns"]=[];if(o.hasRowHeader(n)){i["aria-owns"].push(a+"-rowsel"+t.index)}for(let e=0;e<o.getVisibleColumnCount(n);e++){i["aria-owns"].push(a+"-rows-row"+t.index+"-col"+e)}if(o.hasRowActions(n)){i["aria-owns"].push(a+"-rowact"+t.index)}return i},getAriaAttributesForTreeIcon:function(e,t){let i={};const n=e.getTable();if(o.Grouping.isInTreeMode(n)){i={"aria-label":"",title:"",role:""};if(n.getBinding()){if(t&&t.row){if(t.row.isExpandable()){const e=o.getResourceText("TBL_COLLAPSE_EXPAND");i["title"]=e;i["aria-expanded"]=""+!!t.row.isExpanded();i["aria-hidden"]="false";i["role"]="button"}else{i["aria-label"]=o.getResourceText("TBL_LEAF");i["aria-hidden"]="true"}}}}return i},getAriaAttributesForNoData:function(e){const t={};const i=e.getTable();const n=i.getId();const a=o.getNoContentMessage(i);const r=[];t["role"]="gridcell";if(o.isA(a,"sap.ui.core.Control")){if(a.getAccessibilityReferences instanceof Function){const e=a.getAccessibilityReferences();r.push(e.title);r.push(e.description)}else{r.push(a.getId())}}else{r.push(n+"-noDataMsg")}t["aria-labelledby"]=r;c(i,t,true,false);return t},getAriaAttributesForOverlay:function(e){const t={};const o=e.getTable();const i=o.getId();t["role"]="region";t["aria-labelledby"]=[].concat(o.getAriaLabelledBy());if(o.getTitle()){t["aria-labelledby"].push(o.getTitle().getId())}t["aria-labelledby"].push(i+"-ariainvalid");return t},getAriaAttributesForTableFooter:function(e){const t={};const o=e.getTable();c(o,t,true,false);return t},getAriaAttributesForTableSubHeader:function(e){const t={};const o=e.getTable();c(o,t,true,false);return t},getAriaAttributesForRowActionHeader:function(){return{"aria-hidden":"true"}},getAriaAttributesForPresentation:function(){return{role:"presentation"}}};const d=e.extend("sap.ui.table.extensions.Accessibility",{_init:function(i,a,r){this._accMode=n.isAccessibilityEnabled();this._busyCells=[];o.addDelegate(i,this);e.enrich(i,t);return"AccExtension"},_attachEvents:function(){o.Hook.register(this.getTable(),o.Hook.Keys.Table.TotalRowCountChanged,this._updateAriaRowCount,this)},_detachEvents:function(){o.Hook.deregister(this.getTable(),o.Hook.Keys.Table.TotalRowCountChanged,this._updateAriaRowCount,this)},_debug:function(){this._ExtensionHelper=u;this._ACCInfoHelper=s},destroy:function(){this.getTable().removeEventDelegate(this);this._busyCells=[];e.prototype.destroy.apply(this,arguments)},getAriaAttributesFor:function(e,t){return u["getAriaAttributesFor"+e](this,t)},onfocusin:function(e){const t=this.getTable();if(!t||o.getCellInfo(e.target).cell==null){return}if(t._mTimeouts._cleanupACCExtension){clearTimeout(t._mTimeouts._cleanupACCExtension);t._mTimeouts._cleanupACCExtension=null}this.updateAccForCurrentCell("Focus")},onfocusout:function(e){const t=this.getTable();if(!t||e.target.classList.contains("sapUiTableCtrlBefore")){return}t._mTimeouts._cleanupACCExtension=setTimeout(function(){const e=this.getTable();if(!e){return}this._iLastRowNumber=null;this._iLastColumnNumber=null;u.cleanupCellModifications(this);e._mTimeouts._cleanupACCExtension=null}.bind(this),100)}});d.ELEMENTTYPES={DATACELL:"DataCell",COLUMNHEADER:"ColumnHeader",ROWHEADER:"RowHeader",ROWACTION:"RowAction",COLUMNROWHEADER:"ColumnRowHeader"};d.prototype.getAccMode=function(){return this._accMode};d.prototype._updateAriaRowIndices=function(){if(!this._accMode){return}const e=this.getTable();const t=e.getRows();let o;let i;let n;for(i=0;i<t.length;i++){o=t[i];n=o.getDomRefs(true);n.row.not(n.rowHeaderPart).not(n.rowActionPart).attr("aria-rowindex",u.getRowIndex(o))}};d.prototype._updateAriaRowCount=function(){const e=this.getTable();const t=e.$("sapUiTableGridCnt");if(t){t.attr("aria-rowcount",u.getGridSize(e).rowCount)}};d.prototype.updateAccForCurrentCell=function(e){if(!this._accMode||!this.getTable()._getItemNavigation()){return}if(e==="Focus"||e===o.RowsUpdateReason.Expand||e===o.RowsUpdateReason.Collapse){u.cleanupCellModifications(this)}const t=u.getInfoOfFocusedCell(this);let i;if(!t||!t.isOfType(l.ANY)){return}if(t.isOfType(l.DATACELL)){i=d.ELEMENTTYPES.DATACELL}else if(t.isOfType(l.COLUMNHEADER)){i=d.ELEMENTTYPES.COLUMNHEADER}else if(t.isOfType(l.ROWHEADER)){i=d.ELEMENTTYPES.ROWHEADER}else if(t.isOfType(l.ROWACTION)){i=d.ELEMENTTYPES.ROWACTION}else if(t.isOfType(l.COLUMNROWHEADER)){i=d.ELEMENTTYPES.COLUMNROWHEADER}if(!u["modifyAccOf"+i]){return}if(e!=="Focus"&&e!==o.RowsUpdateReason.Expand&&e!==o.RowsUpdateReason.Collapse){if(t.isOfType(l.ANYCONTENTCELL)){t.cell.setAttribute("role","status");t.cell.setAttribute("role","gridcell")}else{return}}u["modifyAccOf"+i].apply(this,[t])};d.prototype.updateSelectionStateOfRow=function(e){if(!this._accMode){return}const t=e.getDomRefs(true);let o="";if(!e.isEmpty()&&!e.isGroupHeader()&&!e.isSummary()){const i=this.getKeyboardTexts();const n=e._isSelected();if(t.row){t.row.not(t.rowHeaderPart).not(t.rowActionPart).add(t.row.children(".sapUiTableCell")).attr("aria-selected",n?"true":"false")}o=n?i.rowDeselect:i.rowSelect}if(t.rowSelectorText){t.rowSelectorText.text(o)}};d.prototype.updateAriaExpandAndLevelState=function(e){if(!this._accMode){return}const t=e.getDomRefs(true);const o=t.row.find(".sapUiTableTreeIcon");t.row.not(t.rowHeaderPart).not(t.rowActionPart).attr({"aria-expanded":e.isExpandable()?e.isExpanded()+"":null,"aria-level":e.getLevel()});if(o){o.attr(u.getAriaAttributesForTreeIcon(this,{row:e}))}};d.prototype.updateAriaStateOfRowHighlight=function(e){if(!this._accMode||!e){return}const t=e._getRow();const o=t?t.getDomRef("highlighttext"):null;if(o){o.innerText=e._getHighlightText()}};d.prototype._updateAriaStateOfNavigatedRow=function(e){if(!this._accMode||!e){return}const t=e._getRow();const o=e.getNavigated();t.getDomRefs(true).row.attr("aria-current",o?true:null)};d.prototype.updateAriaStateForOverlayAndNoData=function(){const e=this.getTable();if(!e||!e.getDomRef()||!this._accMode){return}if(e.getShowOverlay()){e.$().find("[data-sap-ui-table-acc-covered*='overlay']").attr("aria-hidden","true")}else{e.$().find("[data-sap-ui-table-acc-covered*='overlay']").removeAttr("aria-hidden");if(o.isNoDataVisible(e)){e.$().find("[data-sap-ui-table-acc-covered*='nodata']").attr("aria-hidden","true")}else{e.$().find("[data-sap-ui-table-acc-covered*='nodata']").removeAttr("aria-hidden")}}};d.prototype.getKeyboardTexts=function(){const e=this.getTable().getSelectionMode();const t={rowSelect:"",rowDeselect:""};if(e===r.None){return t}t.rowSelect=o.getResourceText("TBL_ROW_SELECT_KEY");t.rowDeselect=o.getResourceText("TBL_ROW_DESELECT_KEY");return t};d.prototype.setSelectAllState=function(e){const t=this.getTable();if(this._accMode&&t){t.$("selall").attr("aria-checked",e?"true":"false")}};d.prototype.addColumnHeaderLabel=function(e,t){const o=this.getTable();if(!this._accMode||!t.getAriaLabelledBy||!o){return}let i=o.getColumnHeaderVisible()?e.getId():null;if(!i){const t=e.getAggregation("label");if(t){i=t.getId()}}const n=t.getAriaLabelledBy();if(i&&n.indexOf(i)<0){t.addAriaLabelledBy(i)}};return d});
//# sourceMappingURL=Accessibility.js.map