/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["./ExtensionBase","./KeyboardDelegate","../utils/TableUtils","sap/ui/core/delegate/ItemNavigation","sap/ui/Device","sap/ui/dom/containsOrEquals","sap/ui/thirdparty/jquery"],function(t,e,i,o,n,a,jQuery){"use strict";const s={_forward:function(t,e){const i=t._getItemNavigation();if(i!=null&&!t._getKeyboardExtension().isItemNavigationSuspended()&&!e.isMarked("sapUiTableSkipItemNavigation")){i["on"+e.type](e)}},onfocusin:function(t){s._forward(this,t)},onsapfocusleave:function(t){s._forward(this,t)},onmousedown:function(t){s._forward(this,t)},onsapnext:function(t){s._forward(this,t)},onsapnextmodifiers:function(t){s._forward(this,t)},onsapprevious:function(t){s._forward(this,t)},onsappreviousmodifiers:function(t){s._forward(this,t)},onsappageup:function(t){s._forward(this,t)},onsappagedown:function(t){s._forward(this,t)},onsaphome:function(t){s._forward(this,t)},onsaphomemodifiers:function(t){s._forward(this,t)},onsapend:function(t){s._forward(this,t)},onsapendmodifiers:function(t){s._forward(this,t)},onsapkeyup:function(t){s._forward(this,t)}};const l={onBeforeRendering:function(t){this._oStoredFocusInfo=this.getFocusInfo()},onAfterRendering:function(t){const e=t&&t.isMarked("renderRows");this._getKeyboardExtension().invalidateItemNavigation();if(this._oStoredFocusInfo&&this._oStoredFocusInfo.customId){if(e){this.applyFocusInfo(this._oStoredFocusInfo)}else{f.initItemNavigation(this._getKeyboardExtension(),true)}}delete this._oStoredFocusInfo},onfocusin:function(t){const e=this._getKeyboardExtension();if(!e._bIgnoreFocusIn){f.initItemNavigation(this._getKeyboardExtension())}else{t.setMarked("sapUiTableIgnoreFocusIn")}if(t.target&&t.target.id===this.getId()+"-rsz"){t.preventDefault();t.setMarked("sapUiTableSkipItemNavigation")}}};const f={initItemNavigation:function(t,e){if(f.isItemNavigationInvalid(t)){f._initItemNavigation(t,e)}},_initItemNavigation:function(t,e){const n=t.getTable();if(!n){return}const a=n.$();const s=n.getRows().length;let l=i.getVisibleColumnCount(n);const d=i.hasRowHeader(n);const r=i.hasRowActions(n);const c=i.hasFixedColumns(n);let u;let g=[];let p;let h;let m;let _;let b;if(c){m=a.find(".sapUiTableCtrlFixed.sapUiTableCtrlRowFixed:not(.sapUiTableCHT)");_=a.find(".sapUiTableCtrlFixed.sapUiTableCtrlRowScroll:not(.sapUiTableCHT)");b=a.find(".sapUiTableCtrlFixed.sapUiTableCtrlRowFixedBottom:not(.sapUiTableCHT)")}const v=a.find(".sapUiTableCtrlScroll.sapUiTableCtrlRowFixed:not(.sapUiTableCHT)");const I=a.find(".sapUiTableCtrlScroll.sapUiTableCtrlRowScroll:not(.sapUiTableCHT)");const C=a.find(".sapUiTableCtrlScroll.sapUiTableCtrlRowFixedBottom:not(.sapUiTableCHT)");if(d){p=a.find(".sapUiTableRowSelectionCell").get();l++}if(r){h=a.find(".sapUiTableRowActionCell").get();l++}for(u=0;u<s;u++){if(d){g.push(p[u])}if(c){g=g.concat(m.find('tr[data-sap-ui-rowindex="'+u+'"]').find("td[tabindex]").get())}g=g.concat(v.find('tr[data-sap-ui-rowindex="'+u+'"]').find("td[tabindex]").get());if(c){g=g.concat(_.find('tr[data-sap-ui-rowindex="'+u+'"]').find("td[tabindex]").get())}g=g.concat(I.find('tr[data-sap-ui-rowindex="'+u+'"]').find("td[tabindex]").get());if(c){g=g.concat(b.find('tr[data-sap-ui-rowindex="'+u+'"]').find("td[tabindex]").get())}g=g.concat(C.find('tr[data-sap-ui-rowindex="'+u+'"]').find("td[tabindex]").get());if(r){g.push(h[u])}}if(n.getColumnHeaderVisible()){let t=[];const e=a.find(".sapUiTableCHT.sapUiTableCtrlFixed>tbody>tr");const o=a.find(".sapUiTableCHT.sapUiTableCtrlScroll>tbody>tr");const s=i.getHeaderRowCount(n);for(u=0;u<s;u++){if(d){t.push(n.getDomRef("selall"))}if(e.length){t=t.concat(jQuery(e.get(u)).find(".sapUiTableHeaderCell").get())}if(o.length){t=t.concat(jQuery(o.get(u)).find(".sapUiTableHeaderCell").get())}if(r){t.push(n.getDomRef("rowacthdr"))}}g=t.concat(g)}if(!t._itemNavigation){t._itemNavigation=new o;t._itemNavigation.setTableMode(true);t._itemNavigation.attachEvent(o.Events.AfterFocus,function(e){const o=i.getFocusedItemInfo(n);o.header=i.getHeaderRowCount(n);o.domRef=null;if(o.row>=o.header){t._oLastFocusedCellInfo=o}},n)}t._itemNavigation.setColumns(l);t._itemNavigation.setRootDomRef(a.find(".sapUiTableCnt").get(0));t._itemNavigation.setItemDomRefs(g);if(!e){t._itemNavigation.setFocusedIndex(f.getInitialItemNavigationIndex(t))}t._itemNavigationInvalidated=false},getInitialItemNavigationIndex:function(t){return i.hasRowHeader(t.getTable())?1:0},isItemNavigationInvalid:function(t){return!t._itemNavigation||t._itemNavigationInvalidated}};const d=t.extend("sap.ui.table.extensions.Keyboard",{_init:function(t,o,n){this._itemNavigation=null;this._itemNavigationInvalidated=false;this._itemNavigationSuspended=false;this._delegate=new e(o);this._actionMode=false;i.addDelegate(t,l,t);i.addDelegate(t,this._delegate,t);i.addDelegate(t,s,t);t._getItemNavigation=function(){return this._itemNavigation}.bind(this);return"KeyboardExtension"},_debug:function(){this._ExtensionHelper=f;this._ItemNavigationDelegate=s;this._ExtensionDelegate=l},destroy:function(){const e=this.getTable();if(e){e.removeEventDelegate(l);e.removeEventDelegate(this._delegate);e.removeEventDelegate(s)}if(this._itemNavigation){this._itemNavigation.destroy();this._itemNavigation=null}if(this._delegate){this._delegate.destroy();this._delegate=null}t.prototype.destroy.apply(this,arguments)}});d.prototype.initItemNavigation=function(){f.initItemNavigation(this)};d.prototype.invalidateItemNavigation=function(){this._itemNavigationInvalidated=true};d.prototype.setActionMode=function(t,e){if(!this._delegate){return}if(t===true&&!this._actionMode&&this._delegate.enterActionMode){this._actionMode=this._delegate.enterActionMode.call(this.getTable())===true}else if(t===false&&this._actionMode&&this._delegate.leaveActionMode){this._actionMode=false;this._delegate.leaveActionMode.call(this.getTable(),e===true)}};d.prototype.isInActionMode=function(){return this._actionMode};d.prototype.updateNoDataAndOverlayFocus=function(){const t=this.getTable();const e=document.activeElement;if(!t||!t.getDomRef()){return}if(t.getShowOverlay()){if(a(t.getDomRef(),e)&&t.$("overlay")[0]!==e){this._oLastFocus={Ref:e,Pos:"overlay"};t.getDomRef("overlay").focus()}}else if(i.isNoDataVisible(t)){if(t.$("noDataCnt")[0]===e){return}if(a(t.getDomRef("tableCCnt"),e)){this._oLastFocus={Ref:e,Pos:"table content"};if(n.browser.safari){t.getDomRef("noDataCnt").getBoundingClientRect()}t.getDomRef("noDataCnt").focus()}else if(t.$("overlay")[0]===e){c(t,this)}else if(t._bApplyFocusInfoFailed){this._oLastFocus={Ref:e,Pos:"table content"};delete t._bApplyFocusInfoFailed;t.getDomRef("noDataCnt").focus()}}else if(this._oLastFocus){if(this._oLastFocus.Pos==="table content"){if(a(t.getDomRef("tableCCnt"),this._oLastFocus.Ref)){r(t,this)}else if(t.getRows()[0]&&t.getRows()[0].getDomRef("col0")){t.getRows()[0].getDomRef("col0").focus();this._oLastFocus=null}}else if(this._oLastFocus.Pos==="overlay"){if(a(t.getDomRef(),this._oLastFocus.Ref)){r(t,this)}else{c(t,this)}}}};function r(t,e){if(!jQuery(e._oLastFocus.Ref).hasClass("sapUiTableCell")){const o=i.getParentCell(t,e._oLastFocus.Ref);if(o&&o[0]&&jQuery(o[0]).hasClass("sapUiTableCell")){o[0].focus()}else{e._oLastFocus.Ref.focus()}}else{e._oLastFocus.Ref.focus()}e._oLastFocus=null}function c(t,e){if(t.getColumnHeaderVisible()){i.focusItem(t,f.getInitialItemNavigationIndex(e));e._oLastFocus=null}else if(i.isNoDataVisible(t)){t.getDomRef("noDataCnt").focus();e._oLastFocus=null}else if(t.getRows()[0]&&t.getRows()[0].getDomRef("col0")){t.getRows()[0].getDomRef("col0").focus();e._oLastFocus=null}}d.prototype.suspendItemNavigation=function(){this._itemNavigationSuspended=true};d.prototype.resumeItemNavigation=function(){this._itemNavigationSuspended=false};d.prototype.isItemNavigationSuspended=function(){return this._itemNavigationSuspended};d.prototype.getLastFocusedCellInfo=function(){const t=i.getHeaderRowCount(this.getTable());if(!this._oLastFocusedCellInfo||this._oLastFocusedCellInfo.header!==t){const e=i.getFocusedItemInfo(this.getTable());const o=f.getInitialItemNavigationIndex(this);return{cellInRow:o,row:t,header:t,cellCount:e.cellCount,columnCount:e.columnCount,cell:e.columnCount*t+o}}return this._oLastFocusedCellInfo};d.prototype.setSilentFocus=function(t){this._bIgnoreFocusIn=true;this.setFocus(t);this._bIgnoreFocusIn=false};d.prototype.setFocus=function(t){if(!t){return}const e=this.getTable();const o=i.getCellInfo(t);if(o.isOfType(i.CELLTYPE.ANY)&&e){const i=jQuery(t);if(i.attr("tabindex")!=="0"){const t=e._getItemNavigation();if(t&&t.aItemDomRefs){for(let e=0;e<t.aItemDomRefs.length;e++){if(t.aItemDomRefs[e]){t.aItemDomRefs[e].setAttribute("tabindex","-1")}}}i.attr("tabindex","0")}}if(t instanceof HTMLElement){t.focus()}else{t.trigger("focus")}};return d});
//# sourceMappingURL=Keyboard.js.map