/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["./ExtensionBase","../utils/TableUtils","../library","sap/ui/Device","sap/ui/core/Element","sap/ui/core/Popup","sap/base/Log","sap/ui/thirdparty/jquery","sap/ui/dom/jquery/scrollLeftRTL","sap/ui/dom/jquery/control"],function(e,t,o,i,n,s,l,jQuery){"use strict";const r=o.SelectionMode;const a=o.SelectionBehavior;const d=["sapMBtnBase","sapMInputBase","sapMLnk","sapMSlt","sapMCb","sapMRI","sapMSegBBtn","sapUiIconPointer","sapMBtnIcon","sapMObjStatusActive"];const u={_skipClick:function(e,o,i){if(!i.isOfType(t.CELLTYPE.DATACELL|t.CELLTYPE.ROWACTION)){return false}if(e.isMarked()){return true}const s=n.closestTo(o[0]);if(s){const e=s.$();if(e.length){for(let t=0;t<d.length;t++){if(e.hasClass(d[t])){return typeof s.getEnabled==="function"?s.getEnabled():true}}}}return false},_handleClickSelection:function(e,o,i){t.toggleRowSelection(i,o,null,function(t){if(e.shiftKey){i._getSelectionPlugin().setSelected(t,true,{range:true})}else if(i._legacyMultiSelection){i._legacyMultiSelection(t.getIndex(),e)}else{t._setSelected(!t._isSelected())}})}};const c={initColumnResizing:function(e,o){if(e._bIsColumnResizerMoving){return}e._bIsColumnResizerMoving=true;e._bColumnResizerMoved=false;e._iColumnResizeStart=t.getEventPosition(o,e).x;e.$().toggleClass("sapUiTableResizing",true);const i=jQuery(document);const n=e._isTouchEvent(o);e._$colResize=e.$("rsz");i.on((n?"touchend":"mouseup")+".sapUiTableColumnResize",c.exitColumnResizing.bind(e));i.on((n?"touchmove":"mousemove")+".sapUiTableColumnResize",c.onMouseMoveWhileColumnResizing.bind(e));e._disableTextSelection()},exitColumnResizing:function(e){const o=t.getEventPosition(e,this).x;const i=this._getVisibleColumns()[this._iLastHoveredVisibleColumnIndex];const n=this.$().find('th[data-sap-ui-colid="'+i.getId()+'"]');const s=n[0].offsetWidth;const l=n.width();const r=s-l;const a=o-(n.offset().left+(this._bRtlMode?0:s));const d=Math.round(s+a*(this._bRtlMode?-1:1))-r;const u=Math.max(d,t.Column.getMinColumnWidth());c._cleanupColumResizing(this);t.Column.resizeColumn(this,i,this._bColumnResizerMoved?u:null)},onMouseMoveWhileColumnResizing:function(e){const o=t.getEventPosition(e,this).x;const i=this.$().find(".sapUiTableCnt").offset().left;const n=Math.floor(o-i);if(!this._bColumnResizerMoved&&Math.abs(o-this._iColumnResizeStart)>=5){this._bColumnResizerMoved=true}this._$colResize.css("left",n+"px");this._$colResize.toggleClass("sapUiTableColRszActive",true);if(this._isTouchEvent(e)){e.stopPropagation();e.preventDefault()}},_cleanupColumResizing:function(e){if(e._$colResize){e._$colResize.toggleClass("sapUiTableColRszActive",false);e._$colResize=null}e._bIsColumnResizerMoving=false;e.$().toggleClass("sapUiTableResizing",false);e._enableTextSelection();const t=jQuery(document);t.off("touchmove.sapUiTableColumnResize");t.off("touchend.sapUiTableColumnResize");t.off("mousemove.sapUiTableColumnResize");t.off("mouseup.sapUiTableColumnResize")},initColumnTracking:function(e){e.$().find(".sapUiTableCtrlScr, .sapUiTableCtrlScrFixed").on("mousemove",function(e){const t=this.getDomRef("sapUiTableCnt");if(!t||this._bIsColumnResizerMoving){return}const o=e.clientX;const i=t.getBoundingClientRect();let n=0;let s=this._bRtlMode?1e4:-1e4;for(let e=0;e<this._aTableHeaders.length;e++){const t=this._aTableHeaders[e].getBoundingClientRect();if(this._bRtlMode){if(o<t.right-5&&o>=t.left){n=e;s=t.left-i.left;break}}else{if(o>t.left+5&&o<=t.right){n=e;s=t.right-i.left;break}}}const l=this._getVisibleColumns()[n];if(l&&l.getResizable()){this.$("rsz").css("left",s+"px");this._iLastHoveredVisibleColumnIndex=n}}.bind(e))}};const f={initReordering:function(e,o,i){const n=e.getColumns()[o];const l=n.$();const r=e.$();e._disableTextSelection();r.addClass("sapUiTableDragDrop");const a=l.clone();a.find("*").addBack(a).removeAttr("id").removeAttr("data-sap-ui").removeAttr("tabindex");a.attr("id",e.getId()+"-roghost").addClass("sapUiTableColReorderGhost").css({left:-1e4,top:-1e4,"z-index":s.getNextZIndex()});a.toggleClass(t.getContentDensity(e),true);a.appendTo(document.body);e._$ReorderGhost=e.getDomRef("roghost");r.find("td[data-sap-ui-colid='"+n.getId()+"']").toggleClass("sapUiTableColReorderFade",true);const d=jQuery("<div id='"+e.getId()+"-roind' class='sapUiTableColReorderIndicator'><div class='sapUiTableColReorderIndicatorArrow'></div><div class='sapUiTableColReorderIndicatorInner'></div></div>");d.appendTo(e.getDomRef("sapUiTableCnt"));e._$ReorderIndicator=e.getDomRef("roind");e._iDnDColIndex=o;const u=jQuery(document);const c=e._isTouchEvent(i);u.on((c?"touchend":"mouseup")+".sapUiColumnMove",f.exitReordering.bind(e));u.on((c?"touchmove":"mousemove")+".sapUiColumnMove",f.onMouseMoveWhileReordering.bind(e))},onMouseMoveWhileReordering:function(e){const o=t.getEventPosition(e,this);const i=o.x;const n=o.y;const s=this._iNewColPos;this._iNewColPos=this._iDnDColIndex;e.preventDefault();const l=f.findColumnForPosition(this,i);if(!l||!l.id){this._iNewColPos=s;return}const r=40;const a=this.getDomRef("sapUiTableColHdrScr");const d=jQuery(a);const u=a.getBoundingClientRect();const c=d.outerWidth();const h=this._bRtlMode?d.scrollLeftRTL():d.scrollLeft();this._bReorderScroll=false;if(i>u.left+c-r&&h+c<a.scrollWidth){this._bReorderScroll=true;f.doScroll(this,!this._bRtlMode);f.adaptReorderMarkerPosition(this,l,false)}else if(i<u.left+r&&h>0){this._bReorderScroll=true;f.doScroll(this,this._bRtlMode);f.adaptReorderMarkerPosition(this,l,false)}jQuery(this._$ReorderGhost).css({left:i+5,top:n+5});if(this._bReorderScroll||!l){return}if(l.before||l.after&&l.index===this._iDnDColIndex){this._iNewColPos=l.index}else if(l.after&&l.index!==this._iDnDColIndex){this._iNewColPos=l.index+1}if(!t.Column.isColumnMovableTo(this.getColumns()[this._iDnDColIndex],this._iNewColPos)){this._iNewColPos=s}else{f.adaptReorderMarkerPosition(this,l,true)}},exitReordering:function(e){const o=this._iDnDColIndex;const i=this._iNewColPos;const n=jQuery(document);n.off("touchmove.sapUiColumnMove");n.off("touchend.sapUiColumnMove");n.off("mousemove.sapUiColumnMove");n.off("mouseup.sapUiColumnMove");this._bReorderScroll=false;this.$().removeClass("sapUiTableDragDrop");delete this._iDnDColIndex;delete this._iNewColPos;jQuery(this._$ReorderGhost).remove();delete this._$ReorderGhost;jQuery(this._$ReorderIndicator).remove();delete this._$ReorderIndicator;this.$().find(".sapUiTableColReorderFade").removeClass("sapUiTableColReorderFade");this._enableTextSelection();t.Column.moveColumnTo(this.getColumns()[o],i)},findColumnForPosition:function(e,t){let o;let i;let n;let s;let l;let r;let a;for(let d=0;d<e._aTableHeaders.length;d++){o=e._aTableHeaders[d];i=jQuery(o);n=o.getBoundingClientRect();s=i.outerWidth();l={left:n.left,center:n.left+s/2,right:n.left+s,width:s,index:parseInt(i.attr("data-sap-ui-headcolindex")),id:i.attr("data-sap-ui-colid")};r=t>=l.left&&t<=l.center;a=t>=l.center&&t<=l.right;if(r||a){l.before=e._bRtlMode?a:r;l.after=e._bRtlMode?r:a;return l}}return null},doScroll:function(e,t){if(e._mTimeouts.horizontalReorderScrollTimerId){window.clearTimeout(e._mTimeouts.horizontalReorderScrollTimerId);e._mTimeouts.horizontalReorderScrollTimerId=null}if(e._bReorderScroll){let o=t?30:-30;if(e._bRtlMode){o=-1*o}e._mTimeouts.horizontalReorderScrollTimerId=setTimeout(f.doScroll.bind(e,e,t),60);const i=e.$("sapUiTableColHdrScr");const n=e._bRtlMode?"scrollLeftRTL":"scrollLeft";i[n](i[n]()+o)}},adaptReorderMarkerPosition:function(e,t,o){if(!t||!e._$ReorderIndicator){return}let i=t.left-e.getDomRef().getBoundingClientRect().left;if(e._bRtlMode&&t.before||!e._bRtlMode&&t.after){i=i+t.width}jQuery(e._$ReorderIndicator).css({left:i+"px"}).toggleClass("sapUiTableColReorderIndicatorActive",o)}};const h={ROWAREAS:[".sapUiTableRowSelectionCell",".sapUiTableRowActionCell",".sapUiTableCtrlFixed > tbody > .sapUiTableTr",".sapUiTableCtrlScroll > tbody > .sapUiTableTr"],initRowHovering:function(e){const t=e.$();h.ROWAREAS.forEach(function(o){h._initRowHoveringForArea(e,t,o)})},_initRowHoveringForArea:function(e,t,o){t.find(o).on("mouseenter",function(){h._onHover(e,t,o,this)}).on("mouseleave",function(){h._onUnhover(e,t,o,this)})},_onHover:function(e,t,o,i){if(e.getSelectionMode()!==r.None&&e.getSelectionBehavior()!==a.RowSelector||e.hasListeners("cellClick")){const n=t.find(o).index(i);const s=e.getRows()[n];if(s){s._setHovered(true)}}},_onUnhover:function(e,t,o,i){const n=t.find(o).index(i);const s=e.getRows()[n];if(s){s._setHovered(false)}}};const C={onmousedown:function(e){const o=this._getPointerExtension();const n=t.getCell(this,e.target);const s=t.getCellInfo(n);const l=jQuery(e.target);let r;let a;let d;this._getKeyboardExtension().initItemNavigation();if(e.button===0){if(e.target===this.getDomRef("rsz")){e.preventDefault();e.stopPropagation();c.initColumnResizing(this,e)}else if(l.hasClass("sapUiTableColResizer")){const t=l.closest(".sapUiTableHeaderCell").attr("data-sap-ui-colindex");this._iLastHoveredVisibleColumnIndex=this._getVisibleColumns().indexOf(this.getColumns()[t]);c.initColumnResizing(this,e)}else if(s.isOfType(t.CELLTYPE.COLUMNHEADER)){r=this.getColumns()[s.columnIndex];a=r.getAggregation("menu");d=a&&a.isOpen();if(!d){o._bShowMenu=true;this._mTimeouts.delayedMenuTimerId=setTimeout(function(){delete o._bShowMenu},200)}if(this.getEnableColumnReordering()&&!(this._isTouchEvent(e)&&l.hasClass("sapUiTableColDropDown"))){this._getPointerExtension().doReorderColumn(s.columnIndex,e)}}if(i.browser.firefox&&(e.metaKey||e.ctrlKey)||l.closest(".sapUiTableHSb",this.getDomRef()).length===1||l.closest(".sapUiTableVSb",this.getDomRef()).length===1){e.preventDefault()}}if(e.button===2){if(u._skipClick(e,l,s)){o._bShowDefaultMenu=true;return}if(s.isOfType(t.CELLTYPE.COLUMNHEADER)){r=this.getColumns()[s.columnIndex];a=r.getAggregation("menu");d=a&&a.isOpen();if(!d){o._bShowMenu=true}else{o._bHideMenu=true}}else if(s.isOfType(t.CELLTYPE.ANYCONTENTCELL)){o._bShowMenu=true}else{o._bShowDefaultMenu=true}}},onmouseup:function(e){clearTimeout(this._mTimeouts.delayedColumnReorderTimerId)},ondblclick:function(e){if(i.system.desktop&&e.target===this.getDomRef("rsz")){e.preventDefault();c._cleanupColumResizing(this);const t=this._getVisibleColumns()[this._iLastHoveredVisibleColumnIndex];if(t.getAutoResizable()){t.autoResize()}}},ontap:function(e){clearTimeout(this._mTimeouts.delayedColumnReorderTimerId);if(e.isMarked()){return}const o=jQuery(e.target);const i=t.getCell(this,e.target);const n=t.getCellInfo(i);const s=this.getRows()[n.rowIndex];if(!n.isOfType(t.CELLTYPE.ANY)){return}if(n.isOfType(t.CELLTYPE.COLUMNHEADER)){const o=this._getPointerExtension();if(o._bShowMenu){t.Menu.openContextMenu(this,e);delete o._bShowMenu}}else if(n.isOfType(t.CELLTYPE.COLUMNROWHEADER)){this._getSelectionPlugin().onHeaderSelectorPress()}else if(s&&s.isSummary()){e.preventDefault()}else if(o.hasClass("sapUiTableGroupIcon")||o.hasClass("sapUiTableTreeIcon")){s.toggleExpandedState()}else{if(u._skipClick(e,o,n)){return}const t=window.getSelection().toString();if(!e.shiftKey&&t.length>0&&t!=="\n"){l.debug("DOM Selection detected -> Click event on table skipped, Target: "+e.target);return}if(!this._findAndfireCellEvent(this.fireCellClick,e)){u._handleClickSelection(e,i,this)}else{e.preventDefault()}}},oncontextmenu:function(e){const o=this._getPointerExtension();if(o._bShowDefaultMenu){e.setMarked("sapUiTableHandledByPointerExtension");delete o._bShowDefaultMenu}else if(o._bShowMenu){t.Menu.openContextMenu(this,e);e.setMarked("sapUiTableHandledByPointerExtension");delete o._bShowMenu}else if(o._bHideMenu){e.setMarked("sapUiTableHandledByPointerExtension");e.preventDefault();delete o._bHideMenu}}};const g=e.extend("sap.ui.table.extensions.Pointer",{_init:function(o,i,n){this._delegate=C;t.addDelegate(o,this._delegate,o);o._iLastHoveredVisibleColumnIndex=0;o._bIsColumnResizerMoving=false;o._iFirstReorderableIndex=i===e.TABLETYPES.TREE?1:0;return"PointerExtension"},_attachEvents:function(){const e=this.getTable();if(e){c.initColumnTracking(e);h.initRowHovering(e)}},_detachEvents:function(){const e=this.getTable();if(e){const t=e.$();t.find(".sapUiTableCtrlScr, .sapUiTableCtrlScrFixed").off();t.find(".sapUiTableCtrl > tbody > tr").off();t.find(".sapUiTableRowSelectionCell").off()}},_debug:function(){this._ExtensionHelper=u;this._ColumnResizeHelper=c;this._ReorderHelper=f;this._ExtensionDelegate=C;this._RowHoverHandler=h;this._KNOWNCLICKABLECONTROLS=d},doReorderColumn:function(e,o){const i=this.getTable();if(i&&t.Column.isColumnMovable(i.getColumns()[e])){i._mTimeouts.delayedColumnReorderTimerId=setTimeout(function(){f.initReordering(this,e,o)}.bind(i),200)}},destroy:function(){const t=this.getTable();if(t){t.removeEventDelegate(this._delegate)}this._delegate=null;e.prototype.destroy.apply(this,arguments)}});return g});
//# sourceMappingURL=Pointer.js.map