/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["./ExtensionBase","../utils/TableUtils","../library","sap/ui/Device","sap/ui/performance/trace/Interaction","sap/base/Log","sap/ui/thirdparty/jquery","sap/ui/dom/jquery/scrollLeftRTL"],function(e,t,o,l,r,i,jQuery){"use strict";const n=o.SharedDomRef;const s=t.Hook.Keys;const c=t.createWeakMapFacade();const a=1e6;const f=2;const d=500;const u={HORIZONAL:"HORIZONTAL",VERTICAL:"VERTICAL",BOTH:"BOTH"};function p(e,t){i.debug("sap.ui.table.extensions.Scrolling",e,t)}function g(e,t){let o=true;let l=false;const r=[];const i={cancel:function(){if(this.isCancelled()||!this.isRunning()){return}l=true;for(let e=0;e<r.length;e++){r[e]()}p("Process cancelled: "+t.id)},isCancelled:function(){return l},addCancelListener:function(e){r.push(e)},isRunning:function(){return o},getInfo:function(){return t},onPromiseCreated:function(e){}};let n;p("Process started: "+t.id);if(typeof e==="function"){n=new Promise(function(){e.apply(this,Array.prototype.slice.call(arguments).concat(i))})}else{n=Promise.resolve()}Object.assign(n,i);n.then(function(){if(i.isCancelled()){p("Process finished due to cancellation: "+t.id)}else{p("Process finished: "+t.id)}o=false});i.onPromiseCreated(n);return n}function S(){this.iIndex=0;this.nOffset=0;this.sOffsetType=S.OffsetType.Pixel;this.bIsInitial=true}S.OffsetType={Pixel:"Pixel",Percentage:"Percentage",PercentageOfViewport:"PercentageOfViewport"};S.prototype.getIndex=function(){return this.iIndex};S.prototype.getOffset=function(){return this.nOffset};S.prototype.getOffsetType=function(){return this.sOffsetType};S.prototype.isOffsetInPixel=function(){return this.sOffsetType===S.OffsetType.Pixel};S.prototype.isInitial=function(){return this.bIsInitial};S.prototype.setPosition=function(e,t,o){p("ScrollPosition#setPosition(index: "+e+", offset: "+t+", offsetType: "+o+")");if(!S._isPositiveNumber(e)){return}if(!S._isPositiveNumber(t)){this.nOffset=0}this.setIndex(e);this.setOffset(t,o)};S.prototype.setIndex=function(e){p("ScrollPosition#setIndex(index: "+e+")");if(!S._isPositiveNumber(e)){return}this.bIsInitial=false;this.iIndex=e};S.prototype.setOffset=function(e,t){p("ScrollPosition#setOffset(offset: "+e+", offsetType: "+t+")");if(!S._isPositiveNumber(e)){return}this.bIsInitial=false;this.sOffsetType=t in S.OffsetType?t:S.OffsetType.Pixel;if(this.isOffsetInPixel()){this.nOffset=Math.round(e)}else{this.nOffset=Math.min(e,1)}};S.prototype.scrollRows=function(e){const t=this.getIndex()+e;let o=this.getOffset();if(!this.isOffsetInPixel()||t<0){o=0}this.setPosition(Math.max(0,t),o)};S._isPositiveNumber=function(e){return typeof e==="number"&&!isNaN(e)&&e>=0};const h={UpdateFromFirstVisibleRow:{id:"UpdateFromFirstVisibleRow",rank:6},UpdateFromScrollPosition:{id:"UpdateFromScrollPosition",rank:5},RestoreScrollPosition:{id:"RestoreScrollPosition",rank:4},AdjustToTotalRowCount:{id:"AdjustToTotalRowCount",rank:3},OnRowsUpdated:{id:"OnRowsUpdated",rank:3},UpdateFromScrollbar:{id:"UpdateFromScrollbar",rank:2},UpdateFromViewport:{id:"UpdateFromViewport",rank:1},canStart:function(e,t){const o=c(e).pVerticalScrollUpdateProcess;const l=o?o.getInfo():null;if(o&&o.isRunning()&&l.rank>t.rank){p("Cannot start update process "+t.id+" - A higher-ranked update process is currently running ("+l.id+")",e);return false}return true},start:function(e,t,o){if(!h.canStart(e,t)){return}if(c(e).pVerticalScrollUpdateProcess){c(e).pVerticalScrollUpdateProcess.cancel()}c(e).pVerticalScrollUpdateProcess=new g(o,t)}};const b={onScrollbarScroll:function(e){const t=e.target.scrollLeft;const o=e.target._scrollLeft;r.notifyScrollEvent&&r.notifyScrollEvent(e);if(t!==o){const o=b.getScrollAreas(this);e.target._scrollLeft=t;for(let l=0;l<o.length;l++){const r=o[l];if(r!==e.target&&r.scrollLeft!==t){r.scrollLeft=t;r._scrollLeft=t}}c(this).iHorizontalScrollPosition=t}},restoreScrollPosition:function(e){const t=e._getScrollExtension();const o=t.getHorizontalScrollbar();if(o&&c(e).iHorizontalScrollPosition!==null){const t=b.getScrollAreas(e);for(let e=0;e<t.length;e++){const o=t[e];delete o._scrollLeft}if(o.scrollLeft!==c(e).iHorizontalScrollPosition){o.scrollLeft=c(e).iHorizontalScrollPosition}else{const t=jQuery.Event("scroll");t.target=o;b.onScrollbarScroll.call(e,t)}}},updateScrollbar:function(e){const t=e._getScrollExtension();const o=t.getHorizontalScrollbar();if(!o){return}const r=e._collectTableSizes();const i=e.$();let n=r.tableCtrlScrollWidth;if(l.browser.safari){n=Math.max(n,e._getColumnsWidth(e.getComputedFixedColumnCount()))}const s=n>r.tableCtrlScrWidth;c(e).bHorizontalScrollbarRequired=s;if(s){if(!t.isHorizontalScrollbarVisible()){i.addClass("sapUiTableHScr");o.classList.remove("sapUiTableHidden");if(l.browser.safari){const e=i.find(".sapUiTableCtrlScroll, .sapUiTableColHdrScr > .sapUiTableColHdr");e.outerWidth(n)}}let s=r.tableCtrlFixedWidth;if(i.find(".sapUiTableRowHdrScr").length>0){s+=r.tableRowHdrScrWidth}if(e._bRtlMode){o.style.marginRight=s+"px";o.style.marginLeft=""}else{o.style.marginLeft=s+"px";o.style.marginRight=""}const c=e.getDomRef("hsb-content");if(c){c.style.width=n+"px"}}if(!s&&t.isHorizontalScrollbarVisible()){i.removeClass("sapUiTableHScr");o.classList.add("sapUiTableHidden");if(l.browser.safari){i.find(".sapUiTableCtrlScroll, .sapUiTableColHdr").css("width","")}}},onScrollbarMouseDown:function(e){this._getKeyboardExtension().setActionMode(false)},addEventListeners:function(e){const t=e._getScrollExtension();const o=t.getHorizontalScrollbar();const l=b.getScrollAreas(e);if(!t._onHorizontalScrollEventHandler){t._onHorizontalScrollEventHandler=b.onScrollbarScroll.bind(e)}for(let e=0;e<l.length;e++){l[e].addEventListener("scroll",t._onHorizontalScrollEventHandler)}if(o){if(!t._onHorizontalScrollbarMouseDownEventHandler){t._onHorizontalScrollbarMouseDownEventHandler=b.onScrollbarMouseDown.bind(e)}o.addEventListener("mousedown",t._onHorizontalScrollbarMouseDownEventHandler)}},removeEventListeners:function(e){const t=e._getScrollExtension();const o=t.getHorizontalScrollbar();const l=b.getScrollAreas(e);if(t._onHorizontalScrollEventHandler){for(let e=0;e<l.length;e++){l[e].removeEventListener("scroll",t._onHorizontalScrollEventHandler);delete l[e]._scrollLeft}delete t._onHorizontalScrollEventHandler}if(o&&t._onHorizontalScrollbarMouseDownEventHandler){o.removeEventListener("mousedown",t._onHorizontalScrollbarMouseDownEventHandler);delete t._onHorizontalScrollbarMouseDownEventHandler}},getScrollAreas:function(e){const t=e.getDomRef();let o;if(t){o=Array.prototype.slice.call(e.getDomRef().querySelectorAll(".sapUiTableCtrlScr"))}const l=[e._getScrollExtension().getHorizontalScrollbar()].concat(o);return l.filter(function(e){return e!=null})}};const m={performUpdateFromFirstVisibleRow:function(e,o){p("VerticalScrollingHelper.performUpdateFromFirstVisibleRow",e);h.start(e,h.UpdateFromFirstVisibleRow,function(l,r,i){t.Hook.call(e,s.Signal,"StartTableUpdate");i.onPromiseCreated=function(o){o.finally(function(){t.Hook.call(e,s.Signal,"EndTableUpdate")})};if(o===true){const t=function(){p("VerticalScrollingHelper.performUpdateFromFirstVisibleRow (async: rows update)",e);m._performUpdateFromFirstVisibleRow(e,i).then(l);return false};m.addOnRowsUpdatedPreprocessor(e,t);i.addCancelListener(function(){const o=m.removeOnRowsUpdatedPreprocessor(e,t);if(o){l()}})}else{m._performUpdateFromFirstVisibleRow(e,i).then(l)}})},_performUpdateFromFirstVisibleRow:function(e,t){return m.adjustScrollPositionToFirstVisibleRow(e,t).then(function(){return m.fixTemporaryFirstVisibleRow(e,null,t)}).then(function(){return m.fixScrollPosition(e,t)}).then(function(){return Promise.all([m.scrollViewport(e,t),m.scrollScrollbar(e,t)])})},performUpdateFromScrollPosition:function(e){p("VerticalScrollingHelper.performUpdateFromScrollPosition",e);h.start(e,h.UpdateFromScrollPosition,function(o,l,r){t.Hook.call(e,s.Signal,"StartTableUpdate");r.onPromiseCreated=function(o){o.finally(function(){t.Hook.call(e,s.Signal,"EndTableUpdate")})};m.adjustFirstVisibleRowToScrollPosition(e,null,r).then(function(){if(r.isCancelled()){return}const o=c(e).oVerticalScrollPosition;p("VerticalScrollingHelper.performUpdateFromScrollPosition (async: firstVisibleRow update)",e);if(o.getIndex()>e.getFirstVisibleRow()){o.setIndex(e.getFirstVisibleRow());if(t.isVariableRowHeightEnabled(e)){o.setOffset(1,S.OffsetType.Percentage)}else{o.setOffset(0)}}}).then(function(){return m.fixScrollPosition(e,r)}).then(function(){return Promise.all([m.scrollViewport(e,r),m.scrollScrollbar(e,r)])}).then(o)})},performUpdateFromScrollbar:function(e){p("VerticalScrollingHelper.performUpdateFromScrollbar",e);clearTimeout(c(e).mTimeouts.largeDataScrolling);delete c(e).mTimeouts.largeDataScrolling;h.start(e,h.UpdateFromScrollbar,function(o,l,r){t.Hook.call(e,s.Signal,"StartTableUpdate");r.onPromiseCreated=function(o){o.finally(function(){t.Hook.call(e,s.Signal,"EndTableUpdate")})};e._getKeyboardExtension().setActionMode(false);if(e._bLargeDataScrolling){c(e).mTimeouts.largeDataScrolling=setTimeout(function(){delete c(e).mTimeouts.largeDataScrolling;if(e._getScrollExtension().getVerticalScrollbar()!=null){p("VerticalScrollingHelper.performUpdateFromScrollbar (async: large data scrolling)",e);m._performUpdateFromScrollbar(e,r).then(o)}else{p("VerticalScrollingHelper.performUpdateFromScrollbar (async: large data scrolling): No scrollbar",e)}},300);r.addCancelListener(function(){if(c(e).mTimeouts.largeDataScrolling!=null){clearTimeout(c(e).mTimeouts.largeDataScrolling);delete c(e).mTimeouts.largeDataScrolling;o()}})}else{m._performUpdateFromScrollbar(e,r).then(o)}})},_performUpdateFromScrollbar:function(e,t){return m.adjustScrollPositionToScrollbar(e,t).then(function(){return m.adjustFirstVisibleRowToScrollPosition(e,null,t)}).then(function(){return m.fixScrollPosition(e,t)}).then(function(){return m.scrollViewport(e,t)})},performUpdateFromViewport:function(e){p("VerticalScrollingHelper.performUpdateFromViewport",e);h.start(e,h.UpdateFromViewport,function(o,l,r){t.Hook.call(e,s.Signal,"StartTableUpdate");r.onPromiseCreated=function(o){o.finally(function(){t.Hook.call(e,s.Signal,"EndTableUpdate")})};m.adjustScrollPositionToViewport(e,r).then(function(){return m.adjustFirstVisibleRowToScrollPosition(e,true,r)}).then(function(){return m.scrollScrollbar(e,r)}).then(o)})},onScrollbarScroll:function(e){r.notifyScrollEvent&&r.notifyScrollEvent(e);const t=e.target.scrollTop;const o=e.target._scrollTop;const l=t!==o;delete e.target._scrollTop;if(t===0&&!e.target.isConnected){p("VerticalScrollingHelper.onScrollbarScroll: Scrollbar is not connected with the DOM",this)}else if(l){p("VerticalScrollingHelper.onScrollbarScroll: Scroll position changed to "+t+" by interaction",this);m.performUpdateFromScrollbar(this)}else{p("VerticalScrollingHelper.onScrollbarScroll: Scroll position changed to "+t+" by API",this)}},onViewportScroll:function(e){if(!h.canStart(this,h.UpdateFromViewport)){return}const t=e.target.scrollTop;const o=e.target._scrollTop;delete e.target._scrollTop;if(t!==o){p("VerticalScrollingHelper.onViewportScroll: Scroll position changed to "+t+" by interaction",this);m.performUpdateFromViewport(this)}else{p("VerticalScrollingHelper.onViewportScroll: Scroll position changed to "+t+" by API",this)}},adjustFirstVisibleRowToScrollPosition:function(e,t,o){if(o&&o.isCancelled()){return Promise.resolve()}t=t===true;const l=c(e).oVerticalScrollPosition;const r=l.getOffsetType()===S.OffsetType.PercentageOfViewport;const i=l.getIndex();const n=e.getFirstVisibleRow();const s=m.isIndexInBuffer(e,i);const a=s||r;p("VerticalScrollingHelper.adjustFirstVisibleRowToScrollPosition:"+' Set "firstVisibleRow" from '+n+" to "+i,e);const f=e._setFirstVisibleRowIndex(i,{onScroll:true,suppressEvent:a,suppressRendering:t});if(!f){if(a){return m.fixTemporaryFirstVisibleRow(e,true,o)}return Promise.resolve()}return new Promise(function(t){const l=function(l){p("VerticalScrollingHelper.adjustFirstVisibleRowToScrollPosition (async: rows updated):"+" Reason "+l.getParameters().reason,this);if(a){m.fixTemporaryFirstVisibleRow(e,true,o).then(t)}else{t()}return false};m.addOnRowsUpdatedPreprocessor(e,l);if(o){o.addCancelListener(function(){const o=m.removeOnRowsUpdatedPreprocessor(e,l);if(o){t()}})}})},fixTemporaryFirstVisibleRow:function(e,t,o){if(o&&o.isCancelled()){return Promise.resolve()}t=t===true;const l=c(e).oVerticalScrollPosition;const r=l.getOffsetType()===S.OffsetType.PercentageOfViewport;const i=l.getIndex();const n=m.isIndexInBuffer(e,i);const s=n||r;if(!s){p("VerticalScrollingHelper.fixTemporaryFirstVisibleRow: Aborted - The index is already final",e);return Promise.resolve()}let a=i;const f=m.getScrollRangeOfViewport(e);const d=e._getMaxFirstRenderedRowIndex();const u=e._aRowHeights;let g;p("VerticalScrollingHelper.fixTemporaryFirstVisibleRow",e);if(r){let e=f*l.getOffset();if(n){a=d}for(g=0;g<u.length;g++){const t=e-u[g];if(t>=0){e=t;a++}else{break}}}else if(n){const e=Math.max(0,Math.min(u.length-1,i-d));let t=0;for(g=0;g<e;g++){t+=u[g];if(t>f){a=d+g;break}}}if(i!==a||t){p('VerticalScrollingHelper.fixTemporaryFirstVisibleRow: Set "firstVisibleRow" to '+a,e);e._setFirstVisibleRowIndex(a,{onScroll:true,forceEvent:t,suppressRendering:true})}return Promise.resolve()},adjustScrollPositionToFirstVisibleRow:function(e,t){if(t&&t.isCancelled()){return Promise.resolve()}p("VerticalScrollingHelper.adjustScrollPositionToFirstVisibleRow",e);c(e).oVerticalScrollPosition.setPosition(e.getFirstVisibleRow());return Promise.resolve()},adjustScrollPositionToScrollbar:function(e,o){if(o&&o.isCancelled()){return Promise.resolve()}const l=c(e).oVerticalScrollPosition;const r=m.getScrollPositionOfScrollbar(e);const i=m.getScrollRange(e);const n=m.getScrollRangeRowFraction(e);let s=0;let a=0;let f=S.OffsetType.Percentage;let d;p("VerticalScrollingHelper.adjustScrollPositionToScrollbar",e);if(t.isVariableRowHeightEnabled(e)){if(m.isScrollPositionOfScrollbarInBuffer(e)){const t=m.getScrollRangeBuffer(e);const o=i-t;const n=r-o;const c=n/t;s=e._getMaxFirstRenderedRowIndex();if(m.isIndexInBuffer(e,l.getIndex())){const t=m.getScrollRangeOfViewport(e);let o=t*c;const l=e._aRowHeights;for(let e=0;e<l.length;e++){const t=o-l[e];if(t>=0){o=t;s++}else{a=Math.round(o);f=S.OffsetType.Pixel;break}}}else{a=c;f=S.OffsetType.PercentageOfViewport}}else{d=r/n;s=Math.floor(d);a=d-s}}else{const t=i-r;const o=t<1;if(o){s=e._getMaxFirstVisibleRowIndex();a=0;f=S.OffsetType.Pixel}else{d=r/n;s=Math.floor(d);a=d-s}}l.setPosition(s,a,f);return Promise.resolve()},adjustScrollPositionToViewport:function(e,t){if(t&&t.isCancelled()){return Promise.resolve()}const o=c(e).oVerticalScrollPosition;const l=e._aRowHeights;let r=e._getFirstRenderedRowIndex();let i=0;let n=m.getScrollPositionOfViewport(e);p("VerticalScrollingHelper.adjustScrollPositionToViewport",e);for(let e=0;e<l.length;e++){const t=n-l[e];if(t>=0){n=t;r++}else{i=Math.round(n);break}}o.setPosition(r,i);return Promise.resolve()},fixScrollPosition:function(e,o){if(o&&o.isCancelled()){return Promise.resolve()}const l=c(e).oVerticalScrollPosition;const r=e.getDomRef("tableCCnt");const i=m.getScrollRangeOfViewport(e);const n=e._aRowHeights;if(!r||!e.getBinding()){p("VerticalScrollingHelper.fixScrollPosition: Aborted - Viewport or binding not available",e);return Promise.resolve()}p("VerticalScrollingHelper.fixScrollPosition",e);let s=l.getIndex();let a=l.getOffset();let f=0;let d;const u=e._getFirstRenderedRowIndex();switch(l.getOffsetType()){case S.OffsetType.Pixel:case S.OffsetType.Percentage:{const o=l.getIndex();let r=0;let c=l.getOffsetType();if(m.isIndexInBuffer(e,o)){let e=0;f=Math.max(0,Math.min(n.length-1,o-u));for(d=0;d<f;d++){e+=n[d];if(e>i){s=u+d;a=i-r;c=S.OffsetType.Pixel;f=d;break}else{r=e}}}if(c===S.OffsetType.Pixel){a=Math.min(a,n[f])}else{a=n[f]*a}r+=a;if(r>i&&t.isVariableRowHeightEnabled(e)){a-=r-i}break}case S.OffsetType.PercentageOfViewport:{let e=i*l.getOffset();for(d=0;d<n.length;d++){const t=e-n[d];if(t>=0){e=t;f++}else{s=u+f;a=Math.round(e);break}}break}default:}l.setPosition(s,a);return Promise.resolve()},scrollViewport:function(e,o){if(o&&o.isCancelled()){return Promise.resolve()}if(!t.isVariableRowHeightEnabled(e)){p("VerticalScrollingHelper.scrollViewport: Aborted - Variable row height not enabled",e);return Promise.resolve()}const l=c(e).oVerticalScrollPosition;const r=e.getDomRef("tableCCnt");const i=m.getScrollRangeOfViewport(e);const n=e._aRowHeights;let s=0;if(i===0){p("VerticalScrollingHelper.scrollViewport: Aborted - No overflow in viewport",e);r.scrollTop=s;r._scrollTop=r.scrollTop;return Promise.resolve()}p("VerticalScrollingHelper.scrollViewport",e);switch(l.getOffsetType()){case S.OffsetType.Pixel:{const t=l.getIndex();const o=Math.max(0,Math.min(n.length-1,t-e._getFirstRenderedRowIndex()));for(let e=0;e<o;e++){s+=n[e]}s+=l.getOffset();break}default:p("VerticalScrollingHelper.scrollViewport: The viewport can only be scrolled if the offset is in pixel",e);return Promise.resolve()}p("VerticalScrollingHelper.scrollViewport: Scroll from "+r.scrollTop+" to "+s,e);r.scrollTop=s;r._scrollTop=r.scrollTop;return Promise.resolve()},scrollScrollbar:function(e,t){if(t&&t.isCancelled()){return Promise.resolve()}const o=c(e).oVerticalScrollPosition;const l=o.getIndex();const r=m.getScrollRangeBuffer(e);const i=m.getScrollRange(e);const n=i-r;let s=0;let a=0;const f=m.getScrollRangeOfViewport(e);const u=e._aRowHeights;let g;p("VerticalScrollingHelper.scrollScrollbar",e);if(i===0||u.length===0){p("VerticalScrollingHelper.scrollScrollbar: No scrollable content",e);return Promise.resolve()}switch(o.getOffsetType()){case S.OffsetType.Pixel:if(m.isIndexInBuffer(e,l)){let t=0;g=Math.max(0,Math.min(u.length-1,l-e._getMaxFirstRenderedRowIndex()));for(let e=0;e<g;e++){t+=u[e]}t+=Math.min(u[g],o.getOffset());const i=Math.min(t/f,1);const c=r*i;s=n+c}else{const t=m.getScrollRangeRowFraction(e);s=l*t;g=Math.max(0,Math.min(u.length-1,l-e._getFirstRenderedRowIndex()));s+=t*Math.min(o.getOffset()/u[g],1)}break;default:p("VerticalScrollingHelper.scrollViewport: The scrollbar can only be scrolled if the offset is in pixel",e);return Promise.resolve()}if(s>0&&s<.5){a=1}else if(s>=i-.5&&s<i){a=i-1}else{a=Math.round(s)}const h=e._getScrollExtension().getVerticalScrollbar();if(h){p("VerticalScrollingHelper.scrollScrollbar: Scroll from "+h.scrollTop+" to "+a,e);const t=a>h.scrollTop;let o=false;h.scrollTop=a;h._scrollTop=h.scrollTop;if(t){o=Math.round(h.scrollTop)===h.scrollHeight-h.offsetHeight}else{o=h.scrollTop===0}if(o&&!h._unblockScrolling){if(!h._timeoutBlock){h._timeoutBlock=setTimeout(function(){h._unblockScrolling=true;h._timeoutBlock=null},d)}}else{h._unblockScrolling=false}}else{p("VerticalScrollingHelper.scrollScrollbar: Not scrolled - No scrollbar available",e)}return Promise.resolve()},getScrollRange:function(e){const t=e._getScrollExtension();const o=t.getVerticalScrollHeight()-t.getVerticalScrollbarHeight();return Math.max(0,o)},getScrollRangeBuffer:function(e){if(!t.isVariableRowHeightEnabled(e)){return 0}return f*e._getBaseRowHeight()},getScrollPositionOfScrollbar:function(e){const t=e._getScrollExtension();if(t.isVerticalScrollbarVisible()){return t.getVerticalScrollbar().scrollTop}else{return 0}},getScrollPositionOfViewport:function(e){const t=e?e.getDomRef("tableCCnt"):null;return t?t.scrollTop:0},getScrollRangeRowFraction:function(e){const o=e._getScrollExtension();const l=e._getTotalRowCount()-e._getRowCounts()._fullsize;let r;if(t.isVariableRowHeightEnabled(e)){r=m.getScrollRange(e)-m.getScrollRangeBuffer(e);const t=o.getVerticalScrollHeight()===a;if(!t){r+=e._getBaseRowHeight()}}else{r=m.getScrollRange(e)}return r/Math.max(1,l)},isScrollPositionOfScrollbarInBuffer:function(e){if(!t.isVariableRowHeightEnabled(e)){return false}const o=m.getScrollRange(e);const l=m.getScrollPositionOfScrollbar(e);const r=m.getScrollRangeBuffer(e);return o-l<=r},isIndexInBuffer:function(e,o){if(!t.isVariableRowHeightEnabled(e)){return false}return o>=e._getMaxFirstRenderedRowIndex()},getScrollRangeOfViewport:function(e){if(!e||!e._aRowHeights){return 0}let t=e._aRowHeights;const o=e._getBaseRowHeight()*e._getRowCounts()._fullsize;if(e._getRowCounts()._fullsize>=e._getTotalRowCount()){t=t.slice(0,e._getTotalRowCount())}let l=t.reduce(function(e,t){return e+t},0)-o;if(l>0){l=Math.ceil(l)}return Math.max(0,l)},addOnRowsUpdatedPreprocessor:function(e,t){c(e).aOnRowsUpdatedPreprocessors.push(t)},removeOnRowsUpdatedPreprocessor:function(e,t){if(!t){c(e).aOnRowsUpdatedPreprocessors=[];return false}const o=c(e).aOnRowsUpdatedPreprocessors.indexOf(t);if(o>-1){c(e).aOnRowsUpdatedPreprocessors.splice(o,1);return true}return false},onRowsUpdated:function(e){p("VerticalScrollingHelper.onRowsUpdated: Reason "+e.getParameters().reason,this);m.updateScrollbarVisibility(this);if(c(this).aOnRowsUpdatedPreprocessors.length>0){p("VerticalScrollingHelper.onRowsUpdated (preprocessors)",this);const t=c(this).aOnRowsUpdatedPreprocessors.reduce(function(t,o){const l=o.call(this,e);return!(t&&!l)},true);m.removeOnRowsUpdatedPreprocessor(this);if(!t){p("VerticalScrollingHelper.onRowsUpdated (preprocessors): Default prevented",this);return}}if(!t.isVariableRowHeightEnabled(this)){p("VerticalScrollingHelper.onRowsUpdated: Aborted - Variable row heights not enabled",this);return}const o=this;h.start(this,h.OnRowsUpdated,function(e,l,r){t.Hook.call(o,s.Signal,"StartTableUpdate");r.onPromiseCreated=function(e){e.finally(function(){t.Hook.call(o,s.Signal,"EndTableUpdate")})};m.fixScrollPosition(o,r).then(function(){return Promise.all([m.adjustFirstVisibleRowToScrollPosition(o,true,r),m.scrollViewport(o,r),m.scrollScrollbar(o,r)])}).then(e)})},restoreScrollPosition:function(e,o){p("VerticalScrollingHelper.restoreScrollPosition",e);h.start(e,h.RestoreScrollPosition,function(l,r,i){t.Hook.call(e,s.Signal,"StartTableUpdate");i.onPromiseCreated=function(o){o.then(function(){if(!i.isCancelled()){m._restoreScrollPosition(e)}}).finally(function(){t.Hook.call(e,s.Signal,"EndTableUpdate")})};if(o!==true){l();return}const n=function(){p("VerticalScrollingHelper.restoreScrollPosition (async: rows updated)",e);l();return false};m.addOnRowsUpdatedPreprocessor(e,n);i.addCancelListener(function(){const t=m.removeOnRowsUpdatedPreprocessor(e,n);if(t){l()}})})},_restoreScrollPosition:function(e){const t=c(e).oVerticalScrollPosition;const o=t.isInitial();p("VerticalScrollingHelper.restoreScrollPosition: "+"Scroll position is"+(o?" ":" not ")+"initial",e);if(o){m.performUpdateFromFirstVisibleRow(e)}else{m.performUpdateFromScrollPosition(e)}},onTotalRowCountChanged:function(){m.adjustToTotalRowCount(this)},adjustToTotalRowCount:function(e){const o=e._getScrollExtension();p("VerticalScrollingHelper.adjustToTotalRowCount",e);m.updateScrollbarVisibility(e);b.updateScrollbar(e);o.updateVerticalScrollHeight();h.start(e,h.AdjustToTotalRowCount,function(o,l,r){t.Hook.call(e,s.Signal,"StartTableUpdate");r.onPromiseCreated=function(o){o.then(function(){if(r.isCancelled()||c(e).oVerticalScrollPosition.isInitial()){return}m.performUpdateFromScrollPosition(e)}).finally(function(){t.Hook.call(e,s.Signal,"EndTableUpdate")})};if(c(e).oVerticalScrollPosition.isInitial()){o()}else{const t=function(){p("VerticalScrollingHelper.adjustToTotalRowCount (async: rows updated)",e);o();return false};m.addOnRowsUpdatedPreprocessor(e,t);r.addCancelListener(function(){const l=m.removeOnRowsUpdatedPreprocessor(e,t);if(l){o()}})}})},onUpdateTableSizes:function(e){b.updateScrollbar(this);m.updateScrollbarVisibility(this);m.updateScrollbarPosition(this)},updateScrollbarVisibility:function(e){const t=e._getScrollExtension();const o=t.getVerticalScrollbar();const l=e?e.getDomRef():null;if(!o||!l){return}const r=t.isVerticalScrollbarRequired();l.classList.toggle("sapUiTableVScr",r&&!t.isVerticalScrollbarExternal());o.parentElement.classList.toggle("sapUiTableHidden",!r)},updateScrollbarPosition:function(e){const t=e._getScrollExtension();const o=t.getVerticalScrollbar();if(!o){return}const l=t.getHorizontalScrollbar();const r=e._getRowCounts();let i=0;if(l&&c(e).bHorizontalScrollbarRequired&&t.isHorizontalScrollbarVisible()){i=l.offsetHeight}if(r.fixedBottom>0){i+=r.fixedBottom*e._getBaseRowHeight()}o.style.bottom=i+"px"},addEventListeners:function(e){const t=e._getScrollExtension();const o=m.getScrollAreas(e);const l=e.getDomRef("tableCCnt");if(!t._onVerticalScrollEventHandler){t._onVerticalScrollEventHandler=m.onScrollbarScroll.bind(e)}for(let e=0;e<o.length;e++){o[e].addEventListener("scroll",t._onVerticalScrollEventHandler)}if(l){if(!t._onViewportScrollEventHandler){t._onViewportScrollEventHandler=m.onViewportScroll.bind(e)}l.addEventListener("scroll",t._onViewportScrollEventHandler)}e.attachEvent("_rowsUpdated",m.onRowsUpdated)},removeEventListeners:function(e){const t=e._getScrollExtension();const o=m.getScrollAreas(e);const l=e.getDomRef("tableCCnt");if(t._onVerticalScrollEventHandler){for(let e=0;e<o.length;e++){o[e].removeEventListener("scroll",t._onVerticalScrollEventHandler)}delete t._onVerticalScrollEventHandler}if(l&&t._onViewportScrollEventHandler){l.removeEventListener("scroll",t._onViewportScrollEventHandler);delete t._onViewportScrollEventHandler}e.detachEvent("_rowsUpdated",m.onRowsUpdated)},getScrollAreas:function(e){const t=[e._getScrollExtension().getVerticalScrollbar()];return t.filter(function(e){return e!=null})}};const T={onMouseWheelScrolling:function(e,o){const l=this._getScrollExtension();const r=Math.abs(o.deltaY)>Math.abs(o.deltaX);let i=r?o.deltaY:o.deltaX;const n=r&&o.shiftKey||!r;const s=i>0;let a=false;if(i===0){return}if(n&&(e.scrollDirection===u.HORIZONAL||e.scrollDirection===u.BOTH)){const e=l.getHorizontalScrollbar();if(o.deltaMode!==window.WheelEvent.DOM_DELTA_PIXEL){const e=t.Column.getMinColumnWidth();i=s?e:-e}if(s){a=e.scrollLeft===e.scrollWidth-e.offsetWidth}else{a=e.scrollLeft===0}if(l.isHorizontalScrollbarVisible()&&!a){o.preventDefault();o.stopPropagation();this._getKeyboardExtension().setActionMode(false);e.scrollLeft=e.scrollLeft+i}}else if(!n&&(e.scrollDirection===u.VERTICAL||e.scrollDirection===u.BOTH)){if(o.target instanceof window.HTMLTextAreaElement){const e=o.target;if(e.clientHeight<e.scrollHeight){return}}const e=l.getVerticalScrollbar();const t=c(this).oVerticalScrollPosition;if(s){a=Math.round(e.scrollTop)===e.scrollHeight-e.clientHeight}else{a=e.scrollTop===0}if(!l.isVerticalScrollbarVisible()||a&&e._unblockScrolling){return}o.preventDefault();o.stopPropagation();if(o.deltaMode===window.WheelEvent.DOM_DELTA_PIXEL){const e=i/this._getDefaultRowHeight();if(e>=0){t.scrollRows(Math.max(1,Math.floor(e)))}else{t.scrollRows(Math.min(-1,Math.ceil(e)))}}else if(o.deltaMode===window.WheelEvent.DOM_DELTA_LINE){t.scrollRows(i)}else if(o.deltaMode===window.WheelEvent.DOM_DELTA_PAGE){t.scrollRows(i*this._getRowCounts()._scrollSize)}this._getKeyboardExtension().setActionMode(false);m.performUpdateFromScrollPosition(this)}},onTouchStart:function(e,t){if(t.type==="touchstart"||t.pointerType==="touch"){const e=this._getScrollExtension();const o=e.getHorizontalScrollbar();const l=e.getVerticalScrollbar();const r=t.touches?t.touches[0]:t;c(this).mTouchSessionData={initialPageX:r.pageX,initialPageY:r.pageY,initialScrollTop:l?l.scrollTop:0,initialScrollLeft:o?o.scrollLeft:0,initialScrolledToEnd:null,touchMoveDirection:null}}},onTouchMoveScrolling:function(e,t){if(t.type!=="touchmove"&&t.pointerType!=="touch"){return}const o=this._getScrollExtension();const l=c(this).mTouchSessionData;if(!l){return}const r=t.touches?t.touches[0]:t;const i=r.pageX-l.initialPageX;const n=r.pageY-l.initialPageY;let s=false;if(!l.touchMoveDirection){if(i===0&&n===0){return}l.touchMoveDirection=Math.abs(i)>Math.abs(n)?"horizontal":"vertical"}switch(l.touchMoveDirection){case"horizontal":{const t=o.getHorizontalScrollbar();if(t&&(e.scrollDirection===u.HORIZONAL||e.scrollDirection===u.BOTH)){this._getKeyboardExtension().setActionMode(false);if(l.initialScrolledToEnd==null){if(i<0){l.initialScrolledToEnd=t.scrollLeft===t.scrollWidth-t.offsetWidth}else{l.initialScrolledToEnd=t.scrollLeft===0}}if(!l.initialScrolledToEnd){t.scrollLeft=l.initialScrollLeft-i;s=true}}break}case"vertical":{const t=o.getVerticalScrollbar();if(t&&(e.scrollDirection===u.VERTICAL||e.scrollDirection===u.BOTH)){this._getKeyboardExtension().setActionMode(false);if(l.initialScrolledToEnd==null){if(n<0){l.initialScrolledToEnd=t.scrollTop===t.scrollHeight-t.clientHeight}else{l.initialScrolledToEnd=t.scrollTop===0}}if(!l.initialScrolledToEnd){t.scrollTop=l.initialScrollTop-n;s=true}}break}default:}if(s){t.preventDefault()}},addEventListeners:function(e){const t=e._getScrollExtension();const o=T.getEventListenerTargets(e);t._mMouseWheelEventListener=this.addMouseWheelEventListener(o,e,{scrollDirection:u.BOTH});t._mTouchEventListener=this.addTouchEventListener(o,e,{scrollDirection:u.BOTH})},addMouseWheelEventListener:function(e,t,o){const l=T.onMouseWheelScrolling.bind(t,o);for(let t=0;t<e.length;t++){e[t].addEventListener("wheel",l)}return{wheel:l}},addTouchEventListener:function(e,t,o){const r=T.onTouchStart.bind(t,o);const i=T.onTouchMoveScrolling.bind(t,o);let n={};for(let t=0;t<e.length;t++){if(l.support.pointer&&l.system.desktop){e[t].addEventListener("pointerdown",r);e[t].addEventListener("pointermove",i,l.browser.chrome?{passive:true}:false)}else if(l.support.touch){e[t].addEventListener("touchstart",r);e[t].addEventListener("touchmove",i)}}if(l.support.pointer&&l.system.desktop){n={pointerdown:r,pointermove:i}}else if(l.support.touch){n={touchstart:r,touchmove:i}}return n},removeEventListeners:function(e){const t=e._getScrollExtension();const o=T.getEventListenerTargets(e);function l(e,t){for(const o in t){const l=t[o];if(l){e.removeEventListener(o,l)}}}for(let e=0;e<o.length;e++){l(o[e],t._mMouseWheelEventListener);l(o[e],t._mTouchEventListener)}delete t._mMouseWheelEventListener;delete t._mTouchEventListener},getEventListenerTargets:function(e){const t=[e.getDomRef("tableCCnt")];return t.filter(function(e){return e!=null})}};const w={onBeforeRendering:function(e){this._getScrollExtension()._clearCache()},onAfterRendering:function(e){const t=this._getScrollExtension();const o=e!=null&&e.isMarked("renderRows");if(o){t.updateVerticalScrollbarHeight();t.updateVerticalScrollHeight()}m.restoreScrollPosition(this,this.getBinding()!=null);b.restoreScrollPosition(this)},onfocusin:function(e){let o;const r=t.getCellInfo(e.target);const i=this._getScrollExtension().getHorizontalScrollbar();if(r.isOfType(t.CELLTYPE.DATACELL)){o=this.getDomRef("sapUiTableCtrlScr")}else if(r.isOfType(t.CELLTYPE.COLUMNHEADER)){o=this.getDomRef("sapUiTableColHdrScr")}if(o&&i&&r.columnIndex>=this.getComputedFixedColumnCount()){const e=jQuery(i);const t=r.cell;const l=this._bRtlMode?e.scrollLeftRTL():i.scrollLeft;const n=o.clientWidth;const s=t.offsetLeft;const c=s+t.offsetWidth;const a=s-l;const f=c-n-l;let d;if(a<0&&f<0){d=l+a}else if(f>0&&a>0){d=l+f}if(d!=null){if(this._bRtlMode){e.scrollLeftRTL(d)}else{i.scrollLeft=d}}}const n=t.getParentCell(this,e.target);if(n){const e=this;const o=function(){const o=n.find(".sapUiTableCellInner");if(o.length>0){if(e._bRtlMode){o.scrollLeftRTL(o[0].scrollWidth-o[0].clientWidth)}else{o[0].scrollLeft=0}o[0].scrollTop=0}t.Hook.call(e,s.Signal,"EndFocusHandling");t.Hook.call(e,s.Signal,"EndTableUpdate")};t.Hook.call(this,s.Signal,"StartTableUpdate");t.Hook.call(this,s.Signal,"StartFocusHandling");Promise.resolve().then(function(){if(l.browser.safari){window.setTimeout(o,0)}else{o()}})}}};const V=e.extend("sap.ui.table.extensions.Scrolling",{_init:function(e,o,l){const r=c(e);r.oHorizontalScrollbar=null;r.iHorizontalScrollPosition=null;r.oVerticalScrollbar=null;r.oVerticalScrollPosition=new S(e);r.pVerticalScrollUpdateProcess=null;r.oExternalVerticalScrollbar=null;r.bIsVerticalScrollbarExternal=false;r.mTimeouts={};r.mAnimationFrames={};r.mTouchSessionData=null;r.aOnRowsUpdatedPreprocessors=[];t.addDelegate(e,w,e);return"ScrollExtension"},_attachEvents:function(){const e=this.getTable();b.addEventListeners(e);m.addEventListeners(e);T.addEventListeners(e);t.Hook.register(e,t.Hook.Keys.Table.TotalRowCountChanged,m.onTotalRowCountChanged,e);t.Hook.register(e,t.Hook.Keys.Table.UpdateSizes,m.onUpdateTableSizes,e)},_detachEvents:function(){const e=this.getTable();b.removeEventListeners(e);m.removeEventListeners(e);T.removeEventListeners(e);t.Hook.deregister(e,t.Hook.Keys.Table.TotalRowCountChanged,m.onTotalRowCountChanged,e);t.Hook.deregister(e,t.Hook.Keys.Table.UpdateSizes,m.onUpdateTableSizes,e)},destroy:function(){const o=this.getTable();this._clearCache();if(o){t.removeDelegate(o,w);if(c(o).pVerticalScrollUpdateProcess){c(o).pVerticalScrollUpdateProcess.cancel();c(o).pVerticalScrollUpdateProcess=null}}e.prototype.destroy.apply(this,arguments)}});V.prototype.scrollVertically=function(e,t){const o=this.getTable();if(!o){return}const l=o._getRowCounts();const r=o._getFirstRenderedRowIndex();const i=t===true?l.scrollable:1;if(e===true){c(o).oVerticalScrollPosition.setPosition(r+i,1,S.OffsetType.PercentageOfViewport)}else{c(o).oVerticalScrollPosition.setPosition(Math.max(0,r-i))}m.performUpdateFromScrollPosition(o)};V.prototype.scrollVerticallyMax=function(e){const t=this.getTable();if(!t){return}if(e===true){c(t).oVerticalScrollPosition.setPosition(t._getMaxFirstRenderedRowIndex(),1,S.OffsetType.PercentageOfViewport)}else{c(t).oVerticalScrollPosition.setPosition(0)}m.performUpdateFromScrollPosition(t)};V.prototype.getHorizontalScrollbar=function(){const e=this.getTable();if(!e){return null}if(!e._bInvalid&&!c(e).oHorizontalScrollbar){c(e).oHorizontalScrollbar=e.getDomRef(n.HorizontalScrollBar)}return c(e).oHorizontalScrollbar};V.prototype.getVerticalScrollbar=function(){const e=this.getTable();const t=this.isVerticalScrollbarExternal();if(!e){return null}if(!e._bInvalid&&!c(e).oVerticalScrollbar){c(e).oVerticalScrollbar=e.getDomRef(n.VerticalScrollBar);if(!c(e).oVerticalScrollbar&&t){c(e).oVerticalScrollbar=c(e).oExternalVerticalScrollbar}}const o=c(e).oVerticalScrollbar;if(o&&!t&&!o.isConnected){return null}return o};V.prototype.isHorizontalScrollbarVisible=function(){const e=this.getHorizontalScrollbar();return e!=null&&!e.classList.contains("sapUiTableHidden")};V.prototype.isVerticalScrollbarVisible=function(){const e=this.getVerticalScrollbar();return e!=null&&!e.parentElement.classList.contains("sapUiTableHidden")};V.prototype.isVerticalScrollbarExternal=function(){const e=this.getTable();return e?c(e).bIsVerticalScrollbarExternal:false};V.prototype.markVerticalScrollbarAsExternal=function(e){const t=this.getTable();if(t&&e){c(t).bIsVerticalScrollbarExternal=true;c(t).oExternalVerticalScrollbar=e}};V.prototype.updateVerticalScrollbarHeight=function(){const e=this.getTable();const t=this.getVerticalScrollbar();if(!e||!t){return}t.style.maxHeight=this.getVerticalScrollbarHeight()+"px";t._scrollTop=t.scrollTop};V.prototype.getVerticalScrollbarHeight=function(){const e=this.getTable();if(!e){return 0}return e._getRowCounts()._scrollSize*e._getBaseRowHeight()};V.prototype.updateVerticalScrollPosition=function(e){const t=this.getTable();if(!t){return}e=e===true;if(e||t.getBinding()){m.performUpdateFromFirstVisibleRow(t,e)}else{m.adjustScrollPositionToFirstVisibleRow(t)}};V.prototype.restoreVerticalScrollPosition=function(){m.restoreScrollPosition(this.getTable())};V.prototype.updateVerticalScrollHeight=function(){const e=this.getVerticalScrollbar();const t=e?e.firstChild:null;if(!t){return}t.style.height=this.getVerticalScrollHeight()+"px";e._scrollTop=e.scrollTop};V.prototype.getVerticalScrollHeight=function(e){const o=this.getTable();if(!o){return 0}const l=o._getTotalRowCount();const r=o._getRowCounts();const i=Math.max(l,r.count);const n=o._getBaseRowHeight();let s;if(t.isVariableRowHeightEnabled(o)){s=n*(i-1)+m.getScrollRangeBuffer(o)}else{s=n*i}if(e===true){return s}else{return Math.min(a,s)}};V.prototype.isVerticalScrollbarRequired=function(){const e=this.getTable();if(!e){return false}return t.isVariableRowHeightEnabled(e)&&m.getScrollRangeOfViewport(e)>0||e._getTotalRowCount()>e._getRowCounts()._fullsize};V.prototype.registerForMouseWheel=function(t,o){const l=this.getTable();if(e.isEnrichedWith(l,"sap.ui.table.extensions.Synchronization")){return T.addMouseWheelEventListener(t,l,o)}else{i.error("This method can only be used with synchronization enabled.",l,"sap.ui.table.extensions.Scrolling#registerForMouseWheel");return null}};V.prototype.registerForTouch=function(t,o){const l=this.getTable();if(e.isEnrichedWith(l,"sap.ui.table.extensions.Synchronization")){return T.addTouchEventListener(t,l,o)}else{i.error("This method can only be used with synchronization enabled.",l,"sap.ui.table.extensions.Scrolling#registerForTouch");return null}};V.prototype._clearCache=function(){const e=this.getTable();if(!e){return}c(e).oVerticalScrollbar=null;c(e).oHorizontalScrollbar=null};V.ScrollDirection=u;return V});
//# sourceMappingURL=Scrolling.js.map