/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["./ContextMenu","../library","../utils/TableUtils","sap/ui/core/library","sap/ui/unified/Menu","sap/ui/unified/MenuItem"],function(e,t,o,s,n,i){"use strict";const u=s.SortOrder;const r=t.GroupEventType;const l=["ungroup","collapse","expand"];const p=e.extend("sap.ui.table.menus.AnalyticalTableContextMenu",{metadata:{library:"sap.ui.table"}});p.prototype.init=function(){n.prototype.init.apply(this,arguments);this._mItems=new Map};p.prototype.initContent=function(t,s){e.prototype.initContent.apply(this,arguments);const n=this.getMenu();const i=this.getTable();const u=!!i.getProperty("extendedGroupHeaderMenu");if(!t.isGroupHeader()){this._mItems.values().forEach(e=>e.setVisible(false));return}this._iGroupLevel=t.getLevel();if(this._mItems.size===0){this._createItems(i)}for(const[e,t]of this._mItems.entries()){t.setVisible(l.includes(e)?true:u);if(!n.getItems().includes(t)){n.addItem(t)}}if(!u){return}const r=c(i,this._iGroupLevel);const[p,a]=this._mItems.get("move").getSubmenu().getItems();const m=this._mItems.get("visibility");if(r){if(r.getShowIfGrouped()){m.setText(o.getResourceText("TBL_HIDE_COLUMN"))}else{m.setText(o.getResourceText("TBL_SHOW_COLUMN"))}p.setEnabled(this._iGroupLevel>1);a.setEnabled(this._iGroupLevel<i._aGroupedColumns.length)}else{p.setEnabled(true);a.setEnabled(true)}};p.prototype._createItems=function(e){this._mItems.set("ungroup",this._createUngroupItem(e));this._mItems.set("collapse",this._createCollapseItem(e));this._mItems.set("expand",this._createExpandItem(e));this._mItems.set("visibility",this._createVisibilityItem(e));this._mItems.set("move",this._createMoveItem(e));this._mItems.set("sort",this._createSortItem(e))};p.prototype._createUngroupItem=function(e){return new i({text:o.getResourceText("TBL_UNGROUP"),submenu:new n({items:[new i({text:o.getResourceText("TBL_UNGROUP_LEVEL"),select:()=>{const t=c(e,this._iGroupLevel);t.setGrouped(false);e.fireGroup({column:t,groupedColumns:e._aGroupedColumns,type:r.ungroup})}}),new i({text:o.getResourceText("TBL_UNGROUP_ALL"),select:()=>{e.suspendUpdateAnalyticalInfo();for(const t of e.getColumns()){t.setGrouped(false)}e.resumeUpdateAnalyticalInfo();e.fireGroup({column:undefined,groupedColumns:[],type:r.ungroupAll})}})]})})};p.prototype._createCollapseItem=function(e){return new i({text:o.getResourceText("TBL_COLLAPSE"),icon:"sap-icon://collapse-all",submenu:new n({items:[new i({text:o.getResourceText("TBL_COLLAPSE_LEVEL"),select:()=>{e.getBinding().collapseToLevel(this._iGroupLevel-1);e.setFirstVisibleRow(0);e._getSelectionPlugin().clearSelection()}}),new i({text:o.getResourceText("TBL_COLLAPSE_ALL"),select:()=>{e.getBinding().collapseToLevel(0);e.setFirstVisibleRow(0);e._getSelectionPlugin().clearSelection()}})]})})};p.prototype._createExpandItem=function(e){return new i({text:o.getResourceText("TBL_EXPAND"),icon:"sap-icon://expand-all",submenu:new n({items:[new i({text:o.getResourceText("TBL_EXPAND_LEVEL"),select:()=>{e.getBinding().expandToLevel(this._iGroupLevel);e.setFirstVisibleRow(0);e._getSelectionPlugin().clearSelection()}}),new i({text:o.getResourceText("TBL_EXPAND_ALL"),select:()=>{e.expandAll()}})]})})};p.prototype._createVisibilityItem=function(e){return new i({text:o.getResourceText("TBL_SHOW_COLUMN"),select:()=>{const t=c(e,this._iGroupLevel);const o=t.getShowIfGrouped();t.setShowIfGrouped(!o);e.fireGroup({column:t,groupedColumns:e._aGroupedColumns,type:!o?r.showGroupedColumn:r.hideGroupedColumn})}})};p.prototype._createMoveItem=function(e){return new i({text:o.getResourceText("TBL_MOVE"),submenu:new n({items:[new i({text:o.getResourceText("TBL_MOVE_UP"),icon:"sap-icon://arrow-top",select:()=>{const t=c(e,this._iGroupLevel);const o=this._iGroupLevel-1;if(o>0){e._aGroupedColumns[o]=e._aGroupedColumns.splice(o-1,1,e._aGroupedColumns[o])[0];e.updateAnalyticalInfo();e.fireGroup({column:t,groupedColumns:e._aGroupedColumns,type:r.moveUp})}}}),new i({text:o.getResourceText("TBL_MOVE_DOWN"),icon:"sap-icon://arrow-bottom",select:()=>{const t=c(e,this._iGroupLevel);const o=this._iGroupLevel-1;if(o<e._aGroupedColumns.length){e._aGroupedColumns[o]=e._aGroupedColumns.splice(o+1,1,e._aGroupedColumns[o])[0];e.updateAnalyticalInfo();e.fireGroup({column:t,groupedColumns:e._aGroupedColumns,type:r.moveDown})}}})]})})};p.prototype._createSortItem=function(e){return new i({text:o.getResourceText("TBL_SORT"),icon:"sap-icon://sort",submenu:new n({items:[new i({text:o.getResourceText("TBL_SORT_ASC"),icon:"sap-icon://sort-ascending",select:()=>{e.sort(c(e,this._iGroupLevel),u.Ascending)}}),new i({text:o.getResourceText("TBL_SORT_DESC"),icon:"sap-icon://sort-descending",select:()=>{e.sort(c(e,this._iGroupLevel),u.Descending)}})]})})};function c(e,t){return e.getColumns().find(o=>e._aGroupedColumns[t-1]===o.getId())}return p});
//# sourceMappingURL=AnalyticalTableContextMenu.js.map